/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ManufactureStrategyGroup;
import com.kingdee.eas.mm.basedata.OrderBomSimulateFacadeFactory;
import com.kingdee.eas.mm.basedata.client.AbstractOrderBomSimulateFilterUI;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrderBomSimulateFilterUI
extends AbstractOrderBomSimulateFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderBomSimulateFilterUI.class);
    protected F7ContextManager f7ContextManager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 0);
    private DataChangeListener prmtStorageListener = null;
    private IUIWindow window = null;
    private Map queryInfo = null;
    private static final int CONFIRM_ACTION = 0;
    private static final int CANCEL_ACTION = 1;
    private static final int CLOSE_WINDOW_ACTION = 2;
    private int closeWindowType = 2;
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";
    private DataChangeListener materialListener = null;
    private DataChangeListener projectListener = null;
    private CommitListener materialCommitListener = null;
    private SelectorListener materialSelectorListener = null;
    private String manufactureStrategyID = "";
    private IsolatedRuleEnum isolateruleenum = null;
    private boolean istrack = false;

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected void addListeners() {
        if (this.prmtStorageListener == null) {
            this.prmtStorageListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        OrderBomSimulateFilterUI.this.storageChanged(e);
                    }
                    catch (ParseException e1) {
                        OrderBomSimulateFilterUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.prmtStorageListener);
        if (this.materialListener == null) {
            this.materialListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    OrderBomSimulateFilterUI.this.materialChanged(e);
                }
            };
        }
        this.prmtParentMaterial.addDataChangeListener(this.materialListener);
        if (this.materialCommitListener == null) {
            this.materialCommitListener = new CommitListener(){

                public void willCommit(CommitEvent paramCommitEvent) {
                    OrderBomSimulateFilterUI.this.setMaterialFilter();
                }
            };
        }
        if (this.materialSelectorListener == null) {
            this.materialSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    OrderBomSimulateFilterUI.this.setMaterialFilter();
                }
            };
        }
        this.prmtParentMaterial.addSelectorListener(this.materialSelectorListener);
        this.prmtParentMaterial.addCommitListener(this.materialCommitListener);
        if (this.projectListener == null) {
            this.projectListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        OrderBomSimulateFilterUI.this.projectNumberChanged(e);
                    }
                    catch (Exception e1) {
                        OrderBomSimulateFilterUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.prmtProjectNum.addDataChangeListener(this.projectListener);
    }

    protected void removeListener() {
        if (this.prmtStorageListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.prmtStorageListener);
        }
        if (this.materialListener != null) {
            this.prmtParentMaterial.removeDataChangeListener(this.materialListener);
        }
        if (this.materialCommitListener != null) {
            this.prmtParentMaterial.removeCommitListener(this.materialCommitListener);
        }
        if (this.materialSelectorListener != null) {
            this.prmtParentMaterial.removeSelectorListener(this.materialSelectorListener);
        }
        if (this.projectListener != null) {
            this.prmtProjectNum.removeDataChangeListener(this.projectListener);
        }
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        this.addListeners();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_orderbom_simulate");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_orderbom_simulate");
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        this.prmtParentMaterial.setRequired(true);
        this.prmtStorageOrgUnit.setRequired(true);
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.prmtStorageOrgUnit, null, (KDBizPromptBox)this.prmtProjectNum, (boolean)false);
        UIHelper.registerTrackNumberF7ForEdit((KDBizPromptBox)this.prmtStorageOrgUnit, null, (KDBizPromptBox)this.prmtProjectNum, (KDBizPromptBox)this.prmtTrackNum, (boolean)false);
        this.initF7Material(orgInfo);
    }

    private void setMaterialFilter() {
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        String orgId = null;
        if (orgInfo != null) {
            orgId = orgInfo.getId().toString();
        }
        EntityViewInfo entityViewInfo = this.prmtParentMaterial.getEntityViewInfo();
        FilterInfo filterInfo = entityViewInfo.getFilter();
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.isConfigable", (Object)new Boolean(true), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        this.prmtParentMaterial.setEntityViewInfo(entityViewInfo);
    }

    private boolean verifyDataInfo() throws EASBizException, BOSException {
        BomInfo temp;
        if (this.prmtProjectNum.getValue() == null && this.prmtTrackNum.getValue() == null) {
            return false;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)(temp = new BomInfo()), ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString());
        if (!ruleStatus.isExist()) {
            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{"BOM"});
        }
        return true;
    }

    private void storageChanged(DataChangeEvent e) throws ParseException {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent) {
            if (e.getNewValue() != null) {
                this.prmtProjectNum.setValue(null);
                this.prmtTrackNum.setValue(null);
                this.prmtParentMaterial.setValue(null);
                this.initF7Material((StorageOrgUnitInfo)e.getNewValue());
            } else {
                this.prmtStorageOrgUnit.setValue(e.getOldValue());
                this.setMaterialFilter();
            }
        }
    }

    private void initF7Material(StorageOrgUnitInfo orgInfo) {
        String orgId = null;
        if (orgInfo != null) {
            orgId = orgInfo.getId().toString();
        }
        String materialPlanQuery = BOMUIHelper.getMaterialPlanForBOMQuery(this.f7ContextManager.getF7DisplayMode());
        this.f7ContextManager.registerBizMaterialF7(this.prmtParentMaterial, null, materialPlanQuery, (OrgUnitInfo)orgInfo, false);
        EntityViewInfo entityViewInfo = this.prmtParentMaterial.getEntityViewInfo();
        FilterInfo filterInfo = entityViewInfo.getFilter();
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.isConfigable", (Object)new Boolean(true), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        this.prmtParentMaterial.setEntityViewInfo(entityViewInfo);
    }

    private Set getStrategyl() {
        HashSet<String> set = new HashSet<String>();
        set.add("fpPxtypCS/ihJ30GjB/UJtg0uEU=");
        set.add("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=");
        set.add("qAYbemEdG9ngQKjAYj0V1dg0uEU=");
        set.add("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
        return set;
    }

    private void materialChanged(DataChangeEvent e) {
        MaterialInfo material;
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent && e.getNewValue() != null && (material = (MaterialInfo)e.getNewValue()) != null) {
            try {
                String id;
                StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                MaterialInfo[] materialInfos = new MaterialInfo[]{material};
                StorageOrgUnitInfo org = (StorageOrgUnitInfo)this.getMainBizOrg().getData();
                if (null == storageOrgInfo || null == org) {
                    return;
                }
                SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)org, (MaterialInfo[])materialInfos);
                material = voResult.getMaterialInfos()[0];
                String key = material.getId().toString() + org.getId().toString();
                MaterialPlanInfo materialPlan = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key);
                this.manufactureStrategyID = id = materialPlan.getManufactureStrategy().getId().toString();
                if (id != null && !StringUtils.isEmpty((String)id)) {
                    if (this.getStrategyl().contains(id)) {
                        this.prmtProjectNum.setValue(null);
                        this.prmtProjectNum.setEditable(false);
                        this.prmtProjectNum.setEnabled(false);
                        this.prmtProjectNum.setRequired(false);
                        this.prmtTrackNum.setEditable(true);
                        this.prmtTrackNum.setEnabled(true);
                        this.prmtTrackNum.setRequired(true);
                    } else if (ManufactureStrategyGroup.getProjectTrackOrderBomStrategyIdSet().contains(id)) {
                        this.prmtProjectNum.setEditable(true);
                        this.prmtProjectNum.setEnabled(true);
                        this.prmtProjectNum.setRequired(true);
                        this.prmtTrackNum.setEditable(true);
                        this.prmtTrackNum.setEnabled(true);
                        if (materialPlan.getIsolatedRule().equals((Object)IsolatedRuleEnum.ITEM_TRACKNO)) {
                            this.prmtTrackNum.setRequired(true);
                            this.istrack = true;
                            this.isolateruleenum = materialPlan.getIsolatedRule();
                        } else {
                            this.prmtTrackNum.setRequired(false);
                            this.istrack = false;
                            this.isolateruleenum = materialPlan.getIsolatedRule();
                        }
                    }
                }
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    private void projectNumberChanged(DataChangeEvent e) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent) {
            this.prmtTrackNum.setValue(null);
        }
    }

    protected int getCloseWindowType() {
        return this.closeWindowType;
    }

    protected boolean isConfirm() {
        return this.getCloseWindowType() == 0;
    }

    protected OrderBomSimulateFilterUI showDialog(Component owner) {
        OrderBomSimulateFilterUI filterUI = null;
        try {
            if (this.window == null) {
                this.init(owner);
            }
            this.window.show();
            filterUI = (OrderBomSimulateFilterUI)this.window.getUIObject();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return filterUI;
    }

    protected void init(Component owner) throws UIException {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        this.window = uiFactory.create("com.kingdee.eas.mm.basedata.client.OrderBomSimulateFilterUI", (Map)new UIContext((Object)owner), null, null);
    }

    protected Map getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public void actionCommit_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"bomFilter_storage_not_null"));
            this.prmtStorageOrgUnit.setRequestFocusEnabled(true);
            return;
        }
        if (null == this.prmtParentMaterial.getValue()) {
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"bom_material_notNull"));
            this.prmtParentMaterial.requestFocus(true);
            return;
        }
        if (this.manufactureStrategyID != null && ManufactureStrategyGroup.getProjectTrackOrderBomStrategyIdSet().contains(this.manufactureStrategyID)) {
            if (IsolatedRuleEnum.ITEM_TRACKNO.equals((Object)this.isolateruleenum)) {
                if (null == this.prmtTrackNum.getValue() || null == this.prmtProjectNum.getValue()) {
                    MsgBox.showInfo((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"pt_notnull"));
                    this.prmtProjectNum.requestFocus(true);
                    return;
                }
            } else if (null == this.prmtProjectNum.getValue()) {
                MsgBox.showInfo((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"not_null_project"));
                this.prmtProjectNum.requestFocus(true);
                return;
            }
        }
        if (this.manufactureStrategyID != null && ManufactureStrategyGroup.getTrackOrderBomStrategyIdSet().contains(this.manufactureStrategyID) && null == this.prmtTrackNum.getValue()) {
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"track_is_not_null"));
            this.prmtTrackNum.requestFocus(true);
            return;
        }
        if (!this.verifyDataInfo()) {
            return;
        }
        String storageid = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("material", this.prmtParentMaterial.getValue());
        map.put("project", this.prmtProjectNum.getValue());
        map.put("track", this.prmtTrackNum.getValue());
        IRowSet rs = OrderBomSimulateFacadeFactory.getRemoteInstance().getCfgBomTree(storageid, map, OrderBomSimulateFilterUI.getDefaultLocale());
        if (rs.size() == 1) {
            String materialNumber = ((MaterialInfo)this.prmtParentMaterial.getValue()).getNumber();
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"material_no_validchild", (String[])new String[]{materialNumber}));
            SysUtil.abort();
        }
        if (this.queryInfo == null) {
            this.queryInfo = new HashMap();
        }
        this.queryInfo.put("strogeOrgUnit", this.prmtStorageOrgUnit.getValue());
        this.queryInfo.put("parentMaterial", this.prmtParentMaterial.getValue());
        this.queryInfo.put("projectNum", this.prmtProjectNum.getValue());
        this.queryInfo.put("trackNum", this.prmtTrackNum.getValue());
        this.queryInfo.put("cfgRowSet", rs);
        this.closeWindowType = 0;
        Util.getWindow((Component)((Object)this)).dispose();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.closeWindowType = 1;
        Util.getWindow((Component)((Object)this)).dispose();
    }
}

