/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.IOrderBomSimulateFacade;
import com.kingdee.eas.mm.basedata.OrderBOMPTCollection;
import com.kingdee.eas.mm.basedata.OrderBOMPTInfo;
import com.kingdee.eas.mm.basedata.OrderBomSimulateFacadeFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractOrderBomSimulateUI;
import com.kingdee.eas.mm.basedata.client.OrderBomSimulateFilterUI;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OrderBomSimulateUI
extends AbstractOrderBomSimulateUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderBomSimulateUI.class);
    protected F7ContextManager f7ContextManager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 0);
    private SCMEntryDataVO headVO;
    OrderBomSimulateFilterUI filterUI = null;
    KDTEditAdapter yieldChangeLister = null;
    KDTEditAdapter checkBoxChangeLister = null;
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorgeOrg;
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.initUIPanel();
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        this.addListeners();
        this.actionQuery_actionPerformed(null);
        this.kdtEntrySimulate.getActionMap().remove("Delete");
        this.kdtEntrySimulate.getActionMap().remove("Cut");
    }

    protected boolean verify() {
        boolean ret = true;
        if ("".equals(this.txtBomName.getText())) {
            MsgBox.showWarning((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"Orderbom_name_notNull"));
            this.txtBomName.requestFocus(true);
            return false;
        }
        if (this.prmtProjectNum.getValue() == null && this.prmtTrackNum.getValue() == null) {
            MsgBox.showWarning((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)""));
            this.prmtProjectNum.requestFocus(true);
            return false;
        }
        if (this.txtParentMaterialNum.getNumberValue() == null) {
            MsgBox.showWarning((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderbom_parentnum_notnull"));
            this.txtParentMaterialNum.requestFocus(true);
            return false;
        }
        if (this.kdtEntryOrder.getRowCount() <= 0) {
            MsgBox.showWarning((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderbom_simulate_nodata"));
            return false;
        }
        if (this.kdtEntryOrder.getRowCount() == 1) {
            String materialNumber = ((MaterialInfo)this.prmtParentMaterial.getValue()).getNumber();
            MsgBox.showWarning((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"material_no_validchild", (String[])new String[]{materialNumber}));
            return false;
        }
        for (int i = 0; i < this.kdtEntryOrder.getRowCount(); ++i) {
            Integer isBomNode = (Integer)this.kdtEntryOrder.getCell(i, "isBomNode").getValue();
            if (isBomNode != 1 || this.kdtEntryOrder.getCell(i, "yield").getValue() != null) continue;
            MsgBox.showWarning((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderbom_yield_notnull"));
            return false;
        }
        return ret;
    }

    protected void addListeners() {
        if (this.checkBoxChangeLister == null) {
            this.checkBoxChangeLister = new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        OrderBomSimulateUI.this.checkBoxChanged(e);
                    }
                    catch (Exception exc) {
                        OrderBomSimulateUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntrySimulate.addKDTEditListener((KDTEditListener)this.checkBoxChangeLister);
        if (this.yieldChangeLister == null) {
            this.yieldChangeLister = new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        OrderBomSimulateUI.this.yieldChanged(e);
                    }
                    catch (Exception exc) {
                        OrderBomSimulateUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntryOrder.addKDTEditListener((KDTEditListener)this.yieldChangeLister);
    }

    protected void removeListener() {
        if (this.checkBoxChangeLister != null) {
            this.kdtEntryOrder.removeKDTEditListener((KDTEditListener)this.checkBoxChangeLister);
        }
        if (this.yieldChangeLister != null) {
            this.kdtEntrySimulate.removeKDTEditListener((KDTEditListener)this.yieldChangeLister);
        }
    }

    private void yieldChanged(KDTEditEvent e) {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)oldValue);
        if (isDiffrent && newValue != null) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.kdtEntryOrder.getColumnKey(colIndex);
            if (!"yield".equalsIgnoreCase(fieldName)) {
                return;
            }
            String materialId = ((MaterialInfo)this.kdtEntryOrder.getCell(rowIndex, "material").getValue()).getId().toString();
            BigDecimal yield = (BigDecimal)newValue;
            for (int i = 0; i < this.kdtEntryOrder.getRowCount(); ++i) {
                Integer isBomNode;
                if (i == rowIndex || (isBomNode = (Integer)this.kdtEntryOrder.getCell(i, "isBomNode").getValue()) == 0) continue;
                String materialId2 = ((MaterialInfo)this.kdtEntryOrder.getCell(i, "material").getValue()).getId().toString();
                BigDecimal yield2 = (BigDecimal)this.kdtEntryOrder.getCell(i, "yield").getValue();
                if (!materialId.equals(materialId2) || yield.compareTo(yield2) == 0) continue;
                this.kdtEntryOrder.getCell(i, "yield").setValue((Object)yield);
            }
        }
    }

    private void checkBoxChanged(KDTEditEvent e) {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)oldValue);
        if (isDiffrent && newValue != null) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.kdtEntrySimulate.getColumnKey(colIndex);
            if (!"selected".equalsIgnoreCase(fieldName)) {
                return;
            }
            String materialId = ((MaterialInfo)this.kdtEntrySimulate.getCell(rowIndex, "material").getValue()).getId().toString();
            String parentMaterialId = (String)this.kdtEntrySimulate.getCell(rowIndex, "parentMaterial").getValue();
            Boolean isSelected = (Boolean)this.kdtEntrySimulate.getCell(rowIndex, "selected").getValue();
            Integer leadTime = (Integer)this.kdtEntrySimulate.getCell(rowIndex, "leadTime").getValue();
            for (int i = 0; i < this.kdtEntrySimulate.getRowCount(); ++i) {
                if (i == rowIndex) continue;
                String materialId2 = ((MaterialInfo)this.kdtEntrySimulate.getCell(i, "material").getValue()).getId().toString();
                String parentMaterialId2 = (String)this.kdtEntrySimulate.getCell(i, "parentMaterial").getValue();
                Boolean isSelected2 = (Boolean)this.kdtEntrySimulate.getCell(i, "selected").getValue();
                Integer leadTime2 = (Integer)this.kdtEntrySimulate.getCell(i, "leadTime").getValue();
                if (!materialId.equals(materialId2) || !parentMaterialId.equals(parentMaterialId2) || isSelected.booleanValue() == isSelected2.booleanValue() || !leadTime.equals(leadTime2)) continue;
                this.kdtEntrySimulate.getCell(i, "selected").setValue((Object)isSelected);
            }
        }
    }

    private SCMEntryDataVO getHeadData(StorageOrgUnitInfo storageOrg, MaterialInfo material, MeasureUnitInfo unit, MeasureUnitInfo baseUnit) {
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        if (storageOrg != null && material != null && unit != null && baseUnit != null) {
            SCMEntryDataVO vo = new SCMEntryDataVO();
            vo.setMaterialInfos(new MaterialInfo[]{material});
            vo.setStorageOrgUnitInfos(new StorageOrgUnitInfo[]{storageOrg});
            vo.setIsLoadingMou(true);
            vo.setIsLoadingMmuPrecision(true);
            vo.setIsLoadingMaterialPlan(false);
            vo.setIsLoadingMaterialInventory(false);
            vo.setMeasureUnitInfos(new MeasureUnitInfo[]{unit});
            vo.setBaseMeasureUnitInfos(new MeasureUnitInfo[]{baseUnit});
            vo.setAssistMeasureUnitInfos(new MeasureUnitInfo[]{null});
            try {
                voResult = SCMGroupFacadeFactory.getRemoteInstance().loadComplexData(vo);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        return voResult;
    }

    private void loadMaterialAndUnit(KDTable tblMain) {
        try {
            MaterialInfo[] materials = new MaterialInfo[tblMain.getRowCount()];
            MeasureUnitInfo[] units = new MeasureUnitInfo[tblMain.getRowCount()];
            for (int i = 0; i < tblMain.getRowCount(); ++i) {
                materials[i] = (MaterialInfo)tblMain.getRow(i).getCell("material").getValue();
                units[i] = (MeasureUnitInfo)tblMain.getRow(i).getCell("unit").getValue();
            }
            SCMEntryDataVO vo = new SCMEntryDataVO();
            vo.setMaterialInfos(materials);
            vo.setMeasureUnitInfos(units);
            SCMEntryDataVO voResult = SCMGroupFacadeFactory.getRemoteInstance().loadMmuPrecision(vo);
            for (int i = 0; i < tblMain.getRowCount(); ++i) {
                if (materials[i] != null) {
                    tblMain.getCell(i, "materialName").setValue((Object)materials[i].getName());
                    tblMain.getCell(i, "materialModel").setValue((Object)materials[i].getModel());
                }
                SCMClientUtils.changeTableColPrecision((Map)voResult.getMmuPrecisions(), (MaterialInfo)materials[i], (MeasureUnitInfo)units[i], (KDTable)tblMain, (String[])new String[]{"consumeFixQty"}, (int)i);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initUIPanel() {
        this.btnSave.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnLookResult.setEnabled(true);
        this.btnSave.setVisible(true);
        this.btnQuery.setVisible(true);
        this.btnLookResult.setVisible(true);
        this.menuItemSave.setEnabled(true);
        this.menuItemLookResult.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
        this.comboBillStatus.setSelectedItem((Object)BillBaseStatusEnum.ADD);
        this.comboBillStatus.setEnabled(false);
        this.cmbBomUsage.removeItem((Object)BOMUsageEnum.NULL);
        this.cmbBomType.setSelectedItem((Object)BOMTypeEnum.OrderBOM);
        UIHelper.registerMeasureUnitF7((KDBizPromptBox)this.prmtParentMaterial, (KDBizPromptBox)this.prmtUnit);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorgeOrg, (OrgType)this.getMainBizOrgType(), (String)"mm_orderbom_simulate");
        this.initF7Material((StorageOrgUnitInfo)this.prmtStorgeOrg.getValue());
        HashSet<Integer> projStatus = new HashSet<Integer>();
        projStatus.add(new Integer(4));
        projStatus.add(new Integer(7));
        HashSet<Integer> trackNumStatus = new HashSet<Integer>();
        trackNumStatus.add(new Integer(10));
        trackNumStatus.add(new Integer(80));
        UIHelper.registerProjectF7((KDBizPromptBox)this.prmtStorgeOrg, null, (KDBizPromptBox)this.prmtProjectNum, projStatus);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.prmtStorgeOrg, null, (KDBizPromptBox)this.prmtProjectNum, (KDBizPromptBox)this.prmtTrackNum, trackNumStatus, (boolean)false);
        this.kdtEntrySimulate.getStyleAttributes().setLocked(true);
        this.kdtEntryOrder.getStyleAttributes().setLocked(true);
        this.kdtEntryOrder.checkParsed();
        this.kdtEntrySimulate.checkParsed();
        this.kdtEntryOrder.getSelectManager().setSelectMode(1);
        KDTableHelper.releaseTab((JComponent)this.kdtEntryOrder);
        this.kdtEntrySimulate.getSelectManager().setSelectMode(2);
        KDTableHelper.releaseTab((JComponent)this.kdtEntrySimulate);
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)this.f7ContextManager.getF7DisplayMode());
        KDBizPromptBox bizMaterialBox = new KDBizPromptBox();
        this.f7ContextManager.registerBizMaterialF7(bizMaterialBox, this.kdtEntrySimulate.getColumn("material"), materialPlanQuery, (OrgUnitInfo)((StorageOrgUnitInfo)this.prmtStorgeOrg.getValue()), false);
        this.f7ContextManager.registerMeasureUnitF7(this.kdtEntrySimulate, "material", "unit");
        this.f7ContextManager.registerBizMaterialF7(bizMaterialBox, this.kdtEntryOrder.getColumn("material"), materialPlanQuery, (OrgUnitInfo)((StorageOrgUnitInfo)this.prmtStorgeOrg.getValue()), false);
        bizMaterialBox.setEditFormat("$number$");
        bizMaterialBox.setDisplayFormat("$number$");
        bizMaterialBox.setCommitFormat("$number$");
        this.txtYield.setDataType(1);
        this.txtYield.setPrecision(2);
        this.txtYield.setRemoveingZeroInDispaly(false);
        this.txtYield.setMaximumValue((Comparable)new BigDecimal("100.00"));
        this.txtYield.setMinimumValue((Comparable)new BigDecimal("0.00"));
        this.txtYield.setNegatived(false);
        this.txtYield.setHorizontalAlignment(4);
        this.txtParentMaterialNum.setSupportedEmpty(false);
        this.txtParentMaterialNum.setDataType(1);
        this.txtYield.setRemoveingZeroInDispaly(false);
        this.txtParentMaterialNum.setHorizontalAlignment(4);
    }

    private void initF7Material(StorageOrgUnitInfo orgInfo) {
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)this.f7ContextManager.getF7DisplayMode());
        this.f7ContextManager.registerBizMaterialF7(this.prmtParentMaterial, null, materialPlanQuery, (OrgUnitInfo)orgInfo, OrgType.Storage, false, true);
    }

    private void fillBillHead(Map filterInfo) throws EASBizException, BOSException, SQLException {
        String bomId = (String)this.kdtEntryOrder2.getCell(0, "bomId").getValue();
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)filterInfo.get("strogeOrgUnit");
        MaterialInfo parentMaterial = (MaterialInfo)filterInfo.get("parentMaterial");
        ProjectInfo project = (ProjectInfo)filterInfo.get("projectNum");
        TrackNumberInfo trackNumber = (TrackNumberInfo)filterInfo.get("trackNum");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("material.name"));
        selector.add(new SelectorItemInfo("material.number"));
        selector.add(new SelectorItemInfo("material.model"));
        selector.add(new SelectorItemInfo("material.pictureNumber"));
        selector.add(new SelectorItemInfo("bomGroup.id"));
        selector.add(new SelectorItemInfo("bomGroup.name"));
        selector.add(new SelectorItemInfo("bomGroup.number"));
        selector.add(new SelectorItemInfo("unit.id"));
        selector.add(new SelectorItemInfo("unit.name"));
        selector.add(new SelectorItemInfo("unit.number"));
        selector.add(new SelectorItemInfo("baseUnit.id"));
        selector.add(new SelectorItemInfo("baseUnit.name"));
        selector.add(new SelectorItemInfo("baseUnit.number"));
        BomInfo bomInfo = BomFactory.getRemoteInstance().getBomInfo((IObjectPK)new ObjectUuidPK(bomId), selector);
        this.prmtStorgeOrg.setValue((Object)storageOrgUnitInfo);
        this.cmbBomUsage.setSelectedItem((Object)bomInfo.getUsageType());
        this.prmtParentMaterial.setValue((Object)parentMaterial);
        this.txtModel.setText(parentMaterial.getModel());
        this.prmtUnit.setValue((Object)bomInfo.getUnit());
        this.txtParentMaterialNum.setValue((Object)bomInfo.getProductQty());
        this.headVO = this.getHeadData(storageOrgUnitInfo, parentMaterial, bomInfo.getUnit(), bomInfo.getBaseUnit());
        int prec = 2;
        if (parentMaterial != null && bomInfo.getUnit() != null) {
            String key = parentMaterial.getId().toString() + bomInfo.getUnit().getId().toString();
            if (this.headVO != null && this.headVO.getMmuPrecisions() != null && this.headVO.getMmuPrecisions().get(key) != null) {
                prec = (Integer)this.headVO.getMmuPrecisions().get(key);
            }
        }
        this.txtParentMaterialNum.setPrecision(prec);
        this.prmtBomGroup.setValue((Object)bomInfo.getBomGroup());
        this.txtYield.setValue((Object)bomInfo.getYield());
        if (bomInfo.getMaterial() != null) {
            this.txtPictureNumber.setText(bomInfo.getMaterial().getPictureNumber());
        }
        this.prmtProjectNum.setValue((Object)project);
        this.prmtTrackNum.setValue((Object)trackNumber);
    }

    private void fillTempTable(IRowSet rs) throws BOSException, SQLException {
        this.kdtEntryOrder2.getStyleAttributes().setLocked(true);
        this.kdtEntryOrder2.checkParsed();
        this.kdtEntryOrder2.removeRows();
        rs.beforeFirst();
        while (rs.next()) {
            IRow row = this.kdtEntryOrder2.addRow();
            row.getCell("level").setValue((Object)rs.getString("FLevel"));
            row.getCell("selected").setValue((Object)new Boolean(false));
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)rs.getString("FMaterialID")));
            materialInfo.setNumber(rs.getString("FMaterialNumber"));
            materialInfo.setName(rs.getString("FMaterialName"), OrderBomSimulateUI.getDefaultLocale());
            materialInfo.setModel(rs.getString("FMaterialModel"));
            row.getCell("material").setValue((Object)materialInfo);
            row.getCell("materialName").setValue((Object)materialInfo.getName(OrderBomSimulateUI.getDefaultLocale()));
            row.getCell("materialModel").setValue((Object)materialInfo.getModel());
            MeasureUnitInfo unitInfo = new MeasureUnitInfo();
            unitInfo.setId(BOSUuid.read((String)rs.getString("FUnitID")));
            unitInfo.setName(rs.getString("FUnitName"));
            unitInfo.setNumber(rs.getString("FUnitNumber"));
            row.getCell("unit").setValue((Object)unitInfo);
            row.getCell("feature").setValue((Object)new Boolean(rs.getBoolean("FFeture")));
            row.getCell("firstCfg").setValue((Object)new Boolean(rs.getBoolean("FFirstCfg")));
            row.getCell("canSelected").setValue((Object)new Boolean(rs.getBoolean("FCanSelected")));
            row.getCell("consumeType").setValue((Object)ConsumeTypeEnum.getEnum(rs.getInt("FConsumeType")));
            row.getCell("consumeFixQty").setValue((Object)rs.getBigDecimal("FConsumeFixQty"));
            row.getCell("proportion").setValue((Object)rs.getBigDecimal("FProportion"));
            row.getCell("scrapRatio").setValue((Object)rs.getBigDecimal("FScrapRatio"));
            row.getCell("isBomNode").setValue((Object)new Integer(rs.getInt("FBomNode")));
            Object pBomType = null;
            if (pBomType != null) {
                if (rs.getString("FBomType") == null) {
                    row.getCell("bomType").setValue(pBomType);
                } else {
                    row.getCell("bomType").setValue((Object)BOMTypeEnum.getEnum(rs.getInt("FBomType")));
                }
            } else {
                row.getCell("bomType").setValue((Object)BOMTypeEnum.getEnum(rs.getInt("FBomType")));
            }
            row.getCell("yield").setValue((Object)rs.getBigDecimal("FYield"));
            row.getCell("bomPath").setValue((Object)rs.getString("FBomPath"));
            row.getCell("bomId").setValue((Object)rs.getString("FBOMID"));
            row.getCell("parentMaterial").setValue((Object)rs.getString("FParentMaterialID"));
            row.getCell("parentBomId").setValue((Object)rs.getString("FPARENTBOMID"));
            row.getCell("leadTime").setValue((Object)new Integer(rs.getInt("FLeadtime")));
            row.getCell("isConfigable").setValue((Object)new Boolean(rs.getBoolean("FIsConfigable")));
        }
    }

    private void fillCFGBomTable(Map filterInfo) throws EASBizException, BOSException, SQLException {
        IRowSet rs = (IRowSet)filterInfo.get("cfgRowSet");
        this.kdtEntrySimulate.removeRows();
        this.kdtEntryOrder.removeRows();
        rs.beforeFirst();
        while (rs.next()) {
            String rowIndex = null;
            String pMaterialId = rs.getString("FParentMaterialID");
            int bomNode = rs.getInt("FBomNode");
            boolean isFeature = rs.getBoolean("FFeture");
            boolean isCanSelected = rs.getBoolean("FCanSelected");
            boolean isConfigable = rs.getBoolean("FIsConfigable");
            if (rs.getInt("FLevel") != 0) {
                if (!isConfigable && !isFeature && !isCanSelected) continue;
                String selfPath = rs.getString("FBomPath");
                for (int i = 0; i < this.kdtEntrySimulate.getRowCount(); ++i) {
                    String parentPath;
                    MaterialInfo materialInfo = (MaterialInfo)this.kdtEntrySimulate.getCell(i, "material").getValue();
                    if (!pMaterialId.equals(materialInfo.getId().toString()) || !(parentPath = (String)this.kdtEntrySimulate.getCell(i, "bomPath").getValue()).equals(selfPath.substring(0, selfPath.lastIndexOf(",")))) continue;
                    rowIndex = String.valueOf(i + 1);
                    break;
                }
                if (rowIndex == null) continue;
            }
            IRow row = null;
            row = rowIndex == null ? this.kdtEntrySimulate.addRow() : this.kdtEntrySimulate.addRow(Integer.parseInt(rowIndex));
            int level = rs.getInt("FLevel");
            StringBuffer str = new StringBuffer("");
            for (int i = 0; i < level; ++i) {
                str.append(".");
            }
            str.append(level);
            row.getCell("level").setValue((Object)str.toString());
            if (bomNode == 1 && !isFeature && !isCanSelected) {
                row.getStyleAttributes().setBackground(Color.GRAY);
            } else if (isFeature || isCanSelected) {
                row.getCell("selected").setValue((Object)new Boolean(false));
                row.getCell("selected").getStyleAttributes().setLocked(false);
                SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntrySimulate, (int)row.getRowIndex(), (String[])new String[]{"selected"}, (boolean)true);
            }
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)rs.getString("FMaterialID")));
            materialInfo.setNumber(rs.getString("FMaterialNumber"));
            materialInfo.setName(rs.getString("FMaterialName"), OrderBomSimulateUI.getDefaultLocale());
            materialInfo.setModel(rs.getString("FMaterialModel"));
            row.getCell("material").setValue((Object)materialInfo);
            row.getCell("materialName").setValue((Object)materialInfo.getName(OrderBomSimulateUI.getDefaultLocale()));
            row.getCell("materialModel").setValue((Object)materialInfo.getModel());
            MeasureUnitInfo unitInfo = new MeasureUnitInfo();
            unitInfo.setId(BOSUuid.read((String)rs.getString("FUnitID")));
            unitInfo.setName(rs.getString("FUnitName"));
            unitInfo.setNumber(rs.getString("FUnitNumber"));
            row.getCell("unit").setValue((Object)unitInfo);
            row.getCell("feature").setValue((Object)new Boolean(rs.getBoolean("FFeture")));
            row.getCell("firstCfg").setValue((Object)new Boolean(rs.getBoolean("FFirstCfg")));
            row.getCell("canSelected").setValue((Object)new Boolean(rs.getBoolean("FCanSelected")));
            row.getCell("consumeType").setValue((Object)ConsumeTypeEnum.getEnum(rs.getInt("FConsumeType")));
            row.getCell("consumeFixQty").setValue((Object)rs.getBigDecimal("FConsumeFixQty"));
            row.getCell("proportion").setValue((Object)rs.getBigDecimal("FProportion"));
            row.getCell("scrapRatio").setValue((Object)rs.getBigDecimal("FScrapRatio"));
            row.getCell("yield").setValue((Object)rs.getBigDecimal("FYield"));
            row.getCell("bomPath").setValue((Object)rs.getString("FBomPath"));
            row.getCell("parentMaterial").setValue((Object)pMaterialId);
            row.getCell("isBomNode").setValue((Object)new Integer(bomNode));
            row.getCell("bomId").setValue((Object)rs.getString("FBOMID"));
            row.getCell("leadTime").setValue((Object)new Integer(rs.getInt("FLeadtime")));
            row.getCell("isConfigable").setValue((Object)new Boolean(rs.getBoolean("FIsConfigable")));
        }
        this.loadMaterialAndUnit(this.kdtEntrySimulate);
    }

    private void fillResultTable() {
        IRow row;
        String parentPath;
        MaterialInfo materialInfo;
        String selfPath;
        String rowIndex;
        String pMaterialId;
        int intLevel;
        int size = this.kdtEntrySimulate.getRowCount();
        for (int i = 0; i < size; ++i) {
            Boolean isFeature = (Boolean)this.kdtEntrySimulate.getCell(i, "feature").getValue();
            Boolean isCanSelected = (Boolean)this.kdtEntrySimulate.getCell(i, "canSelected").getValue();
            Boolean isSelected = (Boolean)this.kdtEntrySimulate.getCell(i, "selected").getValue();
            Integer isBomNode = (Integer)this.kdtEntrySimulate.getCell(i, "isBomNode").getValue();
            if ((isFeature.booleanValue() || isCanSelected.booleanValue()) && !isSelected.booleanValue()) continue;
            String level = (String)this.kdtEntrySimulate.getCell(i, "level").getValue();
            intLevel = Integer.parseInt(level.replace('.', ' ').trim());
            pMaterialId = (String)this.kdtEntrySimulate.getCell(i, "parentMaterial").getValue();
            rowIndex = null;
            if (intLevel != 0) {
                selfPath = (String)this.kdtEntrySimulate.getCell(i, "bomPath").getValue();
                for (int j = 0; j < this.kdtEntryOrder.getRowCount(); ++j) {
                    materialInfo = (MaterialInfo)this.kdtEntryOrder.getCell(j, "material").getValue();
                    if (!pMaterialId.equals(materialInfo.getId().toString()) || !(parentPath = (String)this.kdtEntryOrder.getCell(j, "bomPath").getValue()).equals(selfPath.substring(0, selfPath.lastIndexOf(",")))) continue;
                    rowIndex = String.valueOf(j + 1);
                    break;
                }
                if (rowIndex == null) continue;
            }
            row = null;
            row = rowIndex == null ? this.kdtEntryOrder.addRow() : this.kdtEntryOrder.addRow(Integer.parseInt(rowIndex));
            row.getCell("level").setValue((Object)level);
            MaterialInfo material = (MaterialInfo)this.kdtEntrySimulate.getCell(i, "material").getValue();
            row.getCell("material").setValue((Object)material);
            row.getCell("materialName").setValue((Object)material.getName(OrderBomSimulateUI.getDefaultLocale()));
            row.getCell("materialModel").setValue((Object)material.getModel());
            row.getCell("unit").setValue(this.kdtEntrySimulate.getCell(i, "unit").getValue());
            row.getCell("consumeType").setValue(this.kdtEntrySimulate.getCell(i, "consumeType").getValue());
            row.getCell("consumeFixQty").setValue(this.kdtEntrySimulate.getCell(i, "consumeFixQty").getValue());
            row.getCell("proportion").setValue(this.kdtEntrySimulate.getCell(i, "proportion").getValue());
            row.getCell("scrapRatio").setValue(this.kdtEntrySimulate.getCell(i, "scrapRatio").getValue());
            if (isBomNode == 1) {
                KDFormattedTextField txtField = new KDFormattedTextField();
                txtField.setDataType(1);
                txtField.setPrecision(2);
                txtField.setRemoveingZeroInDispaly(false);
                txtField.setMaximumValue((Comparable)new BigDecimal("100.00"));
                txtField.setMinimumValue((Comparable)new BigDecimal("0.00"));
                txtField.setNegatived(false);
                txtField.setHorizontalAlignment(4);
                KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)txtField);
                row.getCell("yield").setEditor((ICellEditor)cellEditor);
                row.getCell("yield").getStyleAttributes().setLocked(false);
                SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntryOrder, (int)row.getRowIndex(), (String[])new String[]{"yield"}, (boolean)true);
            }
            row.getCell("yield").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("yield").setValue(this.kdtEntrySimulate.getCell(i, "yield").getValue());
            if ((isFeature.booleanValue() || isCanSelected.booleanValue()) && isSelected.booleanValue()) {
                row.getCell("isCfgSelected").setValue((Object)new Boolean(true));
            } else {
                row.getCell("isCfgSelected").setValue((Object)new Boolean(false));
            }
            row.getCell("bomPath").setValue(this.kdtEntrySimulate.getCell(i, "bomPath").getValue());
            row.getCell("isBomNode").setValue(this.kdtEntrySimulate.getCell(i, "isBomNode").getValue());
            row.getCell("bomId").setValue(this.kdtEntrySimulate.getCell(i, "bomId").getValue());
            row.getCell("parentMaterial").setValue(this.kdtEntrySimulate.getCell(i, "parentMaterial").getValue());
            row.getCell("leadTime").setValue(this.kdtEntrySimulate.getCell(i, "leadTime").getValue());
        }
        int size2 = this.kdtEntryOrder2.getRowCount();
        for (int i = 0; i < size2; ++i) {
            Integer isBomNode = (Integer)this.kdtEntryOrder2.getCell(i, "isBomNode").getValue();
            Boolean isFeature = (Boolean)this.kdtEntryOrder2.getCell(i, "feature").getValue();
            Boolean isCanSelected = (Boolean)this.kdtEntryOrder2.getCell(i, "canSelected").getValue();
            Boolean isConfigable = (Boolean)this.kdtEntryOrder2.getCell(i, "isConfigable").getValue();
            intLevel = Integer.parseInt((String)this.kdtEntryOrder2.getCell(i, "level").getValue());
            pMaterialId = (String)this.kdtEntryOrder2.getCell(i, "parentMaterial").getValue();
            rowIndex = null;
            if (intLevel == 0) continue;
            selfPath = (String)this.kdtEntryOrder2.getCell(i, "bomPath").getValue();
            for (int j = 0; j < this.kdtEntryOrder.getRowCount(); ++j) {
                materialInfo = (MaterialInfo)this.kdtEntryOrder.getCell(j, "material").getValue();
                if (!pMaterialId.equals(materialInfo.getId().toString()) || !(parentPath = (String)this.kdtEntryOrder.getCell(j, "bomPath").getValue()).equals(selfPath.substring(0, selfPath.lastIndexOf(",")))) continue;
                rowIndex = String.valueOf(j + 1);
                break;
            }
            if (isConfigable.booleanValue() || isFeature.booleanValue() || isCanSelected.booleanValue() || rowIndex == null) continue;
            row = null;
            row = rowIndex == null ? this.kdtEntryOrder.addRow() : this.kdtEntryOrder.addRow(Integer.parseInt(rowIndex));
            StringBuffer str = new StringBuffer("");
            for (int ii = 0; ii < intLevel; ++ii) {
                str.append(".");
            }
            str.append(intLevel);
            row.getCell("level").setValue((Object)str.toString());
            MaterialInfo material = (MaterialInfo)this.kdtEntryOrder2.getCell(i, "material").getValue();
            row.getCell("material").setValue((Object)material);
            row.getCell("materialName").setValue((Object)material.getName(OrderBomSimulateUI.getDefaultLocale()));
            row.getCell("materialModel").setValue((Object)material.getModel());
            row.getCell("unit").setValue(this.kdtEntryOrder2.getCell(i, "unit").getValue());
            row.getCell("consumeType").setValue(this.kdtEntryOrder2.getCell(i, "consumeType").getValue());
            row.getCell("consumeFixQty").setValue(this.kdtEntryOrder2.getCell(i, "consumeFixQty").getValue());
            row.getCell("proportion").setValue(this.kdtEntryOrder2.getCell(i, "proportion").getValue());
            row.getCell("scrapRatio").setValue(this.kdtEntryOrder2.getCell(i, "scrapRatio").getValue());
            row.getCell("isCfgSelected").setValue((Object)new Boolean(false));
            if (isBomNode == 1) {
                KDFormattedTextField txtField = new KDFormattedTextField();
                txtField.setDataType(1);
                txtField.setPrecision(2);
                txtField.setRemoveingZeroInDispaly(false);
                txtField.setMaximumValue((Comparable)new BigDecimal("100.00"));
                txtField.setMinimumValue((Comparable)new BigDecimal("0.00"));
                txtField.setNegatived(false);
                txtField.setHorizontalAlignment(4);
                KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)txtField);
                row.getCell("yield").setEditor((ICellEditor)cellEditor);
                row.getCell("yield").getStyleAttributes().setLocked(false);
                SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntryOrder, (int)row.getRowIndex(), (String[])new String[]{"yield"}, (boolean)true);
            }
            row.getCell("yield").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("yield").setValue(this.kdtEntryOrder2.getCell(i, "yield").getValue());
            row.getCell("bomPath").setValue(this.kdtEntryOrder2.getCell(i, "bomPath").getValue());
            row.getCell("isBomNode").setValue(this.kdtEntryOrder2.getCell(i, "isBomNode").getValue());
            row.getCell("bomId").setValue(this.kdtEntryOrder2.getCell(i, "bomId").getValue());
            row.getCell("parentMaterial").setValue(this.kdtEntryOrder2.getCell(i, "parentMaterial").getValue());
            row.getCell("leadTime").setValue(this.kdtEntryOrder2.getCell(i, "leadTime").getValue());
        }
        int size3 = this.kdtEntryOrder.getRowCount();
        for (int i = 0; i < size3; ++i) {
            Integer isBomNode = (Integer)this.kdtEntryOrder.getCell(i, "isBomNode").getValue();
            if (isBomNode == 0) continue;
            boolean isHasChild = false;
            String pMaterialId2 = ((MaterialInfo)this.kdtEntryOrder.getCell(i, "material").getValue()).getId().toString();
            String parentPath2 = (String)this.kdtEntryOrder.getCell(i, "bomPath").getValue();
            for (int j = 0; j < this.kdtEntryOrder.getRowCount(); ++j) {
                String parentMaterialId = (String)this.kdtEntryOrder.getCell(j, "parentMaterial").getValue();
                if (!pMaterialId2.equals(parentMaterialId) || (selfPath = (String)this.kdtEntryOrder.getCell(j, "bomPath").getValue()).lastIndexOf(",") == -1 || !parentPath2.equals(selfPath.substring(0, selfPath.lastIndexOf(",")))) continue;
                isHasChild = true;
                break;
            }
            if (isHasChild) continue;
            SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntryOrder, (int)i, (String[])new String[]{"yield"}, (boolean)false);
            this.kdtEntryOrder.getCell(i, "yield").getStyleAttributes().setLocked(true);
            this.kdtEntryOrder.getCell(i, "isBomNode").setValue((Object)new Integer(0));
        }
    }

    private Map getMaterialPlanMap() throws BOSException {
        HashMap<String, MaterialPlanInfo> map = new HashMap<String, MaterialPlanInfo>();
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.prmtStorgeOrg.getValue();
        String storageOrgUnitId = null;
        if (orgInfo != null) {
            storageOrgUnitId = orgInfo.getId().toString();
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        for (int i = 0; i < this.kdtEntryOrder.getRowCount(); ++i) {
            String parentMaterialId;
            MaterialInfo material;
            IRow row = this.kdtEntryOrder.getRow(i);
            Integer isBomNode = (Integer)row.getCell("isBomNode").getValue();
            if (isBomNode == 1 && (material = (MaterialInfo)row.getCell("material").getValue()) != null) {
                materialIdSet.add(material.getId().toString());
            }
            if ((parentMaterialId = (String)row.getCell("parentMaterial").getValue()) == null) continue;
            materialIdSet.add(parentMaterialId);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("manufactureStrategy.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(sic);
        MaterialPlanCollection planColl = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(viewInfo);
        MaterialPlanInfo planInfo = null;
        for (int i = 0; i < planColl.size(); ++i) {
            planInfo = planColl.get(i);
            map.put(planInfo.getMaterial().getId().toString(), planInfo);
        }
        return map;
    }

    private Map getOrderBomMap() {
        HashMap<String, BomInfo> map = new HashMap<String, BomInfo>();
        Map planMap = new HashMap();
        try {
            planMap = this.getMaterialPlanMap();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        MaterialPlanInfo planInfo = null;
        for (int i = 0; i < this.kdtEntryOrder.getRowCount(); ++i) {
            BomInfo bom;
            MaterialInfo material;
            String parentMaterialId;
            MaterialInfo material2;
            Object object;
            IRow row = this.kdtEntryOrder.getRow(i);
            Integer isBomNode = (Integer)row.getCell("isBomNode").getValue();
            if (isBomNode == 1 && (object = map.get((material2 = (MaterialInfo)row.getCell("material").getValue()).getId().toString())) == null) {
                boolean isAddBom = false;
                planInfo = (MaterialPlanInfo)planMap.get(material2.getId().toString());
                String msId = planInfo.getManufactureStrategy().getId().toString();
                isAddBom = "fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(msId) ? this.prmtTrackNum.getValue() != null : !"NUnM+gEcEADgAA3cwKgL09g0uEU=".equals(msId) && !"NUnM+gEcEADgAA3ewKgL09g0uEU=".equals(msId) && !"NUnM+gEcEADgAA3gwKgL09g0uEU=".equals(msId);
                if (isAddBom) {
                    BomInfo bom2 = new BomInfo();
                    String bomId = (String)row.getCell("bomId").getValue();
                    bom2.setSourceCfgBomId(bomId);
                    bom2.setName(this.txtBomName.getText());
                    bom2.setUsageType((BOMUsageEnum)((Object)this.cmbBomUsage.getSelectedItem()));
                    bom2.setYield((BigDecimal)row.getCell("yield").getValue());
                    OrderBOMPTCollection orderBOMPTCollection = new OrderBOMPTCollection();
                    OrderBOMPTInfo pt = new OrderBOMPTInfo();
                    pt.setProjectId(null);
                    if (!"fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(msId) && this.prmtProjectNum.getValue() != null) {
                        pt.setProjectId(((ProjectInfo)this.prmtProjectNum.getValue()).getId().toString());
                    }
                    pt.setTrackId(null);
                    if (this.prmtTrackNum.getValue() != null) {
                        pt.setTrackId(((TrackNumberInfo)this.prmtTrackNum.getValue()).getId().toString());
                    }
                    orderBOMPTCollection.add(pt);
                    bom2.setOrderBomPT(orderBOMPTCollection);
                    bom2.setMaterial(material2);
                    map.put(material2.getId().toString(), bom2);
                }
            }
            if ((parentMaterialId = (String)row.getCell("parentMaterial").getValue()).equals((material = (MaterialInfo)row.getCell("material").getValue()).getId().toString()) || (bom = (BomInfo)map.get(parentMaterialId)) == null) continue;
            BomEntryInfo entryInfo = new BomEntryInfo();
            entryInfo.setMaterial(material);
            boolean isExist = false;
            if (bom.getEntrys() == null || bom.getEntrys().size() <= 0) {
                bom.getEntrys().add(entryInfo);
            } else {
                String materialId = material.getId().toString();
                for (int j = 0; j < bom.getEntrys().size(); ++j) {
                    BomEntryInfo temp = bom.getEntrys().get(j);
                    if (!materialId.equals(temp.getMaterial().getId().toString())) continue;
                    isExist = true;
                    break;
                }
                if (!isExist) {
                    bom.getEntrys().add(entryInfo);
                }
            }
            map.put(parentMaterialId, bom);
        }
        return map;
    }

    @Override
    public void actionLookResult_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntryOrder.getRowCount() > 0) {
            this.kdtEntryOrder.removeRows();
        }
        this.fillResultTable();
        this.btnSave.setEnabled(true);
        this.menuItemSave.setEnabled(true);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify()) {
            return;
        }
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtStorgeOrg.getValue();
        String storageOrgUnitId = null;
        if (storageOrgUnit != null) {
            storageOrgUnitId = storageOrgUnit.getId().toString();
        }
        ProjectInfo project = (ProjectInfo)this.prmtProjectNum.getValue();
        String projectId = null;
        if (project != null) {
            projectId = project.getId().toString();
        }
        TrackNumberInfo track = (TrackNumberInfo)this.prmtTrackNum.getValue();
        String trackNumberId = null;
        if (track != null) {
            trackNumberId = track.getId().toString();
        }
        Map map = this.getOrderBomMap();
        IOrderBomSimulateFacade iOrderBomSimulate = OrderBomSimulateFacadeFactory.getRemoteInstance();
        IRowSet rowSet = iOrderBomSimulate.checkGenerateOrderBomExist(storageOrgUnitId, projectId, trackNumberId, map);
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                String key = rowSet.getString(1);
                map.remove(key);
            }
        }
        if (map.size() > 0) {
            iOrderBomSimulate.saveOrderBoms(storageOrgUnitId, map);
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderbom_save_success"));
        }
        this.comboBillStatus.setSelectedItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
        this.btnSave.setEnabled(false);
        this.menuItemSave.setEnabled(false);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new OrderBomSimulateFilterUI();
        }
        this.filterUI = this.filterUI.showDialog((Component)this.getUIContext().get("OwnerWindow"));
        if (this.filterUI.isConfirm() && this.filterUI.getQueryInfo() != null) {
            IRowSet rs = (IRowSet)this.filterUI.getQueryInfo().get("cfgRowSet");
            this.fillTempTable(rs);
            this.fillBillHead(this.filterUI.getQueryInfo());
            this.fillCFGBomTable(this.filterUI.getQueryInfo());
            this.btnSave.setEnabled(true);
            this.menuItemSave.setEnabled(true);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionShowDebugTable_actionPerformed(ActionEvent e) throws Exception {
        boolean isVisible = this.kdtEntryOrder2.isVisible();
        this.kdtEntryOrder2.setVisible(!isVisible);
    }
}

