/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.MaterialReplaceCollection;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryCollection;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryInfo;
import com.kingdee.eas.mm.basedata.MaterialReplaceFactory;
import com.kingdee.eas.mm.basedata.MaterialReplaceInfo;
import com.kingdee.eas.mm.basedata.MaterialReplaceScopeEntryCollection;
import com.kingdee.eas.mm.basedata.MaterialReplaceScopeEntryInfo;
import com.kingdee.eas.mm.common.loadmass.MaterialSustituteVO;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OrderMaterialReplace {
    private static final String RES_PRD_ORDER = "com.kingdee.eas.mm.control.ProductionOrderNextResource";

    public List getSuitableReplaceMaterial(String lineSeq, String materialId, String bomId, Date reqDate, BigDecimal reqQty, String storageOrgUnitId, String MaterialUnitId) throws BOSException, EASBizException {
        List replaceMaterialList = new ArrayList();
        try {
            DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
            reqDate = dtformat.parse(dtformat.format(reqDate));
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        MaterialReplaceCollection mrc = this.getMaterialReplaceEntryInfo(reqDate, storageOrgUnitId, materialId, bomId);
        if (mrc.isEmpty()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PRD_ORDER, (String)"MaterialReplaceLogic4"));
            return null;
        }
        MultiMeasureUnitInfo multiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, MaterialUnitId);
        BigDecimal headBaseRate = multiUnifInfo.getBaseConvsRate();
        int headPrecision = multiUnifInfo.getQtyPrecision();
        BigDecimal repBaseQty = reqQty.multiply(headBaseRate).setScale(headPrecision, 4);
        Collection bomSub = this.loadMaterialSustitute(mrc);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"lineSeq", (Object)lineSeq);
        uiContext.put((Object)"repDate", (Object)reqDate);
        uiContext.put((Object)"bomSubs", (Object)bomSub);
        uiContext.put((Object)"materialReplace", (Object)mrc);
        uiContext.put((Object)"bomId", (Object)bomId);
        uiContext.put((Object)"repBaseQty", (Object)repBaseQty);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.mm.basedata.client.MaterialReplaceUI", (Map)uiContext, null);
        window.show();
        replaceMaterialList = (List)window.getUIObject().getUIContext().get("replaceMaterialList");
        return replaceMaterialList;
    }

    private Collection loadMaterialSustitute(MaterialReplaceCollection mrcolls) throws BOSException {
        ArrayList<MaterialSustituteVO> sustituteVOCollection = new ArrayList<MaterialSustituteVO>();
        MaterialReplaceInfo mrInfo = null;
        MaterialReplaceEntryCollection mrEntrys = null;
        MaterialReplaceEntryInfo entryInfo = null;
        for (int i = 0; i < mrcolls.size(); ++i) {
            mrInfo = mrcolls.get(i);
            mrEntrys = mrInfo.getEntry();
            MaterialInfo parentMaterial = mrInfo.getMaterial();
            MeasureUnitInfo productUnit = mrInfo.getUnit();
            EntityViewInfo viewer = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)parentMaterial.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)mrInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            viewer.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("productUnit.id");
            sic.add("productUnit.number");
            sic.add("productUnit.name");
            sic.add("productUnit.coefficient");
            viewer.setSelector(sic);
            MaterialPlanCollection plan = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(viewer);
            if (plan.size() > 0) {
                productUnit = plan.get(0).getProductUnit();
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)parentMaterial.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)productUnit.getId().toString(), CompareType.EQUALS));
            viewer = new EntityViewInfo();
            viewer.setFilter(filter);
            sic = new SelectorItemCollection();
            sic.add("*");
            viewer.setSelector(sic);
            MultiMeasureUnitCollection parentMulti = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(viewer);
            BigDecimal parentToBaseUnitRate = new BigDecimal("1");
            if (parentMulti.size() > 0) {
                parentToBaseUnitRate = parentMulti.get(0).getBaseConvsRate();
            }
            BigDecimal parentCoeff = productUnit.getCoefficient();
            String parentProductUnitId = productUnit.getId().toString();
            for (int j = 0; j < mrEntrys.size(); ++j) {
                entryInfo = mrEntrys.get(j);
                MaterialSustituteVO sustituteVO = new MaterialSustituteVO();
                sustituteVO.setEffectiveDate(entryInfo.getValidDate());
                sustituteVO.setInvalidDate(entryInfo.getInvalidDate());
                sustituteVO.setSubstituteMaterial(entryInfo.getMaterial());
                MeasureUnitInfo unit = entryInfo.getMeasureUnit();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)entryInfo.getMaterial().getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)entryInfo.getMeasureUnit().getId().toString(), CompareType.EQUALS));
                viewer = new EntityViewInfo();
                viewer.setFilter(filter);
                sic = new SelectorItemCollection();
                sic.add("*");
                viewer.setSelector(sic);
                MultiMeasureUnitCollection multi = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(viewer);
                int qtyPrecision = 0;
                if (multi.size() > 0) {
                    qtyPrecision = multi.get(0).getQtyPrecision();
                }
                unit.setQtyPrecision(qtyPrecision);
                sustituteVO.setSubstituteUnit(unit);
                sustituteVO.setParentToBaseUnitRate(parentToBaseUnitRate);
                sustituteVO.setSubstituteProportion(entryInfo.getReplacePercent());
                BigDecimal perReplaceQty = entryInfo.getReplaceQty().divide(mrInfo.getQty(), 8, 5);
                sustituteVO.setSubstituteQty(perReplaceQty);
                sustituteVO.setSubstituteSeq(entryInfo.getReplaceSeq());
                sustituteVO.setSubstitueScale(entryInfo.getReplaceScale());
                sustituteVO.setMaterialReplaceId(entryInfo.getId().toString());
                sustituteVO.setCombinationKey(entryInfo.isIsCombinationKey());
                sustituteVO.setBaseReplaceQty(entryInfo.getBaseReplaceQty());
                if (multi.size() > 0) {
                    sustituteVO.setToBaseUnitRate(multi.get(0).getBaseConvsRate());
                }
                if (entryInfo.getReplaceQty().doubleValue() > 0.0) {
                    sustituteVO.setSubstituteQty(true);
                } else {
                    sustituteVO.setSubstituteQty(false);
                }
                sustituteVO.setParentUnitId(parentProductUnitId);
                sustituteVOCollection.add(sustituteVO);
            }
        }
        return sustituteVOCollection;
    }

    private MaterialReplaceCollection getMaterialReplaceEntryInfo(Date reqDate, String storageOrgUnitId, String materialId, String bomId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(3), CompareType.EQUALS));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("storageOrgUnit.id");
        selector.add("material.id");
        selector.add("material.baseUnit.id");
        selector.add("material.number");
        selector.add("material.model");
        selector.add("unit.id");
        selector.add("unit.name");
        selector.add("substituteMode");
        selector.add("baseQty");
        selector.add("qty");
        selector.add("entry.baseReplaceQty");
        selector.add("isReplaceSeq");
        selector.add("entry.id");
        selector.add("entry.replaceSeq");
        selector.add("entry.material.id");
        selector.add("entry.material.number");
        selector.add("entry.material.name");
        selector.add("entry.material.model");
        selector.add("entry.material.status");
        selector.add("entry.material.baseUnit.id");
        selector.add("entry.material.baseUnit.number");
        selector.add("entry.material.baseUnit.name");
        selector.add("entry.material.baseUnit.coefficient");
        selector.add("entry.measureUnit.id");
        selector.add("entry.measureUnit.number");
        selector.add("entry.measureUnit.name");
        selector.add("entry.replaceQty");
        selector.add("entry.baseUnit.id");
        selector.add("entry.baseUnit.number");
        selector.add("entry.baseUnit.name");
        selector.add("entry.baseReplaceQty");
        selector.add("entry.replacePercent");
        selector.add("entry.isCombinationKey");
        selector.add("entry.replaceScale");
        selector.add("entry.validDate");
        selector.add("entry.invalidDate");
        selector.add("bomScope");
        selector.add("scopeEntry.id");
        selector.add("scopeEntry.bom.id");
        selector.add("entry.supplyOrgUnit.id");
        selector.add("entry.supplyOrgUnit.number");
        selector.add("entry.supplyOrgUnit.name");
        selector.add("entry.supplyOrgUnit.id");
        selector.add("entry.provideType");
        viewer.setSelector(selector);
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("storageOrgUnit.id");
        sort.setSortType(SortType.ASCEND);
        sorters.add(sort);
        sort = new SorterItemInfo("material.id");
        sort.setSortType(SortType.ASCEND);
        sorters.add(sort);
        sort = new SorterItemInfo("entry.replaceSeq");
        sort.setSortType(SortType.ASCEND);
        sorters.add(sort);
        sort = new SorterItemInfo("bomScope");
        sort.setSortType(SortType.ASCEND);
        sorters.add(sort);
        viewer.setSorter(sorters);
        MaterialReplaceCollection colls = MaterialReplaceFactory.getRemoteInstance().getMaterialReplaceCollection(viewer);
        MaterialReplaceInfo replaceInfo = null;
        MaterialReplaceScopeEntryCollection mrec = null;
        MaterialReplaceScopeEntryInfo scopeEntryInfo = null;
        Iterator it = colls.iterator();
        Date validDate = new Date();
        Date invalidDate = new Date();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        int bomScope = 0;
        MaterialReplaceEntryInfo entryInfo = null;
        boolean isHave = false;
        while (it.hasNext()) {
            isHave = false;
            replaceInfo = (MaterialReplaceInfo)it.next();
            MaterialReplaceEntryCollection replaceEntrys = replaceInfo.getEntry();
            Iterator ite = replaceEntrys.iterator();
            bomScope = replaceInfo.getBomScope().getValue();
            mrec = replaceInfo.getScopeEntry();
            for (int i = 0; i < mrec.size(); ++i) {
                scopeEntryInfo = mrec.get(i);
                if (bomId == null) break;
                if (!bomId.equals(scopeEntryInfo.getBom().getId().toString())) continue;
                isHave = true;
                break;
            }
            if (bomScope == 10) {
                if (isHave) {
                    it.remove();
                    continue;
                }
            } else if (!isHave && bomId != null) {
                it.remove();
                continue;
            }
            while (ite.hasNext()) {
                entryInfo = (MaterialReplaceEntryInfo)ite.next();
                try {
                    validDate = dtformat.parse(dtformat.format(entryInfo.getValidDate()));
                    invalidDate = dtformat.parse(dtformat.format(entryInfo.getInvalidDate()));
                    if (!reqDate.before(validDate) && !reqDate.equals(invalidDate) && !reqDate.after(invalidDate)) continue;
                    ite.remove();
                }
                catch (ParseException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (!replaceEntrys.isEmpty()) continue;
            it.remove();
        }
        MaterialReplaceCollection results = new MaterialReplaceCollection();
        if (bomId == null && colls != null && colls.size() > 0) {
            for (int i = 0; i < colls.size(); ++i) {
                MaterialReplaceInfo info = colls.get(i);
                if (info.getBomScope().getValue() != 10) continue;
                results.add(info);
            }
            colls = results;
        }
        return colls;
    }
}

