/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.client.AbstractPBomQueryUI;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class PBomQueryUI
extends AbstractPBomQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(PBomQueryUI.class);
    private boolean isProPBOM = false;

    public PBomQueryUI() throws Exception {
        this.prmtStorageOrgUnit.setRequired(true);
    }

    public PBomQueryUI(boolean isProPBOM) throws Exception {
        this.prmtStorageOrgUnit.setRequired(true);
        this.isProPBOM = isProPBOM;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_pbom_view");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_pbom_view");
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        this.prmtStorageOrgUnit.setRequired(true);
        UIHelper.registerProjectF7ForEdit(null, null, (KDBizPromptBox)this.prmtProjectNum);
        UIHelper.registerProjectF7ForEdit(null, null, (KDBizPromptBox)this.prmtProjectTo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new MMRangeFilterElement("material.number", (Component)this.prmtMaterialNumberFrom, (Component)this.prmtMaterialNumberTo));
        elements.add((FilterElement)new MMRangeFilterElement("number", (Component)this.prmtPBomNumberFrom, (Component)this.prmtPBomNumberTo));
        elements.add((FilterElement)new MMRangeFilterElement("routing.number", (Component)this.prmtStandardRootingFrom, (Component)this.prmtStandardRootingTo));
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, PBomQueryUI.getResource("STORAGEORG_ISNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.kDLabelContainer8.setVisible(false);
        this.kDLabelContainer9.setVisible(false);
        this.kDLabelContainer10.setVisible(false);
        this.prmtStartTrace.setVisible(false);
        this.prmtEndTrace.setVisible(false);
        this.textPartNumber.setVisible(false);
        this.contProjectNum.setVisible(false);
        this.contProjectTo.setVisible(false);
        this.prmtProjectNum.setVisible(false);
        this.prmtProjectTo.setVisible(false);
        if (this.isProPBOM) {
            this.contProjectNum.setVisible(true);
            this.contProjectTo.setVisible(true);
            this.prmtProjectNum.setVisible(true);
            this.prmtProjectTo.setVisible(true);
            elements.add((FilterElement)new MMRangeFilterElement("project.number", (Component)this.prmtProjectNum, (Component)this.prmtProjectTo));
            this.prmtProjectNum.setRequired(true);
            this.prmtProjectTo.setRequired(true);
        }
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtPBomNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtPBomNumberTo, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtStandardRootingFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtStandardRootingTo, this.getPropertyOfMainBizOrg());
        if (this.prmtStorageOrgUnit.getValue() != null) {
            this.initF7Material(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString());
        } else {
            this.initF7Material(null);
            this.initF7PBom(null);
            this.initF7Rooting(null);
        }
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtPBomNumberFrom, this.prmtPBomNumberTo, this.prmtStandardRootingFrom, this.prmtStandardRootingTo});
        OrgUnitInfo[] orgs = PBomQueryUI.getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), "mm_pbom_view");
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.length; ++i) {
            keys.add(orgs[i].getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isStorageOrgUnit", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtStorageOrgUnit.setEntityViewInfo(view);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    private void initF7Material(String id) {
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        String sid = null;
        if (orgInfo != null) {
            sid = orgInfo.getId().toString();
        }
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmtMaterialNumberFrom, false, materialPlanQuery);
        this.setBizMaterialF7(this.prmtMaterialNumberTo, false, materialPlanQuery);
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)sid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.status", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        this.prmtMaterialNumberFrom.setEntityViewInfo(entityViewInfo);
        this.prmtMaterialNumberTo.setEntityViewInfo(entityViewInfo);
        this.prmtMaterialNumberFrom.setEnabledMultiSelection(false);
        this.prmtMaterialNumberTo.setEnabledMultiSelection(false);
        this.prmtMaterialNumberFrom.getQueryAgent().resetRuntimeEntityView();
        this.prmtMaterialNumberTo.getQueryAgent().resetRuntimeEntityView();
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialNumberFrom, this.prmtMaterialNumberTo});
    }

    private void initF7Rooting(String id) {
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)id, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        this.prmtStandardRootingFrom.setEntityViewInfo(entityViewInfo);
        this.prmtStandardRootingTo.setEntityViewInfo(entityViewInfo);
    }

    private void initF7PBom(String id) {
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)id, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bom.name", null, CompareType.NOTEQUALS));
        entityViewInfo.setFilter(filterInfo);
        this.prmtPBomNumberFrom.setEntityViewInfo(entityViewInfo);
        this.prmtPBomNumberTo.setEntityViewInfo(entityViewInfo);
    }

    public void afterMainOrgChanged(String ids) {
        if (ids != null && !ids.trim().equals("")) {
            this.initF7Material(ids);
            this.initF7Rooting(ids);
            this.initF7PBom(ids);
        } else {
            this.initF7Material(null);
            this.initF7Rooting(null);
            this.initF7PBom(null);
        }
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.client.BasedataResource", (String)strKey);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected String getViewPermission() {
        return "mm_pbom_view";
    }

    public static OrgUnitInfo[] getAuthorizedBizOrgUnits(IObjectPK userPK, OrgType orgType, String permissionItem) {
        OrgUnitCollection collection = PBomQueryUI.getAuthOrgByPermItem(userPK, orgType, permissionItem);
        int size = collection.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = collection.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(IObjectPK userPK, OrgType orgType, String permItem) {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = null;
        FullOrgUnitCollection result = null;
        try {
            permission = PermissionFactory.getRemoteInstance();
            result = permission.getAuthorizedOrg(userPK, orgType, null, permItem);
        }
        catch (EASBizException e) {
            return collection;
        }
        catch (BOSException e) {
            return collection;
        }
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public boolean verify() {
        if (this.isProPBOM && this.prmtProjectNum.getValue() == null && this.prmtProjectTo.getValue() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0050"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

