/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.mm.basedata.AbilityImpropriateEnum;
import com.kingdee.eas.mm.basedata.AheadDateOptionEnum;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.BatchControlEnum;
import com.kingdee.eas.mm.basedata.DayCapacityGranularityEnum;
import com.kingdee.eas.mm.basedata.DayCapacityMethodEnum;
import com.kingdee.eas.mm.basedata.ExpandStrategyEnum;
import com.kingdee.eas.mm.basedata.IPriorityModel;
import com.kingdee.eas.mm.basedata.OrderFieldEnum;
import com.kingdee.eas.mm.basedata.OrderSeqEnum;
import com.kingdee.eas.mm.basedata.PLSModelFactory;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.PriorityModelCollection;
import com.kingdee.eas.mm.basedata.PriorityModelFactory;
import com.kingdee.eas.mm.basedata.PriorityModelInfo;
import com.kingdee.eas.mm.basedata.RequireSrcEnum;
import com.kingdee.eas.mm.basedata.SonLineExpandModeEnum;
import com.kingdee.eas.mm.basedata.client.AbstractPLSModelEditUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.action.EditTableSelectionHelper;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.action.ISupportObjContext;
import com.kingdee.eas.scm.common.action.ITableSelectionHelper;
import com.kingdee.eas.scm.common.action.SCMActionManager;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PLSModelEditUI
extends AbstractPLSModelEditUI
implements ISupportBatchAction,
ISupportObjContext {
    private static final Logger logger = CoreUIObject.getLogger(PLSModelEditUI.class);
    private StringBuffer default_orderField = new StringBuffer();
    private StringBuffer default_orderMode = new StringBuffer();
    private static final String SPLIT = "#";
    private String windowTitle = this.resHelper.getString("this.title");
    private DataChangeListener storageChanged = null;
    private DataChangeListener priorityModelChanged = null;
    private ChangeListener isSonLinePlanCalcStockChanged = null;
    private static final String TB_ORDERFIELD = "orderField";
    private static final String TB_ORDERMODE = "orderSeq";
    private static final String TB_ORDERFIELD_VALUE = "orderFieldValue";
    protected SCMActionManager actionManager = null;
    private EditTableSelectionHelper tableSelectionHelper;

    public PLSModelEditUI() throws Exception {
        this.initDefaultTaskOrder();
    }

    private void initDefaultTaskOrder() {
        Iterator iterator = OrderFieldEnum.iterator();
        while (iterator.hasNext()) {
            OrderFieldEnum orderField = (OrderFieldEnum)((Object)iterator.next());
            this.default_orderField.append(orderField.getValue()).append(SPLIT);
            this.default_orderMode.append(10).append(SPLIT);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_plsModel_addnew");
        this.aheadDay.setNegatived(false);
        this.aheadDay.setSupportedEmpty(false);
        this.initBatchActions();
        this.menuItemRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        KDComboBox orderModeBox = new KDComboBox();
        orderModeBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.mm.basedata.OrderSeqEnum").toArray());
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)orderModeBox);
        this.taskOrderEntry.getColumn(TB_ORDERMODE).setEditor((ICellEditor)cellEditor);
        String[] orderField = null;
        String[] orderMode = null;
        if (this.editData.getOrderField() != null) {
            orderField = this.editData.getOrderField().split(SPLIT);
        }
        if (this.editData.getOrderMode() != null) {
            orderMode = this.editData.getOrderMode().split(SPLIT);
        }
        if (orderField == null || orderMode == null || orderField.length != orderMode.length) {
            MsgBox.showInfo((String)this.getResource("entryDataError"));
            this.abort();
        }
        if (orderField != null) {
            for (int i = 0; i < orderField.length; ++i) {
                IRow row = this.taskOrderEntry.addRow();
                if (orderField[i] != null) {
                    row.getCell(TB_ORDERFIELD).setValue((Object)OrderFieldEnum.getEnum(new Integer(orderField[i])).getAlias(SysContext.getSysContext().getLocale()));
                }
                if (row.getCell(TB_ORDERMODE) != null && orderMode != null && orderMode[i] != null) {
                    row.getCell(TB_ORDERMODE).setValue((Object)OrderSeqEnum.getEnum(new Integer(orderMode[i])));
                }
                row.getCell(TB_ORDERFIELD_VALUE).setValue((Object)new Integer(orderField[i]));
            }
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.setUIToolBarStatus();
        this.initProductLineAllocate((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        if (this.isSonLinePlanCalcStock.isSelected()) {
            this.sonLineExpandMode.setEnabled(false);
        } else {
            this.sonLineExpandMode.setEnabled(true);
        }
        this.addListener();
    }

    private void addListener() {
        this.storageChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PLSModelEditUI.this.prmtstorageOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    PLSModelEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageChanged);
        this.priorityModelChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                PLSModelEditUI.this.priorityModelChanged(e);
            }
        };
        this.prmtPriorityModel.addDataChangeListener(this.priorityModelChanged);
        this.isSonLinePlanCalcStockChanged = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PLSModelEditUI.this.isSonLinePlanCalcStockChanged(e);
            }
        };
        this.isSonLinePlanCalcStock.addChangeListener(this.isSonLinePlanCalcStockChanged);
    }

    private void removeListener() {
        if (this.storageChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageChanged);
        }
        if (this.priorityModelChanged != null) {
            this.prmtPriorityModel.removeDataChangeListener(this.priorityModelChanged);
        }
        if (this.isSonLinePlanCalcStockChanged != null) {
            this.isSonLinePlanCalcStock.removeChangeListener(this.isSonLinePlanCalcStockChanged);
        }
    }

    private void prmtstorageOrgUnit_dataChanged(DataChangeEvent e) {
        StorageOrgUnitInfo newValue;
        StorageOrgUnitInfo oldValue = (StorageOrgUnitInfo)e.getOldValue();
        boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = (StorageOrgUnitInfo)e.getNewValue()));
        if (isDifferent) {
            if (newValue == null) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getResource("storageOrgNull"));
                this.prmtStorageOrgUnit.removeDataChangeListener(this.storageChanged);
                this.prmtStorageOrgUnit.setValue((Object)this.editData.getStorageOrgUnit());
                this.prmtStorageOrgUnit.addDataChangeListener(this.storageChanged);
                this.prmtStorageOrgUnit.requestFocus();
                return;
            }
            try {
                this.prmtProductLineAllocate.setValue(null);
                this.initProductLineAllocate(newValue);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void priorityModelChanged(DataChangeEvent e) {
        PriorityModelInfo oldVal = (PriorityModelInfo)e.getOldValue();
        PriorityModelInfo newVal = (PriorityModelInfo)e.getNewValue();
        if (newVal != null && !newVal.equals(oldVal)) {
            String priorityDesc = newVal.getDescription();
            this.priorityDesc.setText(priorityDesc);
        }
        if (newVal == null && oldVal != null) {
            this.priorityDesc.setText("");
        }
    }

    private void isSonLinePlanCalcStockChanged(ChangeEvent e) {
        if (this.isSonLinePlanCalcStock.isSelected()) {
            this.sonLineExpandMode.setEnabled(false);
            this.sonLineExpandMode.setSelectedItem((Object)SonLineExpandModeEnum.WholeToLowTierExpand);
        } else {
            this.sonLineExpandMode.setEnabled(true);
        }
    }

    private void initProductLineAllocate(StorageOrgUnitInfo orgInfo) {
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        if (orgInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        }
        eview.setFilter(filter);
        this.prmtProductLineAllocate.setEntityViewInfo(eview);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        StringBuffer orderField = new StringBuffer();
        StringBuffer orderMode = new StringBuffer();
        for (int i = 0; i < this.taskOrderEntry.getRowCount3(); ++i) {
            Integer orderFieldValue = (Integer)this.taskOrderEntry.getCell(i, TB_ORDERFIELD_VALUE).getValue();
            int orderModeValue = ((OrderSeqEnum)((Object)this.taskOrderEntry.getCell(i, TB_ORDERMODE).getValue())).getValue();
            orderField.append(OrderFieldEnum.getEnum(orderFieldValue).getValue()).append(SPLIT);
            orderMode.append(OrderSeqEnum.getEnum(orderModeValue).getValue()).append(SPLIT);
        }
        this.editData.setOrderField(orderField.toString());
        this.editData.setOrderMode(orderMode.toString());
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)this.windowTitle);
        this.setEntryButtonEnable();
        this.setScrollButtons();
        if (this.isSonLinePlanCalcStock.isSelected()) {
            this.sonLineExpandMode.setEnabled(false);
        } else {
            this.sonLineExpandMode.setEnabled(true);
        }
    }

    private void setScrollButtons() {
        int currentIndex = this.idList.getCurrentIndex();
        int nextIndex = currentIndex + 1;
        String nextId = this.idList.getID(nextIndex);
        if (nextId == null) {
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        }
    }

    protected void setEntryButtonEnable() {
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnMoveUp.setEnabled(true);
            this.btnMoveDown.setEnabled(true);
        } else {
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
        }
    }

    private void setUIToolBarStatus() {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnApprove.setEnabled(false);
            this.actionApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.actionUnApprove.setEnabled(false);
        } else if (this.editData.getId() != null) {
            if (this.editData.getStatus().getValue() == 10) {
                this.btnApprove.setEnabled(true);
                this.btnUnApprove.setEnabled(false);
                this.actionApprove.setEnabled(true);
                this.actionUnApprove.setEnabled(false);
            } else {
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(true);
                this.actionApprove.setEnabled(false);
                this.actionUnApprove.setEnabled(true);
            }
        }
    }

    protected IObjectValue createNewData() {
        PLSModelInfo objectValue = new PLSModelInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_plsModel_addnew"));
        objectValue.setStatus(BDStatusEnum.UNAPPROVE);
        objectValue.setDayAbilityGranu(DayCapacityGranularityEnum.classes);
        objectValue.setDayAbilityMetho(DayCapacityMethodEnum.positiveOrder);
        objectValue.setRequireSrc(RequireSrcEnum.MPSPlanOrder);
        objectValue.setAheadDay(0);
        objectValue.setSonLineExpandMode(SonLineExpandModeEnum.WholeToLowTierExpand);
        objectValue.setExpandStrategy(ExpandStrategyEnum.ByBOMExpand);
        objectValue.setBatchControl(BatchControlEnum.noByBatch);
        objectValue.setAbilityImpropriate(AbilityImpropriateEnum.APAndPOrder);
        objectValue.setIsDateBefAbility(true);
        objectValue.setIsSonLinePlanCalcStock(false);
        objectValue.setIsLessChange(false);
        objectValue.setAheadDateOption(AheadDateOptionEnum.startDate);
        objectValue.setOrderField(this.default_orderField.toString());
        objectValue.setOrderMode(this.default_orderMode.toString());
        IPriorityModel priority = null;
        PriorityModelCollection collection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        try {
            priority = PriorityModelFactory.getRemoteInstance();
            collection = priority.getPriorityModelCollection(viewInfo);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        if (collection.size() > 0) {
            objectValue.setPriorityModel(collection.get(0));
        }
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PLSModelFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        PLSModelInfo info = (PLSModelInfo)newData;
        info.setStatus(BDStatusEnum.UNAPPROVE);
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.PLSModelResource", (String)key);
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        int n = this.taskOrderEntry.getSelectManager().getActiveRowIndex();
        if (n > 0) {
            this.taskOrderEntry.moveRow(n, n - 1);
            this.taskOrderEntry.getSelectManager().select(n - 1, 1, 2);
            this.taskOrderEntry.getSelectManager().setActiveRowIndex(n - 1);
        }
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        int n = this.taskOrderEntry.getSelectManager().getActiveRowIndex();
        if (n < this.taskOrderEntry.getRowCount()) {
            this.taskOrderEntry.moveRow(n + 1, n);
            this.taskOrderEntry.getSelectManager().select(n + 1, 1, 2);
            this.taskOrderEntry.getSelectManager().setActiveRowIndex(n + 1);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (BDStatusEnum.APPROVE.equals((Object)this.editData.getStatus())) {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            this.setOprtState("VIEW");
            this.lockUIForViewStatus();
            AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)this.windowTitle);
        }
        this.editData.setSyncOldValue(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        block3: {
            if (this.editData.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
                MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"Msg_ApprovedCannotDelete"));
                this.abort();
            }
            try {
                super.actionRemove_actionPerformed(e);
            }
            catch (Exception ee) {
                if (!(ee instanceof ObjectReferedException)) break block3;
                this.handUIException(ee);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().getValue() == 20) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"Msg_ApprovedCannotEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo(TB_ORDERFIELD));
        sic.add(new SelectorItemInfo("orderMode"));
        return sic;
    }

    public ActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new SCMActionManager((CoreUIObject)this, ContextTypeEnum.INQUERYING);
            this.actionManager.setTableSelectionHelper((ITableSelectionHelper)this.getTableSelectionHelper());
            this.actionManager.setServiceContext(this.getServiceContext());
        }
        return this.actionManager;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PLSModelFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.taskOrderEntry, "id", this.txtNumber, null);
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.DELETE, (ItemAction)this.actionRemove, (String)"delete");
        this.actionManager.registerBatchAction(actionProxy, "actionRemove");
        actionProxy.bindTo((AbstractButton)this.btnRemove);
        actionProxy.bindTo((AbstractButton)this.menuItemRemove);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("UPAPPROVE"), (ItemAction)this.actionUnApprove, (String)"unApprove");
        this.actionManager.registerBatchAction(actionProxy, "actionUnApprove");
        actionProxy.bindTo((AbstractButton)this.btnUnApprove);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("APPROVE"), (ItemAction)this.actionApprove, (String)"approve");
        this.actionManager.registerBatchAction(actionProxy, "actionApprove");
        actionProxy.bindTo((AbstractButton)this.btnApprove);
    }

    public EditTableSelectionHelper getTableSelectionHelper() {
        if (this.tableSelectionHelper == null) {
            this.tableSelectionHelper = new EditTableSelectionHelper();
        }
        return this.tableSelectionHelper;
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        return true;
    }

    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
        if (countSuccess == 0) {
            return;
        }
        if (this.idList == null) {
            return;
        }
        String id = this.editData.getId().toString();
        if (bizAction.equals((Object)BatchActionEnum.DELETE)) {
            if (this.idList.size() > 1) {
                this.editData = null;
                if (this.actionNext.isEnabled()) {
                    try {
                        this.actionNext_actionPerformed(null);
                    }
                    catch (Exception e) {
                        this.handUIExceptionAndAbort(e);
                    }
                } else {
                    try {
                        this.actionPre_actionPerformed(null);
                    }
                    catch (Exception e) {
                        this.handUIExceptionAndAbort(e);
                    }
                }
                this.idList.remove(id, false);
                this.initScrollButtons();
            } else {
                this.idList.remove(id, false);
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(id);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this.setOprtState("ADDNEW");
                IObjectValue value = this.createNewData();
                if (value != null) {
                    this.setDataObject(value);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.confirm_close"));
                    this.destroyWindow();
                }
                this.loadFields();
                if (this.idList.size() == 0) {
                    this.actionEdit.setEnabled(false);
                }
            }
            this.setSave(true);
            this.setSaved(true);
        }
        if (bizAction.equals((Object)new BatchActionEnum("APPROVE")) || bizAction.equals((Object)new BatchActionEnum("UPAPPROVE"))) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            try {
                this.setDataObject(this.getValue((IObjectPK)pk));
                this.setOprtState("VIEW");
                this.loadFields();
                this.initOldData((IObjectValue)this.editData);
                this.setSave(true);
                this.setSaved(true);
                this.initDataStatus();
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
    }

    public void doActionPerformed(BatchActionEnum bizAction, BatchSelectionEntries selectionEntry) {
    }

    public void refresh(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
    }

    public void handleBatchException(ActionProxy actionProxy, BatchSelectionEntries selectionEntry) throws Exception {
    }

    public Context getMainContext() {
        return this.getMainOrgContext();
    }
}

