/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.IPlanVersionSet;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.basedata.client.AbstractPlanVersionSetListUI;
import com.kingdee.eas.mm.common.client.MMSpecialLicenseAdapter;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlanVersionSetListUI
extends AbstractPlanVersionSetListUI {
    private static final Logger logger = CoreUIObject.getLogger(PlanVersionSetListUI.class);
    String strPath = "com.kingdee.eas.mm.common.MMResource";
    String strPathPlan = "com.kingdee.eas.mm.basedata.PlanVersionSetResource";
    private MMSpecialLicenseAdapter licenseAdapter = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int status;
        this.checkSelected();
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(row);
        BizEnumValueDTO bizDo = (BizEnumValueDTO)iRow.getCell("status").getValue();
        if (bizDo != null && (status = new Integer((String)bizDo.getValue()).intValue()) == 20) {
            String strMsgOrg = EASResource.getString((String)this.strPath, (String)"hasApproveNoEdit");
            MsgBox.showInfo((Component)((Object)this), (String)strMsgOrg);
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        for (int i = 0; i < idList.size(); ++i) {
            boolean isCanRemove = ((IPlanVersionSet)this.getBizInterface()).removeCheck((String)idList.get(i));
            if (!isCanRemove) continue;
            String strMsgOrg = EASResource.getString((String)this.strPathPlan, (String)"selectedRemove");
            MsgBox.showInfo((Component)((Object)this), (String)strMsgOrg);
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        ObjectUuidPK[] pks = new ObjectUuidPK[ids.size()];
        int index = 0;
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            pks[index++] = new ObjectUuidPK(id);
        }
        try {
            ((IPlanVersionSet)this.getBizInterface()).pubFireVOChangeListener(ids, true);
            ((IPlanVersionSet)this.getBizInterface()).approve((IObjectPK[])pks);
            String msg = EASResource.getString((String)this.strPathPlan, (String)"planApproveSuccee");
            MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
            this.refresh(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            ((IPlanVersionSet)this.getBizInterface()).pubFireVOChangeListener(ids, false);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        this.execQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int index = 0;
        ObjectUuidPK[] pks = new ObjectUuidPK[ids.size()];
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            pks[index++] = new ObjectUuidPK(id);
        }
        try {
            ((IPlanVersionSet)this.getBizInterface()).pubFireVOChangeListener(ids, true);
            ((IPlanVersionSet)this.getBizInterface()).unApprove((IObjectPK[])pks);
            String msg = EASResource.getString((String)this.strPathPlan, (String)"unApproveSuccee");
            MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
            this.refresh(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            ((IPlanVersionSet)this.getBizInterface()).pubFireVOChangeListener(ids, false);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    private void mergeColumns() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"storageOrgUnit.name", "name", "number"};
        return columns;
    }

    private void checkSpecialLicense(String planMode) {
        String fullName = "com.kingdee.eas.mm.basedata.client.PlanVersionSetListUI";
        if (planMode != null) {
            if (planMode.equalsIgnoreCase("MRP")) {
                fullName = fullName + "_MRP";
            } else if (planMode.equalsIgnoreCase("MPS")) {
                fullName = fullName + "_MPS";
            } else if (planMode.equalsIgnoreCase("PLS")) {
                fullName = fullName + "_PLS";
            } else if (planMode.equalsIgnoreCase("PDM")) {
                fullName = fullName + "_PDM";
            }
            this.licenseAdapter = new MMSpecialLicenseAdapter(fullName, EASResource.getString((String)"com.kingdee.eas.mm.basedata.BASEDATAAutoGenerateResource", (String)"52_PlanVersionSetListUI"));
            try {
                this.licenseAdapter.checkLicence();
            }
            catch (Exception e) {
                this.abort();
            }
        }
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (b && this.licenseAdapter != null) {
            this.licenseAdapter.releaseLicense();
        }
        return b;
    }

    public void onLoad() throws Exception {
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        this.checkSpecialLicense(uiParam);
        this.mergeColumns();
        super.onLoad();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        Map uiContext = this.getUIContext();
        if (uiContext.get("sourceID") != null && uiContext.get("sourceID").equals("InitMmParamsUI")) {
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(900));
            set.add(new Integer(901));
            set.add(new Integer(902));
            set.add(new Integer(903));
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((String)uiContext.get("storageOrgUnitID")), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        } else {
            FilterInfo storageOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", (String)"mm_PlanVersionSet_view");
            try {
                filter.mergeFilter(storageOrgFilter, "AND");
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        return filter;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"Storage");
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK orgPK = null;
        String actoinName = null;
        if (action != null) {
            actoinName = action.getClass().getName();
        }
        if (actoinName != null && actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        if (actoinName != null && actoinName.equals("ActionEdit")) {
            String id = this.getSelectedKeyValue();
            if (id == null) {
                return super.getOrgPK(action);
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            PlanVersionSetInfo planVersionSetInfo = null;
            try {
                planVersionSetInfo = (PlanVersionSetInfo)this.getBizInterface().getValue((IObjectPK)pk);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (planVersionSetInfo != null && planVersionSetInfo.getStorageOrgUnit() != null) {
                orgPK = new ObjectUuidPK(planVersionSetInfo.getStorageOrgUnit().getId());
            }
        } else {
            orgPK = super.getOrgPK(action);
        }
        return orgPK;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PlanVersionSetFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }
}

