/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.IPlanningHorizonSet;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetFactory;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetInfo;
import com.kingdee.eas.mm.basedata.client.AbstractPlanningHorizonSetListUI;
import com.kingdee.eas.mm.basedata.client.PlanningHorizonSetEditUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlanningHorizonSetListUI
extends AbstractPlanningHorizonSetListUI {
    private static final String RESOURCE_HORIZON = "com.kingdee.eas.mm.basedata.PlanningHorizonSetResource";
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.mm.basedata.client.BasedataResource";
    private static final long serialVersionUID = -3748619851282400706L;
    private static final Logger logger = CoreUIObject.getLogger(PlanningHorizonSetListUI.class);

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PlanningHorizonSetFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        PlanningHorizonSetInfo objectValue = new PlanningHorizonSetInfo();
        return objectValue;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public String getUITitle() {
        return EASResource.getString((String)RESOURCE_FULLNAME, (String)"PlanningHorizonSetQueryF7WindowTitle");
    }

    @Override
    protected String getEditUIName() {
        return PlanningHorizonSetEditUI.class.getName();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkBeforeEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkBeforeEdit() throws Exception {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int rowIndex = selectedRows[0];
        int columnIndex = this.tblMain.getColumnIndex("id");
        columnIndex = this.tblMain.getColumnIndex("number");
        String number = this.tblMain.getTextAt(rowIndex, columnIndex).toString();
        columnIndex = this.tblMain.getColumnIndex("status");
        String isApproved = this.tblMain.getTextAt(rowIndex, columnIndex).toString();
        if (isApproved.trim().equals(BDStatusEnum.APPROVE.toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_HORIZON, (String)"CANNOTEDIT_FORAPPROVED"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id"));
        for (int i = 0; i < pks.length; ++i) {
            try {
                this.setOprtState("AUDIT");
                this.pubFireVOChangeListener(pks[i].toString());
                continue;
            }
            catch (Throwable e1) {
                this.handUIException(e1);
                SysUtil.abort();
            }
        }
        try {
            IPlanningHorizonSet svc = (IPlanningHorizonSet)this.getBizInterface();
            String error = svc.approve(pks);
            if (error != null) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"msg_approve_error"), (String)error, (int)8188);
            } else {
                MMUtils.showInformation((CoreUI)this, (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgApproveSuccee"), (int)2);
            }
            this.refreshList();
        }
        catch (Throwable ex) {
            this.handUIException(ex);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                for (int i = 0; i < pks.length; ++i) {
                    this.pubFireVOChangeListener(pks[i].toString());
                }
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id"));
        for (int i = 0; i < pks.length; ++i) {
            try {
                this.setOprtState("AUDIT");
                this.pubFireVOChangeListener(pks[i].toString());
                continue;
            }
            catch (Throwable e1) {
                this.handUIException(e1);
                SysUtil.abort();
            }
        }
        try {
            IPlanningHorizonSet svc = (IPlanningHorizonSet)this.getBizInterface();
            String error = svc.unApprove(pks);
            if (error != null) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"msg_unapprove_error"), (String)error, (int)8188);
            } else {
                MMUtils.showInformation((CoreUI)this, (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgUnApproveSuccee"), (int)2);
            }
            this.refreshList();
        }
        catch (Throwable ex) {
            this.handUIException(ex);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                for (int i = 0; i < pks.length; ++i) {
                    this.pubFireVOChangeListener(pks[i].toString());
                }
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        this.execQuery();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        Map uiContext = this.getUIContext();
        if (uiContext.get("sourceID") != null && uiContext.get("sourceID").equals("InitMmParamsUI")) {
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(901));
            set.add(new Integer(902));
            set.add(new Integer(900));
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((String)uiContext.get("storageOrgUnitID")), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        } else {
            FilterInfo storageOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", (String)"mm_PlanningHorizonSet_view");
            try {
                filter.mergeFilter(storageOrgFilter, "AND");
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        return filter;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionRemove_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK orgPK = null;
        String actoinName = null;
        if (action != null) {
            actoinName = action.getClass().getName();
        }
        if (actoinName != null && actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        if (actoinName != null && actoinName.equals("ActionEdit")) {
            String id = this.getSelectedKeyValue();
            if (id == null) {
                return super.getOrgPK(action);
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            PlanningHorizonSetInfo planningHorizonSetInfo = null;
            try {
                planningHorizonSetInfo = (PlanningHorizonSetInfo)this.getBizInterface().getValue((IObjectPK)pk);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (planningHorizonSetInfo != null && planningHorizonSetInfo.getStorageOrgUnit() != null) {
                orgPK = new ObjectUuidPK(planningHorizonSetInfo.getStorageOrgUnit().getId());
            }
        } else {
            orgPK = super.getOrgPK(action);
        }
        return orgPK;
    }
}

