/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.IProductLineDayYield;
import com.kingdee.eas.mm.basedata.OprStatusEnum;
import com.kingdee.eas.mm.basedata.PLSTypeEnum;
import com.kingdee.eas.mm.basedata.ProductLineCollection;
import com.kingdee.eas.mm.basedata.ProductLineDayYieldCollection;
import com.kingdee.eas.mm.basedata.ProductLineDayYieldFactory;
import com.kingdee.eas.mm.basedata.ProductLineDayYieldInfo;
import com.kingdee.eas.mm.basedata.ProductLineDayYieldPeriodInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.client.AbstractProductLineDayYieldEditUI;
import com.kingdee.eas.mm.basedata.client.ProductLineDayYieldConditionUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.control.client.TableCellComparator;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class ProductLineDayYieldEditUI
extends AbstractProductLineDayYieldEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductLineDayYieldEditUI.class);
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.mm.basedata.ProductLineDayYieldResource";
    private static final String DAYYIELD_PROPERTY_WORKDATE_KEY = "workDate";
    private static final String DAYYIELD_PROPERTY_WORKDAY_KEY = "workDay";
    private static final String DAYYIELD_PROPERTY_PRODUCTLINE_CODE_KEY = "productLine.code";
    private static final String DAYYIELD_PROPERTY_PRODUCTLINE_NAME_KEY = "productLine.name";
    private static final String DAYYIELD_PROPERTY_DAYYIELD_KEY = "dayYield";
    private static final String DAYYIELD_PROPERTY_UOM_KEY = "productLine.uom";
    private static final String DAYYIELD_PROPERTY_SCHEDULETYPE = "scheduleType";
    private ProductLineDayYieldCollection tableData = null;
    private static final Color COLOR_WORK = Color.WHITE;
    private static final Color COLOR_REST = new Color(255, 255, 193);
    private static final Color COLOR_LOCK = new Color(255, 255, 193);
    private static final Color COLOR_UNLOCK = Color.WHITE;
    private static final float CALC_DAY_SPACE_NUM = 8.64E7f;
    private static final int DAY_UP_ENJOIN = 31;
    private boolean modified = false;
    private int sort = 0;

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.btnSave.setEnabled(modified);
    }

    private void sortForTable(KDTMouseEvent e, KDTable kdtable) {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            KDTSortManager sm = new KDTSortManager(kdtable);
            this.sort = this.sort == 0 ? 1 : 0;
            sm.sort(e.getColIndex(), this.sort);
            if (kdtable.getBody().getRows() == null || kdtable.getBody().getRows().size() <= 0) {
                return;
            }
            List rows = kdtable.getBody().getRows();
            Collections.sort(rows, new TableCellComparator(e.getColIndex(), this.sort));
            kdtable.setRefresh(true);
        }
    }

    @Override
    protected void tableMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.sortForTable(e, this.tableMain);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"Storage");
    }

    protected void promptSaveOperation() throws Exception {
        if (this.isModified()) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("AskWantSave")) == 0) {
                this.saveDayYield();
            } else {
                this.setModified(false);
            }
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        this.promptSaveOperation();
        if (this.pmptStorageOrgUnit.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"StorageOrgIsNull"));
            this.pmptStorageOrgUnit.requestFocusInWindow();
            return;
        }
        if (this.dateStartDate.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"StartDateIsNull"));
            this.dateStartDate.requestFocusInWindow();
            return;
        }
        if (this.dateEndDate.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"EndDateIsNull"));
            this.dateEndDate.requestFocusInWindow();
            return;
        }
        String orgUnitID = null;
        String productLineID = null;
        Date startDate = null;
        Date endDate = null;
        orgUnitID = ((StorageOrgUnitInfo)this.pmptStorageOrgUnit.getData()).getId().toString();
        ProductLineInfo productLineInfo = (ProductLineInfo)this.cmbProductLine.getSelectedItem();
        if (productLineInfo != null && productLineInfo.getName() != null) {
            productLineID = productLineInfo.getId().toString();
        }
        startDate = (Date)this.dateStartDate.getValue();
        endDate = (Date)this.dateEndDate.getValue();
        IProductLineDayYield dayYieldInterface = this.getRemoteInterface();
        Map result = dayYieldInterface.getProductLineDayYield(orgUnitID, productLineID, startDate, endDate);
        this.tableData = (ProductLineDayYieldCollection)((Object)result.get("ProductLineDayYield"));
        ProductLineInfo selectItem = (ProductLineInfo)this.cmbProductLine.getSelectedItem();
        this.initProductLineComboList((ProductLineCollection)((Object)result.get("ProductLine")));
        if (selectItem != null && selectItem.getId() != null) {
            for (int nIndex = 0; nIndex < this.cmbProductLine.getItemCount(); ++nIndex) {
                ProductLineInfo productLine = (ProductLineInfo)this.cmbProductLine.getItemAt(nIndex);
                if (productLine == null || productLine.getId() == null || !productLine.getId().toString().equals(selectItem.getId().toString())) continue;
                this.cmbProductLine.setSelectedItem((Object)selectItem);
            }
        }
        this.fillTableBody(this.tableData);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    @Override
    protected void cmbProductLine_itemStateChanged(ItemEvent e) throws Exception {
    }

    @Override
    protected void pmptStorageOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.pmptStorageOrgUnit.getValue();
        if (orgUnitInfo == null) {
            this.clearTableView();
            this.cmbProductLine.removeAllItems();
            this.txtPLDYPeriod.setText("");
            return;
        }
        IProductLineDayYield productLineDayYieldInterface = ProductLineDayYieldFactory.getRemoteInstance();
        ProductLineCollection productLineCollection = productLineDayYieldInterface.getProductLineCollectionByStorageOrgUnit(orgUnitInfo.getId().toString());
        this.initProductLineComboList(productLineCollection);
        ProductLineDayYieldPeriodInfo period = productLineDayYieldInterface.getProductLineDayYieldPeriod(orgUnitInfo.getId().toString());
        this.refreshDayYieldPeriod(period);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setModified(false);
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_distributedeletcalog"));
        this.menuItemRemove.setIcon(EASResource.getIcon((String)"imgTbtn_distributedeletcalog"));
        this.buildTableHeader();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.pmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_productlinedayyield_search");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_productlinedayyield_search");
        IStorageOrgUnit storageOrgUnitInterface = StorageOrgUnitFactory.getRemoteInstance();
        this.pmptStorageOrgUnit.setValue((Object)orgInfo);
        Date startDate = null;
        Date endDate = null;
        Date currentDate = new Date(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.set(5, 1);
        startDate = calendar.getTime();
        calendar.add(2, 1);
        calendar.add(5, -1);
        endDate = calendar.getTime();
        this.dateStartDate.setValue((Object)startDate);
        this.dateEndDate.setValue((Object)endDate);
        if (orgInfo == null) {
            this.cmbProductLine.setEnabled(false);
            this.lblPLDYPeriod.setVisible(false);
            return;
        }
        this.fillProductLineToComboList(orgInfo);
        IProductLineDayYield productLineDayYieldInterface = ProductLineDayYieldFactory.getRemoteInstance();
        ProductLineDayYieldPeriodInfo period = productLineDayYieldInterface.getProductLineDayYieldPeriod(orgInfo.getId().toString());
        this.refreshDayYieldPeriod(period);
        this.tableMain.getActionMap().put("Delete", null);
        this.addTotalAbility();
    }

    @Override
    protected void tableMain_editStopped(KDTEditEvent e) throws Exception {
        Object newValue;
        int nRowIndex = e.getRowIndex();
        int nColIndex = e.getColIndex();
        Object oldValue = e.getOldValue();
        if (oldValue == (newValue = e.getValue())) {
            return;
        }
        IRow curRow = this.tableMain.getRow(nRowIndex);
        IColumn curCol = this.tableMain.getColumn(nColIndex);
        ICell curCell = this.tableMain.getCell(nRowIndex, nColIndex);
        ProductLineDayYieldInfo dayYieldInfo = (ProductLineDayYieldInfo)curRow.getUserObject();
        if (dayYieldInfo == null) {
            return;
        }
        if (curCol.getKey().equals(DAYYIELD_PROPERTY_WORKDAY_KEY)) {
            if (((Boolean)curCell.getValue()).booleanValue()) {
                dayYieldInfo.setWorkDay(WorkDateTypeEnum.WORKDAY);
            } else {
                dayYieldInfo.setWorkDay(WorkDateTypeEnum.RESTDAY);
            }
        }
        if (curCol.getKey().equals(DAYYIELD_PROPERTY_SCHEDULETYPE)) {
            if (newValue.equals((Object)PLSTypeEnum.SHIFTABILITY)) {
                dayYieldInfo.setDayYield(null);
                curRow.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY).setValue(null);
            } else {
                curRow.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY).setValue((Object)new BigDecimal(0));
            }
            dayYieldInfo.setScheduleType((PLSTypeEnum)((Object)newValue));
            this.replacePLSType(curRow, dayYieldInfo, false);
        }
        if (curCol.getKey().equals(DAYYIELD_PROPERTY_DAYYIELD_KEY)) {
            String dayYield = null;
            if (newValue != null) {
                dayYield = newValue.toString();
            }
            if (dayYield != null && !dayYield.equals("")) {
                int precision = dayYieldInfo.getProductLine().getUnit().getQtyPrecision();
                BigDecimal value = new BigDecimal(dayYield);
                BigDecimal newVal = value.setScale(precision, 4);
                curCell.setValue((Object)newVal);
                dayYieldInfo.setDayYield(newVal);
                IRow row = this.tableMain.getFootManager().getFootRow(0);
                BigDecimal totalVal = (BigDecimal)row.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY).getValue();
                totalVal = this.count(totalVal, (BigDecimal)oldValue, (BigDecimal)newValue);
                row.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY).setValue((Object)totalVal);
            } else {
                dayYieldInfo.setDayYield(null);
            }
        }
        dayYieldInfo.setStatus(OprStatusEnum.MODIFIED);
        this.setModified(true);
    }

    private void replaceWorkDay(IRow row, WorkDateTypeEnum workDayType) {
        if (row == null) {
            return;
        }
        boolean isWorkDay = false;
        switch (workDayType.getValue()) {
            case 1: {
                isWorkDay = true;
                row.getStyleAttributes().setBackground(COLOR_WORK);
                break;
            }
            case 3: {
                isWorkDay = false;
                row.getStyleAttributes().setBackground(COLOR_REST);
                break;
            }
            default: {
                isWorkDay = false;
                row.getStyleAttributes().setBackground(COLOR_REST);
            }
        }
        row.getCell(DAYYIELD_PROPERTY_SCHEDULETYPE).getStyleAttributes().setLocked(!isWorkDay);
        row.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY).getStyleAttributes().setLocked(!isWorkDay);
    }

    private void replacePLSType(IRow row, ProductLineDayYieldInfo dayYieldInfo, boolean selfValue) throws Exception {
        if (dayYieldInfo.getScheduleType() == null) {
            return;
        }
        ICell workDay = row.getCell(DAYYIELD_PROPERTY_WORKDAY_KEY);
        ICell dayYieldCell = row.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY);
        ICell uomCell = row.getCell(DAYYIELD_PROPERTY_UOM_KEY);
        boolean isWorkDay = false;
        if (dayYieldInfo.getWorkDay() != null) {
            isWorkDay = dayYieldInfo.getWorkDay().equals((Object)WorkDateTypeEnum.WORKDAY);
        }
        Object newValue = null;
        Object oldValue = null;
        if (isWorkDay && dayYieldInfo.getScheduleType().equals((Object)PLSTypeEnum.DAYABILITY)) {
            dayYieldCell.getStyleAttributes().setLocked(false);
            dayYieldCell.getStyleAttributes().setBackground(COLOR_UNLOCK);
            uomCell.getStyleAttributes().setBackground(COLOR_UNLOCK);
            ProductLineDayYieldInfo info = ProductLineDayYieldFactory.getRemoteInstance().getProductLineDayYieldInfo((IObjectPK)new ObjectUuidPK(dayYieldInfo.getId().toString()));
            if (selfValue) {
                dayYieldCell.setValue((Object)info.getDayYield());
            } else {
                dayYieldCell.setValue((Object)dayYieldInfo.getProductLine().getDayAbility());
            }
            uomCell.setValue((Object)dayYieldInfo.getProductLine().getUnit());
        } else {
            dayYieldCell.setValue(null);
            dayYieldCell.getStyleAttributes().setLocked(true);
            dayYieldCell.getStyleAttributes().setBackground(COLOR_LOCK);
            uomCell.getStyleAttributes().setBackground(COLOR_LOCK);
            uomCell.setValue(null);
        }
    }

    private BigDecimal count(BigDecimal total, BigDecimal oldValue, BigDecimal newValue) {
        BigDecimal result = total.subtract(oldValue);
        result = result.add(newValue);
        return result;
    }

    private void buildTableHeader() {
        this.tableMain.removeHeadRows();
        this.tableMain.removeColumns();
        this.tableMain.removeRows();
        IRow iRow = this.tableMain.addHeadRow();
        String[] tableHeader = new String[]{DAYYIELD_PROPERTY_WORKDATE_KEY, DAYYIELD_PROPERTY_WORKDAY_KEY, DAYYIELD_PROPERTY_PRODUCTLINE_CODE_KEY, DAYYIELD_PROPERTY_PRODUCTLINE_NAME_KEY, DAYYIELD_PROPERTY_SCHEDULETYPE, DAYYIELD_PROPERTY_DAYYIELD_KEY, DAYYIELD_PROPERTY_UOM_KEY};
        for (int nIndex = 0; nIndex < tableHeader.length; ++nIndex) {
            String key = tableHeader[nIndex];
            IColumn column = this.tableMain.addColumn();
            column.setKey(key);
            column.setSortable(true);
            iRow.getCell(key).setValue((Object)this.getResource(key));
            if (key.equals(DAYYIELD_PROPERTY_DAYYIELD_KEY)) {
                KDFormattedTextField numberTextField = new KDFormattedTextField();
                numberTextField.setDataType(6);
                KDTDefaultCellEditor numberFieldEditor = new KDTDefaultCellEditor((JTextField)numberTextField);
                column.setEditor((ICellEditor)numberFieldEditor);
                continue;
            }
            if (key.equals(DAYYIELD_PROPERTY_SCHEDULETYPE)) {
                KDComboBox comboBox = new KDComboBox();
                Iterator iterator = PLSTypeEnum.iterator();
                while (iterator.hasNext()) {
                    comboBox.addItem(iterator.next());
                }
                KDTDefaultCellEditor comboBoxEditor = new KDTDefaultCellEditor((JComboBox)comboBox);
                column.setEditor((ICellEditor)comboBoxEditor);
                column.getStyleAttributes().setHided(true);
                continue;
            }
            if (!key.equals(DAYYIELD_PROPERTY_PRODUCTLINE_NAME_KEY)) continue;
            column.setWidth(300);
        }
        this.tableMain.refresh();
    }

    private void fillTableBody(ProductLineDayYieldCollection dayYieldCollection) throws Exception {
        this.tableMain.removeRows();
        this.tableMain.getMergeManager().setMergeMode(3);
        BigDecimal count = new BigDecimal(0);
        for (int nIndex = 0; nIndex < dayYieldCollection.size(); ++nIndex) {
            ProductLineDayYieldInfo dayYieldInfo = dayYieldCollection.get(nIndex);
            if (dayYieldInfo == null) continue;
            IRow curRow = this.tableMain.addRow();
            curRow.setUserObject((Object)dayYieldInfo);
            ICell cell = curRow.getCell(DAYYIELD_PROPERTY_WORKDATE_KEY);
            DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
            cell.getStyleAttributes().setLocked(true);
            cell.setValue((Object)dtformat.format(dayYieldInfo.getWorkDate()));
            cell = curRow.getCell(DAYYIELD_PROPERTY_WORKDAY_KEY);
            if (dayYieldInfo.getWorkDay() == WorkDateTypeEnum.WORKDAY) {
                cell.setValue((Object)new Boolean(true));
                count = count.add(dayYieldInfo.getDayYield());
            } else {
                cell.setValue((Object)new Boolean(false));
            }
            ProductLineInfo productLineInfo = dayYieldInfo.getProductLine();
            if (productLineInfo == null) continue;
            cell = curRow.getCell(DAYYIELD_PROPERTY_PRODUCTLINE_CODE_KEY);
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            cell.getStyleAttributes().setLocked(true);
            cell.setValue((Object)productLineInfo.getNumber());
            cell = curRow.getCell(DAYYIELD_PROPERTY_PRODUCTLINE_NAME_KEY);
            cell.setValue((Object)productLineInfo.getName());
            cell.getStyleAttributes().setLocked(true);
            cell = curRow.getCell(DAYYIELD_PROPERTY_SCHEDULETYPE);
            cell.setValue((Object)dayYieldInfo.getScheduleType());
            cell.getStyleAttributes().setLocked(true);
            cell = curRow.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY);
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            KDFormattedTextField numberTextField = new KDFormattedTextField();
            numberTextField.setDataType(1);
            numberTextField.setNegatived(false);
            numberTextField.setPrecision(dayYieldInfo.getProductLine().getUnit().getQtyPrecision());
            cell.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            KDTDefaultCellEditor numberFieldEditor = new KDTDefaultCellEditor((JTextField)numberTextField);
            cell.setEditor((ICellEditor)numberFieldEditor);
            cell.setValue((Object)dayYieldInfo.getDayYield());
            cell.getStyleAttributes().setLocked(false);
            cell = curRow.getCell(DAYYIELD_PROPERTY_UOM_KEY);
            cell.getStyleAttributes().setLocked(true);
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            cell.setValue((Object)productLineInfo.getUnit());
            this.replaceWorkDay(curRow, dayYieldInfo.getWorkDay());
            this.replacePLSType(curRow, dayYieldInfo, true);
        }
        this.addTotalAbility(count);
    }

    private void addTotalAbility() {
        this.addTotalAbility(new BigDecimal(0));
    }

    private void addTotalAbility(BigDecimal value) {
        KDTFootManager footRowManager = this.tableMain.getFootManager();
        IRow footRow = null;
        if (footRowManager == null) {
            footRowManager = new KDTFootManager(this.tableMain);
            footRowManager.addFootView();
            this.tableMain.setFootManager(footRowManager);
        }
        if ((footRow = footRowManager.getFootRow(0)) == null) {
            footRow = footRowManager.addFootRow(0);
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            this.tableMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tableMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
        }
        ICell cell = footRow.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY);
        KDFormattedTextField numberTextField = new KDFormattedTextField();
        numberTextField.setDataType(1);
        cell.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        KDTDefaultCellEditor numberFieldEditor = new KDTDefaultCellEditor((JTextField)numberTextField);
        cell.setEditor((ICellEditor)numberFieldEditor);
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setLocked(false);
        cell.setValue((Object)value);
    }

    private void refreshDayYieldPeriod(ProductLineDayYieldPeriodInfo period) throws Exception {
        this.lblPLDYPeriod.setVisible(true);
        if (period == null) {
            this.txtPLDYPeriod.setText(this.getResource("NoDate"));
        } else {
            this.txtPLDYPeriod.setText(period.getDownPeriod() + "----" + period.getUpPeriod());
        }
    }

    private void fillProductLineToComboList(StorageOrgUnitInfo orgUnitInfo) throws Exception {
        this.cmbProductLine.removeAllItems();
        this.cmbProductLine.setEnabled(true);
        if (orgUnitInfo == null) {
            return;
        }
        IProductLineDayYield dayYieldInterface = ProductLineDayYieldFactory.getRemoteInstance();
        ProductLineCollection productLineCollection = dayYieldInterface.getProductLineCollectionByStorageOrgUnit(orgUnitInfo.getId().toString());
        this.initProductLineComboList(productLineCollection);
    }

    private void initProductLineComboList(ProductLineCollection productLineCollection) {
        this.cmbProductLine.removeAllItems();
        if (productLineCollection == null) {
            this.cmbProductLine.setEnabled(false);
        } else {
            this.cmbProductLine.setEnabled(true);
            this.cmbProductLine.addItem((Object)new ProductLineInfo());
            for (int nIndex = 0; nIndex < productLineCollection.size(); ++nIndex) {
                ProductLineInfo productLine = productLineCollection.get(nIndex);
                this.cmbProductLine.addItem((Object)productLine);
            }
        }
        this.cmbProductLine.setSelectedItem(null);
    }

    private String getResource(String key) {
        return EASResource.getString((String)RESOURCE_FULLNAME, (String)key);
    }

    @Override
    public void actionGenDayYield_actionPerformed(ActionEvent e) throws Exception {
        this.promptSaveOperation();
        ProductLineDayYieldConditionUI objUI = this.showConditionEditDlg(null);
        if (!objUI.isOK()) {
            return;
        }
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)objUI.pmptStorageOrgUnit.getValue();
        Date startDate = (Date)objUI.dateStartDate.getValue();
        Date endDate = (Date)objUI.dateEndDate.getValue();
        boolean dataExists = this.getRemoteInterface().checkExistDate(orgInfo.getId().toString(), startDate, endDate);
        int decision = 0;
        if (dataExists) {
            decision = MsgBox.showConfirm3((Component)((Object)this), (String)this.getResource("AskExistDate"));
        }
        ProductLineDayYieldPeriodInfo period = null;
        IProductLineDayYield dayYieldInterface = ProductLineDayYieldFactory.getRemoteInstance();
        switch (decision) {
            case 0: {
                period = dayYieldInterface.genProductLineDayYield(orgInfo.getId().toString(), startDate, endDate, true);
                break;
            }
            case 1: {
                period = dayYieldInterface.genProductLineDayYield(orgInfo.getId().toString(), startDate, endDate, false);
                break;
            }
            case 2: {
                return;
            }
            default: {
                return;
            }
        }
        MsgBox.showInfo((Component)((Object)this), (String)this.getResource("GenDayYieldSuccessful"));
        this.refreshDayYieldPeriod(period);
        String orgUnitID = ((StorageOrgUnitInfo)this.pmptStorageOrgUnit.getData()).getId().toString();
        String productLineID = null;
        if (this.cmbProductLine.getSelectedItem() != null && ((ProductLineInfo)this.cmbProductLine.getSelectedItem()).getName() != null) {
            productLineID = ((ProductLineInfo)this.cmbProductLine.getSelectedItem()).getId().toString();
        }
        Map result = dayYieldInterface.getProductLineDayYield(orgUnitID, productLineID, startDate, endDate);
        this.tableData = (ProductLineDayYieldCollection)((Object)result.get("ProductLineDayYield"));
        if (this.tableData != null && this.tableData.size() > 0) {
            this.fillTableBody(this.tableData);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionRemoveDayYield_actionPerformed(ActionEvent e) throws Exception {
        this.promptSaveOperation();
        ProductLineDayYieldConditionUI objUI = this.showConditionEditDlg(EASResource.getString((String)RESOURCE_FULLNAME, (String)"Title"));
        if (!objUI.isOK()) {
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"AskContinueDelete")) == 2) {
            return;
        }
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)objUI.pmptStorageOrgUnit.getValue();
        Date startDate = (Date)objUI.dateStartDate.getValue();
        Date endDate = (Date)objUI.dateEndDate.getValue();
        IProductLineDayYield dayYieldInterface = ProductLineDayYieldFactory.getRemoteInstance();
        ProductLineDayYieldPeriodInfo period = dayYieldInterface.removeProductLineDayYield(orgInfo.getId().toString(), startDate, endDate);
        MsgBox.showInfo((Component)((Object)this), (String)this.getResource("DeleteSuccessFul"));
        this.refreshDayYieldPeriod(period);
        if (this.tableData != null && this.tableData.size() > 0) {
            this.removeDayYieldInBuff(orgInfo, startDate, endDate);
            this.fillTableBody(this.tableData);
        }
    }

    private void removeDayYieldInBuff(StorageOrgUnitInfo orgUnitInfo, Date startDate, Date endDate) {
        ArrayList<ProductLineDayYieldInfo> list = new ArrayList<ProductLineDayYieldInfo>();
        startDate = this.getZeroTimeOfDate(startDate);
        endDate = this.getZeroTimeOfDate(endDate);
        ProductLineDayYieldInfo dayYieldInfo2 = null;
        for (int nIndex = 0; nIndex < this.tableData.size(); ++nIndex) {
            dayYieldInfo2 = this.tableData.get(nIndex);
            if (!dayYieldInfo2.getStorageOrgUnit().getId().equals((Object)orgUnitInfo.getId()) || dayYieldInfo2.getWorkDate().getTime() < startDate.getTime() || dayYieldInfo2.getWorkDate().getTime() > endDate.getTime()) continue;
            list.add(dayYieldInfo2);
        }
        for (ProductLineDayYieldInfo dayYieldInfo2 : list) {
            this.tableData.remove(dayYieldInfo2);
        }
    }

    @Override
    public void actionSaveDayYield_actionPerformed(ActionEvent e) throws Exception {
        this.saveDayYield();
    }

    private void saveDayYield() throws Exception {
        int nIndex;
        if (!this.isModified()) {
            return;
        }
        ProductLineDayYieldCollection dayYieldCollection = new ProductLineDayYieldCollection();
        ProductLineDayYieldInfo dayYieldInfo = null;
        for (nIndex = 0; nIndex < this.tableData.size(); ++nIndex) {
            dayYieldInfo = this.tableData.get(nIndex);
            if (dayYieldInfo.getStatus() != OprStatusEnum.MODIFIED) continue;
            dayYieldCollection.add(dayYieldInfo);
        }
        this.getRemoteInterface().saveProductLineDayYield(dayYieldCollection);
        for (nIndex = 0; nIndex < dayYieldCollection.size(); ++nIndex) {
            dayYieldInfo = dayYieldCollection.get(nIndex);
            dayYieldInfo.setStatus(OprStatusEnum.DEFAULT);
        }
        MsgBox.showInfo((Component)((Object)this), (String)this.getResource("SaveSuccessful"));
        this.setModified(false);
    }

    private ProductLineDayYieldConditionUI showConditionEditDlg(String title) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"targetID", SysContext.getSysContext().getCurrentUser());
        uiContext.put((Object)"openModel", (Object)"frame");
        UIModelDialog uiWindow = (UIModelDialog)UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProductLineDayYieldConditionUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        if (title != null) {
            uiWindow.setTitle(title);
        }
        ProductLineDayYieldConditionUI uiObject = (ProductLineDayYieldConditionUI)uiWindow.getUIObject();
        this.fillCondUIFields(uiObject, title);
        uiWindow.show();
        return uiObject;
    }

    private void fillCondUIFields(ProductLineDayYieldConditionUI uiObject, String title) {
        if (title != null) {
            SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)uiObject.pmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_productlinedayyield_remove");
        } else {
            SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)uiObject.pmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_productlinedayyield_gen");
        }
        uiObject.pmptStorageOrgUnit.setValue(this.pmptStorageOrgUnit.getValue());
        uiObject.dateStartDate.setValue(this.dateStartDate.getValue());
        uiObject.dateEndDate.setValue(this.dateEndDate.getValue());
    }

    private IProductLineDayYield getRemoteInterface() throws Exception {
        IProductLineDayYield dayYieldInterface = ProductLineDayYieldFactory.getRemoteInstance();
        return dayYieldInterface;
    }

    @Override
    protected void tableMain_editValueChanged(KDTEditEvent e) throws Exception {
        if (e.getValue() == null) {
            return;
        }
        IRow curRow = this.tableMain.getRow(e.getRowIndex());
        ProductLineDayYieldInfo dayYieldInfo = (ProductLineDayYieldInfo)curRow.getUserObject();
        if (e.getColIndex() == this.tableMain.getColumn(DAYYIELD_PROPERTY_WORKDAY_KEY).getColumnIndex()) {
            if (((Boolean)e.getValue()).booleanValue()) {
                dayYieldInfo.setWorkDay(WorkDateTypeEnum.WORKDAY);
                this.replaceWorkDay(this.tableMain.getRow(e.getRowIndex()), WorkDateTypeEnum.WORKDAY);
            } else {
                dayYieldInfo.setWorkDay(WorkDateTypeEnum.RESTDAY);
                this.replaceWorkDay(this.tableMain.getRow(e.getRowIndex()), WorkDateTypeEnum.RESTDAY);
            }
            this.replacePLSType(curRow, dayYieldInfo, true);
            this.replaceTotalRow(curRow, dayYieldInfo, false);
        }
    }

    private void replaceTotalRow(IRow row, ProductLineDayYieldInfo dayYieldInfo, boolean selfValue) throws Exception {
        if (dayYieldInfo.getScheduleType() == null) {
            return;
        }
        ICell dayYieldCell = row.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY);
        ProductLineDayYieldInfo actualDayyieldInfo = ProductLineDayYieldFactory.getRemoteInstance().getProductLineDayYieldInfo((IObjectPK)new ObjectUuidPK(dayYieldInfo.getId().toString()));
        boolean isWorkDay = false;
        if (dayYieldInfo.getWorkDay() != null) {
            isWorkDay = dayYieldInfo.getWorkDay().equals((Object)WorkDateTypeEnum.WORKDAY);
        }
        BigDecimal newValue = null;
        BigDecimal oldValue = null;
        if (isWorkDay && dayYieldInfo.getScheduleType().equals((Object)PLSTypeEnum.DAYABILITY)) {
            newValue = actualDayyieldInfo.getDayYield();
            oldValue = new BigDecimal(0);
            dayYieldInfo.setDayYield(newValue);
        } else {
            oldValue = dayYieldInfo.getDayYield();
            newValue = new BigDecimal(0);
        }
        IRow lastRow = this.tableMain.getFootManager().getFootRow(0);
        BigDecimal totalVal = (BigDecimal)lastRow.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY).getValue();
        totalVal = this.count(totalVal, oldValue, newValue);
        lastRow.getCell(DAYYIELD_PROPERTY_DAYYIELD_KEY).setValue((Object)totalVal);
    }

    private Date getZeroTimeOfDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private void clearTableView() {
        this.tableMain.removeRows();
    }

    public boolean destroyWindow() {
        try {
            this.promptSaveOperation();
            return super.destroyWindow();
        }
        catch (Exception e) {
            this.handUIException(e);
            return false;
        }
    }
}

