/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.ClassTeamCollection;
import com.kingdee.eas.mm.basedata.ClassTeamEntryCollection;
import com.kingdee.eas.mm.basedata.ClassTeamEntryInfo;
import com.kingdee.eas.mm.basedata.ClassTeamFactory;
import com.kingdee.eas.mm.basedata.ClassTeamInfo;
import com.kingdee.eas.mm.basedata.IProductLine;
import com.kingdee.eas.mm.basedata.PLSTypeEnum;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPException;
import com.kingdee.eas.mm.basedata.TimeUnitEnum;
import com.kingdee.eas.mm.basedata.client.AbstractProductLineEditUI;
import com.kingdee.eas.mm.common.client.CodingRulerUIHelper;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class ProductLineEditUI
extends AbstractProductLineEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductLineEditUI.class);
    private DataChangeListener classTeamChanged = null;
    private CodingRulerUIHelper codingRulerUIHelper = null;
    private DataChangeListener prmtunitChanged = null;
    private ItemListener comboListener = null;
    private HashMap costCenter = new HashMap();
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.mm.basedata.BasedataResource";

    public void onLoad() throws Exception {
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"ProductLineQueryF7WindowTitle"));
        super.onLoad();
        this.txtName.setMaxLength(255);
        this.txtremark.setMaxLength(255);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_productLine_addnew");
        this.txtability.setPrecision(2);
        this.txtability.setRemoveingZeroInDispaly(false);
        this.txtability.setNegatived(false);
        this.txtability.setHorizontalAlignment(4);
        this.txtMaxOutput.setPrecision(2);
        this.txtMaxOutput.setRemoveingZeroInDispaly(false);
        this.txtMaxOutput.setNegatived(false);
        this.txtMaxOutput.setHorizontalAlignment(4);
        this.txtAvgOutput.setPrecision(2);
        this.txtAvgOutput.setRemoveingZeroInDispaly(false);
        this.txtAvgOutput.setNegatived(false);
        this.txtAvgOutput.setHorizontalAlignment(4);
        this.txtusingRate.setPrecision(2);
        this.txtusingRate.setRemoveingZeroInDispaly(false);
        this.txtusingRate.setMaximumValue((Comparable)new BigDecimal("100.00"));
        this.txtusingRate.setMinimumValue((Comparable)new BigDecimal("0.00"));
        this.txtusingRate.setNegatived(false);
        this.txtusingRate.setHorizontalAlignment(4);
        this.txtefficiency.setPrecision(2);
        this.txtefficiency.setRemoveingZeroInDispaly(false);
        this.txtefficiency.setMaximumValue((Comparable)new BigDecimal("100.00"));
        this.txtefficiency.setMinimumValue((Comparable)new BigDecimal("0.00"));
        this.txtefficiency.setNegatived(false);
        this.txtefficiency.setHorizontalAlignment(4);
        this.txtproductBatch.setHorizontalAlignment(4);
        this.txtproductBatch.setRemoveingZeroInDispaly(false);
        this.txtproductBatch.setNegatived(false);
        this.txtbatchTime.setHorizontalAlignment(4);
        this.txtbatchTime.setRemoveingZeroInDispaly(false);
        this.txtbatchTime.setNegatived(false);
        this.txtbatchTime.setPrecision(2);
        this.txtDayAbility.setHorizontalAlignment(4);
        this.txtDayAbility.setNegatived(false);
        this.txtDayAbility.setRemoveingZeroInDispaly(false);
        this.setTextFieldValue();
        this.menuItemApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtstorageOrgUnit;
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    private void setDefaultClassTeam(StorageOrgUnitInfo storageOrgInfo) throws BOSException {
        if (storageOrgInfo != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)1, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            ClassTeamCollection classTeamCollection = ClassTeamFactory.getRemoteInstance().getClassTeamCollection(entityViewInfo);
            if (classTeamCollection != null && classTeamCollection.size() > 0) {
                ClassTeamInfo classTeamInfo = classTeamCollection.get(0);
                this.prmtclassTeam.setValue((Object)classTeamInfo);
            }
        }
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)arg0, (Object)arg1);
        if (isDiffrent) {
            this.setproductLineNumber();
            StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
            try {
                this.prmtclassTeam.setValue(null);
                this.txtability.setValue(null);
                this.txtMaxOutput.setValue(null);
                this.txtAvgOutput.setValue(null);
                this.prmtCostCenterOrgUnit.setValue(null);
                if (storageOrgInfo != null) {
                    this.initClassTeamF7(storageOrgInfo);
                }
                this.prmtworkshop.setValue(null);
                MMUtils.initWorkshopF7((KDBizPromptBox)this.prmtworkshop, (StorageOrgUnitInfo)storageOrgInfo);
                this.setCostCenterF7(storageOrgInfo);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    public void loadFields() {
        this.removeListener();
        this.batchTimeUnit.removeAllItems();
        this.batchTimeUnit.addItem((Object)TimeUnitEnum.MINUTE);
        this.batchTimeUnit.addItem((Object)TimeUnitEnum.HOUR);
        super.loadFields();
        this.setTextFieldValue();
        this.setTxtProductBatchPrecision();
        try {
            StorageOrgUnitInfo storageOrgUnit = this.editData.getStorageOrgUnit();
            MMUtils.initWorkshopF7((KDBizPromptBox)this.prmtworkshop, (StorageOrgUnitInfo)storageOrgUnit);
            this.setCostCenterF7(storageOrgUnit);
            this.classTeamChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ProductLineEditUI.this.prmtclassTeam_dataChanged(e);
                }
            };
            this.prmtclassTeam.addDataChangeListener(this.classTeamChanged);
            if (!this.getOprtState().equals(OprtState.VIEW)) {
                this.initClassTeamF7(storageOrgUnit);
            }
            this.comboListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ProductLineEditUI.this.scheduleTypeChange();
                    }
                }
            };
            this.comboScheduleType.addItemListener(this.comboListener);
            this.prmtunitChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        ProductLineEditUI.this.prmtUnit_dataChanged(eventObj);
                    }
                    catch (Exception e) {
                        ProductLineEditUI.this.handleException(e);
                    }
                }
            };
            this.prmtunit.addDataChangeListener(this.prmtunitChanged);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"ProductLineQueryF7WindowTitle"));
        this.setTxtDayAbillityState();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setproductLineNumber();
        }
    }

    protected void prmtUnit_dataChanged(DataChangeEvent eventObj) {
        MeasureUnitInfo unit = (MeasureUnitInfo)eventObj.getNewValue();
        if (unit != null) {
            BigDecimal valueDayAbility;
            int precision = unit.getQtyPrecision();
            this.txtproductBatch.setPrecision(precision);
            this.txtDayAbility.setPrecision(precision);
            BigDecimal valueProductBatch = this.txtproductBatch.getBigDecimalValue();
            if (valueProductBatch != null) {
                this.txtproductBatch.setValue((Object)valueProductBatch.setScale(precision, 4));
            }
            if ((valueDayAbility = this.txtDayAbility.getBigDecimalValue()) != null) {
                this.txtDayAbility.setValue((Object)valueDayAbility.setScale(precision, 4));
            }
        }
    }

    private void setTxtProductBatchPrecision() {
        MeasureUnitInfo unit = (MeasureUnitInfo)this.prmtunit.getValue();
        if (unit != null) {
            int precision = unit.getQtyPrecision();
            this.txtproductBatch.setPrecision(precision);
            this.txtDayAbility.setPrecision(precision);
        } else {
            this.txtproductBatch.setPrecision(6);
            this.txtDayAbility.setPrecision(6);
        }
    }

    private void removeListener() {
        if (this.classTeamChanged != null) {
            this.prmtclassTeam.removeDataChangeListener(this.classTeamChanged);
        }
        if (this.prmtunitChanged != null) {
            this.prmtunit.removeDataChangeListener(this.prmtunitChanged);
        }
        if (this.comboListener != null) {
            this.comboScheduleType.removeItemListener(this.comboListener);
        }
    }

    public void scheduleTypeChange() {
        if (this.comboScheduleType.getSelectedItem() != null && this.comboScheduleType.getSelectedItem().equals((Object)PLSTypeEnum.SHIFTABILITY)) {
            this.txtDayAbility.setValue(null);
            this.txtDayAbility.setEnabled(false);
        } else {
            this.txtDayAbility.setValue(null);
            this.txtDayAbility.setEnabled(true);
            this.txtDayAbility.setRequired(true);
        }
    }

    public void setTxtDayAbillityState() {
        if ((this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW)) && this.editData.getScheduleType() != null) {
            if (this.editData.getScheduleType().equals((Object)PLSTypeEnum.SHIFTABILITY)) {
                this.txtDayAbility.setEnabled(false);
            } else {
                this.txtDayAbility.setEnabled(true);
                this.txtDayAbility.setRequired(true);
            }
        }
    }

    private void setCostCenterF7(StorageOrgUnitInfo storageOrgInfo) throws EASBizException, BOSException {
        if (storageOrgInfo != null && storageOrgInfo.getId() != null) {
            String storageOrgId = storageOrgInfo.getId().toString();
            if (storageOrgId == null) {
                return;
            }
            HashSet set = new HashSet();
            if (this.costCenter.containsKey(storageOrgId)) {
                set = (HashSet)this.costCenter.get(storageOrgId);
            } else {
                set = ProductLineFactory.getRemoteInstance().getCostCenterByCompanyOrg(storageOrgId);
                this.costCenter.put(storageOrgId, set);
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            if (null != set && set.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)"false", CompareType.EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            this.prmtCostCenterOrgUnit.setEntityViewInfo(viewInfo);
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    protected void prmtclassTeam_dataChanged(DataChangeEvent e) {
        ClassTeamInfo oldClassTeamInfo = (ClassTeamInfo)e.getOldValue();
        ClassTeamInfo newClassTeamInfo = (ClassTeamInfo)e.getNewValue();
        BigDecimal calability = new BigDecimal(0);
        if (newClassTeamInfo != null && !newClassTeamInfo.equals(oldClassTeamInfo)) {
            ClassTeamEntryCollection classTeanEntry = newClassTeamInfo.getEntrys();
            for (int i = 0; i < classTeanEntry.size(); ++i) {
                ClassTeamEntryInfo entryInfo = classTeanEntry.get(i);
                calability = calability.add(entryInfo.getTimes());
            }
            this.txtability.setValue((Object)calability);
            this.txtMaxOutput.setValue((Object)calability);
            this.txtAvgOutput.setValue((Object)calability);
        }
    }

    private void initClassTeamF7(StorageOrgUnitInfo storageOrgInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("entrys.id"));
        selectors.add(new SelectorItemInfo("entrys.number"));
        selectors.add(new SelectorItemInfo("entrys.times"));
        this.prmtclassTeam.setSelectorCollection(selectors);
        this.prmtclassTeam.setEntityViewInfo(viewInfo);
        try {
            this.setDefaultClassTeam(storageOrgInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void setproductLineNumber() {
        StorageOrgUnitInfo storageOrgUnitInfo;
        if ((this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) && (storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue()) != null) {
            this.setNumberTextStatus(storageOrgUnitInfo.getId().toString());
        }
    }

    private void setNumberTextStatus(String orgId) {
        RuleStatus ruleStatus = null;
        Object[] object = null;
        try {
            IObjectValue ov = this.getDataObject();
            ProductLineInfo info = (ProductLineInfo)ov;
            object = ProductLineFactory.getRemoteInstance().getNumberValue(info, orgId);
            ruleStatus = (RuleStatus)object[0];
            if (ruleStatus != null) {
                if (ruleStatus.isExist() && "ADDNEW".equals(this.getOprtState())) {
                    if (ruleStatus.isAddView()) {
                        String newNum = (String)object[1];
                        this.txtNumber.setText(newNum);
                        this.editData.setNumber(newNum);
                    } else {
                        this.txtNumber.setText(null);
                        this.editData.setNumber(null);
                    }
                }
                if (ruleStatus.isExist()) {
                    if (ruleStatus.isModifiable()) {
                        if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
                            this.txtNumber.setEditable(false);
                            this.txtNumber.setAccessAuthority(1);
                        } else {
                            this.txtNumber.setEditable(true);
                            this.txtNumber.setAccessAuthority(0);
                            this.txtNumber.setEnabled(true);
                            this.txtNumber.requestFocus();
                        }
                    } else {
                        this.txtNumber.setEditable(false);
                        this.txtNumber.setAccessAuthority(1);
                    }
                } else if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
                    this.txtNumber.setEditable(false);
                    this.txtNumber.setAccessAuthority(1);
                } else {
                    this.txtNumber.setEditable(true);
                    this.txtNumber.setEnabled(true);
                    this.txtNumber.setAccessAuthority(0);
                    this.txtNumber.requestFocus();
                }
            } else {
                this.txtNumber.setText(null);
                this.editData.setNumber(null);
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ProductLineFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        ProductLineInfo objectValue = new ProductLineInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_productLine_addnew"));
        objectValue.setStatus(BDStatusEnum.UNAPPROVE);
        objectValue.setUsingRate(new BigDecimal("100"));
        objectValue.setEfficiency(new BigDecimal("100"));
        objectValue.setBatchTimeUnit(TimeUnitEnum.MINUTE);
        objectValue.setScheduleType(PLSTypeEnum.DAYABILITY);
        return objectValue;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("Msg_ApprovedCannotDelete"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherBase(0);
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherBase(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doActionOtherBase(int actionenumvalue) throws BOSException, EASBizException {
        if (this.editData != null && this.editData.getId() != null && !"".equals(this.editData.getId().toString())) {
            String id = this.editData.getId().toString();
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
                SysUtil.abort();
            }
            try {
                this.doCheckStatusBase(actionenumvalue);
                IProductLine ipl = ProductLineFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
                String str = null;
                switch (actionenumvalue) {
                    case 0: {
                        str = ipl.approve((IObjectPK)pk);
                        break;
                    }
                    case 1: {
                        str = ipl.unapprove((IObjectPK)pk);
                    }
                }
                if (null == str || "".equals(str)) {
                    CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
                    this.setOprtState("VIEW");
                    this.setDataObject((IObjectValue)ipl.getValue((IObjectPK)pk, this.getSelectors()));
                    this.editData.copyNewToOld();
                    this.loadFields();
                    this.setSaved(true);
                } else {
                    MsgBox.showWarning((String)str);
                }
            }
            catch (EASBizException ex) {
                this.handleException((Exception)((Object)ex));
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                this.setOprtState("RELEASEALL");
                try {
                    this.pubFireVOChangeListener(id);
                }
                catch (Throwable t) {
                    this.handUIException(t);
                }
            }
        }
    }

    private void doCheckStatusBase(int actionenumvalue) throws BOSException, EASBizException {
        if (this.editData == null) {
            return;
        }
        switch (actionenumvalue) {
            case 0: {
                if (this.editData.getStatus() != BDStatusEnum.APPROVE) break;
                throw new ProductLineWPException(ProductLineWPException.AUDITED);
            }
            case 1: {
                if (this.editData.getStatus() != BDStatusEnum.UNAPPROVE) break;
                throw new ProductLineWPException(ProductLineWPException.UNAUDIT);
            }
        }
    }

    private void setTextFieldValue() {
        if (this.editData.getDayAbility() != null && this.editData.getDayAbility().compareTo(new BigDecimal(0)) == 0) {
            this.txtDayAbility.setText(null);
        }
        if (this.editData.getMaxOutput() != null && this.editData.getMaxOutput().compareTo(new BigDecimal(0)) == 0) {
            this.txtMaxOutput.setText(null);
        }
        if (this.editData.getAvgOutput() != null && this.editData.getAvgOutput().compareTo(new BigDecimal(0)) == 0) {
            this.txtAvgOutput.setText(null);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("Msg_ApprovedCannotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.setTextFieldValue();
        this.setTxtDayAbillityState();
        this.setproductLineNumber();
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"ProductLineQueryF7WindowTitle"));
    }

    private String getResource(String key) {
        return EASResource.getString((String)RESOURCE_FULLNAME, (String)key);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        ProductLineInfo info = (ProductLineInfo)this.dataBinder.getValueObject();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtNumber.setEditable(false);
            this.actionApprove.setEnabled(false);
            this.actionUnApprove.setEnabled(false);
        } else if (null != info.getId() && this.getOprtState().equals(OprtState.EDIT)) {
            if (info.getStatus().getValue() == 20) {
                this.actionApprove.setEnabled(false);
                this.actionUnApprove.setEnabled(true);
            } else {
                this.actionApprove.setEnabled(true);
                this.actionUnApprove.setEnabled(false);
            }
        } else if (null != info.getId() && this.getOprtState().equals(OprtState.VIEW)) {
            if (info.getStatus().getValue() == 20) {
                this.actionApprove.setEnabled(false);
                this.actionUnApprove.setEnabled(true);
            } else {
                this.actionApprove.setEnabled(true);
                this.actionUnApprove.setEnabled(false);
            }
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        ProductLineInfo info = (ProductLineInfo)arg0;
        if (null != info && info.getStatus() == BDStatusEnum.APPROVE) {
            info.setStatus(BDStatusEnum.UNAPPROVE);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (BDStatusEnum.APPROVE.equals((Object)this.editData.getStatus())) {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            this.setOprtState("VIEW");
            this.lockUIForViewStatus();
            AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"ProductLineQueryF7WindowTitle"));
        }
    }

    @Override
    public void onShow() throws Exception {
        Frame frame1;
        super.onShow();
        IUIWindow uiWindow = this.getUIWindow();
        if (uiWindow instanceof JFrame && (frame1 = (Frame)uiWindow) != null) {
            frame1.setResizable(false);
        }
    }
}

