/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.IProductLine;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.client.AbstractProductLineListUI;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ProductLineListUI
extends AbstractProductLineListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductLineListUI.class);
    int top = 0;
    int bottom = 0;
    int left = 0;
    int right = 0;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ProductLineFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ProductLineInfo objectValue = new ProductLineInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("productBatch").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblMain.getColumn("dayAbility").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (SCMClientUtils.isSelectRow((KDTable)this.tblMain)) {
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id"));
            ArrayList list = this.getSelectedIdValues();
            pks = SCMUtils.convertStringToObjectPK((String[])list.toArray(new String[0]));
            try {
                IProductLine ipl = (IProductLine)this.getBizInterface();
                ipl.pubFireVOChangeListener(list, true);
                String str = ipl.approve(pks);
                if (null == str || "".equals(str)) {
                    String msg = ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgApproveSuccee");
                    MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
                } else {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"msg_approve_error"), (String)str, (int)8188);
                }
                this.getSelectBlock();
                this.refreshList();
                this.setSelectBlock();
            }
            catch (EASBizException ex) {
                this.handleException((Exception)((Object)ex));
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                ((IProductLine)this.getBizInterface()).pubFireVOChangeListener(list, false);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("Msg_NoRecordSelected"));
            return;
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        this.execQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (SCMClientUtils.isSelectRow((KDTable)this.tblMain)) {
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id"));
            ArrayList list = this.getSelectedIdValues();
            pks = SCMUtils.convertStringToObjectPK((String[])list.toArray(new String[0]));
            try {
                IProductLine ipl = (IProductLine)this.getBizInterface();
                ipl.pubFireVOChangeListener(list, true);
                String str = ipl.unapprove(pks);
                if (null == str || "".equals(str)) {
                    String msg = ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgUnApproveSuccee");
                    MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
                } else {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"msg_unapprove_error"), (String)str, (int)8188);
                }
                this.getSelectBlock();
                this.refreshList();
                this.setSelectBlock();
            }
            catch (EASBizException ex) {
                this.handleException((Exception)((Object)ex));
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                ((IProductLine)this.getBizInterface()).pubFireVOChangeListener(list, false);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("Msg_NoRecordSelected"));
            return;
        }
    }

    private void getSelectBlock() {
        KDTSelectBlock sb = this.tblMain.getSelectManager().get();
        if (sb != null) {
            this.top = sb.getTop();
            this.bottom = sb.getBottom();
            this.left = sb.getLeft();
            this.right = sb.getRight();
        }
    }

    private void setSelectBlock() {
        this.tblMain.getSelectManager().select(this.top, this.left, this.bottom, this.right, 2);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkEdit() {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int selectIndex = -1;
        if (selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        String keyValue = this.tblMain.getCell(selectIndex, "id").getValue().toString();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)keyValue));
        try {
            IProductLine ipl = ProductLineFactory.getRemoteInstance();
            ProductLineInfo plInfo = (ProductLineInfo)ipl.getValue((IObjectPK)pk);
            if (plInfo != null && plInfo.getStatus().getValue() == 20) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("Msg_ApprovedCannotEdit"));
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e2) {
            this.handUIException(e2);
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)key);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo storageOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", (String)"mm_productLine_view");
        try {
            filter.mergeFilter(storageOrgFilter, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filter;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.refreshList();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK orgPK = null;
        String actoinName = null;
        if (action != null) {
            actoinName = action.getClass().getName();
        }
        if (actoinName != null && actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        if (actoinName != null && actoinName.equals("ActionEdit")) {
            String id = this.getSelectedKeyValue();
            if (id == null) {
                return super.getOrgPK(action);
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            ProductLineInfo productLineInfo = null;
            try {
                productLineInfo = (ProductLineInfo)this.getBizInterface().getValue((IObjectPK)pk);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (productLineInfo != null && productLineInfo.getStorageOrgUnit() != null) {
                orgPK = new ObjectUuidPK(productLineInfo.getStorageOrgUnit().getId());
            }
        } else {
            orgPK = super.getOrgPK(action);
        }
        return orgPK;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.tblMain.getViewManager().getFreezeCol() <= 0) {
            KDTableUtils.setDefaultFreezeCol((KDTable)this.tblMain, (int)6);
        }
    }
}

