/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.IProductLineWP;
import com.kingdee.eas.mm.basedata.ProductLineWPFactory;
import com.kingdee.eas.mm.basedata.ProductLineWPInfo;
import com.kingdee.eas.mm.basedata.client.AbstractProductLineWPListUI;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ProductLineWPListUI
extends AbstractProductLineWPListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductLineWPListUI.class);
    int top = 0;
    int bottom = 0;
    int left = 0;
    int right = 0;

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        this.tblMain.getColumn("productline.productBatch").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "storageOrgUnit.name", "productLine.name", "productline.productBatch", "productline.unit.name", "status"};
        return columns;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.refreshList();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ProductLineWPFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ProductLineWPInfo objectValue = new ProductLineWPInfo();
        return objectValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (SCMClientUtils.isSelectRow((KDTable)this.tblMain)) {
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id"));
            ArrayList list = this.getSelectedIdValues();
            pks = SCMUtils.convertStringToObjectPK((String[])list.toArray(new String[0]));
            try {
                IProductLineWP iplwp = (IProductLineWP)this.getBizInterface();
                iplwp.pubFireVOChangeListener(list, true);
                String str = iplwp.approve(pks);
                if (null == str || "".equals(str)) {
                    String msg = ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgApproveSuccee");
                    MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
                } else {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"msg_approve_error"), (String)str, (int)8188);
                }
                this.getSelectBlock();
                this.refreshList();
                this.setSelectBlock();
            }
            catch (EASBizException ex) {
                this.handleException((Exception)((Object)ex));
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                ((IProductLineWP)this.getBizInterface()).pubFireVOChangeListener(list, false);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.mm.BasedataResource", (String)"Msg_NoRecordSelected"));
            return;
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        this.execQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (SCMClientUtils.isSelectRow((KDTable)this.tblMain)) {
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id"));
            ArrayList list = this.getSelectedIdValues();
            pks = SCMUtils.convertStringToObjectPK((String[])list.toArray(new String[0]));
            try {
                IProductLineWP iplwp = (IProductLineWP)this.getBizInterface();
                iplwp.pubFireVOChangeListener(list, true);
                String str = iplwp.unapprove(pks);
                if (null == str || "".equals(str)) {
                    String msg = ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgUnApproveSuccee");
                    MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
                } else {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"msg_unapprove_error"), (String)str, (int)8188);
                }
                this.getSelectBlock();
                this.refreshList();
                this.setSelectBlock();
            }
            catch (EASBizException ex) {
                this.handleException((Exception)((Object)ex));
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                ((IProductLineWP)this.getBizInterface()).pubFireVOChangeListener(list, false);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.mm.BasedataResource", (String)"Msg_NoRecordSelected"));
            return;
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkEdit() throws BOSException, EASBizException {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int selectIndex = -1;
        if (selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        String keyValue = this.tblMain.getCell(selectIndex, "id").getValue().toString();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)keyValue));
        IProductLineWP iplwp = ProductLineWPFactory.getRemoteInstance();
        ProductLineWPInfo plwpInfo = (ProductLineWPInfo)iplwp.getValue((IObjectPK)pk);
        if (plwpInfo != null && plwpInfo.getStatus().getValue() == 20) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.client.BasedataResource", (String)"Msg_ApprovedCannotEdit"));
            SysUtil.abort();
        }
    }

    private void getSelectBlock() {
        KDTSelectBlock sb = this.tblMain.getSelectManager().get();
        if (sb != null) {
            this.top = sb.getTop();
            this.bottom = sb.getBottom();
            this.left = sb.getLeft();
            this.right = sb.getRight();
        }
    }

    private void setSelectBlock() {
        this.tblMain.getSelectManager().select(this.top, this.left, this.bottom, this.right, 2);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "productLineWP";
        param.alias = EASResource.getString((String)"com.kingdee.eas.mm.basedata.BASEDATAAutoGenerateResource", (String)"37_ProductLineWPListUI");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "productLineWP";
        param.alias = EASResource.getString((String)"com.kingdee.eas.mm.basedata.BASEDATAAutoGenerateResource", (String)"37_ProductLineWPListUI");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("productLine.number"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("resource.number"));
        return sic;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo storageOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", (String)"mm_productLineWP_view");
        try {
            filter.mergeFilter(storageOrgFilter, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filter;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK orgPK = null;
        String actoinName = null;
        if (action != null) {
            actoinName = action.getClass().getName();
        }
        if (actoinName != null && actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        if (actoinName != null && actoinName.equals("ActionEdit")) {
            String id = this.getSelectedKeyValue();
            if (id == null) {
                return super.getOrgPK(action);
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            ProductLineWPInfo productLineWPInfo = null;
            try {
                productLineWPInfo = (ProductLineWPInfo)this.getBizInterface().getValue((IObjectPK)pk);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (productLineWPInfo != null && productLineWPInfo.getStorageOrgUnit() != null) {
                orgPK = new ObjectUuidPK(productLineWPInfo.getStorageOrgUnit().getId());
            }
        } else {
            orgPK = super.getOrgPK(action);
        }
        return orgPK;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.tblMain.getViewManager().getFreezeCol() <= 0) {
            KDTableUtils.setDefaultFreezeCol((KDTable)this.tblMain, (int)6);
        }
    }
}

