/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.IProductionFormula;
import com.kingdee.eas.mm.basedata.ManufactureStrategyGroup;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaEntryInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaFactory;
import com.kingdee.eas.mm.basedata.ProductionFormulaInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractProductionFormulaEditUI;
import com.kingdee.eas.mm.basedata.client.F7BomSelectProcessor2;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ProductionFormulaEditUI
extends AbstractProductionFormulaEditUI {
    private static final long serialVersionUID = 4083937725346712903L;
    private static final String PRODUCTIONFORMULA_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.ProductionFormulaResource";
    private Map materialPlanMap = new HashMap();
    private static final String TB_LOCATION = "location";
    private static final String TB_MATERIAL = "materialNumber";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MATERIALMODEL = "materialModel";
    private static final String TB_UNIT = "unit";
    private static final String TB_BASEUNIT = "baseUnit";
    private static final String TB_CONSUMETYPE = "consumeType";
    private static final String TB_PRODUCTQTY = "consumeFixQty";
    private static final String TB_PRODUCTBASEQTY = "consumeFixBaseQty";
    private static final String TB_PROPORTION = "proportion";
    private static final String TB_EFFECTIVEDATE = "effectiveDate";
    private static final String TB_DISABLEDATE = "disableDate";
    private static final String TB_MATERIALCHARA = "materialChara";
    private static final String TB_PICKINGMODE = "pickingMode";
    private static final String TB_PICKINGLEADTIME = "pikingLeadTime";
    private static final String TB_LINEWP = "lineWP";
    private static final String TB_LINEWPMARK = "lineWPMark";
    private static final String TB_ISBACKFLUSH = "isBackFlush";
    private static final String TB_PROVIDETYPE = "provideType";
    private static final String TB_DEFAULTWAREHOUSE = "defaultWarehouse";
    private static final String TB_SUPPLYORGUNIT = "supplyOrgUnit";
    private static final String TB_ISSTOCKTRANSFER = "isStock";
    private static final String TB_TRANSFERORGUNIT = "FSourceStorageOrgUnit";
    private static final String TB_TRANSFERWAREHOUSE = "outWareHouse";
    private static final String TB_PRODUCTTYPE = "productType";
    private static final String TB_MATERIALINVENTORY = "materialInventory";
    private static final String[] QTYPRECISIONFROMUNITTAB = new String[]{"consumeFixQty"};
    private static final String[] QTYPRECISIONFROMBASEUNITTAB = new String[]{"consumeFixBaseQty"};
    private SCMEntryDataVO headVO;
    private KDTEditAdapter entryTableChange = null;
    private DataChangeListener prmtMaterialListener = null;
    private DataChangeListener prmtStorageListener = null;
    private DataChangeListener prodLineListener = null;
    private DataChangeListener bomListener = null;
    private DataChangeListener qtyChangeLister = null;
    private DataChangeListener yieldChangeLister = null;
    private KDTActiveCellListener activeCellListener = null;
    private boolean isCopy = false;
    private int freezeColIndex = 6;

    public ProductionFormulaEditUI() throws Exception {
        HashMap<String, Object> colMap = new HashMap<String, Object>();
        colMap.put("MATERIAL", TB_MATERIAL);
        colMap.put("TB_BASEUNIT", TB_BASEUNIT);
        colMap.put("TB_BASEQTY", TB_PRODUCTBASEQTY);
        colMap.put("TB_UNIT", TB_UNIT);
        colMap.put("QTY", TB_PRODUCTQTY);
        colMap.put("TB_MATERIALSIZE", TB_MATERIALMODEL);
        colMap.put("QTYPRECISIONFROMUNITTAB", QTYPRECISIONFROMUNITTAB);
        colMap.put("QTYPRECISIONFROMBASEUNITTAB", QTYPRECISIONFROMBASEUNITTAB);
        this.uiHelper.setConfigMap(colMap);
        this.uiHelper.setKdtEntries(this.kdtEntrys);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.remove((Component)this.btnAttachment);
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtstorageOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtstorageOrgUnit;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected void initNeedMainOrgF7s() {
        OrgUnitInfo orgInfo = null;
        if (this.getMainOrgContext() != null) {
            orgInfo = (OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType());
        }
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtmaterial, orgInfo);
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        KDBizPromptBox bizEntryMaterialBox = this.getBizMaterialF7(this.kdtEntrys.getColumn(TB_MATERIAL), materialPlanQuery);
        KDBizPromptBox bizEntryWareHouseBox = (KDBizPromptBox)this.kdtEntrys.getColumn(TB_DEFAULTWAREHOUSE).getEditor().getComponent();
        this.f7Manager.registerContextChangeF7(this.prmtproductLine, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(bizEntryWareHouseBox, "storageOrg.id");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtmaterial, bizEntryMaterialBox, this.prmtproductLine});
        this.prmtmaterial.setDisplayFormat("$name$ ");
        UIHelper.registerLocationF7((KDTable)this.kdtEntrys, (String)TB_DEFAULTWAREHOUSE, (String)TB_LOCATION);
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "mm_formula_addnew";
        }
        return null;
    }

    protected MaterialInfo[] verifyMaterials(MaterialInfo[] materials, int rowIdx, Map dataMap, String materialFieldname) throws Exception {
        return materials;
    }

    protected void afterInsertMaterials(int rowIdx, MaterialInfo[] materialInfos, Map dataMap) throws Exception {
        super.afterInsertMaterials(rowIdx, materialInfos, dataMap);
        StorageOrgUnitInfo org = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        SCMEntryDataVO dataVO = new SCMEntryDataVO();
        SelectorItemCollection materialPlanSelectors = this.getMaterialPlanSelectors();
        dataVO.setMaterialPlanSelectors(materialPlanSelectors);
        SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)org, (MaterialInfo[])materialInfos, (SCMEntryDataVO)dataVO);
        for (int i = 0; i < materialInfos.length; ++i) {
            String childMterialId;
            String headMterialId;
            MaterialInfo material = (MaterialInfo)this.prmtmaterial.getValue();
            if (material != null && (headMterialId = material.getId().toString()).equals(childMterialId = materialInfos[i].getId().toString())) {
                MsgBox.showError((String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"parentMaterialNotSameChild"));
                this.kdtEntrys.getCell(rowIdx + i, TB_MATERIAL).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_MATERIALNAME).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_MATERIALMODEL).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_UNIT).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_BASEUNIT).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_MATERIALINVENTORY).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_MATERIALCHARA).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_PICKINGMODE).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_PRODUCTTYPE).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_DEFAULTWAREHOUSE).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_LOCATION).setValue(null);
                this.kdtEntrys.getCell(rowIdx + i, TB_PROVIDETYPE).setValue((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE);
                continue;
            }
            this.kdtEntrys.getCell(rowIdx + i, TB_PICKINGMODE).setValue(null);
            this.kdtEntrys.getCell(rowIdx + i, TB_PICKINGMODE).getStyleAttributes().setLocked(false);
            this.kdtEntrys.getCell(rowIdx + i, TB_MATERIALNAME).setValue((Object)materialInfos[i].getName());
            this.kdtEntrys.getCell(rowIdx + i, TB_MATERIALMODEL).setValue((Object)materialInfos[i].getModel());
            this.kdtEntrys.getCell(rowIdx + i, TB_UNIT).setValue((Object)voResult.getMeasureUnitInfos()[i]);
            this.kdtEntrys.getCell(rowIdx + i, TB_BASEUNIT).setValue((Object)voResult.getBaseMeasureUnitInfos()[i]);
            String key = materialInfos[i].getId().toString() + org.getId().toString();
            MaterialPlanInfo mpInfo = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key);
            MaterialInventoryInfo miInfo = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key);
            if (mpInfo != null) {
                this.kdtEntrys.getCell(rowIdx + i, TB_MATERIALINVENTORY).setValue((Object)mpInfo);
                if (mpInfo.getMaterialChar() != null && !mpInfo.getMaterialChar().equals((Object)MaterialCharEnum.NONE)) {
                    this.kdtEntrys.getCell(rowIdx + i, TB_MATERIALCHARA).setValue((Object)mpInfo.getMaterialChar());
                } else {
                    this.kdtEntrys.getCell(rowIdx + i, TB_MATERIALCHARA).setValue((Object)MaterialCharEnum.MASTERPROP);
                }
                this.kdtEntrys.getCell(rowIdx + i, TB_PICKINGMODE).setValue((Object)mpInfo.getIssMode());
                this.kdtEntrys.getCell(rowIdx + i, TB_PICKINGLEADTIME).setValue((Object)new Integer(mpInfo.getIssueLeadTime()));
                this.kdtEntrys.getCell(rowIdx + i, TB_ISBACKFLUSH).setValue((Object)new Boolean(mpInfo.isIsBackFlush()));
                if (mpInfo.getProvideType().equals((Object)MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE)) {
                    this.kdtEntrys.getCell(rowIdx + i, TB_PROVIDETYPE).setValue((Object)MaterialProvideTypeEnum.SPANORGPROVIDE);
                } else {
                    this.kdtEntrys.getCell(rowIdx + i, TB_PROVIDETYPE).setValue((Object)mpInfo.getProvideType());
                }
                this.kdtEntrys.getCell(rowIdx + i, TB_SUPPLYORGUNIT).setValue((Object)mpInfo.getSupplyOrgUnit());
                this.kdtEntrys.getCell(rowIdx + i, TB_TRANSFERORGUNIT).setValue((Object)mpInfo.getFromInvOrg());
                this.kdtEntrys.getCell(rowIdx + i, TB_TRANSFERWAREHOUSE).setValue((Object)mpInfo.getFromWarehouse());
                this.kdtEntrys.getCell(rowIdx + i, TB_DEFAULTWAREHOUSE).setValue((Object)miInfo.getDefaultWarehouse());
                if (miInfo != null && miInfo.getDefaultWarehouse() != null && miInfo.getDefaultWarehouse().isHasLocation()) {
                    this.kdtEntrys.getCell(rowIdx + i, TB_LOCATION).getStyleAttributes().setLocked(false);
                }
                if (!mpInfo.getOutputType().equals((Object)MaterialProductEnum.MASTERPRODUCT)) {
                    this.kdtEntrys.getCell(rowIdx + i, TB_PRODUCTTYPE).setValue((Object)mpInfo.getOutputType());
                }
                if (mpInfo.getMaterialAttr() != null && mpInfo.getMaterialAttr().equals((Object)MaterialAttributeEnum.OTHER) || mpInfo.getOutputType().equals((Object)MaterialProductEnum.RELATEDPRODUCT) || mpInfo.getOutputType().equals((Object)MaterialProductEnum.BYPRODUCT)) {
                    this.kdtEntrys.getCell(rowIdx + i, TB_PICKINGMODE).setValue((Object)MaterialIssueModeEnum.NOTISSMODE);
                    this.kdtEntrys.getCell(rowIdx + i, TB_PICKINGMODE).getStyleAttributes().setLocked(true);
                }
            }
            SCMClientUtils.changeTableColPrecision((Map)voResult.getMmuPrecisions(), (MaterialInfo)materialInfos[i], (MeasureUnitInfo)voResult.getMeasureUnitInfos()[i], (KDTable)this.kdtEntrys, (String[])QTYPRECISIONFROMUNITTAB, (int)(rowIdx + i));
            SCMClientUtils.changeTableColPrecision((Map)voResult.getMmuPrecisions(), (MaterialInfo)materialInfos[i], (MeasureUnitInfo)voResult.getBaseMeasureUnitInfos()[i], (KDTable)this.kdtEntrys, (String[])QTYPRECISIONFROMBASEUNITTAB, (int)(rowIdx + i));
            this.kdtEntrys.getCell(rowIdx + i, TB_ISSTOCKTRANSFER).setValue((Object)mpInfo.isIsStockAllot());
        }
        this.dealWithDefaultWarehouse(null, true);
        this.dealWithSupplyOrgUnit(null, true);
        this.dealWithStockTransfer(null, true);
        this.dealWithTransferOrgUnit(null, true);
        this.dealWithTransferWarehouse(null, true);
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
        KDTEditEvent event = this.createKDTEditEvent(false);
        this.dealWithSupplyOrgUnit(event, false);
        this.dealWithDefaultWarehouse(event, false);
        this.dealWithStockTransfer(event, false);
        this.dealWithTransferOrgUnit(event, false);
        this.dealWithTransferWarehouse(event, false);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        KDTEditEvent event = this.createKDTEditEvent(true);
        this.dealWithSupplyOrgUnit(event, false);
        this.dealWithDefaultWarehouse(event, false);
        this.dealWithStockTransfer(event, false);
        this.dealWithTransferOrgUnit(event, false);
        this.dealWithTransferWarehouse(event, false);
    }

    private void dealWithSupplyOrgUnit(KDTEditEvent e, boolean isLoadFields) {
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (null == storageOrgUnitInfo) {
            return;
        }
        int startIndex = -1;
        int endIndex = -1;
        if (null == e) {
            startIndex = 0;
            endIndex = this.kdtEntrys.getRowCount();
        } else {
            startIndex = e.getRowIndex();
            if (startIndex == -1) {
                startIndex = 0;
            }
            endIndex = startIndex + 1;
        }
        MaterialProvideTypeEnum provideType = MaterialProvideTypeEnum.NONE;
        FilterInfo filter = null;
        String orgUnitId = storageOrgUnitInfo.getId().toString();
        IRow curRow = null;
        boolean isLocked = true;
        String queryInfo = "com.kingdee.eas.basedata.org.app.StorageItemQuery";
        for (int i = startIndex; i < endIndex; ++i) {
            EntityViewInfo viewInfo;
            KDBizPromptBox sou;
            curRow = this.kdtEntrys.getRow(i);
            provideType = (MaterialProvideTypeEnum)curRow.getCell(TB_PROVIDETYPE).getValue();
            if (provideType.equals((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE)) {
                isLocked = true;
            } else if (provideType.equals((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE)) {
                sou = this.createKDBizPromptBox(queryInfo);
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgUnitId, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1), CompareType.EQUALS));
                viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filter);
                sou.setEntityViewInfo(viewInfo);
                curRow.getCell(TB_SUPPLYORGUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)sou));
                isLocked = false;
            } else if (provideType.equals((Object)MaterialProvideTypeEnum.SPANORGPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE)) {
                sou = this.createKDBizPromptBox(queryInfo);
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgUnitId, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1), CompareType.EQUALS));
                viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filter);
                sou.setEntityViewInfo(viewInfo);
                curRow.getCell(TB_SUPPLYORGUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)sou));
                isLocked = false;
            }
            this.setCellLocked(curRow, TB_SUPPLYORGUNIT, isLocked);
        }
    }

    private void dealWithDefaultWarehouse(KDTEditEvent e, boolean isLoadFields) {
        int startIndex = -1;
        int endIndex = -1;
        if (null == e) {
            startIndex = 0;
            endIndex = this.kdtEntrys.getRowCount();
        } else {
            startIndex = e.getRowIndex();
            if (startIndex == -1) {
                startIndex = 0;
            }
            endIndex = startIndex + 1;
        }
        MaterialProvideTypeEnum provideType = MaterialProvideTypeEnum.NONE;
        IRow curRow = null;
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        KDBizPromptBox wareF7 = null;
        boolean isLocked = true;
        for (int i = startIndex; i < endIndex; ++i) {
            curRow = this.kdtEntrys.getRow(i);
            provideType = (MaterialProvideTypeEnum)curRow.getCell(TB_PROVIDETYPE).getValue();
            if (provideType.equals((Object)MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGPROVIDE)) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)curRow.getCell(TB_SUPPLYORGUNIT).getValue();
                wareF7 = this.createDefaultWarehouseKDBizPromptBox(storageOrgUnitInfo);
                curRow.getCell(TB_DEFAULTWAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)wareF7));
                if (curRow.getCell(TB_SUPPLYORGUNIT).getValue() != null) {
                    isLocked = false;
                }
            } else if (provideType.equals((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE)) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
                wareF7 = this.createDefaultWarehouseKDBizPromptBox(storageOrgUnitInfo);
                curRow.getCell(TB_DEFAULTWAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)wareF7));
                isLocked = false;
            }
            this.setCellLocked(curRow, TB_DEFAULTWAREHOUSE, isLocked);
        }
    }

    private void dealWithStockTransfer(KDTEditEvent e, boolean isLoadFields) {
        int colIndex = 0;
        int startIndex = -1;
        int endIndex = -1;
        if (null == e) {
            startIndex = 0;
            endIndex = this.kdtEntrys.getRowCount();
        } else {
            startIndex = e.getRowIndex();
            if (startIndex == -1) {
                startIndex = 0;
            }
            endIndex = startIndex + 1;
            colIndex = e.getColIndex();
        }
        IRow curRow = null;
        String fieldName = this.kdtEntrys.getColumnKey(colIndex);
        boolean isStockTransferColumn = TB_ISSTOCKTRANSFER.equals(fieldName);
        for (int i = startIndex; i < endIndex; ++i) {
            Boolean isChecked;
            curRow = this.kdtEntrys.getRow(i);
            this.setBackFlushOrStockTransferLocked(curRow, TB_ISSTOCKTRANSFER);
            if (!isLoadFields) {
                this.setBackFlushOrStockTransferNotChecked(curRow, TB_ISSTOCKTRANSFER);
                isChecked = null;
                if (isStockTransferColumn) {
                    isChecked = (Boolean)e.getValue();
                    curRow.getCell(TB_ISSTOCKTRANSFER).setValue((Object)isChecked);
                } else {
                    isChecked = (Boolean)curRow.getCell(TB_ISSTOCKTRANSFER).getValue();
                }
                if (isChecked.booleanValue()) {
                    curRow.getCell(TB_TRANSFERORGUNIT).setValue(this.prmtstorageOrgUnit.getValue());
                    this.setCellLocked(curRow, TB_TRANSFERORGUNIT, false);
                } else {
                    curRow.getCell(TB_TRANSFERORGUNIT).setValue(null);
                    this.setCellLocked(curRow, TB_TRANSFERORGUNIT, true);
                }
                this.dealWithTransferWarehouse(e, false);
                curRow.getCell(TB_TRANSFERWAREHOUSE).setValue(null);
                continue;
            }
            isChecked = (Boolean)curRow.getCell(TB_ISSTOCKTRANSFER).getValue();
            boolean isLocked = true;
            if (isChecked.booleanValue()) {
                isLocked = false;
            }
            this.setCellLocked(curRow, TB_TRANSFERORGUNIT, isLocked);
        }
    }

    private void dealWithTransferOrgUnit(KDTEditEvent e, boolean isLoadFields) {
        int startIndex = -1;
        int endIndex = -1;
        if (null == e) {
            startIndex = 0;
            endIndex = this.kdtEntrys.getRowCount();
        } else {
            startIndex = e.getRowIndex();
            if (startIndex == -1) {
                startIndex = 0;
            }
            endIndex = startIndex + 1;
        }
        IRow curRow = null;
        for (int i = startIndex; i < endIndex; ++i) {
            curRow = this.kdtEntrys.getRow(i);
            if (isLoadFields) continue;
            curRow.getCell(TB_TRANSFERORGUNIT).setValue(null);
        }
    }

    private void dealWithTransferWarehouse(KDTEditEvent e, boolean isLoadFields) {
        int startIndex = -1;
        int endIndex = -1;
        if (null == e) {
            startIndex = 0;
            endIndex = this.kdtEntrys.getRowCount();
        } else {
            startIndex = e.getRowIndex();
            if (startIndex == -1) {
                startIndex = 0;
            }
            endIndex = startIndex + 1;
        }
        MaterialProvideTypeEnum provideType = MaterialProvideTypeEnum.NONE;
        boolean isStockTransfer = false;
        StorageOrgUnitInfo transferOrgUnit = null;
        StorageOrgUnitInfo currOrgUnit = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        WarehouseInfo excludeWarehouse = null;
        IRow curRow = null;
        for (int i = startIndex; i < endIndex; ++i) {
            String wareHouse2;
            String wareHouse1;
            curRow = this.kdtEntrys.getRow(i);
            provideType = (MaterialProvideTypeEnum)curRow.getCell(TB_PROVIDETYPE).getValue();
            if ((MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE.equals((Object)provideType) || MaterialProvideTypeEnum.CURRENTORGPROVIDE.equals((Object)provideType)) && curRow.getCell(TB_TRANSFERWAREHOUSE).getValue() != null && curRow.getCell(TB_DEFAULTWAREHOUSE).getValue() != null && (wareHouse1 = ((WarehouseInfo)this.kdtEntrys.getCell(i, TB_TRANSFERWAREHOUSE).getValue()).getId().toString()).equals(wareHouse2 = ((WarehouseInfo)this.kdtEntrys.getCell(i, TB_DEFAULTWAREHOUSE).getValue()).getId().toString()) && !isLoadFields) {
                curRow.getCell(TB_TRANSFERWAREHOUSE).setValue(null);
            }
            if (curRow.getCell(TB_ISSTOCKTRANSFER).getValue() != null) {
                isStockTransfer = (Boolean)this.kdtEntrys.getCell(i, TB_ISSTOCKTRANSFER).getValue();
            }
            if (!isStockTransfer) {
                if (!isLoadFields) {
                    curRow.getCell(TB_TRANSFERWAREHOUSE).setValue(null);
                }
                curRow.getCell(TB_TRANSFERWAREHOUSE).getStyleAttributes().setLocked(true);
                continue;
            }
            curRow.getCell(TB_TRANSFERWAREHOUSE).getStyleAttributes().setLocked(false);
            transferOrgUnit = (StorageOrgUnitInfo)this.kdtEntrys.getCell(i, TB_TRANSFERORGUNIT).getValue();
            if (transferOrgUnit != null && currOrgUnit != null && transferOrgUnit.getId().toString().equals(currOrgUnit.getId().toString())) {
                excludeWarehouse = (WarehouseInfo)this.kdtEntrys.getCell(i, TB_DEFAULTWAREHOUSE).getValue();
            }
            if (transferOrgUnit == null) {
                if (!isLoadFields) {
                    curRow.getCell(TB_TRANSFERWAREHOUSE).setValue(null);
                }
                curRow.getCell(TB_TRANSFERWAREHOUSE).getStyleAttributes().setLocked(true);
                continue;
            }
            KDBizPromptBox warehouse = new KDBizPromptBox();
            warehouse.setEditable(true);
            warehouse.setDisplayFormat("$name$");
            warehouse.setEditFormat("$number$");
            warehouse.setCommitFormat("$number$");
            warehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
            curRow.getCell(TB_TRANSFERWAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)warehouse));
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            viewInfo.setFilter(filterInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)transferOrgUnit.getId().toString(), CompareType.EQUALS));
            if (excludeWarehouse != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)excludeWarehouse.getId().toString(), CompareType.NOTEQUALS));
            }
            viewInfo.setFilter(filterInfo);
            warehouse.setEntityViewInfo(viewInfo);
        }
    }

    private void dealWithBackFlush(KDTEditEvent e, boolean isLoadFields) {
        int startIndex = -1;
        int endIndex = -1;
        if (null == e) {
            startIndex = 0;
            endIndex = this.kdtEntrys.getRowCount();
        } else {
            startIndex = e.getRowIndex();
            if (startIndex == -1) {
                startIndex = 0;
            }
            endIndex = startIndex + 1;
        }
        IRow curRow = null;
        for (int i = startIndex; i < endIndex; ++i) {
            curRow = this.kdtEntrys.getRow(i);
            this.setBackFlushOrStockTransferLocked(curRow, TB_ISBACKFLUSH);
            if (isLoadFields) continue;
            this.setBackFlushOrStockTransferNotChecked(curRow, TB_ISBACKFLUSH);
        }
    }

    private void dealWithPickingMode(KDTEditEvent e, boolean isLoadFields) {
        int startIndex = -1;
        int endIndex = -1;
        if (null == e) {
            startIndex = 0;
            endIndex = this.kdtEntrys.getRowCount();
        } else {
            startIndex = e.getRowIndex();
            if (startIndex == -1) {
                startIndex = 0;
            }
            endIndex = startIndex + 1;
        }
        MaterialProvideTypeEnum provideType = null;
        MaterialProductEnum outputType = null;
        MaterialIssueModeEnum issueMode = null;
        IRow curRow = null;
        boolean isLocked = false;
        for (int i = startIndex; i < endIndex; ++i) {
            curRow = this.kdtEntrys.getRow(i);
            provideType = (MaterialProvideTypeEnum)curRow.getCell(TB_PROVIDETYPE).getValue();
            if (curRow.getCell(TB_PRODUCTTYPE).getValue() != null) {
                outputType = (MaterialProductEnum)curRow.getCell(TB_PRODUCTTYPE).getValue();
            }
            if (MaterialProductEnum.RELATEDPRODUCT.equals(outputType) || MaterialProductEnum.BYPRODUCT.equals((Object)outputType)) {
                issueMode = MaterialIssueModeEnum.NOTISSMODE;
                isLocked = true;
            } else if (MaterialProductEnum.OTHER.equals((Object)outputType)) {
                if (provideType.equals((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGPROVIDE)) {
                    issueMode = MaterialIssueModeEnum.PRODUCEISSMODE;
                    isLocked = true;
                } else if (MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE.equals((Object)provideType)) {
                    issueMode = MaterialIssueModeEnum.STRAIGHT;
                    isLocked = true;
                } else if (MaterialProvideTypeEnum.CURRENTORGPROVIDE.equals((Object)provideType)) {
                    issueMode = (MaterialIssueModeEnum)curRow.getCell(TB_PICKINGMODE).getValue();
                    isLocked = false;
                }
            }
            if (!isLoadFields) {
                curRow.getCell(TB_PICKINGMODE).setValue((Object)issueMode);
            }
            this.setCellLocked(curRow, TB_PICKINGMODE, isLocked);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.material.id"));
        sic.add(new SelectorItemInfo("entrys.material.name"));
        sic.add(new SelectorItemInfo("entrys.material.number"));
        sic.add(new SelectorItemInfo("entrys.material.model"));
        sic.add(new SelectorItemInfo("entrys.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit"));
        sic.add(new SelectorItemInfo("entrys.material.assistUnit"));
        sic.add(new SelectorItemInfo("entrys.unit.id"));
        sic.add(new SelectorItemInfo("entrys.unit.name"));
        sic.add(new SelectorItemInfo("entrys.unit.number"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.id"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.name"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.number"));
        sic.add(new SelectorItemInfo("entrys.materialInventory.id"));
        sic.add(new SelectorItemInfo("entrys.materialInventory.materialAttribute"));
        sic.add(new SelectorItemInfo("entrys.materialInventory.issueMode"));
        sic.add(new SelectorItemInfo("entrys.location.*"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.menuItemCancel.setEnabled(true);
        this.menuItemCancel.setVisible(true);
        this.menuItemCancelCancel.setEnabled(true);
        this.menuItemCancelCancel.setVisible(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancelCancel.setVisible(true);
        this.btnCancel.setIsControlByParent(false);
        this.btnCancel.setTextIconDisStyle((short)3);
        this.btnCancelCancel.setIsControlByParent(false);
        this.btnCancelCancel.setTextIconDisStyle((short)3);
        this.btnCopyLine.setVisible(false);
        this.menuItemCopyLine.setVisible(true);
        this.menuItemCopyLine.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
    }

    protected void addListeners() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        ProductionFormulaEditUI.this.kdtEntries_Changed(e);
                    }
                    catch (Exception exc) {
                        ProductionFormulaEditUI.this.handUIException(exc);
                    }
                }

                public void editStarting(KDTEditEvent e) {
                    try {
                        ProductionFormulaEditUI.this.kdtEntries_Changed(e);
                    }
                    catch (Exception exc) {
                        ProductionFormulaEditUI.this.handUIException(exc);
                    }
                }

                public void editValueChanged(KDTEditEvent e) {
                    try {
                        ProductionFormulaEditUI.this.kdtEntries_EditValueChanged(e);
                    }
                    catch (Exception exc) {
                        ProductionFormulaEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntrys.addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.activeCellListener == null) {
            this.activeCellListener = new KDTActiveCellListener(){

                public void activeCellChanged(KDTActiveCellEvent e) {
                    try {
                        ProductionFormulaEditUI.this.tableCellActived(e);
                    }
                    catch (Exception exc) {
                        ProductionFormulaEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntrys.addKDTActiveCellListener(this.activeCellListener);
        if (this.prmtMaterialListener == null) {
            this.prmtMaterialListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        ProductionFormulaEditUI.this.headMaterialChanged(e);
                    }
                    catch (Exception e1) {
                        ProductionFormulaEditUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.prmtmaterial.addDataChangeListener(this.prmtMaterialListener);
        if (this.prmtStorageListener == null) {
            this.prmtStorageListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        ProductionFormulaEditUI.this.headStorageChanged(e);
                    }
                    catch (Exception e1) {
                        ProductionFormulaEditUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.prmtstorageOrgUnit.addDataChangeListener(this.prmtStorageListener);
        if (this.prodLineListener == null) {
            this.prodLineListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ProductionFormulaEditUI.this.prodLineChanged(e);
                }
            };
        }
        this.prmtproductLine.addDataChangeListener(this.prodLineListener);
        if (this.bomListener == null) {
            this.bomListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ProductionFormulaEditUI.this.bomChanged(e);
                }
            };
        }
        this.prmtbom.addDataChangeListener(this.bomListener);
        if (this.qtyChangeLister == null) {
            this.qtyChangeLister = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ProductionFormulaEditUI.this.qtyChanged(e);
                }
            };
        }
        this.txtproductQty.addDataChangeListener(this.qtyChangeLister);
        if (this.yieldChangeLister == null) {
            this.yieldChangeLister = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ProductionFormulaEditUI.this.yieldChanged(e);
                }
            };
        }
        this.txtyield.addDataChangeListener(this.yieldChangeLister);
    }

    protected void removeListener() {
        if (this.entryTableChange != null) {
            this.kdtEntrys.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
        if (this.activeCellListener != null) {
            this.kdtEntrys.removeKDTActiveCellListener(this.activeCellListener);
        }
        if (this.prmtMaterialListener != null) {
            this.prmtmaterial.removeDataChangeListener(this.prmtMaterialListener);
        }
        if (this.prmtStorageListener != null) {
            this.prmtmaterial.removeDataChangeListener(this.prmtStorageListener);
        }
        if (this.prodLineListener != null) {
            this.prmtproductLine.removeDataChangeListener(this.prodLineListener);
        }
        if (this.bomListener != null) {
            this.prmtbom.removeDataChangeListener(this.bomListener);
        }
        if (this.qtyChangeLister != null) {
            this.txtproductQty.removeDataChangeListener(this.qtyChangeLister);
        }
        if (this.yieldChangeLister != null) {
            this.txtyield.removeDataChangeListener(this.yieldChangeLister);
        }
    }

    private void yieldChanged(DataChangeEvent e) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getNewValue());
        if (e.getNewValue() != null && isDiffrent) {
            BigDecimal yield = this.txtyield.getBigDecimalValue();
            if (yield.compareTo(MMConstant.BIGDECIMAL_ZERO) <= 0) {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"yieldGTZero"));
                this.txtyield.setValue(null);
                this.txtyield.requestFocusInWindow();
            }
            if (yield.compareTo(new BigDecimal("100")) > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"yieldLTOne"));
                this.txtyield.setValue(null);
                this.txtyield.requestFocusInWindow();
            }
        }
    }

    private void qtyChanged(DataChangeEvent e) {
        MaterialInfo material = (MaterialInfo)this.prmtmaterial.getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)this.prmtunit.getValue();
        if (e.getNewValue() != null && material != null && unit != null) {
            MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.pmtbaseUnit.getValue();
            BigDecimal qty = this.txtproductQty.getBigDecimalValue();
            try {
                BigDecimal baseQty = SCMUtils.getExchangePricesionQtyForClient((String)material.getId().toString(), (MeasureUnitInfo)unit, (MeasureUnitInfo)baseUnit, (BigDecimal)qty);
                this.txtproductBaseQty.setValue((Object)baseQty);
            }
            catch (EASBizException e1) {
                this.handUIException(e1);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    private void headMaterialChanged(DataChangeEvent e) throws Exception {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent && e.getNewValue() != null) {
            MaterialInfo material = (MaterialInfo)e.getNewValue();
            this.kdtEntrys.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(false);
            if (this.isCopy && this.kdtEntrys.getRowCount() > 0) {
                if (MsgBox.showConfirm2New((Component)((Object)this), (String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"Msg_IsDeleteEntry")) == 0) {
                    if (this.kdtEntrys.getRowCount() > 0) {
                        this.kdtEntrys.removeRows();
                    }
                    if (this.editData.getEntrys() != null) {
                        this.editData.getEntrys().clear();
                    }
                } else {
                    for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                        Object value = this.kdtEntrys.getCell(i, TB_MATERIAL).getValue();
                        if (value == null || !(value instanceof MaterialInfo)) continue;
                        MaterialInfo rowMa = (MaterialInfo)value;
                        if (!material.getId().toString().equals(rowMa.getId().toString())) continue;
                        this.kdtEntrys.getCell(i, TB_MATERIAL).setValue(null);
                        this.kdtEntrys.getCell(i, TB_MATERIALNAME).setValue(null);
                        this.kdtEntrys.getCell(i, TB_MATERIALMODEL).setValue(null);
                        this.kdtEntrys.getCell(i, TB_UNIT).setValue(null);
                        this.kdtEntrys.getCell(i, TB_BASEUNIT).setValue(null);
                        this.kdtEntrys.getCell(i, TB_MATERIALINVENTORY).setValue(null);
                        this.kdtEntrys.getCell(i, TB_MATERIALCHARA).setValue(null);
                        this.kdtEntrys.getCell(i, TB_PICKINGMODE).setValue(null);
                        this.kdtEntrys.getCell(i, TB_PRODUCTTYPE).setValue(null);
                        this.kdtEntrys.getCell(i, TB_DEFAULTWAREHOUSE).setValue(null);
                        this.kdtEntrys.getCell(i, TB_LOCATION).setValue(null);
                        this.kdtEntrys.getCell(i, TB_PROVIDETYPE).setValue((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE);
                    }
                }
            } else {
                if (this.kdtEntrys.getRowCount() > 0) {
                    this.kdtEntrys.removeRows();
                }
                if (this.editData.getEntrys() != null) {
                    this.editData.getEntrys().clear();
                }
                this.actionAddLine_actionPerformed(null);
            }
            try {
                StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
                MaterialInfo[] materialInfos = new MaterialInfo[]{material};
                this.headVO = UIHelper.getDataVO((StorageOrgUnitInfo)storageOrgInfo, (MaterialInfo[])materialInfos);
                String key1 = material.getId().toString() + storageOrgInfo.getId().toString();
                MaterialPlanInfo mpInfo = (MaterialPlanInfo)this.headVO.getMaterialPlanInfos().get(key1);
                this.materialPlanMap.put(key1, mpInfo);
                MeasureUnitInfo prodUnit = this.headVO.getMeasureUnitInfos()[0];
                this.prmtunit.setValue((Object)prodUnit);
                this.txheadMaterialModel.setText(material.getModel());
                this.pmtbaseUnit.setValue((Object)this.headVO.getBaseMeasureUnitInfos()[0]);
                String key = material.getId().toString() + prodUnit.getId().toString();
                int unitPrec = 4;
                if (this.headVO.getMmuPrecisions().get(key) != null) {
                    unitPrec = (Integer)this.headVO.getMmuPrecisions().get(key);
                }
                this.txtproductQty.setValue((Object)new BigDecimal("1"));
                this.txtproductQty.setPrecision(unitPrec);
                key = material.getId().toString() + material.getBaseUnit().getId().toString();
                unitPrec = (Integer)this.headVO.getMmuPrecisions().get(key);
                this.txtproductBaseQty.setPrecision(unitPrec);
                try {
                    String materialId = material.getId().toString();
                    MeasureUnitInfo unitInfo = this.headVO.getBaseMeasureUnitInfos()[0];
                    BigDecimal oneBd = new BigDecimal("1");
                    BigDecimal baseQty = SCMUtils.getExchangePricesionQtyForClient((String)materialId, (MeasureUnitInfo)prodUnit, (MeasureUnitInfo)unitInfo, (BigDecimal)oneBd);
                    this.txtproductBaseQty.setValue((Object)baseQty);
                }
                catch (EASBizException e1) {
                    this.handUIException(e1);
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
                this.txtyield.setValue((Object)mpInfo.getYield());
                this.setTrackEnabled(mpInfo);
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
            this.prmtbom.setValue(null);
            this.initBOMF7();
        } else if (e.getNewValue() == null) {
            this.prmtbom.setEnabled(false);
        }
    }

    private void headStorageChanged(DataChangeEvent e) throws Exception {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent) {
            this.kdtEntrys.removeRows();
            if (this.editData.getEntrys() != null) {
                this.editData.getEntrys().clear();
            }
            this.actionAddLine_actionPerformed(null);
            this.prmtmaterial.setValue(null);
            this.txtname.setText(null);
            this.prmtproductLine.setValue(null);
            this.prmtmaterial.setValue(null);
            this.txheadMaterialModel.setText(null);
            this.prmtbom.setValue(null);
            this.prmtunit.setValue(null);
            this.txtproductQty.setValue(null);
            this.txtyield.setValue(null);
            this.ckIsDefault.setSelected(false);
        }
        if (isDiffrent && e.getNewValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"storageOrgCanotNull"));
            this.prmtstorageOrgUnit.requestFocusInWindow();
            this.prmtproductLine.setEnabled(false);
            this.prmtmaterial.setEnabled(false);
            this.prmtstorageOrgUnit.setValue(e.getOldValue());
        } else if (isDiffrent && e.getNewValue() != null) {
            this.prmtproductLine.setEnabled(true);
            this.prmtmaterial.setEnabled(true);
            this.dealWithSupplyOrgUnit(null, false);
            this.dealWithDefaultWarehouse(null, false);
            this.dealWithStockTransfer(null, false);
            this.dealWithTransferOrgUnit(null, false);
            this.dealWithTransferWarehouse(null, false);
        }
        this.prmtstorageOrgUnit.commitEdit();
    }

    private void prodLineChanged(DataChangeEvent e) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent && e.getNewValue() != null && e.getNewValue() instanceof ProductLineInfo) {
            this.kdtEntrys.getColumn(TB_LINEWP).getStyleAttributes().setLocked(false);
            int size = this.kdtEntrys.getRowCount();
            for (int i = 0; i < size; ++i) {
                this.kdtEntrys.getCell(i, TB_LINEWP).setValue(null);
            }
            this.initProductLineWPF7();
        }
    }

    private void bomChanged(DataChangeEvent e) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent && e.getNewValue() != null) {
            BomInfo tBomInfo = (BomInfo)e.getNewValue();
            BomInfo bomInfo = this.getBomInfo(tBomInfo.getId().toString());
            this.txtproductQty.setValue((Object)bomInfo.getProductQty());
            this.txtproductBaseQty.setValue((Object)bomInfo.getProductBaseQty());
            this.txtyield.setValue((Object)bomInfo.getYield());
            this.prmtTrack.setValue((Object)((TrackNumberInfo)tBomInfo.get("orderTrack")));
            if (bomInfo != null && null != this.getMainBizOrg().getData()) {
                if (this.kdtEntrys.getRowCount() > 0) {
                    this.kdtEntrys.removeRows();
                    if (this.editData.getEntrys() != null) {
                        this.editData.getEntrys().clear();
                    }
                }
                Map mmuPrecMap = (Map)bomInfo.get("mulUnitMap");
                StorageOrgUnitInfo org = (StorageOrgUnitInfo)this.getMainBizOrg().getData();
                MaterialInfo[] materialInfos = null;
                ArrayList<MaterialInfo> materialInfoList = new ArrayList<MaterialInfo>();
                int size = bomInfo.getEntrys().size();
                for (int i = 0; i < size; ++i) {
                    BomEntryInfo bomEntry = bomInfo.getEntrys().get(i);
                    MaterialInfo materialInfo = bomEntry.getMaterial();
                    materialInfoList.add(materialInfo);
                }
                SCMEntryDataVO voResult = null;
                if (materialInfoList.size() > 0) {
                    materialInfos = new MaterialInfo[materialInfoList.size()];
                    for (int i = 0; i < materialInfoList.size(); ++i) {
                        materialInfos[i] = (MaterialInfo)materialInfoList.get(i);
                    }
                    try {
                        voResult = UIHelper.getDataVO((StorageOrgUnitInfo)org, (MaterialInfo[])materialInfos);
                    }
                    catch (Exception e1) {
                        this.handleException(e1);
                    }
                }
                Map ConsumeFixQty = (Map)bomInfo.get("ConsumeFixQty");
                Map Proportion = (Map)bomInfo.get("Proportion");
                int size2 = bomInfo.getEntrys().size();
                for (int i = 0; i < size2; ++i) {
                    BigDecimal baseQty;
                    BomEntryInfo bomEntry = bomInfo.getEntrys().get(i);
                    ProductionFormulaEntryInfo entry = new ProductionFormulaEntryInfo();
                    entry.setMaterial(bomEntry.getMaterial());
                    entry.setUnit(bomEntry.getUnit());
                    entry.setBaseUnit(bomEntry.getBaseUnit());
                    entry.setMaterialInventory(bomEntry.getMaterialInventory());
                    entry.setIsStock(true);
                    if (bomEntry.getMaterialInventory() != null) {
                        if (bomEntry.getMaterialInventory().getMaterialAttr() != null) {
                            entry.getMaterialInventory().setMaterialAttr(bomEntry.getMaterialInventory().getMaterialAttr());
                        }
                        if (bomEntry.getMaterialInventory().getIssMode() != null) {
                            entry.getMaterialInventory().setIssMode(bomEntry.getMaterialInventory().getIssMode());
                        }
                        if (bomEntry.getMaterialInventory().getOutputType() != null) {
                            entry.getMaterialInventory().setOutputType(bomEntry.getMaterialInventory().getOutputType());
                        }
                    }
                    String key = bomEntry.getMaterial().getId().toString() + org.getId().toString();
                    MaterialInventoryInfo materialInv = null;
                    if (voResult != null && voResult.getMaterialPlanInfos() != null) {
                        MaterialPlanInfo materialPlan = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key);
                        materialInv = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key);
                        entry.setPickingLeadTime(materialPlan.getIssueLeadTime());
                        entry.setIsBackFlush(materialPlan.getBoolean(TB_ISBACKFLUSH));
                    }
                    entry.setMaterialAttr(bomEntry.getMaterialChar());
                    entry.setProductType(bomEntry.getOutputType());
                    entry.setConsumeType(bomEntry.getConsumeType());
                    BigDecimal qty = (BigDecimal)ConsumeFixQty.get(bomEntry.getId().toString());
                    BigDecimal proportion = (BigDecimal)Proportion.get(bomEntry.getId().toString());
                    if (qty != null || proportion != null) {
                        if (bomEntry.getConsumeType().equals((Object)ConsumeTypeEnum.VariableAmount)) {
                            baseQty = MMConstant.BIGDECIMAL_ZERO;
                            try {
                                baseQty = SCMUtils.getExchangePricesionQtyForClient((String)bomEntry.getMaterial().getId().toString(), (MeasureUnitInfo)bomEntry.getUnit(), (MeasureUnitInfo)bomEntry.getBaseUnit(), (BigDecimal)qty);
                            }
                            catch (EASBizException e1) {
                                this.handUIException(e1);
                            }
                            catch (BOSException e1) {
                                this.handUIException(e1);
                            }
                            entry.setConsumeFixQty(qty.multiply(bomInfo.getProductQty()));
                            entry.setConsumeFixBaseQty(baseQty.multiply(bomInfo.getProductQty()));
                        } else {
                            entry.setProportion(bomEntry.getProportion());
                        }
                    } else if (bomEntry.getConsumeFixBaseQty() == null) {
                        try {
                            baseQty = MMConstant.BIGDECIMAL_ZERO;
                            if (bomEntry.getConsumeFixQty() != null) {
                                baseQty = SCMUtils.getExchangePricesionQtyForClient((String)bomEntry.getMaterial().getId().toString(), (MeasureUnitInfo)bomEntry.getUnit(), (MeasureUnitInfo)bomEntry.getBaseUnit(), (BigDecimal)bomEntry.getConsumeFixQty());
                            }
                            entry.setConsumeFixBaseQty(baseQty);
                        }
                        catch (EASBizException e1) {
                            this.handUIException(e1);
                        }
                        catch (BOSException e1) {
                            this.handUIException(e1);
                        }
                    } else {
                        entry.setConsumeFixBaseQty(bomEntry.getConsumeFixBaseQty());
                        entry.setConsumeFixQty(bomEntry.getConsumeFixQty());
                        entry.setProportion(bomEntry.getProportion());
                    }
                    entry.setLeadtime(bomEntry.getLeadtime());
                    entry.setEffectiveDate(bomEntry.getEffectiveDate());
                    entry.setDisableDate(bomEntry.getDisableDate());
                    entry.setProvideType(bomEntry.getProvideType());
                    entry.setPickingMode(bomEntry.getIssMode());
                    entry.setWarehouse(bomEntry.getDefaultWarehouse());
                    entry.setLocation(bomEntry.getLocation());
                    entry.setSupplyStorageOrgUnit(bomEntry.getSupplyOrgUnit());
                    entry.setIsStock(bomEntry.isIsStockTransfer());
                    entry.setSourceStorageOrgUnit(bomEntry.getTransferOrgUnit());
                    entry.setMoveOutWareHouse(bomEntry.getTransferWarehouse());
                    entry.setIsBackFlush(bomEntry.isIsBackFlush());
                    IRow row = this.kdtEntrys.addRow();
                    this.loadLineFields(this.kdtEntrys, row, (IObjectValue)entry);
                    this.dealWithSupplyOrgUnit(null, true);
                    this.dealWithDefaultWarehouse(null, true);
                    this.dealWithStockTransfer(null, true);
                    this.dealWithTransferOrgUnit(null, true);
                    this.dealWithTransferWarehouse(null, true);
                    this.dealWithBackFlush(null, true);
                    this.dealWithPickingMode(null, true);
                    ConsumeTypeEnum consumeType = bomEntry.getConsumeType();
                    if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                        row.getCell(TB_PROPORTION).getStyleAttributes().setLocked(false);
                        row.getCell(TB_PRODUCTQTY).getStyleAttributes().setLocked(true);
                    } else {
                        row.getCell(TB_PROPORTION).getStyleAttributes().setLocked(true);
                        row.getCell(TB_PRODUCTQTY).getStyleAttributes().setLocked(false);
                    }
                    if (materialInv != null && materialInv.isIsLotNumber()) {
                        row.getCell(TB_ISBACKFLUSH).getStyleAttributes().setLocked(true);
                        entry.setIsBackFlush(false);
                    } else {
                        row.getCell(TB_ISBACKFLUSH).getStyleAttributes().setLocked(false);
                    }
                    SCMClientUtils.changeTableColPrecision((Map)mmuPrecMap, (MaterialInfo)bomEntry.getMaterial(), (MeasureUnitInfo)bomEntry.getUnit(), (KDTable)this.kdtEntrys, (String[])QTYPRECISIONFROMUNITTAB, (int)row.getRowIndex());
                    SCMClientUtils.changeTableColPrecision((Map)mmuPrecMap, (MaterialInfo)bomEntry.getMaterial(), (MeasureUnitInfo)bomEntry.getBaseUnit(), (KDTable)this.kdtEntrys, (String[])QTYPRECISIONFROMBASEUNITTAB, (int)row.getRowIndex());
                }
            }
        }
    }

    private BomInfo getBomInfo(String bomId) {
        BomInfo bomInfo = null;
        try {
            IProductionFormula forumlaCtrl = (IProductionFormula)this.getBizInterface();
            bomInfo = forumlaCtrl.getBOM(bomId);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        return bomInfo;
    }

    public void onLoad() throws Exception {
        this.cleanBtnText();
        super.onLoad();
        this.initPickingModeValue();
        UIHelper.registerTrackNumberF7ForEdit((KDBizPromptBox)this.prmtstorageOrgUnit, null, null, (KDBizPromptBox)this.prmtTrack, (boolean)false);
        this.setMaterialFilter();
        this.kdtEntrys.getActionMap().remove("Paste");
        String dateFormatString = CtrlFormatUtilities.getDateFormatString();
        KDDatePicker dpReqDate = new KDDatePicker();
        this.kdtEntrys.getColumn(TB_EFFECTIVEDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(dpReqDate));
        this.kdtEntrys.getColumn(TB_EFFECTIVEDATE).getStyleAttributes().setNumberFormat(dateFormatString);
        KDDatePicker dpPickingDate = new KDDatePicker();
        this.kdtEntrys.getColumn(TB_DISABLEDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(dpPickingDate));
        this.kdtEntrys.getColumn(TB_DISABLEDATE).getStyleAttributes().setNumberFormat(dateFormatString);
        int precision = 2;
        String colPrecision = PrecisionUtil.getFormatString((int)precision);
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(2);
        colTxtField.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
        colTxtField.setMinimumValue((Comparable)MMConstant.BIGDECIMAL_ZERO);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setNegatived(false);
        colTxtField.setPercentDisplay(false);
        KDComboBox comboxProvideType = (KDComboBox)this.kdtEntrys.getColumn(TB_PROVIDETYPE).getEditor().getComponent();
        comboxProvideType.removeItem((Object)MaterialProvideTypeEnum.NONE);
        this.kdtEntrys.getColumn(TB_PROPORTION).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
        this.kdtEntrys.getColumn(TB_PROPORTION).getStyleAttributes().setNumberFormat(colPrecision);
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            ConsumeTypeEnum consumeType = (ConsumeTypeEnum)((Object)this.kdtEntrys.getCell(i, TB_CONSUMETYPE).getValue());
            if (consumeType == null) continue;
            if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                this.kdtEntrys.getCell(i, TB_PROPORTION).getStyleAttributes().setLocked(false);
                this.kdtEntrys.getCell(i, TB_PRODUCTQTY).getStyleAttributes().setLocked(true);
                this.kdtEntrys.getCell(i, TB_PRODUCTQTY).setValue((Object)MMConstant.BIGDECIMAL_ZERO);
                continue;
            }
            this.kdtEntrys.getCell(i, TB_PROPORTION).getStyleAttributes().setLocked(true);
            this.kdtEntrys.getCell(i, TB_PROPORTION).setValue((Object)MMConstant.BIGDECIMAL_ZERO);
            this.kdtEntrys.getCell(i, TB_PRODUCTQTY).getStyleAttributes().setLocked(false);
        }
        KDTDefaultCellEditor column = (KDTDefaultCellEditor)this.kdtEntrys.getColumn(TB_PRODUCTTYPE).getEditor();
        KDComboBox combox = (KDComboBox)column.getComponent();
        combox.removeAllItems();
        combox.addItems(new Object[]{MaterialProductEnum.OTHER, MaterialProductEnum.BYPRODUCT, MaterialProductEnum.RELATEDPRODUCT});
        this.prmtmaterial.setDisplayFormat("$name$ ");
        this.prmtmaterial.setEditFormat(" $number$");
        this.prmtmaterial.setCommitFormat("$number$");
        this.kdtEntrys.getActionMap().put("FocusChangeRow", (Action)new KDTFocusChangeAction(this.kdtEntrys, 0, false, false));
        this.kdtEntrys.getActionMap().put("FocusChangeCol", (Action)new KDTFocusChangeAction(this.kdtEntrys, 0, false, true));
        if (null == this.editData.getId()) {
            this.dealWithSupplyOrgUnit(null, false);
            this.dealWithDefaultWarehouse(null, false);
            this.dealWithStockTransfer(null, false);
            this.dealWithTransferOrgUnit(null, false);
            this.dealWithTransferWarehouse(null, false);
        }
        KDBizPromptBox supplyStorageOrgUnit = (KDBizPromptBox)this.kdtEntrys.getColumn(TB_SUPPLYORGUNIT).getEditor().getComponent();
        EntityViewInfo viewInfo = new EntityViewInfo();
        supplyStorageOrgUnit.setEntityViewInfo(viewInfo);
        FilterInfo filterInfo = supplyStorageOrgUnit.getEntityViewInfo().getFilter();
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        supplyStorageOrgUnit.setEntityViewInfo(viewInfo);
        KDBizPromptBox transferOrgUnit = (KDBizPromptBox)this.kdtEntrys.getColumn(TB_TRANSFERORGUNIT).getEditor().getComponent();
        viewInfo = new EntityViewInfo();
        transferOrgUnit.setEntityViewInfo(viewInfo);
        filterInfo = transferOrgUnit.getEntityViewInfo().getFilter();
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        transferOrgUnit.setEntityViewInfo(viewInfo);
        EntityViewInfo ev = SCMClientUtils.getWarehouseFilter((StorageOrgUnitInfo)this.editData.getStorageOrgUnit(), (int)-1);
        KDBizPromptBox kDBizPromptBoxWarehouse = new KDBizPromptBox();
        kDBizPromptBoxWarehouse.setEditable(true);
        kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
        kDBizPromptBoxWarehouse.setEditFormat("$number$");
        kDBizPromptBoxWarehouse.setCommitFormat("$number$");
        kDBizPromptBoxWarehouse.setEntityViewInfo(ev);
        for (int j = 0; j < this.kdtEntrys.getRowCount(); ++j) {
            Boolean isStock = (Boolean)this.kdtEntrys.getCell(j, TB_ISSTOCKTRANSFER).getValue();
            if (Boolean.TRUE.equals(isStock)) {
                this.kdtEntrys.getCell(j, TB_TRANSFERWAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
                this.setEntrySourceStorageOrgUnit(this.kdtEntrys.getRow(j));
                continue;
            }
            this.kdtEntrys.getCell(j, TB_TRANSFERWAREHOUSE).getStyleAttributes().setLocked(true);
            this.kdtEntrys.getCell(j, TB_TRANSFERWAREHOUSE).setValue(null);
            this.kdtEntrys.getCell(j, TB_TRANSFERORGUNIT).getStyleAttributes().setLocked(true);
            this.kdtEntrys.getCell(j, TB_TRANSFERORGUNIT).setValue(null);
        }
        KDTDefaultCellEditor materialCharaColumn = (KDTDefaultCellEditor)this.kdtEntrys.getColumn(TB_MATERIALCHARA).getEditor();
        KDComboBox materialCharaBox = (KDComboBox)materialCharaColumn.getComponent();
        materialCharaBox.removeAllItems();
        materialCharaBox.addItems(new Object[]{MaterialCharEnum.MASTERPROP, MaterialCharEnum.AUXILIARYPROP, MaterialCharEnum.REFERRENCEPROP});
        this.initBOMF7();
        F7BomSelectProcessor2 selector2 = new F7BomSelectProcessor2(this.prmtbom);
        this.prmtbom.setSelector((KDPromptSelector)selector2);
        this.prmtbom.setCommitParser((IParser)selector2);
        super.setReservationVisible(false);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.isCopy = this.isCoay;
        if (!this.isCopy && this.getOprtState() == "ADDNEW") {
            this.prmtbom.setValue(null);
            this.prmtbom.setEnabled(false);
            this.txheadMaterialModel.setText("");
        }
        try {
            this.initOtherF7();
            this.uiHelper.initInLoadFields(null);
            String unitId = null;
            String baseUnitId = null;
            if (null != this.editData && null != this.editData.getMaterial()) {
                if (null != this.editData.getBaseUnit()) {
                    baseUnitId = this.editData.getBaseUnit().getId().toString();
                }
                if (null != this.editData.getUnit()) {
                    unitId = this.editData.getUnit().getId().toString();
                }
                HashSet<String> set = new HashSet<String>();
                if (null != baseUnitId) {
                    set.add(baseUnitId);
                }
                if (null != unitId) {
                    set.add(unitId);
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("measureUnit.id"));
                sic.add(new SelectorItemInfo("qtyPrecision"));
                String materialId = this.editData.getMaterial().getId().toString();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", set, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                viewInfo.setSelector(sic);
                IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
                MultiMeasureUnitCollection mmuc = imultiUnit.getMultiMeasureUnitCollection(viewInfo);
                MultiMeasureUnitInfo mmui2 = null;
                for (MultiMeasureUnitInfo mmui2 : mmuc) {
                    if (mmui2.getMeasureUnit().getId().toString().equals(baseUnitId)) {
                        this.txtproductBaseQty.setPrecision(mmui2.getQtyPrecision());
                    }
                    if (!mmui2.getMeasureUnit().getId().toString().equals(unitId)) continue;
                    this.txtproductQty.setPrecision(mmui2.getQtyPrecision());
                }
                MaterialPlanInfo mplan = this.getMaterialPlanInfo(this.editData.getMaterial());
                this.setTrackEnabled(mplan);
            }
            if (null == unitId) {
                this.txtproductQty.setPrecision(6);
            }
            if (null == baseUnitId) {
                this.txtproductBaseQty.setPrecision(6);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.editData != null) {
            if (this.editData.getSourceBillId() != null) {
                this.prmtbom.setEnabled(false);
            } else {
                this.prmtbom.setEnabled(true);
            }
        }
        this.addListeners();
        SCMBillBaseInfo info = (SCMBillBaseInfo)this.dataBinder.getValueObject();
        if (this.getOprtState() == "VIEW" && info.getBaseStatus() != null) {
            if (info.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                this.actionCancelCancel.setEnabled(false);
                this.actionCancel.setEnabled(true);
            } else if (info.getBaseStatus() == BillBaseStatusEnum.DELETED) {
                this.actionCancelCancel.setEnabled(true);
                this.actionCancel.setEnabled(false);
            } else {
                this.actionCancelCancel.setEnabled(false);
                this.actionCancel.setEnabled(false);
            }
        }
        this.syncOldData((IObjectValue)this.editData);
        this.dealWithSupplyOrgUnit(null, true);
        this.dealWithDefaultWarehouse(null, true);
        this.dealWithStockTransfer(null, true);
        this.dealWithTransferOrgUnit(null, true);
        this.dealWithTransferWarehouse(null, true);
        this.dealWithBackFlush(null, true);
        this.dealWithPickingMode(null, true);
        IRow row = null;
        MaterialProductEnum mpe = null;
        int count = this.kdtEntrys.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtEntrys.getRow(i);
            mpe = (MaterialProductEnum)row.getCell(TB_PRODUCTTYPE).getValue();
            if (MaterialProductEnum.RELATEDPRODUCT == mpe || MaterialProductEnum.BYPRODUCT == mpe) {
                row.getCell(TB_PICKINGMODE).setValue((Object)MaterialIssueModeEnum.NOTISSMODE);
                row.getCell(TB_PICKINGMODE).getStyleAttributes().setLocked(true);
            } else {
                row.getCell(TB_PICKINGMODE).getStyleAttributes().setLocked(false);
            }
            try {
                if (Boolean.TRUE.equals(row.getCell(TB_ISSTOCKTRANSFER).getValue())) {
                    WarehouseInfo defaultWareHouse = (WarehouseInfo)row.getCell(TB_DEFAULTWAREHOUSE).getValue();
                    EntityViewInfo ev = SCMClientUtils.getWarehouseFilter((StorageOrgUnitInfo)this.editData.getStorageOrgUnit(), (int)-1);
                    KDBizPromptBox kDBizPromptBoxWarehouse = new KDBizPromptBox();
                    kDBizPromptBoxWarehouse.setEditable(true);
                    kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
                    kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                    kDBizPromptBoxWarehouse.setEditFormat("$number$");
                    kDBizPromptBoxWarehouse.setCommitFormat("$number$");
                    if (defaultWareHouse != null) {
                        ev.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)defaultWareHouse.getId().toString(), CompareType.NOTEQUALS));
                    }
                    kDBizPromptBoxWarehouse.setEntityViewInfo(ev);
                    row.getCell(TB_TRANSFERWAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
                    row.getCell(TB_TRANSFERWAREHOUSE).getStyleAttributes().setLocked(false);
                    this.setEntrySourceStorageOrgUnit(row);
                } else {
                    row.getCell(TB_TRANSFERWAREHOUSE).getStyleAttributes().setLocked(true);
                    row.getCell(TB_TRANSFERORGUNIT).getStyleAttributes().setLocked(true);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            MaterialInfo[] materialInfos = new MaterialInfo[]{(MaterialInfo)row.getCell(TB_MATERIAL).getValue()};
            if (materialInfos[0] == null) continue;
            try {
                StorageOrgUnitInfo orgInfo = this.editData.getStorageOrgUnit();
                SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)orgInfo, (MaterialInfo[])materialInfos);
                String key = materialInfos[0].getId().toString() + orgInfo.getId().toString();
                MaterialInventoryInfo materialInventory = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key);
                if (materialInventory != null && materialInventory.isIsLotNumber()) {
                    row.getCell(TB_ISBACKFLUSH).getStyleAttributes().setLocked(true);
                    continue;
                }
                row.getCell(TB_ISBACKFLUSH).getStyleAttributes().setLocked(false);
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void setEntrySourceStorageOrgUnit(IRow row) {
        HashSet<String> orgSet = new HashSet<String>();
        String currentStorageOrgUnitId = "";
        if (this.editData.getStorageOrgUnit() != null) {
            currentStorageOrgUnitId = this.editData.getStorageOrgUnit().getId().toString();
        }
        String supplyOrgUnitId = "";
        Object supplyOrgUnit = row.getCell(TB_SUPPLYORGUNIT).getValue();
        if (supplyOrgUnit != null && supplyOrgUnit instanceof StorageOrgUnitInfo) {
            supplyOrgUnitId = ((StorageOrgUnitInfo)supplyOrgUnit).getId().toString();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        orgSet.add(currentStorageOrgUnitId);
        orgSet.add(supplyOrgUnitId);
        filterInfo.getFilterItems().add(new FilterItemInfo("ID", orgSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        KDBizPromptBox kDBizPromptBoxSourceStorageOrgUnit = new KDBizPromptBox();
        kDBizPromptBoxSourceStorageOrgUnit.setEditable(true);
        kDBizPromptBoxSourceStorageOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageItemQuery");
        kDBizPromptBoxSourceStorageOrgUnit.setDisplayFormat("$name$");
        kDBizPromptBoxSourceStorageOrgUnit.setEditFormat("$number$");
        kDBizPromptBoxSourceStorageOrgUnit.setCommitFormat("$number$");
        kDBizPromptBoxSourceStorageOrgUnit.setEntityViewInfo(viewInfo);
        row.getCell(TB_TRANSFERORGUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxSourceStorageOrgUnit));
        row.getCell(TB_TRANSFERORGUNIT).getStyleAttributes().setLocked(false);
    }

    protected void tableCellActived(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColumnIndex();
        IRow curRow = this.kdtEntrys.getRow(rowIndex);
        if (curRow == null) {
            return;
        }
        String fieldName = this.kdtEntrys.getColumnKey(colIndex);
        if (TB_LINEWP.equalsIgnoreCase(fieldName)) {
            if (this.prmtproductLine.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"productLineFirst"));
                this.kdtEntrys.getColumn(TB_LINEWP).getStyleAttributes().setLocked(true);
                this.prmtproductLine.requestFocusInWindow();
                return;
            }
            return;
        }
        if (TB_MATERIAL.equalsIgnoreCase(fieldName)) {
            if (this.prmtmaterial.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"headMaterialCanotNull"));
                this.kdtEntrys.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
                this.prmtmaterial.requestFocusInWindow();
                return;
            }
            return;
        }
        if (TB_PRODUCTQTY.equalsIgnoreCase(fieldName)) {
            if (((ConsumeTypeEnum)((Object)curRow.getCell(TB_CONSUMETYPE).getValue())).equals((Object)ConsumeTypeEnum.VariableAmount)) {
                curRow.getCell(TB_PRODUCTQTY).getStyleAttributes().setLocked(false);
            } else {
                curRow.getCell(TB_PRODUCTQTY).getStyleAttributes().setLocked(true);
            }
        } else if (TB_PROPORTION.equalsIgnoreCase(fieldName)) {
            if (((ConsumeTypeEnum)((Object)curRow.getCell(TB_CONSUMETYPE).getValue())).equals((Object)ConsumeTypeEnum.VariableAmount)) {
                curRow.getCell(TB_PROPORTION).getStyleAttributes().setLocked(true);
            } else {
                curRow.getCell(TB_PROPORTION).getStyleAttributes().setLocked(false);
            }
        } else if (TB_ISBACKFLUSH.equals(fieldName) || TB_ISSTOCKTRANSFER.equals(fieldName)) {
            this.setBackFlushOrStockTransferLocked(curRow, fieldName);
        }
    }

    public void kdtEntries_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)oldValue);
        if (e.getValue() == null && oldValue == null) {
            return;
        }
        if (oldValue != null && newValue != null && oldValue instanceof BigDecimal && newValue instanceof BigDecimal) {
            BigDecimal oldBigValue = (BigDecimal)oldValue;
            BigDecimal newBigValue = (BigDecimal)newValue;
            if ((oldBigValue = oldBigValue.setScale(newBigValue.scale(), 4)).compareTo(newBigValue) == 0) {
                return;
            }
        }
        if (!isDiffrent) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow curRow = this.kdtEntrys.getRow(rowIndex);
        String fieldName = this.kdtEntrys.getColumnKey(colIndex);
        if (TB_PRODUCTQTY.equalsIgnoreCase(fieldName)) {
            this.uiHelper.calEntryBaseQty(rowIndex, colIndex);
        } else if (TB_LINEWP.equals(fieldName)) {
            this.entryLineWPChange(rowIndex);
        } else if (TB_CONSUMETYPE.equalsIgnoreCase(fieldName)) {
            ConsumeTypeEnum consumeType = (ConsumeTypeEnum)((Object)curRow.getCell(TB_CONSUMETYPE).getValue());
            if (consumeType != null) {
                if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                    curRow.getCell(TB_PRODUCTQTY).setValue((Object)MMConstant.BIGDECIMAL_ZERO);
                    this.setCellLocked(curRow, TB_PROPORTION, false);
                    this.setCellLocked(curRow, TB_PRODUCTQTY, true);
                } else {
                    curRow.getCell(TB_PROPORTION).setValue((Object)MMConstant.BIGDECIMAL_ZERO);
                    this.setCellLocked(curRow, TB_PROPORTION, true);
                    this.setCellLocked(curRow, TB_PRODUCTQTY, false);
                }
            }
        } else if (TB_EFFECTIVEDATE.equalsIgnoreCase(fieldName) || TB_DISABLEDATE.equalsIgnoreCase(fieldName)) {
            Date effectiveDate = (Date)curRow.getCell(TB_EFFECTIVEDATE).getValue();
            Date disableDate = (Date)curRow.getCell(TB_DISABLEDATE).getValue();
            if (effectiveDate != null && disableDate != null && effectiveDate.compareTo(disableDate) >= 0) {
                MsgBox.showError((String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"effectiveDateGTdisableDate"));
                return;
            }
        } else if (TB_MATERIAL.equalsIgnoreCase(fieldName)) {
            if (curRow.getCell(TB_MATERIAL).getValue() == null) {
                curRow.getCell(TB_MATERIALNAME).setValue(null);
                curRow.getCell(TB_MATERIALMODEL).setValue(null);
                curRow.getCell(TB_UNIT).setValue(null);
                curRow.getCell(TB_DEFAULTWAREHOUSE).setValue(null);
                curRow.getCell(TB_ISSTOCKTRANSFER).setValue((Object)Boolean.FALSE);
                curRow.getCell(TB_ISBACKFLUSH).setValue((Object)Boolean.FALSE);
                curRow.getCell(TB_TRANSFERORGUNIT).setValue(null);
                curRow.getCell(TB_TRANSFERWAREHOUSE).setValue(null);
                curRow.getCell(TB_PROVIDETYPE).setValue((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE);
                curRow.getCell(TB_SUPPLYORGUNIT).setValue(this.prmtstorageOrgUnit.getValue());
            }
        } else if (TB_PROVIDETYPE.equalsIgnoreCase(fieldName)) {
            this.dealWithProvideType(e, curRow);
        } else if (TB_PRODUCTTYPE.equalsIgnoreCase(fieldName)) {
            MaterialProductEnum productType = (MaterialProductEnum)curRow.getCell(TB_PRODUCTTYPE).getValue();
            if (productType.equals((Object)MaterialProductEnum.RELATEDPRODUCT) || productType.equals((Object)MaterialProductEnum.BYPRODUCT)) {
                curRow.getCell(TB_ISBACKFLUSH).setValue((Object)Boolean.FALSE);
                curRow.getCell(TB_ISSTOCKTRANSFER).setValue((Object)Boolean.FALSE);
                curRow.getCell(TB_TRANSFERORGUNIT).setValue(null);
                curRow.getCell(TB_TRANSFERWAREHOUSE).setValue(null);
            }
            this.dealWithPickingMode(e, false);
        } else if (TB_SUPPLYORGUNIT.equalsIgnoreCase(fieldName)) {
            curRow.getCell(TB_DEFAULTWAREHOUSE).setValue(null);
            this.dealWithDefaultWarehouse(e, false);
            this.dealWithTransferWarehouse(e, false);
            curRow.getCell(TB_LOCATION).setValue(null);
        } else if (TB_DEFAULTWAREHOUSE.equalsIgnoreCase(fieldName)) {
            this.dealWithDefaultWarehouse(e, false);
            this.dealWithTransferWarehouse(e, false);
            curRow.getCell(TB_LOCATION).setValue(null);
        } else if (TB_TRANSFERORGUNIT.equalsIgnoreCase(fieldName)) {
            curRow.getCell(TB_TRANSFERWAREHOUSE).setValue(null);
            this.dealWithTransferWarehouse(e, false);
        } else if (TB_PICKINGMODE.equalsIgnoreCase(fieldName)) {
            this.dealWithPickingMode(e, false);
            this.dealWithBackFlush(e);
            this.dealWithStockTransfer(e, false);
        }
        if (TB_DEFAULTWAREHOUSE.equalsIgnoreCase(fieldName) && isDiffrent) {
            curRow.getCell(TB_LOCATION).setValue(null);
        }
    }

    private void entryLineWPChange(int rowIndex) {
        IRow curRow = this.kdtEntrys.getRow(rowIndex);
        ProductLineWPEntryInfo lineEntryInfo = (ProductLineWPEntryInfo)curRow.getCell(TB_LINEWP).getValue();
        if (lineEntryInfo != null) {
            curRow.getCell(TB_LINEWPMARK).setValue((Object)new Boolean(lineEntryInfo.isIsWP()));
        }
    }

    private void initOtherF7() throws Exception {
        this.f7Manager.registerMeasureUnitF7(this.kdtEntrys, TB_MATERIAL, TB_UNIT);
        this.initBOMF7();
        this.initProductLineWPF7();
    }

    private void initBOMF7() {
        this.prmtbom.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7BomChangeQuery");
        MaterialInfo material = (MaterialInfo)this.prmtmaterial.getValue();
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(50), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        if (material != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        }
        if (storageOrgUnitInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        ev.setFilter(filterInfo);
        this.prmtbom.setEntityViewInfo(ev);
        this.prmtbom.setEnabled(true);
    }

    private void initProductLineWPF7() {
        KDBizPromptBox bizLineWPBox = new KDBizPromptBox();
        bizLineWPBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7ProductLineWPQuery");
        bizLineWPBox.setEditable(true);
        bizLineWPBox.setEnabledMultiSelection(false);
        bizLineWPBox.setCommitFormat("$number$");
        bizLineWPBox.setDisplayFormat("$number$");
        bizLineWPBox.setEditFormat("$number$");
        this.kdtEntrys.getColumn(TB_LINEWP).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizLineWPBox));
        ObjectValueRender avrW = new ObjectValueRender();
        avrW.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn(TB_LINEWP).setRenderer((IBasicRender)avrW);
        ProductLineInfo lineInfo = (ProductLineInfo)this.prmtproductLine.getValue();
        String lineId = null;
        lineId = lineInfo != null ? lineInfo.getId().toString() : BOSUuid.create((BOSObjectType)new ProductLineInfo().getBOSType()).toString();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("productLine.id", (Object)lineId, CompareType.EQUALS));
        ev.setFilter(filterInfo);
        bizLineWPBox.setEntityViewInfo(ev);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.editData != null) {
            if (this.editData.getSourceBillId() != null) {
                this.prmtbom.setEnabled(false);
            } else {
                this.prmtbom.setEnabled(true);
            }
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.toolBar.remove((Component)this.btnAttachment);
        this.toolBar.remove((Component)this.btnAuditResult);
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancelCancel.setVisible(true);
        this.menuItemCancel.setEnabled(true);
        this.menuItemCancel.setVisible(true);
        this.menuItemCancelCancel.setEnabled(true);
        this.menuItemCancelCancel.setVisible(true);
        this.kDSeparator5.setEnabled(false);
        this.kDSeparator5.setVisible(false);
        ProductionFormulaInfo info = (ProductionFormulaInfo)this.dataBinder.getValueObject();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
        } else if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            if (info.getBaseStatus() != null && info.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                this.actionCancel.setEnabled(true);
                this.actionCancelCancel.setEnabled(false);
            } else if (info.getBaseStatus() != null && info.getBaseStatus() == BillBaseStatusEnum.DELETED) {
                this.actionCancel.setEnabled(false);
                this.actionCancelCancel.setEnabled(true);
            } else {
                this.actionCancel.setEnabled(false);
                this.actionCancelCancel.setEnabled(false);
            }
        } else if ("EDIT".equals(this.getOprtState())) {
            if (info.getBaseStatus() != null && info.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                this.actionCancel.setEnabled(true);
                this.actionCancelCancel.setEnabled(false);
            } else if (info.getBaseStatus() != null && info.getBaseStatus() == BillBaseStatusEnum.DELETED) {
                this.actionCancel.setEnabled(false);
                this.actionCancelCancel.setEnabled(true);
            } else {
                this.actionCancel.setEnabled(false);
                this.actionCancelCancel.setEnabled(false);
            }
        }
    }

    protected void setAddLineStatus(boolean status) {
        super.setAddLineStatus(status);
        this.actionCopyLine.setEnabled(status);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ProductionFormulaFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        ProductionFormulaEntryInfo entry = new ProductionFormulaEntryInfo();
        entry.setConsumeType(ConsumeTypeEnum.VariableAmount);
        try {
            Calendar effectiveDate = Calendar.getInstance();
            effectiveDate.setTime(SCMClientUtils.getServerDate());
            effectiveDate.set(10, 0);
            effectiveDate.set(12, 0);
            effectiveDate.set(13, 0);
            effectiveDate.set(14, 0);
            Calendar disableDate = Calendar.getInstance();
            disableDate.set(2099, 11, 31);
            disableDate.set(10, 0);
            disableDate.set(12, 0);
            disableDate.set(13, 0);
            disableDate.set(14, 0);
            entry.setEffectiveDate(effectiveDate.getTime());
            entry.setDisableDate(disableDate.getTime());
            entry.setIsStock(true);
            entry.setProvideType(MaterialProvideTypeEnum.CURRENTORGPROVIDE);
            entry.setSupplyStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
            entry.setMaterialAttr(MaterialCharEnum.MASTERPROP);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return entry;
    }

    @Override
    protected IObjectValue createNewData() {
        StorageOrgUnitInfo _ = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
        if (_ == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BASEDATAAutoGenerateResource", (String)"48_BomEditUI"));
            SysUtil.abort();
        }
        ProductionFormulaInfo objectValue = null;
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        try {
            objectValue = new ProductionFormulaInfo();
            objectValue.setBizDate(curDate);
            objectValue.setCreateTime(new Timestamp(cal.getTimeInMillis()));
            objectValue.setBaseStatus(BillBaseStatusEnum.ADD);
            objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            objectValue.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
            objectValue.setBillType(this.getBillTypeInfo());
            objectValue.setProductQty(new BigDecimal("1"));
            objectValue.getEntrys().add((ProductionFormulaEntryInfo)this.createNewDetailData(this.kdtEntrys));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return objectValue;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        MaterialInfo material = (MaterialInfo)this.prmtmaterial.getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)this.prmtunit.getValue();
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.pmtbaseUnit.getValue();
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        MaterialInfo[] materialInfos = new MaterialInfo[]{material};
        this.headVO = UIHelper.getDataVO((StorageOrgUnitInfo)storageOrgInfo, (MaterialInfo[])materialInfos);
        String key = material.getId().toString() + material.getBaseUnit().getId().toString();
        int unitPrec = (Integer)this.headVO.getMmuPrecisions().get(key);
        this.txtproductBaseQty.setPrecision(unitPrec);
        BigDecimal qty = this.txtproductQty.getBigDecimalValue();
        try {
            BigDecimal baseQty = SCMUtils.getExchangePricesionQtyForClient((String)material.getId().toString(), (MeasureUnitInfo)unit, (MeasureUnitInfo)baseUnit, (BigDecimal)qty);
            this.txtproductBaseQty.setValue((Object)baseQty);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private BillTypeInfo getBillTypeInfo() {
        try {
            BillTypeInfo billTypeInfo = SCMClientUtils.getBillType((String)"w0K1/r+3S7m9EroqYHhIvUY+1VI=");
            billTypeInfo.setNumber("650");
            return billTypeInfo;
        }
        catch (EASBizException e) {
            this.handUIException(e);
            return null;
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((String)SaleUtil.getUIResource((String)"ORDER_ADDNEWCANNOT_OPERATOR"));
            return;
        }
        String id = this.editData.getId().toString();
        try {
            this.pubFireVOChangeListener(id);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
            return;
        }
        catch (Throwable t) {
            this.handUIException(t);
            return;
        }
        this.setOprtState("AUDIT");
        boolean isSuccess = false;
        IProductionFormula iProductionFormula = ProductionFormulaFactory.getRemoteInstance();
        try {
            if (this.editData.getBaseStatus() != BillBaseStatusEnum.ALTERING) {
                iProductionFormula.audit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            }
            isSuccess = true;
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        if (isSuccess) {
            this.showSuccessMsg(ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"auditSuccess"));
            this.setUnAuditStatus(true);
            this.setOprtState(OprtState.VIEW);
            this.refreshCurPage();
        }
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkBeforeSubmit()) {
            if (this.ckIsDefault.getSelected() != 32) {
                super.actionSubmit_actionPerformed(e);
            } else if (this.prmtmaterial.getValue() != null && this.prmtproductLine != null && this.prmtstorageOrgUnit != null) {
                MaterialInfo material = (MaterialInfo)this.prmtmaterial.getValue();
                ProductLineInfo lineInfo = (ProductLineInfo)this.prmtproductLine.getValue();
                StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
                TrackNumberInfo trackNumberInfo = (TrackNumberInfo)this.prmtTrack.getValue();
                String trackID = null;
                if (trackNumberInfo != null) {
                    trackID = trackNumberInfo.getId().toString();
                }
                String StringID = null;
                if (this.editData.getId() != null) {
                    StringID = this.editData.getId().toString();
                }
                boolean result = ((IProductionFormula)this.getBizInterface()).verifyDefaultFormula(storageOrgInfo.getId().toString(), lineInfo.getId().toString(), material.getId().toString(), trackID, StringID);
                if (result) {
                    int choice = MsgBox.showConfirm3((Component)((Object)this), (String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"defaultFormula"));
                    if (MsgBox.isOk((int)choice)) {
                        super.actionSubmit_actionPerformed(e);
                    } else {
                        if (MsgBox.isCancel((int)choice)) {
                            return;
                        }
                        this.ckIsDefault.setSelected(false);
                        super.actionSubmit_actionPerformed(e);
                    }
                } else {
                    super.actionSubmit_actionPerformed(e);
                }
            } else {
                super.actionSubmit_actionPerformed(e);
            }
            if (this.editData.getBaseStatus() != null && this.editData.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                this.actionCancel.setEnabled(true);
                this.actionCancelCancel.setEnabled(false);
            }
        }
    }

    protected boolean checkBeforeSubmit() {
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            Date effectiveDate = (Date)this.kdtEntrys.getCell(i, TB_EFFECTIVEDATE).getValue();
            Date disableDate = (Date)this.kdtEntrys.getCell(i, TB_DISABLEDATE).getValue();
            if (effectiveDate == null || disableDate == null || effectiveDate.compareTo(disableDate) < 0) continue;
            MsgBox.showInfo((String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"effectiveDateGTdisableDate"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((String)SaleUtil.getUIResource((String)"ORDER_ADDNEWCANNOT_OPERATOR"));
            return;
        }
        String id = this.editData.getId().toString();
        boolean isSuccess = false;
        String errMsg = null;
        try {
            this.setOprtState("CANCEL");
            this.pubFireVOChangeListener(id);
            String[] ids = new String[]{id};
            errMsg = ProductionFormulaFactory.getRemoteInstance().cancel(ids);
            if (errMsg.length() == 0) {
                isSuccess = true;
            }
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        if (isSuccess) {
            this.showSuccessMsg(ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"Msg_CancelSuccess"));
            this.setOprtState(OprtState.VIEW);
            this.refreshCurPage();
        } else {
            MsgBox.showError((String)errMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((String)SaleUtil.getUIResource((String)"ORDER_ADDNEWCANNOT_OPERATOR"));
            return;
        }
        String id = this.editData.getId().toString();
        boolean isSuccess = false;
        String errMsg = null;
        try {
            this.setOprtState("CANCELCANCEL");
            this.pubFireVOChangeListener(id);
            String[] ids = new String[]{id};
            boolean result = ((IProductionFormula)this.getBizInterface()).verifyDefaultFormula(ids);
            if (result) {
                int choice = MsgBox.showConfirm3((Component)((Object)this), (String)ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"defaultFormula"));
                if (MsgBox.isOk((int)choice)) {
                    errMsg = ProductionFormulaFactory.getRemoteInstance().cancelCancel(ids, true);
                } else {
                    if (MsgBox.isCancel((int)choice)) {
                        return;
                    }
                    errMsg = ProductionFormulaFactory.getRemoteInstance().cancelCancel(ids, false);
                }
            } else {
                errMsg = ProductionFormulaFactory.getRemoteInstance().cancelCancel(ids, true);
            }
            if (errMsg.length() == 0) {
                isSuccess = true;
            }
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        if (isSuccess) {
            this.showSuccessMsg(ResourceManage.getResource((String)PRODUCTIONFORMULA_RESOURCE_PATH, (String)"Msg_CancelCancelSuccess"));
            this.setOprtState(OprtState.VIEW);
            this.refreshCurPage();
        } else {
            MsgBox.showError(errMsg);
        }
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        IRow copyToRowObj;
        KDTSelectManager manager = this.kdtEntrys.getSelectManager();
        if (manager.getBlocks().size() > 0) {
            KDTSelectBlock selectedBlock = (KDTSelectBlock)manager.getBlocks().get(0);
            int beginBlockRow = selectedBlock.getBeginRow();
            int endBlockRow = selectedBlock.getEndRow();
            if (manager.getBlocks().size() > 1 || beginBlockRow != endBlockRow) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MultiRows"));
                return;
            }
            IRow selectedRow = KDTableUtil.getSelectedRow((KDTable)this.kdtEntrys);
            if (null == selectedRow) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneRow"));
                return;
            }
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)selectedRow.getUserObject();
            entryInfo = (SCMBillEntryBaseInfo)entryInfo.clone();
            entryInfo.setId(null);
            int copyFromRowIndex = selectedRow.getRowIndex();
            int copyToRowIndex = this.kdtEntrys.getRowCount();
            copyToRowObj = this.kdtEntrys.addRow(copyToRowIndex);
            IRow copyFromRowObj = this.kdtEntrys.getRow(copyFromRowIndex);
            for (int cellIndex = 0; cellIndex < this.kdtEntrys.getColumnCount(); ++cellIndex) {
                ICell copyFromCell = copyFromRowObj.getCell(cellIndex);
                ICell copyToCell = copyToRowObj.getCell(cellIndex);
                if (copyFromCell == null || copyToCell == null) continue;
                Object orgValue = copyFromCell.getValue();
                copyToCell.setValue(orgValue);
            }
            this.loadLineFields(this.kdtEntrys, copyToRowObj, (IObjectValue)entryInfo);
            this.storeLineFields(this.kdtEntrys, copyToRowObj, (IObjectValue)entryInfo);
            StorageOrgUnitInfo org = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
            MaterialInfo[] materialInfos = new MaterialInfo[]{(MaterialInfo)copyFromRowObj.getCell(TB_MATERIAL).getValue()};
            if (null != materialInfos[0]) {
                SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)org, (MaterialInfo[])materialInfos);
                SCMClientUtils.changeTableColPrecision((Map)voResult.getMmuPrecisions(), (MaterialInfo)materialInfos[0], (MeasureUnitInfo)voResult.getMeasureUnitInfos()[0], (KDTable)this.kdtEntrys, (String[])QTYPRECISIONFROMUNITTAB, (int)copyToRowObj.getRowIndex());
                SCMClientUtils.changeTableColPrecision((Map)voResult.getMmuPrecisions(), (MaterialInfo)materialInfos[0], (MeasureUnitInfo)voResult.getBaseMeasureUnitInfos()[0], (KDTable)this.kdtEntrys, (String[])QTYPRECISIONFROMBASEUNITTAB, (int)copyToRowObj.getRowIndex());
            }
            if (Boolean.TRUE.equals(copyToRowObj.getCell(TB_ISSTOCKTRANSFER).getValue())) {
                copyToRowObj.getCell(TB_TRANSFERWAREHOUSE).getStyleAttributes().setLocked(false);
            } else {
                copyToRowObj.getCell(TB_TRANSFERWAREHOUSE).getStyleAttributes().setLocked(true);
                copyToRowObj.getCell(TB_TRANSFERWAREHOUSE).setValue(null);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneRow"));
            return;
        }
        this.setEntrySourceStorageOrgUnit(copyToRowObj);
    }

    protected void afterSubmitEdit(IObjectPK pk) {
        block8: {
            this.setOprtState(OprtState.EDIT);
            try {
                if (!this.isSubmitLoad()) break block8;
                if ((IObjectValue)this.getUIContext().get("InitDataObject") != null) {
                    ProductionFormulaInfo info = (ProductionFormulaInfo)this.getUIContext().get("InitDataObject");
                    if (BillBaseStatusEnum.AUDITED.equals((Object)info.getBaseStatus()) && this.editData.getId() != null) {
                        if (this.editData.getId() != null) {
                            this.setOprtState("RELEASEALL");
                            try {
                                this.pubFireVOChangeListener(this.editData.getId().toString());
                            }
                            catch (Throwable t) {
                                this.handUIException(t);
                            }
                        }
                        this.setOprtState(OprtState.VIEW);
                    }
                    this.setDataObject((IObjectValue)this.getUIContext().get("InitDataObject"));
                } else {
                    this.setDataObject(this.getValue(pk));
                }
                this.loadFields();
                this.initOldData((IObjectValue)this.editData);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.mm.basedata.app.ProductionFormulaQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/MM/basedata/ProductionFormula";
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(false);
    }

    protected String[] getSumColNames() {
        return new String[]{TB_PRODUCTQTY};
    }

    protected void setTableToSumField() {
        if (this.getDetailTable() != null && this.getSumColNames() != null) {
            this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
        }
    }

    protected String getOnloadPermItemName() {
        if ("ADDNEW".equalsIgnoreCase(this.getOprtState())) {
            return "mm_formula_addnew";
        }
        return null;
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("shift F8"), "cancel");
        actionMap.put("cancel", (Action)this.actionCancel);
        this.menuItemCancel.setText(this.menuItemCancel.getText().trim() + "        Shift+F8");
        inputMap.put(KeyStroke.getKeyStroke("shift F9"), "cancelCancel");
        actionMap.put("cancelCancel", (Action)this.actionCancelCancel);
        this.menuItemCancelCancel.setText(this.menuItemCancelCancel.getText().trim() + "        Shift+F9");
    }

    private void setMaterialFilter() throws BOSException {
        EntityViewInfo view = this.prmtmaterial.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        Set strategySet = ManufactureStrategyGroup.getProjectTrackOrderBomStrategyIdSet();
        filter.getFilterItems().add(new FilterItemInfo("manufactureStrategy.id", (Object)strategySet, CompareType.NOTINCLUDE));
        view.getFilter().mergeFilter(filter, "and");
        this.prmtmaterial.setEntityViewInfo(view);
        this.prmtmaterial.getQueryAgent().resetRuntimeEntityView();
    }

    private void setTrackEnabled(MaterialPlanInfo materialPlanInfo) {
        Set trackStrategySet;
        ManufactureStrategyInfo strategyInfo = materialPlanInfo.getManufactureStrategy();
        String strategyId = "NUnM+gEcEADgAA3cwKgL09g0uEU=";
        if (strategyInfo != null && strategyInfo.getId() != null) {
            strategyId = strategyInfo.getId().toString();
        }
        if ((trackStrategySet = ManufactureStrategyGroup.getTrackOrderBomStrategyIdSet()).contains(strategyId)) {
            this.prmtTrack.setEnabled(true);
        } else {
            this.prmtTrack.setEnabled(false);
            this.prmtTrack.setValue(null);
        }
    }

    private MaterialPlanInfo getMaterialPlanInfo(MaterialInfo materialInfo) throws EASBizException, BOSException {
        MaterialPlanInfo mplan = null;
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (orgInfo == null) {
            return null;
        }
        String key = materialInfo.getId().toString() + orgInfo.getId().toString();
        if (this.materialPlanMap.containsKey(key)) {
            mplan = (MaterialPlanInfo)this.materialPlanMap.get(key);
        } else {
            SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)orgInfo, (MaterialInfo[])new MaterialInfo[]{materialInfo});
            mplan = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key);
            if (mplan != null) {
                this.materialPlanMap.put(key, mplan);
            }
        }
        return mplan;
    }

    private void initPickingModeValue() {
        ICellEditor editor = this.kdtEntrys.getColumn(TB_PICKINGMODE).getEditor();
        if (editor == null) {
            return;
        }
        KDComboBox cboxPickingMode = (KDComboBox)editor.getComponent();
        UIHelper.setIssueModeSelect((KDComboBox)cboxPickingMode);
    }

    private void setCellLocked(IRow row, String columnKey, boolean isLocked) {
        ICell cell = row.getCell(columnKey);
        this.setCellLocked(cell, isLocked);
    }

    private void setCellLocked(ICell cell, boolean isLocked) {
        cell.getStyleAttributes().setLocked(isLocked);
    }

    private void kdtEntries_EditValueChanged(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntrys.getColumnKey(colIndex);
        if (TB_ISSTOCKTRANSFER.equalsIgnoreCase(fieldName)) {
            this.dealWithStockTransfer(e, false);
        } else if (TB_ISBACKFLUSH.equalsIgnoreCase(fieldName)) {
            this.dealWithBackFlush(e, false);
        }
    }

    private void dealWithBackFlush(KDTEditEvent e) {
        int startIndex = -1;
        int endIndex = -1;
        if (null == e) {
            startIndex = 0;
            endIndex = this.kdtEntrys.getRowCount();
        } else {
            startIndex = e.getRowIndex();
            if (startIndex == -1) {
                startIndex = 0;
            }
            endIndex = startIndex + 1;
        }
        IRow curRow = null;
        for (int i = startIndex; i < endIndex; ++i) {
            curRow = this.kdtEntrys.getRow(i);
            this.setBackFlushOrStockTransferLocked(curRow, TB_ISBACKFLUSH);
            this.setBackFlushOrStockTransferNotChecked(curRow, TB_ISBACKFLUSH);
        }
    }

    private void setBackFlushOrStockTransferLocked(IRow curRow, String columnName) {
        MaterialProvideTypeEnum provideType = (MaterialProvideTypeEnum)curRow.getCell(TB_PROVIDETYPE).getValue();
        boolean isLocked = true;
        if (provideType.equals((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE)) {
            MaterialIssueModeEnum issueMode = (MaterialIssueModeEnum)curRow.getCell(TB_PICKINGMODE).getValue();
            isLocked = !MaterialIssueModeEnum.PRODUCEISSMODE.equals((Object)issueMode);
        } else if (provideType.equals((Object)MaterialProvideTypeEnum.SPANORGPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE)) {
            isLocked = true;
        }
        this.setCellLocked(curRow, columnName, isLocked);
    }

    private void setBackFlushOrStockTransferNotChecked(IRow curRow, String columnName) {
        HashSet<MaterialProvideTypeEnum> provideTypeSet = new HashSet<MaterialProvideTypeEnum>();
        provideTypeSet.add(MaterialProvideTypeEnum.CURRENTORGPROVIDE);
        provideTypeSet.add(MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE);
        MaterialProvideTypeEnum provideType = (MaterialProvideTypeEnum)curRow.getCell(TB_PROVIDETYPE).getValue();
        MaterialIssueModeEnum issueMode = (MaterialIssueModeEnum)curRow.getCell(TB_PICKINGMODE).getValue();
        if (!provideTypeSet.contains(provideType) || !MaterialIssueModeEnum.PRODUCEISSMODE.equals((Object)issueMode)) {
            curRow.getCell(columnName).setValue((Object)Boolean.FALSE);
        }
    }

    private void dealWithProvideType(KDTEditEvent e, IRow curRow) {
        MaterialProvideTypeEnum provideType = (MaterialProvideTypeEnum)curRow.getCell(TB_PROVIDETYPE).getValue();
        MaterialProductEnum outputType = (MaterialProductEnum)curRow.getCell(TB_PRODUCTTYPE).getValue();
        if (provideType.equals((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE)) {
            curRow.getCell(TB_SUPPLYORGUNIT).setValue(this.prmtstorageOrgUnit.getValue());
        } else if (provideType.equals((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE)) {
            curRow.getCell(TB_SUPPLYORGUNIT).setValue(null);
            if (MaterialProductEnum.OTHER.equals((Object)outputType)) {
                curRow.getCell(TB_PICKINGMODE).setValue((Object)MaterialIssueModeEnum.PRODUCEISSMODE);
            }
        } else if (provideType.equals((Object)MaterialProvideTypeEnum.SPANORGPROVIDE)) {
            curRow.getCell(TB_SUPPLYORGUNIT).setValue(null);
            if (MaterialProductEnum.OTHER.equals((Object)outputType)) {
                curRow.getCell(TB_PICKINGMODE).setValue((Object)MaterialIssueModeEnum.PRODUCEISSMODE);
            }
            curRow.getCell(TB_ISSTOCKTRANSFER).setValue((Object)Boolean.FALSE);
            curRow.getCell(TB_ISBACKFLUSH).setValue((Object)Boolean.FALSE);
        } else if (provideType.equals((Object)MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE)) {
            curRow.getCell(TB_SUPPLYORGUNIT).setValue(null);
            if (MaterialProductEnum.OTHER.equals((Object)outputType)) {
                curRow.getCell(TB_PICKINGMODE).setValue((Object)MaterialIssueModeEnum.STRAIGHT);
            }
            curRow.getCell(TB_ISSTOCKTRANSFER).setValue((Object)Boolean.FALSE);
            curRow.getCell(TB_ISBACKFLUSH).setValue((Object)Boolean.FALSE);
        }
        curRow.getCell(TB_TRANSFERORGUNIT).setValue(null);
        curRow.getCell(TB_TRANSFERWAREHOUSE).setValue(null);
        curRow.getCell(TB_DEFAULTWAREHOUSE).setValue(null);
        curRow.getCell(TB_LOCATION).setValue(null);
        this.dealWithSupplyOrgUnit(e, false);
        this.dealWithDefaultWarehouse(e, false);
        this.dealWithPickingMode(e, false);
        this.dealWithStockTransfer(e, false);
        this.dealWithTransferOrgUnit(e, false);
        this.dealWithTransferWarehouse(e, false);
        this.dealWithBackFlush(e, false);
    }

    private KDTEditEvent createKDTEditEvent(boolean isAddLine) {
        int[] rowIndexs;
        KDTEditEvent event = null;
        int index = -1;
        index = isAddLine ? this.kdtEntrys.getRowCount() - 1 : ((rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys)) == null || rowIndexs.length == 0 ? this.kdtEntrys.getRowCount() - 1 : rowIndexs[0]);
        event = new KDTEditEvent((Object)this.kdtEntrys, null, null, index, -1, false, 1);
        return event;
    }

    private KDBizPromptBox createKDBizPromptBox(String queryInfo) {
        KDBizPromptBox bizBox = new KDBizPromptBox();
        bizBox.setEditable(true);
        bizBox.setDisplayFormat("$name$");
        bizBox.setEditFormat("$number$");
        bizBox.setCommitFormat("$number$");
        bizBox.setQueryInfo(queryInfo);
        return bizBox;
    }

    private KDBizPromptBox createDefaultWarehouseKDBizPromptBox(StorageOrgUnitInfo storageOrgUnit) {
        KDBizPromptBox warehouse = this.createKDBizPromptBox("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgUnit != null) {
            String storageOrgUnitId = storageOrgUnit.getId().toString();
            FilterItemInfo filterItem = new FilterItemInfo("STORAGEORGUNIT.ID", (Object)storageOrgUnitId, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItem);
        }
        viewInfo.setFilter(filterInfo);
        warehouse.setEntityViewInfo(viewInfo);
        return warehouse;
    }

    private SelectorItemCollection getMaterialPlanSelectors() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        coll.add("materialAttr");
        coll.add("materialChar");
        coll.add("issMode");
        coll.add("issueLeadTime");
        coll.add(TB_ISBACKFLUSH);
        coll.add(TB_PROVIDETYPE);
        coll.add("fromInvOrg.id");
        coll.add("fromInvOrg.name");
        coll.add("supplyOrgUnit.id");
        coll.add("supplyOrgUnit.name");
        coll.add("supplyOrgUnit.number");
        coll.add("fromWarehouse.id");
        coll.add("fromWarehouse.name");
        coll.add("fromWarehouse.number");
        coll.add("outputType");
        coll.add("isStockAllot");
        coll.add("orgUnit");
        coll.add("productUnit.id");
        coll.add("productUnit.name");
        coll.add("productUnit.number");
        return coll;
    }

    private void cleanBtnText() {
        this.btnAddLineNew.setText("");
        this.btnInsertLineNew.setText("");
        this.btnRemoveLineNew.setText("");
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kdtEntrys, (int)this.freezeColIndex);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        dialog.setHeight(344);
        return dialog;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            if (this.kdtEntrys.getRow(i).getCell(TB_PRODUCTQTY).getValue() == null) {
                this.kdtEntrys.getRow(i).getCell(TB_PRODUCTQTY).setValue((Object)new BigDecimal("0.00"));
            }
            if (this.kdtEntrys.getRow(i).getCell(TB_PRODUCTBASEQTY).getValue() != null) continue;
            this.kdtEntrys.getRow(i).getCell(TB_PRODUCTBASEQTY).setValue((Object)new BigDecimal("0.00"));
        }
        super.beforeStoreFields(e);
    }
}

