/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.ChangeTypeEnum;
import com.kingdee.eas.mm.basedata.client.AbstractProjectChangeFilterUI;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashSet;

public class ProjectChangeFilterUI
extends AbstractProjectChangeFilterUI {
    private static final long serialVersionUID = 1L;
    public static final String RESOURCE_PATH = "com.kingdee.eas.mm.basedata.ProjectChangeResource";
    private CustomerParams customerParam = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIsSupportMultiOrgs(true);
        this.initPersionAndDepartmentF7s();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new MMRangeFilterElement("number", (Component)this.prmtNumberFrm, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new MMRangeFilterElement("entrys.bomNo.number", (Component)this.bomFrm, (Component)this.bomTo));
        elements.add((FilterElement)new SingleFilterElement("changeType", (Component)this.changeType, (Object)ChangeTypeEnum.NULL));
        elements.add((FilterElement)new MMRangeFilterElement("entrys.PARENTITEM.NUMBER", (Component)this.itemNumberFrm, (Component)this.itemNumberTo));
        elements.add((FilterElement)new MMRangeFilterElement("requester.number", (Component)this.requesterFrm, (Component)this.requesterTo));
        elements.add((FilterElement)new MMRangeFilterElement("departMent.number", (Component)this.departmentFrm, (Component)this.departmentTo));
        elements.add((FilterElement)new MMRangeFilterElement("DESINGER.NUMBER", (Component)this.prmtProducerFrm, (Component)this.prmtProducerTo));
        elements.add((FilterElement)new MMRangeFilterElement("producer.number", (Component)this.prmtDesignerFrm, (Component)this.prmtDesignerTo));
        MMRangeFilterElement element = new MMRangeFilterElement("createTime", (Component)this.dateFrm, (Component)this.dateTo);
        element.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ProjectChangeFilterUI.getResource("Msg_RequestDate_NotNull")));
        element.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        element.setDefaultValue((Object)SCMUtils.getDefaultDateRange(null));
        elements.add((FilterElement)element);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtstorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ProjectChangeFilterUI.getResource("Msg_storageOrgUnit_NotNull")));
        elements.add((FilterElement)mainOrgElement);
        this.startDateFrm.setValue(null);
        this.startDateTo.setValue(null);
        String query = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.itemNumberFrm, false, query);
        this.setBizMaterialF7(this.itemNumberTo, false, query);
        this.f7Manager.registerContextChangeF7(this.itemNumberFrm, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.itemNumberTo, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.prmtNumberFrm, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.prmtNumberTo, "storageOrgUnit.id");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.itemNumberFrm, this.itemNumberTo, this.prmtNumberFrm, this.prmtNumberTo});
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        this.chkAdd.setSelected(true);
        this.chkAddNew.setSelected(true);
        this.chkAudit.setSelected(true);
        this.chkDelete.setSelected(true);
        this.chkSubmit.setSelected(true);
        this.chkUpdate.setSelected(true);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtstorageOrgUnit;
    }

    private void initPersionAndDepartmentF7s() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(filter);
        this.requesterFrm.setEntityViewInfo(view);
        this.requesterTo.setEntityViewInfo(view);
        this.prmtDesignerFrm.setEntityViewInfo(view);
        this.prmtDesignerTo.setEntityViewInfo(view);
        this.prmtProducerFrm.setEntityViewInfo(view);
        this.prmtProducerTo.setEntityViewInfo(view);
    }

    public FilterInfo getFilterInfo() {
        HashSet<Integer> setStauts = new HashSet<Integer>();
        HashSet<Integer> setChangeType = new HashSet<Integer>();
        FilterInfo filterInfo = super.getFilterInfo();
        if (this.chkAdd.isSelected()) {
            setStauts.add(new Integer(1));
        }
        if (this.chkSubmit.isSelected()) {
            setStauts.add(new Integer(2));
        }
        if (this.chkAudit.isSelected()) {
            setStauts.add(new Integer(4));
        }
        if (this.chkAddNew.isSelected()) {
            setChangeType.add(new Integer("1"));
        }
        if (this.chkUpdate.isSelected()) {
            setChangeType.add(new Integer("2"));
        }
        if (this.chkDelete.isSelected()) {
            setChangeType.add(new Integer("3"));
        }
        FilterInfo filter = new FilterInfo();
        if (setStauts.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", setStauts, CompareType.INCLUDE));
        }
        if (setChangeType.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.oprationType", setChangeType, CompareType.INCLUDE));
        }
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        if (this.changeType.getSelectedItem() == ChangeTypeEnum.Parent) {
            if (null != this.startDateFrm.getValue()) {
                filter.getFilterItems().add(new FilterItemInfo("auditDate", this.startDateFrm.getValue(), CompareType.GREATER_EQUALS));
            }
            if (null != this.startDateTo.getValue()) {
                filter.getFilterItems().add(new FilterItemInfo("auditDate", (Object)(dtformat.format(this.startDateTo.getValue()) + " 23:59:59"), CompareType.LESS_EQUALS));
            }
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else if (this.changeType.getSelectedItem() == ChangeTypeEnum.Child) {
            if (null != this.startDateFrm.getValue()) {
                filter.getFilterItems().add(new FilterItemInfo("entrys.newStartDate", this.startDateFrm.getValue(), CompareType.GREATER_EQUALS));
            }
            if (null != this.startDateTo.getValue()) {
                filter.getFilterItems().add(new FilterItemInfo("entrys.newStartDate", (Object)(dtformat.format(this.startDateTo.getValue()) + " 23:59:59"), CompareType.LESS_EQUALS));
            }
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            if (null != this.startDateFrm.getValue() || null != this.startDateTo.getValue()) {
                FilterInfo filterParent = new FilterInfo();
                filterParent.getFilterItems().add(new FilterItemInfo("changeType", (Object)"01", CompareType.EQUALS));
                if (null != this.startDateFrm.getValue()) {
                    filterParent.getFilterItems().add(new FilterItemInfo("auditDate", this.startDateFrm.getValue(), CompareType.GREATER_EQUALS));
                }
                if (null != this.startDateTo.getValue()) {
                    filterParent.getFilterItems().add(new FilterItemInfo("auditDate", (Object)(dtformat.format(this.startDateTo.getValue()) + " 23:59:59"), CompareType.LESS_EQUALS));
                }
                filterParent.getFilterItems().add(new FilterItemInfo("changeType", (Object)"02", CompareType.EQUALS));
                if (null != this.startDateFrm.getValue()) {
                    filterParent.getFilterItems().add(new FilterItemInfo("entrys.newStartDate", this.startDateFrm.getValue(), CompareType.GREATER_EQUALS));
                }
                if (null != this.startDateTo.getValue()) {
                    filterParent.getFilterItems().add(new FilterItemInfo("entrys.newStartDate", (Object)(dtformat.format(this.startDateTo.getValue()) + " 23:59:59"), CompareType.LESS_EQUALS));
                }
                if (null != this.startDateFrm.getValue() && null != this.startDateTo.getValue()) {
                    filterParent.setMaskString("((#0 and #1 and #2) OR (#3 and #4 and #5))");
                } else {
                    filterParent.setMaskString("((#0 and #1) OR (#2 and #3))");
                }
                try {
                    filterInfo.mergeFilter(filterParent, "AND");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        return filterInfo;
    }

    @Override
    protected void storageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent && e.getNewValue() != null) {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo entityView = new EntityViewInfo();
            HashSet<String> set = new HashSet<String>();
            if (e.getNewValue() instanceof Object[]) {
                Object[] newValue = (Object[])e.getNewValue();
                for (int i = 0; i < newValue.length; ++i) {
                    if (newValue[i] instanceof FullOrgUnitInfo) {
                        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((FullOrgUnitInfo)newValue[i]).getId(), CompareType.EQUALS));
                        continue;
                    }
                    if (!(newValue[i] instanceof StorageOrgUnitInfo)) continue;
                    set.add(((StorageOrgUnitInfo)newValue[i]).getId().toString());
                }
                if (set != null && set.size() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", set, CompareType.INCLUDE));
                }
            } else if (e.getNewValue() instanceof FullOrgUnitInfo) {
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((FullOrgUnitInfo)e.getNewValue()).getId(), CompareType.EQUALS));
            } else if (e.getNewValue() instanceof StorageOrgUnitInfo) {
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)e.getNewValue()).getId(), CompareType.EQUALS));
            }
            entityView.setFilter(filter);
            this.bomFrm.setEntityViewInfo(entityView);
            this.bomTo.setEntityViewInfo(entityView);
            this.prmtNumberFrm.setEntityViewInfo(entityView);
            this.prmtNumberTo.setEntityViewInfo(entityView);
            this.bomFrm.setValue(null);
            this.bomTo.setValue(null);
            this.prmtNumberFrm.setValue(null);
            this.prmtNumberTo.setValue(null);
        } else if (e.getNewValue() == null) {
            this.prmtNumberFrm.setValue(null);
            this.prmtNumberTo.setValue(null);
            this.bomFrm.setValue(null);
            this.bomTo.setValue(null);
            this.itemNumberFrm.setValue(null);
            this.itemNumberTo.setValue(null);
        }
    }

    public boolean verify() {
        boolean verifyResoult = false;
        if (super.verify()) {
            if (!(this.chkAddNew.isSelected() || this.chkUpdate.isSelected() || this.chkDelete.isSelected())) {
                MsgBox.showWarning((String)ProjectChangeFilterUI.getResource("Msg_changeType_NotSelected"));
                return false;
            }
            if (!(this.chkAdd.isSelected() || this.chkAudit.isSelected() || this.chkSubmit.isSelected())) {
                MsgBox.showWarning((String)ProjectChangeFilterUI.getResource("Msg_BillType_NotSelected"));
            } else if (null != this.startDateFrm.getValue() && null != this.startDateTo.getValue()) {
                DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
                if (dtformat.format(this.startDateFrm.getValue()).compareTo(dtformat.format(this.startDateTo.getValue())) <= 0) {
                    verifyResoult = true;
                } else {
                    MsgBox.showInfo((String)ProjectChangeFilterUI.getResource("Msg_FromStartDateMustBeforeToDate"));
                    this.startDateFrm.requestFocusInWindow();
                }
            } else {
                verifyResoult = true;
            }
        }
        return verifyResoult;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_projectChange_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected static String getResource(String strKey) {
        return EASResource.getString((String)RESOURCE_PATH, (String)strKey);
    }

    public void clear() {
        super.clear();
        this.startDateFrm.setValue(null);
        this.startDateTo.setValue(null);
        this.setDefaultQueryStatus(true);
    }

    private void setDefaultQueryStatus(boolean flag) {
        this.chkAdd.setSelected(flag);
        this.chkAudit.setSelected(flag);
        this.chkSubmit.setSelected(flag);
        this.chkAddNew.setSelected(flag);
        this.chkUpdate.setSelected(flag);
        this.chkDelete.setSelected(flag);
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.customerParam = cp;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        if (this.chkAdd.isSelected()) {
            pp.addCustomerParam("baseStatusAdd", String.valueOf(1));
        }
        if (this.chkAudit.isSelected()) {
            pp.addCustomerParam("baseStatusAudit", String.valueOf(4));
        }
        if (this.chkSubmit.isSelected()) {
            pp.addCustomerParam("baseStatusSubmit", String.valueOf(2));
        }
        if (this.chkAddNew.isSelected()) {
            pp.addCustomerParam("operationTypeAdd", String.valueOf("1"));
        }
        if (this.chkUpdate.isSelected()) {
            pp.addCustomerParam("operationTypeUpdate", String.valueOf("2"));
        }
        if (this.chkDelete.isSelected()) {
            pp.addCustomerParam("operationTypeDelete", String.valueOf("3"));
        }
        if (this.startDateFrm.getValue() != null) {
            pp.addCustomerParam("startDateFrm", dtformat.format(this.startDateFrm.getValue()));
        }
        if (this.startDateTo.getValue() != null) {
            pp.addCustomerParam("startDateTo", dtformat.format(this.startDateTo.getValue()));
        }
        return pp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        DataChangeListener[] datachange = (DataChangeListener[])this.prmtstorageOrgUnit.getListeners(DataChangeListener.class);
        if (datachange != null) {
            for (int i = 0; i < datachange.length; ++i) {
                this.prmtstorageOrgUnit.removeDataChangeListener(datachange[i]);
            }
        }
        this.setDefaultQueryStatus(false);
        super.loadData(entityViewInfo);
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        if (this.customerParam.getCustomerParam("baseStatusAdd") != null && this.customerParam.getCustomerParam("baseStatusAdd").length() > 0) {
            this.chkAdd.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("baseStatusAudit") != null && this.customerParam.getCustomerParam("baseStatusAudit").length() > 0) {
            this.chkAudit.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("baseStatusSubmit") != null && this.customerParam.getCustomerParam("baseStatusSubmit").length() > 0) {
            this.chkSubmit.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("operationTypeAdd") != null && this.customerParam.getCustomerParam("operationTypeAdd").length() > 0) {
            this.chkAddNew.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("operationTypeUpdate") != null && this.customerParam.getCustomerParam("operationTypeUpdate").length() > 0) {
            this.chkUpdate.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("operationTypeDelete") != null && this.customerParam.getCustomerParam("operationTypeDelete").length() > 0) {
            this.chkDelete.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("startDateFrm") != null && this.customerParam.getCustomerParam("startDateFrm").length() > 0) {
            try {
                this.startDateFrm.setValue(dtformat.parseObject(this.customerParam.getCustomerParam("startDateFrm")));
            }
            catch (ParseException e) {
                this.handUIException(e);
            }
        } else {
            this.startDateFrm.setValue(null);
        }
        if (this.customerParam.getCustomerParam("startDateTo") != null && this.customerParam.getCustomerParam("startDateTo").length() > 0) {
            try {
                this.startDateTo.setValue(dtformat.parseObject(this.customerParam.getCustomerParam("startDateTo")));
            }
            catch (ParseException e) {
                this.handUIException(e);
            }
        } else {
            this.startDateTo.setValue(null);
        }
        if (datachange != null) {
            for (int i = 0; i < datachange.length; ++i) {
                this.prmtstorageOrgUnit.addDataChangeListener(datachange[i]);
            }
        }
    }
}

