/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ProjectChangeEntryFactory;
import com.kingdee.eas.mm.basedata.ProjectChangeFactory;
import com.kingdee.eas.mm.basedata.ProjectChangeInfo;
import com.kingdee.eas.mm.basedata.ProjectChangeLinkRptFacadeFactory;
import com.kingdee.eas.mm.basedata.client.AbstractProjectChangeListUI;
import com.kingdee.eas.mm.basedata.client.ProjectChangeFilterUI;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.AbstractSCMBillListUI;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ProjectChangeListUI
extends AbstractProjectChangeListUI {
    private static final long serialVersionUID = 1173037183971288725L;
    private ProjectChangeFilterUI conditionPanel = null;
    public static final String RESOURCE_PATH = "com.kingdee.eas.mm.basedata.ProjectChangeResource";
    private static final String[] KDT_DATES = new String[]{"startDate", "endDate", "createTime", "lastUpdateTime", "auditDate"};
    Map mapBom;
    private int freezeColIndex = 6;

    public void onLoad() throws Exception {
        HashMap map;
        this.tblMain.checkParsed();
        Object objValue = this.getUIContext().get("BTPNAVCTX");
        if (objValue instanceof HashMap && null != (map = (HashMap)objValue) && map.size() <= 0) {
            this.getUIContext().put("BTPNAVCTX", null);
        }
        super.onLoad();
        this.mapBom = this.getUIContext();
        if (null != this.mapBom.get("bomID")) {
            this.refreshnew();
            this.menuBar.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.manuLinkRpt.setVisible(false);
            this.btnRefresh.setVisible(false);
            this.btnQuery.setVisible(false);
            this.btnLocate.setVisible(false);
            this.btnAttachment.setVisible(false);
            this.btnPrint.setVisible(false);
            this.btnPrintPreview.setVisible(false);
            this.btnTraceUp.setVisible(false);
            this.btnAuditResult.setVisible(false);
            this.btnAudit.setVisible(false);
        }
        this.btnUnAudit.setVisible(false);
        this.setUITitle(ProjectChangeListUI.getResource("ProjectChangeListTitleName"));
        this.kDMenuPercisionConfig.setVisible(false);
        this.btnViewTrackNumber.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_integralitycheck", (Locale)this.getLocale()));
        this.menuItemViewTrackNumber.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_integralitycheck", (Locale)this.getLocale()));
        this.manuLinkRpt.setIcon(MMUtils.getNewIcon((String)"imgTbtn_sourcebillfilter"));
        this.menuProjectChangeLingRpt.setIcon(MMUtils.getNewIcon((String)"imgTbtn_sourcebillfilter"));
        this.menuItemUnAudit.setEnabled(false);
        this.menuItemUnAudit.setVisible(false);
        this.menuItemUnAudit.removeAll();
        ResourceBundleHelper resBaseHelper = new ResourceBundleHelper(AbstractSCMBillListUI.class.getName());
        this.btnAudit.setText(resBaseHelper.getString("btnAudit.text"));
        this.btnAudit.setToolTipText(resBaseHelper.getString("btnAudit.toolTipText"));
        this.btnAudit.setIsControlByParent(true);
        this.btnUnAudit.setText(resBaseHelper.getString("btnUnAudit.text"));
        this.btnUnAudit.setToolTipText(resBaseHelper.getString("btnUnAudit.toolTipText"));
        this.btnUnAudit.setIsControlByParent(true);
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        super.setReservationVisible(false);
    }

    protected void refreshnew() {
        IIDList idList = (IIDList)this.mapBom.get("bomID");
        BomInfo bominfo = null;
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        if (null != idList) {
            try {
                bominfo = BomFactory.getRemoteInstance().getBomInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)idList.getID(0))));
                this.getUIContext().put(this.getMainBizOrgType(), bominfo.getStorageOrgUnit());
            }
            catch (Exception e) {
                this.handleException(e);
            }
            itemCollection.add(new FilterItemInfo("entrys.bomNo.id", (Object)bominfo.getId().toString(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("storageOrgUnit.id", (Object)bominfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        }
        entity.setFilter(filterInfo);
        this.mainQuery = entity;
        try {
            this.tblMain.removeRows();
            this.refreshList();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionChangeLinkRpt_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        if (null != ids) {
            if (ids.size() != 1) {
                MsgBox.showInfo((String)ProjectChangeListUI.getResource("Msg_selectEntry"));
            } else {
                ArrayList<Object> entryids = new ArrayList<Object>();
                int size = this.tblMain.getSelectManager().size();
                for (int i = 0; i < size; ++i) {
                    int start = 0;
                    int end = 0;
                    KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                    if (sb != null) {
                        if (sb.getMode() == 4) {
                            start = 0;
                            end = this.tblMain.getRowCount() - 1;
                        } else {
                            start = sb.getTop();
                            end = sb.getBottom();
                        }
                    }
                    for (int j = start; j <= end; ++j) {
                        IRow row_t = this.tblMain.getRow(j);
                        if (row_t.getCell("entrys.id").getValue() == null) continue;
                        entryids.add(row_t.getCell("entrys.id").getValue());
                    }
                }
                if (entryids.size() != 1) {
                    MsgBox.showConfirm2((String)ProjectChangeListUI.getResource("Msg_Please_ChangeOneBill"));
                } else {
                    String entryKey = entryids.get(0).toString();
                    Map retMap = null;
                    if (!"".equalsIgnoreCase(entryKey)) {
                        try {
                            retMap = ProjectChangeLinkRptFacadeFactory.getRemoteInstance().getProjectChangeLinkInfo(entryKey);
                        }
                        catch (EASBizException ex) {
                            this.handUIException(ex);
                        }
                    } else {
                        MsgBox.showInfo((String)ProjectChangeListUI.getResource("Msg_EntrysIsNull"));
                        return;
                    }
                    if (retMap != null) {
                        UIContext map = new UIContext((Object)this);
                        map.put("Owner", this);
                        map.put("rptData", retMap);
                        IUIWindow uiWindow = null;
                        String destBillEditUIClassName = "com.kingdee.eas.mm.basedata.client.ProjectChangeLinkRptUI";
                        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(destBillEditUIClassName, (Map)map, null, OprtState.VIEW);
                        uiWindow.show();
                        this.disposeUIWindow();
                    }
                }
            }
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.removeVerify()) {
            super.actionRemove_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)ProjectChangeListUI.getResource("Msg_List_NotSaveSubmit_NotDelete"));
        }
    }

    private boolean removeVerify() throws EASBizException, BOSException, UuidException {
        boolean isVerify = false;
        ArrayList ids = this.getSelectedIdValues();
        for (int i = 0; i < ids.size(); ++i) {
            ProjectChangeInfo pcinfo = ProjectChangeFactory.getRemoteInstance().getProjectChangeInfo((IObjectPK)new ObjectUuidPK(ids.get(i).toString()));
            if (null == pcinfo || pcinfo.getBaseStatus() == BillBaseStatusEnum.SUBMITED || pcinfo.getBaseStatus() == BillBaseStatusEnum.TEMPORARILYSAVED) continue;
            isVerify = true;
            break;
        }
        return isVerify;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ProjectChangeFilterUI();
        }
        return this.conditionPanel;
    }

    protected boolean initDefaultFilter() {
        Map map = this.getUIContext();
        return null == map || null == map.get("bomID");
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ProjectChangeFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        ProjectChangeInfo objectValue = new ProjectChangeInfo();
        return objectValue;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, ProjectChangeFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, ProjectChangeEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entrys.id", "number", "entrys.seq", "storageOrgUnit.id");
        super.initBatchActions();
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        if (BatchActionEnum.UNAUDIT.equals((Object)bizAction)) {
            return false;
        }
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    protected static String getResource(String strKey) {
        return EASResource.getString((String)RESOURCE_PATH, (String)strKey);
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "storageOrgUnit.id";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog commonQueryDialog = super.initCommonQueryDialog();
        commonQueryDialog.setTitle(ProjectChangeListUI.getResource("Msg_ProjectChangeFTitle"));
        commonQueryDialog.setWidth(490);
        commonQueryDialog.setHeight(527);
        commonQueryDialog.setProcessor((IProcessor)new MMCommonQueryProcessor());
        return commonQueryDialog;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    @Override
    public void actionViewTrackNumber_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        ArrayList list = this.tblMain.getSelectManager().getBlocks();
        if (list == null || list.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        KDTSelectBlock block = (KDTSelectBlock)list.get(0);
        int rowIndex = block.getTop();
        if (rowIndex == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        Object entryId = this.tblMain.getCell(rowIndex, "entrys.id").getValue();
        if (entryId == null) {
            return;
        }
        UIHelper.openTrackNumberListUIforBomChange((String)entryId.toString(), (boolean)false, (Map)this.getUIContext());
    }

    protected String[] getQueryShowField() {
        return new String[]{"storageOrgUnit.name", "number", "baseStatus", "changeType", "Entry.bomNo.number", "Entry.parentItemNumber", "Entry.parentItemName", "Entry.parentItemModel", "Entry.childItem.number", "Entry.childItemName", "Entry.childItemModel", "Entry.oprationType", "startDate", "producer.name", "desinger.name", "createTime", "requestNo", "requester.name", "department.name", "zzBom", "ddBom", "pzBom"};
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.tblMain, (int)this.freezeColIndex);
    }

    class MMCommonQueryProcessor
    extends CommonQueryProcessor {
        MMCommonQueryProcessor() {
        }

        public void process() throws Exception {
            CommonQueryPanel commonQueryPanel = (CommonQueryPanel)this.get("COMMON_QUERY_PANEL");
            CustomerQueryPanel customerQueryPanel = (CustomerQueryPanel)commonQueryPanel.getCustomerQueryPanel().get(0);
            FilterInfo filterInfo = customerQueryPanel.getFilterInfo();
            FilterItemCollection cols = filterInfo.getFilterItems();
            FilterItemInfo itemInfo = null;
            FilterInfo defineInfo = new FilterInfo();
            for (int i = 0; i < cols.size(); ++i) {
                itemInfo = cols.get(i);
                if (!itemInfo.getPropertyName().endsWith("storageOrgUnit.number")) continue;
                defineInfo.getFilterItems().add(itemInfo);
            }
            String field = (String)this.get("CURRENT_FIELD_PROP");
            if (field == null || field.trim().length() == 0) {
                return;
            }
            Object editor = this.get("CURRENT_EDITOR");
            if (defineInfo.getFilterItems().size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(defineInfo);
                if ("Entry.bomNo.number".equals(field) && editor instanceof KDBizPromptBox) {
                    ((KDBizPromptBox)editor).setEntityViewInfo(viewInfo);
                }
            }
            if ("baseStatus".equals(field) && editor instanceof KDComboBox) {
                ArrayList<BillBaseStatusEnum> statusList = new ArrayList<BillBaseStatusEnum>();
                statusList.add(BillBaseStatusEnum.SUBMITED);
                statusList.add(BillBaseStatusEnum.TEMPORARILYSAVED);
                statusList.add(BillBaseStatusEnum.AUDITED);
                statusList.add(BillBaseStatusEnum.NULL);
                KDComboBox statusComb = (KDComboBox)editor;
                statusComb.removeAllItems();
                statusComb.addItems(statusList.toArray());
            }
        }
    }
}

