/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.OrgUnitDelegationFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.ClassGroupInfo;
import com.kingdee.eas.mm.basedata.HumanResourceTypeEnum;
import com.kingdee.eas.mm.basedata.IResource;
import com.kingdee.eas.mm.basedata.ProductLineWPException;
import com.kingdee.eas.mm.basedata.ResourceEntryCollection;
import com.kingdee.eas.mm.basedata.ResourceEntryInfo;
import com.kingdee.eas.mm.basedata.ResourceFactory;
import com.kingdee.eas.mm.basedata.ResourceInfo;
import com.kingdee.eas.mm.basedata.ResourceStatusEnum;
import com.kingdee.eas.mm.basedata.ResourceTypeEnum;
import com.kingdee.eas.mm.basedata.client.AbstractResourceEditUI;
import com.kingdee.eas.mm.basedata.client.ResourceEquipmentProcessor;
import com.kingdee.eas.mm.common.client.F7MultiSelectHelper;
import com.kingdee.eas.mm.common.client.ITableMultiSelect;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ResourceEditUI
extends AbstractResourceEditUI
implements ITableMultiSelect {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ResourceEditUI.class);
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.mm.basedata.BasedataResource";
    private static final String RESOURCE_PATH = "com.kingdee.eas.mm.basedata.ResourceResource";
    public static final String TB_NUMBER = "number";
    public static final String TB_NAME = "name";
    public static final String TB_HRTYPE = "hrType";
    public static final String TB_MAXSTORAGE = "maxStorage";
    public static final String TB_UNIT = "unit";
    public static final String TB_REMARK = "remark";
    private DataChangeListener prmtunitChanged = null;
    private DataChangeListener prmtPersonnelChanged = null;
    private ActionListener resourceComboListener = null;
    private HashMap costCenter;
    private KDTEditAdapter entryTableChange = null;
    private DataChangeListener storageOrgUnitDataChanged = null;
    private KDTActiveCellListener maxStorageListener = null;
    private FocusListener feeRateFocusListener = null;
    private CommitListener numberCommitListener = null;
    private SelectorListener numberSelectorListener = null;
    private BigDecimal zeroBigDecimal = new BigDecimal("0.00");
    private BigDecimal maxBigDecimal = new BigDecimal("1.0E13");
    private KDBizPromptBox numberBox = null;
    private F7MultiSelectHelper mulSelectHelper = null;
    private int precision = 2;
    private final Map RULE_STATUS_CACHE = new HashMap();
    private DataChangeListener workshopChangeListener = null;

    public ResourceEditUI() throws Exception {
        this.costCenter = new HashMap();
        this.mulSelectHelper = new F7MultiSelectHelper((ITableMultiSelect)this, this.kdtEntries);
    }

    public void onLoad() throws Exception {
        this.resourceStatus.removeAllItems();
        this.resourceStatus.addItems(new Object[]{ResourceStatusEnum.Using, ResourceStatusEnum.Stop});
        super.onLoad();
        this.txtFeeRate.setDataType(6);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.initHeaderCtrl();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_resource_addnew");
        this.setFeeRatePrecision();
        this.kdtEntries.getActionMap().remove("Paste");
        this.kdtEntries.getActionMap().remove("Copy");
        this.kdtEntries.getActionMap().remove("Cut");
        this.kdtEntries.getActionMap().remove("Delete");
        this.txtFeeRate.setMaximumNumber((Number)this.maxBigDecimal);
        this.txtFeeRate.setNegatived(false);
        this.txtFeeRate.setSupportedEmpty(true);
        this.registerEquipmentF7();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        if (this.numberCommitListener == null) {
            this.numberCommitListener = new CommitListener(){

                public void willCommit(CommitEvent e) {
                    ResourceEditUI.this.filterEquipmentF7();
                }
            };
        }
        if (this.numberSelectorListener == null) {
            this.numberSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    ResourceEditUI.this.filterEquipmentF7();
                }
            };
        }
        if (this.numberBox != null) {
            this.numberBox.addCommitListener(this.numberCommitListener);
            this.numberBox.addSelectorListener(this.numberSelectorListener);
        }
        this.menuItemApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    @Override
    public void loadFields() {
        try {
            this.removeListener();
            this.txtFeeRate.setPrecision(this.precision);
            if (this.editData.getFeeRate() == null || this.editData.getFeeRate().compareTo(this.zeroBigDecimal) == 0) {
                this.zeroBigDecimal = this.zeroBigDecimal.setScale(this.precision);
                this.editData.setFeeRate(this.zeroBigDecimal);
            }
            super.loadFields();
            StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getData();
            this.initWorkshopF7(this.prmtworkshop, storageOrgUnit);
            this.setCostCenterF7(storageOrgUnit);
            this.dealVisibleWithRSType(this.editData.getResourceType());
            this.initEntryTable(storageOrgUnit);
            this.setMeasureUnitStatus();
            if (this.getOprtState().equals("ADDNEW")) {
                this.addLine(this.getDetailTable());
            }
            this.setResourceTypeEnabled();
            if (this.getOprtState().equals("VIEW")) {
                this.resourceType.setEnabled(false);
                this.resourceStatus.setEnabled(false);
            }
            this.setTextNumber();
            if (this.getOprtState().equals("ADDNEW")) {
                this.prmtstorageOrgUnit.setAccessAuthority(0);
                this.prmtstorageOrgUnit.setEditable(true);
            } else {
                this.prmtstorageOrgUnit.setAccessAuthority(1);
                this.prmtstorageOrgUnit.setEditable(false);
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        finally {
            this.addListener();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.classGroup.id"));
        sic.add(new SelectorItemInfo("entries.classGroup.number"));
        sic.add(new SelectorItemInfo("entries.classGroup.name"));
        return sic;
    }

    protected void prmtUnit_dataChanged(DataChangeEvent eventObj) {
        MeasureUnitInfo unit = (MeasureUnitInfo)eventObj.getNewValue();
        int rowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        if (unit != null) {
            int precision = unit.getQtyPrecision();
            String colPrecision = PrecisionUtil.getFormatString((int)precision);
            ICell iCell = this.kdtEntries.getCell(rowIndex, TB_MAXSTORAGE);
            iCell.getStyleAttributes().setNumberFormat(colPrecision);
            BigDecimal maxStorage = (BigDecimal)iCell.getValue();
            iCell.setValue(maxStorage == null ? null : maxStorage.setScale(precision, 4));
        }
    }

    public void addListener() {
        if (this.storageOrgUnitDataChanged == null) {
            this.storageOrgUnitDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        ResourceEditUI.this.prmtstorageOrgUnit_dataChanged(e);
                    }
                    catch (Exception exc) {
                        ResourceEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtstorageOrgUnit.addDataChangeListener(this.storageOrgUnitDataChanged);
        if (this.resourceComboListener == null) {
            this.resourceComboListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceEditUI.this.rsCombo_actionPerformed(e);
                }
            };
        }
        this.resourceType.addActionListener(this.resourceComboListener);
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        ResourceEditUI.this.kdtEntries_Changed(e);
                    }
                    catch (Exception exc) {
                        ResourceEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.prmtunitChanged == null) {
            this.prmtunitChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        ResourceEditUI.this.prmtUnit_dataChanged(e);
                    }
                    catch (Exception e1) {
                        ResourceEditUI.this.handleException(e1);
                    }
                }
            };
        }
        ((KDBizPromptBox)this.kdtEntries.getColumn(TB_UNIT).getEditor().getComponent()).addDataChangeListener(this.prmtunitChanged);
        if (this.maxStorageListener == null) {
            this.maxStorageListener = new KDTActiveCellListener(){

                public void activeCellChanged(KDTActiveCellEvent e) {
                    ResourceEditUI.this.txtMaxStorage_onblur(e);
                }
            };
        }
        this.kdtEntries.getSelectManager().addKDTActiveCellListener(this.maxStorageListener);
        if (this.feeRateFocusListener == null) {
            this.feeRateFocusListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    ResourceEditUI.this.setMeasureUnitStatus();
                }
            };
        }
        this.txtFeeRate.addFocusListener(this.feeRateFocusListener);
        if (this.workshopChangeListener == null) {
            this.workshopChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        ResourceEditUI.this.workShop_change(e);
                    }
                    catch (Exception e1) {
                        ResourceEditUI.this.handleException(e1);
                    }
                }
            };
        }
        this.prmtworkshop.addDataChangeListener(this.workshopChangeListener);
    }

    public void removeListener() {
        KDBizPromptBox box;
        ICellEditor editor;
        if (this.storageOrgUnitDataChanged != null) {
            this.prmtstorageOrgUnit.removeDataChangeListener(this.storageOrgUnitDataChanged);
        }
        if (this.resourceComboListener != null) {
            this.resourceType.removeActionListener(this.resourceComboListener);
        }
        if (this.prmtunitChanged != null && (editor = this.kdtEntries.getColumn(TB_UNIT).getEditor()) != null && (box = (KDBizPromptBox)editor.getComponent()) != null) {
            box.removeDataChangeListener(this.prmtunitChanged);
        }
        if (this.maxStorageListener != null) {
            this.kdtEntries.getSelectManager().removeKDTActiveCellListener(this.maxStorageListener);
        }
        if (this.feeRateFocusListener != null) {
            this.txtFeeRate.removeFocusListener(this.feeRateFocusListener);
        }
        if (this.numberCommitListener != null) {
            this.numberBox.removeCommitListener(this.numberCommitListener);
        }
        if (this.numberSelectorListener != null) {
            this.numberBox.removeSelectorListener(this.numberSelectorListener);
        }
    }

    public void addListenerForPersonnel(int rowIndex) {
        this.prmtPersonnelChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    ResourceEditUI.this.prmtpersonnel_dataChanged(eventObj);
                }
                catch (Exception e) {
                    ResourceEditUI.this.handleException(e);
                }
            }
        };
        ((KDBizPromptBox)this.kdtEntries.getRow(rowIndex).getCell(TB_NUMBER).getEditor().getComponent()).addDataChangeListener(this.prmtPersonnelChanged);
    }

    public void txtMaxStorage_onblur(KDTActiveCellEvent e) {
        int preRowIndex = e.getPrevRowIndex();
        int preColIndex = e.getPrevColumnIndex();
        String fieldName = this.kdtEntries.getColumnKey(preColIndex);
        if (preRowIndex >= 0 && fieldName != null && fieldName.equals(TB_MAXSTORAGE) && preRowIndex < this.kdtEntries.getRowCount()) {
            if (this.kdtEntries.getRow(preRowIndex).getCell(TB_MAXSTORAGE).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(preRowIndex).getCell(TB_MAXSTORAGE).getValue()).signum() > 0) {
                this.kdtEntries.getRow(preRowIndex).getCell(TB_UNIT).getStyleAttributes().setLocked(false);
            } else {
                this.kdtEntries.getRow(preRowIndex).getCell(TB_UNIT).getStyleAttributes().setLocked(true);
                this.kdtEntries.getRow(preRowIndex).getCell(TB_UNIT).setValue(null);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        boolean flag = false;
        if (this.editData.getFeeRate() == null) {
            this.editData.setFeeRate(this.zeroBigDecimal.setScale(this.precision));
        }
        if (!this.editData.isValueChange()) {
            flag = true;
        }
        if (this.editData.getResourceType() != null) {
            if (this.editData.getResourceType().getValue() == 30) {
                for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                    ResourceEntryInfo rsEntryInfo;
                    IRow row = this.kdtEntries.getRow(i);
                    if (row.getCell(TB_HRTYPE).getValue() == null) continue;
                    if (row.getCell(TB_HRTYPE).getValue().equals((Object)HumanResourceTypeEnum.PERSONNEL)) {
                        rsEntryInfo = (ResourceEntryInfo)row.getUserObject();
                        PersonInfo person = (PersonInfo)row.getCell(TB_NUMBER).getValue();
                        rsEntryInfo.setPerson(person);
                        continue;
                    }
                    if (!row.getCell(TB_HRTYPE).getValue().equals((Object)HumanResourceTypeEnum.CLASSGROUP)) continue;
                    rsEntryInfo = (ResourceEntryInfo)row.getUserObject();
                    ClassGroupInfo classGroup = (ClassGroupInfo)row.getCell(TB_NUMBER).getValue();
                    rsEntryInfo.setClassGroup(classGroup);
                }
            } else if (this.editData.getResourceType().getValue() == 10) {
                EquipmentArchivesInfo info = null;
                for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                    IRow row = this.kdtEntries.getRow(i);
                    ResourceEntryInfo rsEntryInfo = (ResourceEntryInfo)row.getUserObject();
                    info = (EquipmentArchivesInfo)row.getCell(TB_NUMBER).getValue();
                    if (info != null) {
                        rsEntryInfo.setNumber(info.getNumber());
                        rsEntryInfo.setEquipment(info);
                    }
                    rsEntryInfo.setName((String)row.getCell(TB_NAME).getValue());
                }
            }
        }
        if (flag) {
            this.initOldData((IObjectValue)this.editData);
        }
    }

    public void dealVisibleWithRSType(ResourceTypeEnum rsType) {
        if (rsType == ResourceTypeEnum.Equipment) {
            this.resourceStatus.setEnabled(true);
            this.kdtEntries.getColumn(TB_HRTYPE).getStyleAttributes().setHided(true);
            this.kdtEntries.getColumn(TB_HRTYPE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_NUMBER).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_MAXSTORAGE).getStyleAttributes().setHided(false);
            this.kdtEntries.getColumn(TB_MAXSTORAGE).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_UNIT).getStyleAttributes().setHided(false);
            this.registerEquipmentF7();
            this.filterEquipmentF7();
            this.kdtEntries.getColumn(TB_NAME).getStyleAttributes().setLocked(true);
        } else if (rsType == ResourceTypeEnum.PERSONNEL) {
            this.kdtEntries.getColumn(TB_HRTYPE).getStyleAttributes().setHided(false);
            this.kdtEntries.getColumn(TB_HRTYPE).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_NAME).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_NUMBER).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MAXSTORAGE).getStyleAttributes().setHided(true);
            this.kdtEntries.getColumn(TB_MAXSTORAGE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_UNIT).getStyleAttributes().setHided(true);
            SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntries, (String[])new String[]{TB_NAME}, (boolean)false);
        }
    }

    public void initHeaderCtrl() {
        this.txtName.setMaxLength(80);
        this.txtremark.setMaxLength(255);
        this.editData.getUsingRate();
        this.txtUsingRate.setNegatived(false);
        this.txtUsingRate.setPrecision(2);
        this.txtUsingRate.setRemoveingZeroInDispaly(false);
        this.txtUsingRate.setHorizontalAlignment(4);
        this.txtEfficiency.setPrecision(2);
        this.txtEfficiency.setRemoveingZeroInDispaly(false);
        this.txtEfficiency.setNegatived(false);
        this.txtEfficiency.setHorizontalAlignment(4);
    }

    public void initEntryTable(StorageOrgUnitInfo storageOrgInfo) {
        if (this.editData.getResourceType() == ResourceTypeEnum.PERSONNEL) {
            for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                if (this.kdtEntries.getRow(i).getCell(TB_HRTYPE).getValue() != null) {
                    if (this.kdtEntries.getRow(i).getCell(TB_HRTYPE).getValue().equals((Object)HumanResourceTypeEnum.PERSONNEL)) {
                        this.buildPersonCell(i, (AdminOrgUnitInfo)this.prmtworkshop.getValue());
                        this.kdtEntries.getRow(i).getCell(TB_NUMBER).setValue((Object)((ResourceEntryInfo)this.kdtEntries.getRow(i).getUserObject()).getPerson());
                        this.kdtEntries.getRow(i).getCell(TB_NAME).setValue((Object)((ResourceEntryInfo)this.kdtEntries.getRow(i).getUserObject()).getPerson().getName());
                    } else {
                        this.buildClassGroupCell(i, storageOrgInfo);
                        this.kdtEntries.getRow(i).getCell(TB_NUMBER).setValue((Object)((ResourceEntryInfo)this.kdtEntries.getRow(i).getUserObject()).getClassGroup());
                        this.kdtEntries.getRow(i).getCell(TB_NAME).setValue((Object)((ResourceEntryInfo)this.kdtEntries.getRow(i).getUserObject()).getClassGroup().getName());
                    }
                    this.addListenerForPersonnel(i);
                }
                this.kdtEntries.getRow(i).getCell(TB_NUMBER).getStyleAttributes().setLocked(false);
            }
        } else if (this.editData.getResourceType() == ResourceTypeEnum.Equipment) {
            IRow row = null;
            EquipmentArchivesInfo info = null;
            ResourceEntryInfo entryInfo = null;
            MeasureUnitInfo unit = null;
            int precision = 2;
            ICell iCell = null;
            BigDecimal maxStorage = null;
            for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                row = this.kdtEntries.getRow(i);
                entryInfo = (ResourceEntryInfo)row.getUserObject();
                info = new EquipmentArchivesInfo();
                if (entryInfo.getEquipment() != null) {
                    info.setId(entryInfo.getEquipment().getId());
                }
                info.setName(entryInfo.getName());
                info.setNumber(entryInfo.getNumber());
                row.getCell(TB_NUMBER).setValue((Object)info);
                row.getCell(TB_NAME).setValue((Object)entryInfo.getName());
                if (row.getCell(TB_UNIT).getValue() != null) {
                    row.getCell(TB_UNIT).getStyleAttributes().setLocked(false);
                    unit = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(TB_UNIT).getValue();
                    precision = unit.getQtyPrecision();
                    String colPrecision = PrecisionUtil.getFormatString((int)precision);
                    iCell = this.kdtEntries.getCell(i, TB_MAXSTORAGE);
                    iCell.getStyleAttributes().setNumberFormat(colPrecision);
                    maxStorage = (BigDecimal)iCell.getValue();
                    iCell.setValue(maxStorage == null ? null : maxStorage.setScale(precision, 4));
                    continue;
                }
                row.getCell(TB_UNIT).getStyleAttributes().setLocked(true);
            }
        }
        KDFormattedTextField maxStorage = (KDFormattedTextField)this.kdtEntries.getColumn(TB_MAXSTORAGE).getEditor().getComponent();
        maxStorage.setNegatived(false);
        maxStorage.setRemoveingZeroInDispaly(true);
        maxStorage.setSupportedEmpty(true);
        maxStorage.setMaximumValue((Comparable)MMConstant.MAX_BIGDECIMAL);
        KDBizMultiLangBox mlRemark = new KDBizMultiLangBox();
        mlRemark.setMaxLength(200);
        String language = LocaleUtils.getDefaultLocale().getLanguage();
        int count = mlRemark.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!((MultiLangItem)mlRemark.getItemAt(i)).getLang().getLocale().getLanguage().equalsIgnoreCase(language)) continue;
            mlRemark.setSelectedIndex(i);
        }
        this.kdtEntries.getColumn(TB_REMARK).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)mlRemark));
        if (this.numberCommitListener == null) {
            this.numberCommitListener = new CommitListener(){

                public void willCommit(CommitEvent e) {
                    ResourceEditUI.this.filterEquipmentF7();
                }
            };
        }
        if (this.numberSelectorListener == null) {
            this.numberSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    ResourceEditUI.this.filterEquipmentF7();
                }
            };
        }
        if (this.numberBox != null) {
            this.numberBox.addCommitListener(this.numberCommitListener);
            this.numberBox.addSelectorListener(this.numberSelectorListener);
        }
    }

    public void buildPersonCell(int rowIndex, AdminOrgUnitInfo department) {
        KDBizPromptBox prmtperson = new KDBizPromptBox();
        prmtperson.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        prmtperson.setVisible(true);
        prmtperson.setEditable(true);
        prmtperson.setDisplayFormat("$number$");
        prmtperson.setEditFormat("$number$");
        prmtperson.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (department != null) {
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)department.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)" ", CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)String.valueOf(1), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        prmtperson.setEntityViewInfo(viewInfo);
        ObjectValueRender renderer = new ObjectValueRender();
        renderer.setFormat((IDataFormat)new BizDataFormat("$number$"));
        KDTDefaultCellEditor kdtEntries_person_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtperson);
        this.kdtEntries.getRow(rowIndex).getCell(TB_NUMBER).setEditor((ICellEditor)kdtEntries_person_CellEditor);
        this.kdtEntries.getRow(rowIndex).getCell(TB_NUMBER).setRenderer((IBasicRender)renderer);
    }

    public void buildClassGroupCell(int rowIndex, StorageOrgUnitInfo storageOrgInfo) {
        KDBizPromptBox prmtclassGroup = new KDBizPromptBox();
        prmtclassGroup.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7ClassGroupQuery");
        prmtclassGroup.setVisible(true);
        prmtclassGroup.setEditable(true);
        prmtclassGroup.setDisplayFormat("$number$");
        prmtclassGroup.setEditFormat("$number$");
        prmtclassGroup.setCommitFormat("$number$");
        if (storageOrgInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            prmtclassGroup.setEntityViewInfo(viewInfo);
        }
        ObjectValueRender renderer = new ObjectValueRender();
        renderer.setFormat((IDataFormat)new BizDataFormat("$number$"));
        KDTDefaultCellEditor kdtEntries_classGroup_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtclassGroup);
        this.kdtEntries.getRow(rowIndex).getCell(TB_NUMBER).setEditor((ICellEditor)kdtEntries_classGroup_CellEditor);
        this.kdtEntries.getRow(rowIndex).getCell(TB_NUMBER).setRenderer((IBasicRender)renderer);
    }

    public void kdtEntries_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        AdminOrgUnitInfo department = (AdminOrgUnitInfo)this.prmtworkshop.getValue();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (fieldName.equals(TB_HRTYPE) && newValue != null && !newValue.equals(oldValue)) {
            this.kdtEntries.getRow(rowIndex).getCell(TB_NUMBER).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(TB_NAME).setValue(null);
            if (((HumanResourceTypeEnum)((Object)newValue)).equals((Object)HumanResourceTypeEnum.PERSONNEL)) {
                this.buildPersonCell(rowIndex, department);
            } else if (((HumanResourceTypeEnum)((Object)newValue)).equals((Object)HumanResourceTypeEnum.CLASSGROUP)) {
                this.buildClassGroupCell(rowIndex, storageOrgInfo);
            }
            this.addListenerForPersonnel(rowIndex);
            if (oldValue == null) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_NUMBER).getStyleAttributes().setLocked(false);
            }
        }
    }

    public void prmtpersonnel_dataChanged(DataChangeEvent e) {
        DataBaseInfo hrInfo = (DataBaseInfo)e.getNewValue();
        int rowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        if (hrInfo != null) {
            this.kdtEntries.getCell(rowIndex, TB_NAME).setValue((Object)hrInfo.getName());
        } else {
            this.kdtEntries.getCell(rowIndex, TB_NAME).setValue(null);
        }
    }

    public void rsCombo_actionPerformed(ActionEvent e) {
        if (!((ResourceTypeEnum)((Object)this.resourceType.getSelectedItem())).equals((Object)this.editData.getResourceType())) {
            if (!ResourceEditUI.checkEntryIsBlank(this.getDetailTable())) {
                if (!MsgBox.isYes((int)MsgBox.showConfirm2((String)this.getRSResource("MSG_SRCTYPECHG_CLEARENTRY")))) {
                    this.resourceType.setSelectedItem((Object)this.editData.getResourceType());
                    return;
                }
                this.kdtEntries.removeRows();
            }
            this.editData.setResourceType((ResourceTypeEnum)((Object)this.resourceType.getSelectedItem()));
            this.dealVisibleWithRSType(this.editData.getResourceType());
        }
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtstorageOrgUnit;
    }

    protected void prmtstorageOrgUnit_dataChanged(DataChangeEvent e) {
        StorageOrgUnitInfo newStorageOrgUnitInfo;
        StorageOrgUnitInfo oldStorageOrgUnitInfo = (StorageOrgUnitInfo)e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldStorageOrgUnitInfo, (Object)(newStorageOrgUnitInfo = (StorageOrgUnitInfo)e.getNewValue()));
        if (isDiffrent) {
            if (newStorageOrgUnitInfo != null) {
                if (!ResourceEditUI.checkEntryIsBlank(this.kdtEntries)) {
                    if (!MsgBox.isYes((int)MsgBox.showConfirm2((String)this.getRSResource("MSG_ORGCHANGE_CLEARENTRY")))) {
                        this.prmtstorageOrgUnit.removeDataChangeListener(this.storageOrgUnitDataChanged);
                        this.prmtstorageOrgUnit.setValue((Object)oldStorageOrgUnitInfo);
                        this.prmtstorageOrgUnit.addDataChangeListener(this.storageOrgUnitDataChanged);
                        return;
                    }
                    this.kdtEntries.removeRows();
                    this.addLine(this.getDetailTable());
                }
                try {
                    this.prmtworkshop.setValue(null);
                    this.initWorkshopF7(this.prmtworkshop, newStorageOrgUnitInfo);
                    this.prmtCostCenterOrgUnit.setValue(null);
                    this.setCostCenterF7(newStorageOrgUnitInfo);
                    this.setFeeRatePrecision();
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            } else {
                int i;
                MsgBox.showInfo((String)ResourceEditUI.getMessage("STORAGEORG_NOT_NULL"));
                DataChangeListener[] datachange = (DataChangeListener[])this.prmtstorageOrgUnit.getListeners(DataChangeListener.class);
                ChangeListener[] changelistener = (ChangeListener[])this.prmtstorageOrgUnit.getListeners(ChangeListener.class);
                for (i = 0; i < datachange.length; ++i) {
                    this.prmtstorageOrgUnit.removeDataChangeListener(datachange[i]);
                }
                for (i = 0; i < changelistener.length; ++i) {
                    this.prmtstorageOrgUnit.removeChangeListener(changelistener[i]);
                }
                this.editData.setStorageOrgUnit(oldStorageOrgUnitInfo);
                this.prmtstorageOrgUnit.setValue((Object)oldStorageOrgUnitInfo);
                for (i = 0; i < datachange.length; ++i) {
                    this.prmtstorageOrgUnit.addDataChangeListener(datachange[i]);
                }
                for (i = 0; i < changelistener.length; ++i) {
                    this.prmtstorageOrgUnit.addChangeListener(changelistener[i]);
                }
                this.prmtstorageOrgUnit.requestFocus();
            }
            this.setTextNumberAfterMainOrgChanged();
        }
    }

    public void initWorkshopF7(KDBizPromptBox workshopBox, StorageOrgUnitInfo storageOrgInfo) throws Exception {
        workshopBox.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unitLayerType.id", (Object)"00000000-0000-0000-0000-00000000000362824988", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)"1", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        workshopBox.setEntityViewInfo(viewInfo);
        workshopBox.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        IFilterInfoProducer iProducer = FilterInfoProducerFactory.getOrgUnitDelegationFilterInfoProducer((DelegationPartsEnum)DelegationPartsEnum.THE_TO_UNIT, (OrgType)OrgType.Admin);
        OrgUnitDelegationFilterInfoProducer producer = (OrgUnitDelegationFilterInfoProducer)iProducer;
        producer.getModel().setDoNotUseUserOrgRangeAsFilter();
        workshopBox.setFilterInfoProducer((IFilterInfoProducer)producer);
        workshopBox.setCurrentMainBizOrgUnit((OrgUnitInfo)storageOrgInfo, OrgType.Storage);
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ResourceFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        ResourceInfo objectValue = new ResourceInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setCreateTime(new Timestamp(new Date().getTime()));
        objectValue.setResourceType(ResourceTypeEnum.Equipment);
        OrgUnitInfo orgUnit = MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_resource_addnew");
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)orgUnit);
        objectValue.setStatus(BDStatusEnum.UNAPPROVE);
        return objectValue;
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
        vo.put("usingRate", (Object)new BigDecimal(100.0));
        vo.put("efficiency", (Object)new BigDecimal(100.0));
    }

    public static boolean checkEntryIsBlank(KDTable kdtEntrys) {
        int rows = kdtEntrys.getRowCount();
        int cols = kdtEntrys.getColumnCount();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    if (kdtEntrys.getRow(i).getCell(j).getValue() == null || kdtEntrys.getRow(i).getCell(j).getValue().toString().trim().length() <= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("Msg_ApprovedCannotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.setTextNumber();
        this.setResourceTypeEnabled();
        this.prmtstorageOrgUnit.setAccessAuthority(1);
        this.prmtstorageOrgUnit.setEditable(false);
    }

    private void setResourceTypeEnabled() throws Exception {
        if (!this.getOprtState().equals("EDIT")) {
            return;
        }
        ResourceTypeEnum type = this.editData.getResourceType();
        if (ResourceTypeEnum.Equipment.equals((Object)type)) {
            IResource resource = (IResource)this.getBizInterface();
            boolean isMainResource = resource.isMainResource(this.editData.getId().toString());
            if (isMainResource) {
                this.resourceType.setEnabled(false);
                this.resourceStatus.setEnabled(false);
            } else {
                this.resourceType.setEnabled(true);
                this.resourceStatus.setEnabled(true);
            }
        } else if (ResourceTypeEnum.PERSONNEL.equals((Object)type)) {
            this.resourceType.setEnabled(true);
            this.resourceStatus.setEnabled(true);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.removeListener();
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherBase(0);
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherBase(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doActionOtherBase(int actionenumvalue) throws BOSException, EASBizException {
        block29: {
            if (this.editData == null || this.editData.getId() == null || "".equals(this.editData.getId().toString())) break block29;
            id = this.editData.getId().toString();
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable e1) {
                this.handUIException(e1);
                SysUtil.abort();
            }
            try {
                irs = ResourceFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                pk = new ObjectUuidPK(this.editData.getId());
                this.doCheckStatusBase(actionenumvalue);
                str = null;
                switch (actionenumvalue) {
                    case 0: {
                        str = irs.approve((IObjectPK)pk);
                        break;
                    }
                    case 1: {
                        try {
                            irs.isBizRef(BOSUuid.read((String)pk.toString()));
                        }
                        catch (Exception e) {
                            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Material_UnApprove_Msgbox")))) ** GOTO lbl31
                            this.setOprtState("RELEASEALL");
                            try {
                                this.pubFireVOChangeListener(id);
                            }
                            catch (Throwable t) {
                                this.handUIException(t);
                            }
                            return;
                        }
lbl31:
                        // 2 sources

                        str = irs.unapprove((IObjectPK)pk);
                    }
                }
                if (null == str || "".equals(str)) {
                    this.setOprtState("VIEW");
                    CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
                    value = (ResourceInfo)irs.getValue((IObjectPK)pk, this.getSelectors());
                    storageOrgUnitId = value.getStorageOrgUnit().getId().toString();
                    feeRate = value.getFeeRate();
                    if (feeRate == null || feeRate.equals(this.zeroBigDecimal)) {
                        baseCurrInfo = MMUtils.getBaseCurrencyByCompanyOrg((String)storageOrgUnitId);
                        scale = baseCurrInfo.getPrecision();
                        value.setFeeRate(this.zeroBigDecimal.setScale(scale, 4));
                    }
                    this.setDataObject((IObjectValue)value);
                    this.editData.copyNewToOld();
                    this.loadFields();
                    this.setSaved(true);
                } else {
                    MsgBox.showWarning((String)str);
                }
            }
            catch (EASBizException ex) {
                this.handleException((Exception)ex);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                this.setOprtState("RELEASEALL");
                try {
                    this.pubFireVOChangeListener(id);
                }
                catch (Throwable t) {
                    this.handUIException(t);
                }
            }
        }
    }

    private void doCheckStatusBase(int actionenumvalue) throws BOSException, EASBizException {
        if (this.editData != null) {
            switch (actionenumvalue) {
                case 0: {
                    if (this.editData.getStatus() != BDStatusEnum.APPROVE) break;
                    throw new ProductLineWPException(ProductLineWPException.AUDITED);
                }
                case 1: {
                    if (this.editData.getStatus() != BDStatusEnum.UNAPPROVE) break;
                    throw new ProductLineWPException(ProductLineWPException.UNAUDIT);
                }
            }
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)RESOURCE_FULLNAME, (String)key);
    }

    private String getRSResource(String key) {
        return EASResource.getString((String)RESOURCE_PATH, (String)key);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        ResourceInfo info = (ResourceInfo)this.dataBinder.getValueObject();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.idList != null && this.idList.size() == 0) {
                this.unLockUI();
            }
            this.txtNumber.setEditable(false);
            this.actionApprove.setEnabled(false);
            this.actionUnApprove.setEnabled(false);
            this.actionCopy.setEnabled(false);
            this.initEntryKeyListener(true);
        } else if (null != info.getId() && this.getOprtState().equals(OprtState.EDIT)) {
            if (info.getStatus().getValue() == 20) {
                this.actionApprove.setEnabled(false);
                this.actionUnApprove.setEnabled(true);
            } else {
                this.actionApprove.setEnabled(true);
                this.actionUnApprove.setEnabled(false);
            }
            this.actionCopy.setEnabled(true);
            this.initEntryKeyListener(true);
        } else if (null != info.getId() && this.getOprtState().equals(OprtState.VIEW)) {
            if (info.getStatus().getValue() == 20) {
                this.actionApprove.setEnabled(false);
                this.actionUnApprove.setEnabled(true);
            } else {
                this.actionApprove.setEnabled(true);
                this.actionUnApprove.setEnabled(false);
            }
            this.actionCopy.setEnabled(true);
            this.initEntryKeyListener(false);
        }
        this.setEntryButtonEnable();
        String title = EASResource.getString((String)RESOURCE_FULLNAME, (String)"ResourceQueryF7WindowTitle");
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)title);
    }

    public void setEntryButtonEnable() {
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnAddLine.setEnabled(true);
            this.btnInsertLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
        } else {
            this.btnAddLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
        }
    }

    public void setTextNumber() {
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (storageOrgUnit != null) {
            this.setNumberTextStatus(storageOrgUnit.getId().toString(), false);
        }
    }

    private void setTextNumberAfterMainOrgChanged() {
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (storageOrgUnit != null) {
            this.setNumberTextStatus(storageOrgUnit.getId().toString(), true);
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    private RuleStatus getRuleStatusByStoageOrgUnit(IObjectValue bizObject, String storageOrgUnitId) throws BOSException, EASBizException {
        RuleStatus ruleStatus = (RuleStatus)this.RULE_STATUS_CACHE.get(storageOrgUnitId);
        if (ruleStatus != null) {
            return ruleStatus;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        RuleStatus status = codingRuleManager.getRuleStatus(bizObject, storageOrgUnitId);
        this.RULE_STATUS_CACHE.put(storageOrgUnitId, status);
        return status;
    }

    private void setNumberTextStatus(String orgId, boolean isMainOrgChanged) {
        RuleStatus ruleStatus = null;
        IObjectValue bizObject = this.getDataObject();
        try {
            if ("ADDNEW".equals(this.getOprtState()) || isMainOrgChanged) {
                Object[] retValues = ResourceFactory.getRemoteInstance().getNumberValue(bizObject, orgId);
                ruleStatus = (RuleStatus)retValues[0];
                if (ruleStatus != null) {
                    if (ruleStatus.isExist()) {
                        if (ruleStatus.isAddView()) {
                            String newNum = (String)retValues[1];
                            this.txtNumber.setText(newNum);
                            this.editData.setNumber(newNum);
                        } else {
                            this.txtNumber.setText(null);
                            this.editData.setNumber(null);
                        }
                    } else {
                        this.txtNumber.setText(null);
                        this.editData.setNumber(null);
                    }
                } else {
                    this.txtNumber.setText(null);
                    this.editData.setNumber(null);
                }
            } else {
                ruleStatus = this.getRuleStatusByStoageOrgUnit(bizObject, orgId);
            }
            if (ruleStatus != null && ruleStatus.isExist()) {
                if (ruleStatus.isModifiable()) {
                    if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
                        this.txtNumber.setEditable(false);
                        this.txtNumber.setAccessAuthority(1);
                    } else {
                        this.txtNumber.setAccessAuthority(0);
                        this.txtNumber.setEditable(true);
                        this.txtNumber.setEnabled(true);
                        this.txtNumber.requestFocus();
                    }
                } else {
                    this.txtNumber.setEditable(false);
                    this.txtNumber.setAccessAuthority(1);
                }
            } else if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
                this.txtNumber.setEditable(false);
                this.txtNumber.setAccessAuthority(1);
            } else {
                this.txtNumber.setAccessAuthority(0);
                this.txtNumber.setEditable(true);
                this.txtNumber.setEnabled(true);
                this.txtNumber.requestFocus();
            }
        }
        catch (EASBizException exc) {
            this.handleException((Exception)((Object)exc));
        }
        catch (BOSException exc) {
            this.handleException((Exception)((Object)exc));
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK user = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK storage = new ObjectUuidPK(SysContext.getSysContext().getCurrentStorageUnit().getId());
        PermissionHelper.checkFunctionPermission((IObjectPK)user, (IObjectPK)storage, (String)"mm_resource_addnew");
        this.setEntryButtonEnable();
        this.editData.setIsMainResource(false);
        this.initOldData((IObjectValue)this.editData);
        super.actionCopy_actionPerformed(e);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        ResourceEntryCollection reCol;
        super.setFieldsNull(arg0);
        ResourceInfo info = (ResourceInfo)arg0;
        if (null != info.getStatus() && info.getStatus() == BDStatusEnum.APPROVE) {
            info.setStatus(BDStatusEnum.UNAPPROVE);
        }
        if (null != (reCol = info.getEntries()) && reCol.size() > 0) {
            for (int i = reCol.size(); i > 0; --i) {
                reCol.removeObject(reCol.size() - 1);
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (BDStatusEnum.APPROVE.equals((Object)this.editData.getStatus())) {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            this.setOprtState("VIEW");
            this.lockUIForViewStatus();
            this.setEntryButtonEnable();
            AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"ResourceQueryF7WindowTitle"));
        }
        this.editData.setSyncOldValue(true);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            int total = this.getPeopleDeviceQty();
            String resourceNumber = this.editData.getId().toString();
            ResourceFactory.getRemoteInstance().updateTotalQty(total, resourceNumber);
        }
    }

    private void setCostCenterF7(StorageOrgUnitInfo storageOrgInfo) {
        if (storageOrgInfo != null && storageOrgInfo.getId() != null) {
            MMUtils.initCostCenterF7((HashMap)this.costCenter, (String)storageOrgInfo.getId().toString(), (KDBizPromptBox)this.prmtCostCenterOrgUnit);
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        ResourceEntryInfo reInfo = new ResourceEntryInfo();
        return reInfo;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.insertLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
            if (this.getDetailTable().getRowCount() == 0) {
                FocusTraversalPolicy policy = null;
                Object container = null;
                Component initComponent = null;
                if (this.getFocusTraversalPolicy() != null && this.getFocusTraversalPolicy() instanceof UIFocusTraversalPolicy) {
                    policy = this.getFocusTraversalPolicy();
                    container = this;
                    Component[] traverComponent = ((UIFocusTraversalPolicy)policy).getComponents();
                    for (int i = 0; i < traverComponent.length; ++i) {
                        if (traverComponent[i] != this.getDetailTable()) continue;
                        initComponent = traverComponent[i];
                        break;
                    }
                    if (initComponent == null) {
                        initComponent = policy.getLastComponent((Container)container);
                        initComponent.requestFocusInWindow();
                    } else if (initComponent != null) {
                        Component component = policy.getComponentBefore((Container)container, initComponent);
                        while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                            component = policy.getComponentBefore((Container)container, component);
                        }
                        component.requestFocusInWindow();
                    }
                } else if (policy == null) {
                    if (this.getUIWindow() instanceof Dialog) {
                        policy = ((Dialog)this.uiWindow).getFocusTraversalPolicy();
                        container = (Dialog)this.uiWindow;
                    } else if (this.getUIWindow() instanceof Window) {
                        policy = ((Window)this.uiWindow).getFocusTraversalPolicy();
                        container = (Window)this.uiWindow;
                    }
                    if (policy != null) {
                        try {
                            Component component = policy.getComponentBefore((Container)container, (Component)this.getDetailTable());
                            while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                                component = policy.getComponentBefore((Container)container, component);
                            }
                            component.requestFocusInWindow();
                        }
                        catch (Exception exc) {
                            this.handleException(exc);
                        }
                    }
                }
            }
        }
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = table.addRow();
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    private void setFeeRatePrecision() {
        if (this.prmtstorageOrgUnit.getValue() != null) {
            StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
            String orgId = storageOrgUnit.getId().toString();
            CurrencyInfo baseCurrInfo = MMUtils.getBaseCurrencyByCompanyOrg((String)orgId);
            this.precision = baseCurrInfo.getPrecision();
        }
        this.txtFeeRate.setPrecision(this.precision);
    }

    private void setMeasureUnitStatus() {
        BigDecimal bdFeeRate = this.getFeeRate();
        if (this.zeroBigDecimal.compareTo(bdFeeRate) == 0) {
            this.prmtMeasureUnit.setRequired(false);
        } else {
            this.prmtMeasureUnit.setRequired(true);
        }
    }

    private BigDecimal getFeeRate() {
        Number feeRate = this.txtFeeRate.getNumberValue();
        BigDecimal bdFeeRate = null;
        bdFeeRate = feeRate == null ? this.zeroBigDecimal : new BigDecimal(feeRate.toString());
        return bdFeeRate;
    }

    public static String getMessage(String key) {
        return EASResource.getString((String)RESOURCE_PATH, (String)key);
    }

    public void afterInsertOperation() {
        int count = this.kdtEntries.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            Object value = row.getCell(TB_NUMBER).getValue();
            ResourceEntryInfo entry = this.editData.getEntries().get(i);
            if (value == null) {
                row.getCell(TB_NAME).setValue(null);
                if (entry == null) continue;
                entry.setNumber(null);
                continue;
            }
            if (value.getClass().isArray()) {
                int size = Array.getLength(value);
                EquipmentArchivesInfo eai = null;
                if (size > 0) {
                    eai = (EquipmentArchivesInfo)Array.get(value, 0);
                }
                String name = null;
                String number = null;
                if (eai != null) {
                    name = eai.getName();
                    number = eai.getNumber();
                }
                row.getCell(TB_NAME).setValue((Object)name);
                if (entry == null) continue;
                entry.setNumber(number);
                continue;
            }
            EquipmentArchivesInfo eai = (EquipmentArchivesInfo)value;
            row.getCell(TB_NAME).setValue((Object)eai.getName());
            if (entry == null) continue;
            entry.setNumber(eai.getNumber());
        }
    }

    public void afterInsertOperation(IObjectValue objValue, int rowIndex) {
    }

    private void registerEquipmentF7() {
        String queryInfo = "com.kingdee.eas.mm.basedata.app.ResourceEquipmentQuery";
        this.numberBox = this.mulSelectHelper.registerF7ToColumn(TB_NUMBER, queryInfo);
        ResourceEquipmentProcessor processor = new ResourceEquipmentProcessor(this.prmtstorageOrgUnit, this.numberBox, this.prmtworkshop);
        this.numberBox.setSelector((KDPromptSelector)processor);
        this.numberBox.setCommitParser((IParser)processor);
        this.numberBox.setEditFormat("$number$");
        this.numberBox.setCommitFormat("$number$");
        this.numberBox.setDisplayFormat("$number$");
        KDTDefaultCellEditor resourceF7 = new KDTDefaultCellEditor((IKDEditor)this.numberBox);
        this.kdtEntries.getColumn(TB_NUMBER).setEditor((ICellEditor)resourceF7);
        ObjectValueRender ovr = new ObjectValueRender();
        ovr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(TB_NUMBER).setRenderer((IBasicRender)ovr);
    }

    private void filterEquipmentF7() {
        StorageOrgUnitInfo orgUnit = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String orgUnitId = orgUnit.getId().toString();
        FilterItemInfo item = new FilterItemInfo("storageorgunit.id", (Object)orgUnitId, CompareType.EQUALS);
        filter.getFilterItems().add(item);
        item = new FilterItemInfo("resource.number", null, CompareType.IS);
        filter.getFilterItems().add(item);
        ObjectUuidPK pk = new ObjectUuidPK(orgUnit.getId());
        boolean hasEquipModule = true;
        try {
            String paraNumber = "Resource_Catch_EQM";
            String rce = ParamManager.getParamValue(null, (IObjectPK)pk, (String)paraNumber);
            hasEquipModule = Boolean.valueOf(rce);
        }
        catch (EASBizException ex) {
            logger.error((Object)("getParamValue error:" + (Object)((Object)ex)));
        }
        catch (BOSException ex) {
            logger.error((Object)("getParamValue error:" + (Object)((Object)ex)));
        }
        Integer status = null;
        if (hasEquipModule) {
            status = new Integer(30);
            item = new FilterItemInfo("billstatus", (Object)status, CompareType.EQUALS);
            filter.getFilterItems().add(item);
            item = new FilterItemInfo("initial", (Object)Boolean.TRUE, CompareType.EQUALS);
            filter.getFilterItems().add(item);
        } else {
            status = new Integer(10);
            item = new FilterItemInfo("billstatus", (Object)status, CompareType.EQUALS);
            filter.getFilterItems().add(item);
        }
        view.setFilter(filter);
        this.setEquipSort(view);
        this.numberBox.setCurrentCtrlUnit(orgUnit.getCU());
        this.numberBox.setEntityViewInfo(view);
        QueryAgent agent = this.numberBox.getQueryAgent();
        agent.setHasCUDefaultFilter(false);
        agent.resetRuntimeEntityView();
    }

    private int getPeopleDeviceQty() throws BOSException {
        int peopleDeviceQty = 0;
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.resourceType.getSelectedItem().equals((Object)ResourceTypeEnum.Equipment)) {
            peopleDeviceQty = this.kdtEntries.getRowCount();
        } else {
            for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                Object value = this.kdtEntries.getRow(i).getCell(TB_HRTYPE).getValue();
                if (HumanResourceTypeEnum.PERSONNEL.equals((Object)((HumanResourceTypeEnum)((Object)value)))) {
                    ++peopleDeviceQty;
                    continue;
                }
                list.add(this.kdtEntries.getRow(i).getCell(TB_NUMBER).getValue());
            }
            if (!list.isEmpty()) {
                peopleDeviceQty += ResourceFactory.getRemoteInstance().getTotalQty(list);
            }
        }
        return peopleDeviceQty;
    }

    private void setEquipSort(EntityViewInfo view) {
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo(TB_NUMBER);
        item.setSortType(SortType.ASCEND);
        sortCol.add(item);
        view.setSorter(sortCol);
    }

    private void initEntryKeyListener(boolean isAutoAddLine) {
        AbstractAction entryAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String state = ResourceEditUI.this.getOprtState();
                ResourceEditUI.this.kdtEntries.removeRow(ResourceEditUI.this.kdtEntries.getRowCount() - 1);
                if (state.equals(OprtState.ADDNEW) || state.equals(OprtState.EDIT)) {
                    ResourceEditUI.this.addLine(ResourceEditUI.this.kdtEntries);
                }
            }
        };
        KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntries, (boolean)isAutoAddLine, (Action)entryAction);
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntries, (boolean)isAutoAddLine, (Action)entryAction);
    }

    public void onShow() throws Exception {
        Frame frame1;
        super.onShow();
        IUIWindow uiWindow = this.getUIWindow();
        if (uiWindow instanceof JFrame && (frame1 = (Frame)uiWindow) != null) {
            frame1.setResizable(false);
        }
    }

    private void workShop_change(DataChangeEvent e) {
        AdminOrgUnitInfo newValue = (AdminOrgUnitInfo)e.getNewValue();
        AdminOrgUnitInfo oldValue = (AdminOrgUnitInfo)e.getOldValue();
        if ((newValue == null && oldValue != null || newValue != null && oldValue == null || newValue != null && oldValue != null && !newValue.getNumber().toString().equals(oldValue.getNumber().toString())) && ResourceTypeEnum.PERSONNEL == this.resourceType.getSelectedItem()) {
            for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                if (this.kdtEntries.getRow(i).getCell(TB_HRTYPE).getValue() == null || !this.kdtEntries.getRow(i).getCell(TB_HRTYPE).getValue().equals((Object)HumanResourceTypeEnum.PERSONNEL)) continue;
                this.buildPersonCell(i, (AdminOrgUnitInfo)this.prmtworkshop.getValue());
            }
        }
    }
}

