/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.mm.basedata.IResourceEntry;
import com.kingdee.eas.mm.basedata.ResourceEntryFactory;
import com.kingdee.eas.mm.basedata.ResourceEquipment;
import com.kingdee.eas.mm.basedata.client.AbstractResourceEquipmentEditUI;
import com.kingdee.eas.mm.basedata.client.ResourceEditUI;
import com.kingdee.eas.mm.basedata.client.ResourceEquipmentSelectUI;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class ResourceEquipmentEditUI
extends AbstractResourceEquipmentEditUI {
    private static final long serialVersionUID = 3685450253831622053L;
    private static final String TB_ID = "id";
    private static final String TB_NUMBER = "number";
    private static final String TB_NAME = "name";
    private static final String TB_ORGUNITID = "orgUnitId";
    private static final String TB_ORGUNITNAME = "orgUnitName";
    private StorageOrgUnitInfo orgUnitInfo = null;
    private AdminOrgUnitInfo usingDeptInfo = null;
    private String status = null;
    private List oldList = null;
    private ResourceEquipmentSelectUI parentUI = null;
    private boolean isSaveClose = false;
    private List errorList = null;

    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        String status = uiContext.get("status").toString();
        this.parentUI = (ResourceEquipmentSelectUI)((Object)uiContext.get("ParentWin"));
        this.status = status;
        Object obj = uiContext.get("storageOrgUnit");
        this.orgUnitInfo = (StorageOrgUnitInfo)obj;
        this.usingDeptInfo = (AdminOrgUnitInfo)uiContext.get("workShop");
        this.init();
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Delete");
        obj = uiContext.get("optList");
        if (obj != null) {
            this.oldList = (List)obj;
            ResourceEquipment re = null;
            IRow row = null;
            for (int i = 0; i < this.oldList.size(); ++i) {
                re = (ResourceEquipment)this.oldList.get(i);
                row = this.tblMain.addRow(i);
                this.fillDataToTable(row, re);
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return false;
        }
        boolean rst = false;
        if (this.isSaveClose) {
            rst = true;
        } else {
            List newList = this.getResourceEquipmentList();
            if (!this.isChanged(newList, this.oldList)) {
                rst = true;
            } else {
                String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
                int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
                if (result == 0) {
                    try {
                        this.actionSave.setDaemonRun(false);
                        ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                        UtilRequest.setPrepare((boolean)false);
                        this.actionSave.actionPerformed(event);
                        boolean bl = rst = !this.actionSave.isInvokeFailed();
                        if (this.errorList != null && this.errorList.size() > 0) {
                            rst = false;
                        }
                    }
                    catch (Exception exc) {
                        this.handUIException(exc);
                    }
                } else {
                    rst = result == 1;
                }
            }
        }
        try {
            this.parentUI.refresh();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return rst;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getEditManager().stopEditing();
        int num = this.tblMain.getRowCount();
        if (num < 1) {
            String msg = ResourceEditUI.getMessage("no_information");
            MsgBox.showInfo((String)msg);
            return;
        }
        List list = this.getResourceEquipmentList();
        StringBuffer buff = new StringBuffer();
        if ("ADDNEW".equals(this.status)) {
            this.errorList = this.getBizInterface().addnewEquipment(list);
            buff.append(ResourceEditUI.getMessage("addNew_error"));
        } else if ("EDIT".equals(this.status)) {
            if (!this.isChanged(list, this.oldList)) {
                return;
            }
            this.errorList = this.getBizInterface().editEquipment(list);
            buff.append(ResourceEditUI.getMessage("edit_error"));
        }
        if (this.errorList == null || this.errorList.size() == 0) {
            this.isSaveClose = true;
            this.uiWindow.close();
            return;
        }
        StringBuffer msg = new StringBuffer();
        String[] strs = null;
        for (int i = 0; i < this.errorList.size(); ++i) {
            strs = (String[])this.errorList.get(i);
            msg.append(strs[2]).append("\n");
        }
        MsgBox.showDetailAndOK((Component)((Object)this), (String)buff.toString(), (String)msg.toString(), (int)8188);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(true);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(false);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            return;
        }
        int[] selectedRow = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = selectedRow.length - 1; i >= 0; --i) {
            this.tblMain.removeRow(selectedRow[i]);
        }
    }

    private void addLine(boolean isAdd) {
        IRow row = this.getAddLineRow(isAdd);
        ResourceEquipment ea = this.createData();
        this.fillDataToTable(row, ea);
    }

    private void fillDataToTable(IRow row, ResourceEquipment re) {
        if (re == null) {
            return;
        }
        row.getCell(TB_ID).setValue((Object)re.getId());
        row.getCell(TB_NUMBER).setValue((Object)re.getNumber());
        row.getCell(TB_NAME).setValue((Object)re.getName());
        row.getCell(TB_ORGUNITID).setValue((Object)re.getOrgUnitId());
        row.getCell(TB_ORGUNITNAME).setValue((Object)re.getOrgUnitName());
    }

    private void init() {
        this.btnSave.setEnabled(true);
        this.tblMain.checkParsed();
        IColumn numberCol = this.tblMain.getColumn(TB_NUMBER);
        KDTextField numField = new KDTextField();
        numField.setMaxLength(80);
        numberCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numField));
        IColumn nameCol = this.tblMain.getColumn(TB_NAME);
        KDBizMultiLangBox nameField = new KDBizMultiLangBox();
        nameField.setMaxLength(255);
        String language = LocaleUtils.getDefaultLocale().getLanguage();
        int count = nameField.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!((MultiLangItem)nameField.getItemAt(i)).getLang().getLocale().getLanguage().equalsIgnoreCase(language)) continue;
            nameField.setSelectedIndex(i);
        }
        nameCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)nameField));
        if ("ADDNEW".equals(this.status)) {
            this.btnAddLine.setEnabled(true);
            this.btnAddLine.setVisible(true);
            this.btnInsertLine.setEnabled(true);
            this.btnInsertLine.setVisible(true);
            this.btnRemoveLine.setEnabled(true);
            this.btnRemoveLine.setVisible(true);
            numberCol.getStyleAttributes().setLocked(false);
            nameCol.getStyleAttributes().setLocked(false);
            this.initEntryKeyListener(true);
            this.addLine(true);
            this.oldList = this.getResourceEquipmentList();
        } else if ("EDIT".equals(this.status)) {
            this.btnAddLine.setEnabled(false);
            this.btnAddLine.setVisible(false);
            this.btnInsertLine.setEnabled(false);
            this.btnInsertLine.setVisible(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnRemoveLine.setVisible(false);
            numberCol.getStyleAttributes().setLocked(true);
            nameCol.getStyleAttributes().setLocked(false);
            this.initEntryKeyListener(false);
        }
    }

    private ResourceEquipment createData() {
        ResourceEquipment re = new ResourceEquipment();
        re.setOrgUnitId(this.orgUnitInfo.getId().toString());
        re.setOrgUnitName(this.orgUnitInfo.getName());
        re.setUsingdept(this.usingDeptInfo == null ? null : (this.usingDeptInfo.getId() == null ? null : this.usingDeptInfo.getId().toString()));
        return re;
    }

    private IRow getAddLineRow(boolean isAdd) {
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        if (isAdd || index < 0) {
            index = this.tblMain.getRowCount();
        }
        return this.tblMain.addRow(index);
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private ResourceEquipment getResourceEquipment(IRow row) {
        ResourceEquipment re = new ResourceEquipment(false);
        Object obj = row.getCell(TB_ID).getValue();
        re.setId(obj.toString());
        obj = row.getCell(TB_NUMBER).getValue();
        if (obj != null) {
            re.setNumber(obj.toString());
        }
        if ((obj = row.getCell(TB_NAME).getValue()) != null) {
            re.setName(obj.toString());
        }
        if ((obj = row.getCell(TB_ORGUNITID).getValue()) != null) {
            re.setOrgUnitId(obj.toString());
        }
        if ((obj = row.getCell(TB_ORGUNITNAME).getValue()) != null) {
            re.setOrgUnitName(obj.toString());
        }
        return re;
    }

    private List getResourceEquipmentList() {
        this.tblMain.getEditManager().stopEditing();
        int num = this.tblMain.getRowCount();
        if (num < 1) {
            return null;
        }
        IRow row = null;
        ArrayList<ResourceEquipment> list = new ArrayList<ResourceEquipment>();
        ResourceEquipment re = null;
        for (int i = 0; i < num; ++i) {
            row = this.tblMain.getRow(i);
            re = this.getResourceEquipment(row);
            re.setOrgCuId(this.orgUnitInfo.getCU().getId().toString());
            if (this.usingDeptInfo != null) {
                re.setUsingdept(this.usingDeptInfo.getId().toString());
            } else {
                re.setUsingdept(null);
            }
            list.add(re);
        }
        return list;
    }

    private boolean isChanged(List newList, List oldList) {
        if (newList == null && oldList == null) {
            return false;
        }
        if (newList == null && oldList != null || newList != null && oldList == null) {
            return true;
        }
        if (newList.size() != oldList.size()) {
            return true;
        }
        ResourceEquipment newRe = null;
        ResourceEquipment oldRe = null;
        String newNumber = null;
        String newName = null;
        String oldNumber = null;
        String oldName = null;
        for (int i = 0; i < newList.size(); ++i) {
            newRe = (ResourceEquipment)newList.get(i);
            oldRe = (ResourceEquipment)oldList.get(i);
            newNumber = newRe.getNumber();
            newName = newRe.getName();
            oldNumber = oldRe.getNumber();
            oldName = oldRe.getName();
            if (MMUtils.isEmptyString((String)newNumber)) {
                newNumber = "";
            }
            if (MMUtils.isEmptyString((String)newName)) {
                newName = "";
            }
            if (MMUtils.isEmptyString((String)oldNumber)) {
                oldNumber = "";
            }
            if (MMUtils.isEmptyString((String)oldName)) {
                oldName = "";
            }
            if (newNumber.equals(newNumber) && newName.equals(oldName)) continue;
            return true;
        }
        return false;
    }

    private void initEntryKeyListener(boolean isAutoAddLine) {
        AbstractAction entryAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceEquipmentEditUI.this.tblMain.removeRow(ResourceEquipmentEditUI.this.tblMain.getRowCount() - 1);
                ResourceEquipmentEditUI.this.addLine(true);
            }
        };
        KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)isAutoAddLine, (Action)entryAction);
        KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)isAutoAddLine, (Action)entryAction);
    }

    private IResourceEntry getBizInterface() throws BOSException {
        return ResourceEntryFactory.getRemoteInstance();
    }
}

