/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.mm.basedata.ResourceEntryFactory;
import com.kingdee.eas.mm.basedata.ResourceEquipment;
import com.kingdee.eas.mm.basedata.client.ResourceEditUI;
import com.kingdee.eas.mm.basedata.client.ResourceEquipmentEditUI;
import com.kingdee.eas.mm.basedata.client.ResourceEquipmentProcessor;
import com.kingdee.eas.mm.common.client.F7CustomProcessor;
import com.kingdee.eas.mm.common.client.F7CustomSelectUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ResourceEquipmentSelectUI
extends F7CustomSelectUI {
    private static final long serialVersionUID = -3660575420315575956L;
    private static Logger logger = Logger.getLogger(ResourceEquipmentSelectUI.class);
    private KDWorkButton btnAddNew = null;
    private KDWorkButton btnEdit = null;
    private KDWorkButton btnRemove = null;
    private static final String TB_ISCHECKED = "isChecked";
    private static final String TB_ID = "id";
    private static final String TB_NUMBER = "number";
    private static final String TB_NAME = "name";
    private static final String TB_ORGUNITID = "storageOrgUnit.id";
    private static final String TB_ORGUNITNAME = "storageOrgUnit.name";
    private static final String TB_RESOURCE_NUMBER = "resource.number";
    private static final String TB_RESOURCE_NAME = "resource.name";
    private static final String EQUIP_BILLSTATUS = "billstatus";
    private static final String EQUIP_INITIAL = "initial";
    private static final String KDCHECKBOX_NAME = "chkshowAllEquip";
    ResourceEquipmentProcessor processor = null;
    StorageOrgUnitInfo orgUnitInfo = null;
    AdminOrgUnitInfo workShop = null;
    private EntityViewInfo viewCache = null;

    public ResourceEquipmentSelectUI(Dialog owner, KDBizPromptBox bizPromtBox, ResourceEquipmentProcessor processor) {
        super(owner, bizPromtBox, (F7CustomProcessor)processor);
        this.processor = processor;
        this.orgUnitInfo = processor.getStorageOrgUnitInfo();
        this.setCustomizeButtonStatus();
    }

    public ResourceEquipmentSelectUI(Dialog owner, KDBizPromptBox bizPromtBox, ResourceEquipmentProcessor processor, String input) {
        super(owner, null, bizPromtBox, (F7CustomProcessor)processor);
        this.processor = processor;
        this.orgUnitInfo = processor.getStorageOrgUnitInfo();
        this.setCustomizeButtonStatus();
    }

    public ResourceEquipmentSelectUI(KDBizPromptBox bizPromtBox, ResourceEquipmentProcessor processor, String input) {
        super((Frame)null, bizPromtBox, (F7CustomProcessor)processor);
        this.processor = processor;
        this.orgUnitInfo = processor.getStorageOrgUnitInfo();
        this.setCustomizeButtonStatus();
    }

    public ResourceEquipmentSelectUI(Frame owner, KDBizPromptBox bizPromtBox, ResourceEquipmentProcessor processor, String input) {
        super(owner, null, bizPromtBox, (F7CustomProcessor)processor);
        this.processor = processor;
        this.orgUnitInfo = processor.getStorageOrgUnitInfo();
        this.workShop = processor.getAdminOrgUnitInfo();
        this.setCustomizeButtonStatus();
    }

    protected String getKeyFieldName() {
        return TB_ID;
    }

    protected Object buildReturnValue() {
        int num = KDTableUtil.getSelectedRowCount((KDTable)this.table);
        if (num < 1) {
            return null;
        }
        int[] selectedRow = KDTableUtil.getSelectedRows((KDTable)this.table);
        ArrayList<EquipmentArchivesInfo> datas = new ArrayList<EquipmentArchivesInfo>();
        EquipmentArchivesInfo info = null;
        IRow row = null;
        Object obj = null;
        for (int i = 0; i < selectedRow.length; ++i) {
            row = this.table.getRow(selectedRow[i]);
            obj = row.getCell(TB_ID).getValue();
            info = new EquipmentArchivesInfo();
            info.setId(BOSUuid.read((String)obj.toString()));
            obj = row.getCell(TB_NUMBER).getValue();
            if (obj != null) {
                info.setNumber(obj.toString());
            }
            if ((obj = row.getCell(TB_NAME).getValue()) != null) {
                info.setName(obj.toString());
            }
            datas.add(info);
        }
        Object ret = datas.toArray();
        if (!this.isEnabledMultipleSelect()) {
            if (ret != DEFAULTVALUE) {
                Object[] d;
                ret = ret == BADVALUE ? null : ((d = ret) != null && d.length > 0 ? d[0] : null);
            }
        } else if (ret != DEFAULTVALUE) {
            if (ret == BADVALUE) {
                ret = null;
            } else {
                Object[] d = ret;
                if (d == null || d.length <= 0) {
                    ret = null;
                }
            }
        }
        return ret;
    }

    public void kdtable_afterDataFill(KDTDataRequestEvent e) {
        int num = this.table.getRowCount();
        IRow row = null;
        Object obj = null;
        this.table.getColumn(TB_ISCHECKED).getStyleAttributes().setLocked(true);
        for (int i = 0; i < num; ++i) {
            row = this.table.getRow(i);
            obj = row.getCell(TB_RESOURCE_NUMBER).getValue();
            if (obj == null) {
                row.getCell(TB_ISCHECKED).setValue((Object)Boolean.FALSE);
                continue;
            }
            row.getCell(TB_ISCHECKED).setValue((Object)Boolean.TRUE);
        }
        KDCheckBox box = this.getShowEquipCheckBox();
        if (!box.isSelected()) {
            this.isHideColumn(true);
        }
    }

    protected void btnOK_actionPerformed(ActionEvent e) {
        if (this.checkRefEquipment()) {
            return;
        }
        super.btnOK_actionPerformed(e);
    }

    protected KDPanel getPanelForQuickFilterComponents() {
        super.getPanelForQuickFilterComponents();
        KDCheckBox chkShowAllEqui = new KDCheckBox();
        chkShowAllEqui.setName(KDCHECKBOX_NAME);
        chkShowAllEqui.setSelected(false);
        chkShowAllEqui.setBounds(new Rectangle(445, 10, 100, 19));
        chkShowAllEqui.setText(ResourceEditUI.getMessage("showAllEquiCheckBoxName"));
        chkShowAllEqui.setVisible(true);
        chkShowAllEqui.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceEquipmentSelectUI.this.chkShowAllEquiAction(e);
            }
        });
        this.quickFilterPanel.add((Component)chkShowAllEqui, null);
        return this.quickFilterPanel;
    }

    public void show() {
        KDCheckBox box = this.getShowEquipCheckBox();
        box.setSelected(false);
        super.show();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"status", (Object)"ADDNEW");
        uiContext.put((Object)"storageOrgUnit", (Object)this.orgUnitInfo);
        uiContext.put((Object)"workShop", (Object)this.workShop);
        uiContext.put((Object)"ParentWin", (Object)this);
        this.showEditUI((Map)uiContext);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<ResourceEquipment> list = new ArrayList<ResourceEquipment>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.table);
        IRow row = null;
        ResourceEquipment re = null;
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.table.getRow(selectRows[i]);
            re = this.getResourceEquipment(row);
            list.add(re);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"status", (Object)"EDIT");
        uiContext.put((Object)"storageOrgUnit", (Object)this.orgUnitInfo);
        uiContext.put((Object)"optList", list);
        uiContext.put((Object)"ParentWin", (Object)this);
        this.showEditUI((Map)uiContext);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            return;
        }
        int[] selectedRow = KDTableUtil.getSelectedRows((KDTable)this.table);
        if (selectedRow != null && selectedRow.length > 0) {
            String[] ids = new String[selectedRow.length];
            for (int i = 0; i < selectedRow.length; ++i) {
                ids[i] = this.table.getCell(selectedRow[i], TB_ID).getValue().toString();
            }
            List rst = ResourceEntryFactory.getRemoteInstance().removeEquipment(ids);
            if (rst != null && rst.size() > 0) {
                int totalNum = ids.length;
                int errorNum = rst.size();
                int succeNum = totalNum - errorNum;
                StringBuffer buff = new StringBuffer();
                buff.append(ResourceEditUI.getMessage("success")).append(succeNum);
                buff.append(ResourceEditUI.getMessage("numberUnit"));
                buff.append(ResourceEditUI.getMessage("fail")).append(errorNum);
                buff.append(ResourceEditUI.getMessage("numberUnit"));
                StringBuffer msg = new StringBuffer();
                String[] strs = null;
                for (int i = 0; i < rst.size(); ++i) {
                    strs = (String[])rst.get(i);
                    msg.append(strs[2]).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)buff.toString(), (String)msg.toString(), (int)8188);
            }
        }
        this.refreshData(true);
    }

    private void showEditUI(Map uiContext) throws UIException {
        String uiName = ResourceEquipmentEditUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public void checkSelected() {
        if (this.table.getRowCount() == 0 || this.table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private ResourceEquipment getResourceEquipment(IRow row) {
        ResourceEquipment re = new ResourceEquipment(false);
        Object obj = row.getCell(TB_ID).getValue();
        re.setId(obj.toString());
        obj = row.getCell(TB_NUMBER).getValue();
        re.setNumber(obj.toString());
        obj = row.getCell(TB_NAME).getValue();
        re.setName(obj.toString());
        obj = row.getCell(TB_ORGUNITID).getValue();
        re.setOrgUnitId(obj.toString());
        obj = row.getCell(TB_ORGUNITNAME).getValue();
        re.setOrgUnitName(obj.toString());
        return re;
    }

    private boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private boolean checkRefEquipment() {
        int selectedNum = KDTableUtil.getSelectedRowCount((KDTable)this.table);
        if (selectedNum < 1) {
            return false;
        }
        int[] selectedRow = KDTableUtil.getSelectedRows((KDTable)this.table);
        ICell cell = null;
        Object obj = null;
        boolean isChecked = false;
        for (int i = 0; i < selectedRow.length; ++i) {
            cell = this.table.getRow(selectedRow[i]).getCell(TB_ISCHECKED);
            obj = cell.getValue();
            isChecked = Boolean.valueOf(obj.toString());
            if (!isChecked) continue;
            isChecked = true;
            break;
        }
        if (isChecked) {
            String msg = ResourceEditUI.getMessage("not_user_ref_equipment");
            MsgBox.showInfo((String)msg);
        }
        return isChecked;
    }

    private void setCustomizeButtonStatus() {
        ObjectUuidPK pk = new ObjectUuidPK(this.orgUnitInfo.getId());
        boolean hasEquipModule = true;
        try {
            String paraNumber = "Resource_Catch_EQM";
            String rce = ParamManager.getParamValue(null, (IObjectPK)pk, (String)paraNumber);
            hasEquipModule = Boolean.valueOf(rce);
        }
        catch (EASBizException ex) {
            logger.error((Object)("getParamValue error:" + (Object)((Object)ex)));
        }
        catch (BOSException ex) {
            logger.error((Object)("getParamValue error:" + (Object)((Object)ex)));
        }
        if (hasEquipModule) {
            return;
        }
        this.btnAddNew = new KDWorkButton();
        this.btnEdit = new KDWorkButton();
        this.btnRemove = new KDWorkButton();
        this.btnAddNew.setText(ResourceEditUI.getMessage("addNew_text"));
        this.btnAddNew.setToolTipText(ResourceEditUI.getMessage("addNew_text"));
        this.btnEdit.setText(ResourceEditUI.getMessage("edit_text"));
        this.btnEdit.setToolTipText(ResourceEditUI.getMessage("edit_text"));
        this.btnRemove.setText(ResourceEditUI.getMessage("remove_text"));
        this.btnRemove.setToolTipText(ResourceEditUI.getMessage("remove_text"));
        Icon icon = EASResource.getIcon((String)"imgTbtn_new");
        this.btnAddNew.setIcon(icon);
        icon = EASResource.getIcon((String)"imgTbtn_edit");
        this.btnEdit.setIcon(icon);
        icon = EASResource.getIcon((String)"imgTbtn_delete");
        this.btnRemove.setIcon(icon);
        this.btnAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ResourceEquipmentSelectUI.this.actionAddNew_actionPerformed(e);
                }
                catch (Exception ex) {
                    logger.error((Object)("add new equipment error:" + ex));
                }
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ResourceEquipmentSelectUI.this.actionEdit_actionPerformed(e);
                }
                catch (Exception ex) {
                    logger.error((Object)("edit new equipment error:" + ex));
                }
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ResourceEquipmentSelectUI.this.actionRemove_actionPerformed(e);
                }
                catch (Exception ex) {
                    logger.error((Object)("remove new equipment error:" + ex));
                }
            }
        });
        this.tb.add((Component)this.btnAddNew, 3);
        this.tb.add((Component)this.btnEdit, 4);
        this.tb.add((Component)this.btnRemove, 5);
    }

    private void chkShowAllEquiAction(ActionEvent e) {
        KDCheckBox box = (KDCheckBox)e.getSource();
        boolean isSelected = box.isSelected();
        EntityViewInfo view = null;
        if (isSelected) {
            this.isHideColumn(false);
            if (this.viewCache == null) {
                this.viewCache = this.createCacheEntityViewInfo();
            }
            view = this.viewCache;
        } else {
            this.isHideColumn(true);
            FilterItemInfo item = new FilterItemInfo(TB_RESOURCE_NUMBER, null, CompareType.IS);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(item);
            view = (EntityViewInfo)this.viewCache.clone();
            try {
                view.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException ex) {
                logger.error((Object)("merge filter error:" + (Object)((Object)ex)));
            }
        }
        this.setEntityViewInfo(view);
        this.table.removeRows();
    }

    private void isHideColumn(boolean isHide) {
        this.table.getColumn(TB_ISCHECKED).getStyleAttributes().setHided(isHide);
        this.table.getColumn(TB_RESOURCE_NUMBER).getStyleAttributes().setHided(isHide);
        this.table.getColumn(TB_RESOURCE_NAME).getStyleAttributes().setHided(isHide);
    }

    public EntityViewInfo createCacheEntityViewInfo() {
        EntityViewInfo view = this.getEntityViewInfo();
        FilterItemCollection itemColl = view.getFilter().getFilterItems();
        FilterItemInfo itemInfo = null;
        EntityViewInfo newView = new EntityViewInfo();
        FilterInfo newFilter = new FilterInfo();
        FilterItemInfo item = null;
        String propertyName = null;
        String propertyValue = null;
        Object obj = null;
        for (int j = 0; j < itemColl.size(); ++j) {
            itemInfo = itemColl.get(j);
            if (itemInfo == null) continue;
            propertyName = itemInfo.getPropertyName();
            obj = itemInfo.getCompareValue();
            if (obj == null) continue;
            propertyValue = obj.toString();
            if (TB_ORGUNITID.equalsIgnoreCase(propertyName)) {
                item = new FilterItemInfo(TB_ORGUNITID, (Object)propertyValue, CompareType.EQUALS);
                newFilter.getFilterItems().add(item);
                continue;
            }
            if (EQUIP_BILLSTATUS.equalsIgnoreCase(propertyName)) {
                item = new FilterItemInfo(EQUIP_BILLSTATUS, (Object)new Integer(propertyValue), CompareType.EQUALS);
                newFilter.getFilterItems().add(item);
                continue;
            }
            if (!EQUIP_INITIAL.equalsIgnoreCase(propertyName)) continue;
            item = new FilterItemInfo(EQUIP_INITIAL, (Object)new Integer(propertyValue), CompareType.EQUALS);
            newFilter.getFilterItems().add(item);
        }
        newView.setFilter(newFilter);
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo(TB_NUMBER);
        sortItem.setSortType(SortType.ASCEND);
        sortCol.add(sortItem);
        newView.setSorter(sortCol);
        return newView;
    }

    private KDCheckBox getShowEquipCheckBox() {
        Component[] com = this.quickFilterPanel.getComponents();
        KDCheckBox box = null;
        for (int i = com.length - 1; !(i < 0 || (box = (KDCheckBox)com[i]) != null && KDCHECKBOX_NAME.equalsIgnoreCase(box.getName())); --i) {
        }
        return box;
    }
}

