/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractTrackNumberDEditUI;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class TrackNumberDEditUI
extends AbstractTrackNumberDEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrackNumberDEditUI.class);
    private String number = null;

    protected IObjectValue createNewData() {
        return new TrackNumberInfo();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.kDTextAreaName.setMaxLength(255);
        this.txtNumber.setMaxLength(80);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrackNumberFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.number = this.editData.getNumber();
        for (int i = 0; i < this.comboStatus.getItemCount(); ++i) {
            MMBasedataStatusEnum basenum = (MMBasedataStatusEnum)this.comboStatus.getItemAt(i);
            if (basenum.equals((Object)MMBasedataStatusEnum.SAVED) || basenum.equals((Object)MMBasedataStatusEnum.CLOSED)) continue;
            this.comboStatus.removeItemAt(i);
            --i;
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtAdminCU;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sele = super.getSelectors();
        sele.add("CU.*");
        return sele;
    }

    protected void showSaveSuccess() {
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0} {1}");
        String messageText = format.format(new Object[]{this.getClassAlise(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK")});
        this.setMessageText(messageText);
        String nextMessageText = format.format(new Object[]{this.getClassAlise(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit")});
        this.setNextMessageText(nextMessageText);
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        String newtxtNumber = this.txtNumber.getText().trim();
        if (newtxtNumber == null || newtxtNumber.trim().length() <= 0) {
            MsgBox.showInfo((String)this.getTrackNumberResource("track_not_null"));
            this.abort();
        }
        if (!newtxtNumber.equals(this.number.trim())) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)newtxtNumber));
            if (this.getBizInterface().exists(filter)) {
                MsgBox.showInfo((String)this.getTrackNumberResource("TRACK_IN_NUMBER"));
                this.abort();
            }
        }
        if (this.prmtTrackNumberGroup.getValue() == null || StringUtil.isEmpty((String)this.prmtTrackNumberGroup.getValue().toString())) {
            MsgBox.showInfo((String)this.getTrackNumberResource("tracknumbergroup_is_null"));
            this.abort();
        }
        this.editData.setSeq(Integer.valueOf(this.txtSeq.getText()).intValue());
        super.actionSave_actionPerformed(e);
    }

    private String getTrackNumberResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)sKey);
    }

    protected boolean isModifySave() {
        return true;
    }
}

