/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberGroupCollection;
import com.kingdee.eas.mm.basedata.TrackNumberGroupFactory;
import com.kingdee.eas.mm.basedata.TrackNumberGroupInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractTrackNumberEditUI;
import com.kingdee.eas.mm.basedata.client.TrackNumberListUI;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.STConverter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TrackNumberEditUI
extends AbstractTrackNumberEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrackNumberEditUI.class);
    private KDTEditAdapter entryTableChange;
    ListUiHelper listUiHelper = null;
    private final String TB_ID = "id";
    private final String TB_NUMBER = "number";
    private final String TB_NAME = "name";
    private final String TB_STATUS = "status";
    private final String TB_ADMINCUID = "adminCU.id";
    private final String TB_ADMINCUNAME = "adminCU.name";
    private final String TB_SEQ = "seq";
    private CtrlUnitInfo curCtrlUnitInfo = null;
    private TrackNumberGroupInfo trackNumberGroupInfo = null;
    private UserInfo userInfo = null;
    private RuleStatus ruleStatus;
    private ICodingRuleManager codingRuleManager;
    private Integer rowId = new Integer(0);
    private ArrayList newRows = new ArrayList();
    private boolean isChanged = false;
    private Map mapOldTrackNo = new HashMap();

    public TrackNumberEditUI() throws Exception {
        this.listUiHelper = new ListUiHelper();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrackNumberFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.setMultiLangBox();
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("currentCtrlUnit");
        this.trackNumberGroupInfo = (TrackNumberGroupInfo)this.getUIContext().get("tracnumberGroup");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
        KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)true, null);
        KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)true);
        this.initTableKeyStroke(this.tblMain, true);
        KDTextField txtnumber = new KDTextField();
        txtnumber.setMaxLength(80);
        this.tblMain.getColumn("number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtnumber));
        this.entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    TrackNumberEditUI.this.kdtEntry_Changed(e);
                }
                catch (Exception exc) {
                    TrackNumberEditUI.this.handUIException(exc);
                }
            }
        };
        this.tblMain.addKDTEditListener((KDTEditListener)this.entryTableChange);
        ObjectValueRender avrNum = new ObjectValueRender();
        avrNum.setFormat((IDataFormat)new BizDataFormat("$name$"));
        KDBizPromptBox prmtOperation = new KDBizPromptBox();
        prmtOperation.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7TrackNumberGroupQuery");
        prmtOperation.setDisplayFormat("$name$");
        prmtOperation.setEditFormat("$number$");
        prmtOperation.setCommitFormat("$number$;$name$");
        if (this.curCtrlUnitInfo != null) {
            FilterInfo filterInfo = this.getDefaultFilterForTree(this.curCtrlUnitInfo);
            EntityViewInfo view = new EntityViewInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.longnumber", (Object)("%!" + this.curCtrlUnitInfo.getNumber()), CompareType.LIKE));
            view.setFilter(filterInfo);
            prmtOperation.setEntityViewInfo(view);
        }
        this.tblMain.getColumn("trackNumberGroup").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtOperation));
        this.tblMain.getColumn("trackNumberGroup").setRenderer((IBasicRender)avrNum);
    }

    protected FilterInfo getDefaultFilterForTree(CtrlUnitInfo cui) {
        FilterInfo fi = null;
        try {
            String cuID = cui.getId().toString();
            String cuLongNumber = cui.getLongNumber();
            fi = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cuID, (String)cuLongNumber);
        }
        catch (Exception e) {
            logger.debug((Object)"Exception:getControlTypeOfTreeEntity()");
        }
        return fi;
    }

    public void kdtEntry_Changed(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.tblMain.getColumnKey(colIndex);
        if ("name".equals(fieldName)) {
            Object obj = e.getValue();
            this.tblMain.getCell(rowIndex, colIndex).setValue(obj);
        }
        if ("number".equals(fieldName)) {
            String strNumber;
            if (this.tblMain.getCell(rowIndex, "seq").getValue() == null) {
                if (e.getValue() != null && e.getValue().toString().length() > 3) {
                    strNumber = e.getValue().toString();
                    String strSeq = strNumber.substring(strNumber.length() - 4, strNumber.length());
                    if (TrackNumberEditUI.isNumeric(strSeq) && Integer.valueOf(strSeq) > 0) {
                        this.tblMain.getCell(rowIndex, "seq").setValue((Object)Integer.valueOf(strSeq));
                    } else {
                        this.tblMain.getCell(rowIndex, "seq").setValue((Object)this.getSeqByNumber());
                    }
                }
            } else if (e.getValue() != null) {
                String oldNumber;
                String oldSeq;
                strNumber = e.getValue().toString();
                String strSeq = strNumber.substring(strNumber.length() - 4, strNumber.length());
                if (TrackNumberEditUI.isNumeric(strSeq) && Integer.valueOf(strSeq) > 0) {
                    this.tblMain.getCell(rowIndex, "seq").setValue((Object)Integer.valueOf(strSeq));
                } else if (this.mapOldTrackNo.get(rowIndex) != null && this.mapOldTrackNo.get(rowIndex).toString().length() > 3 && TrackNumberEditUI.isNumeric(oldSeq = (oldNumber = this.mapOldTrackNo.get(rowIndex).toString()).substring(oldNumber.length() - 4, oldNumber.length())) && Integer.valueOf(oldSeq) > 0) {
                    this.tblMain.getCell(rowIndex, "seq").setValue((Object)this.getSeqByNumber());
                }
            }
        }
        this.mapOldTrackNo.put(rowIndex, this.tblMain.getCell(rowIndex, "number").getValue());
    }

    protected int getSeqByNumber() throws BOSException, SQLException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select isNull(max(fseq),0) + 1  as fseq from T_MM_TrackNumber ");
        IRowSet rs = SQLFacadeFactory.getRemoteInstance().getRowset(sql.toString());
        int maxSeq = this.getMaxSeqByTable();
        if (rs.next()) {
            if (maxSeq >= rs.getInt("fseq")) {
                return maxSeq + 1;
            }
            return rs.getInt("fseq");
        }
        return maxSeq + 1;
    }

    protected int getMaxSeqByTable() {
        int maxSeq = 0;
        int count = this.tblMain.getRowCount3();
        for (int i = 0; i < count; ++i) {
            int seq;
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("seq").getValue() == null || (seq = Integer.parseInt(row.getCell("seq").getValue().toString())) <= maxSeq) continue;
            maxSeq = seq;
        }
        return maxSeq;
    }

    protected void initTableKeyStroke(KDTable table, boolean isDownArrow) {
        AbstractAction actionTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrackNumberEditUI.this.tblMain != null) {
                    TrackNumberEditUI.this.tblMain.removeRow(TrackNumberEditUI.this.tblMain.getRowCount() - 1);
                    try {
                        IRow newRow = TrackNumberEditUI.this.tblMain.addRow();
                        TrackNumberEditUI.this.addRow(newRow);
                    }
                    catch (Exception e1) {
                        TrackNumberEditUI.this.handUIException(e1);
                    }
                }
            }
        };
        KDTableHelper.updateEnterWithTab((KDTable)table, (boolean)true, (Action)actionTable);
        if (isDownArrow) {
            KDTableHelper.downArrowAutoAddRow((KDTable)table, (boolean)true, (Action)actionTable);
        }
    }

    private ICodingRuleManager getCodingRuleManager() throws BOSException {
        if (this.codingRuleManager == null) {
            this.codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        }
        return this.codingRuleManager;
    }

    private String getNewNumberByUnit(String bizOrgUnitID) throws EASBizException, BOSException {
        ICodingRuleManager codingRuleManager = this.getCodingRuleManager();
        return codingRuleManager.getNumber((IObjectValue)new TrackNumberInfo(), bizOrgUnitID);
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        IRow newRow = this.tblMain.addRow();
        this.addRow(newRow);
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        this.deleteRow_actionPerformed(e);
    }

    @Override
    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        IRow newRow;
        if (this.tblMain == null) {
            return;
        }
        if (this.tblMain.getSelectManager().size() > 0) {
            int top = this.tblMain.getSelectManager().get().getTop();
            newRow = this.isTableColumnSelected(this.tblMain) ? this.tblMain.addRow() : this.tblMain.addRow(top);
        } else {
            newRow = this.tblMain.addRow();
        }
        this.addRow(newRow);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public void addRow(IRow newRow) throws Exception {
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        Integer idValue = new Integer(this.rowId + 1);
        this.tblMain.getCell(newRow.getRowIndex(), "number").getStyleAttributes().setLocked(false);
        this.tblMain.getCell(newRow.getRowIndex(), "number").getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
        this.tblMain.getCell(newRow.getRowIndex(), "trackNumberGroup").getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
        ICodingRuleManager codingRuleManager = this.getCodingRuleManager();
        String newNum = null;
        this.ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new TrackNumberInfo(), this.curCtrlUnitInfo.getId().toString());
        if (this.ruleStatus.isExist()) {
            newNum = this.getNewNumberByUnit(this.curCtrlUnitInfo.getId().toString());
            newRow.getCell("number").setValue((Object)newNum);
            newRow.getCell("number").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(newRow.getRowIndex(), "number").getStyleAttributes().setBackground(null);
        } else {
            this.tblMain.getCell(newRow.getRowIndex(), "number").getStyleAttributes().setLocked(false);
        }
        if (this.userInfo == null) {
            this.userInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        this.rowId = idValue;
        newRow.getCell("id").setValue((Object)idValue);
        newRow.getCell("status").setValue((Object)MMBasedataStatusEnum.ADDNEW);
        newRow.getCell("adminCU.id").setValue((Object)this.curCtrlUnitInfo.getId());
        newRow.getCell("adminCU.name").setValue((Object)this.curCtrlUnitInfo.getName());
        newRow.getCell("trackNumberGroup").setValue((Object)this.trackNumberGroupInfo);
        this.newRows.add(newRow);
        this.isChanged = true;
    }

    private void setMultiLangBox() {
        KDBizMultiLangBox namebox = new KDBizMultiLangBox();
        namebox.setMaxLength(255);
        String lan = LocaleUtils.getDefaultLocale().getLanguage();
        if (lan == "l1") {
            namebox.setSelectedIndex(2);
        } else if (lan == "l2") {
            namebox.setSelectedIndex(0);
        } else if (lan == "l3") {
            namebox.setSelectedIndex(1);
        }
        this.tblMain.getColumn("name").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)namebox));
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isChanged) {
            b = true;
            b = this.checkSaveChange();
        }
        if (b) {
            TrackNumberListUI ui = (TrackNumberListUI)((Object)this.getUIContext().get("Owner"));
            try {
                ui.refreshList();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return b;
    }

    private boolean checkSaveChange() {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)ResourceManage.getResource((String)"Confirm_Save_Exit"));
        if (result == 0) {
            try {
                this.actionSubmit_actionPerformed(null);
                return true;
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
        }
        return result != 2;
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public void deleteRow_actionPerformed(ActionEvent e) throws Exception {
        int size;
        IRow currRow;
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<String> ids = new ArrayList<String>();
        boolean isYes = MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
        if (!isYes) {
            return;
        }
        for (int i = selectRows.length; i > 0; --i) {
            currRow = this.tblMain.getRow(selectRows[i - 1]);
            if (this.tblMain.getCell(selectRows[i - 1], "status").getValue().equals(MMBasedataStatusEnum.SAVED)) {
                ids.add(this.tblMain.getCell(selectRows[i - 1], "id").getValue().toString());
                continue;
            }
            this.newRows.remove(currRow);
            this.tblMain.removeRow(selectRows[i - 1]);
        }
        this.newRows.clear();
        ArrayList successIDs = null;
        if (ids.size() > 0) {
            successIDs = this.remove(ids);
        }
        for (int i = size = this.tblMain.getRowCount(); i > 0; --i) {
            currRow = this.tblMain.getRow(i - 1);
            if (currRow.getCell("status").getValue().equals(MMBasedataStatusEnum.ADDNEW)) {
                this.newRows.add(currRow);
                continue;
            }
            if (successIDs == null || successIDs.size() <= 0 || !successIDs.contains(currRow.getCell("id").getValue().toString())) continue;
            this.tblMain.removeRow(i - 1);
        }
        if (this.newRows.size() <= 0) {
            this.isChanged = false;
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isChanged) {
            return;
        }
        Iterator itc = this.newRows.iterator();
        CoreBaseCollection newColls = new CoreBaseCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"EOMAAAAM4ODZJgxC", CompareType.EQUALS));
        view.setFilter(filter);
        TrackNumberGroupCollection colls = null;
        TrackNumberGroupInfo groupInfo = null;
        try {
            colls = TrackNumberGroupFactory.getRemoteInstance().getTrackNumberGroupCollection(view);
        }
        catch (BOSException e2) {
            this.handleException((Exception)((Object)e2));
        }
        if (colls != null) {
            groupInfo = colls.get(0);
        }
        while (itc.hasNext()) {
            IRow currRow = (IRow)itc.next();
            TrackNumberInfo info = new TrackNumberInfo();
            info.setTracknumberGroup(groupInfo);
            info = this.prepareData(currRow, info);
            newColls.add((CoreBaseInfo)info);
        }
        Result rt = null;
        LineResult lineResult = null;
        if (newColls.size() > 0) {
            try {
                rt = ((ITrackNumber)this.getBizInterface()).save(newColls);
            }
            catch (EASBizException bizE) {
                this.handleNumberDupErr(bizE, this.newRows);
            }
        }
        Iterator it = this.newRows.iterator();
        int i = 0;
        while (it.hasNext()) {
            IRow currRow = (IRow)it.next();
            if (rt != null && rt.getLineResult(i) != null && (lineResult = rt.getLineResult(i)).getPk() != null) {
                currRow.getCell("id").setValue((Object)lineResult.getPk().toString());
            }
            currRow.getCell("number").getStyleAttributes().setLocked(true);
            currRow.getCell("number").getStyleAttributes().setBackground(null);
            currRow.getCell("status").setValue((Object)MMBasedataStatusEnum.SAVED);
            ++i;
        }
        this.newRows.clear();
        this.isChanged = false;
    }

    private void handleNumberDupErr(EASBizException e, ArrayList rows) throws EASBizException {
        String excMsg = e.getMessage();
        if (excMsg.startsWith("NUMBER")) {
            int errIndex = this.rowDataError("number", excMsg.substring(6), rows);
            this.tblMain.getEditManager().editCellAt(errIndex, this.tblMain.getColumnIndex("number"));
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{excMsg.substring(6)});
        }
        throw e;
    }

    private int rowDataError(String col, String value, ArrayList rows) {
        for (IRow row : rows) {
            if (!row.getCell(col).getValue().toString().equalsIgnoreCase(value)) continue;
            return row.getRowIndex();
        }
        return -1;
    }

    private String getTrackNumberResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)sKey);
    }

    private TrackNumberInfo prepareData(IRow row, TrackNumberInfo info) {
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        info.setAdminCU(this.curCtrlUnitInfo);
        info.setCU(this.curCtrlUnitInfo);
        if (row.getCell("trackNumberGroup").getValue() != null && row.getCell("trackNumberGroup").getValue().toString().trim().length() > 0) {
            info.setTracknumberGroup((TrackNumberGroupInfo)row.getCell("trackNumberGroup").getValue());
        }
        String number = null;
        if (!(row.getCell("id").getValue() instanceof Integer)) {
            info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        }
        if (row.getCell("number").getValue() != null && row.getCell("number").getValue().toString().trim().length() > 0) {
            number = row.getCell("number").getValue().toString().trim();
        } else {
            String messageFormatString = this.getTrackNumberResource("TrackNumber_IsNotNull");
            MessageFormat messageFormat = new MessageFormat(messageFormatString);
            String msg = messageFormat.format(new String[]{" " + (row.getRowIndex() + 1) + " "});
            MsgBox.showInfo((String)msg);
            this.tblMain.getEditManager().editCellAt(row.getRowIndex(), this.tblMain.getColumnIndex("number"));
            SysUtil.abort();
        }
        info.setNumber(number);
        if (row.getCell("status").getValue() != null) {
            MMBasedataStatusEnum status = (MMBasedataStatusEnum)row.getCell("status").getValue();
            if (status.getValue() == 40) {
                info.setStatus(MMBasedataStatusEnum.SAVED);
            } else {
                info.setStatus(status);
            }
        }
        if (this.userInfo == null) {
            this.userInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        info.setCreator(this.userInfo);
        if (row.getCell("name").getValue() != null) {
            info.setName(row.getCell("name").getValue().toString());
            if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L2")) {
                info.setName(STConverter.sc2tc((String)info.getName(new Locale("L2"))), new Locale("L3"));
            }
            if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L3")) {
                info.setName(STConverter.sc2tc((String)info.getName(new Locale("L3"))), new Locale("L2"));
            }
        }
        if (row.getCell("seq").getValue() != null) {
            info.setSeq(Integer.valueOf(row.getCell("seq").getValue().toString()).intValue());
        }
        info = this.prepareCustomData(row, info);
        return info;
    }

    protected TrackNumberInfo prepareCustomData(IRow row, TrackNumberInfo info) {
        return info;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDeleteRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsetRow.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList remove(ArrayList ids) throws Exception {
        Throwable[] ex = null;
        HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
        ArrayList<String> exceptionIds = new ArrayList<String>();
        ArrayList successIDs = ids;
        Map mapNumber = this.listUiHelper.getSelectColumnValue(this.tblMain, "id", "number");
        Map rowNumberMap = null;
        if (mapNumber.isEmpty()) {
            rowNumberMap = this.listUiHelper.getSelectRowNumberMap(this.tblMain, "id");
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Iterator lt = ids.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
                exceptionMap.put(id, mutexException);
                exceptionIds.add(id);
                lt.remove();
            }
            if (ids.size() > 0) {
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[ids.size()];
                for (int i = 0; i < ids.size(); ++i) {
                    BatchExecuteParamsEntry entry;
                    if (ids.get(i) == null) continue;
                    ObjectStringPK pk = new ObjectStringPK(ids.get(i).toString());
                    paramEntries[i] = entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
                }
                BatchExecuteResult result = this.getBizInterface().batchExecute("delete", new Class[]{IObjectPK.class}, paramEntries);
                ex = result.getExceptions();
                for (int i = 0; i < ex.length; ++i) {
                    if (ex[i] == null) continue;
                    exceptionMap.put((String)ids.get(i), ex[i]);
                    exceptionIds.add((String)ids.get(i));
                    successIDs.remove(ids.get(i));
                }
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
        }
        StringBuffer errorMsg = new StringBuffer();
        String numbetMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteFail_ByNumber");
        String rowIndexMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteFail_ByRowIndex");
        for (String id : exceptionIds) {
            if (mapNumber.isEmpty()) {
                if (rowNumberMap != null) {
                    errorMsg.append(MessageFormat.format(rowIndexMsg, rowNumberMap.get(id)));
                }
            } else if (mapNumber != null) {
                errorMsg.append(MessageFormat.format(numbetMsg, mapNumber.get(id)));
            }
            if (!exceptionMap.isEmpty()) {
                errorMsg.append("," + ExceptionMessageUtility.getMessage((Throwable)((Throwable)exceptionMap.get(id))) + "\n");
                continue;
            }
            errorMsg.append("\n");
        }
        if (exceptionIds.size() > 0) {
            String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorMsg.toString(), (int)8188);
        }
        return successIDs;
    }

    protected static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            System.out.println(str.charAt(i));
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

