/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractTrackNumberUI;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrackNumberUI
extends AbstractTrackNumberUI {
    private static final Logger logger = CoreUIObject.getLogger(TrackNumberUI.class);
    private final String TB_ID = "id";
    private final String TB_NUMBER = "number";
    private final String TB_STATUS = "status";
    private final String TB_CREATOR = "creator.name";
    private final String TB_CREATETIME = "createTime";
    private final String[] KDT_DATES = new String[]{"createTime"};
    private String UI_STATUS = "VIEW";
    private Color lockedColor = new Color(232, 232, 227);
    private RuleStatus ruleStatus;
    private ICodingRuleManager codingRuleManager;
    private KDTEditAdapter entryTableChange = null;
    private KDTActiveCellListener activeCellListener = null;
    private Integer rowId = new Integer(0);
    private boolean isMutex = false;
    private int lastPage = 0;
    private Set newRows = new HashSet();
    private Set editRows = new HashSet();
    private Map userMap = new HashMap();
    KDBizMultiLangBox box = null;
    private boolean isChanged = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrackNumberFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void initTableParams() {
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private void requestMutex(String opState) throws Throwable {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
        this.dataBinding();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])this.KDT_DATES);
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        Integer idValue;
        super.actionAddRow_actionPerformed(e);
        Object newNum = null;
        this.tblMain.checkParsed();
        IRow newRow = this.tblMain.addRow();
        this.rowId = idValue = new Integer(this.rowId + 1);
        newRow.getCell("id").setValue((Object)idValue);
        newRow.getCell("status").setValue((Object)MMBasedataStatusEnum.ADDNEW);
        newRow.getCell("creator.name").setValue((Object)this.getUserInfo().getName());
        if (!this.userMap.containsKey(this.getUserInfo().getName())) {
            this.userMap.put(this.getUserInfo().getName(), this.getUserInfo());
        }
        newRow.getCell("createTime").setValue((Object)new Date());
        this.newRows.add(newRow);
        newRow.getCell("number").getStyleAttributes().setLocked(false);
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        Iterator itc = this.newRows.iterator();
        CoreBaseCollection newColls = new CoreBaseCollection();
        CoreBaseCollection editColls = new CoreBaseCollection();
        while (itc.hasNext()) {
            IRow currRow = (IRow)itc.next();
            TrackNumberInfo info = this.prepareData(currRow);
            newColls.add((CoreBaseInfo)info);
        }
        for (IRow currRow : this.editRows) {
            TrackNumberInfo info = this.prepareData(currRow);
            editColls.add((CoreBaseInfo)info);
        }
        if (newColls.size() > 0) {
            try {
                ((ITrackNumber)this.getBizInterface()).save(newColls);
            }
            catch (EASBizException bizE) {
                this.handleNumberDupErr(bizE, this.newRows);
            }
        }
        if (editColls.size() > 0 && newColls.size() != editColls.size()) {
            try {
                ((ITrackNumber)this.getBizInterface()).update(editColls);
            }
            catch (EASBizException bizE) {
                this.handleNumberDupErr(bizE, this.editRows);
            }
        }
        this.newRows.clear();
        this.editRows.clear();
        this.isChanged = false;
        this.dataBinding();
    }

    private void handleNumberDupErr(EASBizException e, Set rows) throws EASBizException {
        String excMsg = e.getMessage();
        if (excMsg.startsWith("NUMBER")) {
            int errIndex = this.rowDataError("number", excMsg.substring(6), rows);
            this.tblMain.getEditManager().editCellAt(errIndex, this.tblMain.getColumnIndex("number"));
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{excMsg.substring(6)});
        }
        throw e;
    }

    private int rowDataError(String col, String value, Set rows) {
        for (IRow row : rows) {
            if (!row.getCell(col).getValue().toString().equalsIgnoreCase(value)) continue;
            return row.getRowIndex();
        }
        return -1;
    }

    private TrackNumberCollection queryTrackNumber() throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("creator.*"));
        SorterItemInfo aSorterItemInfo = new SorterItemInfo("number");
        aSorterItemInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(aSorterItemInfo);
        return ((ITrackNumber)this.getBizInterface()).getTrackNumberCollection(view);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private void dataBinding() throws BOSException, Exception {
        this.tblMain.repaint();
        this.tblMain.removeRows();
        TrackNumberCollection csColls = this.queryTrackNumber();
        for (int i = 0; i < csColls.size(); ++i) {
            TrackNumberInfo info = csColls.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)info.getId());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("status").setValue((Object)info.getStatus());
            if (info.getCreator() != null) {
                row.getCell("creator.name").setValue((Object)info.getCreator().getName());
                if (!this.userMap.containsKey(info.getCreator().getName())) {
                    this.userMap.put(info.getCreator().getName(), info.getCreator());
                }
            }
            row.getCell("createTime").setValue((Object)info.getCreateTime());
            row.getCell("number").getStyleAttributes().setBackground(this.lockedColor);
            row.getCell("number").getStyleAttributes().setLocked(true);
        }
    }

    private String getControlStrategyResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)sKey);
    }

    protected TrackNumberInfo prepareData(IRow row) {
        TrackNumberInfo info = new TrackNumberInfo();
        String number = null;
        if (!(row.getCell("id").getValue() instanceof Integer)) {
            info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        }
        if (row.getCell("number").getValue() != null) {
            number = (String)row.getCell("number").getValue();
        } else {
            String messageFormatString = this.getControlStrategyResource("ControlStrategyNumber_IsNotNull");
            MessageFormat messageFormat = new MessageFormat(messageFormatString);
            String msg = messageFormat.format(new String[]{" " + (row.getRowIndex() + 1) + " "});
            MsgBox.showInfo((String)msg);
            this.tblMain.getEditManager().editCellAt(row.getRowIndex(), this.tblMain.getColumnIndex("number"));
            SysUtil.abort();
        }
        info.setNumber(number);
        if (row.getCell("status").getValue() != null) {
            MMBasedataStatusEnum status = (MMBasedataStatusEnum)row.getCell("status").getValue();
            if (status.getValue() == 40) {
                info.setStatus(MMBasedataStatusEnum.SAVED);
            } else {
                info.setStatus(status);
            }
        }
        if (row.getCell("creator.name").getValue() != null) {
            info.setCreator((UserInfo)this.userMap.get((String)row.getCell("creator.name").getValue()));
        }
        info.setLastUpdateUser(this.getUserInfo());
        return info;
    }
}

