/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.client.AbstractWarehouseChangeUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WarehouseChangeUI
extends AbstractWarehouseChangeUI {
    private static final Logger logger = CoreUIObject.getLogger(WarehouseChangeUI.class);
    private BomEntryCollection entryColl;

    public void onLoad() throws Exception {
        Map ctx = this.getUIContext();
        Set entrySet = null;
        if (ctx != null) {
            entrySet = (Set)ctx.get("EntryIDs");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add(new SelectorItemInfo("parent.storageOrgUnit.number"));
        view.getSelector().add(new SelectorItemInfo("parent.storageOrgUnit.name"));
        view.getSelector().add(new SelectorItemInfo("supplyOrgUnit.number"));
        view.getSelector().add(new SelectorItemInfo("supplyOrgUnit.name"));
        view.getSelector().add(new SelectorItemInfo("defaultWarehouse.number"));
        view.getSelector().add(new SelectorItemInfo("defaultWarehouse.name"));
        view.getSelector().add(new SelectorItemInfo("provideType"));
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("id", (Object)entrySet, CompareType.INCLUDE));
        view.setFilter(filter1);
        this.entryColl = BomEntryFactory.getRemoteInstance().getBomEntryCollection(view);
        if (this.entryColl != null && this.entryColl.size() > 0) {
            BomEntryInfo entry = this.entryColl.get(0);
            StorageOrgUnitInfo storageInfo = entry.getSupplyOrgUnit();
            if (storageInfo == null) {
                MsgBox.showWarning((String)"\u7b2c1\u6761\u9009\u62e9\u8bb0\u5f55\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a");
                SysUtil.abort();
            }
            if (entry.getProvideType() == MaterialProvideTypeEnum.getEnum((int)10920)) {
                storageInfo = entry.getParent().getStorageOrgUnit();
            }
            String storageID = storageInfo.getId().toString();
            EntityViewInfo en = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageID, CompareType.EQUALS));
            en.setFilter(filter2);
            this.kDBizPromptBox1.setEntityViewInfo(en);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        if (this.entryColl != null && this.entryColl.size() > 0) {
            Object warehouseObj = this.kDBizPromptBox1.getValue();
            if (warehouseObj == null || warehouseObj instanceof String) {
                MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7");
                SysUtil.abort();
            }
            StorageOrgUnitInfo storageInfo = null;
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < this.entryColl.size(); ++i) {
                BomEntryInfo entry = this.entryColl.get(i);
                StorageOrgUnitInfo tempInfo = entry.getSupplyOrgUnit();
                if (tempInfo == null) {
                    MsgBox.showWarning((String)("\u7b2c" + (i + 1) + "\u6761\u5206\u5f55\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a"));
                    SysUtil.abort();
                }
                if (entry.getProvideType() == MaterialProvideTypeEnum.getEnum((int)10920)) {
                    tempInfo = entry.getParent().getStorageOrgUnit();
                }
                if (i == 0) {
                    storageInfo = entry.getSupplyOrgUnit();
                    if (entry.getProvideType() == MaterialProvideTypeEnum.getEnum((int)10920)) {
                        storageInfo = entry.getParent().getStorageOrgUnit();
                    }
                }
                if (storageInfo != null && storageInfo.getId() != null && tempInfo != null && tempInfo.getId() != null && StringUtils.equals((String)storageInfo.getId().toString(), (String)tempInfo.getId().toString())) {
                    coll.add((CoreBaseInfo)entry);
                    entry.setDefaultWarehouse((WarehouseInfo)warehouseObj);
                    continue;
                }
                if (entry.getProvideType() == MaterialProvideTypeEnum.getEnum((int)10920)) {
                    MsgBox.showWarning((String)("\u7b2c" + (i + 1) + "\u6761\u9009\u4e2d\u5206\u5f55\u4e3a" + entry.getProvideType().getAlias() + "\uff0c\u9886\u6599\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u540c\uff0c\u4e0d\u80fd\u6279\u91cf\u4fee\u6539"));
                } else {
                    MsgBox.showWarning((String)("\u7b2c" + (i + 1) + "\u6761\u9009\u4e2d\u5206\u5f55\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u540c\uff0c\u4e0d\u80fd\u6279\u91cf\u4fee\u6539"));
                }
                SysUtil.abort();
            }
            BomEntryFactory.getRemoteInstance().updateBatchData(coll);
            this.getUIContext().put("isOK", true);
            MsgBox.showInfo((String)"\u66f4\u65b0\u6210\u529f");
            this.getUIWindow().close();
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

