/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.mm.basedata.WorkCenterGroupFactory;
import com.kingdee.eas.mm.basedata.WorkCenterGroupInfo;
import com.kingdee.eas.mm.basedata.client.AbstractWorkCenterGroupEditUI;
import com.kingdee.eas.mm.common.client.MMF7ContextManager;
import com.kingdee.eas.mm.common.client.RegisterF7ParamFactory;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class WorkCenterGroupEditUI
extends AbstractWorkCenterGroupEditUI
implements IMultiOrgSupport {
    private static final Logger logger = CoreUIObject.getLogger(WorkCenterGroupEditUI.class);
    private MMF7ContextManager F7ContextManager = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtParent.setSelectorCollection(this.getSelectors());
        this.prmtStorage.setValue((Object)((StorageOrgUnitInfo)this.getUIContext().get("currStorage")));
        this.loadParentData();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        return sic;
    }

    private void loadParentData() {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("description"));
        view.getSelector().add(new SelectorItemInfo("parent.number"));
        view.getSelector().add(new SelectorItemInfo("parent.name"));
        this.prmtParent.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7WorkCenterGroupQuery");
        FilterInfo filterInfo = new FilterInfo();
        if (this.editData.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(this.editData.getLongNumber() + "!%"), CompareType.NOTLIKE));
        }
        if (this.editData.getStorageOrgUnit() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.editData.getStorageOrgUnit().getId(), CompareType.EQUALS));
        }
        view.setFilter(filterInfo);
        this.prmtParent.setEntityViewInfo(view);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || StringUtil.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showInfo((String)this.getWorkCenterGroupResource("Number_Not_Null"));
            SysUtil.abort();
        }
        if (this.txtName.getEditor().getItem() == null || StringUtil.isEmpty((String)this.txtName.getEditor().getItem().toString())) {
            MsgBox.showInfo((String)this.getWorkCenterGroupResource("Name_Not_Null"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    protected IObjectValue createNewData() {
        WorkCenterGroupInfo group = new WorkCenterGroupInfo();
        group.setStorageOrgUnit((StorageOrgUnitInfo)this.getUIContext().get("currStorage"));
        group.setParent((WorkCenterGroupInfo)this.getUIContext().get("workCenterBrowsGroup"));
        return group;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WorkCenterGroupFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorage;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCopy.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.menuItemSubmit.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        String saveText = EASResource.getString((String)"com.kingdee.eas.framework.config.Preferences", (String)"BtnSave");
        this.btnSave.setText(saveText);
        this.btnSave.setToolTipText(saveText);
        this.menuItemSave.setText(saveText);
        this.menuItemSave.setToolTipText(saveText);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private String getWorkCenterGroupResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)sKey);
    }

    protected void showSaveSuccess() {
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0} {1}");
        String messageText = format.format(new Object[]{this.getClassAlise(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK")});
        this.setMessageText(messageText);
        String nextMessageText = format.format(new Object[]{this.getClassAlise(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit")});
        this.setNextMessageText(nextMessageText);
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
    }

    public IF7ContextChange getF7ContextManager() {
        return (MMF7ContextManager)this.getF7Register();
    }

    public IF7Register getF7Register() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new MMF7ContextManager((Component)((Object)this), OrgType.Storage, ContextTypeEnum.INQUERYING, 0);
            try {
                this.registerF7();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtStorage;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return null;
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public String getPermissionItem() {
        return null;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    private void registerF7() throws Exception {
        this.F7ContextManager.registerWorkcenterF7(RegisterF7ParamFactory.getWorkCenterF7Param((KDBizPromptBox)this.prmtParent, (StorageOrgUnitInfo)((StorageOrgUnitInfo)this.getUIContext().get("currStorage"))));
    }
}

