/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.param.IOtherParam;
import com.kingdee.eas.base.param.ISetOrgType;
import com.kingdee.eas.base.param.client.ICustomParamUI;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.control.ControlParamFactory;
import com.kingdee.eas.mm.control.ControlParamInfo;
import com.kingdee.eas.mm.control.FinishedRptBOTPParams;
import com.kingdee.eas.mm.control.FinishedRptFactory;
import com.kingdee.eas.mm.control.IControlParam;
import com.kingdee.eas.mm.control.IFinishedRpt;
import com.kingdee.eas.mm.control.client.AbstractControlParamSetUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ControlParamSetUI
extends AbstractControlParamSetUI
implements IOtherParam,
ICustomParamUI,
ISetOrgType {
    private static final Logger logger = CoreUIObject.getLogger(ControlParamSetUI.class);
    private OrgType cuOrgType = null;
    private StorageOrgUnitInfo storageOrgInfo = null;
    private ControlParamInfo cpInfo = null;
    private FinishedRptBOTPParams botpMappings = null;
    private IBOTMapping iBOTMapping;

    public void onShow() throws Exception {
        super.onShow();
        this.chkTaskDispBillComplete.setEnabled(false);
        this.chkFinishQty.setEnabled(false);
        this.chkNRStock.setEnabled(false);
        this.initBOTPRuleF7();
    }

    private void initBOTPRuleF7() throws BOTPException, BOSException {
        String cuId = this.storageOrgInfo.getCU().getId().toString();
        EntityViewInfo view = this.getCurrBotpFilter(cuId);
        this.prmtBOTPRule01.setEntityViewInfo(view);
        this.prmtBOTPRule02.setEntityViewInfo(view);
        this.prmtBOTPRule03.setEntityViewInfo(view);
        this.prmtBOTPRule04.setEntityViewInfo(view);
        this.prmtBOTPRule05.setEntityViewInfo(view);
        this.prmtBOTPRule06.setEntityViewInfo(view);
        this.prmtBOTPRule07.setEntityViewInfo(view);
        this.prmtBOTPRule08.setEntityViewInfo(view);
        this.prmtBOTPRule09.setEntityViewInfo(view);
        this.prmtBOTPRule10.setEntityViewInfo(view);
        this.prmtBOTPRule11.setEntityViewInfo(view);
        this.prmtBOTPRule12.setEntityViewInfo(view);
    }

    private EntityViewInfo getCurrBotpFilter(String cuId) throws BOTPException, BOSException {
        int i;
        if (this.iBOTMapping == null) {
            this.iBOTMapping = BOTMappingFactory.getRemoteInstance();
        }
        HashMap<String, String> transmitCtx = null;
        if (!StringUtils.isEmpty((String)cuId)) {
            transmitCtx = new HashMap<String, String>();
            transmitCtx.put("TRANSMITCU_ID", cuId);
        }
        HashSet<String> botpIds = new HashSet<String>();
        BOTMappingCollection botMappingCol = this.iBOTMapping.getMappingCollectionForSelect("F2901DDD", "FA1292B4", DefineSysEnum.BTP, transmitCtx);
        int n = botMappingCol.size();
        for (i = 0; i < n; ++i) {
            botpIds.add(botMappingCol.get(i).getId().toString());
        }
        botMappingCol = this.iBOTMapping.getMappingCollectionForSelect("F2901DDD", "A4D04D23", DefineSysEnum.BTP, transmitCtx);
        n = botMappingCol.size();
        for (i = 0; i < n; ++i) {
            botpIds.add(botMappingCol.get(i).getId().toString());
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", botpIds, CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        return entityView;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadParamValue();
    }

    private void loadParamValue() {
        try {
            IControlParam iControlParam = ControlParamFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            this.cpInfo = iControlParam.getParameters((OrgUnitInfo)this.storageOrgInfo);
            this.chkTaskDispBillComplete.setSelected(this.cpInfo.isTaskDispBillComplete());
            this.chkAllInStock.setSelected(this.cpInfo.isAllInStock());
            this.chkPickingSlipComplete.setSelected(this.cpInfo.isPickingSlipComplete());
            this.chkFinishQty.setSelected(this.cpInfo.isFinishQty());
            this.chkNRStock.setSelected(this.cpInfo.isNrStock());
            this.chkNRPickingSlipComplete.setSelected(this.cpInfo.isNrPickingSlipComplete());
            IFinishedRpt iFinishedRpt = FinishedRptFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            this.botpMappings = iFinishedRpt.getBOTPParameters(this.storageOrgInfo);
            this.prmtBOTPRule01.setValue((Object)this.botpMappings.getBotpRule1());
            this.prmtBOTPRule02.setValue((Object)this.botpMappings.getBotpRule2());
            this.prmtBOTPRule03.setValue((Object)this.botpMappings.getBotpRule3());
            this.prmtBOTPRule04.setValue((Object)this.botpMappings.getBotpRule4());
            this.prmtBOTPRule05.setValue((Object)this.botpMappings.getBotpRule5());
            this.prmtBOTPRule06.setValue((Object)this.botpMappings.getBotpRule6());
            this.prmtBOTPRule07.setValue((Object)this.botpMappings.getBotpRule7());
            this.prmtBOTPRule08.setValue((Object)this.botpMappings.getBotpRule8());
            this.prmtBOTPRule09.setValue((Object)this.botpMappings.getBotpRule9());
            this.prmtBOTPRule10.setValue((Object)this.botpMappings.getBotpRule10());
            this.prmtBOTPRule11.setValue((Object)this.botpMappings.getBotpRule11());
            this.prmtBOTPRule12.setValue((Object)this.botpMappings.getBotpRule12());
        }
        catch (Exception e) {
            this.botpMappings = new FinishedRptBOTPParams();
            this.handUIException(e);
        }
    }

    public void otherParamSave() throws BOSException, EASBizException {
        this.cpInfo.setTaskDispBillComplete(this.chkTaskDispBillComplete.isSelected());
        this.cpInfo.setAllInStock(this.chkAllInStock.isSelected());
        this.cpInfo.setPickingSlipComplete(this.chkPickingSlipComplete.isSelected());
        this.cpInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        this.cpInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        this.cpInfo.setFinishQty(this.chkFinishQty.isSelected());
        this.cpInfo.setNrStock(this.chkNRStock.isSelected());
        this.cpInfo.setNrPickingSlipComplete(this.chkNRPickingSlipComplete.isSelected());
        IControlParam iControlParam = ControlParamFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        iControlParam.save((CoreBaseInfo)this.cpInfo);
        this.checkBotp();
        this.botpMappings.setBotpRule1((BOTMappingInfo)this.prmtBOTPRule01.getValue());
        this.botpMappings.setBotpRule2((BOTMappingInfo)this.prmtBOTPRule02.getValue());
        this.botpMappings.setBotpRule3((BOTMappingInfo)this.prmtBOTPRule03.getValue());
        this.botpMappings.setBotpRule4((BOTMappingInfo)this.prmtBOTPRule04.getValue());
        this.botpMappings.setBotpRule5((BOTMappingInfo)this.prmtBOTPRule05.getValue());
        this.botpMappings.setBotpRule6((BOTMappingInfo)this.prmtBOTPRule06.getValue());
        this.botpMappings.setBotpRule7((BOTMappingInfo)this.prmtBOTPRule07.getValue());
        this.botpMappings.setBotpRule8((BOTMappingInfo)this.prmtBOTPRule08.getValue());
        this.botpMappings.setBotpRule9((BOTMappingInfo)this.prmtBOTPRule09.getValue());
        this.botpMappings.setBotpRule10((BOTMappingInfo)this.prmtBOTPRule10.getValue());
        this.botpMappings.setBotpRule11((BOTMappingInfo)this.prmtBOTPRule11.getValue());
        this.botpMappings.setBotpRule12((BOTMappingInfo)this.prmtBOTPRule12.getValue());
        IFinishedRpt iFinishedRpt = FinishedRptFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        iFinishedRpt.saveBOTPParameters(this.botpMappings);
    }

    private void checkBotp() {
        if (this.prmtBOTPRule01.getValue() == null || this.prmtBOTPRule02.getValue() == null || this.prmtBOTPRule03.getValue() == null || this.prmtBOTPRule04.getValue() == null || this.prmtBOTPRule05.getValue() == null || this.prmtBOTPRule06.getValue() == null || this.prmtBOTPRule07.getValue() == null || this.prmtBOTPRule08.getValue() == null || this.prmtBOTPRule09.getValue() == null || this.prmtBOTPRule10.getValue() == null || this.prmtBOTPRule11.getValue() == null || this.prmtBOTPRule12.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"30_ControlParamSetUI"));
            SysUtil.abort();
        }
    }

    public void sendOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
        this.cuOrgType = orgType;
        if (orgType.getValue() != 4) {
            return;
        }
        if (orgUnit == null || orgUnit.getId() == null) {
            return;
        }
        this.storageOrgInfo = (StorageOrgUnitInfo)orgUnit;
        try {
            this.loadFields();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public Vector getOrgTypeVect() throws BOSException, EASBizException {
        Vector<OrgType> vect = new Vector<OrgType>();
        vect.add(OrgType.Storage);
        return vect;
    }

    public void setOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
        if (orgType == null) {
            return;
        }
    }
}

