/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.ClassGroupInfo;
import com.kingdee.eas.mm.basedata.ClassTeamEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryCollection;
import com.kingdee.eas.mm.control.DDMReceivalBillFactory;
import com.kingdee.eas.mm.control.DDMReceivalBillInfo;
import com.kingdee.eas.mm.control.DDMSourceBillTypeEnum;
import com.kingdee.eas.mm.control.client.AbstractDDMReceivalBillEditUI;
import com.kingdee.eas.mm.control.client.DDMReceivalCreateFromUI;
import com.kingdee.eas.mm.control.client.DDMReceivalTargetUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DDMReceivalBillEditUI
extends AbstractDDMReceivalBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DDMReceivalBillEditUI.class);
    private DataChangeListener headerF7ChangeListener = null;
    private KDTEditAdapter entryKDTEditAdapter;
    private static final String TB_MATERIAL_NUMBER = "materialNumber";
    private static final String TB_TRACK_NUMBER = "trackNumer";
    private static final String TB_UNIT = "unit";
    private static final String TB_BASEUNIT = "baseUnit";
    private static final String TB_RECEIVEQTY = "receiveQty";
    private static final String TB_BSRECEIVEQTY = "baseReceiveQty";
    private static final String TB_RECEIVABLEQTY = "receivableQty";
    private static final String TB_BSRECEIVABLEQTY = "bsReceivableQty";
    private static final String TB_MATERIALINVENTORY = "materialInventory";
    private static final String TB_ASSISTUNIT = "assistUnit";
    private static final String TB_ASSISTPROPERTY = "assistProperty";
    private static final String TB_ASSISTQTY = "assistQty";
    private static final String TB_LOTNUMBER = "lotNumber";
    private static final String TB_PRODUCTDATE = "productDate";
    private static final String TB_EXPIREDATE = "expireDate";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_STOCKER = "stocker";
    private static final String TB_REMARK = "remark";
    private static final String[] QTYPRECISIONFROMUNITTAB = new String[]{"receiveQty", "receivableQty"};
    protected String[] QTYPRECISIONFROMBASEUNITTAB = new String[]{"baseReceiveQty", "bsReceivableQty"};
    protected String[] COLS_QTYPRECISIONFROMASSISTUNITTAB = new String[]{"assistQty"};
    private static final String[] KDT_DATES = new String[]{"productDate", "expireDate", "deliveryDate"};
    private static final String[] TAR_DATETIMES = new String[]{"startDate", "endDate"};
    private static final String IN_STATE = "inState";
    private static final String IN_DATA = "inData";
    private static final String OUT_DATA = "outData";
    private static final String RTN_STATE = "retrunState";

    public DDMReceivalBillEditUI() throws Exception {
        HashMap<String, Object> colMap = new HashMap<String, Object>();
        colMap.put("MATERIAL", TB_MATERIAL_NUMBER);
        colMap.put("TB_BASEUNIT", TB_BASEUNIT);
        colMap.put("TB_UNIT", TB_UNIT);
        colMap.put("TB_ASSISTPROPERTY", TB_ASSISTPROPERTY);
        colMap.put("TB_ASSISTUNIT", TB_ASSISTUNIT);
        colMap.put("TB_ASSISTQTY", TB_ASSISTQTY);
        colMap.put("QTYPRECISIONFROMUNITTAB", QTYPRECISIONFROMUNITTAB);
        colMap.put("QTYPRECISIONFROMBASEUNITTAB", this.QTYPRECISIONFROMBASEUNITTAB);
        colMap.put("QTYPRECISIONFROMASSISTUNITTAB", this.COLS_QTYPRECISIONFROMASSISTUNITTAB);
        this.uiHelper.setConfigMap(colMap);
        this.uiHelper.setKdtEntries(this.kdtEntrys);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_dDMReceivalBill_addNew");
        this.kdtEntrys.getActionMap().put("FocusChangeRow", (Action)new KDTFocusChangeAction(this.kdtEntrys, 0, false, false, null));
        this.kdtEntrys.getActionMap().remove("Paste");
        this.pkBizDate.setRequired(true);
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn(TB_MATERIAL_NUMBER).setRenderer((IBasicRender)render);
        this.kdtEntrys.getColumn(TB_TRACK_NUMBER).setRenderer((IBasicRender)render);
        KDTextField kdtEntrys_remark_TextField = new KDTextField();
        kdtEntrys_remark_TextField.setName("kdtEntrys_remark_TextField");
        kdtEntrys_remark_TextField.setMaxLength(255);
        KDTDefaultCellEditor kdtEntrys_remark_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_remark_TextField);
        this.kdtEntrys.getColumn(TB_REMARK).setEditor((ICellEditor)kdtEntrys_remark_CellEditor);
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.setRequired(true);
        }
        EditTableUtil.formatColDate((KDTable)this.kdtEntrys, (String[])KDT_DATES);
        EditTableUtil.formatColDateTime((KDTable)this.kdtTargetEntry, (String[])TAR_DATETIMES);
        super.setReservationVisible(false);
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, DDMReceivalBillFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.kdtEntrys, "id", this.txtNumber, null);
        super.initBatchActions();
    }

    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
        super.afterAction(bizAction, selectionEntries, countSuccess);
        if (bizAction.equals((Object)BatchActionEnum.SUBMIT)) {
            this.btnCopyFrom.setEnabled(false);
        }
        if (bizAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.setOprtState("VIEW");
            this.btnSendTo.setEnabled(true);
            this.menuItemSendTo.setEnabled(true);
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        try {
            this.initF7Filter();
            this.initEntryFilter();
            this.f7Manager.registerAssistPropertyF7(this.kdtEntrys, TB_MATERIAL_NUMBER, TB_ASSISTPROPERTY, (SCMBillEditUI)this);
            this.uiHelper.initInLoadFields(null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.setButtonState();
        this.setHeadFieldsState();
        this.setEntryFieldsState();
        this.setEntryFieldsDisplay();
        this.addListener();
        if (BillBaseStatusEnum.AUDITED.equals((Object)this.editData.getBaseStatus())) {
            this.btnCreateFrom.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnSendTo.setEnabled(true);
            this.menuItemSendTo.setEnabled(true);
            this.prmtsupplier.setEditable(false);
        }
    }

    private void initEntryFilter() throws Exception {
        MaterialInfo materialInfo = null;
        StorageOrgUnitInfo orgInfo = this.editData.getStorageOrgUnit();
        WarehouseInfo whInfo = null;
        for (int i = 0; i < this.kdtEntrys.getRowCount3(); ++i) {
            materialInfo = this.editData.getEntrys().get(i).getMaterial();
            whInfo = this.editData.getEntrys().get(i).getWarehouse();
            InvClientUtils.setLocationFilter((StorageOrgUnitInfo)orgInfo, (WarehouseInfo)whInfo, (MaterialInfo)materialInfo, (KDTable)this.kdtEntrys, (int)i, (boolean)true);
        }
    }

    private void setEntryFieldsDisplay() {
        BigDecimal assistQty = null;
        Object assistUnit = null;
        for (int i = 0; i < this.kdtEntrys.getRowCount3(); ++i) {
            assistQty = (BigDecimal)this.kdtEntrys.getCell(i, TB_ASSISTQTY).getValue();
            assistUnit = this.kdtEntrys.getCell(i, TB_ASSISTUNIT).getValue();
            if ((assistQty == null || assistQty.compareTo(SCMClientUtils.ZERO) == 0) && assistUnit != null) continue;
        }
    }

    protected void initListener() {
        super.initListener();
        this.entryKDTEditAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    DDMReceivalBillEditUI.this.kdtEntries_Changed(e);
                }
                catch (Exception exc) {
                    DDMReceivalBillEditUI.this.handUIException(exc);
                }
            }
        };
        this.kdtEntrys.addKDTEditListener((KDTEditListener)this.entryKDTEditAdapter);
    }

    private void kdtEntries_Changed(KDTEditEvent e) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getValue());
        if (isDiffrent) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.kdtEntrys.getColumnKey(colIndex);
            if (TB_WAREHOUSE.equalsIgnoreCase(fieldName)) {
                Object stocker = this.kdtEntrys.getCell(rowIndex, TB_STOCKER).getValue();
                MaterialInfo mInfo = (MaterialInfo)this.kdtEntrys.getCell(rowIndex, TB_MATERIAL_NUMBER).getValue();
                if (stocker == null) {
                    WarehouseInfo newValue = (WarehouseInfo)e.getValue();
                    if (newValue == null) {
                        this.kdtEntrys.getCell(rowIndex, TB_STOCKER).setValue(null);
                    } else {
                        this.kdtEntrys.getCell(rowIndex, TB_STOCKER).setValue((Object)newValue.getWhman());
                    }
                }
                InvClientUtils.setLocationFilter((StorageOrgUnitInfo)this.editData.getStorageOrgUnit(), (WarehouseInfo)((WarehouseInfo)e.getValue()), (MaterialInfo)mInfo, (KDTable)this.kdtEntrys, (int)rowIndex, (boolean)false);
            } else if (TB_PRODUCTDATE.equals(fieldName) || TB_EXPIREDATE.equals(fieldName)) {
                MaterialInventoryInfo inventoryInfo = (MaterialInventoryInfo)this.kdtEntrys.getCell(rowIndex, TB_MATERIALINVENTORY).getValue();
                int unit = inventoryInfo.getPeriodValidUnit().getValue();
                int unitValue = inventoryInfo.getPeriodValid();
                if (inventoryInfo == null || !inventoryInfo.isIsPeriodValid()) {
                    return;
                }
                if (e.getValue() == null) {
                    return;
                }
                if (TB_PRODUCTDATE.equals(fieldName)) {
                    Date expDate = InvClientUtils.getEXP((Date)((Date)e.getValue()), (int)unit, (int)unitValue);
                    this.kdtEntrys.getCell(rowIndex, TB_EXPIREDATE).setValue((Object)expDate);
                } else {
                    Date prdDate = InvClientUtils.getMFG((Date)((Date)e.getValue()), (int)unit, (int)unitValue);
                    this.kdtEntrys.getCell(rowIndex, TB_PRODUCTDATE).setValue((Object)prdDate);
                }
            } else if (TB_LOTNUMBER.equals(fieldName)) {
                if (e.getValue() == null) {
                    this.kdtEntrys.getCell(rowIndex, TB_PRODUCTDATE).getStyleAttributes().setLocked(false);
                    this.kdtEntrys.getCell(rowIndex, TB_EXPIREDATE).getStyleAttributes().setLocked(false);
                } else {
                    MaterialInfo materialInfo = (MaterialInfo)this.kdtEntrys.getCell(rowIndex, TB_MATERIAL_NUMBER).getValue();
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo fi = new FilterInfo();
                    fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)this.editData.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
                    fi.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                    fi.getFilterItems().add(new FilterItemInfo("lot", e.getValue(), CompareType.EQUALS));
                    evi.setFilter(fi);
                    try {
                        IDateOfMinDurability ido = DateOfMinDurabilityFactory.getRemoteInstance();
                        DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(evi);
                        if (doc == null || doc.size() <= 0) {
                            this.kdtEntrys.getCell(rowIndex, TB_PRODUCTDATE).getStyleAttributes().setLocked(false);
                            this.kdtEntrys.getCell(rowIndex, TB_EXPIREDATE).getStyleAttributes().setLocked(false);
                        } else {
                            this.kdtEntrys.getCell(rowIndex, TB_PRODUCTDATE).getStyleAttributes().setLocked(true);
                            this.kdtEntrys.getCell(rowIndex, TB_EXPIREDATE).getStyleAttributes().setLocked(true);
                            DateOfMinDurabilityInfo dod = doc.get(0);
                            this.kdtEntrys.getCell(rowIndex, TB_PRODUCTDATE).setValue((Object)dod.getMfg());
                            this.kdtEntrys.getCell(rowIndex, TB_EXPIREDATE).setValue((Object)dod.getExp());
                        }
                    }
                    catch (BOSException ex) {
                        ExceptionHandler.handle((Throwable)ex);
                    }
                }
            }
        }
    }

    private void removeListener() {
        if (this.headerF7ChangeListener != null) {
            this.prmtstorageOrgUnit.removeDataChangeListener(this.headerF7ChangeListener);
            this.prmtsupplier.removeDataChangeListener(this.headerF7ChangeListener);
            this.prmtworkshop.removeDataChangeListener(this.headerF7ChangeListener);
            this.prmtproductLine.removeDataChangeListener(this.headerF7ChangeListener);
            this.prmtclassTeam.removeDataChangeListener(this.headerF7ChangeListener);
            this.prmtclassGroup.removeDataChangeListener(this.headerF7ChangeListener);
        }
    }

    private void addListener() {
        if (this.headerF7ChangeListener == null) {
            this.headerF7ChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        DDMReceivalBillEditUI.this.headF7Changed(e);
                    }
                    catch (Exception exc) {
                        DDMReceivalBillEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtstorageOrgUnit.addDataChangeListener(this.headerF7ChangeListener);
        this.prmtsupplier.addDataChangeListener(this.headerF7ChangeListener);
        this.prmtworkshop.addDataChangeListener(this.headerF7ChangeListener);
        this.prmtproductLine.addDataChangeListener(this.headerF7ChangeListener);
        this.prmtclassTeam.addDataChangeListener(this.headerF7ChangeListener);
        this.prmtclassGroup.addDataChangeListener(this.headerF7ChangeListener);
    }

    private void headF7Changed(DataChangeEvent e) {
        Object newValue;
        Object oldValue = e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getNewValue()));
        if (!isDiffrent) {
            return;
        }
        boolean isEntryBlank = SCMClientUtils.checkEntryIsBlank((KDTable)this.kdtEntrys, (String)TB_MATERIAL_NUMBER);
        if (newValue instanceof StorageOrgUnitInfo || oldValue instanceof StorageOrgUnitInfo) {
            if (newValue == null) {
                MsgBox.showInfo((Component)((Object)this), (String)DDMReceivalBillEditUI.getResource("storageOrgNull"));
                this.prmtstorageOrgUnit.setDataNoNotify(oldValue);
                this.prmtstorageOrgUnit.requestFocus();
                return;
            }
            this.prmtsupplier.setDataNoNotify(null);
            this.prmtworkshop.setDataNoNotify(null);
            this.prmtproductLine.setDataNoNotify(null);
            this.prmtclassTeam.setDataNoNotify(null);
            this.prmtclassGroup.setDataNoNotify(null);
            this.kdtEntrys.removeRows();
            this.kdtTargetEntry.removeRows();
            this.setButtonState();
            StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)newValue;
            CompanyOrgUnitInfo companyOrgInfo = MMUtils.getCompanyOrgByStorageOrg((String)storageOrgInfo.getId().toString());
            this.prmtcompanyOrgUnit.setValue((Object)companyOrgInfo);
            this.filterByStorageUnit(storageOrgInfo);
            this.filterSupplierF7(companyOrgInfo);
            try {
                MMUtils.initWorkshopF7((KDBizPromptBox)this.prmtworkshop, (StorageOrgUnitInfo)storageOrgInfo);
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
            return;
        }
        if (!isEntryBlank && (newValue instanceof SupplierInfo || oldValue instanceof SupplierInfo)) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)DDMReceivalBillEditUI.getResource("supplierChange")))) {
                this.kdtEntrys.removeRows();
                this.kdtTargetEntry.removeRows();
                this.setButtonState();
                return;
            }
            this.prmtsupplier.setDataNoNotify(oldValue);
            this.prmtsupplier.requestFocus();
            return;
        }
        if (!isEntryBlank) {
            if (newValue instanceof AdminOrgUnitInfo || oldValue instanceof AdminOrgUnitInfo) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)DDMReceivalBillEditUI.getResource("workShopChange")))) {
                    this.kdtEntrys.removeRows();
                    this.kdtTargetEntry.removeRows();
                    this.setButtonState();
                    return;
                }
                this.prmtworkshop.setDataNoNotify(oldValue);
                this.prmtworkshop.requestFocus();
                return;
            }
            if (newValue instanceof ProductLineInfo || oldValue instanceof ProductLineInfo) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)DDMReceivalBillEditUI.getResource("productLineChange")))) {
                    this.kdtEntrys.removeRows();
                    this.kdtTargetEntry.removeRows();
                    this.setButtonState();
                    return;
                }
                this.prmtproductLine.setDataNoNotify(oldValue);
                this.prmtproductLine.requestFocus();
                return;
            }
            if (newValue instanceof ClassTeamEntryInfo || oldValue instanceof ClassTeamEntryInfo) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)DDMReceivalBillEditUI.getResource("classTeamChange")))) {
                    this.kdtEntrys.removeRows();
                    this.kdtTargetEntry.removeRows();
                    this.setButtonState();
                    return;
                }
                this.prmtclassTeam.setDataNoNotify(oldValue);
                this.prmtclassTeam.requestFocus();
                return;
            }
            if (newValue instanceof ClassGroupInfo || oldValue instanceof ClassGroupInfo) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)DDMReceivalBillEditUI.getResource("classGroupChange")))) {
                    this.kdtEntrys.removeRows();
                    this.kdtTargetEntry.removeRows();
                    this.setButtonState();
                    return;
                }
                this.prmtclassGroup.setDataNoNotify(oldValue);
                this.prmtclassGroup.requestFocus();
                return;
            }
        }
    }

    private void initF7Filter() throws Exception {
        CompanyOrgUnitInfo companyOrgInfo = null;
        StorageOrgUnitInfo storageOrgInfo = null;
        storageOrgInfo = this.editData.getStorageOrgUnit();
        companyOrgInfo = this.editData.getCompanyOrgUnit();
        if (storageOrgInfo == null) {
            return;
        }
        if (companyOrgInfo == null) {
            companyOrgInfo = MMUtils.getCompanyOrgByStorageOrg((String)storageOrgInfo.getId().toString());
            this.prmtcompanyOrgUnit.setValue((Object)companyOrgInfo);
        }
        this.filterByStorageUnit(storageOrgInfo);
        this.filterSupplierF7(companyOrgInfo);
        MMUtils.initWorkshopF7((KDBizPromptBox)this.prmtworkshop, (StorageOrgUnitInfo)storageOrgInfo);
        this.initWarehouseF7(storageOrgInfo);
        this.initStockerF7(storageOrgInfo);
    }

    protected void setEntryAssistProperty(IRow curRow, MaterialInfo materialInfo) {
        if (materialInfo == null) {
            return;
        }
        AsstAttrTypeInfo asst = materialInfo.getAssistAttr();
        if (asst != null) {
            KDBizPromptBox prmtAssistProperty = new KDBizPromptBox();
            SCMClientUtils.setF7MaterialAssistProperty((KDBizPromptBox)prmtAssistProperty, (String)materialInfo.getId().toString(), (SCMBillEditUI)this);
            prmtAssistProperty.setDisplayFormat("$number$");
            curRow.getCell(TB_ASSISTPROPERTY).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAssistProperty));
        }
    }

    private void initStockerF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        KDBizPromptBox kDBizPromptBoxStocker = new KDBizPromptBox();
        kDBizPromptBoxStocker = SCMClientUtils.setStockerF7ByStorageOrg((KDBizPromptBox)kDBizPromptBoxStocker, (StorageOrgUnitInfo)storageOrgInfo, (CoreUI)this);
        this.kdtEntrys.getColumn(TB_STOCKER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxStocker));
    }

    private void initWarehouseF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        KDBizPromptBox kDBizPromptBoxWarehouse = new KDBizPromptBox();
        kDBizPromptBoxWarehouse.setEditable(true);
        kDBizPromptBoxWarehouse.setDisplayFormat("$number$");
        kDBizPromptBoxWarehouse.setEditFormat("$number$");
        kDBizPromptBoxWarehouse.setCommitFormat("$number$");
        kDBizPromptBoxWarehouse.setEntityViewInfo(SCMClientUtils.getWarehouseFilter((StorageOrgUnitInfo)storageOrgInfo, (int)-1));
        kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("whman.id"));
        selectors.add(new SelectorItemInfo("whman.number"));
        selectors.add(new SelectorItemInfo("whman.name"));
        kDBizPromptBoxWarehouse.setSelectorCollection(selectors);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn(TB_WAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
        this.kdtEntrys.getColumn(TB_WAREHOUSE).setRenderer((IBasicRender)avr);
    }

    private void filterByStorageUnit(StorageOrgUnitInfo storageOrgInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtproductLine.setEntityViewInfo(viewInfo);
        this.prmtclassTeam.setEntityViewInfo(viewInfo);
        this.prmtclassGroup.setEntityViewInfo(viewInfo);
    }

    private void filterSupplierF7(CompanyOrgUnitInfo companyOrgUnitInfo) {
        this.setBizSupplierF7(this.prmtsupplier, null, null);
        EntityViewInfo evi = null;
        if (companyOrgUnitInfo != null) {
            this.prmtsupplier.setCurrentMainBizOrgUnit((OrgUnitInfo)companyOrgUnitInfo, OrgType.Storage);
            evi = SCMGroupClientUtils.getApproved4SupplierF7Filter((OrgType)OrgType.Storage);
            evi.getFilter().getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        } else {
            evi = new EntityViewInfo();
        }
        this.prmtsupplier.setEntityViewInfo(evi);
        this.prmtsupplier.setDisplayFormat("$name$");
    }

    private void setHeadFieldsState() {
        if (this.editData.getSourceType() != null && this.editData.getSourceType().getValue() == 10) {
            this.prmtsupplier.setRequired(true);
        }
        if (this.editData.getSourceType() != null && this.editData.getSourceType().getValue() != 10 || BillBaseStatusEnum.AUDITED.equals((Object)this.editData.getBaseStatus()) || "VIEW".equals(this.getOprtState())) {
            this.prmtsupplier.setAccessAuthority(1);
            this.prmtworkshop.setAccessAuthority(1);
            this.prmtproductLine.setAccessAuthority(1);
            this.prmtclassTeam.setAccessAuthority(1);
            this.prmtclassGroup.setAccessAuthority(1);
            this.pkBizDate.setAccessAuthority(1);
        } else {
            this.prmtsupplier.setAccessAuthority(0);
            this.prmtworkshop.setAccessAuthority(0);
            this.prmtproductLine.setAccessAuthority(0);
            this.prmtclassTeam.setAccessAuthority(0);
            this.prmtclassGroup.setAccessAuthority(0);
            this.pkBizDate.setAccessAuthority(0);
        }
    }

    private void setEntryFieldsState() {
        if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
            MaterialInventoryInfo inventoryInfo = null;
            MaterialInfo materialInfo = null;
            MeasureUnitInfo assistUnit = null;
            IRow row = null;
            for (int i = 0; i < this.kdtEntrys.getRowCount3(); ++i) {
                inventoryInfo = this.editData.getEntrys().get(i).getMaterialInventory();
                materialInfo = this.editData.getEntrys().get(i).getMaterial();
                if (inventoryInfo == null || materialInfo == null) {
                    return;
                }
                row = this.kdtEntrys.getRow(i);
                if (materialInfo.getAssistAttr() != null) {
                    SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntrys, (String)TB_ASSISTPROPERTY, (int)i, (boolean)true);
                    SCMClientUtils.lockCells((IRow)row, (String[])new String[]{TB_ASSISTPROPERTY}, (boolean)false);
                } else {
                    SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntrys, (String)TB_ASSISTPROPERTY, (int)i, (boolean)false);
                    SCMClientUtils.lockCells((IRow)row, (String[])new String[]{TB_ASSISTPROPERTY}, (boolean)true);
                }
                if (inventoryInfo.isIsLotNumber()) {
                    SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntrys, (String)TB_LOTNUMBER, (int)i, (boolean)true);
                    SCMClientUtils.lockCells((IRow)row, (String[])new String[]{TB_LOTNUMBER}, (boolean)false);
                } else {
                    SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntrys, (String)TB_LOTNUMBER, (int)i, (boolean)false);
                    SCMClientUtils.lockCells((IRow)row, (String[])new String[]{TB_LOTNUMBER}, (boolean)true);
                }
                if (inventoryInfo.isIsPeriodValid()) {
                    SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntrys, (String)TB_PRODUCTDATE, (int)i, (boolean)true);
                    SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntrys, (String)TB_EXPIREDATE, (int)i, (boolean)true);
                    SCMClientUtils.lockCells((IRow)row, (String[])new String[]{TB_PRODUCTDATE, TB_EXPIREDATE}, (boolean)false);
                } else {
                    SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntrys, (String)TB_PRODUCTDATE, (int)i, (boolean)false);
                    SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntrys, (String)TB_EXPIREDATE, (int)i, (boolean)false);
                    SCMClientUtils.lockCells((IRow)row, (String[])new String[]{TB_PRODUCTDATE, TB_EXPIREDATE}, (boolean)true);
                }
                assistUnit = (MeasureUnitInfo)this.kdtEntrys.getCell(i, TB_ASSISTUNIT).getValue();
                row = this.kdtEntrys.getRow(i);
                String[] colNames = new String[]{TB_ASSISTQTY};
                if (assistUnit == null) {
                    SCMClientUtils.lockCells((IRow)row, (String[])colNames, (boolean)true);
                    continue;
                }
                SCMClientUtils.lockCells((IRow)row, (String[])colNames, (boolean)false);
            }
        }
    }

    private void setButtonState() {
        if (this.editData.getSourceType() != null && this.kdtEntrys != null && this.kdtEntrys.getRowCount3() > 0) {
            this.actionSendTo.setEnabled(true);
        } else {
            this.actionSendTo.setEnabled(false);
        }
        if (this.editData.getSourceType() != null && this.editData.getSourceType().getValue() == 10 && !"VIEW".equalsIgnoreCase(this.getOprtState())) {
            this.actionCreateFrom.setEnabled(true);
        } else {
            this.actionCreateFrom.setEnabled(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSendTo.setIcon(EASResource.getIcon((String)"imgTbtn_seeallot"));
        this.menuItemSendTo.setIcon(EASResource.getIcon((String)"imgTbtn_seeallot"));
        this.chkMenuItemSubmitAndAddNew.setText("  " + this.chkMenuItemSubmitAndAddNew.getText() + "(F)");
        this.menuSubmitOption.setIcon(EASResource.getIcon((String)"imgTbtn_descryrefer"));
        this.chkMenuItemSubmitAndAddNew.setMnemonic(70);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("workshop.id"));
        sic.add(new SelectorItemInfo("workshop.name"));
        sic.add(new SelectorItemInfo("workshop.number"));
        sic.add(new SelectorItemInfo("productLine.id"));
        sic.add(new SelectorItemInfo("productLine.name"));
        sic.add(new SelectorItemInfo("productLine.number"));
        sic.add(new SelectorItemInfo("classTeam.id"));
        sic.add(new SelectorItemInfo("classTeam.name"));
        sic.add(new SelectorItemInfo("classTeam.number"));
        sic.add(new SelectorItemInfo("classGroup.id"));
        sic.add(new SelectorItemInfo("classGroup.name"));
        sic.add(new SelectorItemInfo("classGroup.number"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("modifier.id"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.add(new SelectorItemInfo("modifier.number"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.material.id"));
        sic.add(new SelectorItemInfo("entrys.material.number"));
        sic.add(new SelectorItemInfo("entrys.material.name"));
        sic.add(new SelectorItemInfo("entrys.material.model"));
        sic.add(new SelectorItemInfo("entrys.material.assistAttr"));
        sic.add(new SelectorItemInfo("entrys.assistProperty.*"));
        sic.add(new SelectorItemInfo("entrys.unit.*"));
        sic.add(new SelectorItemInfo("entrys.trackNumber.*"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.*"));
        sic.add(new SelectorItemInfo("entrys.warehouse.id"));
        sic.add(new SelectorItemInfo("entrys.warehouse.name"));
        sic.add(new SelectorItemInfo("entrys.warehouse.number"));
        sic.add(new SelectorItemInfo("entrys.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("entrys.stocker.id"));
        sic.add(new SelectorItemInfo("entrys.stocker.name"));
        sic.add(new SelectorItemInfo("entrys.stocker.number"));
        sic.add(new SelectorItemInfo("entrys.location.id"));
        sic.add(new SelectorItemInfo("entrys.location.name"));
        sic.add(new SelectorItemInfo("entrys.location.number"));
        sic.add(new SelectorItemInfo("entrys.assistUnit.id"));
        sic.add(new SelectorItemInfo("entrys.assistUnit.name"));
        sic.add(new SelectorItemInfo("entrys.assistUnit.number"));
        sic.add(new SelectorItemInfo("entrys.purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("entrys.purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("entrys.purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("entrys.materialInventory.*"));
        sic.add(new SelectorItemInfo("entrys.purOrder.*"));
        sic.add(new SelectorItemInfo("entrys.purOrderEntry.*"));
        sic.add(new SelectorItemInfo("entrys.finishedRpt.id"));
        sic.add(new SelectorItemInfo("entrys.finishedRptEntry.id"));
        sic.add(new SelectorItemInfo("entrys.finishedRptCR.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entrys.targetEntry.*"));
        sic.add(new SelectorItemInfo("entrys.targetEntry.productionOrder.id"));
        sic.add(new SelectorItemInfo("entrys.targetEntry.productionOrder.name"));
        sic.add(new SelectorItemInfo("entrys.targetEntry.productionOrder.number"));
        sic.add(new SelectorItemInfo("entrys.targetEntry.stockEntry.id"));
        sic.add(new SelectorItemInfo("entrys.targetEntry.stockEntry.lineSeq"));
        sic.add(new SelectorItemInfo("entrys.targetEntry.unit.*"));
        sic.add(new SelectorItemInfo("entrys.targetEntry.baseUnit.*"));
        return sic;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        DDMReceivalBillInfo objectValue = new DDMReceivalBillInfo();
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        DateFormat df = CtrlFormatUtilities.getDateFormat();
        Date currentDate = null;
        try {
            currentDate = df.parse(df.format(new Date()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        objectValue.setBizDate(currentDate);
        objectValue.setSourceType(DDMSourceBillTypeEnum.purOrder);
        return objectValue;
    }

    protected void applyBillDefaultValue(IObjectValue vo) {
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"EVuaJtWZ4kKbRG9czgLdmkY+1VI="));
        ((DDMReceivalBillInfo)vo).setBillType(billTypeInfo);
        super.applyBillDefaultValue(vo);
    }

    protected String getBillTypeId() {
        return "EVuaJtWZ4kKbRG9czgLdmkY+1VI=";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DDMReceivalBillFactory.getRemoteInstance();
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtstorageOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtstorageOrgUnit;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "mm_dDMReceivalBill_addNew";
        }
        return null;
    }

    protected String getOnloadPermItemName() {
        if ("ADDNEW".equalsIgnoreCase(this.getOprtState())) {
            return "mm_dDMReceivalBill_addNew";
        }
        return null;
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    protected boolean isModifySave() {
        return this.editData.getBaseStatus() != BillBaseStatusEnum.SUBMITED;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.DDMReceivalBillResource", (String)strKey);
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        this.setButtonState();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if ("EDIT".equals(this.getOprtState())) {
            this.btnEdit.setEnabled(false);
        }
        this.setButtonState();
        this.setHeadFieldsState();
        this.setEntryFieldsState();
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.validateBeforeCreateFrom();
        this.storeFields();
        DDMReceivalBillInfo ddmInfo = (DDMReceivalBillInfo)this.editData.clone();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)this.getMainBizOrgType(), this.getMainOrgContext().get((Object)this.getMainBizOrgType()));
        uiContext.put((Object)IN_DATA, (Object)ddmInfo);
        IUIWindow uiWindow = UIHelper.openUIWindow((UIContext)uiContext, (String)DDMReceivalCreateFromUI.class.getName());
        DDMReceivalCreateFromUI ui = (DDMReceivalCreateFromUI)uiWindow.getUIObject();
        Map context = ui.getUIContext();
        Integer retrunState = (Integer)context.get(RTN_STATE);
        if (null != retrunState && retrunState == 0) {
            DDMReceivalBillEntryCollection rtnEntryCollection = (DDMReceivalBillEntryCollection)((Object)context.get(OUT_DATA));
            this.editData.getEntrys().addCollection(rtnEntryCollection);
            this.loadFields();
            this.loadTargetEntry();
        } else {
            DDMReceivalBillEditUI.abort((CoreUI)this);
        }
    }

    private void loadTargetEntry() {
        for (int i = 0; i < this.kdtEntrys.getRowCount3(); ++i) {
            this.kdtEntrys.getSelectManager().select(i, 0);
        }
        this.kdtEntrys.getSelectManager().select(0, 0);
    }

    @Override
    public void actionSendTo_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        DDMReceivalBillInfo ddmInfo = (DDMReceivalBillInfo)this.editData.clone();
        boolean isOnlyView = false;
        if (this.getOprtState().equals(OprtState.VIEW) || this.editData.getSourceType().getValue() != 10) {
            isOnlyView = true;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)this.getMainBizOrgType(), this.getMainOrgContext().get((Object)this.getMainBizOrgType()));
        uiContext.put((Object)IN_DATA, (Object)ddmInfo);
        uiContext.put((Object)IN_STATE, (Object)isOnlyView);
        IUIWindow uiWindow = UIHelper.openUIWindow((UIContext)uiContext, (String)DDMReceivalTargetUI.class.getName());
        DDMReceivalTargetUI ui = (DDMReceivalTargetUI)uiWindow.getUIObject();
        Map context = ui.getUIContext();
        Integer retrunState = (Integer)context.get(RTN_STATE);
        if (null != retrunState && retrunState == 0) {
            DDMReceivalBillEntryCollection rtnEntryCollection = (DDMReceivalBillEntryCollection)((Object)context.get(OUT_DATA));
            this.editData.getEntrys().clear();
            this.editData.getEntrys().addCollection(rtnEntryCollection);
            this.loadFields();
            this.loadTargetEntry();
        } else {
            DDMReceivalBillEditUI.abort((CoreUI)this);
        }
    }

    private void validateBeforeCreateFrom() {
        if (this.prmtsupplier.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)DDMReceivalBillEditUI.getResource("supplierFirst"));
            this.prmtsupplier.requestFocus();
            SysUtil.abort();
        }
    }

    private static void abort(CoreUI currentUi) {
        currentUi.setCursorOfDefault();
        SysUtil.abort();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.mm.control.app.DDMReceivalBillForPrintQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/MM/CONTROL/pm/DDMReceivalBill";
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            return;
        }
        BillBaseStatusEnum billBaseStatus = this.editData.getBaseStatus();
        if (this.editData.getId() == null || billBaseStatus != null && (billBaseStatus.getValue() == 0 || billBaseStatus.getValue() == 1)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"CanPrintAndPrintView"));
            SysUtil.abort();
        }
        this.invokePrintFunction(false);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            return;
        }
        BillBaseStatusEnum billBaseStatus = this.editData.getBaseStatus();
        if (this.editData.getId() == null || billBaseStatus != null && (billBaseStatus.getValue() == 0 || billBaseStatus.getValue() == 1)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"CanPrintAndPrintView"));
            SysUtil.abort();
        }
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(true);
    }
}

