/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.IProductLine;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.control.DDMSourceBillTypeEnum;
import com.kingdee.eas.mm.control.client.AbstractDDMReceivalBillFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class DDMReceivalBillFilterUI
extends AbstractDDMReceivalBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DDMReceivalBillFilterUI.class);
    private Timestamp[] dates = SCMUtils.getDefaultDateRange(null);

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_dDMReceivalBill_view");
        this.setBizSupplierF7(this.prmtSupplier, null);
        this.prmtSupplier.setDisplayFormat("$name$");
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, DDMReceivalBillFilterUI.getResource("storageOrgNull")));
        elements.add((FilterElement)mainOrgElement);
        this.setIsSupportMultiOrgs(true);
        elements.add((FilterElement)new SingleFilterElement("supplier.number", (Component)this.prmtSupplier));
        this.prmtWorkShop.setEnabledMultiSelection(true);
        elements.add((FilterElement)new SingleFilterElement("workshop.number", (Component)this.prmtWorkShop));
        this.prmtProductLine.setEnabledMultiSelection(true);
        elements.add((FilterElement)new SingleFilterElement("productLine.number", (Component)this.prmtProductLine));
        RangeFilterElement elementBizDate = new RangeFilterElement("bizDate", (Component)this.bizDateFrom, (Component)this.bizDateTo);
        elementBizDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elementBizDate.setDefaultValue((Object)this.dates);
        elements.add((FilterElement)elementBizDate);
        elements.add((FilterElement)new SingleFilterElement("sourceType", (Component)this.sourceType, (Object)DDMSourceBillTypeEnum.NULL));
        this.status.removeAllItems();
        this.status.addItem((Object)BillBaseStatusEnum.NULL);
        this.status.addItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
        this.status.addItem((Object)BillBaseStatusEnum.SUBMITED);
        this.status.addItem((Object)BillBaseStatusEnum.AUDITED);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.status, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtWorkShop, this.prmtProductLine});
        this.f7Manager.registerContextChangeF7(this.prmtProductLine, "storageOrgUnit.id");
    }

    private String transformNumberArray(KDBizPromptBox control) {
        String ids = control.getText();
        if (ids == null || ids != null && ids.length() == 0) {
            return null;
        }
        return ids.replaceAll(" ", "").replaceAll(";", "','");
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            CoreBaseCollection items;
            String numbers = this.transformNumberArray(this.prmtSupplier);
            if (numbers != null) {
                ISupplier supplier = SupplierFactory.getRemoteInstance();
                items = supplier.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtSupplier.setValue((Object)items.toArray());
            }
            if ((numbers = this.transformNumberArray(this.prmtWorkShop)) != null) {
                IAdminOrgUnit admin = AdminOrgUnitFactory.getRemoteInstance();
                items = admin.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtWorkShop.setValue((Object)items.toArray());
            }
            if ((numbers = this.transformNumberArray(this.prmtProductLine)) != null) {
                IProductLine prodLine = ProductLineFactory.getRemoteInstance();
                items = prodLine.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtProductLine.setValue((Object)items.toArray());
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.DDMReceivalBillResource", (String)strKey);
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }
}

