/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ProductionStrategyHelper;
import com.kingdee.eas.mm.control.AbstractDDMReceivalBillEntryInfo;
import com.kingdee.eas.mm.control.AbstractDDMReceivalBillEntryTargetEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryCollection;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryTargetEntryCollection;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryTargetEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillInfo;
import com.kingdee.eas.mm.control.IProductionOrderStockEntry;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.client.AbstractDDMReceivalCreateFromUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class DDMReceivalCreateFromUI
extends AbstractDDMReceivalCreateFromUI {
    private static final Logger logger = CoreUIObject.getLogger(DDMReceivalCreateFromUI.class);
    protected F7ContextManager f7Manager = null;
    private static final String IN_DATA = "inData";
    private static final String OUT_DATA = "outData";
    private static final String RTN_STATE = "retrunState";
    private KDTEditAdapter purEntryEditAdapter;
    private KDTEditAdapter stockEntryEditAdapter;
    private KDTSelectListener purEntrySelected;
    private DDMReceivalBillInfo inInfo = null;
    private DDMReceivalBillEntryCollection cacheEntryColl = null;
    Map mmuMap = null;
    String[] qtyFieldNames = new String[]{"receiveQty", "receivableQty"};
    private static final String TB_ReceivableQty = "receivableQty";
    private static final String TB_ReceiveQty = "receiveQty";
    private static final String TB_ID = "id";
    private static final String TB_UNIT = "unit";
    private static final String TB_BSRECEIVEQTY = "baseReceiveQty";
    private static final String TB_BSRECEIVABLEQTY = "bsReceivableQty";
    private static final String TB_PURORGUNIT = "purchaseOrgUnit";
    private static final String TB_PURORDER = "purOrder";
    private static final String TB_PURENTRYSEQ = "purEntrySeq";
    private static final String TB_MATERIAL_NUMBER = "materialNumber";
    private static final String TB_MATERIAL_ID = "materialID";
    private static final String TB_MATERIAL_NAME = "materialName";
    private static final String TB_MATERIAL_MODEL = "materialModel";
    private static final String TB_DELIVERYDATE = "deliveryDate";
    private static final String TB_TRACENUMBER = "traceNumber";
    private static final String TB_TRACENUMBERID = "traceNumberID";
    private static final String TB_TRACENUMBER_ORDER = "trackNumber";
    private static final String TB_PRODUCTIONORDER = "productionOrder";
    private static final String TB_LINESEQ = "lineSeq";
    private static final String TB_STARTDATE = "startDate";
    private static final String TB_ENDDATE = "endDate";
    private static final String TB_STOCKENTRY = "stockEntry";
    private static final Category psbeInfo = null;
    private static final String[] PUR_DATETIMES = new String[]{"deliveryDate"};
    private static final String[] POE_DATETIMES = new String[]{"startDate", "endDate"};

    public DDMReceivalCreateFromUI() throws Exception {
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
        this.cacheEntryColl = new DDMReceivalBillEntryCollection();
        this.mmuMap = new HashMap();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.inInfo = (DDMReceivalBillInfo)this.getUIContext().get(IN_DATA);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.initCellEditor();
        EditTableUtil.formatColDateTime((KDTable)this.purOrderEntry, (String[])PUR_DATETIMES);
        EditTableUtil.formatColDateTime((KDTable)this.stockEntry, (String[])POE_DATETIMES);
        this.purOrderEntry.getActionMap().remove("Delete");
        this.stockEntry.getActionMap().remove("Delete");
        this.purOrderEntry.getSelectManager().setSelectMode(2);
        this.pkDeliverDate.setTimeEnabled(true);
        this.pkReqDate.setTimeEnabled(true);
        this.pkDeliverDate.setValue(null);
        this.pkReqDate.setValue(null);
        try {
            StorageOrgUnitInfo orgInfo = this.inInfo.getStorageOrgUnit();
            this.initMaterialF7(orgInfo);
            this.initPurOrderF7(orgInfo);
            this.initProductionOrderF7(orgInfo);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void initCellEditor() {
        KDFormattedTextField qtyField = null;
        qtyField = new KDFormattedTextField(1);
        qtyField.setPrecision(8);
        qtyField.setNegatived(false);
        this.purOrderEntry.getColumn(TB_ReceiveQty).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)qtyField));
        qtyField = new KDFormattedTextField(1);
        qtyField.setPrecision(8);
        qtyField.setNegatived(false);
        this.stockEntry.getColumn(TB_ReceiveQty).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)qtyField));
    }

    private void initMaterialF7(StorageOrgUnitInfo orgInfo) throws Exception {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(this.prmtMaterial, null, queryInfo, (OrgUnitInfo)orgInfo, OrgType.Storage, true, true);
        this.prmtMaterial.setDisplayFormat("$name$");
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1), CompareType.EQUALS));
        if (orgInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        }
        eview.setFilter(filter);
        this.prmtMaterial.setEntityViewInfo(eview);
    }

    private void initPurOrderF7(StorageOrgUnitInfo orgInfo) throws Exception {
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String supplierId = this.inInfo.getSupplier().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        eview.setFilter(filter);
        this.prmtPurOrder.setEntityViewInfo(eview);
        this.prmtPurOrder.setEnabledMultiSelection(true);
    }

    private void initProductionOrderF7(StorageOrgUnitInfo orgInfo) throws Exception {
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.inInfo == null) {
            return;
        }
        String id = null;
        if (this.inInfo.getWorkshop() != null) {
            id = this.inInfo.getWorkshop().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("workShop.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getProductLine() != null) {
            id = this.inInfo.getProductLine().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("productLine.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getClassTeam() != null) {
            id = this.inInfo.getClassTeam().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("classTeam.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getClassGroup() != null) {
            id = this.inInfo.getClassGroup().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("classGroup.id", (Object)id, CompareType.EQUALS));
        }
        String orgId = this.inInfo.getStorageOrgUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        String baseStatus = "4,5,8";
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)baseStatus, CompareType.INNER));
        eview.setFilter(filter);
        this.prmtPrdOrder.setEntityViewInfo(eview);
        this.prmtPrdOrder.setEnabledMultiSelection(true);
    }

    protected void initListener() {
        super.initListener();
        this.purEntryEditAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    DDMReceivalCreateFromUI.this.purEntry_Changed(e);
                }
                catch (Exception exc) {
                    DDMReceivalCreateFromUI.this.handUIException(exc);
                }
            }
        };
        this.purOrderEntry.addKDTEditListener((KDTEditListener)this.purEntryEditAdapter);
        this.stockEntryEditAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    DDMReceivalCreateFromUI.this.stockEntry_Changed(e);
                }
                catch (Exception exc) {
                    DDMReceivalCreateFromUI.this.handUIException(exc);
                }
            }
        };
        this.stockEntry.addKDTEditListener((KDTEditListener)this.stockEntryEditAdapter);
        this.purEntrySelected = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    DDMReceivalCreateFromUI.this.purEntry_SelectChanged(e);
                }
                catch (Exception e1) {
                    DDMReceivalCreateFromUI.this.handUIException(e1);
                }
            }
        };
        this.purOrderEntry.addKDTSelectListener(this.purEntrySelected);
    }

    private void purEntry_SelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = -1;
        rowIndex = this.purOrderEntry.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        String key = this.purOrderEntry.getCell(rowIndex, TB_ID).getValue().toString();
        DDMReceivalBillEntryInfo entryInfo = null;
        for (int i = 0; i < this.cacheEntryColl.size() && !key.equals((entryInfo = this.cacheEntryColl.get(i)).getPurOrderEntry().getId().toString()); ++i) {
        }
        if (null != entryInfo) {
            DDMReceivalBillEntryTargetEntryCollection targetEntryCollection = entryInfo.getTargetEntry();
            if (targetEntryCollection.size() == 0) {
                this.queryStockEntry();
            } else {
                String materialId = entryInfo.getMaterial().getId().toString();
                this.showOnD2(targetEntryCollection, materialId, key);
            }
        }
    }

    private void purEntry_Changed(KDTEditEvent e) throws Exception {
        Object newValue;
        Object oldValue = e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getValue()));
        if (isDiffrent) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.purOrderEntry.getColumnKey(colIndex);
            if (TB_ReceiveQty.equalsIgnoreCase(fieldName)) {
                BigDecimal receivableQty = (BigDecimal)this.purOrderEntry.getCell(rowIndex, TB_ReceivableQty).getValue();
                BigDecimal receiveQty = (BigDecimal)this.purOrderEntry.getCell(rowIndex, fieldName).getValue();
                if (receiveQty != null) {
                    // empty if block
                }
                AbstractDDMReceivalBillEntryInfo cacheEntryInfo = null;
                String key = this.purOrderEntry.getCell(rowIndex, TB_ID).getValue().toString();
                for (int i = 0; i < this.cacheEntryColl.size() && !key.equals((cacheEntryInfo = this.cacheEntryColl.get(i)).getPurOrderEntry().getId().toString()); ++i) {
                }
                cacheEntryInfo.setReceiveQty(receiveQty);
                BigDecimal bsReceiveQty = new BigDecimal("0");
                if (receiveQty != null && receiveQty.doubleValue() > 0.0) {
                    bsReceiveQty = SCMUtils.getExchangePricesionQtyForClient((String)cacheEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)cacheEntryInfo.getUnit(), (MeasureUnitInfo)cacheEntryInfo.getBaseUnit(), (BigDecimal)receiveQty);
                }
                cacheEntryInfo.setBaseReceiveQty(bsReceiveQty);
                this.purOrderEntry.getCell(rowIndex, TB_BSRECEIVEQTY).setValue((Object)bsReceiveQty);
            }
        }
    }

    private void stockEntry_Changed(KDTEditEvent e) throws Exception {
        Object newValue;
        Object oldValue = e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getValue()));
        if (isDiffrent) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.stockEntry.getColumnKey(colIndex);
            if (TB_ReceiveQty.equalsIgnoreCase(fieldName)) {
                DDMReceivalBillEntryTargetEntryCollection cacheTargetCollection;
                BigDecimal receivableQty = (BigDecimal)this.stockEntry.getCell(rowIndex, TB_ReceivableQty).getValue();
                BigDecimal receiveQty = (BigDecimal)this.stockEntry.getCell(rowIndex, fieldName).getValue();
                if (receiveQty != null) {
                    // empty if block
                }
                int d1RowIndex = this.stockEntry.getSelectManager().getActiveRowIndex();
                String keyD1 = this.stockEntry.getCell(d1RowIndex, TB_ID).getValue().toString();
                DDMReceivalBillEntryInfo entryInfo = null;
                for (int i = 0; i < this.cacheEntryColl.size() && !keyD1.equals((entryInfo = this.cacheEntryColl.get(i)).getPurOrderEntry().getId().toString()); ++i) {
                }
                String keyD2 = this.stockEntry.getCell(rowIndex, TB_STOCKENTRY).getValue().toString();
                AbstractDDMReceivalBillEntryTargetEntryInfo cacheTargetInfo = null;
                if (null != entryInfo && null != (cacheTargetCollection = entryInfo.getTargetEntry())) {
                    for (int i = 0; i < cacheTargetCollection.size() && !keyD2.equals((cacheTargetInfo = cacheTargetCollection.get(i)).getStockEntry().getId().toString()); ++i) {
                    }
                }
                cacheTargetInfo.setReceiveQty(receiveQty);
                BigDecimal bsReceiveQty = new BigDecimal("0");
                if (receiveQty != null && receiveQty.doubleValue() > 0.0) {
                    bsReceiveQty = SCMUtils.getExchangePricesionQtyForClient((String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)cacheTargetInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)receiveQty);
                }
                cacheTargetInfo.setBaseReceiveQty(bsReceiveQty);
            }
        }
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.DDMReceivalBillResource", (String)strKey);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAutoAllot.setIcon(EASResource.getIcon((String)"imgTbtn_automatching"));
        this.btnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionQueryPurOrder_actionPerformed(ActionEvent e) throws Exception {
        this.queryPurEntry();
        if (this.cacheEntryColl.size() == 0) {
            return;
        }
        if (this.purOrderEntry.getRowCount3() > 0) {
            this.purOrderEntry.getSelectManager().select(0, 0);
            this.purOrderEntry.getSelectManager().setActiveRowIndex(0);
        }
    }

    @Override
    public void actionQueryStock_actionPerformed(ActionEvent e) throws Exception {
        this.queryStockEntry();
    }

    private void queryPurEntry() throws Exception {
        int i;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object[] materialInfo = null;
        Object[] purOrderInfo = null;
        HashSet<String> hs = null;
        if (this.prmtMaterial.getValue() != null) {
            hs = new HashSet<String>();
            materialInfo = (Object[])this.prmtMaterial.getValue();
            for (i = 0; i < materialInfo.length && materialInfo[i] != null; ++i) {
                hs.add(((MaterialInfo)materialInfo[i]).getId().toString());
            }
            if (hs.size() != 0) {
                filter.getFilterItems().add(new FilterItemInfo("material.id", hs, CompareType.INCLUDE));
            }
        }
        if (this.prmtPurOrder.getValue() != null) {
            hs = new HashSet();
            purOrderInfo = (Object[])this.prmtPurOrder.getValue();
            for (i = 0; i < purOrderInfo.length && purOrderInfo[i] != null; ++i) {
                hs.add(((PurOrderInfo)purOrderInfo[i]).getId().toString());
            }
            if (hs.size() != 0) {
                filter.getFilterItems().add(new FilterItemInfo("parent.id", hs, CompareType.INCLUDE));
            }
        }
        if (this.pkDeliverDate.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo(TB_DELIVERYDATE, this.pkDeliverDate.getValue(), CompareType.LESS_EQUALS));
        }
        String supplierId = this.inInfo.getSupplier().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("parent.supplier.id", (Object)supplierId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(7), CompareType.NOTEQUALS));
        String orgId = this.inInfo.getStorageOrgUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        DDMReceivalBillEntryCollection inEntryCollection = this.inInfo.getEntrys();
        if (inEntryCollection.size() > 0) {
            hs = new HashSet();
            DDMReceivalBillEntryInfo entryInfo = null;
            for (int i2 = 0; i2 < inEntryCollection.size(); ++i2) {
                entryInfo = inEntryCollection.get(i2);
                hs.add(entryInfo.getPurOrderEntry().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo(TB_ID, hs, CompareType.NOTINCLUDE));
        }
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("material.*"));
        coll.add(new SelectorItemInfo("material.assistUnit.*"));
        coll.add(new SelectorItemInfo("unit.*"));
        coll.add(new SelectorItemInfo("baseUnit.*"));
        coll.add(new SelectorItemInfo("parent.*"));
        coll.add(new SelectorItemInfo("parent.purchaseOrgUnit.*"));
        coll.add(new SelectorItemInfo("trackNo.*"));
        coll.add(new SelectorItemInfo("assistProperty.id"));
        coll.add(new SelectorItemInfo("assistProperty.number"));
        coll.add(new SelectorItemInfo("assistProperty.name"));
        coll.add(new SelectorItemInfo("assistProperty.type"));
        view.setSelector(coll);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo(TB_DELIVERYDATE));
        sorter.add(new SorterItemInfo("parent.number"));
        view.setSorter(sorter);
        IPurOrderEntry iPurEntry = PurOrderEntryFactory.getRemoteInstance();
        PurOrderEntryCollection purEntryColl = iPurEntry.getPurOrderEntryCollection(view);
        this.updateCacheD1(purEntryColl);
    }

    private void queryStockEntry() throws Exception {
        int d1RowIndex = this.purOrderEntry.getSelectManager().getActiveRowIndex();
        if (d1RowIndex == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)DDMReceivalCreateFromUI.getResource("d1NotSelected"));
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object[] prdOrderInfo = null;
        HashSet<String> hs = null;
        if (this.prmtPrdOrder.getValue() != null) {
            prdOrderInfo = (Object[])this.prmtPrdOrder.getValue();
            hs = new HashSet<String>();
            for (int i = 0; i < prdOrderInfo.length && prdOrderInfo[i] != null; ++i) {
                hs.add(((ProductionOrderInfo)prdOrderInfo[i]).getId().toString());
            }
            if (hs.size() != 0) {
                filter.getFilterItems().add(new FilterItemInfo("parent.id", hs, CompareType.INCLUDE));
            }
        }
        if (this.pkReqDate.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo(TB_STARTDATE, this.pkReqDate.getValue(), CompareType.LESS_EQUALS));
        }
        String id = null;
        if (this.inInfo.getWorkshop() != null) {
            id = this.inInfo.getWorkshop().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("parent.workShop.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getProductLine() != null) {
            id = this.inInfo.getProductLine().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("parent.productLine.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getClassTeam() != null) {
            id = this.inInfo.getClassTeam().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("parent.classTeam.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getClassGroup() != null) {
            id = this.inInfo.getClassGroup().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("parent.classGroup.id", (Object)id, CompareType.EQUALS));
        }
        String orgId = this.inInfo.getStorageOrgUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        String baseStatus = "4,5,8";
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)baseStatus, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("issMode", (Object)new Integer(11050), CompareType.EQUALS));
        String materialNumber = (String)this.purOrderEntry.getCell(d1RowIndex, TB_MATERIAL_NUMBER).getValue();
        filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialNumber, CompareType.EQUALS));
        String materialID = (String)this.purOrderEntry.getCell(d1RowIndex, TB_MATERIAL_ID).getValue();
        String trackNumberID = (String)this.purOrderEntry.getCell(d1RowIndex, TB_TRACENUMBERID).getValue();
        if (ProductionStrategyHelper.isATO20orMTO20(null, (String)materialID, (String)orgId) && trackNumberID != null) {
            filter.getFilterItems().add(new FilterItemInfo("parent.trackNumber.id", (Object)trackNumberID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("unit.*"));
        coll.add(new SelectorItemInfo("baseUnit.*"));
        coll.add(new SelectorItemInfo("parent.*"));
        coll.add(new SelectorItemInfo("parent.trackNumber.*"));
        view.setSelector(coll);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo(TB_STARTDATE));
        sorter.add(new SorterItemInfo("parent.number"));
        view.setSorter(sorter);
        IProductionOrderStockEntry iStockEntry = ProductionOrderStockEntryFactory.getRemoteInstance();
        ProductionOrderStockEntryCollection stockEntryColl = iStockEntry.getProductionOrderStockEntryCollection(view);
        this.updateCacheD2(stockEntryColl);
    }

    private void updateCacheD1(PurOrderEntryCollection entryColl) throws Exception {
        this.cacheEntryColl.clear();
        DDMReceivalBillEntryCollection entryCollection = this.convertToEntryCollection(entryColl);
        this.cacheEntryColl.addCollection(entryCollection);
        this.updateMMU((IObjectCollection)entryCollection, null);
        this.showOnD1();
    }

    private void updateMMU(IObjectCollection coll, String materialIdD1) throws Exception {
        DDMReceivalBillEntryCollection entryColl = null;
        DDMReceivalBillEntryTargetEntryCollection targetColl = null;
        StringBuffer sqlWhere = new StringBuffer();
        ArrayList<String> keyList = new ArrayList<String>();
        String materialId = null;
        String unitId = null;
        String key = null;
        if (coll instanceof DDMReceivalBillEntryCollection) {
            entryColl = (DDMReceivalBillEntryCollection)coll;
        } else if (coll instanceof DDMReceivalBillEntryTargetEntryCollection) {
            targetColl = (DDMReceivalBillEntryTargetEntryCollection)coll;
        }
        for (int i = 0; i < coll.size(); ++i) {
            if (entryColl != null) {
                materialId = entryColl.get(i).getMaterial().getId().toString();
                unitId = entryColl.get(i).getUnit().getId().toString();
            } else if (targetColl != null) {
                materialId = materialIdD1;
                unitId = targetColl.get(i).getUnit().getId().toString();
            }
            key = materialId + unitId;
            if (this.mmuMap.get(key) != null || keyList.contains(key)) continue;
            keyList.add(key);
            if (sqlWhere.length() > 0) {
                sqlWhere.append("or ");
            }
            sqlWhere.append("(material.id = '").append(materialId).append("' and measureUnit.id = '").append(unitId).append("' ) ");
        }
        if (sqlWhere.length() > 0) {
            MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(" where " + sqlWhere.toString());
            int precision = 0;
            for (int i = 0; i < mmuc.size(); ++i) {
                materialId = mmuc.get(i).getMaterial().getId().toString();
                unitId = mmuc.get(i).getMeasureUnit().getId().toString();
                key = materialId + unitId;
                precision = mmuc.get(i).getQtyPrecision();
                this.mmuMap.put(key, new Integer(precision));
            }
        }
    }

    private DDMReceivalBillEntryCollection convertToEntryCollection(PurOrderEntryCollection entryColl) {
        PurOrderEntryInfo purEntryInfo = null;
        DDMReceivalBillEntryCollection entryCollection = new DDMReceivalBillEntryCollection();
        DDMReceivalBillEntryInfo entryInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            purEntryInfo = entryColl.get(i);
            entryInfo = new DDMReceivalBillEntryInfo();
            BigDecimal receivableQty = purEntryInfo.getQty().subtract(purEntryInfo.getTotalReceiptQty() == null ? new BigDecimal("0") : purEntryInfo.getTotalReceiptQty()).add(purEntryInfo.getTotalReturnedQty() == null ? new BigDecimal("0") : purEntryInfo.getTotalReturnedQty());
            BigDecimal bsReceivableQty = purEntryInfo.getQty().subtract(purEntryInfo.getTotalReceiptBaseQty() == null ? new BigDecimal("0") : purEntryInfo.getTotalReceiptBaseQty()).add(purEntryInfo.getTotalReturnedBaseQty() == null ? new BigDecimal("0") : purEntryInfo.getTotalReturnedBaseQty());
            entryInfo.setAssistProperty(purEntryInfo.getAssistProperty());
            entryInfo.setPurchaseOrgUnit(purEntryInfo.getParent().getPurchaseOrgUnit());
            entryInfo.setPurOrder(purEntryInfo.getParent());
            entryInfo.setSourceBillEntrySeq(purEntryInfo.getSeq());
            entryInfo.setMaterial(purEntryInfo.getMaterial());
            entryInfo.setUnit(purEntryInfo.getUnit());
            entryInfo.setReceivableQty(receivableQty);
            entryInfo.setDeliveryDate(purEntryInfo.getDeliveryDate());
            entryInfo.setBaseUnit(purEntryInfo.getBaseUnit());
            entryInfo.setBsReceivableQty(bsReceivableQty);
            entryInfo.setTrackNumber(purEntryInfo.getTrackNo());
            entryInfo.setAssistUnit(purEntryInfo.getMaterial().getAssistUnit());
            entryInfo.setPurOrderEntry(purEntryInfo);
            entryInfo.setSourceBillId(purEntryInfo.getParent().getId().toString());
            entryInfo.setSourceBillNumber(purEntryInfo.getParent().getNumber().toString());
            entryInfo.setSourceBillEntryId(purEntryInfo.getId().toString());
            entryInfo.setSourceBillEntrySeq(purEntryInfo.getSeq());
            entryCollection.add(entryInfo);
        }
        return entryCollection;
    }

    private void updateCacheD2(ProductionOrderStockEntryCollection entryColl) throws Exception {
        int d1RowIndex = this.purOrderEntry.getSelectManager().getActiveRowIndex();
        String key = this.purOrderEntry.getCell(d1RowIndex, TB_ID).getValue().toString();
        AbstractDDMReceivalBillEntryInfo entryInfo = null;
        for (int i = 0; i < this.cacheEntryColl.size() && !key.equals((entryInfo = this.cacheEntryColl.get(i)).getPurOrderEntry().getId().toString()); ++i) {
        }
        entryInfo.getTargetEntry().clear();
        DDMReceivalBillEntryTargetEntryCollection targetCollection = this.convertToTargetCollection(entryColl);
        entryInfo.getTargetEntry().addCollection(targetCollection);
        String materialId = entryInfo.getMaterial().getId().toString();
        this.updateMMU((IObjectCollection)targetCollection, materialId);
        this.showOnD2(targetCollection, materialId, key);
    }

    private DDMReceivalBillEntryTargetEntryCollection convertToTargetCollection(ProductionOrderStockEntryCollection entryColl) {
        DDMReceivalBillEntryTargetEntryCollection targetCollection = new DDMReceivalBillEntryTargetEntryCollection();
        ProductionOrderStockEntryInfo stockEntryInfo = null;
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            stockEntryInfo = entryColl.get(i);
            if (stockEntryInfo.getQty().compareTo(stockEntryInfo.getTotleReceiveQty()) <= 0) continue;
            targetInfo = new DDMReceivalBillEntryTargetEntryInfo();
            BigDecimal receivableQty = stockEntryInfo.getQty().subtract(stockEntryInfo.getTotleReceiveQty());
            BigDecimal bsReceivableQty = stockEntryInfo.getBaseQty().subtract(stockEntryInfo.getBaseTotleReceiveQty());
            targetInfo.setProductionOrder(stockEntryInfo.getParent());
            targetInfo.setLineSeq(stockEntryInfo.getLineSeq());
            targetInfo.setUnit(stockEntryInfo.getUnit());
            targetInfo.setReceivableQty(receivableQty);
            targetInfo.setStartDate(stockEntryInfo.getStartDate());
            targetInfo.setEndDate(stockEntryInfo.getEndDate());
            targetInfo.setStockEntry(stockEntryInfo);
            targetInfo.setBsReceivableQty(bsReceivableQty);
            targetInfo.setBaseUnit(stockEntryInfo.getBaseUnit());
            targetInfo.setConditionPdOrder((Object[])this.prmtPrdOrder.getValue());
            targetInfo.setConditionReqDate((Date)this.pkReqDate.getValue());
            targetCollection.add(targetInfo);
        }
        return targetCollection;
    }

    private void showOnD1() {
        this.purOrderEntry.removeRows();
        this.stockEntry.removeRows();
        IRow newRow = null;
        DDMReceivalBillEntryInfo cacheEntryInfo = null;
        String key = null;
        int precision = 8;
        for (int i = 0; i < this.cacheEntryColl.size(); ++i) {
            cacheEntryInfo = this.cacheEntryColl.get(i);
            newRow = this.purOrderEntry.addRow();
            newRow.getCell(TB_PURORGUNIT).setValue((Object)cacheEntryInfo.getPurchaseOrgUnit().getName());
            newRow.getCell(TB_PURORDER).setValue((Object)cacheEntryInfo.getPurOrder().getNumber());
            if (cacheEntryInfo.getTrackNumber() != null) {
                newRow.getCell(TB_TRACENUMBER).setValue((Object)cacheEntryInfo.getTrackNumber().getNumber());
                newRow.getCell(TB_TRACENUMBERID).setValue((Object)cacheEntryInfo.getTrackNumber().getId().toString());
            }
            newRow.getCell(TB_PURENTRYSEQ).setValue((Object)new Integer(cacheEntryInfo.getSourceBillEntrySeq()));
            newRow.getCell(TB_MATERIAL_ID).setValue((Object)cacheEntryInfo.getMaterial().getId().toString());
            newRow.getCell(TB_MATERIAL_NUMBER).setValue((Object)cacheEntryInfo.getMaterial().getNumber());
            newRow.getCell(TB_MATERIAL_NAME).setValue((Object)cacheEntryInfo.getMaterial().getName());
            newRow.getCell(TB_MATERIAL_MODEL).setValue((Object)cacheEntryInfo.getMaterial().getModel());
            newRow.getCell(TB_UNIT).setValue((Object)cacheEntryInfo.getUnit().getName());
            newRow.getCell(TB_ReceivableQty).setValue((Object)cacheEntryInfo.getReceivableQty());
            newRow.getCell(TB_ReceiveQty).setValue((Object)cacheEntryInfo.getReceiveQty());
            newRow.getCell(TB_DELIVERYDATE).setValue((Object)cacheEntryInfo.getDeliveryDate());
            newRow.getCell(TB_BSRECEIVABLEQTY).setValue((Object)cacheEntryInfo.getBsReceivableQty());
            newRow.getCell(TB_BSRECEIVEQTY).setValue((Object)cacheEntryInfo.getBaseReceiveQty());
            newRow.getCell(TB_ID).setValue((Object)cacheEntryInfo.getPurOrderEntry().getId().toString());
            key = cacheEntryInfo.getMaterial().getId().toString() + cacheEntryInfo.getUnit().getId().toString();
            if (this.mmuMap.containsKey(key)) {
                precision = (Integer)this.mmuMap.get(key);
            }
            SCMClientUtils.changeCellPrecision((IRow)newRow, (String[])this.qtyFieldNames, (int)precision, (boolean)false, (boolean)false);
        }
    }

    private void showOnD2(DDMReceivalBillEntryTargetEntryCollection targetCollection, String materialId, String key) {
        this.stockEntry.removeRows();
        IRow newRow = null;
        DDMReceivalBillEntryTargetEntryInfo cacheTargetInfo = null;
        String keyMMU = null;
        int precision = 8;
        for (int i = 0; i < targetCollection.size(); ++i) {
            cacheTargetInfo = targetCollection.get(i);
            newRow = this.stockEntry.addRow();
            newRow.getCell(TB_PRODUCTIONORDER).setValue((Object)cacheTargetInfo.getProductionOrder().getNumber());
            if (cacheTargetInfo.getProductionOrder().getTrackNumber() != null) {
                newRow.getCell(TB_TRACENUMBER_ORDER).setValue((Object)cacheTargetInfo.getProductionOrder().getTrackNumber().getNumber());
            }
            newRow.getCell(TB_LINESEQ).setValue((Object)cacheTargetInfo.getLineSeq());
            newRow.getCell(TB_UNIT).setValue((Object)cacheTargetInfo.getUnit().getName());
            newRow.getCell(TB_ReceivableQty).setValue((Object)cacheTargetInfo.getReceivableQty());
            newRow.getCell(TB_ReceiveQty).setValue((Object)cacheTargetInfo.getReceiveQty());
            newRow.getCell(TB_STARTDATE).setValue((Object)cacheTargetInfo.getStartDate());
            newRow.getCell(TB_ENDDATE).setValue((Object)cacheTargetInfo.getEndDate());
            newRow.getCell(TB_STOCKENTRY).setValue((Object)cacheTargetInfo.getStockEntry().getId().toString());
            newRow.getCell(TB_BSRECEIVABLEQTY).setValue((Object)cacheTargetInfo.getBsReceivableQty());
            newRow.getCell(TB_BSRECEIVEQTY).setValue((Object)cacheTargetInfo.getBaseReceiveQty());
            newRow.getCell(TB_ID).setValue((Object)key);
            this.prmtPrdOrder.setValue((Object)cacheTargetInfo.getConditionPdOrder());
            this.pkReqDate.setValue((Object)cacheTargetInfo.getConditionReqDate());
            keyMMU = materialId + cacheTargetInfo.getUnit().getId().toString();
            if (this.mmuMap.containsKey(keyMMU)) {
                precision = (Integer)this.mmuMap.get(keyMMU);
            }
            SCMClientUtils.changeCellPrecision((IRow)newRow, (String[])this.qtyFieldNames, (int)precision, (boolean)false, (boolean)false);
        }
    }

    @Override
    public void actionAutoAllot_actionPerformed(ActionEvent e) throws Exception {
        int i;
        DDMReceivalBillEntryTargetEntryCollection targetCollection;
        int d1RowIndex;
        if (this.cacheEntryColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)DDMReceivalCreateFromUI.getResource("d1Null"));
            SysUtil.abort();
        }
        if ((d1RowIndex = this.purOrderEntry.getSelectManager().getActiveRowIndex()) == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)DDMReceivalCreateFromUI.getResource("d1NotSelected"));
            SysUtil.abort();
        }
        StringBuffer msg = new StringBuffer();
        DDMReceivalBillEntryInfo entryInfo = null;
        String d1 = DDMReceivalCreateFromUI.getResource("d1");
        String d2 = DDMReceivalCreateFromUI.getResource("d2");
        String colon = DDMReceivalCreateFromUI.getResource("colon");
        String d1Prefix = d1 + (d1RowIndex + 1) + colon;
        entryInfo = this.cacheEntryColl.get(d1RowIndex);
        if (entryInfo.getReceiveQty() == null) {
            msg.append(d1Prefix).append(DDMReceivalCreateFromUI.getResource("receiveQtyNull")).append("\n");
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        if (entryInfo.getReceiveQty() != null && entryInfo.getReceiveQty().compareTo(entryInfo.getReceivableQty()) == 1) {
            msg.append(d1Prefix).append(DDMReceivalCreateFromUI.getResource("receiveQtyLarger")).append("\n");
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        if ((targetCollection = entryInfo.getTargetEntry()).size() == 0) {
            msg.append(d1Prefix).append(DDMReceivalCreateFromUI.getResource("d2Null")).append("\n");
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        BigDecimal d1BSReceiveQty = entryInfo.getBaseReceiveQty();
        BigDecimal d2BSReceivableQty = null;
        BigDecimal d2ReceiveQty = null;
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        for (i = 0; i < targetCollection.size(); ++i) {
            targetInfo = targetCollection.get(i);
            targetInfo.setBaseReceiveQty(null);
            targetInfo.setReceiveQty(null);
            this.stockEntry.getCell(i, TB_BSRECEIVEQTY).setValue(null);
            this.stockEntry.getCell(i, TB_ReceiveQty).setValue(null);
        }
        for (i = 0; i < targetCollection.size() && d1BSReceiveQty.compareTo(new BigDecimal("0")) != 0; ++i) {
            targetInfo = targetCollection.get(i);
            d2BSReceivableQty = targetInfo.getBsReceivableQty();
            if (d2BSReceivableQty.compareTo(d1BSReceiveQty) >= 0) {
                targetInfo.setBaseReceiveQty(d1BSReceiveQty);
            } else {
                targetInfo.setBaseReceiveQty(d2BSReceivableQty);
            }
            d1BSReceiveQty = d1BSReceiveQty.subtract(targetInfo.getBaseReceiveQty());
            d2ReceiveQty = SCMUtils.getExchangePricesionQtyForClient((String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (MeasureUnitInfo)targetInfo.getUnit(), (BigDecimal)targetInfo.getBaseReceiveQty());
            targetInfo.setReceiveQty(d2ReceiveQty);
            this.stockEntry.getCell(i, TB_BSRECEIVEQTY).setValue((Object)targetInfo.getBaseReceiveQty());
            this.stockEntry.getCell(i, TB_ReceiveQty).setValue((Object)d2ReceiveQty);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.validationOnConfirm();
        this.filterCacheD1();
        this.filterCacheD2();
        this.updateCacheD1Inventory();
        this.getUIContext().put(RTN_STATE, new Integer(0));
        this.getUIContext().put(OUT_DATA, this.cacheEntryColl);
        this.actionExitCurrent_actionPerformed(e);
    }

    private void updateCacheD1Inventory() throws Exception {
        DDMReceivalBillEntryInfo entryInfo = null;
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < this.cacheEntryColl.size(); ++i) {
            entryInfo = this.cacheEntryColl.get(i);
            if (entryInfo.getMaterial().getAssistUnit() != null) {
                BigDecimal assistQty = SCMUtils.getExchangePricesionQtyForClient((String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getAssistUnit(), (BigDecimal)entryInfo.getReceiveQty());
                entryInfo.setAssistQty(assistQty);
            }
            hs.add(entryInfo.getMaterial().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", hs, CompareType.INCLUDE));
        String orgId = this.inInfo.getStorageOrgUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("defaultWarehouse.*"));
        coll.add(new SelectorItemInfo("defaultWarehouse.whman.*"));
        view.setSelector(coll);
        IMaterialInventory iInventory = MaterialInventoryFactory.getRemoteInstance();
        MaterialInventoryCollection invColl = iInventory.getMaterialInventoryCollection(view);
        String materialId = null;
        MaterialInventoryInfo invInfo = null;
        for (int i = 0; i < this.cacheEntryColl.size(); ++i) {
            entryInfo = this.cacheEntryColl.get(i);
            materialId = entryInfo.getMaterial().getId().toString();
            for (int j = 0; j < invColl.size() && !materialId.equals((invInfo = invColl.get(j)).getMaterial().getId().toString()); ++j) {
            }
            entryInfo.setMaterialInventory(invInfo);
            if (invInfo != null) {
                entryInfo.setWarehouse(invInfo.getDefaultWarehouse());
            }
            if (invInfo.getDefaultWarehouse() == null) continue;
            entryInfo.setStocker(invInfo.getDefaultWarehouse().getWhman());
        }
    }

    private void filterCacheD1() {
        DDMReceivalBillEntryInfo entryInfo = null;
        for (int i = 0; i < this.cacheEntryColl.size(); ++i) {
            entryInfo = this.cacheEntryColl.get(i);
            if (entryInfo.getReceiveQty() != null && entryInfo.getReceiveQty().doubleValue() != 0.0) continue;
            this.cacheEntryColl.remove(entryInfo);
            --i;
        }
    }

    private void filterCacheD2() {
        DDMReceivalBillEntryInfo entryInfo = null;
        DDMReceivalBillEntryTargetEntryCollection targetCollection = null;
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        for (int i = 0; i < this.cacheEntryColl.size(); ++i) {
            entryInfo = this.cacheEntryColl.get(i);
            targetCollection = entryInfo.getTargetEntry();
            for (int j = 0; j < targetCollection.size(); ++j) {
                targetInfo = targetCollection.get(j);
                if (targetInfo.getReceiveQty() != null && targetInfo.getReceiveQty().doubleValue() != 0.0) continue;
                targetCollection.remove(targetInfo);
                --j;
            }
        }
    }

    private void validationOnConfirm() throws EASBizException {
        BigDecimal d1BSQty;
        String d1Prefix;
        int i;
        StringBuffer msg = new StringBuffer();
        if (this.cacheEntryColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)DDMReceivalCreateFromUI.getResource("d1Null"));
            SysUtil.abort();
        }
        DDMReceivalBillEntryInfo entryInfo = null;
        String d1 = DDMReceivalCreateFromUI.getResource("d1");
        String d2 = DDMReceivalCreateFromUI.getResource("d2");
        String colon = DDMReceivalCreateFromUI.getResource("colon");
        for (int i2 = 0; i2 < this.cacheEntryColl.size(); ++i2) {
            entryInfo = this.cacheEntryColl.get(i2);
            if (entryInfo.getReceiveQty() == null || entryInfo.getReceiveQty().compareTo(entryInfo.getReceivableQty()) != 1) continue;
            msg.append(d1).append(i2 + 1).append(colon).append(DDMReceivalCreateFromUI.getResource("receiveQtyLarger")).append("\n");
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        DDMReceivalBillEntryTargetEntryCollection targetCollection = null;
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        for (i = 0; i < this.cacheEntryColl.size(); ++i) {
            d1Prefix = d1 + (i + 1) + colon;
            entryInfo = this.cacheEntryColl.get(i);
            d1BSQty = entryInfo.getBaseReceiveQty();
            if (d1BSQty == null || d1BSQty.doubleValue() == 0.0) continue;
            targetCollection = entryInfo.getTargetEntry();
            if (targetCollection.size() == 0) {
                msg.append(d1Prefix).append(DDMReceivalCreateFromUI.getResource("d2Null")).append("\n");
                continue;
            }
            for (int j = 0; j < targetCollection.size(); ++j) {
                targetInfo = targetCollection.get(j);
                String d2Prefix = d1Prefix + d2 + (j + 1) + colon;
                if (targetInfo.getReceiveQty() == null || targetInfo.getReceiveQty().compareTo(targetInfo.getReceivableQty()) != 1) continue;
                msg.append(d2Prefix).append(DDMReceivalCreateFromUI.getResource("receiveQtyLarger")).append("\n");
            }
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        for (i = 0; i < this.cacheEntryColl.size(); ++i) {
            d1Prefix = d1 + (i + 1) + colon;
            entryInfo = this.cacheEntryColl.get(i);
            d1BSQty = entryInfo.getBaseReceiveQty();
            if (d1BSQty == null || d1BSQty.doubleValue() == 0.0) continue;
            BigDecimal totalD2BSQty = new BigDecimal("0");
            targetCollection = entryInfo.getTargetEntry();
            for (int j = 0; j < targetCollection.size(); ++j) {
                targetInfo = targetCollection.get(j);
                if (targetInfo.getReceiveQty() == null || targetInfo.getReceiveQty().doubleValue() == 0.0) continue;
                totalD2BSQty = totalD2BSQty.add(targetInfo.getBaseReceiveQty());
            }
            if (d1BSQty.compareTo(totalD2BSQty) == 0) continue;
            msg.append(d1Prefix).append(DDMReceivalCreateFromUI.getResource("d2QtyNotEqualD1Qty")).append("\n");
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
    }
}

