/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.control.AbstractDDMReceivalBillEntryInfo;
import com.kingdee.eas.mm.control.AbstractDDMReceivalBillEntryTargetEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryCollection;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryTargetEntryCollection;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryTargetEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillInfo;
import com.kingdee.eas.mm.control.IProductionOrderStockEntry;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.client.AbstractDDMReceivalTargetUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DDMReceivalTargetUI
extends AbstractDDMReceivalTargetUI {
    private static final Logger logger = CoreUIObject.getLogger(DDMReceivalTargetUI.class);
    private static final String IN_STATE = "inState";
    private static final String IN_DATA = "inData";
    private static final String OUT_DATA = "outData";
    private static final String RTN_STATE = "retrunState";
    private KDTEditAdapter purEntryEditAdapter;
    private KDTEditAdapter stockEntryEditAdapter;
    private KDTSelectListener purEntrySelected;
    private DDMReceivalBillInfo inInfo = null;
    private DDMReceivalBillEntryCollection cacheEntryColl = null;
    Map mmuMap = null;
    String[] qtyFieldNames = new String[]{"receiveQty", "receivableQty"};
    private static final String TB_ReceivableQty = "receivableQty";
    private static final String TB_ReceiveQty = "receiveQty";
    private static final String TB_ID = "id";
    private static final String TB_UNIT = "unit";
    private static final String TB_BSRECEIVEQTY = "baseReceiveQty";
    private static final String TB_BSRECEIVABLEQTY = "bsReceivableQty";
    private static final String TB_PURORGUNIT = "srcOrgUnit";
    private static final String TB_PURORDER = "srcBillNumber";
    private static final String TB_PURENTRYSEQ = "srcBillESeq";
    private static final String TB_MATERIAL_NUMBER = "materialNumber";
    private static final String TB_MATERIAL_NAME = "materialName";
    private static final String TB_MATERIAL_MODEL = "materialModel";
    private static final String TB_PRODUCTIONORDER = "productionOrder";
    private static final String TB_LINESEQ = "lineSeq";
    private static final String TB_STARTDATE = "startDate";
    private static final String TB_ENDDATE = "endDate";
    private static final String TB_STOCKENTRY = "stockEntry";
    private static final String[] PUR_DATETIMES = new String[]{"deliveryDate"};
    private static final String[] POE_DATETIMES = new String[]{"startDate", "endDate"};

    public void onLoad() throws Exception {
        super.onLoad();
        this.inInfo = (DDMReceivalBillInfo)this.getUIContext().get(IN_DATA);
        this.cacheEntryColl = this.inInfo.getEntrys();
        this.mmuMap = new HashMap();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initCellEditor();
        this.purOrderEntry.getActionMap().remove("Delete");
        this.stockEntry.getActionMap().remove("Delete");
        this.purOrderEntry.getSelectManager().setSelectMode(2);
        this.pkReqDate.setTimeEnabled(true);
        this.pkReqDate.setValue(null);
        try {
            StorageOrgUnitInfo orgInfo = this.inInfo.getStorageOrgUnit();
            this.initProductionOrderF7(orgInfo);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handleInitShow();
        EditTableUtil.formatColDateTime((KDTable)this.purOrderEntry, (String[])PUR_DATETIMES);
        EditTableUtil.formatColDateTime((KDTable)this.stockEntry, (String[])POE_DATETIMES);
    }

    private void handleInitShow() throws Exception {
        Boolean isOnlyView = (Boolean)this.getUIContext().get(IN_STATE);
        if (isOnlyView.booleanValue()) {
            this.btnAutoAllot.setEnabled(false);
            this.btnConfirm.setEnabled(false);
            this.btnStockQuery.setEnabled(false);
            this.prmtPrdOrder.setEnabled(false);
            this.pkReqDate.setEnabled(false);
            this.purOrderEntry.getColumn(TB_ReceiveQty).getStyleAttributes().setLocked(true);
            this.stockEntry.getColumn(TB_ReceiveQty).getStyleAttributes().setLocked(true);
        }
        this.updateMMU((IObjectCollection)this.cacheEntryColl, null);
        this.showOnD1();
        this.purOrderEntry.getSelectManager().select(0, 0);
        this.purOrderEntry.getSelectManager().setActiveRowIndex(0);
        String key = this.purOrderEntry.getCell(0, TB_ID).getValue().toString();
        DDMReceivalBillEntryInfo entryInfo = this.cacheEntryColl.get(0);
        String materialId = entryInfo.getMaterial().getId().toString();
        this.updateMMU((IObjectCollection)entryInfo.getTargetEntry(), materialId);
        this.showOnD2(entryInfo.getTargetEntry(), materialId, key);
    }

    private void initCellEditor() {
        KDFormattedTextField qtyField = null;
        qtyField = new KDFormattedTextField(1);
        qtyField.setPrecision(8);
        qtyField.setNegatived(false);
        this.purOrderEntry.getColumn(TB_ReceiveQty).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)qtyField));
        qtyField = new KDFormattedTextField(1);
        qtyField.setPrecision(8);
        qtyField.setNegatived(false);
        this.stockEntry.getColumn(TB_ReceiveQty).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)qtyField));
    }

    private void initProductionOrderF7(StorageOrgUnitInfo orgInfo) throws Exception {
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String id = null;
        if (this.inInfo.getWorkshop() != null) {
            id = this.inInfo.getWorkshop().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("workShop.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getProductLine() != null) {
            id = this.inInfo.getProductLine().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("productLine.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getClassTeam() != null) {
            id = this.inInfo.getClassTeam().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("classTeam.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getClassGroup() != null) {
            id = this.inInfo.getClassGroup().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("classGroup.id", (Object)id, CompareType.EQUALS));
        }
        String orgId = this.inInfo.getStorageOrgUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        String baseStatus = "4," + BillBaseStatusEnum.RELEASED;
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)baseStatus, CompareType.INNER));
        eview.setFilter(filter);
        this.prmtPrdOrder.setEntityViewInfo(eview);
        this.prmtPrdOrder.setEnabledMultiSelection(true);
    }

    protected void initListener() {
        super.initListener();
        this.purEntryEditAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    DDMReceivalTargetUI.this.purEntry_Changed(e);
                }
                catch (Exception exc) {
                    DDMReceivalTargetUI.this.handUIException(exc);
                }
            }
        };
        this.purOrderEntry.addKDTEditListener((KDTEditListener)this.purEntryEditAdapter);
        this.stockEntryEditAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    DDMReceivalTargetUI.this.stockEntry_Changed(e);
                }
                catch (Exception exc) {
                    DDMReceivalTargetUI.this.handUIException(exc);
                }
            }
        };
        this.stockEntry.addKDTEditListener((KDTEditListener)this.stockEntryEditAdapter);
        this.purEntrySelected = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    DDMReceivalTargetUI.this.purEntry_SelectChanged(e);
                }
                catch (Exception e1) {
                    DDMReceivalTargetUI.this.handUIException(e1);
                }
            }
        };
        this.purOrderEntry.addKDTSelectListener(this.purEntrySelected);
    }

    private void setFieldsPrecision(KDTable table, int rowIndex, String materialId, String measureUnitId) {
        MultiMeasureUnitInfo multiMeasureUnitInfo = null;
        String[] qtyFieldNames = new String[]{TB_ReceiveQty, TB_ReceivableQty};
        int precision = 8;
        try {
            multiMeasureUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, measureUnitId);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (multiMeasureUnitInfo != null) {
            precision = multiMeasureUnitInfo.getQtyPrecision();
        }
        SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)table, (String[])qtyFieldNames, (int)rowIndex);
    }

    private void purEntry_SelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = -1;
        rowIndex = this.purOrderEntry.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        String key = this.purOrderEntry.getCell(rowIndex, TB_ID).getValue().toString();
        DDMReceivalBillEntryInfo entryInfo = null;
        for (int i = 0; i < this.cacheEntryColl.size() && !key.equals((entryInfo = this.cacheEntryColl.get(i)).getSourceBillEntryId()); ++i) {
        }
        DDMReceivalBillEntryTargetEntryCollection targetEntryCollection = null;
        if (null != entryInfo) {
            targetEntryCollection = entryInfo.getTargetEntry();
        }
        if (targetEntryCollection.size() == 0) {
            this.queryStockEntry();
        } else {
            String materialId = entryInfo.getMaterial().getId().toString();
            this.showOnD2(targetEntryCollection, materialId, key);
        }
    }

    private void purEntry_Changed(KDTEditEvent e) throws Exception {
        Object newValue;
        Object oldValue = e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getValue()));
        if (isDiffrent) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.purOrderEntry.getColumnKey(colIndex);
            if (TB_ReceiveQty.equalsIgnoreCase(fieldName)) {
                BigDecimal receivableQty = (BigDecimal)this.purOrderEntry.getCell(rowIndex, TB_ReceivableQty).getValue();
                BigDecimal receiveQty = (BigDecimal)this.purOrderEntry.getCell(rowIndex, fieldName).getValue();
                if (receiveQty != null) {
                    // empty if block
                }
                AbstractDDMReceivalBillEntryInfo cacheEntryInfo = null;
                String key = this.purOrderEntry.getCell(rowIndex, TB_ID).getValue().toString();
                for (int i = 0; i < this.cacheEntryColl.size() && !key.equals((cacheEntryInfo = this.cacheEntryColl.get(i)).getSourceBillEntryId()); ++i) {
                }
                cacheEntryInfo.setReceiveQty(receiveQty);
                BigDecimal bsReceiveQty = new BigDecimal("0");
                if (receiveQty != null && receiveQty.doubleValue() > 0.0) {
                    bsReceiveQty = SCMUtils.getExchangePricesionQtyForClient((String)cacheEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)cacheEntryInfo.getUnit(), (MeasureUnitInfo)cacheEntryInfo.getBaseUnit(), (BigDecimal)receiveQty);
                }
                cacheEntryInfo.setBaseReceiveQty(bsReceiveQty);
                this.purOrderEntry.getCell(rowIndex, TB_BSRECEIVEQTY).setValue((Object)bsReceiveQty);
            }
        }
    }

    private void stockEntry_Changed(KDTEditEvent e) throws Exception {
        Object newValue;
        Object oldValue = e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getValue()));
        if (isDiffrent) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.stockEntry.getColumnKey(colIndex);
            if (TB_ReceiveQty.equalsIgnoreCase(fieldName)) {
                BigDecimal receivableQty = (BigDecimal)this.stockEntry.getCell(rowIndex, TB_ReceivableQty).getValue();
                BigDecimal receiveQty = (BigDecimal)this.stockEntry.getCell(rowIndex, fieldName).getValue();
                if (receiveQty != null) {
                    // empty if block
                }
                int d1RowIndex = this.stockEntry.getSelectManager().getActiveRowIndex();
                String keyD1 = this.stockEntry.getCell(d1RowIndex, TB_ID).getValue().toString();
                DDMReceivalBillEntryInfo entryInfo = null;
                for (int i = 0; i < this.cacheEntryColl.size() && !keyD1.equals((entryInfo = this.cacheEntryColl.get(i)).getSourceBillEntryId()); ++i) {
                }
                String keyD2 = this.stockEntry.getCell(rowIndex, TB_STOCKENTRY).getValue().toString();
                DDMReceivalBillEntryTargetEntryCollection cacheTargetCollection = entryInfo.getTargetEntry();
                AbstractDDMReceivalBillEntryTargetEntryInfo cacheTargetInfo = null;
                for (int i = 0; i < cacheTargetCollection.size() && !keyD2.equals((cacheTargetInfo = cacheTargetCollection.get(i)).getStockEntry().getId().toString()); ++i) {
                }
                cacheTargetInfo.setReceiveQty(receiveQty);
                BigDecimal bsReceiveQty = new BigDecimal("0");
                if (receiveQty != null && receiveQty.doubleValue() > 0.0) {
                    bsReceiveQty = SCMUtils.getExchangePricesionQtyForClient((String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)cacheTargetInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)receiveQty);
                }
                cacheTargetInfo.setBaseReceiveQty(bsReceiveQty);
            }
        }
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.DDMReceivalBillResource", (String)strKey);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAutoAllot.setIcon(EASResource.getIcon((String)"imgTbtn_automatching"));
        this.btnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
    }

    @Override
    public void actionQueryStock_actionPerformed(ActionEvent e) throws Exception {
        this.queryStockEntry();
    }

    private void queryStockEntry() throws Exception {
        int d1RowIndex = this.purOrderEntry.getSelectManager().getActiveRowIndex();
        if (d1RowIndex == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)DDMReceivalTargetUI.getResource("d1NotSelected"));
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object[] prdOrderInfo = null;
        HashSet<String> hs = null;
        if (this.prmtPrdOrder.getValue() != null) {
            prdOrderInfo = (Object[])this.prmtPrdOrder.getValue();
            hs = new HashSet<String>();
            for (int i = 0; i < prdOrderInfo.length && prdOrderInfo[i] != null; ++i) {
                hs.add(((ProductionOrderInfo)prdOrderInfo[i]).getId().toString());
            }
            if (hs.size() != 0) {
                filter.getFilterItems().add(new FilterItemInfo("parent.id", hs, CompareType.INCLUDE));
            }
        }
        if (this.pkReqDate.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo(TB_STARTDATE, this.pkReqDate.getValue(), CompareType.LESS_EQUALS));
        }
        String id = null;
        if (this.inInfo.getWorkshop() != null) {
            id = this.inInfo.getWorkshop().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("parent.workShop.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getProductLine() != null) {
            id = this.inInfo.getProductLine().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("parent.productLine.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getClassTeam() != null) {
            id = this.inInfo.getClassTeam().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("parent.classTeam.id", (Object)id, CompareType.EQUALS));
        }
        if (this.inInfo.getClassGroup() != null) {
            id = this.inInfo.getClassGroup().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("parent.classGroup.id", (Object)id, CompareType.EQUALS));
        }
        String orgId = this.inInfo.getStorageOrgUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        String baseStatus = "4,5";
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)baseStatus, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("issMode", (Object)new Integer(11050), CompareType.EQUALS));
        String materialNumber = (String)this.purOrderEntry.getCell(d1RowIndex, TB_MATERIAL_NUMBER).getValue();
        filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialNumber, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("unit.*"));
        coll.add(new SelectorItemInfo("baseUnit.*"));
        coll.add(new SelectorItemInfo("parent.*"));
        view.setSelector(coll);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo(TB_STARTDATE));
        sorter.add(new SorterItemInfo("parent.number"));
        view.setSorter(sorter);
        IProductionOrderStockEntry iStockEntry = ProductionOrderStockEntryFactory.getRemoteInstance();
        ProductionOrderStockEntryCollection stockEntryColl = iStockEntry.getProductionOrderStockEntryCollection(view);
        this.updateCacheD2(stockEntryColl);
    }

    private void updateCacheD2(ProductionOrderStockEntryCollection entryColl) throws Exception {
        int d1RowIndex = this.purOrderEntry.getSelectManager().getActiveRowIndex();
        String key = this.purOrderEntry.getCell(d1RowIndex, TB_ID).getValue().toString();
        AbstractDDMReceivalBillEntryInfo entryInfo = null;
        for (int i = 0; i < this.cacheEntryColl.size() && !key.equals((entryInfo = this.cacheEntryColl.get(i)).getSourceBillEntryId()); ++i) {
        }
        entryInfo.getTargetEntry().clear();
        DDMReceivalBillEntryTargetEntryCollection targetCollection = this.convertToTargetCollection(entryColl);
        entryInfo.getTargetEntry().addCollection(targetCollection);
        String materialId = entryInfo.getMaterial().getId().toString();
        this.updateMMU((IObjectCollection)targetCollection, materialId);
        this.showOnD2(targetCollection, materialId, key);
    }

    private void updateMMU(IObjectCollection coll, String materialIdD1) throws Exception {
        DDMReceivalBillEntryCollection entryColl = null;
        DDMReceivalBillEntryTargetEntryCollection targetColl = null;
        StringBuffer sqlWhere = new StringBuffer();
        ArrayList<String> keyList = new ArrayList<String>();
        String materialId = null;
        String unitId = null;
        String key = null;
        if (coll instanceof DDMReceivalBillEntryCollection) {
            entryColl = (DDMReceivalBillEntryCollection)coll;
        } else if (coll instanceof DDMReceivalBillEntryTargetEntryCollection) {
            targetColl = (DDMReceivalBillEntryTargetEntryCollection)coll;
        }
        for (int i = 0; i < coll.size(); ++i) {
            if (entryColl != null) {
                materialId = entryColl.get(i).getMaterial().getId().toString();
                unitId = entryColl.get(i).getUnit().getId().toString();
            } else if (targetColl != null) {
                materialId = materialIdD1;
                unitId = targetColl.get(i).getUnit().getId().toString();
            }
            key = materialId + unitId;
            if (this.mmuMap.get(key) != null || keyList.contains(key)) continue;
            keyList.add(key);
            if (sqlWhere.length() > 0) {
                sqlWhere.append("or ");
            }
            sqlWhere.append("(material.id = '").append(materialId).append("' and measureUnit.id = '").append(unitId).append("' ) ");
        }
        if (sqlWhere.length() > 0) {
            MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(" where " + sqlWhere.toString());
            int precision = 0;
            for (int i = 0; i < mmuc.size(); ++i) {
                materialId = mmuc.get(i).getMaterial().getId().toString();
                unitId = mmuc.get(i).getMeasureUnit().getId().toString();
                key = materialId + unitId;
                precision = mmuc.get(i).getQtyPrecision();
                this.mmuMap.put(key, new Integer(precision));
            }
        }
    }

    private DDMReceivalBillEntryTargetEntryCollection convertToTargetCollection(ProductionOrderStockEntryCollection entryColl) {
        DDMReceivalBillEntryTargetEntryCollection targetCollection = new DDMReceivalBillEntryTargetEntryCollection();
        ProductionOrderStockEntryInfo stockEntryInfo = null;
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            stockEntryInfo = entryColl.get(i);
            if (stockEntryInfo.getQty().compareTo(stockEntryInfo.getTotleReceiveQty()) <= 0) continue;
            targetInfo = new DDMReceivalBillEntryTargetEntryInfo();
            BigDecimal receivableQty = stockEntryInfo.getQty().subtract(stockEntryInfo.getTotleReceiveQty());
            BigDecimal bsReceivableQty = stockEntryInfo.getBaseQty().subtract(stockEntryInfo.getBaseTotleReceiveQty());
            targetInfo.setProductionOrder(stockEntryInfo.getParent());
            targetInfo.setLineSeq(stockEntryInfo.getLineSeq());
            targetInfo.setUnit(stockEntryInfo.getUnit());
            targetInfo.setReceivableQty(receivableQty);
            targetInfo.setStartDate(stockEntryInfo.getStartDate());
            targetInfo.setEndDate(stockEntryInfo.getEndDate());
            targetInfo.setStockEntry(stockEntryInfo);
            targetInfo.setBsReceivableQty(bsReceivableQty);
            targetInfo.setBaseUnit(stockEntryInfo.getBaseUnit());
            targetInfo.setConditionPdOrder((Object[])this.prmtPrdOrder.getValue());
            targetInfo.setConditionReqDate((Date)this.pkReqDate.getValue());
            targetCollection.add(targetInfo);
        }
        return targetCollection;
    }

    private void showOnD1() {
        this.purOrderEntry.removeRows();
        IRow newRow = null;
        DDMReceivalBillEntryInfo cacheEntryInfo = null;
        String key = null;
        int precision = 8;
        for (int i = 0; i < this.cacheEntryColl.size(); ++i) {
            cacheEntryInfo = this.cacheEntryColl.get(i);
            newRow = this.purOrderEntry.addRow();
            if (this.inInfo.getSourceType().getValue() == 10) {
                newRow.getCell(TB_PURORGUNIT).setValue((Object)cacheEntryInfo.getPurchaseOrgUnit().getName());
            } else {
                newRow.getCell(TB_PURORGUNIT).setValue((Object)this.inInfo.getStorageOrgUnit().getName());
            }
            newRow.getCell(TB_PURORDER).setValue((Object)cacheEntryInfo.getSourceBillNumber());
            newRow.getCell(TB_PURENTRYSEQ).setValue((Object)new Integer(cacheEntryInfo.getSourceBillEntrySeq()));
            newRow.getCell(TB_MATERIAL_NUMBER).setValue((Object)cacheEntryInfo.getMaterial().getNumber());
            newRow.getCell(TB_MATERIAL_NAME).setValue((Object)cacheEntryInfo.getMaterial().getName());
            newRow.getCell(TB_MATERIAL_MODEL).setValue((Object)cacheEntryInfo.getMaterial().getModel());
            newRow.getCell(TB_UNIT).setValue((Object)cacheEntryInfo.getUnit().getName());
            newRow.getCell(TB_ReceivableQty).setValue((Object)cacheEntryInfo.getReceivableQty());
            newRow.getCell(TB_ReceiveQty).setValue((Object)cacheEntryInfo.getReceiveQty());
            newRow.getCell(TB_BSRECEIVABLEQTY).setValue((Object)cacheEntryInfo.getBsReceivableQty());
            newRow.getCell(TB_BSRECEIVEQTY).setValue((Object)cacheEntryInfo.getBaseReceiveQty());
            newRow.getCell(TB_ID).setValue((Object)cacheEntryInfo.getSourceBillEntryId());
            key = cacheEntryInfo.getMaterial().getId().toString() + cacheEntryInfo.getUnit().getId().toString();
            if (this.mmuMap.containsKey(key)) {
                precision = (Integer)this.mmuMap.get(key);
            }
            SCMClientUtils.changeCellPrecision((IRow)newRow, (String[])this.qtyFieldNames, (int)precision, (boolean)false, (boolean)false);
        }
    }

    private void showOnD2(DDMReceivalBillEntryTargetEntryCollection targetCollection, String materialId, String key) {
        this.stockEntry.removeRows();
        IRow newRow = null;
        DDMReceivalBillEntryTargetEntryInfo cacheTargetInfo = null;
        String keyMMU = null;
        int precision = 8;
        for (int i = 0; i < targetCollection.size(); ++i) {
            cacheTargetInfo = targetCollection.get(i);
            newRow = this.stockEntry.addRow();
            newRow.getCell(TB_PRODUCTIONORDER).setValue((Object)cacheTargetInfo.getProductionOrder().getNumber());
            newRow.getCell(TB_LINESEQ).setValue((Object)cacheTargetInfo.getLineSeq());
            newRow.getCell(TB_UNIT).setValue((Object)cacheTargetInfo.getUnit().getName());
            newRow.getCell(TB_ReceivableQty).setValue((Object)cacheTargetInfo.getReceivableQty());
            newRow.getCell(TB_ReceiveQty).setValue((Object)cacheTargetInfo.getReceiveQty());
            newRow.getCell(TB_STARTDATE).setValue((Object)cacheTargetInfo.getStartDate());
            newRow.getCell(TB_ENDDATE).setValue((Object)cacheTargetInfo.getEndDate());
            newRow.getCell(TB_STOCKENTRY).setValue((Object)cacheTargetInfo.getStockEntry().getId().toString());
            newRow.getCell(TB_BSRECEIVABLEQTY).setValue((Object)cacheTargetInfo.getBsReceivableQty());
            newRow.getCell(TB_BSRECEIVEQTY).setValue((Object)cacheTargetInfo.getBaseReceiveQty());
            newRow.getCell(TB_ID).setValue((Object)key);
            this.prmtPrdOrder.setValue((Object)cacheTargetInfo.getConditionPdOrder());
            this.pkReqDate.setValue((Object)cacheTargetInfo.getConditionReqDate());
            keyMMU = materialId + cacheTargetInfo.getUnit().getId().toString();
            if (this.mmuMap.containsKey(keyMMU)) {
                precision = (Integer)this.mmuMap.get(keyMMU);
            }
            SCMClientUtils.changeCellPrecision((IRow)newRow, (String[])this.qtyFieldNames, (int)precision, (boolean)false, (boolean)false);
        }
    }

    @Override
    public void actionAutoAllot_actionPerformed(ActionEvent e) throws Exception {
        int i;
        DDMReceivalBillEntryTargetEntryCollection targetCollection;
        int d1RowIndex;
        if (this.cacheEntryColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)DDMReceivalTargetUI.getResource("d1Null"));
            SysUtil.abort();
        }
        if ((d1RowIndex = this.purOrderEntry.getSelectManager().getActiveRowIndex()) == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)DDMReceivalTargetUI.getResource("d1NotSelected"));
            SysUtil.abort();
        }
        StringBuffer msg = new StringBuffer();
        DDMReceivalBillEntryInfo entryInfo = null;
        String d1 = DDMReceivalTargetUI.getResource("Td1");
        String colon = DDMReceivalTargetUI.getResource("colon");
        String d1Prefix = d1 + (d1RowIndex + 1) + colon;
        entryInfo = this.cacheEntryColl.get(d1RowIndex);
        if (entryInfo.getReceiveQty() == null) {
            msg.append(d1Prefix).append(DDMReceivalTargetUI.getResource("receiveQtyNull")).append("\n");
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        if (entryInfo.getReceiveQty() != null && entryInfo.getReceiveQty().compareTo(entryInfo.getReceivableQty()) == 1) {
            msg.append(d1Prefix).append(DDMReceivalTargetUI.getResource("receiveQtyLarger")).append("\n");
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        if ((targetCollection = entryInfo.getTargetEntry()).size() == 0) {
            msg.append(d1Prefix).append(DDMReceivalTargetUI.getResource("d2Null")).append("\n");
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        BigDecimal d1BSReceiveQty = entryInfo.getBaseReceiveQty();
        BigDecimal d2BSReceivableQty = null;
        BigDecimal d2ReceiveQty = null;
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        for (i = 0; i < targetCollection.size(); ++i) {
            targetInfo = targetCollection.get(i);
            targetInfo.setBaseReceiveQty(null);
            targetInfo.setReceiveQty(null);
            this.stockEntry.getCell(i, TB_BSRECEIVEQTY).setValue(null);
            this.stockEntry.getCell(i, TB_ReceiveQty).setValue(null);
        }
        for (i = 0; i < targetCollection.size() && d1BSReceiveQty.compareTo(new BigDecimal("0")) != 0; ++i) {
            targetInfo = targetCollection.get(i);
            d2BSReceivableQty = targetInfo.getBsReceivableQty();
            if (d2BSReceivableQty.compareTo(d1BSReceiveQty) >= 0) {
                targetInfo.setBaseReceiveQty(d1BSReceiveQty);
            } else {
                targetInfo.setBaseReceiveQty(d2BSReceivableQty);
            }
            d1BSReceiveQty = d1BSReceiveQty.subtract(targetInfo.getBaseReceiveQty());
            d2ReceiveQty = SCMUtils.getExchangePricesionQtyForClient((String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (MeasureUnitInfo)targetInfo.getUnit(), (BigDecimal)targetInfo.getBaseReceiveQty());
            targetInfo.setReceiveQty(d2ReceiveQty);
            this.stockEntry.getCell(i, TB_BSRECEIVEQTY).setValue((Object)targetInfo.getBaseReceiveQty());
            this.stockEntry.getCell(i, TB_ReceiveQty).setValue((Object)d2ReceiveQty);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.validationOnConfirm();
        this.filterCacheD1();
        this.filterCacheD2();
        this.getUIContext().put(RTN_STATE, new Integer(0));
        this.getUIContext().put(OUT_DATA, this.cacheEntryColl);
        this.actionExitCurrent_actionPerformed(e);
    }

    private void filterCacheD1() {
        DDMReceivalBillEntryInfo entryInfo = null;
        for (int i = 0; i < this.cacheEntryColl.size(); ++i) {
            entryInfo = this.cacheEntryColl.get(i);
            if (entryInfo.getReceiveQty() != null && entryInfo.getReceiveQty().doubleValue() != 0.0) continue;
            this.cacheEntryColl.remove(entryInfo);
            --i;
        }
    }

    private void filterCacheD2() {
        DDMReceivalBillEntryInfo entryInfo = null;
        DDMReceivalBillEntryTargetEntryCollection targetCollection = null;
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        for (int i = 0; i < this.cacheEntryColl.size(); ++i) {
            entryInfo = this.cacheEntryColl.get(i);
            targetCollection = entryInfo.getTargetEntry();
            for (int j = 0; j < targetCollection.size(); ++j) {
                targetInfo = targetCollection.get(j);
                if (targetInfo.getReceiveQty() != null && targetInfo.getReceiveQty().doubleValue() != 0.0) continue;
                targetCollection.remove(targetInfo);
                --j;
            }
        }
    }

    private void validationOnConfirm() throws EASBizException {
        BigDecimal d1BSQty;
        String d1Prefix;
        int i;
        StringBuffer msg = new StringBuffer();
        DDMReceivalBillEntryInfo entryInfo = null;
        String d1 = DDMReceivalTargetUI.getResource("Td1");
        String d2 = DDMReceivalTargetUI.getResource("d2");
        String colon = DDMReceivalTargetUI.getResource("colon");
        for (int i2 = 0; i2 < this.cacheEntryColl.size(); ++i2) {
            entryInfo = this.cacheEntryColl.get(i2);
            if (entryInfo.getReceiveQty() == null || entryInfo.getReceiveQty().compareTo(entryInfo.getReceivableQty()) != 1) continue;
            msg.append(d1).append(i2 + 1).append(colon).append(DDMReceivalTargetUI.getResource("receiveQtyLarger")).append("\n");
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        DDMReceivalBillEntryTargetEntryCollection targetCollection = null;
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        for (i = 0; i < this.cacheEntryColl.size(); ++i) {
            d1Prefix = d1 + (i + 1) + colon;
            entryInfo = this.cacheEntryColl.get(i);
            d1BSQty = entryInfo.getBaseReceiveQty();
            if (d1BSQty == null || d1BSQty.doubleValue() == 0.0) continue;
            targetCollection = entryInfo.getTargetEntry();
            if (targetCollection.size() == 0) {
                msg.append(d1Prefix).append(DDMReceivalTargetUI.getResource("d2Null")).append("\n");
                continue;
            }
            for (int j = 0; j < targetCollection.size(); ++j) {
                targetInfo = targetCollection.get(j);
                String d2Prefix = d1Prefix + d2 + (j + 1) + colon;
                if (targetInfo.getReceiveQty() == null || targetInfo.getReceiveQty().compareTo(targetInfo.getReceivableQty()) != 1) continue;
                msg.append(d2Prefix).append(DDMReceivalTargetUI.getResource("receiveQtyLarger")).append("\n");
            }
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        for (i = 0; i < this.cacheEntryColl.size(); ++i) {
            d1Prefix = d1 + (i + 1) + colon;
            entryInfo = this.cacheEntryColl.get(i);
            d1BSQty = entryInfo.getBaseReceiveQty();
            if (d1BSQty == null || d1BSQty.doubleValue() == 0.0) continue;
            BigDecimal totalD2BSQty = new BigDecimal("0");
            targetCollection = entryInfo.getTargetEntry();
            for (int j = 0; j < targetCollection.size(); ++j) {
                targetInfo = targetCollection.get(j);
                if (targetInfo.getReceiveQty() == null || targetInfo.getReceiveQty().doubleValue() == 0.0) continue;
                totalD2BSQty = totalD2BSQty.add(targetInfo.getBaseReceiveQty());
            }
            if (d1BSQty.compareTo(totalD2BSQty) == 0) continue;
            msg.append(d1Prefix).append(DDMReceivalTargetUI.getResource("d2QtyNotEqualD1Qty")).append("\n");
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
    }
}

