/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.control.CheckTypeEnum;
import com.kingdee.eas.mm.control.DirectDisChildVO;
import com.kingdee.eas.mm.control.DirectDisParentVO;
import com.kingdee.eas.mm.control.FinishedRptBillingVO;
import com.kingdee.eas.mm.control.FinishedRptCRCollection;
import com.kingdee.eas.mm.control.FinishedRptCRInfo;
import com.kingdee.eas.mm.control.FinishedRptCheckReqVO;
import com.kingdee.eas.mm.control.FinishedRptCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryInfo;
import com.kingdee.eas.mm.control.FinishedRptFactory;
import com.kingdee.eas.mm.control.FinishedRptInfo;
import com.kingdee.eas.mm.control.FinishedRptOrderVO;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.client.FinishedRptBillingUI;
import com.kingdee.eas.mm.control.client.FinishedRptCheckReqUI;
import com.kingdee.eas.mm.control.client.FinishedRptDirectDisUI;
import com.kingdee.eas.mm.control.client.FinishedRptRepairUI;
import com.kingdee.eas.mm.control.client.FinishedRptReworkUI;
import com.kingdee.eas.mm.control.util.FinishedRptUtil;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.action.ISupportObjContext;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FinishedRptBotpUtil {
    public static final String MANUFACTURERECBILL_BOSTYPE = "FA1292B4";
    public static final String BILLING_DATA = "billingData";
    public static final String BILLING_STATE = "retrunState";
    public static final String CHECK_DATA = "checkData";
    public static final String DIRECTDIS_DATA = "directiDisData";
    public static final String PRD_DATA = "prdData";
    private static IMultiMeasureUnit multiUnit = null;
    private static Map<String, MultiMeasureUnitInfo> multiUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
    private static Map hasCheckModular = new HashMap();

    public static void customFinishedRptTOManufactureRec(CoreUI currentUi, Set billIds, Set entryIds) throws Exception {
        FinishedRptCollection srcObjCols = FinishedRptBotpUtil.getFinishedRptCollection(billIds, entryIds, true);
        List<FinishedRptBillingVO> billingData = new ArrayList();
        Iterator ite = srcObjCols.iterator();
        while (ite.hasNext()) {
            FinishedRptInfo info = (FinishedRptInfo)ite.next();
            Boolean[] result = FinishedRptUtil.checkCreateToStatus(info);
            if (!result[0].booleanValue()) {
                MsgBox.showInfo((Component)currentUi, (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"PushCreateToMsg"));
                FinishedRptBotpUtil.abort(currentUi);
            } else if (result[1].booleanValue()) {
                MsgBox.showInfo((Component)currentUi, (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"PushCreateToMsg2"));
                FinishedRptBotpUtil.abort(currentUi);
            }
            String orgId = info.getStorageOrgUnit().getId().toString();
            boolean hasCheck = false;
            if (hasCheckModular.containsKey(orgId)) {
                hasCheck = (Boolean)hasCheckModular.get(orgId);
            } else {
                hasCheck = FinishedRptUtil.hasCheckModular(orgId);
                hasCheckModular.put(orgId, hasCheck);
            }
            Iterator iter = info.getEntrys().iterator();
            while (iter.hasNext()) {
                FinishedRptEntryInfo entryInfo = (FinishedRptEntryInfo)iter.next();
                if (hasCheck && entryInfo.isIsCheck() && !entryInfo.isUrgentRelease()) {
                    Iterator itera = entryInfo.getCheckEntry().iterator();
                    while (itera.hasNext()) {
                        FinishedRptCRInfo checkInfo = (FinishedRptCRInfo)itera.next();
                        boolean isPass = false;
                        if (checkInfo.getCheckResult().getValue() == 2) {
                            isPass = true;
                        } else {
                            if (checkInfo.getCheckResult().getValue() != 3) continue;
                            isPass = false;
                        }
                        FinishedRptBillingVO vo = new FinishedRptBillingVO();
                        FinishedRptBotpUtil.buildBillingData(vo, info, entryInfo, checkInfo);
                        vo.setIsPass(isPass);
                        vo.setPreRecQty(checkInfo.getQty().subtract(checkInfo.getTotalReportQty()));
                        vo.setRecQty(vo.getPreRecQty());
                        billingData.add(vo);
                    }
                    continue;
                }
                FinishedRptBillingVO billingVO = new FinishedRptBillingVO();
                FinishedRptBotpUtil.buildBillingData(billingVO, info, entryInfo, null);
                BigDecimal temp = entryInfo.getTotalPassQty().subtract(entryInfo.getStockTotalQty()).subtract(entryInfo.getTotalReversePreQty());
                if (temp.compareTo(BigDecimal.ZERO) < 0) {
                    temp = BigDecimal.ZERO;
                }
                billingVO.setPreRecQty(temp);
                billingVO.setIsPass(true);
                billingVO.setRecQty(temp);
                billingData.add(billingVO);
                billingVO = new FinishedRptBillingVO();
                FinishedRptBotpUtil.buildBillingData(billingVO, info, entryInfo, null);
                temp = entryInfo.getTotalRejectQty().subtract(entryInfo.getRejectStockTotalQty());
                if (temp.compareTo(BigDecimal.ZERO) < 0) {
                    temp = BigDecimal.ZERO;
                }
                billingVO.setPreRecQty(temp);
                billingVO.setIsPass(false);
                billingVO.setRecQty(temp);
                billingData.add(billingVO);
            }
        }
        if (billingData.size() <= 0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("noToStorageData"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)currentUi);
        uiContext.put((Object)BILLING_DATA, billingData);
        uiContext.put((Object)"canResize", (Object)"true");
        IUIWindow uiWindow = UIHelper.openUIWindow((UIContext)uiContext, (String)FinishedRptBillingUI.class.getName());
        FinishedRptBillingUI ui = (FinishedRptBillingUI)uiWindow.getUIObject();
        Map context = ui.getUIContext();
        Integer retrunState = (Integer)context.get(BILLING_STATE);
        if (null != retrunState && retrunState == 0) {
            billingData = (List)ui.getUIContext().get(BILLING_DATA);
            FinishedRptBillingVO vo = null;
            HashMap groupData = new HashMap();
            HashMap<String, BOTMappingInfo> botpCache = new HashMap<String, BOTMappingInfo>();
            for (int i = 0; i < billingData.size(); ++i) {
                List<FinishedRptBillingVO> list;
                vo = (FinishedRptBillingVO)billingData.get(i);
                if (vo.getRecQty().compareTo(BigDecimal.ZERO) <= 0) continue;
                String key = vo.getBotpRule().getId().toString();
                if (groupData.containsKey(key)) {
                    list = (List)groupData.get(key);
                    list.add(vo);
                    continue;
                }
                list = new ArrayList();
                list.add(vo);
                groupData.put(key, list);
                botpCache.put(key, vo.getBotpRule());
            }
            ArrayList<CoreBillBaseCollection> srcBillList = new ArrayList<CoreBillBaseCollection>();
            ArrayList mappingList = new ArrayList();
            for (Map.Entry entry : groupData.entrySet()) {
                srcBillList.add(FinishedRptBotpUtil.getSrcBillColl(srcObjCols, (List)entry.getValue()));
                mappingList.add(botpCache.get(entry.getKey()));
            }
            if (mappingList.size() > 0 && srcBillList.size() > 0 && mappingList.size() == srcBillList.size()) {
                IObjectCollection colls = FinishedRptFactory.getRemoteInstance().transformForBotp(srcBillList, mappingList);
                boolean isShow = false;
                for (int i = 0; i < mappingList.size(); ++i) {
                    BOTMappingInfo btpInfo = (BOTMappingInfo)mappingList.get(i);
                    if (btpInfo.getIsShowEditUI() != 1) continue;
                    isShow = true;
                    break;
                }
                if (colls != null && colls.size() > 0) {
                    if (isShow) {
                        ArrayList<String> destIds = new ArrayList<String>();
                        for (ManufactureRecBillInfo mrb : colls) {
                            destIds.add(mrb.getId().toString());
                        }
                        FinishedRptBotpUtil.autoOpenDescInStockBill(destIds, (IUIObject)currentUi, ((ISupportObjContext)currentUi).getMainContext());
                    } else {
                        MsgBox.showInfo((String)FinishedRptUtil.getResource("converseSuccess"));
                    }
                }
            }
        } else {
            FinishedRptBotpUtil.abort(currentUi);
        }
    }

    private static CoreBillBaseCollection getSrcBillColl(FinishedRptCollection srcObjCols, List dataList) throws EASBizException, BOSException {
        CoreBillBaseCollection returnColls = new CoreBillBaseCollection();
        Iterator ite = srcObjCols.iterator();
        while (ite.hasNext()) {
            FinishedRptInfo info = (FinishedRptInfo)ite.next();
            if (!FinishedRptBotpUtil.hasBillingData(info, dataList)) continue;
            FinishedRptInfo rentunInfo = (FinishedRptInfo)info.clone();
            rentunInfo.getEntrys().clear();
            String orgId = info.getStorageOrgUnit().getId().toString();
            boolean hasCheck = (Boolean)hasCheckModular.get(orgId);
            Iterator iter = info.getEntrys().iterator();
            block1: while (iter.hasNext()) {
                FinishedRptEntryInfo entryInfo = (FinishedRptEntryInfo)iter.next();
                if (!FinishedRptBotpUtil.hasBillingData(entryInfo, dataList)) continue;
                FinishedRptEntryInfo returnEntryInfo = (FinishedRptEntryInfo)entryInfo.clone();
                returnEntryInfo.getCheckEntry().clear();
                if (hasCheck && entryInfo.isIsCheck() && !entryInfo.isUrgentRelease()) {
                    Iterator itera = entryInfo.getCheckEntry().iterator();
                    block2: while (itera.hasNext()) {
                        FinishedRptCRInfo checkInfo = (FinishedRptCRInfo)itera.next();
                        int n = dataList.size();
                        for (int i = 0; i < n; ++i) {
                            FinishedRptBillingVO vo = (FinishedRptBillingVO)dataList.get(i);
                            if (vo.getCheckResultID() == null || !vo.getCheckResultID().equals(checkInfo.getId().toString())) continue;
                            String materialId = vo.getMaterial().getId().toString();
                            String unitId = vo.getUnit().getId().toString();
                            String baseUnitId = vo.getMaterial().getBaseUnit().getId().toString();
                            MultiMeasureUnitInfo multiUnitInfo = FinishedRptBotpUtil.getMultiMeasureUnitInfo(materialId, unitId);
                            MultiMeasureUnitInfo baseMultiUnitInfo = FinishedRptBotpUtil.getMultiMeasureUnitInfo(materialId, baseUnitId);
                            checkInfo.setTotalReportQty(checkInfo.getQty().subtract(vo.getRecQty()));
                            checkInfo.setBaseTotalReportQty(MMUtils.getExchangeQtyForClient((MultiMeasureUnitInfo)multiUnitInfo, (MultiMeasureUnitInfo)baseMultiUnitInfo, (BigDecimal)checkInfo.getTotalReportQty()));
                            checkInfo.setWarehouse(vo.getWarehouse());
                            returnEntryInfo.getCheckEntry().add(checkInfo);
                            continue block2;
                        }
                    }
                    rentunInfo.getEntrys().add(returnEntryInfo);
                    continue;
                }
                int n = dataList.size();
                for (int i = 0; i < n; ++i) {
                    FinishedRptBillingVO vo = (FinishedRptBillingVO)dataList.get(i);
                    if (vo.getBillLineId() == null || !vo.getBillLineId().equals(entryInfo.getId().toString())) continue;
                    String materialId = vo.getMaterial().getId().toString();
                    String unitId = vo.getUnit().getId().toString();
                    String baseUnitId = vo.getMaterial().getBaseUnit().getId().toString();
                    MultiMeasureUnitInfo multiUnitInfo = FinishedRptBotpUtil.getMultiMeasureUnitInfo(materialId, unitId);
                    MultiMeasureUnitInfo baseMultiUnitInfo = FinishedRptBotpUtil.getMultiMeasureUnitInfo(materialId, baseUnitId);
                    if (vo.getIsPass()) {
                        returnEntryInfo.setStockTotalQty(returnEntryInfo.getTotalPassQty().subtract(vo.getRecQty()));
                        returnEntryInfo.setBaseStockTotalQty(MMUtils.getExchangeQtyForClient((MultiMeasureUnitInfo)multiUnitInfo, (MultiMeasureUnitInfo)baseMultiUnitInfo, (BigDecimal)returnEntryInfo.getStockTotalQty()));
                        returnEntryInfo.setTotalReversePreQty(BigDecimal.ZERO);
                        returnEntryInfo.setBaseTotalReversePreQty(BigDecimal.ZERO);
                        returnEntryInfo.setWarehouse(vo.getWarehouse());
                    } else {
                        returnEntryInfo.setRejectStockTotalQty(returnEntryInfo.getTotalRejectQty().subtract(vo.getRecQty()));
                        returnEntryInfo.setBaseRejectStockTotalQty(MMUtils.getExchangeQtyForClient((MultiMeasureUnitInfo)multiUnitInfo, (MultiMeasureUnitInfo)baseMultiUnitInfo, (BigDecimal)returnEntryInfo.getRejectStockTotalQty()));
                        returnEntryInfo.setWarehouse(vo.getWarehouse());
                    }
                    rentunInfo.getEntrys().add(returnEntryInfo);
                    continue block1;
                }
            }
            returnColls.add((CoreBillBaseInfo)rentunInfo);
        }
        return returnColls;
    }

    private static boolean hasBillingData(FinishedRptInfo info, List dataList) {
        int n = dataList.size();
        for (int i = 0; i < n; ++i) {
            FinishedRptBillingVO vo = (FinishedRptBillingVO)dataList.get(i);
            if (!vo.getBillHeadId().equals(info.getId().toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasBillingData(FinishedRptEntryInfo entryInfo, List dataList) {
        int n = dataList.size();
        for (int i = 0; i < n; ++i) {
            FinishedRptBillingVO vo = (FinishedRptBillingVO)dataList.get(i);
            if (!vo.getBillLineId().equals(entryInfo.getId().toString())) continue;
            return true;
        }
        return false;
    }

    private static MultiMeasureUnitInfo getMultiMeasureUnitInfo(String materialId, String unitId) throws BOSException, EASBizException {
        String key = materialId + unitId;
        if (multiUnitMap.containsKey(key)) {
            return multiUnitMap.get(key);
        }
        if (multiUnit == null) {
            multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        }
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialId, unitId);
        multiUnitMap.put(key, multiUnifInfo);
        return multiUnifInfo;
    }

    private static FinishedRptCollection getFinishedRptCollection(Set billIds, Set entryIds, boolean isHDD) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterInfo entryFilter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billIds, CompareType.INCLUDE));
        entryFilter.setEntryName("entrys");
        entryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)entryIds, CompareType.INCLUDE));
        view.setSelector(FinishedRptBotpUtil.getSelectors(isHDD));
        view.setFilter(filter);
        view.getEntryFilters().add(entryFilter);
        return FinishedRptFactory.getRemoteInstance().getFinishedRptCollection(view);
    }

    private static SelectorItemCollection getSelectors(boolean isHDD) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.CU.id"));
        sic.add(new SelectorItemInfo("taskDispBill.material.id"));
        sic.add(new SelectorItemInfo("taskDispBill.material.number"));
        sic.add(new SelectorItemInfo("taskDispBill.material.name"));
        sic.add(new SelectorItemInfo("taskDispBill.material.model"));
        sic.add(new SelectorItemInfo("taskDispBill.unit.id"));
        sic.add(new SelectorItemInfo("taskDispBill.unit.name"));
        sic.add(new SelectorItemInfo("taskDispBill.unit.number"));
        sic.add(new SelectorItemInfo("taskDispBill.baseUnit.id"));
        sic.add(new SelectorItemInfo("taskDispBill.baseUnit.name"));
        sic.add(new SelectorItemInfo("taskDispBill.baseUnit.number"));
        sic.add(new SelectorItemInfo("productionOrder.baseStatus"));
        sic.add(new SelectorItemInfo("productionOrder.lotNo"));
        sic.add(new SelectorItemInfo("productionOrder.material.id"));
        sic.add(new SelectorItemInfo("productionOrder.material.number"));
        sic.add(new SelectorItemInfo("productionOrder.material.name"));
        sic.add(new SelectorItemInfo("productionOrder.material.model"));
        sic.add(new SelectorItemInfo("productionOrder.unit.id"));
        sic.add(new SelectorItemInfo("productionOrder.unit.name"));
        sic.add(new SelectorItemInfo("productionOrder.unit.number"));
        sic.add(new SelectorItemInfo("productionOrder.baseUnit.id"));
        sic.add(new SelectorItemInfo("productionOrder.baseUnit.name"));
        sic.add(new SelectorItemInfo("productionOrder.baseUnit.number"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.material.id"));
        sic.add(new SelectorItemInfo("entrys.material.name"));
        sic.add(new SelectorItemInfo("entrys.material.number"));
        sic.add(new SelectorItemInfo("entrys.material.model"));
        sic.add(new SelectorItemInfo("entrys.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit"));
        sic.add(new SelectorItemInfo("entrys.material.assistUnit"));
        sic.add(new SelectorItemInfo("entrys.unit.id"));
        sic.add(new SelectorItemInfo("entrys.unit.name"));
        sic.add(new SelectorItemInfo("entrys.unit.number"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.id"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.name"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.number"));
        sic.add(new SelectorItemInfo("entrys.warehouse.id"));
        sic.add(new SelectorItemInfo("entrys.warehouse.name"));
        sic.add(new SelectorItemInfo("entrys.warehouse.number"));
        sic.add(new SelectorItemInfo("entrys.warehouse.hasLocation"));
        if (isHDD) {
            sic.add(new SelectorItemInfo("entrys.checkEntry.*"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.material.id"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.material.name"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.material.number"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.material.model"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.material.pricePrecision"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.material.baseUnit"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.material.assistUnit"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.unit.id"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.unit.name"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.unit.number"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.dPProcessMode.id"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.dPProcessMode.name"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.dPProcessMode.number"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.sourceBillType.id"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.sourceBillType.name"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.sourceBillType.number"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.transactionType.id"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.transactionType.name"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.transactionType.number"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.warehouse.id"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.warehouse.name"));
            sic.add(new SelectorItemInfo("entrys.checkEntry.warehouse.number"));
        }
        return sic;
    }

    public static void customFinishedRptTOManufactureRec(CoreUI currentUi, IObjectCollection srcObjCols) throws Exception {
        int i;
        if (null == srcObjCols) {
            return;
        }
        List<FinishedRptBillingVO> billingData = new ArrayList();
        for (FinishedRptInfo info : srcObjCols) {
            HashSet<BOSUuid> selectIds = new HashSet<BOSUuid>();
            if (info != null && info.getEntrys() != null) {
                Iterator iterator = info.getEntrys().iterator();
                while (iterator.hasNext()) {
                    FinishedRptEntryInfo entryInfo = (FinishedRptEntryInfo)iterator.next();
                    if (entryInfo == null) continue;
                    selectIds.add(entryInfo.getId());
                }
            }
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            try {
                info = FinishedRptFactory.getRemoteInstance().getFinishedRptInfo((IObjectPK)pk, FinishedRptBotpUtil.getSelectors(true));
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (selectIds.size() > 0 && info != null && info.getEntrys() != null) {
                for (int i2 = 0; i2 < info.getEntrys().size(); ++i2) {
                    FinishedRptEntryInfo element = info.getEntrys().get(i2);
                    if (!selectIds.contains(element.getId())) {
                        info.getEntrys().remove(element);
                        --i2;
                        continue;
                    }
                    boolean flag = FinishedRptUtil.hasCheckModular(info.getStorageOrgUnit().getId().toString());
                    if (!flag || !element.isIsCheck() || element.isUrgentRelease()) continue;
                    info.getEntrys().remove(element);
                    --i2;
                }
            }
            FinishedRptEntryCollection passEntryCollection = info.getEntrys();
            if (info == null || info.getEntrys() == null) continue;
            BigDecimal temp = new BigDecimal(String.valueOf(0.0));
            for (i = 0; i < passEntryCollection.size(); ++i) {
                FinishedRptBillingVO billingVO;
                FinishedRptEntryInfo entryInfo = passEntryCollection.get(i);
                if (entryInfo == null) continue;
                boolean flag = FinishedRptUtil.hasCheckModular(info.getStorageOrgUnit().getId().toString());
                if (!flag || flag && !entryInfo.isIsCheck()) {
                    billingVO = new FinishedRptBillingVO();
                    FinishedRptBotpUtil.buildBillingData(billingVO, info, entryInfo, null);
                    if (entryInfo.getTotalPassQty() != null && entryInfo.getRptTotalQty() != null && (temp = entryInfo.getTotalPassQty().subtract(entryInfo.getStockTotalQty()).subtract(entryInfo.getTotalReversePreQty())).doubleValue() < 0.0) {
                        temp = new BigDecimal(String.valueOf(0.0));
                    }
                    billingVO.setPreRecQty(temp);
                    billingVO.setIsPass(true);
                    billingVO.setRecQty(temp);
                    billingData.add(billingVO);
                    billingVO = new FinishedRptBillingVO();
                    FinishedRptBotpUtil.buildBillingData(billingVO, info, entryInfo, null);
                    if (entryInfo.getTotalRejectQty() != null && entryInfo.getRejectRptTotalQty() != null && (temp = entryInfo.getTotalRejectQty().subtract(entryInfo.getRejectStockTotalQty())).doubleValue() < 0.0) {
                        temp = new BigDecimal(String.valueOf(0.0));
                    }
                    billingVO.setPreRecQty(temp);
                    billingVO.setIsPass(false);
                    billingVO.setRecQty(temp);
                    billingData.add(billingVO);
                    continue;
                }
                if (!flag || !entryInfo.isUrgentRelease()) continue;
                billingVO = new FinishedRptBillingVO();
                FinishedRptBotpUtil.buildBillingData(billingVO, info, entryInfo, null);
                if (entryInfo.getTotalPassQty() != null && entryInfo.getRptTotalQty() != null && (temp = entryInfo.getCommitQty().subtract(entryInfo.getStockTotalQty()).subtract(entryInfo.getRejectStockTotalQty()).subtract(entryInfo.getTotalReversePreQty())).doubleValue() < 0.0) {
                    temp = new BigDecimal(String.valueOf(0.0));
                }
                billingVO.setPreRecQty(temp);
                billingVO.setIsPass(true);
                billingVO.setRecQty(temp);
                billingData.add(billingVO);
            }
        }
        if (billingData.size() <= 0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("noToStorageData"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)currentUi);
        uiContext.put((Object)BILLING_DATA, billingData);
        uiContext.put((Object)"canResize", (Object)"true");
        IUIWindow uiWindow = UIHelper.openUIWindow((UIContext)uiContext, (String)FinishedRptBillingUI.class.getName());
        FinishedRptBillingUI ui = (FinishedRptBillingUI)uiWindow.getUIObject();
        Map context = ui.getUIContext();
        Integer retrunState = (Integer)context.get(BILLING_STATE);
        if (null != retrunState && retrunState == 0) {
            billingData = (List)ui.getUIContext().get(BILLING_DATA);
            FinishedRptBillingVO vo = null;
            for (i = 0; i < billingData.size(); ++i) {
                vo = (FinishedRptBillingVO)billingData.get(i);
                for (int j = 0; j < srcObjCols.size(); ++j) {
                    FinishedRptInfo info = (FinishedRptInfo)srcObjCols.getObject(j);
                    if (!info.getId().toString().equals(vo.getBillHeadId())) continue;
                    FinishedRptEntryCollection entryCollection = info.getEntrys();
                    for (int k = 0; k < entryCollection.size(); ++k) {
                        FinishedRptEntryInfo entryInfo = entryCollection.get(k);
                        if (!entryInfo.getId().toString().equals(vo.getBillLineId())) continue;
                        if (vo.getIsPass()) {
                            entryInfo.setPassBillingQty(vo.getRecQty());
                            entryInfo.setWarehouse(vo.getWarehouse());
                            continue;
                        }
                        entryInfo.setUnPassBillingQty(vo.getRecQty());
                        entryInfo.setUnPassWarehouse(vo.getWarehouse());
                    }
                }
            }
            try {
                FinishedRptFactory.getRemoteInstance().updateRptTotalQty(srcObjCols, true);
            }
            catch (Exception e) {
                MsgBox.showError((Component)currentUi, (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"UpdateRptTotalQtyUnsuccessMsg"));
                FinishedRptBotpUtil.abort(currentUi);
            }
            FinishedRptFactory.getRemoteInstance().makeManuRecBill(srcObjCols, true);
            MsgBox.showInfo((String)FinishedRptUtil.getResource("converseSuccess"));
        } else {
            FinishedRptBotpUtil.abort(currentUi);
        }
    }

    private static void buildBillingData(FinishedRptBillingVO vo, FinishedRptInfo info, FinishedRptEntryInfo entryInfo, FinishedRptCRInfo checkInfo) {
        vo.setBillNumber(info.getNumber());
        vo.setBillHeadId(info.getId().toString());
        vo.setBillLineId(entryInfo.getId().toString());
        vo.setWarehouse(entryInfo.getWarehouse());
        vo.setStorage(info.getStorageOrgUnit());
        vo.setLotNo(entryInfo.getLotNo());
        if (checkInfo == null) {
            vo.setMaterial(entryInfo.getMaterial());
            vo.setUnit(entryInfo.getUnit());
            vo.setPrecision(MMUtils.getQtyPrecision((String)entryInfo.getMaterial().getId().toString(), (String)entryInfo.getUnit().getId().toString()));
            vo.setCheckResultID(null);
        } else {
            vo.setMaterial(checkInfo.getMaterial());
            vo.setUnit(checkInfo.getUnit());
            vo.setPrecision(MMUtils.getQtyPrecision((String)checkInfo.getMaterial().getId().toString(), (String)checkInfo.getUnit().getId().toString()));
            vo.setCheckResultID(checkInfo.getId().toString());
        }
        vo.setOutputType(entryInfo.getOutputType());
        if (checkInfo != null) {
            vo.setCheckType(CheckTypeEnum.check);
        } else {
            vo.setCheckType(CheckTypeEnum.noCheck);
        }
    }

    public static void customCheckResultToStorage(CoreUI currentUi, IObjectCollection srcObjCols) throws EASBizException, BOSException {
        if (null == srcObjCols) {
            return;
        }
        FinishedRptCollection collection = (FinishedRptCollection)srcObjCols;
        List<FinishedRptBillingVO> billingData = new ArrayList();
        FinishedRptBillingVO vo = null;
        for (int i = 0; i < collection.size(); ++i) {
            FinishedRptInfo info = collection.get(i);
            FinishedRptEntryInfo entryInfo = null;
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                entryInfo = info.getEntrys().get(j);
                FinishedRptCRInfo checkInfo = null;
                for (int k = 0; k < entryInfo.getCheckEntry().size(); ++k) {
                    vo = new FinishedRptBillingVO();
                    checkInfo = entryInfo.getCheckEntry().get(k);
                    FinishedRptBotpUtil.buildBillingData(vo, info, entryInfo, checkInfo);
                    if (checkInfo.getCheckResult().getValue() == 2) {
                        vo.setIsPass(true);
                    } else {
                        vo.setIsPass(false);
                    }
                    vo.setPreRecQty(checkInfo.getQty().subtract(checkInfo.getTotalReportQty()));
                    vo.setRecQty(vo.getPreRecQty());
                    billingData.add(vo);
                }
            }
        }
        if (billingData.size() <= 0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("noToStorageData"));
            SysUtil.abort();
            return;
        }
        UIContext uiContext = new UIContext((Object)currentUi);
        uiContext.put((Object)BILLING_DATA, billingData);
        IUIWindow uiWindow = UIHelper.openUIWindow((UIContext)uiContext, (String)FinishedRptBillingUI.class.getName());
        FinishedRptBillingUI ui = (FinishedRptBillingUI)uiWindow.getUIObject();
        Map context = ui.getUIContext();
        List list = (List)context.get(BILLING_DATA);
        if (list.size() <= 0) {
            return;
        }
        Integer retrunState = (Integer)context.get(BILLING_STATE);
        if (null != retrunState && retrunState == 0) {
            billingData = (List)ui.getUIContext().get(BILLING_DATA);
            for (int i = 0; i < billingData.size(); ++i) {
                vo = (FinishedRptBillingVO)billingData.get(i);
                for (int j = 0; j < srcObjCols.size(); ++j) {
                    FinishedRptInfo info = (FinishedRptInfo)srcObjCols.getObject(j);
                    if (!info.getId().toString().equals(vo.getBillHeadId())) continue;
                    FinishedRptEntryCollection entryCollection = info.getEntrys();
                    for (int k = 0; k < entryCollection.size(); ++k) {
                        FinishedRptEntryInfo entryInfo = entryCollection.get(k);
                        if (!entryInfo.getId().toString().equals(vo.getBillLineId())) continue;
                        FinishedRptCRCollection checkColls = entryInfo.getCheckEntry();
                        for (int m = 0; m < checkColls.size(); ++m) {
                            FinishedRptCRInfo checkInfo = checkColls.get(m);
                            if (!checkInfo.getId().toString().equals(vo.getCheckResultID())) continue;
                            checkInfo.setBillingQty(vo.getRecQty());
                            checkInfo.setWarehouse(vo.getWarehouse());
                        }
                    }
                }
            }
            try {
                FinishedRptFactory.getRemoteInstance().updateRptTotalQty(srcObjCols, false);
            }
            catch (Exception e) {
                MsgBox.showError((Component)currentUi, (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"UpdateRptTotalQtyUnsuccessMsg"));
                FinishedRptBotpUtil.abort(currentUi);
            }
            FinishedRptFactory.getRemoteInstance().makeManuRecBill(srcObjCols, false);
            MsgBox.showInfo((String)FinishedRptUtil.getResource("successManuRecBill"));
        } else {
            FinishedRptBotpUtil.abort(currentUi);
        }
    }

    private static void abort(CoreUI currentUi) {
        currentUi.setCursorOfDefault();
        SysUtil.abort();
    }

    public static void customFinishedRptTOMCheckReq(CoreUI currentUi, Set billIds, Set entryIds) throws Exception {
        FinishedRptCollection srcObjCols = FinishedRptBotpUtil.getFinishedRptCollection(billIds, entryIds, false);
        ArrayList<FinishedRptCheckReqVO> checkReqs = new ArrayList<FinishedRptCheckReqVO>();
        FinishedRptCheckReqVO vo = null;
        Iterator ite = srcObjCols.iterator();
        while (ite.hasNext()) {
            FinishedRptInfo info = (FinishedRptInfo)ite.next();
            if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.FINISH)) {
                MsgBox.showInfo((Component)currentUi, (String)FinishedRptUtil.getResource("notAuditOrCompleteNotGenCheckReq"));
                FinishedRptBotpUtil.abort(currentUi);
            }
            String orgId = info.getStorageOrgUnit().getId().toString();
            boolean hasCheck = false;
            if (hasCheckModular.containsKey(orgId)) {
                hasCheck = (Boolean)hasCheckModular.get(orgId);
            } else {
                hasCheck = FinishedRptUtil.hasCheckModular(orgId);
                hasCheckModular.put(orgId, hasCheck);
            }
            if (!hasCheck) {
                ite.remove();
                continue;
            }
            Iterator iter = info.getEntrys().iterator();
            while (iter.hasNext()) {
                FinishedRptEntryInfo entryInfo = (FinishedRptEntryInfo)iter.next();
                if (!entryInfo.isIsCheck()) {
                    iter.remove();
                    continue;
                }
                BigDecimal total = entryInfo.getTotalPassQty().add(entryInfo.getTotalRejectQty()).add(entryInfo.getTotalReworkQty()).add(entryInfo.getTotalRepairQty());
                if (!entryInfo.isUrgentRelease() && total.equals(entryInfo.getCommitQty())) {
                    iter.remove();
                    continue;
                }
                BigDecimal temp = entryInfo.getCommitQty().subtract(entryInfo.getRptCheckQty());
                if (temp.compareTo(BigDecimal.ZERO) <= 0) {
                    iter.remove();
                    continue;
                }
                vo = new FinishedRptCheckReqVO();
                vo.setFinishedRptId(info.getId().toString());
                vo.setFinishedRptEntryId(entryInfo.getId().toString());
                vo.setFinishedRptNum(info.getNumber());
                vo.setStorageOrgUnit(info.getStorageOrgUnit());
                vo.setMaterial(entryInfo.getMaterial());
                vo.setUnit(entryInfo.getUnit());
                vo.setCouldCheckQty(entryInfo.getCommitQty().subtract(entryInfo.getRptCheckQty()));
                vo.setCheckQty(vo.getCouldCheckQty());
                checkReqs.add(vo);
            }
            if (info.getEntrys().size() != 0) continue;
            ite.remove();
        }
        if (checkReqs.size() <= 0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("noCheckData"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)currentUi);
        uiContext.put((Object)CHECK_DATA, checkReqs);
        uiContext.put((Object)"canResize", (Object)"true");
        IUIWindow uiWindow = UIHelper.openUIWindow((UIContext)uiContext, (String)FinishedRptCheckReqUI.class.getName());
        FinishedRptCheckReqUI ui = (FinishedRptCheckReqUI)uiWindow.getUIObject();
        Map context = ui.getUIContext();
        List checkData = (List)context.get(CHECK_DATA);
        if (checkData.size() <= 0) {
            return;
        }
        Integer retrunState = (Integer)context.get(BILLING_STATE);
        if (null != retrunState && retrunState == 0) {
            HashMap groupData = new HashMap();
            HashMap<String, BOTMappingInfo> botpCache = new HashMap<String, BOTMappingInfo>();
            for (int i = 0; i < checkData.size(); ++i) {
                List<FinishedRptCheckReqVO> list;
                vo = (FinishedRptCheckReqVO)checkData.get(i);
                if (vo.getCheckQty().compareTo(BigDecimal.ZERO) <= 0) continue;
                String key = vo.getBotpRule().getId().toString();
                if (groupData.containsKey(key)) {
                    list = (List)groupData.get(key);
                    list.add(vo);
                    continue;
                }
                list = new ArrayList();
                list.add(vo);
                groupData.put(key, list);
                botpCache.put(key, vo.getBotpRule());
            }
            ArrayList<CoreBillBaseCollection> srcBillList = new ArrayList<CoreBillBaseCollection>();
            ArrayList mappingList = new ArrayList();
            for (Map.Entry entry : groupData.entrySet()) {
                srcBillList.add(FinishedRptBotpUtil.getSrcBillCollForCheck(srcObjCols, (List)entry.getValue()));
                mappingList.add(botpCache.get(entry.getKey()));
            }
            if (mappingList.size() > 0 && srcBillList.size() > 0 && mappingList.size() == srcBillList.size()) {
                IObjectCollection colls = FinishedRptFactory.getRemoteInstance().transformForBotp(srcBillList, mappingList);
                boolean isShow = false;
                for (int i = 0; i < mappingList.size(); ++i) {
                    BOTMappingInfo btpInfo = (BOTMappingInfo)mappingList.get(i);
                    if (btpInfo.getIsShowEditUI() != 1) continue;
                    isShow = true;
                    break;
                }
                if (colls != null && colls.size() > 0) {
                    if (isShow) {
                        ArrayList<String> destIds = new ArrayList<String>();
                        for (QCRequestInfo mrb : colls) {
                            destIds.add(mrb.getId().toString());
                        }
                        FinishedRptBotpUtil.autoOpenDescBill(destIds, (IUIObject)currentUi, ((ISupportObjContext)currentUi).getMainContext());
                    } else {
                        MsgBox.showInfo((String)FinishedRptUtil.getResource("successCheckReq"));
                    }
                }
            }
        } else {
            FinishedRptBotpUtil.abort(currentUi);
        }
    }

    private static void autoOpenDescBill(List<String> keyList, IUIObject iuiObject, Context mainOrgContext) throws BOSException, UIException {
        if (keyList != null && keyList.size() > 0) {
            UIContext objectContext = new UIContext((Object)iuiObject);
            objectContext.put((Object)"ID", (Object)keyList.get(0));
            if (keyList.size() > 1) {
                RealModeIDList idList = null;
                idList = new RealModeIDList(keyList.size(), 0);
                HashSet<String> hs = new HashSet<String>();
                for (int i = 0; i < keyList.size(); ++i) {
                    idList.add(i, keyList.get(i).toString());
                    hs.add(keyList.get(i).toString());
                }
                idList.setPkFieldName("id");
                EntityViewInfo env = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", hs, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("qcBizType", (Object)20, CompareType.EQUALS));
                env.setFilter(filterInfo);
                env.getSorter().add(new SorterItemInfo("number"));
                env.getSorter().add(new SorterItemInfo("entrys.seq"));
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.qm.qc.app", "QCRequestQuery");
                IQueryExecutor exec = null;
                exec = QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)mainQueryPK, (Context)mainOrgContext);
                exec.setObjectView(env);
                Uuid queryUuid = exec.openQuery();
                idList.setQuery((IMetaDataPK)mainQueryPK, env, queryUuid);
                objectContext.put((Object)"IDList", (Object)idList);
                idList.setCurrentID(keyList.get(0).toString());
                idList.getID(idList.getCurrentIndex());
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.qm.qc.client.QCMMRequestEditUI", (Map)objectContext, null, OprtState.VIEW);
            uiWindow.show();
            MsgBox.showInfo((Component)((CoreUI)uiWindow.getUIObject()), (String)FinishedRptUtil.getResource("successCheckReq"));
        }
    }

    private static void autoOpenDescInStockBill(List<String> keyList, IUIObject iuiObject, Context mainOrgContext) throws BOSException, UIException {
        if (keyList != null && keyList.size() > 0) {
            UIContext objectContext = new UIContext((Object)iuiObject);
            objectContext.put((Object)"ID", (Object)keyList.get(0));
            if (keyList.size() > 1) {
                RealModeIDList idList = null;
                idList = new RealModeIDList(keyList.size(), 0);
                HashSet<String> hs = new HashSet<String>();
                for (int i = 0; i < keyList.size(); ++i) {
                    idList.add(i, keyList.get(i).toString());
                    hs.add(keyList.get(i).toString());
                }
                idList.setPkFieldName("id");
                EntityViewInfo env = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", hs, CompareType.INCLUDE));
                env.setFilter(filterInfo);
                env.getSorter().add(new SorterItemInfo("number"));
                env.getSorter().add(new SorterItemInfo("entry.seq"));
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "ManufactureRecBillQuery");
                IQueryExecutor exec = null;
                exec = QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)mainQueryPK, (Context)mainOrgContext);
                exec.setObjectView(env);
                Uuid queryUuid = exec.openQuery();
                idList.setQuery((IMetaDataPK)mainQueryPK, env, queryUuid);
                objectContext.put((Object)"IDList", (Object)idList);
                idList.setCurrentID(keyList.get(0).toString());
                idList.getID(idList.getCurrentIndex());
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.scm.im.inv.client.ManufactureRecBillEditUI", (Map)objectContext, null, OprtState.VIEW);
            uiWindow.show();
            MsgBox.showInfo((Component)((CoreUI)uiWindow.getUIObject()), (String)FinishedRptUtil.getResource("converseSuccess"));
        }
    }

    private static CoreBillBaseCollection getSrcBillCollForCheck(FinishedRptCollection srcObjCols, List dataList) throws EASBizException, BOSException {
        CoreBillBaseCollection returnColls = new CoreBillBaseCollection();
        Iterator ite = srcObjCols.iterator();
        while (ite.hasNext()) {
            FinishedRptInfo info = (FinishedRptInfo)ite.next();
            if (!FinishedRptBotpUtil.hasCheckData(info, dataList)) continue;
            FinishedRptInfo rentunInfo = (FinishedRptInfo)info.clone();
            rentunInfo.getEntrys().clear();
            Iterator iter = info.getEntrys().iterator();
            block1: while (iter.hasNext()) {
                FinishedRptEntryInfo entryInfo = (FinishedRptEntryInfo)iter.next();
                if (!FinishedRptBotpUtil.hasCheckData(entryInfo, dataList)) continue;
                FinishedRptEntryInfo returnEntryInfo = (FinishedRptEntryInfo)entryInfo.clone();
                returnEntryInfo.getCheckEntry().clear();
                int n = dataList.size();
                for (int i = 0; i < n; ++i) {
                    FinishedRptCheckReqVO vo = (FinishedRptCheckReqVO)dataList.get(i);
                    if (vo.getFinishedRptEntryId() == null || !vo.getFinishedRptEntryId().equals(entryInfo.getId().toString())) continue;
                    returnEntryInfo.setRptCheckQty(returnEntryInfo.getCommitQty().subtract(vo.getCheckQty()));
                    returnEntryInfo.setBaseRptCheckQty(SCMUtils.getExchangeQtyForClient((String)returnEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)returnEntryInfo.getUnit(), (MeasureUnitInfo)returnEntryInfo.getBaseUnit(), (BigDecimal)returnEntryInfo.getRptCheckQty()));
                    rentunInfo.getEntrys().add(returnEntryInfo);
                    continue block1;
                }
            }
            returnColls.add((CoreBillBaseInfo)rentunInfo);
        }
        return returnColls;
    }

    private static boolean hasCheckData(FinishedRptInfo info, List dataList) {
        int n = dataList.size();
        for (int i = 0; i < n; ++i) {
            FinishedRptCheckReqVO vo = (FinishedRptCheckReqVO)dataList.get(i);
            if (!vo.getFinishedRptId().equals(info.getId().toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCheckData(FinishedRptEntryInfo entryInfo, List dataList) {
        int n = dataList.size();
        for (int i = 0; i < n; ++i) {
            FinishedRptCheckReqVO vo = (FinishedRptCheckReqVO)dataList.get(i);
            if (!vo.getFinishedRptEntryId().equals(entryInfo.getId().toString())) continue;
            return true;
        }
        return false;
    }

    public static void customFinishedRptTOMCheckReq(CoreUI currentUi, IObjectCollection srcObjCols) throws EASBizException, BOSException {
        FinishedRptInfo info;
        int i;
        if (null == srcObjCols) {
            return;
        }
        FinishedRptCollection collection = (FinishedRptCollection)srcObjCols;
        ArrayList<FinishedRptCheckReqVO> checkReqs = new ArrayList<FinishedRptCheckReqVO>();
        FinishedRptCheckReqVO vo = null;
        for (i = collection.size() - 1; i >= 0; --i) {
            info = collection.get(i);
            FinishedRptEntryCollection entryColls = info.getEntrys();
            for (int j = entryColls.size() - 1; j >= 0; --j) {
                if (!entryColls.get(j).isIsCheck()) {
                    entryColls.removeObject(j);
                    continue;
                }
                FinishedRptEntryInfo entryInfo = entryColls.get(j);
                BigDecimal total = entryInfo.getTotalPassQty().add(entryInfo.getTotalRejectQty()).add(entryInfo.getTotalReworkQty()).add(entryInfo.getTotalRepairQty());
                if (total.equals(entryInfo.getCommitQty())) {
                    entryColls.removeObject(j);
                    continue;
                }
                BigDecimal temp = entryInfo.getCommitQty().subtract(entryInfo.getRptCheckQty());
                if (!(temp.doubleValue() <= 0.0)) continue;
                entryColls.removeObject(j);
            }
            if (entryColls.size() > 0) continue;
            collection.removeObject(i);
        }
        for (i = 0; i < collection.size(); ++i) {
            info = collection.get(i);
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                vo = new FinishedRptCheckReqVO();
                vo.setFinishedRptId(info.getId().toString());
                vo.setFinishedRptEntryId(info.getEntrys().get(j).getId().toString());
                vo.setFinishedRptNum(info.getNumber());
                vo.setStorageOrgUnit(info.getStorageOrgUnit());
                vo.setMaterial(info.getEntrys().get(j).getMaterial());
                vo.setUnit(info.getEntrys().get(j).getUnit());
                vo.setCouldCheckQty(info.getEntrys().get(j).getCommitQty().subtract(info.getEntrys().get(j).getRptCheckQty()));
                vo.setCheckQty(vo.getCouldCheckQty());
                checkReqs.add(vo);
            }
        }
        if (checkReqs.size() <= 0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("noCheckData"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)currentUi);
        uiContext.put((Object)CHECK_DATA, checkReqs);
        uiContext.put((Object)"canResize", (Object)"true");
        IUIWindow uiWindow = UIHelper.openUIWindow((UIContext)uiContext, (String)FinishedRptCheckReqUI.class.getName());
        FinishedRptCheckReqUI ui = (FinishedRptCheckReqUI)uiWindow.getUIObject();
        Map context = ui.getUIContext();
        List list = (List)context.get(CHECK_DATA);
        if (list.size() <= 0) {
            return;
        }
        Integer retrunState = (Integer)context.get(BILLING_STATE);
        if (null != retrunState && retrunState == 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                vo = (FinishedRptCheckReqVO)list.get(i2);
                block5: for (int j = 0; j < collection.size(); ++j) {
                    FinishedRptInfo info2 = collection.get(j);
                    for (int k = 0; k < info2.getEntrys().size(); ++k) {
                        FinishedRptEntryInfo entryInfo = info2.getEntrys().get(k);
                        if (!info2.getId().toString().equals(vo.getFinishedRptId()) || !entryInfo.getId().toString().equals(vo.getFinishedRptEntryId())) continue;
                        entryInfo.setCurrCheckQty(vo.getCheckQty());
                        BigDecimal baseCheckQty = SCMUtils.getExchangeQtyForClient((String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)vo.getCheckQty());
                        entryInfo.setBaseCurrCheckQty(baseCheckQty);
                        continue block5;
                    }
                }
            }
            IObjectPK[] pks = new IObjectPK[srcObjCols.size()];
            for (int i3 = 0; i3 < pks.length; ++i3) {
                pks[i3] = new ObjectUuidPK(srcObjCols.getObject(i3).get("id").toString());
            }
            FinishedRptFactory.getRemoteInstance().makeCheckReq(srcObjCols, pks);
            MsgBox.showInfo((String)FinishedRptUtil.getResource("successCheckReq"));
        }
    }

    public static void customPrdOrder(CoreUI currentUi, IObjectCollection srcObjCols, int type) throws Exception {
        HashMap<String, Boolean> hasCheckModular = new HashMap<String, Boolean>();
        if (null == srcObjCols) {
            return;
        }
        FinishedRptCollection collection = (FinishedRptCollection)srcObjCols;
        ArrayList<FinishedRptOrderVO> voColls = new ArrayList<FinishedRptOrderVO>();
        FinishedRptOrderVO vo = null;
        String orgUnitID = null;
        for (int i = 0; i < collection.size(); ++i) {
            int j;
            FinishedRptInfo info = collection.get(i);
            orgUnitID = info.getStorageOrgUnit().getId().toString();
            Object value = hasCheckModular.get(orgUnitID);
            boolean flag = false;
            if (value == null) {
                flag = FinishedRptUtil.hasCheckModular(orgUnitID);
                hasCheckModular.put(orgUnitID, new Boolean(flag));
            } else {
                Boolean token = (Boolean)hasCheckModular.get(orgUnitID);
                if (token.booleanValue()) {
                    flag = true;
                }
            }
            FinishedRptEntryInfo entryInfo = null;
            boolean isMaterialValidate = false;
            if (!flag) {
                for (j = 0; j < info.getEntrys().size(); ++j) {
                    entryInfo = info.getEntrys().get(j);
                    isMaterialValidate = FinishedRptBotpUtil.checkToOrderMaterial(entryInfo.getMaterial(), info.getStorageOrgUnit());
                    if (!isMaterialValidate) continue;
                    vo = new FinishedRptOrderVO();
                    vo.setFinishedRptID(info.getId().toString());
                    vo.setFinishedRptEntryID(entryInfo.getId().toString());
                    vo.setFinishedRptNum(info.getNumber());
                    vo.setMaterial(entryInfo.getMaterial());
                    vo.setUnit(entryInfo.getUnit());
                    if (type == 4) {
                        vo.setCouldQty(entryInfo.getTotalReworkQty().subtract(entryInfo.getReworkRptTotalQty()));
                    } else {
                        vo.setCouldQty(entryInfo.getTotalRepairQty().subtract(entryInfo.getRepairRptTotalQty()));
                    }
                    vo.setPrecision(MMUtils.getQtyPrecision((String)entryInfo.getMaterial().getId().toString(), (String)entryInfo.getUnit().getId().toString()));
                    if (vo.getCouldQty().doubleValue() <= 0.0) continue;
                    vo.setQty(vo.getCouldQty());
                    vo.setStorage(info.getStorageOrgUnit());
                    voColls.add(vo);
                }
                continue;
            }
            for (j = 0; j < info.getEntrys().size(); ++j) {
                entryInfo = info.getEntrys().get(j);
                if (!entryInfo.isIsCheck()) {
                    isMaterialValidate = FinishedRptBotpUtil.checkToOrderMaterial(entryInfo.getMaterial(), info.getStorageOrgUnit());
                    if (!isMaterialValidate) continue;
                    vo = new FinishedRptOrderVO();
                    entryInfo = info.getEntrys().get(j);
                    vo.setFinishedRptID(info.getId().toString());
                    vo.setFinishedRptEntryID(entryInfo.getId().toString());
                    vo.setFinishedRptNum(info.getNumber());
                    vo.setMaterial(entryInfo.getMaterial());
                    vo.setUnit(entryInfo.getUnit());
                    vo.setPrecision(MMUtils.getQtyPrecision((String)entryInfo.getMaterial().getId().toString(), (String)entryInfo.getUnit().getId().toString()));
                    if (type == 4) {
                        vo.setCouldQty(entryInfo.getTotalReworkQty().subtract(entryInfo.getReworkRptTotalQty()));
                    } else {
                        vo.setCouldQty(entryInfo.getTotalRepairQty().subtract(entryInfo.getRepairRptTotalQty()));
                    }
                    if (vo.getCouldQty().doubleValue() <= 0.0) continue;
                    vo.setQty(vo.getCouldQty());
                    vo.setStorage(info.getStorageOrgUnit());
                    voColls.add(vo);
                    continue;
                }
                if (entryInfo.isUrgentRelease()) continue;
                FinishedRptCRInfo checkInfo = null;
                for (int k = 0; k < entryInfo.getCheckEntry().size(); ++k) {
                    checkInfo = entryInfo.getCheckEntry().get(k);
                    isMaterialValidate = FinishedRptBotpUtil.checkToOrderMaterial(checkInfo.getMaterial(), info.getStorageOrgUnit());
                    if (!isMaterialValidate) continue;
                    vo = new FinishedRptOrderVO();
                    vo.setFinishedRptID(info.getId().toString());
                    vo.setFinishedRptEntryID(entryInfo.getId().toString());
                    vo.setFinishedrptCRID(checkInfo.getId().toString());
                    vo.setFinishedRptNum(info.getNumber());
                    if (checkInfo.getMaterial() != null) {
                        vo.setMaterial(checkInfo.getMaterial());
                    } else {
                        vo.setMaterial(entryInfo.getMaterial());
                    }
                    if (checkInfo.getUnit() != null) {
                        vo.setUnit(checkInfo.getUnit());
                    } else {
                        vo.setUnit(entryInfo.getUnit());
                    }
                    vo.setPrecision(MMUtils.getQtyPrecision((String)vo.getMaterial().getId().toString(), (String)vo.getUnit().getId().toString()));
                    vo.setCouldQty(checkInfo.getQty().subtract(checkInfo.getTotalReportQty()));
                    vo.setQty(vo.getCouldQty());
                    vo.setStorage(info.getStorageOrgUnit());
                    if (vo.getCouldQty().doubleValue() <= 0.0) continue;
                    voColls.add(vo);
                }
            }
        }
        if (voColls.size() <= 0) {
            String noDataStr = "";
            noDataStr = type == 4 ? FinishedRptUtil.getResource("noReworkData") : FinishedRptUtil.getResource("noRepairData");
            MsgBox.showInfo((String)noDataStr);
            SysUtil.abort();
            return;
        }
        UIContext uiContext = new UIContext((Object)currentUi);
        uiContext.put((Object)PRD_DATA, voColls);
        IUIWindow uiWindow = null;
        uiWindow = type == 4 ? UIHelper.openUIWindow((UIContext)uiContext, (String)FinishedRptReworkUI.class.getName()) : UIHelper.openUIWindow((UIContext)uiContext, (String)FinishedRptRepairUI.class.getName());
        IUIObject ui = uiWindow.getUIObject();
        Map context = ui.getUIContext();
        List list = (List)context.get(PRD_DATA);
        if (list.size() <= 0) {
            return;
        }
        Integer retrunState = (Integer)context.get(BILLING_STATE);
        if (null != retrunState && retrunState == 0) {
            for (int i = 0; i < list.size(); ++i) {
                vo = (FinishedRptOrderVO)list.get(i);
                for (int j = 0; j < collection.size(); ++j) {
                    FinishedRptInfo info = collection.get(j);
                    if (!info.getId().toString().equals(vo.getFinishedRptID())) continue;
                    for (int k = 0; k < info.getEntrys().size(); ++k) {
                        FinishedRptEntryInfo entryInfo = info.getEntrys().get(k);
                        if (vo.getFinishedrptCRID() == null || vo.getFinishedrptCRID().trim().equals("")) {
                            if (!entryInfo.getId().toString().equals(vo.getFinishedRptEntryID())) continue;
                            entryInfo.setCurrPrdQty(vo.getQty());
                            continue;
                        }
                        if (!entryInfo.getId().toString().equals(vo.getFinishedRptEntryID())) continue;
                        FinishedRptCRInfo checkInfo = null;
                        for (int m = 0; m < entryInfo.getCheckEntry().size(); ++m) {
                            checkInfo = entryInfo.getCheckEntry().get(m);
                            if (!vo.getFinishedrptCRID().equals(checkInfo.getId().toString())) continue;
                            checkInfo.setCurrQty(vo.getQty());
                        }
                    }
                }
            }
            boolean flag = false;
            String successStr = "";
            IObjectPK[] pks = new IObjectPK[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                pks[i] = new ObjectUuidPK(collection.get(i).getId().toString());
            }
            if (type == 4) {
                flag = FinishedRptFactory.getRemoteInstance().makeReworkOrder((IObjectCollection)collection, pks);
                successStr = FinishedRptUtil.getResource("successReworkOrder");
            } else {
                flag = FinishedRptFactory.getRemoteInstance().makeRepairOrder((IObjectCollection)collection, pks);
                successStr = FinishedRptUtil.getResource("successRepairOrder");
            }
            if (flag) {
                MsgBox.showInfo((String)successStr);
            }
        }
    }

    public static boolean checkToOrderMaterial(MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("materialAttr", (Object)new Integer(10030), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialAttr", (Object)new Integer(10050), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filter.setMaskString("(#0 or #1) and #2 and #3 and #4");
        env.setFilter(filter);
        MaterialPlanCollection colls = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(env);
        return colls.size() > 0 && material.getStatus().getValue() == 1;
    }

    public static void customDirectDis(CoreUI currentUi, IObjectCollection srcObjCols) throws Exception {
        HashMap<String, Boolean> hasCheckModular = new HashMap<String, Boolean>();
        if (null == srcObjCols) {
            return;
        }
        String orgUnitID = null;
        ArrayList<DirectDisParentVO> directDisColls = new ArrayList<DirectDisParentVO>();
        for (int i = 0; i < srcObjCols.size(); ++i) {
            FinishedRptInfo info = (FinishedRptInfo)srcObjCols.getObject(i);
            orgUnitID = info.getStorageOrgUnit().getId().toString();
            Object value = hasCheckModular.get(orgUnitID);
            boolean flag = false;
            if (value == null) {
                flag = FinishedRptUtil.hasCheckModular(orgUnitID);
                hasCheckModular.put(orgUnitID, new Boolean(flag));
            } else {
                Boolean token = (Boolean)hasCheckModular.get(orgUnitID);
                if (token.booleanValue()) {
                    flag = true;
                }
            }
            FinishedRptEntryInfo entryInfo = null;
            DirectDisParentVO parent = null;
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                entryInfo = info.getEntrys().get(j);
                if (!flag || flag && !entryInfo.isIsCheck() || flag && entryInfo.isUrgentRelease()) {
                    parent = FinishedRptBotpUtil.getDirectDisColls(info, info.getEntrys().get(j), null);
                    if (parent == null) continue;
                    directDisColls.add(parent);
                    continue;
                }
                FinishedRptCRInfo checkInfo = null;
                for (int k = 0; k < info.getEntrys().get(j).getCheckEntry().size(); ++k) {
                    checkInfo = info.getEntrys().get(j).getCheckEntry().get(k);
                    parent = FinishedRptBotpUtil.getDirectDisColls(info, info.getEntrys().get(j), checkInfo);
                    if (parent == null) continue;
                    directDisColls.add(parent);
                }
            }
        }
        if (directDisColls.size() <= 0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("noDirectDisData"));
            SysUtil.abort();
            return;
        }
        UIContext uiContext = new UIContext((Object)currentUi);
        uiContext.put((Object)DIRECTDIS_DATA, directDisColls);
        IUIWindow uiWindow = UIHelper.openUIWindow((UIContext)uiContext, (String)FinishedRptDirectDisUI.class.getName());
        FinishedRptDirectDisUI ui = (FinishedRptDirectDisUI)uiWindow.getUIObject();
        Map context = ui.getUIContext();
        Integer retrunState = (Integer)context.get(BILLING_STATE);
        if (null != retrunState && retrunState == 0) {
            List directDisData = (List)context.get(DIRECTDIS_DATA);
            IObjectPK[] pks = new IObjectPK[directDisData.size()];
            DirectDisParentVO parent = null;
            for (int i = 0; i < directDisData.size(); ++i) {
                parent = (DirectDisParentVO)directDisData.get(i);
                pks[i] = new ObjectUuidPK(parent.getFinishedRpt().getId().toString());
            }
            FinishedRptFactory.getRemoteInstance().makeDDMReceivingBill(directDisData, pks);
            MsgBox.showInfo((String)FinishedRptUtil.getResource("successDDM"));
        }
    }

    public static DirectDisParentVO getDirectDisColls(FinishedRptInfo info, FinishedRptEntryInfo entryInfo, FinishedRptCRInfo checkInfo) throws Exception {
        String value = ParamManager.getParamValue((IObjectPK)new ObjectUuidPK(info.getStorageOrgUnit().getId().toString()), (String)"directDisStyle");
        boolean directDisStyle = false;
        directDisStyle = value.trim().equals("true");
        DirectDisParentVO parent = new DirectDisParentVO();
        parent.setFinishedRpt(info);
        parent.setFinishedRptEntry(entryInfo);
        parent.setFinishedRptCR(checkInfo);
        parent.setStorage(info.getStorageOrgUnit());
        parent.setProductionOrder(info.getProductionOrder());
        parent.setTaspBill(info.getTaskDispBill());
        parent.setFinishedRptId(info.getId().toString());
        parent.setFinishedRptEntryId(entryInfo.getId().toString());
        if (checkInfo == null) {
            parent.setMaterial(entryInfo.getMaterial());
            parent.setUnit(entryInfo.getUnit());
            boolean flag = FinishedRptUtil.hasCheckModular(info.getStorageOrgUnit().getId().toString());
            if (!flag || !entryInfo.isIsCheck()) {
                parent.setCouldQty(entryInfo.getTotalPassQty().subtract(entryInfo.getTotalReversePreQty()).subtract(entryInfo.getStockTotalQty()));
            } else if (entryInfo.isUrgentRelease()) {
                parent.setCouldQty(entryInfo.getCommitQty().subtract(entryInfo.getTotalReversePreQty()).subtract(entryInfo.getStockTotalQty()));
            }
        } else {
            parent.setFinishedRptCRId(checkInfo.getId().toString());
            parent.setMaterial(checkInfo.getMaterial());
            parent.setUnit(checkInfo.getUnit());
            parent.setCouldQty(checkInfo.getQty().subtract(checkInfo.getTotalReportQty()));
        }
        BigDecimal baseCouldQty = SCMUtils.getExchangeQtyForClient((String)parent.getMaterial().getId().toString(), (MeasureUnitInfo)parent.getUnit(), (MeasureUnitInfo)parent.getMaterial().getBaseUnit(), (BigDecimal)parent.getCouldQty());
        parent.setBaseCouldQty(baseCouldQty);
        parent.setCurrQty(new BigDecimal("0"));
        parent.setBaseCurrQty(new BigDecimal("0"));
        if (parent.getCouldQty().doubleValue() <= 0.0) {
            return null;
        }
        if (directDisStyle) {
            String motherId = info.getProductionOrder().getMotherBillId();
            if (motherId != null && !motherId.trim().equals("")) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("trackNumber.*");
                sic.add("stockEntry.*");
                sic.add("stockEntry.material.*");
                sic.add("stockEntry.unit.*");
                EntityViewInfo env = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("sourceBillEntry", (Object)motherId, CompareType.EQUALS));
                HashSet<Integer> status = new HashSet<Integer>();
                status.add(new Integer(4));
                status.add(new Integer(5));
                status.add(new Integer(8));
                filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
                env.setFilter(filter);
                env.setSelector(sic);
                ProductionOrderCollection prdColls = ProductionOrderFactory.getRemoteInstance().getProductionOrderCollection(env);
                if (prdColls.size() <= 0) {
                    return null;
                }
                ProductionOrderInfo motherInfo = prdColls.get(0);
                ProductionOrderStockEntryCollection stockEntryColls = motherInfo.getStockEntry();
                ProductionOrderStockEntryInfo stockEntryInfo = null;
                DirectDisChildVO child = null;
                for (int i = 0; i < stockEntryColls.size(); ++i) {
                    stockEntryInfo = stockEntryColls.get(i);
                    if (!stockEntryInfo.getMaterial().getId().toString().equals(parent.getMaterial().getId().toString()) || stockEntryInfo.getIssMode().getValue() != 11050) continue;
                    child = new DirectDisChildVO();
                    child.setProducitonOrder(motherInfo);
                    child.setStockInfo(stockEntryInfo);
                    child.setUnit(stockEntryInfo.getUnit());
                    child.setCouldQty(stockEntryInfo.getQty().subtract(stockEntryInfo.getTotleReceiveQty()));
                    baseCouldQty = SCMUtils.getExchangeQtyForClient((String)parent.getMaterial().getId().toString(), (MeasureUnitInfo)child.getUnit(), (MeasureUnitInfo)parent.getMaterial().getBaseUnit(), (BigDecimal)child.getCouldQty());
                    child.setBaseCouldQty(baseCouldQty);
                    child.setCurrQty(new BigDecimal("0"));
                    child.setBaseCurrQty(new BigDecimal("0"));
                    BigDecimal temp = stockEntryInfo.getQty().subtract(stockEntryInfo.getTotleReceiveQty());
                    if (temp.doubleValue() <= 0.0) continue;
                    parent.getChildDirectDisVO().add(child);
                }
                return parent;
            }
            return null;
        }
        EntityViewInfo env = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("material.*");
        sic.add("unit.*");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("parent.storageOrgUnit.*");
        sic.add("parent.productLine.*");
        sic.add("parent.workShop.*");
        sic.add("parent.classGroup.*");
        sic.add("parent.classTeam.*");
        sic.add("parent.trackNumber.*");
        env.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)parent.getMaterial().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)parent.getStorage().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("issMode", (Object)new Integer(11050), CompareType.EQUALS));
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        status.add(new Integer(5));
        status.add(new Integer(8));
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", status, CompareType.INCLUDE));
        env.setFilter(filter);
        ProductionOrderStockEntryCollection stockEntryColls = ProductionOrderStockEntryFactory.getRemoteInstance().getProductionOrderStockEntryCollection(env);
        ProductionOrderStockEntryInfo stockEntryInfo = null;
        DirectDisChildVO child = null;
        for (int i = 0; i < stockEntryColls.size(); ++i) {
            stockEntryInfo = stockEntryColls.get(i);
            BigDecimal result = stockEntryInfo.getTotleReceiveQty().subtract(stockEntryInfo.getQty());
            if (!(result.doubleValue() < 0.0)) continue;
            child = new DirectDisChildVO();
            child.setProducitonOrder(stockEntryInfo.getParent());
            child.setStockInfo(stockEntryInfo);
            child.setUnit(stockEntryInfo.getUnit());
            child.setCouldQty(stockEntryInfo.getQty().subtract(stockEntryInfo.getTotleReceiveQty()));
            baseCouldQty = SCMUtils.getExchangeQtyForClient((String)parent.getMaterial().getId().toString(), (MeasureUnitInfo)child.getUnit(), (MeasureUnitInfo)parent.getMaterial().getBaseUnit(), (BigDecimal)child.getCouldQty());
            child.setBaseCouldQty(baseCouldQty);
            child.setCurrQty(new BigDecimal("0"));
            child.setBaseCurrQty(new BigDecimal("0"));
            BigDecimal temp = stockEntryInfo.getQty().subtract(stockEntryInfo.getTotleReceiveQty());
            if (temp.doubleValue() <= 0.0) continue;
            parent.getChildDirectDisVO().add(child);
        }
        return parent;
    }
}

