/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.control.FinishedRptCheckReqVO;
import com.kingdee.eas.mm.control.client.AbstractFinishedRptCheckReqUI;
import com.kingdee.eas.mm.control.util.FinishedRptUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FinishedRptCheckReqUI
extends AbstractFinishedRptCheckReqUI {
    private static final Logger logger = CoreUIObject.getLogger(FinishedRptCheckReqUI.class);
    private static String TB_STORAGEORGUNIT = "storageOrgUnit";
    private static String TB_FINISHEDRPTNUM = "finishedRptNum";
    private static String TB_MATERIAL = "materialNum";
    private static String TB_MATERIALNAME = "materialName";
    private static String TB_MODEL = "model";
    private static String TB_UNIT = "unit";
    private static String TB_COULDCHECKQTY = "couldCheckQty";
    private static String TB_CHECKQTY = "checkQty";
    private static String TB_FINISHEDRPTID = "finishedRptId";
    private static String TB_FINISHEDRPTENTRYID = "finishedRptEntryId";
    private static final String TB_BOTP = "BOTP";
    private static final String TB_CUID = "cuId";
    private IBOTMapping iBOTMapping;
    private Map botpMap = new HashMap();
    private KDTActiveCellListener kdtActiveCellListener;
    private static final String[] QTYPRECISIONFROMUNITTAB = new String[]{TB_COULDCHECKQTY, TB_CHECKQTY};
    private List checkReqs;

    protected void initListener() {
        super.initListener();
        if (this.kdtActiveCellListener == null) {
            this.kdtActiveCellListener = new KDTActiveCellListener(){

                public void activeCellChanged(KDTActiveCellEvent e) {
                    try {
                        FinishedRptCheckReqUI.this.tblMain_activeCellChanged(e);
                    }
                    catch (Exception ex) {
                        FinishedRptCheckReqUI.this.handUIExceptionAndAbort(ex);
                    }
                }
            };
            this.kdTable.addKDTActiveCellListener(this.kdtActiveCellListener);
        }
    }

    private void tblMain_activeCellChanged(KDTActiveCellEvent e) throws BOTPException, BOSException {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColumnIndex();
        if (rowIndex < 0 || colIndex < 0) {
            return;
        }
        if (TB_BOTP.equals(this.kdTable.getColumnKey(colIndex))) {
            String cuId = (String)this.kdTable.getCell(rowIndex, TB_CUID).getValue();
            BOTMappingCollection botMappingCol = this.getMappingCollection(cuId);
            EntityViewInfo view = this.getCurrBotpFilter(botMappingCol);
            KDTDefaultCellEditor botp_CellEditor = (KDTDefaultCellEditor)this.kdTable.getColumn(colIndex).getEditor();
            KDBizPromptBox botp_PromptBox = (KDBizPromptBox)botp_CellEditor.getComponent();
            botp_PromptBox.setEntityViewInfo(view);
        }
    }

    private void initBOTPRuleF7() throws BOSException, BOTPException {
        KDBizPromptBox botp_PromptBox = new KDBizPromptBox();
        botp_PromptBox.setQueryInfo("com.kingdee.bos.metadata.bot.BOTMappingQuery");
        botp_PromptBox.setEditable(true);
        botp_PromptBox.setEditFormat("$name$");
        botp_PromptBox.setDisplayFormat("$alias$");
        botp_PromptBox.setCommitFormat("$name$");
        KDTDefaultCellEditor botp_CellEditor = new KDTDefaultCellEditor((IKDEditor)botp_PromptBox);
        ObjectValueRender botp_OVR = new ObjectValueRender();
        botp_OVR.setFormat((IDataFormat)new BizDataFormat("$alias$"));
        this.kdTable.getColumn(TB_BOTP).setEditor((ICellEditor)botp_CellEditor);
        this.kdTable.getColumn(TB_BOTP).setRenderer((IBasicRender)botp_OVR);
    }

    private EntityViewInfo getCurrBotpFilter(BOTMappingCollection botMappingCol) throws BOTPException, BOSException {
        HashSet<String> botpIds = new HashSet<String>();
        int n = botMappingCol.size();
        for (int i = 0; i < n; ++i) {
            botpIds.add(botMappingCol.get(i).getId().toString());
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", botpIds, CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        return entityView;
    }

    private BOTMappingCollection getMappingCollection(String cuId) throws BOSException, BOTPException {
        BOTMappingCollection botMappingCol;
        if (this.botpMap.containsKey(cuId)) {
            botMappingCol = (BOTMappingCollection)this.botpMap.get(cuId);
        } else {
            if (this.iBOTMapping == null) {
                this.iBOTMapping = BOTMappingFactory.getRemoteInstance();
            }
            HashMap<String, String> transmitCtx = null;
            if (!StringUtils.isEmpty((String)cuId)) {
                transmitCtx = new HashMap<String, String>();
                transmitCtx.put("TRANSMITCU_ID", cuId);
            }
            botMappingCol = this.iBOTMapping.getMappingCollectionForSelect("F2901DDD", "751CA7E1", DefineSysEnum.BTP, transmitCtx);
            this.botpMap.put(cuId, botMappingCol);
        }
        return botMappingCol;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        Dimension d = KDToolkit.getScreenSize();
        int w = 1024;
        int h = 768;
        if (d != null) {
            h = d.height;
            w = d.width;
        }
        int width = w <= 1024 ? w - 100 : w - 256;
        int height = h <= 768 ? h - 100 : h * 2 / 3;
        this.setPreferredSize(new Dimension(width, height));
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initBOTPRuleF7();
        this.initData(this.kdTable);
        this.kdTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                block6: {
                    try {
                        Object newValue;
                        Object oldValue;
                        int rowIndex = e.getRowIndex();
                        int colIndex = e.getColIndex();
                        String fieldName = FinishedRptCheckReqUI.this.kdTable.getColumnKey(colIndex);
                        if (TB_CHECKQTY.equalsIgnoreCase(fieldName)) {
                            oldValue = e.getOldValue();
                            newValue = e.getValue();
                            if (oldValue != null && newValue != null) {
                                BigDecimal oldBigValue = (BigDecimal)oldValue;
                                BigDecimal newBigValue = (BigDecimal)newValue;
                                if ((oldBigValue = oldBigValue.setScale(newBigValue.scale(), 4)).compareTo(newBigValue) == 0) {
                                    return;
                                }
                                FinishedRptCheckReqVO vo = (FinishedRptCheckReqVO)FinishedRptCheckReqUI.this.kdTable.getRow(rowIndex).getUserObject();
                                vo.setCheckQty(newBigValue);
                            }
                        }
                        if (!FinishedRptCheckReqUI.TB_BOTP.equalsIgnoreCase(fieldName)) break block6;
                        oldValue = e.getOldValue();
                        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getValue()));
                        if (isDiffrent && newValue != null) {
                            FinishedRptCheckReqVO vo = (FinishedRptCheckReqVO)FinishedRptCheckReqUI.this.kdTable.getRow(rowIndex).getUserObject();
                            vo.setBotpRule((BOTMappingInfo)newValue);
                            break block6;
                        }
                        return;
                    }
                    catch (Exception exc) {
                        FinishedRptCheckReqUI.this.handUIException(exc);
                    }
                }
            }
        });
    }

    private void initData(KDTable kdtTable) throws EASBizException, BOSException {
        this.checkReqs = (List)this.getUIContext().get("checkData");
        MaterialInfo[] materialInfos = null;
        MeasureUnitInfo[] measureUnitInfos = null;
        int[] rowIndexs = null;
        if (null != this.checkReqs) {
            materialInfos = new MaterialInfo[this.checkReqs.size()];
            measureUnitInfos = new MeasureUnitInfo[this.checkReqs.size()];
            rowIndexs = new int[this.checkReqs.size()];
            int rowIndex = 0;
            String msg_yes = ResourceManage.getResource((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"YES");
            String msg_no = ResourceManage.getResource((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"NO");
            KDFormattedTextField numberTextField = new KDFormattedTextField(1);
            numberTextField.setPrecision(8);
            numberTextField.setNegatived(false);
            IColumn col = kdtTable.getColumn(TB_CHECKQTY);
            col = kdtTable.getColumn(TB_CHECKQTY);
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
            col.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            col = kdtTable.getColumn(TB_COULDCHECKQTY);
            col = kdtTable.getColumn(TB_COULDCHECKQTY);
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
            col.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            for (int i = 0; i < this.checkReqs.size(); ++i) {
                FinishedRptCheckReqVO vo = (FinishedRptCheckReqVO)this.checkReqs.get(i);
                IRow row = kdtTable.addRow();
                row.setUserObject((Object)vo);
                row.getCell(TB_STORAGEORGUNIT).setValue((Object)vo.getStorageOrgUnit().getName());
                row.getCell(TB_FINISHEDRPTNUM).setValue((Object)vo.getFinishedRptNum());
                row.getCell(TB_MATERIAL).setValue((Object)vo.getMaterial().getNumber());
                row.getCell(TB_MATERIALNAME).setValue((Object)vo.getMaterial().getName());
                row.getCell(TB_UNIT).setValue((Object)vo.getUnit());
                row.getCell(TB_MODEL).setValue((Object)vo.getMaterial().getModel());
                row.getCell(TB_COULDCHECKQTY).setValue((Object)vo.getCouldCheckQty());
                row.getCell(TB_CHECKQTY).setValue((Object)vo.getCheckQty());
                row.getCell(TB_FINISHEDRPTID).setValue((Object)vo.getFinishedRptId());
                row.getCell(TB_FINISHEDRPTENTRYID).setValue((Object)vo.getFinishedRptEntryId());
                row.getCell(TB_CUID).setValue((Object)vo.getStorageOrgUnit().getCU().getId().toString());
                BOTMappingCollection botMappingCol = this.getMappingCollection(vo.getStorageOrgUnit().getCU().getId().toString());
                row.getCell(TB_BOTP).setValue((Object)botMappingCol.get(0));
                vo.setBotpRule(botMappingCol.get(0));
                materialInfos[rowIndex] = vo.getMaterial();
                measureUnitInfos[rowIndex] = vo.getUnit();
                rowIndexs[rowIndex] = rowIndex;
                ++rowIndex;
            }
        }
        SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, measureUnitInfos, (KDTable)kdtTable, (String[])QTYPRECISIONFROMUNITTAB, rowIndexs);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkBOTP();
        this.checkQty();
        this.getUIContext().put("retrunState", new Integer(0));
        this.getUIContext().put("checkData", this.checkReqs);
        this.actionExitCurrent_actionPerformed(e);
    }

    private void checkBOTP() {
        for (int i = 0; i < this.kdTable.getRowCount(); ++i) {
            Object o = this.kdTable.getCell(i, TB_BOTP).getValue();
            if (o != null) continue;
            MsgBox.showInfo((String)FinishedRptUtil.getResource("BOTP_NOTNULL"));
            SysUtil.abort();
        }
    }

    private void checkQty() {
        ArrayList<Integer> blankList = new ArrayList<Integer>();
        ArrayList<Integer> lessList = new ArrayList<Integer>();
        ArrayList<Integer> zeroList = new ArrayList<Integer>();
        for (int i = 0; i < this.kdTable.getRowCount(); ++i) {
            BigDecimal couldCheckQty = (BigDecimal)this.kdTable.getCell(i, TB_COULDCHECKQTY).getValue();
            BigDecimal checkQty = (BigDecimal)this.kdTable.getCell(i, TB_CHECKQTY).getValue();
            if (checkQty == null) {
                blankList.add(new Integer(i + 1));
                continue;
            }
            if (checkQty.doubleValue() == 0.0) {
                zeroList.add(new Integer(i + 1));
                continue;
            }
            if (!(couldCheckQty.doubleValue() < checkQty.doubleValue())) continue;
            lessList.add(new Integer(i + 1));
        }
        StringBuffer str = new StringBuffer();
        if (blankList.size() > 0) {
            str.append(FinishedRptUtil.getResource("head"));
            for (int i = 0; i < blankList.size(); ++i) {
                if (i != 0) {
                    str.append(",");
                }
                int row = (Integer)blankList.get(i);
                str.append(row);
            }
            str.append(FinishedRptUtil.getResource("checkQtyBlank") + "\n");
        }
        if (lessList.size() > 0) {
            str.append(FinishedRptUtil.getResource("head"));
            for (int i = 0; i < lessList.size(); ++i) {
                if (i != 0) {
                    str.append(",");
                }
                int row = (Integer)lessList.get(i);
                str.append(row);
            }
            str.append(FinishedRptUtil.getResource("checkQtyMore") + "\n");
        }
        if (zeroList.size() > 0) {
            str.append(FinishedRptUtil.getResource("head"));
            for (int i = 0; i < zeroList.size(); ++i) {
                if (i != 0) {
                    str.append(",");
                }
                int row = (Integer)zeroList.get(i);
                str.append(row);
            }
            str.append(FinishedRptUtil.getResource("checkQtyNotZero") + "\n");
        }
        if (str.length() > 0) {
            MsgBox.showInfo((String)str.toString());
            SysUtil.abort();
            return;
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

