/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.control.DirectDisChildVO;
import com.kingdee.eas.mm.control.DirectDisParentVO;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.client.AbstractFinishedRptDirectDisUI;
import com.kingdee.eas.mm.control.util.FinishedRptUtil;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FinishedRptDirectDisUI
extends AbstractFinishedRptDirectDisUI {
    private static final Logger logger = CoreUIObject.getLogger(FinishedRptDirectDisUI.class);
    private static final String PARENT_STORAGE = "storageOrgUnit";
    private static final String PARENT_FINISHEDRPTNUM = "finishedRptNum";
    private static final String PARENT_PRDNUM = "prdOrderNum";
    private static final String PARENT_TASKDISPNUM = "taskDispNum";
    private static final String PARENT_MATERIALNUM = "material";
    private static final String PARENT_MATERIALNAME = "materialName";
    private static final String PARENT_UNIT = "unit";
    private static final String PARENT_MODEL = "model";
    private static final String PARENT_TRACKNUMBERID = "trackNumberID";
    private static final String PARENT_TRACKNUMBER = "trackNumber";
    private static final String PARENT_COULDQTY = "couldQty";
    private static final String PARENT_BASECOULDQTY = "baseCouldQty";
    private static final String PARENT_CURRQTY = "currQty";
    private static final String PARENT_BASECURRQTY = "baseCurrQty";
    private static final String PARENT_FINISHEDRPTID = "finishedRptId";
    private static final String PARENT_FINISHEDRPTENTRYID = "finishedRptEntryId";
    private static final String PARENT_FINISHEDRPTCRID = "FinishedRptCRId";
    private static final String CHILD_PRDNUM = "prdNum";
    private static final String CHILD_STOCKSQL = "stockEntry";
    private static final String CHILD_TRACKNUMBERID = "trackNumberID";
    private static final String CHILD_TRACKNUMBER = "trackNumber";
    private static final String CHILD_UNIT = "unit";
    private static final String CHILD_COULDQTY = "couldReceiveQty";
    private static final String CHILD_BASECOULDQTY = "baseCouldReceiveQty";
    private static final String CHILD_CURRQTY = "currDirectDisQty";
    private static final String CHILD_BASECURRQTY = "baseCurrDirectDisQty";
    private static final String CHILD_STARTDATE = "startDate";
    private static final String CHILD_ENDDATE = "endDate";
    private static final String CHILD_STOCKID = "stockId";
    private static final String[] CHI_DATETIMES = new String[]{"startDate", "endDate"};
    private List directDisColls = null;
    private DirectDisParentVO currentVO;
    private Map mulUnitMap = null;
    private KDTSelectListener parentKDTSelectListener;
    private DataChangeListener prmtPrdNumChangedListener;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtPrdNum.setText("");
    }

    protected void initListener() {
        this.parentKDTSelectListener = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                FinishedRptDirectDisUI.this.parentTableSelectChanged(e);
            }
        };
        this.prmtPrdNumChangedListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    FinishedRptDirectDisUI.this.prmtPrdNum_dataChanged(e);
                }
                catch (Exception exc) {
                    FinishedRptDirectDisUI.this.handUIException(exc);
                }
            }
        };
        this.tbParent.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                FinishedRptDirectDisUI.this.parentQtyChanged(e);
            }
        });
        this.tbChild.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                FinishedRptDirectDisUI.this.childQtyChanged(e);
            }
        });
    }

    private void addListener() {
        this.removeListener();
        this.tbParent.getSelectManager().addKDTSelectListener(this.parentKDTSelectListener);
        this.prmtPrdNum.addDataChangeListener(this.prmtPrdNumChangedListener);
    }

    private void removeListener() {
        if (null != this.parentKDTSelectListener) {
            this.tbParent.getSelectManager().removeKDTSelectListener(this.parentKDTSelectListener);
        }
        if (null != this.prmtPrdNumChangedListener) {
            this.prmtPrdNum.removeDataChangeListener(this.prmtPrdNumChangedListener);
        }
    }

    private void parentQtyChanged(KDTEditEvent e) {
        try {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.tbParent.getColumnKey(colIndex);
            if (PARENT_CURRQTY.equalsIgnoreCase(fieldName)) {
                Object oldValue = e.getOldValue();
                Object newValue = e.getValue();
                if (newValue != null) {
                    BigDecimal newBigValue;
                    BigDecimal oldBigValue = new BigDecimal("0");
                    if (oldValue != null) {
                        oldBigValue = (BigDecimal)oldValue;
                    }
                    if ((oldBigValue = oldBigValue.setScale((newBigValue = (BigDecimal)newValue).scale(), 4)).compareTo(newBigValue) == 0) {
                        return;
                    }
                    BigDecimal baseQty = SCMUtils.getExchangePricesionQtyForClient((String)this.currentVO.getMaterial().getId().toString(), (MeasureUnitInfo)this.currentVO.getUnit(), (MeasureUnitInfo)this.currentVO.getMaterial().getBaseUnit(), (BigDecimal)newBigValue);
                    this.currentVO.setCurrQty(newBigValue);
                    this.currentVO.setBaseCurrQty(baseQty);
                    this.tbParent.getCell(rowIndex, PARENT_BASECURRQTY).setValue((Object)baseQty);
                }
            }
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    private void childQtyChanged(KDTEditEvent e) {
        try {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.tbChild.getColumnKey(colIndex);
            if (CHILD_CURRQTY.equalsIgnoreCase(fieldName)) {
                Object oldValue = e.getOldValue();
                Object newValue = e.getValue();
                if (oldValue != null && newValue != null) {
                    BigDecimal oldBigValue = (BigDecimal)oldValue;
                    BigDecimal newBigValue = (BigDecimal)newValue;
                    if ((oldBigValue = oldBigValue.setScale(newBigValue.scale(), 4)).compareTo(newBigValue) == 0) {
                        return;
                    }
                    ICell cell = this.tbChild.getCell(rowIndex, CHILD_STOCKID);
                    List childList = this.currentVO.getChildDirectDisVO();
                    DirectDisChildVO child = null;
                    for (int i = 0; i < childList.size() && !(child = (DirectDisChildVO)childList.get(i)).getStockInfo().getId().toString().equals(cell.getValue().toString()); ++i) {
                    }
                    child.setCurrQty(newBigValue);
                    BigDecimal baseQty = SCMUtils.getExchangeQtyForClient((String)this.currentVO.getMaterial().getId().toString(), (MeasureUnitInfo)child.getUnit(), (MeasureUnitInfo)this.currentVO.getMaterial().getBaseUnit(), (BigDecimal)newBigValue);
                    child.setBaseCurrQty(baseQty);
                    this.tbChild.getCell(rowIndex, CHILD_BASECURRQTY).setValue((Object)baseQty);
                }
            }
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    private void prmtPrdNum_dataChanged(DataChangeEvent e) {
    }

    private void parentTableSelectChanged(KDTSelectEvent e) {
        this.prmtPrdNum.setText("");
        this.tbChild.removeRows();
        int selectedIndex = this.tbParent.getSelectManager().getActiveRowIndex();
        Object cell = null;
        String finishedRptId = this.tbParent.getCell(selectedIndex, PARENT_FINISHEDRPTID).getValue().toString();
        String finishedRptEntryId = this.tbParent.getCell(selectedIndex, PARENT_FINISHEDRPTENTRYID).getValue().toString();
        String finishedRptCRId = null;
        if (this.tbParent.getCell(selectedIndex, PARENT_FINISHEDRPTCRID).getValue() != null) {
            finishedRptCRId = this.tbParent.getCell(selectedIndex, PARENT_FINISHEDRPTCRID).getValue().toString();
        }
        DirectDisParentVO parent = null;
        DirectDisChildVO child = null;
        IRow row = null;
        for (int i = 0; i < this.directDisColls.size(); ++i) {
            parent = (DirectDisParentVO)this.directDisColls.get(i);
            if (!finishedRptId.equals(parent.getFinishedRptId()) || !finishedRptEntryId.equals(parent.getFinishedRptEntryId()) || finishedRptCRId != null && !finishedRptCRId.equals(parent.getFinishedRptCRId())) continue;
            this.currentVO = parent;
            for (int j = 0; j < parent.getChildDirectDisVO().size(); ++j) {
                child = (DirectDisChildVO)parent.getChildDirectDisVO().get(j);
                if (!child.isSubmitBotp()) continue;
                row = this.tbChild.addRow();
                this.initChildRow(row, child, parent);
            }
            this.initF7();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAutoDis.setIcon(EASResource.getIcon((String)"imgTbtn_automatching"));
        this.btnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
    }

    @Override
    public void actionAutoDis_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbParent);
        if (selectRows.length == 0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("selectDDMRow"));
            SysUtil.abort();
        }
        IRow row = this.tbParent.getRow(selectRows[0]);
        BigDecimal couldVal = (BigDecimal)row.getCell(PARENT_COULDQTY).getValue();
        BigDecimal currVal = (BigDecimal)row.getCell(PARENT_CURRQTY).getValue();
        if (currVal == null || currVal.doubleValue() <= 0.0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("checkDDMQty"));
            SysUtil.abort();
        }
        if (couldVal.subtract(currVal).doubleValue() < 0.0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("checkDDMMoreQty"));
            SysUtil.abort();
        }
        BigDecimal baseParentQty = (BigDecimal)row.getCell(PARENT_BASECURRQTY).getValue();
        List childList = this.currentVO.getChildDirectDisVO();
        DirectDisChildVO child = null;
        for (int i2 = 0; i2 < childList.size(); ++i2) {
            child = (DirectDisChildVO)childList.get(i2);
            child.setCurrQty(new BigDecimal("0"));
            child.setBaseCurrQty(new BigDecimal("0"));
        }
        BigDecimal temp = null;
        for (i = 0; i < childList.size(); ++i) {
            BigDecimal qty;
            child = (DirectDisChildVO)childList.get(i);
            if (!child.isSubmitBotp()) continue;
            BigDecimal baseCouldQty = child.getBaseCouldQty();
            if (baseParentQty.subtract(baseCouldQty).doubleValue() <= 0.0) {
                temp = baseParentQty.subtract(baseCouldQty);
                child.setBaseCurrQty(baseParentQty);
                qty = SCMUtils.getExchangeQtyForClient((String)this.currentVO.getMaterial().getId().toString(), (MeasureUnitInfo)this.currentVO.getMaterial().getBaseUnit(), (MeasureUnitInfo)child.getUnit(), (BigDecimal)baseParentQty);
                child.setCurrQty(qty);
                break;
            }
            child.setBaseCurrQty(baseCouldQty);
            qty = SCMUtils.getExchangeQtyForClient((String)this.currentVO.getMaterial().getId().toString(), (MeasureUnitInfo)this.currentVO.getMaterial().getBaseUnit(), (MeasureUnitInfo)child.getUnit(), (BigDecimal)baseCouldQty);
            child.setCurrQty(qty);
            temp = baseParentQty.subtract(baseCouldQty);
            baseParentQty = baseParentQty.subtract(baseCouldQty);
        }
        if (temp == null || temp.doubleValue() > 0.0) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("checkDDMQty2"));
            SysUtil.abort();
        }
        this.tbChild.removeRows();
        for (i = 0; i < childList.size(); ++i) {
            child = (DirectDisChildVO)childList.get(i);
            if (!child.isSubmitBotp()) continue;
            row = this.tbChild.addRow();
            this.initChildRow(row, child, this.currentVO);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkBlank();
        this.checkZero();
        this.checkMoreQty();
        this.checkEqualQty();
        this.getUIContext().put("retrunState", new Integer(0));
        this.getUIContext().put("directiDisData", this.directDisColls);
        this.actionExitCurrent_actionPerformed(e);
    }

    private void checkBlank() {
        ArrayList<Integer> blankList = new ArrayList<Integer>();
        IRow row = null;
        ICell cell = null;
        for (int i = 0; i < this.tbParent.getRowCount(); ++i) {
            row = this.tbParent.getRow(i);
            cell = row.getCell(PARENT_CURRQTY);
            if (cell.getValue() != null) continue;
            blankList.add(new Integer(i + 1));
        }
        if (blankList.size() > 0) {
            String errorStr = FinishedRptUtil.getResource("head");
            errorStr = errorStr + ((Object)blankList).toString().substring(1, ((Object)blankList).toString().length() - 1);
            if ((errorStr = errorStr + FinishedRptUtil.getResource("DDMQtyNull")).length() > 0) {
                MsgBox.showInfo((String)errorStr);
                SysUtil.abort();
            }
        }
    }

    private void checkZero() {
        DirectDisParentVO parent = null;
        ArrayList<Integer> zeroList = new ArrayList<Integer>();
        for (int i = 0; i < this.directDisColls.size(); ++i) {
            parent = (DirectDisParentVO)this.directDisColls.get(i);
            if (parent.getCurrQty().doubleValue() != 0.0) continue;
            zeroList.add(new Integer(i + 1));
        }
        String errorStr = "";
        if (zeroList.size() > 0) {
            errorStr = errorStr + FinishedRptUtil.getResource("head");
            errorStr = errorStr + ((Object)zeroList).toString().substring(1, ((Object)zeroList).toString().length() - 1);
            errorStr = errorStr + FinishedRptUtil.getResource("DDMQtyZero");
        }
        if (errorStr.length() > 0) {
            MsgBox.showInfo((String)errorStr);
            SysUtil.abort();
        }
    }

    private void checkMoreQty() {
        DirectDisParentVO parent = null;
        ArrayList<Integer> parentMoreList = new ArrayList<Integer>();
        ArrayList<Serializable> childMoreList = new ArrayList<Serializable>();
        for (int i = 0; i < this.directDisColls.size(); ++i) {
            parent = (DirectDisParentVO)this.directDisColls.get(i);
            BigDecimal baseQty = parent.getBaseCurrQty();
            DirectDisChildVO child = null;
            BigDecimal total = new BigDecimal("0");
            if (parent.getCurrQty().subtract(parent.getCouldQty()).doubleValue() > 0.0) {
                parentMoreList.add(new Integer(i + 1));
                continue;
            }
            ArrayList<Integer> chldren = new ArrayList<Integer>();
            for (int j = 0; j < parent.getChildDirectDisVO().size(); ++j) {
                child = (DirectDisChildVO)parent.getChildDirectDisVO().get(j);
                total = total.add(child.getBaseCurrQty());
                if (!(child.getCurrQty().subtract(child.getCouldQty()).doubleValue() > 0.0)) continue;
                chldren.add(new Integer(j + 1));
            }
            if (chldren.size() <= 0) continue;
            childMoreList.add(new Integer(i + 1));
            childMoreList.add(chldren);
        }
        String errorStr = "";
        if (parentMoreList.size() > 0) {
            errorStr = errorStr + FinishedRptUtil.getResource("head");
            errorStr = errorStr + ((Object)parentMoreList).toString().subSequence(1, ((Object)parentMoreList).toString().length() - 1);
            errorStr = errorStr + FinishedRptUtil.getResource("qtyMoreThanCould");
        }
        if (errorStr.length() > 0) {
            errorStr = errorStr + "\n";
        }
        if (childMoreList.size() > 0) {
            for (int i = 0; i < childMoreList.size(); i += 2) {
                if (errorStr.length() > 0) {
                    errorStr = errorStr + "\n";
                }
                String index = childMoreList.get(i).toString();
                List childList = (List)childMoreList.get(i + 1);
                errorStr = errorStr + FinishedRptUtil.getResource("head") + index + ":";
                errorStr = errorStr + FinishedRptUtil.getResource("stockRow") + childList.toString().substring(1, childList.toString().length() - 1);
                errorStr = errorStr + FinishedRptUtil.getResource("receiveQtyMoreThanCould");
            }
        }
        if (errorStr.length() > 0) {
            MsgBox.showInfo((String)errorStr);
            SysUtil.abort();
        }
    }

    private String checkEqualQty() {
        DirectDisParentVO parent = null;
        ArrayList<Integer> rowList = new ArrayList<Integer>();
        for (int i = 0; i < this.directDisColls.size(); ++i) {
            parent = (DirectDisParentVO)this.directDisColls.get(i);
            BigDecimal baseQty = parent.getBaseCurrQty();
            DirectDisChildVO child = null;
            BigDecimal total = new BigDecimal("0");
            for (int j = 0; j < parent.getChildDirectDisVO().size(); ++j) {
                child = (DirectDisChildVO)parent.getChildDirectDisVO().get(j);
                total = total.add(child.getBaseCurrQty());
            }
            if (baseQty.subtract(total).doubleValue() == 0.0) continue;
            rowList.add(new Integer(i + 1));
        }
        String errorStr = "";
        if (rowList.size() > 0) {
            if (errorStr.length() > 0) {
                errorStr = errorStr + "\n";
            }
            errorStr = errorStr + FinishedRptUtil.getResource("head");
            errorStr = errorStr + ((Object)rowList).toString().substring(1, ((Object)rowList).toString().length() - 1);
            errorStr = errorStr + FinishedRptUtil.getResource("ddmQtyNotEqualReceivingQty");
        }
        if (errorStr.length() > 0) {
            MsgBox.showInfo((String)errorStr);
            SysUtil.abort();
        }
        return errorStr;
    }

    public void onShow() throws Exception {
        super.onShow();
        EditTableUtil.formatColDateTime((KDTable)this.tbChild, (String[])CHI_DATETIMES);
        this.tbParent.getSelectManager().setSelectMode(2);
        this.initTBData();
        this.initF7();
        this.addListener();
    }

    private void initF7() {
        List childList = this.currentVO.getChildDirectDisVO();
        HashSet<String> set = new HashSet<String>();
        DirectDisChildVO child = null;
        int size = 0;
        for (int i = 0; i < childList.size(); ++i) {
            child = (DirectDisChildVO)childList.get(i);
            set.add(child.getProducitonOrder().getNumber());
            if (!child.isSubmitBotp()) continue;
            ++size;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        this.prmtPrdNum.setEntityViewInfo(env);
        if (this.currentVO.isFirst()) {
            this.prmtPrdNum.setText("");
            this.txtReqDate.setValue(null);
            return;
        }
        if (size > 0) {
            ProductionOrderInfo[] orders = new ProductionOrderInfo[size];
            int index = 0;
            for (int i = 0; i < childList.size(); ++i) {
                child = (DirectDisChildVO)childList.get(i);
                if (!child.isSubmitBotp()) continue;
                orders[index] = child.getProducitonOrder();
                ++index;
            }
            this.prmtPrdNum.setValue((Object)orders);
        }
        this.txtReqDate.setValue((Object)this.currentVO.getReqDate());
    }

    private void initTBData() {
        int i;
        this.directDisColls = (List)this.getUIContext().get("directiDisData");
        MaterialInfo[] materialInfos = new MaterialInfo[this.directDisColls.size()];
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[this.directDisColls.size()];
        StorageOrgUnitInfo[] StorageOrgUnitInfos = new StorageOrgUnitInfo[this.directDisColls.size()];
        for (int i2 = 0; i2 < this.directDisColls.size(); ++i2) {
            materialInfos[i2] = ((DirectDisParentVO)this.directDisColls.get(i2)).getMaterial();
            measureUnitInfos[i2] = ((DirectDisParentVO)this.directDisColls.get(i2)).getUnit();
            StorageOrgUnitInfos[i2] = ((DirectDisParentVO)this.directDisColls.get(i2)).getStorage();
        }
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(materialInfos);
        vo.setStorageOrgUnitInfos(StorageOrgUnitInfos);
        vo.setIsLoadingMou(true);
        vo.setIsLoadingMmuPrecision(true);
        vo.setMeasureUnitInfos(measureUnitInfos);
        vo.setBaseMeasureUnitInfos(new MeasureUnitInfo[materialInfos.length]);
        vo.setAssistMeasureUnitInfos(new MeasureUnitInfo[materialInfos.length]);
        try {
            SCMEntryDataVO voResult = SCMGroupFacadeFactory.getRemoteInstance().loadComplexData(vo);
            this.mulUnitMap = voResult.getMmuPrecisions();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        DirectDisParentVO parent = null;
        DirectDisChildVO child = null;
        IRow row = null;
        KDFormattedTextField numberTextField = null;
        IColumn col = null;
        String[] cols = this.getParentPrecisionCol();
        for (i = 0; i < cols.length; ++i) {
            col = this.tbParent.getColumn(cols[i]);
            col.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        }
        cols = this.getChildPrecisionCol();
        for (i = 0; i < cols.length; ++i) {
            col = this.tbChild.getColumn(cols[i]);
            col.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        }
        for (i = 0; i < this.directDisColls.size(); ++i) {
            parent = (DirectDisParentVO)this.directDisColls.get(i);
            row = this.tbParent.addRow();
            row.getCell(PARENT_STORAGE).setValue((Object)parent.getStorage().getName());
            row.getCell(PARENT_FINISHEDRPTNUM).setValue((Object)parent.getFinishedRpt().getNumber());
            row.getCell(PARENT_PRDNUM).setValue((Object)parent.getProductionOrder().getNumber());
            if (parent.getFinishedRpt().getTrackNumber() != null) {
                row.getCell("trackNumberID").setValue((Object)parent.getFinishedRpt().getTrackNumber().getId().toString());
                row.getCell("trackNumber").setValue((Object)parent.getFinishedRpt().getTrackNumber().getNumber());
            }
            if (parent.getTaspBill() != null) {
                row.getCell(PARENT_TASKDISPNUM).setValue((Object)parent.getTaspBill().getNumber());
            }
            row.getCell(PARENT_MATERIALNUM).setValue((Object)parent.getMaterial().getNumber());
            row.getCell(PARENT_MATERIALNAME).setValue((Object)parent.getMaterial().getName());
            row.getCell("unit").setValue((Object)parent.getUnit().getName());
            row.getCell(PARENT_MODEL).setValue((Object)parent.getMaterial().getModel());
            row.getCell(PARENT_COULDQTY).setValue((Object)parent.getCouldQty());
            row.getCell(PARENT_BASECOULDQTY).setValue((Object)parent.getBaseCouldQty());
            row.getCell(PARENT_CURRQTY).setValue((Object)parent.getCurrQty());
            row.getCell(PARENT_BASECURRQTY).setValue((Object)parent.getBaseCurrQty());
            row.getCell(PARENT_FINISHEDRPTID).setValue((Object)parent.getFinishedRptId());
            row.getCell(PARENT_FINISHEDRPTENTRYID).setValue((Object)parent.getFinishedRptEntryId());
            row.getCell(PARENT_FINISHEDRPTCRID).setValue((Object)parent.getFinishedRptCRId());
            int precision = (Integer)this.mulUnitMap.get(parent.getMaterial().getId().toString() + parent.getUnit().getId().toString());
            numberTextField = new KDFormattedTextField(1);
            numberTextField.setPrecision(precision);
            numberTextField.setNegatived(false);
            row.getCell(PARENT_COULDQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
            row.getCell(PARENT_CURRQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
            int basePrecision = parent.getMaterial().getBaseUnit().getQtyPrecision();
            numberTextField = new KDFormattedTextField(1);
            numberTextField.setPrecision(basePrecision);
            numberTextField.setNegatived(false);
            row.getCell(PARENT_BASECOULDQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
            row.getCell(PARENT_BASECURRQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
            if (i != 0) continue;
            for (int j = 0; j < parent.getChildDirectDisVO().size(); ++j) {
                child = (DirectDisChildVO)parent.getChildDirectDisVO().get(j);
                row = this.tbChild.addRow();
                this.initChildRow(row, child, parent);
            }
        }
        if (this.directDisColls != null && this.directDisColls.size() > 0) {
            this.currentVO = (DirectDisParentVO)this.directDisColls.get(0);
        }
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        List childList = this.currentVO.getChildDirectDisVO();
        this.currentVO.setFirst(false);
        Date date = (Date)this.txtReqDate.getValue();
        Object[] vals = (Object[])this.prmtPrdNum.getValue();
        DirectDisChildVO child = null;
        this.tbChild.removeRows();
        IRow row = null;
        this.currentVO.setReqDate(date);
        for (int i = childList.size() - 1; i >= 0; --i) {
            child = (DirectDisChildVO)childList.get(i);
            String prdNum = child.getProducitonOrder().getNumber().trim();
            boolean isExistNum = false;
            for (int j = 0; vals != null && j < vals.length; ++j) {
                ProductionOrderInfo orderInfo = (ProductionOrderInfo)vals[j];
                if (orderInfo == null || !prdNum.equals(orderInfo.getNumber())) continue;
                isExistNum = true;
                break;
            }
            if (vals == null || vals.length == 1 && vals[0] == null) {
                isExistNum = true;
            }
            boolean isDateValidate = false;
            if (date == null) {
                isDateValidate = true;
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                Date reqDate = calendar.getTime();
                if (!reqDate.before(child.getStockInfo().getStartDate())) {
                    isDateValidate = true;
                }
            }
            if (isExistNum && isDateValidate) {
                row = this.tbChild.addRow();
                this.initChildRow(row, child, this.currentVO);
                child.setSubmitBotp(true);
                continue;
            }
            child.setSubmitBotp(false);
        }
    }

    private void initChildRow(IRow row, DirectDisChildVO child, DirectDisParentVO parent) {
        KDFormattedTextField numberTextField = null;
        row.getCell(CHILD_PRDNUM).setValue((Object)child.getProducitonOrder().getNumber());
        row.getCell(CHILD_STOCKSQL).setValue((Object)new Integer(child.getStockInfo().getSeq()));
        if (child.getProducitonOrder().getTrackNumber() != null) {
            row.getCell("trackNumberID").setValue((Object)child.getProducitonOrder().getTrackNumber().getId().toString());
            row.getCell("trackNumber").setValue((Object)child.getProducitonOrder().getTrackNumber().getNumber());
        }
        row.getCell("unit").setValue((Object)child.getUnit().getName());
        row.getCell(CHILD_COULDQTY).setValue((Object)child.getCouldQty());
        row.getCell(CHILD_BASECOULDQTY).setValue((Object)child.getBaseCouldQty());
        row.getCell(CHILD_CURRQTY).setValue((Object)child.getCurrQty());
        row.getCell(CHILD_BASECURRQTY).setValue((Object)child.getBaseCurrQty());
        row.getCell(CHILD_STARTDATE).setValue((Object)child.getStockInfo().getStartDate());
        row.getCell(CHILD_ENDDATE).setValue((Object)child.getStockInfo().getEndDate());
        row.getCell(CHILD_STOCKID).setValue((Object)child.getStockInfo().getId().toString());
        int precision = (Integer)this.mulUnitMap.get(parent.getMaterial().getId().toString() + parent.getUnit().getId().toString());
        numberTextField = new KDFormattedTextField(1);
        numberTextField.setPrecision(precision);
        numberTextField.setNegatived(false);
        row.getCell(CHILD_COULDQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
        row.getCell(CHILD_CURRQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
        numberTextField = new KDFormattedTextField(1);
        numberTextField.setPrecision(8);
        numberTextField.setNegatived(false);
        row.getCell(CHILD_BASECOULDQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
        row.getCell(CHILD_BASECURRQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numberTextField));
    }

    private String[] getParentPrecisionCol() {
        return new String[]{PARENT_COULDQTY, PARENT_BASECOULDQTY, PARENT_CURRQTY, PARENT_BASECOULDQTY};
    }

    private String[] getChildPrecisionCol() {
        return new String[]{CHILD_COULDQTY, CHILD_BASECOULDQTY, CHILD_CURRQTY, CHILD_BASECURRQTY};
    }
}

