/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.IProductLine;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.control.client.AbstractFinishedRptFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinishedRptFilterUI
extends AbstractFinishedRptFilterUI {
    private static final long serialVersionUID = 8724315185340629077L;
    private static final Logger logger = CoreUIObject.getLogger(FinishedRptFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_finishedRpt_view");
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, FinishedRptFilterUI.getResource("STORAGEORG_ISNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.setIsSupportMultiOrgs(true);
        this.prmtWorkshop.setEnabledMultiSelection(true);
        elements.add((FilterElement)new SingleFilterElement("workshop.number", (Component)this.prmtWorkshop));
        this.prmtProductLine.setEnabledMultiSelection(true);
        elements.add((FilterElement)new SingleFilterElement("productLine.number", (Component)this.prmtProductLine));
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        this.initTaskDispBillF7(this.prmtTaskDispBillFrom);
        this.initTaskDispBillF7(this.prmtTaskDispBillTo);
        elements.add((FilterElement)new RangeFilterElement("taskDispBill.number", (Component)this.prmtTaskDispBillFrom, (Component)this.prmtTaskDispBillTo));
        elements.add((FilterElement)new RangeFilterElement("productionOrder.number", (Component)this.prmtProductionOrderFrom, (Component)this.prmtProductionOrderTo));
        elements.add((FilterElement)new RangeFilterElement("shift.name", (Component)this.prmtShiftFrom, (Component)this.prmtShiftTo));
        elements.add((FilterElement)new RangeFilterElement("classGroup.number", (Component)this.prmtClassGroupFrom, (Component)this.prmtClassGroupTo));
        elements.add((FilterElement)new RangeFilterElement("person.number", (Component)this.prmtPersonFrom, (Component)this.prmtPersonTo));
        RangeFilterElement elementBizDate = new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo);
        elementBizDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elementBizDate.setDefaultValue((Object)new Timestamp[]{SCMUtils.getSCMQueryTime(null, (String)"startDate"), SCMUtils.getSCMQueryTime(null, (String)"endDate")});
        elements.add((FilterElement)elementBizDate);
        elements.add((FilterElement)new RangeFilterElement("creator.name", (Component)this.prmtCreatorFrom, (Component)this.prmtCreatorTo));
        this.cmbBaseStatus.removeAllItems();
        this.cmbBaseStatus.addItem((Object)BillBaseStatusEnum.NULL);
        this.cmbBaseStatus.addItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
        this.cmbBaseStatus.addItem((Object)BillBaseStatusEnum.SUBMITED);
        this.cmbBaseStatus.addItem((Object)BillBaseStatusEnum.AUDITED);
        this.cmbBaseStatus.addItem((Object)BillBaseStatusEnum.FINISH);
        this.cmbBaseStatus.addItem((Object)BillBaseStatusEnum.CLOSED);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.cmbBaseStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtWorkshop, this.prmtProductLine, this.prmtNumberFrom, this.prmtNumberTo, this.prmtTaskDispBillFrom, this.prmtTaskDispBillTo, this.prmtProductionOrderFrom, this.prmtProductionOrderTo, this.prmtShiftFrom, this.prmtShiftTo, this.prmtClassGroupFrom, this.prmtClassGroupTo});
        this.f7Manager.registerContextChangeF7(this.prmtNumberFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.prmtNumberTo, "storageOrgUnit.id");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private String transformNumberArray(KDBizPromptBox control) {
        String ids = control.getText();
        if (ids == null || ids != null && ids.length() == 0) {
            return null;
        }
        return ids.replaceAll(" ", "").replaceAll(";", "','");
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            CoreBaseCollection items;
            String numbers = this.transformNumberArray(this.prmtWorkshop);
            if (numbers != null) {
                IAdminOrgUnit admin = AdminOrgUnitFactory.getRemoteInstance();
                items = admin.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtWorkshop.setValue((Object)items.toArray());
            }
            if ((numbers = this.transformNumberArray(this.prmtProductLine)) != null) {
                IProductLine prodLine = ProductLineFactory.getRemoteInstance();
                items = prodLine.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtProductLine.setValue((Object)items.toArray());
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return null;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.client.ControlResource", (String)strKey);
    }

    private void initTaskDispBillF7(KDBizPromptBox prmttaskDispBill) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isManualFinish", (Object)new Boolean(false), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(8), CompareType.EQUALS));
        String maskString = "#0 or (#1 and #2)";
        filter.setMaskString(maskString);
        viewInfo.setFilter(filter);
        prmttaskDispBill.setEntityViewInfo(viewInfo);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        Set set = this.getBackFlushFlag();
        if (set.size() > 0) {
            FilterInfo newFilter = new FilterInfo();
            newFilter.getFilterItems().add(new FilterItemInfo("backFlushFlag", (Object)set, CompareType.INCLUDE));
            try {
                filter.mergeFilter(newFilter, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return filter;
    }

    public CustomerParams getCustomerParams() {
        String flagStr = StringUtil.arrayToString((Object[])this.getBackFlushFlag().toArray(), (String)",");
        CustomerParams params = super.getCustomerParams();
        params.addCustomerParam("backFlushFlag", flagStr);
        return params;
    }

    public void setCustomerParams(CustomerParams cp) {
        String flagStr = cp.getCustomerParam("backFlushFlag");
        if (flagStr != null && flagStr.length() > 0) {
            String[] flags = flagStr.split(",");
            this.setBackFlushFlag(flags);
        } else {
            this.setBackFlushFlag(null);
        }
        super.setCustomerParams(cp);
    }

    private Set getBackFlushFlag() {
        HashSet<Integer> set = new HashSet<Integer>();
        if (this.ckbNotBackFlush.isSelected()) {
            set.add(4);
        }
        if (this.ckbPartSuccess.isSelected()) {
            set.add(3);
        }
        if (this.ckbSuccess.isSelected()) {
            set.add(1);
        }
        if (this.ckbNoBackFlush.isSelected()) {
            set.add(5);
        }
        return set;
    }

    private void setBackFlushFlag(String[] flags) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (flags != null && flags.length > 0) {
            int n = flags.length;
            for (int i = 0; i < n; ++i) {
                set.add(Integer.parseInt(flags[i]));
            }
        }
        if (set.contains(4)) {
            this.ckbNotBackFlush.setSelected(true);
        } else {
            this.ckbNotBackFlush.setSelected(false);
        }
        if (set.contains(3)) {
            this.ckbPartSuccess.setSelected(true);
        } else {
            this.ckbPartSuccess.setSelected(false);
        }
        if (set.contains(1)) {
            this.ckbSuccess.setSelected(true);
        } else {
            this.ckbSuccess.setSelected(false);
        }
        if (set.contains(5)) {
            this.ckbNoBackFlush.setSelected(true);
        } else {
            this.ckbNoBackFlush.setSelected(false);
        }
    }

    public void clear() {
        super.clear();
        this.ckbNotBackFlush.setSelected(true);
        this.ckbPartSuccess.setSelected(true);
        this.ckbSuccess.setSelected(false);
        this.ckbNoBackFlush.setSelected(false);
    }
}

