/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.control.FinishedRptCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryFactory;
import com.kingdee.eas.mm.control.FinishedRptEntryInfo;
import com.kingdee.eas.mm.control.FinishedRptFactory;
import com.kingdee.eas.mm.control.FinishedRptInfo;
import com.kingdee.eas.mm.control.IFinishedRpt;
import com.kingdee.eas.mm.control.client.AbstractFinishedRptListUI;
import com.kingdee.eas.mm.control.client.FinishedRptBotpUtil;
import com.kingdee.eas.mm.control.client.FinishedRptEditUI;
import com.kingdee.eas.mm.control.client.FinishedRptFilterUI;
import com.kingdee.eas.mm.control.util.FinishedRptUtil;
import com.kingdee.eas.mm.lot.client.BatchFileEditUI;
import com.kingdee.eas.qm.qc.QCUITypeEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;

public class FinishedRptListUI
extends AbstractFinishedRptListUI {
    private static final long serialVersionUID = -6741062378786672094L;
    private static final Logger logger = CoreUIObject.getLogger(FinishedRptListUI.class);
    private FinishedRptFilterUI conditionPanel = null;
    private static final String TB_ENTRYID = "entrys.id";
    private static final String TB_BASESTATUS = "baseStatus";
    ParamUtil paramUtil = null;
    private static final String[] KDT_DATES = new String[]{"bizDate", "createTime"};
    private static final String[] KDT_DATETIMES = new String[]{"entrys.finishDate", "entrys.expDate"};
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public FinishedRptListUI() throws Exception {
        this.paramUtil = new ParamUtil(null);
    }

    public void onLoad() throws Exception {
        if (!this.isFinishedRptEnable()) {
            MsgBox.showWarning((Component)((Object)this), (String)FinishedRptUtil.getResource("noUseRptBill"));
            this.abort();
            return;
        }
        super.onLoad();
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                FinishedRptListUI.this.tbl_afterDataFill(e);
            }
        });
        this.btnAuditResult.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnRemove);
        this.btnUnBackFlush.setVisible(false);
        this.menuItemUnBackFlush.setVisible(false);
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        EditTableUtil.formatColDateTime((KDTable)this.tblMain, (String[])KDT_DATETIMES);
        super.setReservationVisible(false);
        this.btnSubmit.setEnabled(true);
        this.btnSubmit.setVisible(true);
    }

    private boolean isFinishedRptEnable() {
        boolean isRpt = true;
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        if (orgUnit != null && orgUnit.getId() != null) {
            this.paramUtil.setStorageOrgUnitID(orgUnit.getId().toString(), false);
            String enabledReport = this.paramUtil.getEnabledProductionReportParam("true");
            if (!"true".equals(enabledReport)) {
                isRpt = false;
            }
        }
        return isRpt;
    }

    @Override
    public void actionCheckResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionCheckResult_actionPerformed(e);
    }

    @Override
    public void actionDirectDis_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ((IFinishedRpt)this.getBizInterface()).commonCheck(idList, 2);
        HashMap<String, Boolean> hasCheckModular = new HashMap<String, Boolean>();
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            hs.add(idList.get(i).toString());
        }
        EntityViewInfo env = new EntityViewInfo();
        env.getSelector().add(new SelectorItemInfo("*"));
        env.getSelector().add(new SelectorItemInfo("storageOrgUnit.*"));
        env.getSelector().add(new SelectorItemInfo("entrys.*"));
        env.getSelector().add(new SelectorItemInfo("entrys.material.*"));
        env.getSelector().add(new SelectorItemInfo("entrys.unit.*"));
        env.getSelector().add(new SelectorItemInfo("entrys.warehouse.*"));
        env.getSelector().add(new SelectorItemInfo("entrys.warehouse.whman.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", hs, CompareType.INCLUDE));
        env.setFilter(filter);
        CoreBaseCollection colls = this.getBizInterface().getCollection(env);
        for (int i = 0; i < colls.size(); ++i) {
            FinishedRptInfo info = (FinishedRptInfo)colls.getObject(i);
            FinishedRptEntryCollection entryColls = info.getEntrys();
            boolean flag = false;
            if (hasCheckModular.get(info.getStorageOrgUnit().getId().toString()) != null) {
                Object value = hasCheckModular.get(info.getStorageOrgUnit().getId().toString());
                flag = (Boolean)value;
            } else {
                flag = FinishedRptUtil.hasCheckModular(info.getStorageOrgUnit().getId().toString());
                hasCheckModular.put(info.getStorageOrgUnit().getId().toString(), new Boolean(flag));
            }
            for (int j = entryColls.size() - 1; j >= 0; --j) {
                if (!entryColls.get(j).isIsDirectDis()) {
                    entryColls.removeObject(j);
                    continue;
                }
                if (!flag || !entryColls.get(j).isIsCheck() || entryColls.get(j).isUrgentRelease()) continue;
                entryColls.removeObject(j);
            }
        }
        FinishedRptBotpUtil.customDirectDis((CoreUI)this, (IObjectCollection)colls);
    }

    @Override
    public void actionGenCheckReq_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ((IFinishedRpt)this.getBizInterface()).commonCheck(idList, 1);
        HashSet<String> billIds = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            billIds.add(idList.get(i).toString());
        }
        HashSet<String> entryIds = new HashSet<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            entryIds.add((String)this.tblMain.getCell(selectRows[i], TB_ENTRYID).getValue());
        }
        FinishedRptBotpUtil.customFinishedRptTOMCheckReq((CoreUI)this, billIds, entryIds);
    }

    @Override
    public void actionRepair_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        ((IFinishedRpt)this.getBizInterface()).commonCheck(idList, 4);
        this.dealMakeOrder(5);
    }

    @Override
    public void actionRework_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        ((IFinishedRpt)this.getBizInterface()).commonCheck(idList, 3);
        this.dealMakeOrder(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealMakeOrder(int type) throws BOSException, EASBizException {
        int i;
        int i2;
        HashMap<String, Boolean> hasCheckModular = new HashMap<String, Boolean>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        HashSet<String> hs = new HashSet<String>();
        for (int i3 = 0; i3 < selectRows.length; ++i3) {
            String id = this.tblMain.getCell(selectRows[i3], TB_ENTRYID).getValue().toString();
            hs.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("material.*");
        selector.add("material.baseUnit.*");
        selector.add("unit.*");
        selector.add("parent.id");
        selector.add("parent.number");
        selector.add("parent.storageOrgUnit.*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", hs, CompareType.INCLUDE));
        view.setFilter(filter);
        FinishedRptEntryCollection entryCollection = FinishedRptEntryFactory.getRemoteInstance().getFinishedRptEntryCollection(view);
        hs = new HashSet();
        for (int i4 = 0; i4 < selectRows.length; ++i4) {
            String id = this.tblMain.getCell(selectRows[i4], "id").getValue().toString();
            hs.add(id);
        }
        view = new EntityViewInfo();
        selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("storageOrgUnit.*");
        view.setSelector(selector);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", hs, CompareType.INCLUDE));
        view.setFilter(filter);
        FinishedRptCollection collection = FinishedRptFactory.getRemoteInstance().getFinishedRptCollection(view);
        for (i2 = collection.size() - 1; i2 >= 0; --i2) {
            String orgUnitID = collection.get(i2).getStorageOrgUnit().getId().toString();
            Object value = hasCheckModular.get(orgUnitID);
            if (value == null) {
                boolean flag = FinishedRptUtil.hasCheckModular(orgUnitID);
                hasCheckModular.put(orgUnitID, new Boolean(flag));
                continue;
            }
            Boolean flag = (Boolean)value;
            if (!flag.booleanValue()) continue;
            collection.removeObject(i2);
        }
        for (i2 = 0; i2 < collection.size(); ++i2) {
            collection.get(i2).getEntrys().clear();
        }
        FinishedRptEntryInfo entryInfo = null;
        block15: for (i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            for (int j = 0; j < collection.size(); ++j) {
                if (!collection.get(j).getId().toString().equals(entryInfo.getParent().getId().toString())) continue;
                Boolean flag = (Boolean)hasCheckModular.get(collection.get(j).getStorageOrgUnit().getId().toString());
                if (flag.booleanValue() && entryInfo.isIsCheck() && (!entryInfo.isIsCheck() || !entryInfo.isUrgentRelease())) continue block15;
                collection.get(j).getEntrys().add(entryInfo);
                continue block15;
            }
        }
        try {
            for (i = 0; i < collection.size(); ++i) {
                String billId = collection.get(i).getId().toString();
                this.pubFireVOChangeListener(billId);
            }
            FinishedRptBotpUtil.customPrdOrder((CoreUI)this, (IObjectCollection)collection, type);
        }
        catch (Throwable e1) {
            this.handUIException(e1);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                for (i = 0; i < collection.size(); ++i) {
                    String billId = collection.get(i).getId().toString();
                    this.pubFireVOChangeListener(billId);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        super.tbl_afterDataFill(e);
        String[] fields = new String[]{"entrys.baseCommtQty", "entrys.commitQty"};
        if (null == fields || fields.length <= 0) {
            return;
        }
        int firstIndex = e.getFirstRow();
        int endIndex = e.getLastRow();
        for (int i = firstIndex; i <= endIndex; ++i) {
            for (int j = 0; j < fields.length; ++j) {
                Object objValue = this.tblMain.getCell(i, fields[j]).getValue();
                if (null != objValue && !StringUtils.isEmpty((String)objValue.toString())) continue;
                this.tblMain.getCell(i, fields[j]).setValue((Object)"0");
            }
        }
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.menuItemSubmit.setVisible(true);
        this.btnBackFlushed.setIcon(EASResource.getIcon((String)"imgTbtn_backwriting"));
        this.menuItemBackFlushed.setIcon(EASResource.getIcon((String)"imgTbtn_backwriting"));
        this.btnRework.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_rework", (Locale)this.getLocale()));
        this.menuItemRework.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_rework", (Locale)this.getLocale()));
        this.btnRepair.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_repair", (Locale)this.getLocale()));
        this.menuItemRepair.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_repair", (Locale)this.getLocale()));
        this.btnDirectDis.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_directdistribution", (Locale)this.getLocale()));
        this.menuItemDirectDis.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_directdistribution", (Locale)this.getLocale()));
        this.btnViewBatch.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_recordlot", (Locale)this.getLocale()));
        this.menuItemViewBatch.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_recordlot", (Locale)this.getLocale()));
        this.btnGenCheckReq.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_zoomdown", (Locale)this.getLocale()));
        this.menuItemGenCheckReq.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_zoomdown", (Locale)this.getLocale()));
        this.btnUnBackFlush.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_fbackwriting", (Locale)this.getLocale()));
        this.menuItemUnBackFlush.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_fbackwriting", (Locale)this.getLocale()));
        this.btnBizOperation.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_businessoperations", (Locale)this.getLocale()));
        this.initSubBar();
        this.kDMenuPercisionConfig.setText(this.kDMenuPercisionConfig.getText() + "(C)");
        this.kDMenuPercisionConfig.setIcon(EASResource.getIcon((String)"imgTbtn_showsetting"));
        this.kDMenuPercisionConfig.setMnemonic(67);
    }

    protected KDWorkButton[] getBizOperBarList() {
        return new KDWorkButton[]{this.btnBackFlushed, this.btnInStock, this.btnGenCheckReq, this.btnRework, this.btnRepair, this.btnDirectDis};
    }

    protected void initSubBar() {
        KDWorkButton[] bizOpers = this.getBizOperBarList();
        this.processSubBar(this.btnBizOperation, bizOpers);
    }

    protected void processSubBar(KDWorkButton parent, KDWorkButton[] childList) {
        for (int i = 0; i < childList.length; ++i) {
            KDWorkButton child = childList[i];
            child.setVisible(false);
            KDMenuItem bizProcessBar = new KDMenuItem(child.getText());
            bizProcessBar.setAction(child.getAction());
            bizProcessBar.setIcon(child.getIcon());
            parent.addAssistMenuItem((JMenuItem)bizProcessBar);
        }
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.initPSBatchActions();
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, FinishedRptFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", null, "number", null, "storageOrgUnit.id");
    }

    public void initPSBatchActions() {
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.DELETE, (ItemAction)this.actionRemove, (String)"delete");
        this.actionManager.registerBatchAction(actionProxy, "actionRemove");
        actionProxy.bindTo((AbstractButton)this.btnRemove);
        actionProxy.bindTo((AbstractButton)this.menuItemRemove);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.AUDIT, (ItemAction)this.actionAudit, (String)"audit");
        this.actionManager.registerBatchAction(actionProxy, "actionAudit");
        actionProxy.bindTo((AbstractButton)this.btnAudit);
        actionProxy.bindTo((AbstractButton)this.menuItemAudit);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnUnAudit);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNAUDIT, (ItemAction)this.actionUnAudit, (String)"unAudit");
        this.actionManager.registerBatchAction(actionProxy, "actionUnAudit");
        actionProxy.bindTo((AbstractButton)this.btnUnAudit);
        actionProxy.bindTo((AbstractButton)this.menuItemUnAudit);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnUnAudit);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("BACKFLUSHED"), (ItemAction)this.actionBackFlushed, (String)"finishedRptBackFlushed");
        this.actionManager.registerBatchAction(actionProxy, "actionBackFlushed");
        actionProxy.bindTo((AbstractButton)this.btnBackFlushed);
        actionProxy.bindTo((AbstractButton)this.menuItemBackFlushed);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnBackFlushed);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("UNBACKFLUSH"), (ItemAction)this.actionUnBackFlush, (String)"unBackFlush");
        this.actionManager.registerBatchAction(actionProxy, "actionUnBackFlush");
        actionProxy.bindTo((AbstractButton)this.btnUnBackFlush);
        actionProxy.bindTo((AbstractButton)this.menuItemUnBackFlush);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnUnBackFlush);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.SUBMIT, (ItemAction)this.actionSubmit, (String)"submit");
        this.actionManager.registerBatchAction(actionProxy, "actionSubmit");
        actionProxy.bindTo((AbstractButton)this.btnSubmit);
        actionProxy.bindTo((AbstractButton)this.menuItemSubmit);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnSubmit);
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        if (bizAction.equals((Object)BatchActionEnum.AUDIT)) {
            this.checkSelected();
            this.checkSameOrg();
            ArrayList ids = this.getSelectedIdValues();
            if (null == ids || 0 == ids.size()) {
                SysUtil.abort();
            }
            ArrayList<String> idsFormat = new ArrayList<String>();
            for (int i = 0; i < ids.size(); ++i) {
                if (idsFormat.contains(((String)ids.get(i)).toString())) continue;
                idsFormat.add(((String)ids.get(i)).toString());
            }
            try {
                StringBuffer numbers;
                String[] strNums;
                IFinishedRpt finishedRpt = (IFinishedRpt)this.getBizInterface();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("storageOrgUnit.id"));
                FinishedRptInfo info = finishedRpt.getFinishedRptInfo((IObjectPK)new ObjectUuidPK(((String)ids.get(0)).toString()), selector);
                String strStoreageOrgId = info.getStorageOrgUnit().getId().toString();
                IParamControl ipc = ParamControlFactory.getRemoteInstance();
                String strValue = ipc.getParamValue((IObjectPK)new ObjectStringPK(strStoreageOrgId), "OverRunMeasure");
                if (strValue == null) {
                    String strInfo = ResourceUtils.getMessage((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"OverRunMeasureRes");
                    MsgBox.showWarning((Component)((Object)this), (String)strInfo);
                    SysUtil.abort();
                }
                if (strValue.equals("1")) {
                    strNums = finishedRpt.excessQtyIds(idsFormat.toArray(new String[idsFormat.size()]));
                    if (strNums != null) {
                        String strInfo;
                        int confirm;
                        numbers = new StringBuffer();
                        for (int i = 0; i < strNums.length; ++i) {
                            if (StringUtils.isEmpty((String)strNums[i])) continue;
                            numbers.append("'" + strNums[i] + "' ");
                        }
                        if (numbers.length() > 0 && (confirm = MsgBox.showConfirm2New((Component)((Object)this), (String)(strInfo = ResourceUtils.getMessage((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"OVER_RPT_HIGHT_LIMITW", (String[])new String[]{numbers.toString()})))) == 1) {
                            SysUtil.abort();
                        }
                    }
                } else if (strValue.equals("2") && (strNums = finishedRpt.excessQtyIds(idsFormat.toArray(new String[idsFormat.size()]))) != null) {
                    numbers = new StringBuffer();
                    for (int i = 0; i < strNums.length; ++i) {
                        if (StringUtils.isEmpty((String)strNums[i])) continue;
                        numbers.append("'" + strNums[i] + "' ");
                    }
                    if (numbers.length() > 0) {
                        String strInfo = ResourceUtils.getMessage((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"OVER_RPT_HIGHT_LIMIT", (String[])new String[]{numbers.toString()});
                        MsgBox.showWarning((Component)((Object)this), (String)strInfo);
                        SysUtil.abort();
                    }
                }
                String numbers2 = "";
                for (String id : idsFormat) {
                    Object[] isCanFinish = finishedRpt.isCanFinish(id);
                    if (null == isCanFinish || !((Boolean)isCanFinish[0]).booleanValue()) continue;
                    numbers2 = numbers2 + "," + (String)isCanFinish[1];
                }
                if (!StringUtils.isEmpty((String)(numbers2 = numbers2.replaceFirst(",", ""))) && MsgBox.showConfirm2New((Component)((Object)this), (String)ResourceUtils.getMessage((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"ConfirmAudit", (String[])new String[]{numbers2})) == 1) {
                    SysUtil.abort();
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
                return false;
            }
        }
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
        super.afterAction(bizAction, selectionEntries, countSuccess);
    }

    @Override
    public void actionInstock_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ((IFinishedRpt)this.getBizInterface()).commonCheck(idList, 1);
        HashSet<String> billIds = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            billIds.add(idList.get(i).toString());
        }
        HashSet<String> entryIds = new HashSet<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            entryIds.add((String)this.tblMain.getCell(selectRows[i], TB_ENTRYID).getValue());
        }
        FinishedRptBotpUtil.customFinishedRptTOManufactureRec((CoreUI)this, billIds, entryIds);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FinishedRptFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        FinishedRptInfo objectValue = new FinishedRptInfo();
        return objectValue;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    public String getEntriesName() {
        return "entrys";
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new FinishedRptFilterUI();
        }
        return this.conditionPanel;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setHeight(360);
        String title = FinishedRptUtil.getResource("FinishedRptQueryF7WindowTitle");
        dialog.setTitle(title + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    @Override
    protected String getEditUIName() {
        return FinishedRptEditUI.class.getName();
    }

    protected String[] getQtyColumns() {
        return new String[]{"entrys.baseCommtQty", "entrys.commitQty", "entrys.baseStockTotalQty", "entrys.stockTotalQty"};
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.material.id"));
        sic.add(new SelectorItemInfo("entrys.material.name"));
        sic.add(new SelectorItemInfo("entrys.material.number"));
        sic.add(new SelectorItemInfo("entrys.material.model"));
        sic.add(new SelectorItemInfo("entrys.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit"));
        sic.add(new SelectorItemInfo("entrys.material.assistUnit"));
        sic.add(new SelectorItemInfo("entrys.unit.id"));
        sic.add(new SelectorItemInfo("entrys.unit.name"));
        sic.add(new SelectorItemInfo("entrys.unit.number"));
        sic.add(new SelectorItemInfo("entrys.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.id"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.name"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.number"));
        sic.add(new SelectorItemInfo("entrys.warehouse.id"));
        sic.add(new SelectorItemInfo("entrys.warehouse.name"));
        sic.add(new SelectorItemInfo("entrys.warehouse.number"));
        sic.add(new SelectorItemInfo("entrys.warehouse.hasLocation"));
        return sic;
    }

    private void getFinishedRptIdList(List idList, List entriesList) {
        block7: {
            block6: {
                int mode = 0;
                ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
                if (blockList != null && blockList.size() == 1) {
                    mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
                }
                if (mode != 8) break block6;
                List selectIdList = this.getQueryPkList();
                if (selectIdList == null) break block7;
                for (Object[] idObj : selectIdList) {
                    if (idObj == null) continue;
                    if (!idList.contains(idObj[0].toString())) {
                        idList.add(idObj[0].toString());
                    }
                    if (idObj.length != 2) continue;
                    entriesList.add(idObj[1]);
                }
                break block7;
            }
            ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
            for (KDTSelectBlock block : blocks) {
                int top = block.getTop();
                int bottom = block.getBottom();
                for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                    ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                    if (this.tblMain.getRow(rowIndex).getCell(this.getEntriesPKName()) != null && this.tblMain.getRow(rowIndex).getCell(this.getEntriesPKName()).getValue() != null) {
                        entriesList.add(this.tblMain.getRow(rowIndex).getCell(this.getEntriesPKName()).getValue().toString());
                    }
                    if (idList.contains(cell.getValue())) continue;
                    idList.add(cell.getValue());
                }
            }
        }
    }

    protected CoreBillBaseCollection getNewBillList() throws Exception {
        this.checkSelected();
        ArrayList idList = new ArrayList();
        ArrayList entriesKey = new ArrayList();
        this.getFinishedRptIdList(idList, entriesKey);
        Object[] filterObj = new Object[idList.size()];
        FilterInfo filterInfo = new FilterInfo();
        Iterator idIter = idList.iterator();
        int index = 0;
        while (idIter.hasNext()) {
            String id = idIter.next().toString();
            filterObj[index] = id;
            ++index;
        }
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(this.getBOTPSelectors());
        entityViewInfo.setFilter(filterInfo);
        CoreBillBaseCollection sourceBillCollection = ((ICoreBillBase)this.getCoreBaseInterface()).getCoreBillBaseCollection(entityViewInfo);
        this.getUIContext().put("originalBill", sourceBillCollection.clone());
        if (entriesKey.size() > 0) {
            this.removeUnSelect(entriesKey, sourceBillCollection);
        }
        return sourceBillCollection;
    }

    private void removeUnSelect(List entriesKey, CoreBillBaseCollection sourceBillCollection) {
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            CoreBillBaseInfo bills = sourceBillCollection.get(i);
            boolean isHasSelect = false;
            IObjectCollection entries = (IObjectCollection)bills.get(this.getEntriesName());
            if (entries == null) {
                return;
            }
            Iterator iters = entries.iterator();
            while (iters.hasNext()) {
                CoreBaseInfo cInfo = (CoreBaseInfo)iters.next();
                isHasSelect = false;
                for (int k = 0; k < entriesKey.size(); ++k) {
                    if (!cInfo.get("id").toString().equals(entriesKey.get(k).toString())) continue;
                    isHasSelect = true;
                    break;
                }
                if (isHasSelect) continue;
                iters.remove();
            }
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public void beforeTransform(IObjectCollection srcObjCols, String destBillBosType) {
        super.beforeTransform(srcObjCols, destBillBosType);
    }

    protected void logPrint() {
        FinishedRptInfo plInfo = new FinishedRptInfo();
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)plInfo.getBOSType(), null, (String)FinishedRptUtil.getResource("FinishedRptPrint"), (String)"mm_finishedRpt_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        FinishedRptInfo info;
        this.actionViewBatch.setEnabled(false);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length == 1 && ((info = (FinishedRptInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))).getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) || info.getBaseStatus().equals((Object)BillBaseStatusEnum.FINISH))) {
            this.actionViewBatch.setEnabled(true);
        }
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    public void actionViewBatch_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        String finishedRptID = this.getSelectedKeyValue();
        FinishedRptInfo info = (FinishedRptInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int row = selectRows[0];
        String entryID = this.tblMain.getCell(row, TB_ENTRYID).getValue().toString();
        String id = FinishedRptFactory.getRemoteInstance().getBatchFileID(finishedRptID, entryID, info.getStorageOrgUnit().getId().toString());
        if (id == null || id.trim().equals("")) {
            MsgBox.showInfo((String)FinishedRptUtil.getResource("noBatchInfo"));
            SysUtil.abort();
            return;
        }
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BatchFileEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "finishedRptImp";
        param.alias = FinishedRptUtil.getResource("FinishedRptInOutTitle");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "finishedRptImp";
        param.alias = FinishedRptUtil.getResource("FinishedRptInOutTitle");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("QCBizType", QCUITypeEnum.pdtCheck);
        super.actionTraceDown_actionPerformed(e);
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ctrl shift E"), "exportData");
        actionMap.put("exportData", (Action)this.actionExportData);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    public void checkSameOrg() {
        super.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows != null && selectRows.length > 1) {
            String strOrgName = null;
            for (int i = 0; i < selectRows.length; ++i) {
                String strTemp = (String)this.tblMain.getRow(selectRows[i]).getCell("storageOrgUnit.name").getValue();
                if (strOrgName == null) {
                    strOrgName = strTemp;
                    continue;
                }
                if (strOrgName.equals(strTemp)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)ResourceUtils.getMessage((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"sameOrg"));
                SysUtil.abort();
            }
        }
    }

    public static void addSqlMenu(final FinishedRptListUI uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift alt V"){

            public void action_actionPerformed() {
                KDWorkButton btn = uiObject.btnUnBackFlush;
                KDMenuItem bizProcessBar = new KDMenuItem(btn.getText());
                bizProcessBar.setAction(btn.getAction());
                bizProcessBar.setIcon(btn.getIcon());
                uiObject.btnBizOperation.addAssistMenuItem((JMenuItem)bizProcessBar);
            }
        });
    }
}

