/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.control.FinishedRptOrderVO;
import com.kingdee.eas.mm.control.client.AbstractFinishedRptRepairUI;
import com.kingdee.eas.mm.control.util.FinishedRptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FinishedRptRepairUI
extends AbstractFinishedRptRepairUI {
    private static final Logger logger = CoreUIObject.getLogger(FinishedRptRepairUI.class);
    private String TB_STORAGEORGUNIT = "storageOrgUnit";
    private String TB_FINISHEDRPTNUM = "finishedRptNum";
    private String TB_MATERIAL = "material";
    private String TB_MATERIALNAME = "materailName";
    private String TB_MODEL = "model";
    private String TB_UNIT = "unit";
    private String TB_COULDREPAIRQTY = "couldRepairQty";
    private String TB_REPAIRQTY = "actualRepairQty";
    private String TB_FINISHEDRPTID = "finishedRptId";
    private String TB_FINISHEDRPTENTRYID = "finishedRptEntryId";
    private String TB_FINISHEDRPTCRID = "finishedRptCRID";
    private List repairColls;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initData(this.kDTable1);
        this.kDTable1.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    int rowIndex = e.getRowIndex();
                    int colIndex = e.getColIndex();
                    String fieldName = FinishedRptRepairUI.this.kDTable1.getColumnKey(colIndex);
                    if (FinishedRptRepairUI.this.TB_REPAIRQTY.equalsIgnoreCase(fieldName)) {
                        Object oldValue = e.getOldValue();
                        Object newValue = e.getValue();
                        if (oldValue != null && newValue != null) {
                            BigDecimal oldBigValue = (BigDecimal)oldValue;
                            BigDecimal newBigValue = (BigDecimal)newValue;
                            if ((oldBigValue = oldBigValue.setScale(newBigValue.scale(), 4)).compareTo(newBigValue) == 0) {
                                return;
                            }
                            String finishedRptID = (String)FinishedRptRepairUI.this.kDTable1.getCell(rowIndex, FinishedRptRepairUI.this.TB_FINISHEDRPTID).getValue();
                            String finishedRptEntryID = (String)FinishedRptRepairUI.this.kDTable1.getCell(rowIndex, FinishedRptRepairUI.this.TB_FINISHEDRPTENTRYID).getValue();
                            for (int i = 0; i < FinishedRptRepairUI.this.repairColls.size(); ++i) {
                                FinishedRptOrderVO vo = (FinishedRptOrderVO)FinishedRptRepairUI.this.repairColls.get(i);
                                if (!vo.getFinishedRptID().equals(finishedRptID) || !vo.getFinishedRptEntryID().equals(finishedRptEntryID)) continue;
                                ICell cellValue = FinishedRptRepairUI.this.kDTable1.getCell(rowIndex, FinishedRptRepairUI.this.TB_FINISHEDRPTCRID);
                                if (cellValue.getValue() != null) {
                                    String finishedRptCRID = cellValue.getValue().toString();
                                    if (vo.getFinishedrptCRID() == null || !vo.getFinishedrptCRID().equals(finishedRptCRID)) continue;
                                    vo.setQty(newBigValue);
                                    continue;
                                }
                                vo.setQty(newBigValue);
                            }
                        }
                    }
                }
                catch (Exception exc) {
                    FinishedRptRepairUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initData(KDTable kdtTable) {
        this.repairColls = (List)this.getUIContext().get("prdData");
        if (null != this.repairColls) {
            String msg_yes = ResourceManage.getResource((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"YES");
            String msg_no = ResourceManage.getResource((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"NO");
            for (int i = 0; i < this.repairColls.size(); ++i) {
                FinishedRptOrderVO vo = (FinishedRptOrderVO)this.repairColls.get(i);
                IRow row = kdtTable.addRow();
                row.getCell(this.TB_STORAGEORGUNIT).setValue((Object)vo.getStorage().getName());
                row.getCell(this.TB_FINISHEDRPTNUM).setValue((Object)vo.getFinishedRptNum());
                row.getCell(this.TB_MATERIAL).setValue((Object)vo.getMaterial().getNumber());
                row.getCell(this.TB_MATERIALNAME).setValue((Object)vo.getMaterial().getName());
                row.getCell(this.TB_UNIT).setValue((Object)vo.getUnit());
                row.getCell(this.TB_MODEL).setValue((Object)vo.getMaterial().getModel());
                row.getCell(this.TB_COULDREPAIRQTY).setEditor((ICellEditor)this.createNumericCellEditor(vo.getPrecision()));
                row.getCell(this.TB_COULDREPAIRQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)vo.getPrecision()));
                row.getCell(this.TB_COULDREPAIRQTY).setValue((Object)vo.getCouldQty().setScale(vo.getPrecision(), 4));
                row.getCell(this.TB_REPAIRQTY).setEditor((ICellEditor)this.createNumericCellEditor(vo.getPrecision()));
                row.getCell(this.TB_REPAIRQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)vo.getPrecision()));
                row.getCell(this.TB_REPAIRQTY).setValue((Object)vo.getQty().setScale(vo.getPrecision(), 4));
                row.getCell(this.TB_FINISHEDRPTID).setValue((Object)vo.getFinishedRptID());
                row.getCell(this.TB_FINISHEDRPTENTRYID).setValue((Object)vo.getFinishedRptEntryID());
                row.getCell(this.TB_FINISHEDRPTCRID).setValue((Object)vo.getFinishedrptCRID());
            }
        }
    }

    private KDTDefaultCellEditor createNumericCellEditor(int precision) {
        KDFormattedTextField numeric_TextField = new KDFormattedTextField();
        numeric_TextField.setVisible(true);
        numeric_TextField.setEditable(true);
        numeric_TextField.setHorizontalAlignment(2);
        numeric_TextField.setDataType(1);
        numeric_TextField.setPrecision(precision);
        KDTDefaultCellEditor numericCellEditor = new KDTDefaultCellEditor((JTextField)numeric_TextField);
        return numericCellEditor;
    }

    private String getNumberFormat(int precision) {
        StringBuffer result = new StringBuffer();
        result.append("%{0");
        if (precision > 0) {
            result.append(".");
        }
        for (int i = 0; i < precision; ++i) {
            result.append("0");
        }
        result.append("}f");
        return result.toString();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Integer> blankList = new ArrayList<Integer>();
        ArrayList<Integer> lessList = new ArrayList<Integer>();
        ArrayList<Integer> zeroList = new ArrayList<Integer>();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            BigDecimal couldCheckQty = (BigDecimal)this.kDTable1.getCell(i, this.TB_COULDREPAIRQTY).getValue();
            BigDecimal checkQty = (BigDecimal)this.kDTable1.getCell(i, this.TB_REPAIRQTY).getValue();
            if (checkQty == null) {
                blankList.add(new Integer(i + 1));
                continue;
            }
            if (checkQty.doubleValue() == 0.0) {
                zeroList.add(new Integer(i + 1));
                continue;
            }
            if (!(couldCheckQty.doubleValue() < checkQty.doubleValue())) continue;
            lessList.add(new Integer(i + 1));
        }
        StringBuffer str = new StringBuffer();
        if (blankList.size() > 0) {
            str.append(FinishedRptUtil.getResource("head"));
            for (int i = 0; i < blankList.size(); ++i) {
                if (i != 0) {
                    str.append(",");
                }
                int row = (Integer)blankList.get(i);
                str.append(row);
            }
            str.append(FinishedRptUtil.getResource("repairQtyBlank") + "\n");
        }
        if (lessList.size() > 0) {
            str.append(FinishedRptUtil.getResource("head"));
            for (int i = 0; i < lessList.size(); ++i) {
                if (i != 0) {
                    str.append(",");
                }
                int row = (Integer)lessList.get(i);
                str.append(row);
            }
            str.append(FinishedRptUtil.getResource("checkRepairQtyMore") + "\n");
        }
        if (zeroList.size() > 0) {
            str.append(FinishedRptUtil.getResource("head"));
            for (int i = 0; i < zeroList.size(); ++i) {
                if (i != 0) {
                    str.append(",");
                }
                int row = (Integer)zeroList.get(i);
                str.append(row);
            }
            str.append(FinishedRptUtil.getResource("checkQtyNotZero") + "\n");
        }
        if (str.length() > 0) {
            MsgBox.showInfo((String)str.toString());
            SysUtil.abort();
            return;
        }
        this.getUIContext().put("retrunState", new Integer(0));
        this.getUIContext().put("prdData", this.repairColls);
        this.actionExitCurrent_actionPerformed(e);
    }
}

