/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.client.AbstractMMRemarkUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class MMRemarkUI
extends AbstractMMRemarkUI {
    private static final Logger logger = CoreUIObject.getLogger(MMRemarkUI.class);
    private int txtLen = 0;
    private String moID;
    private String oldRemark = null;

    public MMRemarkUI() throws Exception {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.moID = (String)this.getUIContext().get("MO_ID");
        this.oldRemark = (String)this.getUIContext().get("MO_REMARK");
        if (this.oldRemark != null) {
            this.txtRemark.setMaxLength(250 - this.oldRemark.length());
        }
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.txtRemark.getEditor().getItem().toString().length() != this.txtLen) {
            String msg = EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"REMARK_NOT_SAVED");
            int ret = MsgBox.showConfirm2((String)msg);
            if (ret == 0) {
                boolean retB = super.checkBeforeWindowClosing();
                if (retB) {
                    this.txtRemark.getEditor().setItem("");
                }
                return retB;
            }
            return false;
        }
        return super.checkBeforeWindowClosing();
    }

    public String getRemark() {
        if (this.oldRemark == null) {
            return this.txtRemark.getEditor().getItem().toString();
        }
        return this.oldRemark + "\n" + this.txtRemark.getEditor().getItem().toString();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtRemark.getEditor().getItem().toString().length() > 0) {
            String newRem = this.getRemark();
            ProductionOrderFactory.getRemoteInstance().updateRemark(this.moID, newRem);
            this.txtLen = this.txtRemark.getEditor().getItem().toString().length();
            this.actionExitCurrent_actionPerformed(e);
        }
    }
}

