/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.mm.lot.BatchFileInfo;
import com.kingdee.eas.mm.lot.QueryTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.util.List;
import java.util.Map;

public class MaterialLotTracePrintDataProvider
extends AbstractPrintDataProvider {
    private String storageOrgUnitName;
    private Map product;
    private QueryTypeEnum queryType;
    private List srcMaterial;

    public MaterialLotTracePrintDataProvider(String storageOrgUnitName, List srcMaterial, Map product, QueryTypeEnum queryType) {
        this.storageOrgUnitName = storageOrgUnitName;
        this.product = product;
        this.srcMaterial = srcMaterial;
        this.queryType = queryType;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        if ("VirtualPrintDataQuery.bos-query".equals(dataSource.getId())) {
            String[] column = null;
            column = new String[]{"src_id", "src_materialNumber", "src_materialName", "src_materialModel", "src_lotNo", "storageOrgUnitName", "tier", "materialNumber", "materialName", "materialModel", "lotNo", "lotDate", "OfMaterial", "OfMaterialLot", "isMultiTier", "createTime"};
            String isMultiTier = "NO";
            if (20 == this.queryType.getValue()) {
                isMultiTier = "YES";
            }
            DynamicRowSet dynamicRowSet = new DynamicRowSet(column.length);
            for (int i = 0; i < column.length; ++i) {
                ColInfo ciId = new ColInfo(column[i], column[i], 12, null);
                dynamicRowSet.setColInfo(i + 1, ciId);
            }
            if (null != this.srcMaterial && this.srcMaterial.size() > 0) {
                for (String[] src : this.srcMaterial) {
                    List traceProduct = (List)this.product.get(src[0]);
                    if (null != traceProduct && traceProduct.size() > 0) {
                        for (BatchFileInfo element : traceProduct) {
                            dynamicRowSet.moveToInsertRow();
                            dynamicRowSet.updateString("src_id", src[0]);
                            dynamicRowSet.updateString("src_materialNumber", src[1]);
                            dynamicRowSet.updateString("src_materialName", src[2]);
                            dynamicRowSet.updateString("src_materialModel", src[3]);
                            dynamicRowSet.updateString("src_lotNo", src[4]);
                            dynamicRowSet.updateString("storageOrgUnitName", this.storageOrgUnitName);
                            dynamicRowSet.updateString("createTime", src[5]);
                            dynamicRowSet.updateString("tier", (String)element.get("ep_structCode_20080923"));
                            dynamicRowSet.updateString("materialNumber", element.getMaterial().getNumber());
                            dynamicRowSet.updateString("materialName", element.getMaterial().getName());
                            dynamicRowSet.updateString("materialModel", element.getMaterial().getModel());
                            dynamicRowSet.updateString("lotNo", element.getLotNo());
                            dynamicRowSet.updateString("lotDate", element.getCreateTime() == null ? "" : CtrlFormatUtilities.getDateFormat().format(element.getCreateTime()));
                            dynamicRowSet.updateString("OfMaterial", (String)element.get("ep_OfMaterial_20080923"));
                            dynamicRowSet.updateString("OfMaterialLot", (String)element.get("ep_OfMaterialLot_20080923"));
                            dynamicRowSet.updateString("isMultiTier", isMultiTier);
                            dynamicRowSet.insertRow();
                        }
                        continue;
                    }
                    dynamicRowSet.moveToInsertRow();
                    dynamicRowSet.updateString("src_id", src[0]);
                    dynamicRowSet.updateString("src_materialNumber", src[1]);
                    dynamicRowSet.updateString("src_materialName", src[2]);
                    dynamicRowSet.updateString("src_materialModel", src[3]);
                    dynamicRowSet.updateString("src_lotNo", src[4]);
                    dynamicRowSet.updateString("storageOrgUnitName", this.storageOrgUnitName);
                    dynamicRowSet.updateString("createTime", src[5]);
                    dynamicRowSet.updateString("tier", "");
                    dynamicRowSet.updateString("materialNumber", "");
                    dynamicRowSet.updateString("materialName", "");
                    dynamicRowSet.updateString("materialModel", "");
                    dynamicRowSet.updateString("lotNo", "");
                    dynamicRowSet.updateString("lotDate", "");
                    dynamicRowSet.updateString("OfMaterial", "");
                    dynamicRowSet.updateString("OfMaterialLot", "");
                    dynamicRowSet.updateString("isMultiTier", isMultiTier);
                    dynamicRowSet.insertRow();
                }
                dynamicRowSet.beforeFirst();
            }
            return dynamicRowSet;
        }
        return null;
    }
}

