/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.ReplaceModeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.common.loadmass.MaterialSustituteVO;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.client.AbstractMaterialReplaceUI;
import com.kingdee.eas.mm.control.util.MaterialSustituteHelper;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialReplaceUI
extends AbstractMaterialReplaceUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialReplaceUI.class);
    private static final String STT_ENTRYID = "FEntryID";
    private static final String STT_REPLACESEQ = "substituteSeq";
    private static final String STT_MATERIALID = "substituteMaterial";
    private static final String STT_MATERIALNUM = "substituteMaterialNum";
    private static final String STT_MATERIALNAME = "substituteMaterialName";
    private static final String STT_MODEL = "substituteMaterialMode";
    private static final String STT_FUNIT = "substituteUnit";
    private static final String STT_UNITREPQTY = "substituteUnitQty";
    private static final String STT_PERPROPORTION = "substituteProportion";
    private static final String STT_EFFECTIVEDATE = "effectiveDate";
    private static final String STT_INVALIDATE = "invalidDate";
    private static final String STT_SURPLUSQTY = "surplusQty";
    private static final String STT_SUBSTITUTEQTY = "substituteQty";
    private static final String STT_SUBSTITUTEBASEQTY = "substituteBaseQty";
    private KDTPropertyChangeListener kdtEntrysChangeListener = null;
    private static final String RES_PRD_ORDER = "com.kingdee.eas.mm.control.ProductionOrderNextResource";
    private Map parentPrecision = new HashMap();
    private Map parentBaseRate = new HashMap();
    private double headReplacedCatch = 0.0;
    private Map eachSeqReplacedCatch = new HashMap();
    private KDFormattedTextField[] initHeadTxtField = new KDFormattedTextField[]{this.txtCanBeUseQty, this.txtQty, this.txtReplaceQty, this.txtSurplusQty};
    private static final String[] KDT_DATES = new String[]{"effectiveDate", "invalidDate"};
    List countKey = new ArrayList();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.kDTable1.removeKDTPropertyChangeListener(this.kdtEntrysChangeListener);
        super.onLoad();
        EditTableUtil.formatColDateTime((KDTable)this.kDTable1, (String[])KDT_DATES);
        if (this.kdtEntrysChangeListener == null) {
            this.kdtEntrysChangeListener = new KDTPropertyChangeListener(){

                public void propertyChange(KDTPropertyChangeEvent evt) {
                    try {
                        int rowIndex = evt.getRowIndex();
                        int colIndex = evt.getColIndex();
                        String fieldName = MaterialReplaceUI.this.kDTable1.getColumnKey(colIndex);
                        if (MaterialReplaceUI.STT_SUBSTITUTEQTY.equalsIgnoreCase(fieldName)) {
                            int i;
                            if (MaterialReplaceUI.this.kDTable1.getRow(rowIndex) == null) {
                                return;
                            }
                            MaterialSustituteVO bomSubstituteInfo = (MaterialSustituteVO)MaterialReplaceUI.this.kDTable1.getRow(rowIndex).getUserObject();
                            MaterialReplaceUI.this.kDTable1.removeKDTPropertyChangeListener(MaterialReplaceUI.this.kdtEntrysChangeListener);
                            if (evt.getNewValue() == null || ((BigDecimal)evt.getNewValue()).doubleValue() == 0.0) {
                                MaterialReplaceUI.this.kDTable1.getRow(rowIndex).getCell(MaterialReplaceUI.STT_SUBSTITUTEBASEQTY).setValue((Object)new BigDecimal(0));
                            } else {
                                BigDecimal baseQty = SCMUtils.getExchangePricesionQtyForClient((String)bomSubstituteInfo.getSubstituteMaterial().getId().toString(), (MeasureUnitInfo)bomSubstituteInfo.getSubstituteUnit(), (MeasureUnitInfo)bomSubstituteInfo.getSubstituteMaterial().getBaseUnit(), (BigDecimal)((BigDecimal)evt.getNewValue()));
                                MaterialReplaceUI.this.kDTable1.getRow(rowIndex).getCell(MaterialReplaceUI.STT_SUBSTITUTEBASEQTY).setValue((Object)baseQty);
                            }
                            String seq = String.valueOf(bomSubstituteInfo.getSubstituteSeq());
                            boolean isRemove = true;
                            if (!(evt.getOldValue() != null && ((BigDecimal)evt.getOldValue()).doubleValue() != 0.0 || evt.getNewValue() != null && ((BigDecimal)evt.getNewValue()).doubleValue() != 0.0)) {
                                isRemove = false;
                            }
                            double substituteChangedSeqQty = MaterialReplaceUI.this.getHeadSubstituteQtyByEntryQty(bomSubstituteInfo, (BigDecimal)evt.getNewValue());
                            double parentSeqQty = MaterialReplaceUI.this.getHeadSubstituteBaseQtyByEntryQty(bomSubstituteInfo, (BigDecimal)evt.getNewValue());
                            int j = MaterialReplaceUI.this.kDTable1.getRowCount();
                            for (i = 0; i < j; ++i) {
                                MaterialSustituteVO bomSub = (MaterialSustituteVO)MaterialReplaceUI.this.kDTable1.getRow(i).getUserObject();
                                String eachSeq = (String)MaterialReplaceUI.this.kDTable1.getRow(i).getCell(MaterialReplaceUI.STT_REPLACESEQ).getValue();
                                if (ReplaceModeEnum.AllREPLACE == (ReplaceModeEnum)MaterialReplaceUI.this.cmbReplaceMode.getSelectedItem() && !eachSeq.equals(seq) && isRemove) {
                                    MaterialReplaceUI.this.kDTable1.getRow(i).getCell(MaterialReplaceUI.STT_SUBSTITUTEQTY).setValue((Object)new BigDecimal(0));
                                    MaterialReplaceUI.this.kDTable1.getRow(i).getCell(MaterialReplaceUI.STT_SUBSTITUTEBASEQTY).setValue((Object)new BigDecimal(0));
                                }
                                if (i == rowIndex || !seq.equals((String)MaterialReplaceUI.this.kDTable1.getRow(i).getCell(MaterialReplaceUI.STT_REPLACESEQ).getValue())) continue;
                                BigDecimal sameSeqQty = MaterialReplaceUI.this.getSameSeqSustituteQty(bomSubstituteInfo, parentSeqQty, bomSub);
                                MaterialReplaceUI.this.kDTable1.getRow(i).getCell(MaterialReplaceUI.STT_SUBSTITUTEQTY).setValue((Object)sameSeqQty);
                                if (sameSeqQty == null || sameSeqQty.doubleValue() == 0.0) {
                                    MaterialReplaceUI.this.kDTable1.getRow(i).getCell(MaterialReplaceUI.STT_SUBSTITUTEBASEQTY).setValue((Object)new BigDecimal(0));
                                    continue;
                                }
                                BigDecimal baseQty = SCMUtils.getExchangePricesionQtyForClient((String)bomSub.getSubstituteMaterial().getId().toString(), (MeasureUnitInfo)bomSub.getSubstituteUnit(), (MeasureUnitInfo)bomSub.getSubstituteMaterial().getBaseUnit(), (BigDecimal)sameSeqQty);
                                MaterialReplaceUI.this.kDTable1.getRow(i).getCell(MaterialReplaceUI.STT_SUBSTITUTEBASEQTY).setValue((Object)baseQty);
                            }
                            if (isRemove) {
                                if (ReplaceModeEnum.AllREPLACE == (ReplaceModeEnum)MaterialReplaceUI.this.cmbReplaceMode.getSelectedItem()) {
                                    MaterialReplaceUI.this.eachSeqReplacedCatch = new HashMap();
                                    MaterialReplaceUI.this.eachSeqReplacedCatch.put(seq, new BigDecimal(substituteChangedSeqQty).divide(new BigDecimal(1), 16, 1));
                                } else {
                                    MaterialReplaceUI.this.eachSeqReplacedCatch.put(seq, new BigDecimal(substituteChangedSeqQty).divide(new BigDecimal(1), 16, 1));
                                }
                            }
                            MaterialReplaceUI.this.headReplacedCatch = 0.0;
                            j = MaterialReplaceUI.this.countKey.size();
                            for (i = 0; i < j; ++i) {
                                if (!MaterialReplaceUI.this.eachSeqReplacedCatch.containsKey((String)MaterialReplaceUI.this.countKey.get(i))) continue;
                                BigDecimal eachSeqReplacedQty = (BigDecimal)MaterialReplaceUI.this.eachSeqReplacedCatch.get((String)MaterialReplaceUI.this.countKey.get(i));
                                MaterialReplaceUI.this.headReplacedCatch = MaterialReplaceUI.this.headReplacedCatch + eachSeqReplacedQty.doubleValue();
                            }
                            Integer precisionCalc = (Integer)MaterialReplaceUI.this.parentPrecision.get("parentPrecision");
                            BigDecimal substituteQty = new BigDecimal(MaterialReplaceUI.this.headReplacedCatch).divide(new BigDecimal(1.0), (int)precisionCalc, 1);
                            MaterialReplaceUI.this.txtReplaceQty.setValue((Object)substituteQty);
                            if (MaterialReplaceUI.this.headReplacedCatch >= MaterialReplaceUI.this.txtQty.getBigDecimalValue().doubleValue()) {
                                MaterialReplaceUI.this.txtSurplusQty.setValue((Object)new BigDecimal(0));
                            } else {
                                MaterialReplaceUI.this.txtSurplusQty.setValue((Object)MaterialReplaceUI.this.txtQty.getBigDecimalValue().subtract(new BigDecimal(MaterialReplaceUI.this.headReplacedCatch)).divide(new BigDecimal(1.0), (int)precisionCalc, 0));
                            }
                            MaterialReplaceUI.this.kDTable1.addKDTPropertyChangeListener(MaterialReplaceUI.this.kdtEntrysChangeListener);
                        }
                    }
                    catch (Exception exc) {
                        MaterialReplaceUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kDTable1.addKDTPropertyChangeListener(this.kdtEntrysChangeListener);
    }

    private BigDecimal getSameSeqSustituteQty(MaterialSustituteVO bomSubstituteInfo, double parentSeqQty, MaterialSustituteVO bomSub) {
        BigDecimal parentBaseRate = bomSubstituteInfo.getParentToBaseUnitRate();
        double seqQty = 0.0;
        if (bomSub.isSubstituteQty()) {
            seqQty = parentSeqQty / parentBaseRate.doubleValue() * bomSub.getSubstituteQty().doubleValue();
            BigDecimal sameSeqQty = new BigDecimal(seqQty).divide(new BigDecimal(1.0), bomSub.getSubstituteUnit().getQtyPrecision(), 4);
            return sameSeqQty;
        }
        BigDecimal childToParentBaseRate = bomSub.getToParentBaseUnitRate();
        seqQty = bomSub.getSubstituteUnit().getId().toString().equals(bomSub.getParentUnitId()) ? parentSeqQty / parentBaseRate.doubleValue() * (bomSub.getSubstituteProportion().doubleValue() / 100.0) : parentSeqQty / childToParentBaseRate.doubleValue() * (bomSub.getSubstituteProportion().doubleValue() / 100.0) / bomSub.getToBaseUnitRate().doubleValue();
        BigDecimal sameSeqQty = new BigDecimal(seqQty).divide(new BigDecimal(1.0), bomSub.getSubstituteUnit().getQtyPrecision(), 4);
        return sameSeqQty;
    }

    private double getHeadSubstituteQtyByEntryQty(MaterialSustituteVO bomSubstituteInfo, BigDecimal entryQty) {
        double sustituteQty = 0.0;
        if (entryQty == null || entryQty.doubleValue() == 0.0) {
            return sustituteQty;
        }
        BigDecimal baseRateCalc = (BigDecimal)this.parentBaseRate.get("parentBaseRate");
        BigDecimal parentBaseRate = bomSubstituteInfo.getParentToBaseUnitRate();
        if (bomSubstituteInfo.isSubstituteQty()) {
            BigDecimal childUnitQty = bomSubstituteInfo.getSubstituteQty();
            double parentBaseQty = entryQty.doubleValue() / childUnitQty.doubleValue() * parentBaseRate.doubleValue();
            sustituteQty = parentBaseQty / baseRateCalc.doubleValue();
            return sustituteQty;
        }
        BigDecimal childToParentBaseRate = bomSubstituteInfo.getToParentBaseUnitRate();
        BigDecimal proportion = bomSubstituteInfo.getSubstituteProportion();
        BigDecimal childBaseRate = bomSubstituteInfo.getToBaseUnitRate();
        if (bomSubstituteInfo.getParentUnitId().equals(bomSubstituteInfo.getSubstituteUnit().getId().toString())) {
            sustituteQty = entryQty.doubleValue() / (proportion.doubleValue() / 100.0) * parentBaseRate.doubleValue() / baseRateCalc.doubleValue();
        } else {
            double parentBaseQty = entryQty.doubleValue() * childBaseRate.doubleValue() * childToParentBaseRate.doubleValue() / (proportion.doubleValue() / 100.0);
            sustituteQty = parentBaseQty / baseRateCalc.doubleValue();
        }
        return sustituteQty;
    }

    private BigDecimal getEntrySubstituteByHeadQty(MaterialSustituteVO bomSubstituteInfo, BigDecimal headQty) {
        BigDecimal baseRateCalc = (BigDecimal)this.parentBaseRate.get("parentBaseRate");
        BigDecimal entrySubstitute = new BigDecimal(0);
        if (bomSubstituteInfo.isSubstituteQty()) {
            BigDecimal parentBaseRate = bomSubstituteInfo.getParentToBaseUnitRate();
            BigDecimal childUnitQty = bomSubstituteInfo.getSubstituteQty();
            entrySubstitute = new BigDecimal(headQty.doubleValue() * baseRateCalc.doubleValue() / parentBaseRate.doubleValue() * childUnitQty.doubleValue()).divide(new BigDecimal(1), bomSubstituteInfo.getSubstituteUnit().getQtyPrecision(), 4);
            return entrySubstitute;
        }
        BigDecimal childToParentBaseRate = bomSubstituteInfo.getToParentBaseUnitRate();
        BigDecimal proportion = bomSubstituteInfo.getSubstituteProportion();
        BigDecimal childBaseRate = bomSubstituteInfo.getToBaseUnitRate();
        entrySubstitute = bomSubstituteInfo.getSubstituteUnit().getId().toString().equals(bomSubstituteInfo.getParentUnitId()) ? new BigDecimal(headQty.doubleValue() * baseRateCalc.doubleValue() / bomSubstituteInfo.getParentToBaseUnitRate().doubleValue() * (proportion.doubleValue() / 100.0)).divide(new BigDecimal(1), bomSubstituteInfo.getSubstituteUnit().getQtyPrecision(), 4) : new BigDecimal(headQty.doubleValue() * baseRateCalc.doubleValue() * (proportion.doubleValue() / 100.0) / childToParentBaseRate.doubleValue() / childBaseRate.doubleValue()).divide(new BigDecimal(1), bomSubstituteInfo.getSubstituteUnit().getQtyPrecision(), 4);
        return entrySubstitute;
    }

    private double getHeadSubstituteBaseQtyByEntryQty(MaterialSustituteVO bomSubstituteInfo, BigDecimal totleQty) {
        double parentBaseQty = 0.0;
        if (totleQty == null || totleQty.doubleValue() == 0.0) {
            return parentBaseQty;
        }
        BigDecimal parentBaseRate = bomSubstituteInfo.getParentToBaseUnitRate();
        if (bomSubstituteInfo.isSubstituteQty()) {
            BigDecimal childUnitQty = bomSubstituteInfo.getSubstituteQty();
            parentBaseQty = totleQty.doubleValue() / childUnitQty.doubleValue() * parentBaseRate.doubleValue();
            return parentBaseQty;
        }
        BigDecimal childToParentBaseRate = bomSubstituteInfo.getToParentBaseUnitRate();
        BigDecimal proportion = bomSubstituteInfo.getSubstituteProportion();
        BigDecimal childBaseRate = bomSubstituteInfo.getToBaseUnitRate();
        parentBaseQty = bomSubstituteInfo.getSubstituteUnit().getId().toString().equals(bomSubstituteInfo.getParentUnitId()) ? totleQty.doubleValue() / (proportion.doubleValue() / 100.0) * parentBaseRate.doubleValue() : totleQty.doubleValue() * childBaseRate.doubleValue() * childToParentBaseRate.doubleValue() / (proportion.doubleValue() / 100.0);
        return parentBaseQty;
    }

    public void onShow() throws Exception {
        super.onShow();
        Object stock = this.getUIContext().get("headInfo");
        if (stock instanceof ProductionOrderStockEntryInfo) {
            ProductionOrderStockEntryInfo psi = (ProductionOrderStockEntryInfo)this.getUIContext().get("headInfo");
            ReplaceModeEnum rme = (ReplaceModeEnum)this.getUIContext().get("replaceMode");
            this.initHead(psi, rme);
            StorageOrgUnitInfo sou = psi.getParent().getStorageOrgUnit();
            Collection bomSubs = (Collection)this.getUIContext().get("bomSubs");
            this.kDTable1.checkParsed();
            this.kDTable1.removeRows();
            IRow row = null;
            String seqTemp = "";
            for (MaterialSustituteVO bs : bomSubs) {
                if (!seqTemp.equals(String.valueOf(bs.getSubstituteSeq()))) {
                    seqTemp = String.valueOf(bs.getSubstituteSeq());
                    this.countKey.add(seqTemp);
                }
                row = this.kDTable1.addRow();
                this.initEntry(sou, row, bs, psi.getEndDate());
                this.initEntryPrecision(row, bs);
            }
            MultiMeasureUnitInfo multiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(psi.getMaterial().getId().toString(), psi.getUnit().getId().toString());
            BigDecimal baseConvsRate = multiUnifInfo.getBaseConvsRate();
            int precision = multiUnifInfo.getQtyPrecision();
            this.parentPrecision.put("parentPrecision", new Integer(precision));
            this.parentBaseRate.put("parentBaseRate", baseConvsRate);
            BigDecimal result = MaterialSustituteHelper.getInventorySurplusQty(sou.getId().toString(), psi.getMaterial().getId().toString(), baseConvsRate, precision, psi.getEndDate());
            if (result.doubleValue() <= 0.0) {
                this.txtCanBeUseQty.setValue((Object)new BigDecimal(0));
            } else {
                this.txtCanBeUseQty.setValue((Object)result);
            }
            this.initHeadTxtField(multiUnifInfo);
        } else if (stock instanceof ManufactureOrderStockInfo) {
            ManufactureOrderStockInfo msi = (ManufactureOrderStockInfo)this.getUIContext().get("headInfo");
            ReplaceModeEnum rme = (ReplaceModeEnum)this.getUIContext().get("replaceMode");
            this.initHead(msi, rme);
            StorageOrgUnitInfo sou = msi.getParent().getStorageOrgUnit();
            Collection bomSubs = (Collection)this.getUIContext().get("bomSubs");
            this.kDTable1.checkParsed();
            this.kDTable1.removeRows();
            IRow row = null;
            String seqTemp = "";
            for (MaterialSustituteVO bs : bomSubs) {
                if (!seqTemp.equals(String.valueOf(bs.getSubstituteSeq()))) {
                    seqTemp = String.valueOf(bs.getSubstituteSeq());
                    this.countKey.add(seqTemp);
                }
                row = this.kDTable1.addRow();
                this.initEntryPrecision(row, bs);
            }
            MultiMeasureUnitInfo multiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(msi.getMaterial().getId().toString(), msi.getUnit().getId().toString());
            BigDecimal baseConvsRate = multiUnifInfo.getBaseConvsRate();
            int precision = multiUnifInfo.getQtyPrecision();
            this.parentPrecision.put("parentPrecision", new Integer(precision));
            this.parentBaseRate.put("parentBaseRate", baseConvsRate);
            BigDecimal result = new BigDecimal("0.00");
            if (result.doubleValue() <= 0.0) {
                this.txtCanBeUseQty.setValue((Object)new BigDecimal(0));
            } else {
                this.txtCanBeUseQty.setValue((Object)result);
            }
            this.initHeadTxtField(multiUnifInfo);
        }
        this.repaint();
    }

    private void initHeadTxtField(MultiMeasureUnitInfo multiUnifInfo) {
        for (int i = 0; i < this.initHeadTxtField.length; ++i) {
            KDFormattedTextField field = this.initHeadTxtField[i];
            field.setPrecision(multiUnifInfo.getQtyPrecision());
            field.setHorizontalAlignment(4);
            field.setRemoveingZeroInDispaly(false);
        }
        int precision = 2;
        String colPrecision = PrecisionUtil.getFormatString((int)precision);
        KDFormattedTextField proTxtField = new KDFormattedTextField();
        proTxtField.setDataType(1);
        proTxtField.setPrecision(2);
        proTxtField.setRemoveingZeroInDispaly(false);
        proTxtField.setSupportedEmpty(true);
        proTxtField.setNegatived(false);
        proTxtField.setPercentDisplay(true);
        proTxtField.setHorizontalAlignment(2);
        this.kDTable1.getColumn(STT_PERPROPORTION).getStyleAttributes().setNumberFormat(colPrecision);
    }

    private void initEntry(StorageOrgUnitInfo sou, IRow row, MaterialSustituteVO bs, Date endDate) throws Exception {
        row.setUserObject((Object)bs);
        row.getCell(STT_REPLACESEQ).setValue((Object)String.valueOf(bs.getSubstituteSeq()));
        row.getCell(STT_MATERIALID).setUserObject((Object)bs.getSubstituteMaterial());
        row.getCell(STT_MATERIALID).setValue((Object)bs.getSubstituteMaterial().getId().toString());
        row.getCell(STT_MATERIALNUM).setValue((Object)bs.getSubstituteMaterial().getNumber());
        row.getCell(STT_MATERIALNAME).setValue((Object)bs.getSubstituteMaterial().getName());
        row.getCell(STT_MODEL).setValue((Object)bs.getSubstituteMaterial().getModel());
        row.getCell(STT_FUNIT).setValue((Object)bs.getSubstituteUnit().getName());
        row.getCell(STT_UNITREPQTY).setValue((Object)bs.getSubstituteQty());
        row.getCell(STT_PERPROPORTION).setValue((Object)bs.getSubstituteProportion());
        row.getCell(STT_EFFECTIVEDATE).setValue((Object)bs.getEffectiveDate());
        row.getCell(STT_INVALIDATE).setValue((Object)bs.getInvalidDate());
        BigDecimal result = MaterialSustituteHelper.getInventorySurplusQty(sou.getId().toString(), bs.getSubstituteMaterial().getId().toString(), bs.getToBaseUnitRate(), bs.getSubstituteUnit().getQtyPrecision(), endDate);
        row.getCell(STT_SURPLUSQTY).setValue((Object)result);
    }

    private void initEntryPrecision(IRow row, MaterialSustituteVO bs) {
        row.getCell(STT_UNITREPQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)bs.getSubstituteUnit().getQtyPrecision()));
        row.getCell(STT_PERPROPORTION).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        row.getCell(STT_UNITREPQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)bs.getSubstituteUnit().getQtyPrecision()));
        row.getCell(STT_SURPLUSQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)bs.getSubstituteUnit().getQtyPrecision()));
        row.getCell(STT_SUBSTITUTEQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)bs.getSubstituteUnit().getQtyPrecision()));
        KDTDefaultCellEditor kdCellUnitNumEditor = FormattedEditorFactory.getBigDecimalCellEditor((int)bs.getSubstituteUnit().getQtyPrecision(), (boolean)false);
        row.getCell(STT_SUBSTITUTEQTY).setEditor((ICellEditor)kdCellUnitNumEditor);
    }

    private void initHead(Object stock, ReplaceModeEnum rme) {
        if (stock instanceof ProductionOrderStockEntryInfo) {
            ProductionOrderStockEntryInfo psi = (ProductionOrderStockEntryInfo)stock;
            this.txtQty.setValue((Object)psi.getQty());
            this.txtModel.setStringValue(psi.getMaterial().getModel());
            this.prmtMaterial.setValue((Object)psi.getMaterial());
            this.pkStartDate.setValue((Object)psi.getStartDate());
            this.pkEndDate.setValue((Object)psi.getEndDate());
            this.prmtUnit.setValue((Object)psi.getUnit());
            this.cmbReplaceMode.setSelectedItem((Object)rme);
            this.txtLineNo.setStringValue(psi.getLineSeq());
            this.txtSurplusQty.setValue((Object)psi.getQty());
            this.txtReplaceQty.setValue((Object)new BigDecimal(0));
        } else if (stock instanceof ManufactureOrderStockInfo) {
            ManufactureOrderStockInfo msi = (ManufactureOrderStockInfo)stock;
            this.txtQty.setValue((Object)msi.getQty());
            this.txtModel.setStringValue(msi.getMaterial().getModel());
            this.prmtMaterial.setValue((Object)msi.getMaterial());
            this.pkDemandDate.setValue((Object)msi.getDemandTime());
            this.prmtUnit.setValue((Object)msi.getUnit());
            this.cmbReplaceMode.setSelectedItem((Object)rme);
            this.txtLineNo.setStringValue(String.valueOf(msi.getSeq()));
            this.txtSurplusQty.setValue((Object)msi.getQty());
            this.txtReplaceQty.setValue((Object)new BigDecimal(0));
        }
    }

    @Override
    public void actionAutoAllot_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.kDTable1.removeKDTPropertyChangeListener(this.kdtEntrysChangeListener);
        Integer precisionCalc = (Integer)this.parentPrecision.get("parentPrecision");
        BigDecimal qty = this.txtQty.getBigDecimalValue();
        String seqTemp = "";
        BigDecimal substituteChangeQty = new BigDecimal(0);
        BigDecimal substituteMinQty = new BigDecimal(0);
        HashMap<String, BigDecimal> count = new HashMap<String, BigDecimal>();
        int j = this.kDTable1.getRowCount();
        for (int i2 = 0; i2 < j; ++i2) {
            double headSubstituteQty;
            MaterialSustituteVO bomSubstituteInfo = (MaterialSustituteVO)this.kDTable1.getRow(i2).getUserObject();
            BigDecimal surplusQty = (BigDecimal)this.kDTable1.getRow(i2).getCell(STT_SURPLUSQTY).getValue();
            if (!seqTemp.equals((String)this.kDTable1.getRow(i2).getCell(STT_REPLACESEQ).getValue())) {
                seqTemp = (String)this.kDTable1.getRow(i2).getCell(STT_REPLACESEQ).getValue();
                if (surplusQty.doubleValue() > 0.0) {
                    headSubstituteQty = this.getHeadSubstituteQtyByEntryQty(bomSubstituteInfo, surplusQty);
                    substituteChangeQty = new BigDecimal(headSubstituteQty).divide(new BigDecimal(1.0), 16, 1);
                }
                count.put(seqTemp, substituteChangeQty);
                substituteMinQty = substituteChangeQty;
                continue;
            }
            if (surplusQty.doubleValue() > 0.0) {
                headSubstituteQty = this.getHeadSubstituteQtyByEntryQty(bomSubstituteInfo, surplusQty);
                substituteChangeQty = new BigDecimal(headSubstituteQty).divide(new BigDecimal(1.0), 16, 1);
            } else {
                substituteChangeQty = new BigDecimal(0);
            }
            if (substituteChangeQty.doubleValue() < substituteMinQty.doubleValue()) {
                count.put(seqTemp, substituteChangeQty);
                substituteMinQty = substituteChangeQty;
                continue;
            }
            count.put(seqTemp, substituteMinQty);
        }
        BigDecimal totleSubstituteQty = new BigDecimal(0);
        BigDecimal lastSeqSubstituteQty = new BigDecimal(0);
        BigDecimal totleOverSubstituteQty = new BigDecimal(0);
        BigDecimal lastActualSeqSubstituteQty = new BigDecimal(0);
        String seq = null;
        String allReplaceSeq = (String)this.countKey.get(0);
        BigDecimal allReplaceSeqQty = (BigDecimal)count.get((String)this.countKey.get(0));
        this.eachSeqReplacedCatch = new HashMap();
        int j2 = count.size();
        for (i = 0; i < j2; ++i) {
            BigDecimal eachSeqReplacedQty = (BigDecimal)count.get((String)this.countKey.get(i));
            seq = (String)this.countKey.get(i);
            if (ReplaceModeEnum.AllREPLACE == (ReplaceModeEnum)this.cmbReplaceMode.getSelectedItem()) {
                if (eachSeqReplacedQty.doubleValue() > qty.doubleValue()) {
                    allReplaceSeqQty = qty;
                    allReplaceSeq = seq;
                    totleSubstituteQty = qty;
                    break;
                }
                totleSubstituteQty = allReplaceSeqQty;
                this.eachSeqReplacedCatch.put(seq, allReplaceSeqQty);
                continue;
            }
            totleSubstituteQty = totleSubstituteQty.add(eachSeqReplacedQty);
            this.eachSeqReplacedCatch.put(seq, eachSeqReplacedQty);
            if (!(totleSubstituteQty.doubleValue() > qty.doubleValue())) continue;
            totleOverSubstituteQty = totleSubstituteQty.subtract(qty);
            lastSeqSubstituteQty = (BigDecimal)count.get(seq);
            lastActualSeqSubstituteQty = lastSeqSubstituteQty.subtract(totleOverSubstituteQty);
            break;
        }
        if (totleSubstituteQty.doubleValue() <= qty.doubleValue()) {
            seq = (String)this.countKey.get(count.size() - 1);
            this.txtReplaceQty.setValue((Object)totleSubstituteQty.divide(new BigDecimal(1.0), (int)precisionCalc, 1));
            this.headReplacedCatch = totleSubstituteQty.doubleValue();
            this.txtSurplusQty.setValue((Object)new BigDecimal(qty.doubleValue() - this.headReplacedCatch).divide(new BigDecimal(1.0), (int)precisionCalc, 0));
            lastActualSeqSubstituteQty = (BigDecimal)count.get(seq);
        } else {
            this.headReplacedCatch = qty.doubleValue();
            this.txtReplaceQty.setValue((Object)qty);
            this.txtSurplusQty.setValue((Object)new BigDecimal(0));
        }
        j2 = this.kDTable1.getRowCount();
        for (i = 0; i < j2; ++i) {
            BigDecimal entrySubstituteQty;
            BigDecimal entrySurplusQty = (BigDecimal)this.kDTable1.getRow(i).getCell(STT_SURPLUSQTY).getValue();
            MaterialSustituteVO bomSubstituteInfo = (MaterialSustituteVO)this.kDTable1.getRow(i).getUserObject();
            if (ReplaceModeEnum.AllREPLACE == (ReplaceModeEnum)this.cmbReplaceMode.getSelectedItem()) {
                if (allReplaceSeq.equals((String)this.kDTable1.getRow(i).getCell(STT_REPLACESEQ).getValue())) {
                    entrySubstituteQty = this.getEntrySubstituteByHeadQty(bomSubstituteInfo, allReplaceSeqQty);
                    if (entrySubstituteQty.doubleValue() >= entrySurplusQty.doubleValue()) {
                        this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).setValue((Object)entrySurplusQty);
                    } else {
                        this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).setValue((Object)entrySubstituteQty);
                    }
                } else {
                    this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).setValue((Object)new BigDecimal(0));
                }
            } else if (seq.equals((String)this.kDTable1.getRow(i).getCell(STT_REPLACESEQ).getValue())) {
                entrySubstituteQty = this.getEntrySubstituteByHeadQty(bomSubstituteInfo, lastActualSeqSubstituteQty);
                if (entrySubstituteQty.doubleValue() >= entrySurplusQty.doubleValue()) {
                    this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).setValue((Object)entrySurplusQty);
                } else {
                    this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).setValue((Object)entrySubstituteQty);
                }
            } else {
                String seqBefore = (String)this.kDTable1.getRow(i).getCell(STT_REPLACESEQ).getValue();
                if (Integer.parseInt(seqBefore) < Integer.parseInt(seq)) {
                    BigDecimal entrySubstituteQty2 = this.getEntrySubstituteByHeadQty(bomSubstituteInfo, (BigDecimal)count.get(seqBefore));
                    if (entrySubstituteQty2.doubleValue() >= entrySurplusQty.doubleValue()) {
                        this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).setValue((Object)entrySurplusQty);
                    } else {
                        this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).setValue((Object)entrySubstituteQty2);
                    }
                } else {
                    this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).setValue((Object)new BigDecimal(0));
                }
            }
            BigDecimal baseQty = new BigDecimal(0);
            BigDecimal qtyCount = (BigDecimal)this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).getValue();
            if (qtyCount != null && qtyCount.doubleValue() != 0.0) {
                baseQty = SCMUtils.getExchangePricesionQtyForClient((String)bomSubstituteInfo.getSubstituteMaterial().getId().toString(), (MeasureUnitInfo)bomSubstituteInfo.getSubstituteUnit(), (MeasureUnitInfo)bomSubstituteInfo.getSubstituteMaterial().getBaseUnit(), (BigDecimal)qtyCount);
            }
            this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEBASEQTY).setValue((Object)baseQty);
        }
        this.kDTable1.addKDTPropertyChangeListener(this.kdtEntrysChangeListener);
    }

    @Override
    public void actionReplace_actionPerformed(ActionEvent e) throws Exception {
        ProductionOrderStockEntryInfo pse = (ProductionOrderStockEntryInfo)this.getUIContext().get("headInfo");
        ArrayList<ProductionOrderStockEntryInfo> stockInfos = new ArrayList<ProductionOrderStockEntryInfo>();
        String connect = "-";
        int seq = 1;
        int replaceSeqNum = 0;
        String tempReplaceSeq = "";
        int j = this.kDTable1.getRowCount();
        for (int i = 0; i < j; ++i) {
            if (this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).getValue() == null || !(((BigDecimal)this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).getValue()).doubleValue() > 0.0)) continue;
            MaterialSustituteVO bomSub = (MaterialSustituteVO)this.kDTable1.getRow(i).getUserObject();
            BigDecimal sustituteQty = (BigDecimal)this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEQTY).getValue();
            BigDecimal sustituteBaseQty = (BigDecimal)this.kDTable1.getRow(i).getCell(STT_SUBSTITUTEBASEQTY).getValue();
            BigDecimal surplusQty = (BigDecimal)this.kDTable1.getRow(i).getCell(STT_SURPLUSQTY).getValue();
            String replaceSeq = (String)this.kDTable1.getRow(i).getCell(STT_REPLACESEQ).getValue();
            if (sustituteQty.doubleValue() > surplusQty.doubleValue()) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getResourceMsg("MaterialReplaceDetermine1", new String[]{i + 1 + ""}));
                return;
            }
            if (!tempReplaceSeq.equals(replaceSeq)) {
                ++replaceSeqNum;
                tempReplaceSeq = replaceSeq;
            }
            BigDecimal childBaseRate = bomSub.getToBaseUnitRate();
            ProductionOrderStockEntryInfo entryInfo = new ProductionOrderStockEntryInfo();
            entryInfo.setMaterial(bomSub.getSubstituteMaterial());
            entryInfo.setUnit(bomSub.getSubstituteUnit());
            MeasureUnitInfo baseUnit = bomSub.getSubstituteMaterial().getBaseUnit();
            entryInfo.setBaseUnit(baseUnit);
            entryInfo.setQty(sustituteQty);
            entryInfo.setBaseQty(sustituteBaseQty);
            entryInfo.setLineSeq(pse.getLineSeq() + connect + seq);
            entryInfo.setSourceBillId(pse.getParent().getSourceBillId() != null ? pse.getParent().getSourceBillId().toString() : null);
            entryInfo.setSourceBillNumber(pse.getParent().getSourceBillNumber());
            entryInfo.setSourceBillEntryId(pse.getSourceBillEntryId());
            entryInfo.setSourceBillEntrySeq(pse.getSourceBillEntrySeq());
            entryInfo.setSourceBillType(pse.getParent().getSourceBillType());
            entryInfo.setPickingLeadTime(pse.getPickingLeadTime());
            entryInfo.setBaseSendOutTotalQty(new BigDecimal(0.0));
            entryInfo.setSendOutTotalQty(new BigDecimal(0.0));
            entryInfo.setUntreadTotalQty(new BigDecimal(0.0));
            entryInfo.setBaseUntreadTotalQty(new BigDecimal(0.0));
            entryInfo.setProductLineWP(pse.getProductLineWP());
            entryInfo.setModel(bomSub.getSubstituteMaterial().getModel());
            entryInfo.setStartDate(pse.getStartDate());
            entryInfo.setEndDate(pse.getEndDate());
            entryInfo.setReplaceFlag(true);
            entryInfo.setConsumeType(pse.getConsumeType());
            if (ConsumeTypeEnum.VariableAmount.equals((Object)pse.getConsumeType())) {
                entryInfo.setConsumeFixQty(pse.getConsumeFixQty());
                entryInfo.setBaseConsumeFixQty(pse.getBaseConsumeFixQty());
                entryInfo.setProportion(new BigDecimal(0));
            } else {
                entryInfo.setConsumeFixQty(new BigDecimal(0));
                entryInfo.setBaseConsumeFixQty(new BigDecimal(0));
                entryInfo.setProportion(pse.getProportion());
            }
            entryInfo.setRemark(null);
            stockInfos.add(entryInfo);
            ++seq;
        }
        if (this.txtReplaceQty.getBigDecimalValue().doubleValue() <= 0.0 && ReplaceModeEnum.AllREPLACE == (ReplaceModeEnum)this.getUIContext().get("replaceMode")) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResourceMsg("MaterialReplaceDetermine4"));
            return;
        }
        if (replaceSeqNum > 1 && ReplaceModeEnum.AllREPLACE == (ReplaceModeEnum)this.getUIContext().get("replaceMode")) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResourceMsg("MaterialReplaceDetermine2"));
            return;
        }
        if (this.txtSurplusQty.getBigDecimalValue().doubleValue() > 0.0 && ReplaceModeEnum.AllREPLACE == (ReplaceModeEnum)this.getUIContext().get("replaceMode")) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResourceMsg("MaterialReplaceDetermine3"));
            return;
        }
        if (stockInfos.size() > 0) {
            pse.setReplaceFlag(true);
        }
        this.getUIContext().put("replaceStock", stockInfos);
        BigDecimal baseSurplusQty = SCMUtils.getExchangePricesionQtyForClient((String)pse.getMaterial().getId().toString(), (MeasureUnitInfo)pse.getUnit(), (MeasureUnitInfo)pse.getBaseUnit(), (BigDecimal)this.txtSurplusQty.getBigDecimalValue());
        pse.setQty(this.txtSurplusQty.getBigDecimalValue());
        pse.setBaseQty(baseSurplusQty);
        this.actionExitCurrent_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("replaceStock", null);
        super.actionExitCurrent_actionPerformed(e);
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)key);
    }

    private String getResourceMsg(String key, String[] params) {
        return ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)key, (String[])params);
    }
}

