/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.common.client.MMCommonProcessor;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.control.BizTypeEnum;
import com.kingdee.eas.mm.control.IPickingSlipBill;
import com.kingdee.eas.mm.control.IPickingSlipBillEntry;
import com.kingdee.eas.mm.control.PickingModeEnum;
import com.kingdee.eas.mm.control.PickingSlipBillEntryCollection;
import com.kingdee.eas.mm.control.PickingSlipBillEntryFactory;
import com.kingdee.eas.mm.control.PickingSlipBillEntryInfo;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.PickingSlipBillInfo;
import com.kingdee.eas.mm.control.client.AbstractPickingSlipBillListUI;
import com.kingdee.eas.mm.control.client.PickingSlipBillEditUI;
import com.kingdee.eas.mm.control.client.PickingSlipFilterUI;
import com.kingdee.eas.mm.control.client.PickingSlip_BySuiteUI;
import com.kingdee.eas.mm.control.client.PickingSlip_GatherUI;
import com.kingdee.eas.mm.control.client.PickingSlip_SimpleUI;
import com.kingdee.eas.mm.control.client.pickMode.AbstractPickingSlipMode;
import com.kingdee.eas.mm.control.client.pickMode.PickingModeCreateFactory;
import com.kingdee.eas.mm.control.util.PickingSlipUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;

public class PickingSlipBillListUI
extends AbstractPickingSlipBillListUI {
    private static final long serialVersionUID = -6440354495872643328L;
    private static final Logger logger = CoreUIObject.getLogger(PickingSlipBillListUI.class);
    private PickingSlipFilterUI conditionPanel = null;
    private static final String TB_PICKEDTOTALQTY = "entry.pickedTotalQty";
    private static final String TB_ISSUEEDTOTALQTY = "entry.issuedTotalQty";
    private static final String TB_RETURNEDTOTALQTY = "entry.returnedTotalQty";
    private static final String TB_REQQTY = "entry.reqQty";
    private static final String TB_REQSUITE = "reqSuite";
    private ParamUtil paramUtil = new ParamUtil(null);
    private static final String[] KDT_DATES = new String[]{"bizDate", "createTime", "entry.reqDate"};
    private static final String[] KDT_DATETIMES = new String[]{"entry.pickingDate"};

    public void onLoad() throws Exception {
        if (!this.isPickingSlipEnable()) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getPSResource("noUsePickingSlip"));
            this.abort();
            return;
        }
        super.onLoad();
        this.tblMain.getColumn(TB_REQSUITE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        EditTableUtil.formatColDateTime((KDTable)this.tblMain, (String[])KDT_DATETIMES);
        this.btnInventoryQuery.setEnabled(true);
        this.btnLock.setVisible(false);
        this.btnUnlock.setVisible(false);
        this.menuItemLock.setVisible(false);
        this.menuItemUnlock.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.actionPickingSlip.setEnabled(false);
        this.actionReturnSlip.setEnabled(false);
        this.actionCreateTo.setEnabled(false);
        this.menuItemCreateTo.setVisible(false);
        super.setReservationVisible(false);
    }

    private boolean isPickingSlipEnable() {
        boolean isPick = true;
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        if (orgUnit != null && orgUnit.getId() != null) {
            this.paramUtil.setStorageOrgUnitID(orgUnit.getId().toString(), false);
            String enabledReport = this.paramUtil.getEnabledPickBillParam("true");
            if (!"true".equals(enabledReport)) {
                isPick = false;
            }
        }
        return isPick;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PickingSlipBillFactory.getRemoteInstance();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new PickingSlipFilterUI();
        }
        return this.conditionPanel;
    }

    @Override
    protected String getEditUIName() {
        return PickingSlipBillEditUI.class.getName();
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{TB_REQSUITE, TB_REQQTY, TB_PICKEDTOTALQTY, TB_ISSUEEDTOTALQTY, TB_RETURNEDTOTALQTY};
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        String title = this.getPSResource("PickingSlipQueryWindowTitle");
        dialog.setTitle(title + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        dialog.setProcessor((IProcessor)new MMCommonProcessor(this.createCommonProcessorMap()));
        return dialog;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.pickStorageOrg.id"));
        sic.add(new SelectorItemInfo("entries.pickStorageOrg.name"));
        sic.add(new SelectorItemInfo("entries.pickStorageOrg.number"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPickingSlip.setIcon(EASResource.getIcon((String)"imgTbtn_takemateriel"));
        this.btnReturnSlip.setIcon(EASResource.getIcon((String)"imgTbtn_returnmateriel"));
        this.btnLock.setIcon(EASResource.getIcon((String)"imgTbtn_congeal"));
        this.btnUnlock.setIcon(EASResource.getIcon((String)"imgTbtn_fcongeal"));
        this.menuItemPickingSlip.setIcon(EASResource.getIcon((String)"imgTbtn_takemateriel"));
        this.menuItemReturnSlip.setIcon(EASResource.getIcon((String)"imgTbtn_returnmateriel"));
        this.menuItemLock.setIcon(EASResource.getIcon((String)"imgTbtn_congeal"));
        this.menuItemUnlock.setIcon(EASResource.getIcon((String)"imgTbtn_fcongeal"));
        this.menuItemSubmit.setVisible(false);
        this.btnInventoryQuery.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_storagefilter", (Locale)this.getLocale()));
        this.menuItemInventoryQuery.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_storagefilter", (Locale)this.getLocale()));
        this.btnBlankOut.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.menuItemBlankOut.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnPickingBySuite.setIcon(EASResource.getIcon((String)"imgTbtn_takemateriel"));
        this.btnPickingByUnSuite.setIcon(EASResource.getIcon((String)"imgTbtn_checklose"));
        this.btnPickingReSuite.setIcon(EASResource.getIcon((String)"imgTbtn_returnmateriel"));
        this.btnPickingReUnSuite.setIcon(EASResource.getIcon((String)"imgTbtn_checkprofit"));
        this.menuItemPickingSlipSuite.setIcon(EASResource.getIcon((String)"imgTbtn_takemateriel"));
        this.menuItemPickingSlipUnSuite.setIcon(EASResource.getIcon((String)"imgTbtn_checklose"));
        this.menuItemReturnSuite.setIcon(EASResource.getIcon((String)"imgTbtn_returnmateriel"));
        this.menuItemReturnUnSuite.setIcon(EASResource.getIcon((String)"imgTbtn_checkprofit"));
        this.kDMenuPercisionConfig.setText(this.kDMenuPercisionConfig.getText() + "(C)");
        this.kDMenuPercisionConfig.setIcon(EASResource.getIcon((String)"imgTbtn_showsetting"));
        this.kDMenuPercisionConfig.setMnemonic(67);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.initPSBatchActions();
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PickingSlipBillFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", null, "number", null, "storageOrgUnit.id");
    }

    public void initPSBatchActions() throws BOSException {
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.DELETE, (ItemAction)this.actionRemove, (String)"delete");
        this.actionManager.registerBatchAction(actionProxy, "actionRemove");
        actionProxy.bindTo((AbstractButton)this.btnRemove);
        actionProxy.bindTo((AbstractButton)this.menuItemRemove);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnRemove);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.AUDIT, (ItemAction)this.actionAudit, (String)"audit");
        this.actionManager.registerBatchAction(actionProxy, "actionAudit");
        actionProxy.bindTo((AbstractButton)this.btnAudit);
        actionProxy.bindTo((AbstractButton)this.menuItemAudit);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnAudit);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNAUDIT, (ItemAction)this.actionUnAudit, (String)"unAudit");
        this.actionManager.registerBatchAction(actionProxy, "actionUnAudit");
        actionProxy.bindTo((AbstractButton)this.btnUnAudit);
        actionProxy.bindTo((AbstractButton)this.menuItemUnAudit);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnUnAudit);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("BLANKOUT"), (ItemAction)this.actionBlankOut, (String)"blankOut");
        this.actionManager.registerBatchAction(actionProxy, "actionBlankOut");
        actionProxy.bindTo((AbstractButton)this.btnBlankOut);
        actionProxy.bindTo((AbstractButton)this.menuItemBlankOut);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.btnBlankOut);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.MULTIPRINT, (ItemAction)this.actionMultiPrint, null);
        this.actionManager.registerBatchAction(actionProxy, "actionMultiPrint");
        actionProxy.bindTo((AbstractButton)this.btnMultiPrint);
        actionProxy.bindTo((AbstractButton)this.menuItemMultiPrint);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.MULTIPRINTPREVIEW, (ItemAction)this.actionMultiPrintPreview, null);
        this.actionManager.registerBatchAction(actionProxy, "actionMultiPrintPreview");
        actionProxy.bindTo((AbstractButton)this.btnMultiPrintPreview);
        actionProxy.bindTo((AbstractButton)this.menuItemMultiPrintPreview);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "PickingSlipBill";
        param.alias = EASResource.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"26_PickingSlipBillListUI");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "PickingSlipBill";
        param.alias = EASResource.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"26_PickingSlipBillListUI");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionPickingSlip_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this);
        this.openPickingUI(ids, uiContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openPickingUI(List ids, UIContext uiContext) throws Exception {
        List keyList = null;
        IUIWindow uiWindow = null;
        String uiClass = null;
        Boolean isAuto = Boolean.TRUE;
        if (ids.size() > 1) {
            try {
                int i;
                uiContext.put((Object)"IDList", (Object)ids);
                IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
                PickingSlipBillInfo firstpsbInfo = (PickingSlipBillInfo)ipsb.getValue((IObjectPK)new ObjectUuidPK((String)ids.get(0)));
                String orgID = firstpsbInfo.getStorageOrgUnit().getId().toString();
                ObjectUuidPK[] pks = new ObjectUuidPK[ids.size()];
                for (i = 0; i < ids.size(); ++i) {
                    pks[i] = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
                }
                ipsb.canPickingSlip_gather((IObjectPK[])pks);
                this.setOprtState("PICKINGSLIP");
                for (i = 0; i < ids.size(); ++i) {
                    this.pubFireVOChangeListener(ids.get(i).toString());
                }
                if (firstpsbInfo.isIsBySuite()) {
                    uiContext.put((Object)"Mode", (Object)"Picking");
                    uiClass = PickingSlip_BySuiteUI.class.getName();
                } else {
                    FilterInfo productLineWPFilter = new FilterInfo();
                    Set entryIds = this.getAllSelectWpIds(ids);
                    if (entryIds != null && entryIds.size() > 0) {
                        productLineWPFilter.getFilterItems().add(new FilterItemInfo("entryIds", (Object)entryIds, CompareType.INCLUDE));
                    }
                    uiContext.put((Object)"wpFilter", (Object)productLineWPFilter);
                    uiClass = PickingSlip_GatherUI.class.getName();
                }
                uiContext.put((Object)"orgID", (Object)orgID);
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
                uiWindow.show();
                keyList = (List)uiWindow.getUIObject().getUIContext().get("result");
                isAuto = (Boolean)uiWindow.getUIObject().getUIContext().get("isAuto");
            }
            catch (EASBizException ex) {
                this.handleException((Exception)((Object)ex));
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                this.setOprtState("RELEASEALL");
                try {
                    for (int i = 0; i < ids.size(); ++i) {
                        this.pubFireVOChangeListener(ids.get(i).toString());
                    }
                }
                catch (Throwable t) {
                    this.handUIException(t);
                    SysUtil.abort();
                }
            }
        } else {
            String id = ids.get(0).toString();
            try {
                this.setOprtState("PICKINGSLIP");
                this.pubFireVOChangeListener(id);
                IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
                PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)ipsb.getValue((IObjectPK)new ObjectUuidPK((String)ids.get(0)), this.getRSelectors());
                if (!psbInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                    MsgBox.showInfo((String)(this.getPSResource("Msg_bill") + psbInfo.getNumber() + this.getPSResource("NotAudited_CannotPickingSlip")));
                    SysUtil.abort();
                }
                uiContext.put((Object)"orgID", (Object)psbInfo.getStorageOrgUnit().getId().toString());
                uiContext.put((Object)"Mode", (Object)"Picking");
                String productId = null;
                if (psbInfo.getMaterial() != null) {
                    productId = psbInfo.getMaterial().getId().toString();
                }
                uiContext.put((Object)"productId", productId);
                if (psbInfo.getTaskDisp() != null && psbInfo.getTaskDisp().getLotNo() != null && !"".equals(psbInfo.getTaskDisp().getLotNo())) {
                    uiContext.put((Object)"parentLot", (Object)psbInfo.getTaskDisp().getLotNo());
                } else if (psbInfo.getProductionOrder() != null && psbInfo.getProductionOrder().getLotNo() != null && !"".equals(psbInfo.getProductionOrder().getLotNo())) {
                    uiContext.put((Object)"parentLot", (Object)psbInfo.getProductionOrder().getLotNo());
                }
                uiContext.put((Object)"productLine", (Object)psbInfo.getProductLine().getId().toString());
                if (psbInfo.isIsBySuite()) {
                    uiContext.put((Object)"IDList", (Object)ids);
                    uiClass = PickingSlip_BySuiteUI.class.getName();
                } else {
                    uiContext.put((Object)"ID", ids.get(0));
                    FilterInfo productLineWPFilter = new FilterInfo();
                    Set entryIds = this.getAllSelectWpIds(ids);
                    if (entryIds != null && entryIds.size() > 0) {
                        productLineWPFilter.getFilterItems().add(new FilterItemInfo("entryIds", (Object)entryIds, CompareType.INCLUDE));
                    }
                    uiContext.put((Object)"wpFilter", (Object)productLineWPFilter);
                    uiClass = PickingSlip_SimpleUI.class.getName();
                }
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
                uiWindow.show();
                keyList = (List)uiWindow.getUIObject().getUIContext().get("result");
                isAuto = (Boolean)uiWindow.getUIObject().getUIContext().get("isAuto");
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                this.setOprtState("RELEASEALL");
                try {
                    this.pubFireVOChangeListener(id);
                }
                catch (Throwable t) {
                    this.handUIException(t);
                }
            }
        }
        PickingSlipUtil.autoOpenDescBill(keyList, isAuto, (CoreUI)this, this.getMainOrgContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionReturnSlip_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this);
        List keyList = null;
        Boolean isAuto = Boolean.TRUE;
        String uiClass = null;
        if (ids.size() > 1) {
            MsgBox.showInfo((String)this.getPSResource("Msg_OnlySingleReturn"));
            SysUtil.abort();
        }
        String id = ids.get(0).toString();
        try {
            this.pubFireVOChangeListener(id);
        }
        catch (Throwable e2) {
            this.handUIException(e2);
            SysUtil.abort();
        }
        try {
            IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
            PickingSlipBillInfo psbInfo = ipsb.checkSpanOrgProvide((IObjectPK)new ObjectUuidPK(id), "Return", false);
            if (Boolean.TRUE == psbInfo.get("message") && MsgBox.showConfirm2New((Component)((Object)this), (String)this.getPSResource("Msg_ReturnSlip_Confirm")) == 1) {
                return;
            }
            uiContext.put((Object)"orgID", (Object)psbInfo.getStorageOrgUnit().getId().toString());
            uiContext.put((Object)"Mode", (Object)"Return");
            if (psbInfo.getMaterial() != null) {
                uiContext.put((Object)"productId", (Object)psbInfo.getMaterial().getId().toString());
            }
            if (psbInfo.isIsBySuite()) {
                uiContext.put((Object)"IDList", (Object)ids);
                uiClass = PickingSlip_BySuiteUI.class.getName();
            } else {
                uiContext.put((Object)"ID", (Object)psbInfo.getId().toString());
                uiClass = PickingSlip_SimpleUI.class.getName();
            }
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            keyList = (List)uiWindow.getUIObject().getUIContext().get("result");
            isAuto = (Boolean)uiWindow.getUIObject().getUIContext().get("isAuto");
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        PickingSlipUtil.autoOpenDescBill(keyList, isAuto, (CoreUI)this, this.getMainOrgContext());
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        this.checkSelected();
        if (new BatchActionEnum("BLANKOUT").equals((Object)bizAction)) {
            return this.confirm(this.getPSResource("Msg_ConfirmBlankOut"));
        }
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    @Override
    public void actionInventoryQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<String> entryIds = null;
        PickingSlipBillEntryCollection pseCol = null;
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        HashSet idSet = new HashSet();
        for (int i = 0; i < idList.size(); ++i) {
            idSet.add(idList.get(i));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        IPickingSlipBillEntry ipsbe = PickingSlipBillEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        pseCol = ipsbe.getPickingSlipBillEntryCollection(viewInfo);
        if (pseCol == null || pseCol.size() == 0) {
            return;
        }
        entryIds = new ArrayList<String>();
        Iterator it = pseCol.iterator();
        while (it.hasNext()) {
            PickingSlipBillEntryInfo pseInfo = (PickingSlipBillEntryInfo)it.next();
            entryIds.add(pseInfo.getId().toString());
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)this.getMainBizOrgType(), this.getMainOrgContext().get((Object)this.getMainBizOrgType()));
        uiContext.put((Object)"idList", entryIds);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.mm.control.client.PickingSlipInventoryQueryUI", (Map)uiContext, null);
        window.show();
    }

    protected void logPrint() {
        PickingSlipBillInfo psbInfo = new PickingSlipBillInfo();
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)psbInfo.getBOSType(), null, (String)this.getPSResource("Msg_PickingSlip_Print"), (String)"mm_pickingslipbill_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private String getNumberColumn() {
        String numberColumn = null;
        if (numberColumn == null) {
            for (int i = 0; i < this.tblMain.getColumns().size(); ++i) {
                IColumn column = this.tblMain.getColumn(i);
                if (column.getFieldName() == null || !column.getFieldName().equals("number")) continue;
                numberColumn = column.getKey();
                break;
            }
            if (numberColumn == null) {
                numberColumn = "";
            }
        }
        return numberColumn;
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"id", "number", "storageOrgUnit.name", "storageOrgUnit.id", "productionOrder.number", "taskDisp.number", "workshop.name", "productline.name", "material.number", "material.name", "material.model", "unit.name", TB_REQSUITE, "shift.name", "classGroup.name", "saleOrder.number", "productionOrder.number", "traceNo", "mmBizType", "bizDate", "createTime", "creator.name", "baseStatus", "description", "trackNumber"};
    }

    protected boolean confirm(String msg) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg));
    }

    private String getPSResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)key);
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ctrl shift E"), "exportData");
        actionMap.put("exportData", (Action)this.actionExportData);
    }

    private Set getAllSelectWpIds(List ids) {
        HashSet<String> result = new HashSet<String>();
        if (this.tblMain.getSelectManager().size() == 0) {
            return null;
        }
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String id = (String)this.tblMain.getRow(i).getCell("id").getValue();
            if (!ids.contains(id)) continue;
            result.add((String)this.tblMain.getRow(i).getCell("entry.id").getValue());
        }
        return result;
    }

    protected Map createCommonProcessorMap() {
        HashMap<String, List> treatmentMap = new HashMap<String, List>();
        treatmentMap.put("mmBizType", BizTypeEnum.getEnumList());
        return treatmentMap;
    }

    public SelectorItemCollection getRSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isBySuite"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("taskDisp.id"));
        sic.add(new SelectorItemInfo("taskDisp.number"));
        sic.add(new SelectorItemInfo("taskDisp.lotNo"));
        sic.add(new SelectorItemInfo("productionOrder.id"));
        sic.add(new SelectorItemInfo("productionOrder.number"));
        sic.add(new SelectorItemInfo("productionOrder.lotNo"));
        sic.add(new SelectorItemInfo("productLine.id"));
        sic.add(new SelectorItemInfo("productLine.number"));
        sic.add(new SelectorItemInfo("productLine.name"));
        return sic;
    }

    @Override
    public void actionPickingByUnSuite_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        ArrayList entryIds = this.getSelectedFieldValues("entry.id");
        AbstractPickingSlipMode pickMode = PickingModeCreateFactory.createPickingMode(new UIContext((Object)this), PickingModeEnum.pickingSlipUnSuite);
        pickMode.init((StorageOrgUnitInfo)this.getOrgUnitInfo(), this.transformListToArray(ids));
        pickMode.setPickingEntryIds(this.transformListToArray(entryIds));
        pickMode.canPickingSlip();
        pickMode.openPickingUI();
        this.refresh(e);
        pickMode.showProcessMsg((CoreUI)this, EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource.PickingSlipSuccess"));
        pickMode.autoOpenDescBill((CoreUI)this, this.getMainContext());
    }

    @Override
    public void actionPickingReUnSuite_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        AbstractPickingSlipMode pickMode = PickingModeCreateFactory.createPickingMode(new UIContext((Object)this), PickingModeEnum.returnSlipUnSuite);
        pickMode.init((StorageOrgUnitInfo)this.getOrgUnitInfo(), this.transformListToArray(ids));
        pickMode.canReturnSlip();
        pickMode.openPickingUI();
        this.refresh(e);
        pickMode.showProcessMsg((CoreUI)this, EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource.ReturnSlipSuccess"));
        pickMode.autoOpenDescBill((CoreUI)this, this.getMainContext());
    }

    @Override
    public void actionPickingBySuite_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        AbstractPickingSlipMode pickMode = PickingModeCreateFactory.createPickingMode(new UIContext((Object)this), PickingModeEnum.pickingSlipSuite);
        pickMode.init((StorageOrgUnitInfo)this.getOrgUnitInfo(), this.transformListToArray(ids));
        pickMode.canPickingSlip();
        pickMode.openPickingUI();
        this.refresh(e);
        pickMode.showProcessMsg((CoreUI)this, EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource.PickingSlipSuccess"));
        pickMode.autoOpenDescBill((CoreUI)this, this.getMainContext());
    }

    @Override
    public void actionPickingReSuite_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        AbstractPickingSlipMode pickMode = PickingModeCreateFactory.createPickingMode(new UIContext((Object)this), PickingModeEnum.returnSlipSuite);
        pickMode.init((StorageOrgUnitInfo)this.getOrgUnitInfo(), this.transformListToArray(ids));
        pickMode.canReturnSlip();
        pickMode.openPickingUI();
        this.refresh(e);
        pickMode.showProcessMsg((CoreUI)this, EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource.ReturnSlipSuccess"));
        pickMode.autoOpenDescBill((CoreUI)this, this.getMainContext());
    }

    private String[] transformListToArray(ArrayList list) {
        if (list.size() <= 0) {
            return null;
        }
        String[] array = new String[list.size()];
        for (int index = 0; index < list.size(); ++index) {
            array[index] = list.get(index).toString();
        }
        return array;
    }
}

