/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ProductionStrategyHelper;
import com.kingdee.eas.mm.control.IPickingSlipBillEntry;
import com.kingdee.eas.mm.control.PickingSlipBillEntryCollection;
import com.kingdee.eas.mm.control.PickingSlipBillEntryFactory;
import com.kingdee.eas.mm.control.PickingSlipBillEntryInfo;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.client.AbstractPickingSlipInventoryQueryUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PickingSlipInventoryQueryUI
extends AbstractPickingSlipInventoryQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(PickingSlipInventoryQueryUI.class);
    private static final String TB_PS_ID = "id";
    private static final String TB_PS_STORORGUNITID = "FStorageOrgUnitID";
    private static final String TB_PS_STORORGUNITNAME = "FStorageOrgUnitName";
    private static final String TB_PS_NUMBER = "FNumber";
    private static final String TB_PS_PRODUCTIONORDERNUM = "FProductionOrderNum";
    private static final String TB_PS_TASKDISPBILLNUM = "FTaskDispBillNum";
    private static final String TB_PS_ENTRYID = "FEntryID";
    private static final String TB_PS_PLWPNAME = "FPlwpNum";
    private static final String TB_PS_MATERIALID = "FMaterialID";
    private static final String TB_PS_MATERIALNUM = "FMaterialNum";
    private static final String TB_PS_MATERIALNAME = "FMaterialName";
    private static final String TB_PS_MODEL = "FModel";
    private static final String TB_PS_FUNIT = "FUnit";
    private static final String TB_PS_REQQTY = "FQty";
    private static final String TB_PS_FREQDATE = "FReqDate";
    private static final String TB_PS_ISLIMIT = "FIsLimit";
    private static final String TB_PS_UPPERLIMIT = "FOverPickingTolerance";
    private static final String TB_PS_LOWERLIMIT = "FUnderPickingTolerance";
    private static final String TB_PS_FPICKINGDATE = "FPickingDate";
    private static final String TB_PS_WAREHOUSE = "FWarehouse";
    private static final String TB_PS_TRACKNUMBER = "FTraceNo";
    private static final String TB_PS_TRACKID = "FTraceID";
    private DataChangeListener prmtWarehouseDataChange = null;
    private static final String[] QTYPRECISIONFROMUNITTAB = new String[]{"FQty"};
    private static final String[] QTYPRECISIONFROMUNITTAB2 = new String[]{"FCurQty", "FCurLockQty"};
    private static final String[] KDT_DATES = new String[]{"FReqDate"};
    private static final String[] KDT_DATETIMES = new String[]{"FPickingDate"};
    private Set userStorOrgSet = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadUserStorOrgSet();
        this.initWarehouseF7();
        this.prmtWarehouseDataChange = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PickingSlipInventoryQueryUI.this.prmtWareHouse_dataChanged(e);
                }
                catch (Exception exc) {
                    PickingSlipInventoryQueryUI.this.handUIException(exc);
                }
            }
        };
        this.prmtWareHouse.addDataChangeListener(this.prmtWarehouseDataChange);
        this.prmtLocation.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (PickingSlipInventoryQueryUI.this.prmtWareHouse.getValue() == null) {
                    e.setCanceled(true);
                }
            }
        });
        this.cbIncludeExpMaterial.setSelected(true);
        this.cbIncludeExpMaterial.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PickingSlipInventoryQueryUI.this.cbIncludeExpMaterial_itemStateChanged(e);
                }
                catch (Exception exc) {
                    PickingSlipInventoryQueryUI.this.handUIException(exc);
                }
            }
        });
    }

    public void cbIncludeExpMaterial_itemStateChanged(ItemEvent e) {
        Object[] locationArr;
        HashSet<BOSUuid> warehouseIdSet = null;
        HashSet<BOSUuid> locationIdSet = null;
        int tblpsRowIndex = this.tblPSBill.getSelectManager().getActiveRowIndex();
        Object[] warehouseArr = (Object[])this.prmtWareHouse.getData();
        if (warehouseArr != null && warehouseArr.length > 0) {
            warehouseIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < warehouseArr.length; ++i) {
                warehouseIdSet.add(((WarehouseInfo)warehouseArr[i]).getId());
            }
        }
        if ((locationArr = (Object[])this.prmtLocation.getValue()) != null && locationArr.length > 0) {
            locationIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < locationArr.length; ++i) {
                locationIdSet.add(((LocationInfo)locationArr[i]).getId());
            }
        }
        try {
            this.tblInventoryinsertRow(tblpsRowIndex, warehouseIdSet, locationIdSet);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    protected Set getUserStorOrgSet() {
        return this.userStorOrgSet;
    }

    private void loadUserStorOrgSet() throws BOSException {
        UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
        String orgRangeOql = "select org.id where user = '" + curUser.getId().toString() + "' and type = " + 10 + " and org.isStorageOrgUnit = 1";
        IOrgRange iorgRange = OrgRangeFactory.getRemoteInstance();
        OrgRangeCollection orgRangeCol = iorgRange.getOrgRangeCollection(orgRangeOql);
        HashSet<String> orgSet = new HashSet<String>();
        for (OrgRangeInfo orgRangeInfo : orgRangeCol) {
            orgSet.add(orgRangeInfo.getOrg().getId().toString());
        }
        this.userStorOrgSet = orgSet;
    }

    private void initWarehouseF7() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getUserStorOrgSet(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("transState", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("transState", (Object)"2", CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2)");
        viewInfo.setFilter(filter);
        this.prmtWareHouse.setEntityViewInfo(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblPSBill.getSelectManager().setSelectMode(2);
        this.tblPSBill.getStyleAttributes().setLocked(true);
        this.tblInventory.getSelectManager().setSelectMode(2);
        this.tblInventory.getStyleAttributes().setLocked(true);
        this.tblPSBillInsertRows();
        EditTableUtil.formatColDate((KDTable)this.tblPSBill, (String[])KDT_DATES);
        EditTableUtil.formatColDateTime((KDTable)this.tblPSBill, (String[])KDT_DATETIMES);
    }

    private void tblPSBillInsertRows() throws Exception {
        this.tblPSBill.removeRows();
        ArrayList idList = (ArrayList)this.getUIContext().get("idList");
        PickingSlipBillEntryCollection psbeCol = null;
        if (idList != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("parent.number"));
            sic.add(new SelectorItemInfo("parent.productionOrder.number"));
            sic.add(new SelectorItemInfo("parent.taskDisp.number"));
            sic.add(new SelectorItemInfo("parent.trackNumber.*"));
            sic.add(new SelectorItemInfo("parent.material.id"));
            sic.add(new SelectorItemInfo("parent.material.number"));
            sic.add(new SelectorItemInfo("parent.material.name"));
            sic.add(new SelectorItemInfo("parent.material.model"));
            sic.add(new SelectorItemInfo("warehouse.id"));
            sic.add(new SelectorItemInfo("warehouse.number"));
            sic.add(new SelectorItemInfo("warehouse.name"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("material.name"));
            sic.add(new SelectorItemInfo("material.model"));
            sic.add(new SelectorItemInfo("baseUnit.id"));
            sic.add(new SelectorItemInfo("baseUnit.number"));
            sic.add(new SelectorItemInfo("baseUnit.name"));
            sic.add(new SelectorItemInfo("unit.id"));
            sic.add(new SelectorItemInfo("unit.number"));
            sic.add(new SelectorItemInfo("unit.name"));
            sic.add(new SelectorItemInfo("productLineWP.id"));
            sic.add(new SelectorItemInfo("productLineWP.name"));
            sic.add(new SelectorItemInfo("productLineWP.number"));
            sic.add(new SelectorItemInfo("materialPlan.issInHightLimit"));
            sic.add(new SelectorItemInfo("materialPlan.issInLowLimit"));
            sic.add(new SelectorItemInfo("materialPlan.isQuotaControl"));
            sic.add(new SelectorItemInfo("materialPlan.isQuotaControl"));
            sic.add(new SelectorItemInfo("parent.storageOrgUnit.*"));
            viewInfo.setSelector(sic);
            HashSet idSet = new HashSet();
            for (int i = 0; i < idList.size(); ++i) {
                idSet.add(idList.get(i));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(TB_PS_ID, idSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            IPickingSlipBillEntry ipsbe = PickingSlipBillEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            psbeCol = ipsbe.getPickingSlipBillEntryCollection(viewInfo);
        } else {
            psbeCol = (PickingSlipBillEntryCollection)((Object)this.getUIContext().get("EntryCol"));
        }
        MaterialInfo[] materialInfos = null;
        MeasureUnitInfo[] measureUnitInfos = null;
        int[] rowIndexs = null;
        Iterator it = psbeCol.iterator();
        int psCount = psbeCol.size();
        if (psCount > 0) {
            materialInfos = new MaterialInfo[psCount];
            measureUnitInfos = new MeasureUnitInfo[psCount];
            rowIndexs = new int[psCount];
        }
        int rowIndex = 0;
        while (it.hasNext()) {
            PickingSlipBillEntryInfo psbeInfo = (PickingSlipBillEntryInfo)it.next();
            if (psbeInfo.getMaterial() == null) continue;
            IRow newRow = this.tblPSBill.addRow();
            newRow.getCell(TB_PS_ID).setValue((Object)psbeInfo.getParent().getId());
            newRow.getCell(TB_PS_STORORGUNITID).setValue((Object)psbeInfo.getParent().getStorageOrgUnit().getId());
            newRow.getCell(TB_PS_STORORGUNITNAME).setValue((Object)psbeInfo.getParent().getStorageOrgUnit().getName());
            newRow.getCell(TB_PS_ENTRYID).setValue((Object)psbeInfo.getId());
            newRow.getCell(TB_PS_NUMBER).setValue((Object)psbeInfo.getParent().getNumber());
            if (psbeInfo.getParent().getProductionOrder() != null) {
                newRow.getCell(TB_PS_PRODUCTIONORDERNUM).setValue((Object)psbeInfo.getParent().getProductionOrder().getNumber());
            }
            if (psbeInfo.getParent().getTaskDisp() != null) {
                newRow.getCell(TB_PS_TASKDISPBILLNUM).setValue((Object)psbeInfo.getParent().getNumber());
            }
            if (psbeInfo.getProductLineWP() != null) {
                newRow.getCell(TB_PS_PLWPNAME).setValue((Object)psbeInfo.getProductLineWP().getName());
            }
            newRow.getCell(TB_PS_MATERIALID).setValue((Object)psbeInfo.getMaterial().getId());
            newRow.getCell(TB_PS_MATERIALID).setUserObject((Object)psbeInfo.getMaterial());
            newRow.getCell(TB_PS_MATERIALNUM).setValue((Object)psbeInfo.getMaterial().getNumber());
            newRow.getCell(TB_PS_MATERIALNAME).setValue((Object)psbeInfo.getMaterial().getName());
            newRow.getCell(TB_PS_MODEL).setValue((Object)psbeInfo.getMaterial().getModel());
            if (psbeInfo.getUnit() != null) {
                newRow.getCell(TB_PS_FUNIT).setValue((Object)psbeInfo.getUnit().getName());
                newRow.getCell(TB_PS_FUNIT).setUserObject((Object)psbeInfo.getUnit());
            }
            newRow.getCell(TB_PS_REQQTY).setValue((Object)psbeInfo.getReqQty());
            newRow.getCell(TB_PS_FREQDATE).setValue((Object)psbeInfo.getReqDate());
            newRow.getCell(TB_PS_ISLIMIT).setValue((Object)new Boolean(psbeInfo.getMaterialPlan().isIsQuotaControl()));
            newRow.getCell(TB_PS_UPPERLIMIT).setValue((Object)psbeInfo.getMaterialPlan().getIssInHightLimit());
            newRow.getCell(TB_PS_LOWERLIMIT).setValue((Object)psbeInfo.getMaterialPlan().getIssInLowLimit());
            newRow.getCell(TB_PS_FPICKINGDATE).setValue((Object)psbeInfo.getPickingDate());
            if (psbeInfo.getWarehouse() != null) {
                newRow.getCell(TB_PS_WAREHOUSE).setValue((Object)psbeInfo.getWarehouse().getName());
            }
            if (psbeInfo.getParent().getMaterial() != null && psbeInfo.getParent().getTrackNumber() != null && ProductionStrategyHelper.isATO20orMTO20(null, (String)psbeInfo.getMaterial().getId().toString(), (String)psbeInfo.getParent().getStorageOrgUnit().getId().toString())) {
                newRow.getCell(TB_PS_TRACKNUMBER).setValue((Object)psbeInfo.getParent().getTrackNumber().getNumber());
                newRow.getCell(TB_PS_TRACKID).setValue((Object)psbeInfo.getParent().getTrackNumber().getId());
            }
            materialInfos[rowIndex] = psbeInfo.getMaterial();
            measureUnitInfos[rowIndex] = psbeInfo.getUnit();
            rowIndexs[rowIndex] = rowIndex;
            ++rowIndex;
        }
        SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, (MeasureUnitInfo[])measureUnitInfos, (KDTable)this.tblPSBill, (String[])QTYPRECISIONFROMUNITTAB, (int[])rowIndexs);
        this.tblPSBill.getSelectManager().select(0, 0);
    }

    private void tblInventoryinsertRow(int rowIndex, Set warehouseIdSet, Set locationIdSet) throws Exception {
        this.tblInventory.removeRows();
        if (this.tblPSBill.getRowCount() == 0) {
            return;
        }
        IRow aRow = this.tblPSBill.getRow(rowIndex);
        EntityViewInfo ev = new EntityViewInfo();
        MaterialInfo aMaterialInfo = (MaterialInfo)aRow.getCell(TB_PS_MATERIALID).getUserObject();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo orgUnitFilter = new FilterItemInfo("STORAGEORGUNIT.ID", (Object)this.getUserStorOrgSet(), CompareType.INCLUDE);
        FilterItemInfo materialFilter = new FilterItemInfo("MATERIAL.ID", aRow.getCell(TB_PS_MATERIALID).getValue(), CompareType.EQUALS);
        FilterItemInfo storeTypeFilter = new FilterItemInfo("STORETYPE.ID", (Object)"181875d5-0105-1000-e000-0111c0a812fd97D461A6", CompareType.EQUALS);
        FilterItemInfo storeStatusFilter = new FilterItemInfo("STORESTATUS.ID", (Object)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5", CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter1 = new FilterItemInfo("WAREHOUSE.transState", (Object)"1", CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter2 = new FilterItemInfo("WAREHOUSE.transState", (Object)"2", CompareType.EQUALS);
        filter.getFilterItems().add(orgUnitFilter);
        filter.getFilterItems().add(materialFilter);
        filter.getFilterItems().add(storeTypeFilter);
        filter.getFilterItems().add(storeStatusFilter);
        filter.getFilterItems().add(warehouseStateFilter1);
        filter.getFilterItems().add(warehouseStateFilter2);
        FilterItemInfo trackNumberFilter = null;
        trackNumberFilter = aRow.getCell(TB_PS_TRACKID).getValue() == null || "".equals(aRow.getCell(TB_PS_TRACKID).getValue().toString().trim()) ? new FilterItemInfo("trackNumber.id", null, CompareType.EQUALS) : new FilterItemInfo("trackNumber.id", (Object)aRow.getCell(TB_PS_TRACKID).getValue().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(trackNumberFilter);
        filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5) and #6");
        FilterInfo conditionfilter = new FilterInfo();
        if (warehouseIdSet != null && warehouseIdSet.size() > 0) {
            FilterItemInfo warehouseFilter = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseIdSet, CompareType.INCLUDE);
            conditionfilter.getFilterItems().add(warehouseFilter);
        }
        if (locationIdSet != null && locationIdSet.size() > 0) {
            FilterItemInfo locationFilter = new FilterItemInfo("LOCATION.ID", (Object)locationIdSet, CompareType.INCLUDE);
            conditionfilter.getFilterItems().add(locationFilter);
        }
        if (conditionfilter.getFilterItems().size() > 0) {
            filter.mergeFilter(conditionfilter, "and");
        }
        ev.setFilter(filter);
        SCMLockInvDataVO vo = new SCMLockInvDataVO();
        vo.setTableNether(true);
        vo.setViewInfo(ev);
        vo.setType("bottom");
        Date reqDate = (Date)aRow.getCell(TB_PS_FREQDATE).getValue();
        SCMLockInvDataVO tblInventoryVO = PickingSlipBillFactory.getRemoteInstance().getMaterialInventory(vo, reqDate);
        IObjectPK[] invIdList = tblInventoryVO.getInvIdList();
        Map wareHouseMap = tblInventoryVO.getWareHouseMap();
        Map locationMap = tblInventoryVO.getLocationMap();
        Map storeTypeMap = tblInventoryVO.getStoreTypeMap();
        Map storeStateMap = tblInventoryVO.getStoreStateMap();
        Map supplierMap = tblInventoryVO.getSupplierMap();
        Map customerMap = tblInventoryVO.getCustomerMap();
        Map storageMap = tblInventoryVO.getStorageMap();
        Map invUnitMap = tblInventoryVO.getInvUnitMap();
        Map inventoryMap = tblInventoryVO.getInventoryMap();
        Map trackNumberMap = tblInventoryVO.getTrackNumberMap();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(TB_PS_ID));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        String invID = null;
        int n = invIdList.length;
        for (int i = 0; i < n; ++i) {
            invID = invIdList[i].toString();
            InventoryInfo aInventoryInfo = (InventoryInfo)inventoryMap.get(invID);
            if (aInventoryInfo.getCurStoreQty() != null && aInventoryInfo.getCurStoreQty().doubleValue() == 0.0) continue;
            IRow newRow = this.tblInventory.addRow();
            StorageOrgUnitInfo aStorageOrgUnitInfo = (StorageOrgUnitInfo)storageMap.get(invID);
            newRow.getCell("FStorageOrg").setValue((Object)aStorageOrgUnitInfo.getName());
            newRow.getCell("FStorageOrg").setUserObject((Object)aStorageOrgUnitInfo);
            newRow.getCell(TB_PS_ID).setValue((Object)invIdList[i]);
            newRow.getCell("select").setValue((Object)new Boolean(false));
            if (aInventoryInfo.getWarehouse() != null) {
                WarehouseInfo aWarehouseInfo = (WarehouseInfo)wareHouseMap.get(invID);
                newRow.getCell("FWareHouse").setValue((Object)aWarehouseInfo.getName());
                newRow.getCell("FWareHouse").setUserObject((Object)aWarehouseInfo);
            }
            if (aInventoryInfo.getLocation() != null) {
                LocationInfo aLocationInfo = (LocationInfo)locationMap.get(invID);
                newRow.getCell("FLocation").setValue((Object)aLocationInfo.getName());
                newRow.getCell("FLocation").setUserObject((Object)aLocationInfo);
            }
            newRow.getCell("FCurQty").setValue((Object)aInventoryInfo.getCurStoreQty());
            if (aInventoryInfo.getLot() != null) {
                newRow.getCell("FLot").setValue((Object)aInventoryInfo.getLot());
            }
            if (aInventoryInfo.getStoretype() != null) {
                StoreTypeInfo aStoreTypeInfo = (StoreTypeInfo)storeTypeMap.get(invID);
                newRow.getCell("FStoreType").setValue((Object)aStoreTypeInfo.getName());
                newRow.getCell("FStoreType").setUserObject((Object)aStoreTypeInfo);
            }
            if (aInventoryInfo.getStorestatus() != null) {
                StoreStateInfo aStoreStateInfo = (StoreStateInfo)storeStateMap.get(invID);
                newRow.getCell("FStoreState").setValue((Object)aStoreStateInfo.getName());
                newRow.getCell("FStoreState").setUserObject((Object)aStoreStateInfo);
            }
            if (aInventoryInfo.getSupplier() != null) {
                SupplierInfo aSupplierInfo = (SupplierInfo)supplierMap.get(invID);
                newRow.getCell("FSupplier").setValue((Object)aSupplierInfo.getName());
                newRow.getCell("FSupplier").setUserObject((Object)aSupplierInfo);
            }
            if (aInventoryInfo.getCustomer() != null) {
                CustomerInfo aCustomerInfo = (CustomerInfo)customerMap.get(invID);
                newRow.getCell("FCustomer").setValue((Object)aCustomerInfo.getName());
                newRow.getCell("FCustomer").setUserObject((Object)aCustomerInfo);
            }
            if (aInventoryInfo.getTrackNumber() != null) {
                TrackNumberInfo trackNumberInfo = (TrackNumberInfo)trackNumberMap.get(invID);
                newRow.getCell("FTrackNumber").setValue((Object)trackNumberInfo.getNumber());
            }
            if (aInventoryInfo.getUnit() != null) {
                MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)invUnitMap.get(invID);
                newRow.getCell(TB_PS_FUNIT).setValue((Object)measureUnitInfo.getName());
                newRow.getCell(TB_PS_FUNIT).setUserObject((Object)measureUnitInfo);
                this.changePrecision(tblInventoryVO, this.tblInventory, QTYPRECISIONFROMUNITTAB2, aMaterialInfo, measureUnitInfo, newRow.getRowIndex());
            }
            newRow.getCell("FCurLockQty").getStyleAttributes().setLocked(true);
        }
    }

    protected void prmtWareHouse_dataChanged(DataChangeEvent e) {
        Object warehouse = this.prmtWareHouse.getData();
        HashSet<String> warehouseSet = new HashSet<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.prmtLocation.setValue(null);
        if (warehouse == null) {
            this.prmtLocation.setEnabled(false);
        } else if (warehouse instanceof Object[]) {
            Object[] warehouseArr = (Object[])warehouse;
            if (warehouseArr.length == 1) {
                filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)((WarehouseInfo)warehouseArr[0]).getId().toString(), CompareType.EQUALS));
            } else if (warehouseArr.length > 1) {
                for (int i = 0; i < warehouseArr.length; ++i) {
                    warehouseSet.add(((WarehouseInfo)warehouseArr[i]).getId().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", warehouseSet, CompareType.INCLUDE));
            }
            this.prmtLocation.setEnabled(true);
            viewInfo.setFilter(filter);
            this.prmtLocation.setEntityViewInfo(viewInfo);
        }
    }

    private void changePrecision(SCMLockInvDataVO resultVO, KDTable kdtable, String[] fieldNames, MaterialInfo info, MeasureUnitInfo measureUnitInfo, int rowIndex) {
        MultiMeasureUnitInfo multiUnitInfo;
        int precision = 2;
        Map mmuMap = resultVO.getMmuPrecisions();
        if (info != null && measureUnitInfo != null && (multiUnitInfo = (MultiMeasureUnitInfo)mmuMap.get(info.getId().toString() + measureUnitInfo.getId().toString())) != null) {
            precision = multiUnitInfo.getQtyPrecision();
        }
        SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)kdtable, (String[])fieldNames, (int)rowIndex);
    }

    @Override
    protected void tblPSBill_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.prmtWareHouse.removeDataChangeListener(this.prmtWarehouseDataChange);
        this.prmtWareHouse.setValue(null);
        this.prmtWareHouse.addDataChangeListener(this.prmtWarehouseDataChange);
        this.prmtLocation.setValue(null);
        this.prmtLocation.setEnabled(false);
        this.tblInventoryinsertRow(e.getSelectBlock().getBeginRow(), null, null);
    }

    @Override
    public void actionQueryInventory_actionPerformed(ActionEvent e) throws Exception {
        Object[] locationArr;
        HashSet<BOSUuid> warehouseIdSet = null;
        HashSet<BOSUuid> locationIdSet = null;
        int tblpsRowIndex = this.tblPSBill.getSelectManager().getActiveRowIndex();
        Object[] warehouseArr = (Object[])this.prmtWareHouse.getData();
        if (warehouseArr != null && warehouseArr.length > 0) {
            warehouseIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < warehouseArr.length; ++i) {
                warehouseIdSet.add(((WarehouseInfo)warehouseArr[i]).getId());
            }
        }
        if ((locationArr = (Object[])this.prmtLocation.getValue()) != null && locationArr.length > 0) {
            locationIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < locationArr.length; ++i) {
                locationIdSet.add(((LocationInfo)locationArr[i]).getId());
            }
        }
        this.tblInventoryinsertRow(tblpsRowIndex, warehouseIdSet, locationIdSet);
    }
}

