/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.mm.control.IPickingSlipBill;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.PickingSlipLotCollection;
import com.kingdee.eas.mm.control.PickingSlipLotInfo;
import com.kingdee.eas.mm.control.client.AbstractPickingSlipLotUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PickingSlipLotUI
extends AbstractPickingSlipLotUI {
    private static final Logger logger = CoreUIObject.getLogger(PickingSlipLotUI.class);
    private static final String TB_PICKINGSLIPLOTID = "id";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_WAREHOUSENAME = "warehouseName";
    private static final String TB_LOCATION = "location";
    private static final String TB_LOCATIONNAME = "locationName";
    private static final String TB_LOT = "lot";
    private static final String TB_USEABLEQTY = "useableQty";
    private static final String TB_EXP = "exp";
    private static final String TB_SELECTEDQTY = "selectedQty";
    private static final String TB_PICKEDQTY = "pickedQty";
    private static final String TB_ACTUALOUTSTOCKQTY = "actualOutStockQty";
    private static final String TB_ACTUALRETURNQTY = "actualReturnQty";
    public static final String STATUS_CANCEL = "CANCEL";
    public static final String STATUS_CONFIRM = "CONFIRM";
    private PickingSlipLotCollection lotData = null;
    private int precision = 2;
    private KDTEditAdapter entryTableChange = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initFields();
        this.loadHeaderData();
        this.loadEntryData(this.kdtTable, this.lotData);
    }

    public void initFields() {
        this.entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    PickingSlipLotUI.this.kdtTable_editStopped(e);
                }
                catch (Exception ex) {
                    PickingSlipLotUI.this.handUIException(ex);
                }
            }
        };
        this.kdtTable.addKDTEditListener((KDTEditListener)this.entryTableChange);
        KDFormattedTextField reqQty_TextField = new KDFormattedTextField();
        reqQty_TextField.setName("kdtEntrys_baseReqQty_TextField");
        reqQty_TextField.setEditable(true);
        reqQty_TextField.setDataType(1);
        reqQty_TextField.setPrecision(this.precision);
        reqQty_TextField.setRemoveingZeroInDispaly(false);
        reqQty_TextField.setHorizontalAlignment(4);
        reqQty_TextField.setSupportedEmpty(true);
        reqQty_TextField.setNegatived(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.precision = ((BigDecimal)this.getUIContext().get("precision")).intValue();
        this.txtreqQty.getDataType();
        this.txtreqQty.setDataType(1);
        this.txtreqQty.setRemoveingZeroInDispaly(false);
        this.txtreqQty.setSupportedEmpty(true);
        this.txtreqQty.setPrecision(this.precision);
        this.txtreqQty.setHorizontalAlignment(4);
        this.kdtTable.getStyleAttributes().setLocked(true);
    }

    private void loadHeaderData() {
        this.txtmaterialNum.setText(((MaterialInfo)this.getUIContext().get("Material")).getNumber().toString());
        this.txtreqQty.setValue(this.getUIContext().get("reqQty"));
        this.lotData = (PickingSlipLotCollection)((Object)this.getUIContext().get("lotCollection"));
    }

    private void loadEntryData(KDTable kdtTable, PickingSlipLotCollection lotData) {
        if (lotData.size() > 0) {
            Iterator iter = lotData.iterator();
            while (iter.hasNext()) {
                PickingSlipLotInfo lotVO = (PickingSlipLotInfo)iter.next();
                IRow row = kdtTable.addRow();
                row.getCell(TB_PICKINGSLIPLOTID).setValue((Object)lotVO.getId());
                row.getCell(TB_WAREHOUSE).setValue((Object)lotVO.getWarehouse().getId());
                row.getCell(TB_WAREHOUSENAME).setValue((Object)lotVO.getWarehouse().getName());
                if (lotVO.getLocation() != null) {
                    row.getCell(TB_LOCATION).setValue((Object)lotVO.getLocation().getId());
                    row.getCell(TB_LOCATIONNAME).setValue((Object)lotVO.getLocation().getName());
                }
                row.getCell(TB_LOT).setValue((Object)lotVO.getLot());
                row.getCell(TB_USEABLEQTY).setValue((Object)lotVO.getUseableQty());
                if (lotVO.getSelectQty() != null) {
                    row.getCell(TB_SELECTEDQTY).setValue((Object)lotVO.getSelectQty().setScale(this.precision, 4));
                }
                if (lotVO.getPickedQty() != null) {
                    row.getCell(TB_PICKEDQTY).setValue((Object)lotVO.getPickedQty().setScale(this.precision, 4));
                }
                if (lotVO.getActualOutStockQty() != null) {
                    row.getCell(TB_ACTUALOUTSTOCKQTY).setValue((Object)lotVO.getActualOutStockQty().setScale(this.precision, 4));
                }
                if (lotVO.getReturnedQty() == null) continue;
                row.getCell(TB_ACTUALRETURNQTY).setValue((Object)lotVO.getReturnedQty().setScale(this.precision, 4));
            }
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        for (int rowIndex = 0; rowIndex < this.kdtTable.getBody().size(); ++rowIndex) {
            this.kdtTable.getCell(rowIndex, TB_SELECTEDQTY).setValue(null);
        }
    }

    @Override
    public void actionReload_actionPerformed(ActionEvent e) throws Exception {
        this.kdtTable.removeRows();
        String orgUnitId = this.getUIContext().get("OrgUnitID").toString();
        String unitId = this.getUIContext().get("UnitID").toString();
        String materialId = ((MaterialInfo)this.getUIContext().get("Material")).getId().toString();
        IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
        IRowSet rs = ipsb.getLotsByMaterial(materialId, orgUnitId, unitId);
        PickingSlipLotCollection pslCol = new PickingSlipLotCollection();
        while (rs.next()) {
            PickingSlipLotInfo pslInfo = new PickingSlipLotInfo();
            WarehouseInfo whInfo = new WarehouseInfo();
            whInfo.setId(BOSUuid.read((String)rs.getString("FWarehouseID")));
            whInfo.setName(rs.getString("FWarehouseName"));
            pslInfo.setWarehouse(whInfo);
            LocationInfo lcInfo = null;
            if (rs.getString("FLocationID") != null) {
                lcInfo = new LocationInfo();
                lcInfo.setId(BOSUuid.read((String)rs.getString("FLocationID")));
                lcInfo.setName(rs.getString("FLocationName"));
            }
            pslInfo.setLocation(lcInfo);
            pslInfo.setLot(rs.getString("FLot"));
            pslInfo.setUseableQty(rs.getBigDecimal("FUseableQty"));
            pslCol.addObject((IObjectValue)pslInfo);
        }
        this.loadEntryData(this.kdtTable, pslCol);
    }

    @Override
    public void actionAutoAssign_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int i = 0;
        int rowIndex = 0;
        while (i < this.lotData.size()) {
            if (this.kdtTable.getCell(rowIndex, TB_SELECTEDQTY).getValue() != null && ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_SELECTEDQTY).getValue()).compareTo(new BigDecimal(0)) > 0) {
                PickingSlipLotInfo pslInfo = this.lotData.get(i);
                pslInfo.setSelectQty((BigDecimal)this.kdtTable.getCell(rowIndex, TB_SELECTEDQTY).getValue());
            } else {
                this.lotData.removeObject(i);
                --i;
            }
            ++i;
            ++rowIndex;
        }
        this.getUIContext().put("selectedLots", this.lotData);
        this.getUIContext().put("oprtType", new Integer(0));
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void kdtTable_editStopped(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        int row = e.getRowIndex();
        String fieldName = this.kdtTable.getColumnKey(colIndex);
        if (TB_SELECTEDQTY.equalsIgnoreCase(fieldName)) {
            if (this.kdtTable.getCell(row, TB_SELECTEDQTY).getValue() != null && ((BigDecimal)this.kdtTable.getCell(row, TB_SELECTEDQTY).getValue()).compareTo(new BigDecimal(0)) > 0 && ((BigDecimal)this.kdtTable.getCell(row, TB_SELECTEDQTY).getValue()).compareTo((BigDecimal)this.kdtTable.getCell(row, TB_USEABLEQTY).getValue()) > 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_SelectQtyBiggerUsingAbleQty"));
                this.kdtTable.getEditManager().editCellAt(row, colIndex);
                SysUtil.abort();
            }
            BigDecimal selectedTotalQty = new BigDecimal(0.0);
            for (int rowIndex = 0; rowIndex < this.kdtTable.getBody().size(); ++rowIndex) {
                if (this.kdtTable.getCell(rowIndex, TB_SELECTEDQTY).getValue() == null) continue;
                selectedTotalQty = selectedTotalQty.add((BigDecimal)this.kdtTable.getCell(rowIndex, TB_SELECTEDQTY).getValue());
            }
        }
    }
}

