/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.control.IPickingSlipBill;
import com.kingdee.eas.mm.control.PickingSlipBillCollection;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.PickingSlipBillInfo;
import com.kingdee.eas.mm.control.client.AbstractPickingSlip_BySuiteUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PickingSlip_BySuiteUI
extends AbstractPickingSlip_BySuiteUI {
    private static final Logger logger = CoreUIObject.getLogger(PickingSlip_BySuiteUI.class);
    private PickingSlipBillCollection pickingSlipBillCol = new PickingSlipBillCollection();
    private static final String TB_PRODUCTIONORDER = "productionOrder";
    private static final String TB_TASKDISP = "taskDisp";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALMODEL = "model";
    private static final String TB_UNIT = "unit";
    private static final String TB_PICKINGABLESUITE = "pickingAbleSuite";
    private static final String TB_RETURNABLESUITE = "returnAbleSuite";
    private static final String TB_PICKINGSUITE = "pickingSuite";
    private static final String TB_RETURNINGSUITE = "returningSuite";
    private static final String TB_SUPPLEMENTSUITE = "supplementSuite";
    private static final int DEFAULT_PRICISION = 2;
    private KDTEditAdapter entryTableChange = null;
    private String mode = "";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadData();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initUI();
        this.initData(this.kdtTable);
    }

    private void initUI() {
        this.mode = this.getUIContext().get("Mode").toString();
        if (this.mode.equals("Picking")) {
            this.kdtTable.getColumn(TB_RETURNABLESUITE).getStyleAttributes().setHided(true);
            this.kdtTable.getColumn(TB_RETURNINGSUITE).getStyleAttributes().setHided(true);
            this.kdtTable.getColumn(TB_SUPPLEMENTSUITE).getStyleAttributes().setHided(true);
        } else if (this.mode.equals("Return")) {
            this.kdtTable.getColumn(TB_PICKINGABLESUITE).getStyleAttributes().setHided(true);
            this.kdtTable.getColumn(TB_PICKINGSUITE).getStyleAttributes().setHided(true);
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"ReturnSlip_BySuite"));
        }
    }

    private void loadData() throws BOSException, EASBizException {
        IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
        ArrayList ids = (ArrayList)this.getUIContext().get("IDList");
        if (ids == null) {
            String s = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_IDIsNull");
            MsgBox.showError((String)s);
            SysUtil.abort();
        }
        if (ids.size() == 1) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)ids.get(0))));
            PickingSlipBillInfo psbInfo = ipsb.getPickingSlipBillInfo((IObjectPK)pk, this.getSelectors());
            this.pickingSlipBillCol.addObject((IObjectValue)psbInfo);
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("material.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("material.model"));
            viewInfo.getSelector().add(new SelectorItemInfo("unit.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("unit.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("productionOrder.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("productionOrder.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("taskDisp.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("taskDisp.model"));
            FilterInfo fiter = new FilterInfo();
            fiter.getFilterItems().add(new FilterItemInfo("ID", new HashSet(ids), CompareType.INCLUDE));
            viewInfo.setFilter(fiter);
            this.pickingSlipBillCol = ipsb.getPickingSlipBillCollection(viewInfo);
        }
        int isAuto = ipsb.getIsAutoOpenDesc();
        this.ckIsAutoOpenDesc.setSelected(isAuto == 1);
    }

    private void initData(KDTable kdTable) throws BOSException, EASBizException {
        Iterator iter = this.pickingSlipBillCol.iterator();
        while (iter.hasNext()) {
            PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)iter.next();
            int precision = 2;
            IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnitInfo = imultiUnit.getMultiUnit(psbInfo.getMaterial().getId().toString(), psbInfo.getUnit().getId().toString());
            if (multiUnitInfo != null) {
                precision = multiUnitInfo.getQtyPrecision();
            }
            if (this.mode.equals("Picking")) {
                IRow row = kdTable.addRow();
                row.getCell("ID").setValue((Object)psbInfo.getId());
                row.getCell(TB_PRODUCTIONORDER).setValue(psbInfo.getProductionOrder() == null ? null : psbInfo.getProductionOrder().getNumber());
                row.getCell(TB_TASKDISP).setValue(psbInfo.getTaskDisp() == null ? null : psbInfo.getTaskDisp().getNumber());
                row.getCell(TB_MATERIAL).setValue(psbInfo.getMaterial() == null ? null : psbInfo.getMaterial().getNumber());
                row.getCell(TB_MATERIALMODEL).setValue(psbInfo.getMaterial() == null ? null : psbInfo.getMaterial().getModel());
                row.getCell(TB_UNIT).setValue(psbInfo.getUnit() == null ? null : psbInfo.getUnit().getName());
                BigDecimal pickingAbleSuite = psbInfo.getReqSuite();
                pickingAbleSuite = pickingAbleSuite.subtract(psbInfo.getSupplementTotalSuite()).subtract(psbInfo.getPickedTotalSuite()).add(psbInfo.getReturnedTotalSuite());
                row.getCell(TB_PICKINGABLESUITE).setEditor((ICellEditor)this.initNumericCellEditor(precision));
                row.getCell(TB_PICKINGABLESUITE).setValue((Object)pickingAbleSuite.setScale(precision, 4));
                row.getCell(TB_PICKINGSUITE).setEditor((ICellEditor)this.initNumericCellEditor(precision));
                if (pickingAbleSuite.compareTo(new BigDecimal(0)) >= 0) {
                    row.getCell(TB_PICKINGSUITE).setValue((Object)pickingAbleSuite.setScale(precision, 4));
                    continue;
                }
                row.getCell(TB_PICKINGSUITE).setValue((Object)new BigDecimal(0).setScale(precision, 4));
                continue;
            }
            if (!this.mode.equals("Return")) continue;
            BigDecimal returnAbleSuite = psbInfo.getPickedTotalSuite();
            if ((returnAbleSuite = returnAbleSuite.subtract(psbInfo.getReturnedTotalSuite())).compareTo(new BigDecimal(0)) <= 0) continue;
            IRow row = kdTable.addRow();
            row.getCell("ID").setValue((Object)psbInfo.getId());
            row.getCell(TB_PRODUCTIONORDER).setValue(psbInfo.getProductionOrder() == null ? null : psbInfo.getProductionOrder().getNumber());
            row.getCell(TB_TASKDISP).setValue(psbInfo.getTaskDisp() == null ? null : psbInfo.getTaskDisp().getNumber());
            row.getCell(TB_MATERIAL).setValue(psbInfo.getMaterial() == null ? null : psbInfo.getMaterial().getNumber());
            row.getCell(TB_MATERIALMODEL).setValue(psbInfo.getMaterial() == null ? null : psbInfo.getMaterial().getModel());
            row.getCell(TB_UNIT).setValue(psbInfo.getUnit() == null ? null : psbInfo.getUnit().getName());
            row.getCell(TB_RETURNABLESUITE).setValue((Object)returnAbleSuite.setScale(precision, 4));
            row.getCell(TB_RETURNINGSUITE).setEditor((ICellEditor)this.initNumericCellEditor(precision));
            row.getCell(TB_RETURNINGSUITE).setValue((Object)new BigDecimal(0).setScale(precision, 4));
            row.getCell(TB_SUPPLEMENTSUITE).setEditor((ICellEditor)this.initNumericCellEditor(precision));
            row.getCell(TB_SUPPLEMENTSUITE).setValue((Object)new BigDecimal(0).setScale(precision, 4));
        }
    }

    private KDTDefaultCellEditor initNumericCellEditor(int precision) {
        KDFormattedTextField numeric_TextField = new KDFormattedTextField();
        numeric_TextField.setDataType(1);
        numeric_TextField.setRemoveingZeroInDispaly(false);
        numeric_TextField.setHorizontalAlignment(4);
        numeric_TextField.setSupportedEmpty(true);
        numeric_TextField.setNegatived(false);
        numeric_TextField.setPrecision(precision);
        KDTDefaultCellEditor kdtEntrys_numeric_CellEditor = new KDTDefaultCellEditor((JTextField)numeric_TextField);
        return kdtEntrys_numeric_CellEditor;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkNumber();
        Vector vec = new Vector();
        ArrayList<Object> ids = new ArrayList<Object>();
        IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
        String orgID = this.getUIContext().get("orgID").toString();
        for (int i = 0; i < this.kdtTable.getBody().size(); ++i) {
            HashMap<String, Object> psb;
            if (this.mode.equals("Picking")) {
                if (this.kdtTable.getCell(i, TB_PICKINGSUITE).getValue() == null || ((BigDecimal)this.kdtTable.getCell(i, TB_PICKINGSUITE).getValue()).compareTo(new BigDecimal(0)) <= 0) continue;
                psb = new HashMap<String, Object>();
                psb.put("ID", this.kdtTable.getCell(i, "ID").getValue());
                psb.put(TB_PICKINGSUITE, this.kdtTable.getCell(i, TB_PICKINGSUITE).getValue());
                vec.add(psb);
                ids.add(this.kdtTable.getCell(i, "ID").getValue());
                continue;
            }
            if (!this.mode.equals("Return") || this.kdtTable.getCell(i, TB_RETURNINGSUITE).getValue() == null || ((BigDecimal)this.kdtTable.getCell(i, TB_RETURNINGSUITE).getValue()).compareTo(new BigDecimal(0)) <= 0) continue;
            psb = new HashMap();
            psb.put("ID", this.kdtTable.getCell(i, "ID").getValue());
            BigDecimal returningSuite = new BigDecimal(0);
            BigDecimal supplementSuite = new BigDecimal(0);
            if (this.kdtTable.getCell(i, TB_RETURNINGSUITE).getValue() != null) {
                returningSuite = (BigDecimal)this.kdtTable.getCell(i, TB_RETURNINGSUITE).getValue();
            }
            if (this.kdtTable.getCell(i, TB_SUPPLEMENTSUITE).getValue() != null) {
                supplementSuite = (BigDecimal)this.kdtTable.getCell(i, TB_SUPPLEMENTSUITE).getValue();
            }
            psb.put(TB_RETURNINGSUITE, returningSuite);
            psb.put(TB_SUPPLEMENTSUITE, supplementSuite);
            vec.add(psb);
            ids.add(this.kdtTable.getCell(i, "ID").getValue());
        }
        if (vec.size() > 0) {
            IObjectPK[] pks = new IObjectPK[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                pks[i] = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
            }
            HashMap otherParam = new HashMap();
            otherParam.put("productId", this.getUIContext().get("productId"));
            otherParam.put("parentLot", this.getUIContext().get("parentLot"));
            otherParam.put("productLine", this.getUIContext().get("productLine"));
            Map result = null;
            if (this.mode.equals("Picking")) {
                result = ipsb.pickingSlip_BySuite(vec, orgID, pks, otherParam);
            } else if (this.mode.equals("Return")) {
                result = ipsb.returnSlip_BySuite(vec, orgID, pks, otherParam);
            }
            this.getUIContext().put("result", result.get("result"));
            this.getUIContext().put("isAuto", this.ckIsAutoOpenDesc.isSelected());
            this.actionExitCurrent_actionPerformed(e);
        } else if (this.mode.equals("Picking")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_AtLeastOnePSSuite"));
            SysUtil.abort();
        } else if (this.mode.equals("Return")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_AtLeastOneRSSuite"));
            SysUtil.abort();
        }
    }

    private void checkNumber() {
        String fieldName = "";
        if (this.mode.equals("Return")) {
            fieldName = TB_RETURNINGSUITE;
            int colIndex = this.kdtTable.getColumnIndex(TB_RETURNINGSUITE);
            for (int rowIndex = 0; rowIndex < this.kdtTable.getBody().size(); ++rowIndex) {
                if (!TB_RETURNINGSUITE.equalsIgnoreCase(fieldName) || this.kdtTable.getCell(rowIndex, TB_RETURNINGSUITE).getValue() == null || ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_RETURNINGSUITE).getValue()).compareTo(new BigDecimal(0)) <= 0 || ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_RETURNINGSUITE).getValue()).compareTo((BigDecimal)this.kdtTable.getCell(rowIndex, TB_RETURNABLESUITE).getValue()) <= 0) continue;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_RtnSuiteBiggerReturnAble"));
                this.kdtTable.getEditManager().editCellAt(rowIndex, colIndex);
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("productionOrder.id"));
        sic.add(new SelectorItemInfo("productionOrder.number"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("taskDisp.number"));
        sic.add(new SelectorItemInfo("taskDisp.model"));
        return sic;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }
}

