/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.mm.control.IPickingSlipBill;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.client.AbstractPickingSlip_GatherUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PickingSlip_GatherUI
extends AbstractPickingSlip_GatherUI {
    private static final Logger logger = CoreUIObject.getLogger(PickingSlip_GatherUI.class);
    private static String tempTable;
    private static String srcDataTempTable;
    private static boolean isDividingByNumber;
    private KDTEditAdapter entryTableChange = null;
    private static final String TB_ID = "id";
    private static final String TB_ENTRYID = "entry.id";
    private static final String TB_WORKSHOP = "workshop";
    private static final String TB_PRODUCTLINE = "productline";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MODEL = "model";
    private static final String TB_UNIT = "unit";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_LOCATION = "location";
    private static final String TB_LOT = "lot";
    private static final String TB_REQQTY = "reqQty";
    private static final String TB_ISQUOTACONTROL = "isQuotaControl";
    private static final String TB_UPPERLIMITQTY = "upperLimitQty";
    private static final String TB_PICKINGQTY = "pickingQty";
    private static final String TB_TRACENO = "traceno";
    private static final String TB_SALEORDER = "saleOrder";
    private static final String TB_PICKINGDATE = "pickingdate";
    private static final String TB_NUMBER = "number";
    private static final String TB_TRACKNUMBER = "trackNumber";

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.loadData();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void loadData() {
        ArrayList ids = (ArrayList)this.getUIContext().get("IDList");
        String orgID = this.getUIContext().get("orgID").toString();
        FilterInfo productLineWPFilter = (FilterInfo)this.getUIContext().get("wpFilter");
        if (ids == null) {
            String s = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_IDIsNull");
            MsgBox.showError((String)s);
            SysUtil.abort();
        }
        try {
            IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
            srcDataTempTable = ipsb.createTempPSTable();
            tempTable = ipsb.createTempTable_gather();
            isDividingByNumber = ipsb.getIsDividingByNumber();
            IRowSet rs = ipsb.buildTempTable_Gather(ids, tempTable, srcDataTempTable, orgID, productLineWPFilter);
            if (isDividingByNumber) {
                this.kdtTable.getColumn(TB_NUMBER).getStyleAttributes().setHided(false);
                int index = this.kdtTable.getColumn(TB_NUMBER).getColumnIndex();
                this.initData(this.kdtTable, rs, index);
            } else {
                this.initData(this.kdtTable, rs);
            }
            int isAuto = ipsb.getIsAutoOpenDesc();
            this.ckIsAutoOpenDesc.setSelected(isAuto == 1);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initData(KDTable kdTable, IRowSet rs) throws Exception {
        while (rs.next()) {
            IRow row = kdTable.addRow();
            row.getCell(TB_ID).setValue((Object)rs.getString("FID"));
            row.getCell(TB_MATERIAL).setValue((Object)rs.getString(TB_MATERIAL));
            row.getCell(TB_MATERIALNAME).setValue((Object)rs.getString(TB_MATERIALNAME));
            row.getCell(TB_MODEL).setValue((Object)rs.getString(TB_MODEL));
            row.getCell(TB_UNIT).setValue((Object)rs.getString(TB_UNIT));
            row.getCell(TB_REQQTY).setValue((Object)rs.getBigDecimal("FReqQty").setScale(rs.getInt("FQtyPrecision"), 4));
            row.getCell(TB_LOT).setValue((Object)rs.getString("FLotNo"));
            row.getCell(TB_LOT).setValue((Object)rs.getString("FLotNo"));
            row.getCell(TB_WAREHOUSE).setValue((Object)rs.getString(TB_WAREHOUSE));
            row.getCell(TB_LOCATION).setValue((Object)rs.getString(TB_LOCATION));
            row.getCell(TB_WORKSHOP).setValue((Object)rs.getString(TB_WORKSHOP));
            row.getCell(TB_PRODUCTLINE).setValue((Object)rs.getString(TB_PRODUCTLINE));
            row.getCell(TB_PICKINGQTY).setEditor((ICellEditor)this.initNumericCellEditor(rs.getInt("FQtyPrecision")));
            row.getCell(TB_ISQUOTACONTROL).setValue((Object)rs.getBigDecimal("FIsQuotaControl"));
            row.getCell(TB_UPPERLIMITQTY).setValue((Object)rs.getBigDecimal("FUpperLimitQty").setScale(rs.getInt("FQtyPrecision"), 4));
            BigDecimal reqqty = rs.getBigDecimal("FReqQty");
            if (reqqty.compareTo(new BigDecimal(0)) >= 0) {
                row.getCell(TB_PICKINGQTY).setValue((Object)reqqty.setScale(rs.getInt("FQtyPrecision"), 4));
            } else {
                row.getCell(TB_PICKINGQTY).setValue((Object)new BigDecimal(0).setScale(rs.getInt("FQtyPrecision"), 4));
            }
            row.getCell(TB_TRACENO).setValue((Object)rs.getString("FTraceNo"));
            row.getCell(TB_TRACKNUMBER).setValue((Object)rs.getString(TB_TRACKNUMBER));
            row.getCell(TB_SALEORDER).setValue((Object)rs.getString("SaleOrderNum"));
            row.getCell(TB_PICKINGDATE).setValue((Object)rs.getString("FPickingDate"));
        }
    }

    private KDTDefaultCellEditor initNumericCellEditor(int precision) {
        KDFormattedTextField numeric_TextField = new KDFormattedTextField();
        numeric_TextField.setDataType(1);
        numeric_TextField.setRemoveingZeroInDispaly(false);
        numeric_TextField.setHorizontalAlignment(4);
        numeric_TextField.setSupportedEmpty(true);
        numeric_TextField.setNegatived(false);
        numeric_TextField.setPrecision(precision);
        KDTDefaultCellEditor kdtEntrys_numeric_CellEditor = new KDTDefaultCellEditor((JTextField)numeric_TextField);
        return kdtEntrys_numeric_CellEditor;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkNumber();
        Vector vec = new Vector();
        for (int i = 0; i < this.kdtTable.getBody().size(); ++i) {
            if (this.kdtTable.getCell(i, TB_PICKINGQTY).getValue() == null || ((BigDecimal)this.kdtTable.getCell(i, TB_PICKINGQTY).getValue()).compareTo(new BigDecimal(0)) <= 0) continue;
            HashMap<String, Object> psb = new HashMap<String, Object>();
            psb.put("ID", this.kdtTable.getCell(i, TB_ID).getValue());
            if (isDividingByNumber) {
                psb.put("entryID", this.kdtTable.getCell(i, TB_ENTRYID).getValue());
            }
            psb.put(TB_PICKINGQTY, this.kdtTable.getCell(i, TB_PICKINGQTY).getValue());
            vec.add(psb);
        }
        String orgID = this.getUIContext().get("orgID").toString();
        ArrayList ids = (ArrayList)this.getUIContext().get("IDList");
        IObjectPK[] pks = new IObjectPK[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            pks[i] = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
        }
        IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
        HashMap otherParam = new HashMap();
        if (ipsb.isNeedPriceMethodChoose(tempTable, vec, true)) {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create("com.kingdee.eas.mm.control.client.SpanStorageOrgPickingMethedChooseUI", this.getUIContext(), null);
            window.show();
            if (Boolean.FALSE == window.getUIObject().getUIContext().get("excute")) {
                return;
            }
            otherParam.put("priceMethod", window.getUIObject().getUIContext().get("priceMethod"));
        } else {
            otherParam.put("priceMethod", null);
        }
        Map result = null;
        result = ipsb.pickingSlip_Gather(tempTable, srcDataTempTable, vec, orgID, pks, otherParam);
        this.getUIContext().put("result", result.get("result"));
        this.getUIContext().put("isAuto", this.ckIsAutoOpenDesc.isSelected());
        ipsb.updateIsAutoOpenDesc(this.ckIsAutoOpenDesc.isSelected());
        this.actionExitCurrent_actionPerformed(e);
    }

    private void checkNumber() {
        String fieldName = "";
        fieldName = TB_PICKINGQTY;
        int colIndex = this.kdtTable.getColumnIndex(TB_PICKINGQTY);
        for (int rowIndex = 0; rowIndex < this.kdtTable.getBody().size(); ++rowIndex) {
            if (!TB_PICKINGQTY.equalsIgnoreCase(fieldName) || ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_ISQUOTACONTROL).getValue()).compareTo(new BigDecimal(1)) != 0 || this.kdtTable.getCell(rowIndex, TB_PICKINGQTY).getValue() == null || ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_PICKINGQTY).getValue()).compareTo(new BigDecimal(0)) <= 0 || ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_PICKINGQTY).getValue()).compareTo((BigDecimal)this.kdtTable.getCell(rowIndex, TB_UPPERLIMITQTY).getValue()) <= 0) continue;
            MsgBox.showInfo((String)(this.getHolderResource("Msg_ExceedUpperLimit", new String[]{this.kdtTable.getCell(rowIndex, TB_MATERIAL).getValue().toString()}) + this.kdtTable.getCell(rowIndex, TB_UPPERLIMITQTY).getValue()));
            this.kdtTable.getEditManager().editCellAt(rowIndex, colIndex);
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
        ipsb.releaseTempTable(srcDataTempTable);
        ipsb.releaseTempTable(tempTable);
        super.actionExitCurrent_actionPerformed(e);
    }

    private String getHolderResource(String key, String[] params) {
        return ResourceUtils.getMessage((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)key, (String[])params);
    }

    private void initData(KDTable kdTable, IRowSet rs, int index) throws Exception {
        int start = 0;
        int end = -1;
        String tempNumber = "";
        while (rs.next()) {
            IRow row = this.initRowCommonInfo(kdTable, rs);
            row.getCell(TB_NUMBER).setValue((Object)rs.getString("fnumber"));
            if ("".equals(tempNumber)) {
                tempNumber = rs.getString("fnumber");
            }
            if (tempNumber.equals(rs.getString("fnumber"))) {
                ++end;
                continue;
            }
            if (start != end) {
                this.kdtTable.getMergeManager().mergeBlock(start, index, end, index);
            }
            end = start = end + 1;
            tempNumber = rs.getString("fnumber");
        }
        if (start != end) {
            this.kdtTable.getMergeManager().mergeBlock(start, index, end, index);
        }
    }

    private IRow initRowCommonInfo(KDTable kdTable, IRowSet rs) throws SQLException {
        IRow row = kdTable.addRow();
        row.getCell(TB_ID).setValue((Object)rs.getString("FID"));
        if (isDividingByNumber) {
            row.getCell(TB_ENTRYID).setValue((Object)rs.getString("FEntryID"));
        }
        row.getCell(TB_MATERIAL).setValue((Object)rs.getString(TB_MATERIAL));
        row.getCell(TB_MATERIALNAME).setValue((Object)rs.getString(TB_MATERIALNAME));
        row.getCell(TB_MODEL).setValue((Object)rs.getString(TB_MODEL));
        row.getCell(TB_UNIT).setValue((Object)rs.getString(TB_UNIT));
        row.getCell(TB_REQQTY).setValue((Object)rs.getBigDecimal("FReqQty").setScale(rs.getInt("FQtyPrecision"), 4));
        row.getCell(TB_LOT).setValue((Object)rs.getString("FLotNo"));
        row.getCell(TB_LOT).setValue((Object)rs.getString("FLotNo"));
        row.getCell(TB_WAREHOUSE).setValue((Object)rs.getString(TB_WAREHOUSE));
        row.getCell(TB_LOCATION).setValue((Object)rs.getString(TB_LOCATION));
        row.getCell(TB_WORKSHOP).setValue((Object)rs.getString(TB_WORKSHOP));
        row.getCell(TB_PRODUCTLINE).setValue((Object)rs.getString(TB_PRODUCTLINE));
        row.getCell(TB_PICKINGQTY).setEditor((ICellEditor)this.initNumericCellEditor(rs.getInt("FQtyPrecision")));
        row.getCell(TB_ISQUOTACONTROL).setValue((Object)rs.getBigDecimal("FIsQuotaControl"));
        row.getCell(TB_UPPERLIMITQTY).setValue((Object)rs.getBigDecimal("FUpperLimitQty").setScale(rs.getInt("FQtyPrecision"), 4));
        BigDecimal reqqty = rs.getBigDecimal("FReqQty");
        if (reqqty.compareTo(new BigDecimal(0)) >= 0) {
            row.getCell(TB_PICKINGQTY).setValue((Object)reqqty.setScale(rs.getInt("FQtyPrecision"), 4));
        } else {
            row.getCell(TB_PICKINGQTY).setValue((Object)new BigDecimal(0).setScale(rs.getInt("FQtyPrecision"), 4));
        }
        row.getCell(TB_TRACENO).setValue((Object)rs.getString("FTraceNo"));
        row.getCell(TB_TRACKNUMBER).setValue((Object)rs.getString(TB_TRACKNUMBER));
        row.getCell(TB_SALEORDER).setValue((Object)rs.getString("SaleOrderNum"));
        row.getCell(TB_PICKINGDATE).setValue((Object)rs.getString("FPickingDate"));
        return row;
    }
}

