/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.mm.control.IPickingSlipBill;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.client.AbstractPickingSlip_SimpleUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PickingSlip_SimpleUI
extends AbstractPickingSlip_SimpleUI {
    private static final Logger logger = CoreUIObject.getLogger(PickingSlip_SimpleUI.class);
    public static final int DEFAULT_PRECISION = 2;
    private static String tempTable;
    private static final String TB_ID = "pickingSlipID";
    private static final String TB_ENTRYID = "pickingSlipEntryID";
    private static final String TB_PSLOTID = "pickingSlipLotID";
    private static final String TB_MATERIAL = "materialNumber";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MODEL = "model";
    private static final String TB_UNIT = "unit";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_LOCATION = "location";
    private static final String TB_LOT = "lot";
    private static final String TB_REQQTY = "reqQty";
    private static final String TB_ISQUOTACONTROL = "isQuotaControl";
    private static final String TB_UPPERLIMITQTY = "upperLimitQty";
    private static final String TB_RETURNABLEQTY = "returnAbleQty";
    private static final String TB_PICKINGQTY = "pickingQty";
    private static final String TB_RETURNINGQTY = "returningQty";
    private static final String TB_SUPPLEMENTQTY = "supplementQty";
    private String mode = "";

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initFields();
        this.loadData();
    }

    private void loadData() {
        String id = (String)this.getUIContext().get("ID");
        String orgID = this.getUIContext().get("orgID").toString();
        FilterInfo productLineWPFilter = (FilterInfo)this.getUIContext().get("wpFilter");
        if (id == null) {
            String s = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_IDIsNull");
            MsgBox.showError((String)s);
            SysUtil.abort();
        }
        try {
            IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
            tempTable = ipsb.createTempPSTable();
            IRowSet rs = ipsb.buildTempTable(id, tempTable, orgID, this.mode, productLineWPFilter);
            this.initData(this.kdtTable, rs);
            int isAuto = ipsb.getIsAutoOpenDesc();
            this.ckIsAutoOpenDesc.setSelected(isAuto == 1);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void initFields() {
        this.mode = this.getUIContext().get("Mode").toString();
        if (this.mode.equals("Picking")) {
            this.kdtTable.getColumn(TB_RETURNABLEQTY).getStyleAttributes().setHided(true);
            this.kdtTable.getColumn(TB_RETURNINGQTY).getStyleAttributes().setHided(true);
            this.kdtTable.getColumn(TB_SUPPLEMENTQTY).getStyleAttributes().setHided(true);
            this.kdtTable.getColumn(TB_LOT).getStyleAttributes().setHided(false);
        } else if (this.mode.equals("Return")) {
            this.kdtTable.getColumn(TB_REQQTY).getStyleAttributes().setHided(true);
            this.kdtTable.getColumn(TB_PICKINGQTY).getStyleAttributes().setHided(true);
            this.kdtTable.getColumn(TB_LOT).getStyleAttributes().setHided(false);
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"ReturnSlip_NotSuite"));
        }
        KDFormattedTextField reqQty_TextField = new KDFormattedTextField();
        reqQty_TextField.setName("kdtEntrys_baseReqQty_TextField");
        reqQty_TextField.setEditable(true);
        reqQty_TextField.setDataType(1);
        reqQty_TextField.setRemoveingZeroInDispaly(false);
        reqQty_TextField.setHorizontalAlignment(4);
        reqQty_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor reqQty_CellEditor = new KDTDefaultCellEditor((JTextField)reqQty_TextField);
        this.kdtTable.getColumn(TB_REQQTY).setEditor((ICellEditor)reqQty_CellEditor);
    }

    private void initData(KDTable kdTable, IRowSet rs) throws Exception {
        while (rs.next()) {
            if (this.mode.equals("Return")) {
                BigDecimal reqqty = rs.getBigDecimal("FReqQty");
                if (reqqty.compareTo(new BigDecimal(0)) <= 0) continue;
                IRow row = kdTable.addRow();
                row.getCell(TB_ID).setValue((Object)rs.getString("FID"));
                row.getCell(TB_ENTRYID).setValue((Object)rs.getString("FEntryID"));
                row.getCell(TB_PSLOTID).setValue((Object)rs.getString("FPSLotID"));
                row.getCell(TB_MATERIAL).setValue((Object)rs.getString("material"));
                row.getCell(TB_MATERIALNAME).setValue((Object)rs.getString(TB_MATERIALNAME));
                row.getCell(TB_MODEL).setValue((Object)rs.getString(TB_MODEL));
                row.getCell(TB_UNIT).setValue((Object)rs.getString(TB_UNIT));
                row.getCell(TB_WAREHOUSE).setValue((Object)rs.getString(TB_WAREHOUSE));
                row.getCell(TB_LOCATION).setValue((Object)rs.getString(TB_LOCATION));
                row.getCell(TB_LOT).setValue((Object)rs.getString("FLotNo"));
                row.getCell(TB_RETURNABLEQTY).setValue((Object)reqqty.setScale(rs.getInt("FQtyPrecision"), 4));
                row.getCell(TB_RETURNINGQTY).setEditor((ICellEditor)this.initNumericCellEditor(rs.getInt("FQtyPrecision")));
                row.getCell(TB_RETURNINGQTY).setValue((Object)new BigDecimal(0).setScale(rs.getInt("FQtyPrecision"), 4));
                row.getCell(TB_SUPPLEMENTQTY).setEditor((ICellEditor)this.initNumericCellEditor(rs.getInt("FQtyPrecision")));
                row.getCell(TB_SUPPLEMENTQTY).setValue((Object)new BigDecimal(0).setScale(rs.getInt("FQtyPrecision"), 4));
                continue;
            }
            if (!this.mode.equals("Picking")) continue;
            IRow row = kdTable.addRow();
            row.getCell(TB_ID).setValue((Object)rs.getString("FID"));
            row.getCell(TB_ENTRYID).setValue((Object)rs.getString("FEntryID"));
            row.getCell(TB_MATERIAL).setValue((Object)rs.getString("material"));
            row.getCell(TB_MATERIALNAME).setValue((Object)rs.getString(TB_MATERIALNAME));
            row.getCell(TB_MODEL).setValue((Object)rs.getString(TB_MODEL));
            row.getCell(TB_UNIT).setValue((Object)rs.getString(TB_UNIT));
            row.getCell(TB_WAREHOUSE).setValue((Object)rs.getString(TB_WAREHOUSE));
            row.getCell(TB_LOCATION).setValue((Object)rs.getString(TB_LOCATION));
            row.getCell(TB_LOT).setValue((Object)rs.getString("FLotNo"));
            BigDecimal reqqty = rs.getBigDecimal("FReqQty");
            row.getCell(TB_ISQUOTACONTROL).setValue((Object)rs.getBigDecimal("FIsQuotaControl"));
            row.getCell(TB_REQQTY).setValue((Object)reqqty.setScale(rs.getInt("FQtyPrecision"), 4));
            row.getCell(TB_UPPERLIMITQTY).setValue((Object)rs.getBigDecimal("FUpperLimitQty").setScale(rs.getInt("FQtyPrecision"), 4));
            row.getCell(TB_PICKINGQTY).setEditor((ICellEditor)this.initNumericCellEditor(rs.getInt("FQtyPrecision")));
            if (reqqty.compareTo(new BigDecimal(0)) >= 0) {
                row.getCell(TB_PICKINGQTY).setValue((Object)reqqty.setScale(rs.getInt("FQtyPrecision"), 4));
                continue;
            }
            row.getCell(TB_PICKINGQTY).setValue((Object)new BigDecimal(0).setScale(rs.getInt("FQtyPrecision"), 4));
        }
    }

    private void checkNumber() {
        int colIndex;
        String fieldName = "";
        if (this.mode.equals("Picking")) {
            fieldName = TB_PICKINGQTY;
            colIndex = this.kdtTable.getColumnIndex(TB_PICKINGQTY);
        } else {
            fieldName = TB_RETURNINGQTY;
            colIndex = this.kdtTable.getColumnIndex(TB_RETURNINGQTY);
        }
        for (int rowIndex = 0; rowIndex < this.kdtTable.getBody().size(); ++rowIndex) {
            if (TB_PICKINGQTY.equalsIgnoreCase(fieldName) && ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_ISQUOTACONTROL).getValue()).compareTo(new BigDecimal(1)) == 0 && this.kdtTable.getCell(rowIndex, TB_PICKINGQTY).getValue() != null && ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_PICKINGQTY).getValue()).compareTo(new BigDecimal(0)) > 0 && ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_PICKINGQTY).getValue()).compareTo((BigDecimal)this.kdtTable.getCell(rowIndex, TB_UPPERLIMITQTY).getValue()) > 0) {
                MsgBox.showInfo((String)(this.getHolderResource("Msg_ExceedUpperLimit", new String[]{this.kdtTable.getCell(rowIndex, TB_MATERIAL).getValue().toString()}) + this.kdtTable.getCell(rowIndex, TB_UPPERLIMITQTY).getValue()));
                this.kdtTable.getEditManager().editCellAt(rowIndex, colIndex);
                SysUtil.abort();
            }
            if (!TB_RETURNINGQTY.equalsIgnoreCase(fieldName) || this.kdtTable.getCell(rowIndex, TB_RETURNINGQTY).getValue() == null || ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_RETURNINGQTY).getValue()).compareTo(new BigDecimal(0)) <= 0 || ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_RETURNINGQTY).getValue()).compareTo((BigDecimal)this.kdtTable.getCell(rowIndex, TB_RETURNABLEQTY).getValue()) <= 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_RtnQtyBiggerReturnAble"));
            this.kdtTable.getEditManager().editCellAt(rowIndex, colIndex);
            SysUtil.abort();
        }
    }

    private KDTDefaultCellEditor initNumericCellEditor(int precision) {
        KDFormattedTextField numeric_TextField = new KDFormattedTextField();
        numeric_TextField.setDataType(1);
        numeric_TextField.setRemoveingZeroInDispaly(false);
        numeric_TextField.setHorizontalAlignment(4);
        numeric_TextField.setSupportedEmpty(true);
        numeric_TextField.setNegatived(false);
        numeric_TextField.setPrecision(precision);
        KDTDefaultCellEditor kdtEntrys_numeric_CellEditor = new KDTDefaultCellEditor((JTextField)numeric_TextField);
        return kdtEntrys_numeric_CellEditor;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkNumber();
        Vector vec = new Vector();
        ArrayList<Object> ids = new ArrayList<Object>();
        for (int i = 0; i < this.kdtTable.getBody().size(); ++i) {
            HashMap<String, Object> psb;
            if (this.mode.equals("Picking")) {
                if (this.kdtTable.getCell(i, TB_PICKINGQTY).getValue() == null || ((BigDecimal)this.kdtTable.getCell(i, TB_PICKINGQTY).getValue()).compareTo(new BigDecimal(0)) <= 0) continue;
                psb = new HashMap<String, Object>();
                psb.put("ID", this.kdtTable.getCell(i, TB_ID).getValue());
                psb.put("ENTRYID", this.kdtTable.getCell(i, TB_ENTRYID).getValue());
                psb.put("PSLOTID", this.kdtTable.getCell(i, TB_PSLOTID).getValue());
                psb.put(TB_PICKINGQTY, this.kdtTable.getCell(i, TB_PICKINGQTY).getValue());
                vec.add(psb);
                ids.add(this.kdtTable.getCell(i, TB_ID).getValue());
                continue;
            }
            if (!this.mode.equals("Return") || this.kdtTable.getCell(i, TB_RETURNINGQTY).getValue() == null || ((BigDecimal)this.kdtTable.getCell(i, TB_RETURNINGQTY).getValue()).compareTo(new BigDecimal(0)) <= 0) continue;
            psb = new HashMap();
            psb.put("ID", this.kdtTable.getCell(i, TB_ID).getValue());
            psb.put("ENTRYID", this.kdtTable.getCell(i, TB_ENTRYID).getValue());
            psb.put("PSLOTID", this.kdtTable.getCell(i, TB_PSLOTID).getValue());
            psb.put(TB_PICKINGQTY, this.kdtTable.getCell(i, TB_RETURNINGQTY).getValue());
            BigDecimal supplementQty = new BigDecimal(0);
            if (this.kdtTable.getCell(i, TB_SUPPLEMENTQTY).getValue() != null) {
                supplementQty = (BigDecimal)this.kdtTable.getCell(i, TB_SUPPLEMENTQTY).getValue();
            }
            psb.put(TB_SUPPLEMENTQTY, supplementQty);
            vec.add(psb);
            ids.add(this.kdtTable.getCell(i, TB_ID).getValue());
        }
        IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
        String orgID = this.getUIContext().get("orgID").toString();
        if (vec.size() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
            HashMap otherParam = new HashMap();
            otherParam.put("productId", this.getUIContext().get("productId"));
            otherParam.put("parentLot", this.getUIContext().get("parentLot"));
            otherParam.put("productLine", this.getUIContext().get("productLine"));
            Map result = null;
            if (this.mode.equals("Picking")) {
                if (ipsb.isNeedPriceMethodChoose(tempTable, vec, false)) {
                    IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                    IUIWindow window = uiFactory.create("com.kingdee.eas.mm.control.client.SpanStorageOrgPickingMethedChooseUI", this.getUIContext(), null);
                    window.show();
                    if (Boolean.FALSE == window.getUIObject().getUIContext().get("excute")) {
                        return;
                    }
                    otherParam.put("priceMethod", window.getUIObject().getUIContext().get("priceMethod"));
                } else {
                    otherParam.put("priceMethod", null);
                }
                result = ipsb.pickingSlip_Simple(tempTable, vec, orgID, (IObjectPK)pk, otherParam);
            } else if (this.mode.equals("Return")) {
                result = ipsb.returnSlip_Simple(tempTable, vec, orgID, (IObjectPK)pk, otherParam);
            }
            this.getUIContext().put("result", result.get("result"));
            this.getUIContext().put("isAuto", this.ckIsAutoOpenDesc.isSelected());
            ipsb.updateIsAutoOpenDesc(this.ckIsAutoOpenDesc.isSelected());
            this.actionExitCurrent_actionPerformed(e);
        } else if (this.mode.equals("Picking")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_AtLeastOnePSQty"));
            SysUtil.abort();
        } else if (this.mode.equals("Return")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_AtLeastOneRSQty"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        IPickingSlipBill ipsb = PickingSlipBillFactory.getRemoteInstance();
        ipsb.releaseTempTable(tempTable);
        super.actionExitCurrent_actionPerformed(e);
    }

    private String getHolderResource(String key, String[] params) {
        return ResourceUtils.getMessage((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)key, (String[])params);
    }
}

