/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.control.client.AbstractPickingSlip_SuiteUI;
import com.kingdee.eas.mm.control.client.pickMode.AbstractPickingSlipMode;
import com.kingdee.eas.mm.control.client.pickMode.PickingSlipSuiteMode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PickingSlip_SuiteUI
extends AbstractPickingSlip_SuiteUI {
    private static final Logger logger = CoreUIObject.getLogger(PickingSlip_SuiteUI.class);
    private static final String TB_PICKINGSLIP = "pickingSlip";
    private static final String TB_PRODUCTIONORDER = "productionOrder";
    private static final String TB_PRODUCTLINE = "productLine";
    private static final String TB_TASKDISP = "taskDisp";
    private static final String TB_STARTDATE = "startDate";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MATERIALMODEL = "model";
    private static final String TB_UNIT = "unit";
    private static final String TB_WORKSHOP = "workWhop";
    private static final String TB_PICKINGABLESUITE = "pickingAbleSuite";
    private static final String TB_PICKINGSUITE = "pickingSuite";
    private static final int DEFAULT_PRICISION = 2;
    AbstractPickingSlipMode pickingSlipMode = null;

    public void onShow() throws Exception {
        super.onShow();
        this.actionDividingGroup.setEnabled(true);
        if (this.pickingSlipMode == null) {
            this.pickingSlipMode = (PickingSlipSuiteMode)this.getUIContext().get("pickingSlipMode");
        }
        this.initData(this.kdtTable);
        this.initAutoOpenDesc();
        this.kdtTable.getSelectManager().select(0, 5);
        this.kdtTable.getColumn(TB_STARTDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.removeLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    public void actionDividingGroup_actionPerformed(ActionEvent e) throws Exception {
        this.pickingSlipMode.dividingGroup(this);
    }

    private void initData(KDTable kdTable) throws Exception {
        int precision = 2;
        IRowSet rs = this.pickingSlipMode.getData();
        while (rs.next()) {
            IRow row = kdTable.addRow();
            precision = rs.getInt("pis");
            row.getCell("ID").setValue((Object)rs.getString("FID"));
            row.getCell(TB_STARTDATE).setValue((Object)rs.getDate("fstartdate"));
            row.getCell(TB_PICKINGSLIP).setValue((Object)rs.getString("pickNum"));
            row.getCell(TB_PRODUCTIONORDER).setValue((Object)rs.getString("orderNum"));
            row.getCell(TB_PRODUCTLINE).setValue((Object)rs.getString("pName"));
            row.getCell(TB_TASKDISP).setValue((Object)rs.getString("taskNum"));
            row.getCell(TB_MATERIAL).setValue((Object)rs.getString("mNumber"));
            row.getCell(TB_MATERIALNAME).setValue((Object)rs.getString("mName"));
            row.getCell(TB_MATERIALMODEL).setValue((Object)rs.getString(TB_MATERIALMODEL));
            row.getCell(TB_UNIT).setValue((Object)rs.getString("uName"));
            row.getCell(TB_WORKSHOP).setValue((Object)rs.getString("wName"));
            BigDecimal pickingAbleSuite = rs.getBigDecimal("suite");
            row.getCell(TB_PICKINGABLESUITE).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
            if (pickingAbleSuite.compareTo(new BigDecimal(0)) >= 0) {
                row.getCell(TB_PICKINGABLESUITE).setValue((Object)pickingAbleSuite.setScale(precision, 4));
            } else {
                row.getCell(TB_PICKINGABLESUITE).setValue((Object)new BigDecimal(0).setScale(precision, 4));
            }
            row.getCell(TB_PICKINGSUITE).setEditor((ICellEditor)this.initNumericCellEditor(precision));
            row.getCell(TB_PICKINGSUITE).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
            row.getCell(TB_PICKINGSUITE).setValue((Object)new BigDecimal(0).setScale(precision, 4));
        }
    }

    private void initAutoOpenDesc() throws EASBizException, BOSException {
        int isAuto = this.pickingSlipMode.getAutoOpenDesc();
        this.ckIsAutoOpenDesc.setSelected(isAuto == 1);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtTable == null) {
            return;
        }
        if (this.kdtTable.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            int i;
            int size = this.kdtTable.getSelectManager().size();
            KDTSelectBlock selectBlock = null;
            KDTSelectBlock tempBlock = null;
            IRow iRow = null;
            Vector<KDTSelectBlock> vtemp = new Vector<KDTSelectBlock>(0);
            for (i = 0; i < size; ++i) {
                selectBlock = this.kdtTable.getSelectManager().get(i);
                boolean find = false;
                for (int j = 0; j < vtemp.size(); ++j) {
                    tempBlock = (KDTSelectBlock)vtemp.get(j);
                    if (selectBlock.getTop() > tempBlock.getTop()) continue;
                    vtemp.add(j, selectBlock);
                    find = true;
                    break;
                }
                if (find) continue;
                vtemp.add(selectBlock);
            }
            for (i = size - 1; i >= 0; --i) {
                selectBlock = (KDTSelectBlock)vtemp.get(i);
                for (int j = selectBlock.getBottom(); j >= selectBlock.getTop(); --j) {
                    iRow = this.kdtTable.getRow(j);
                    if (iRow == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                        return;
                    }
                    this.kdtTable.removeRow(j);
                }
            }
        }
    }

    private KDTDefaultCellEditor initNumericCellEditor(int precision) {
        KDFormattedTextField numeric_TextField = new KDFormattedTextField();
        numeric_TextField.setDataType(1);
        numeric_TextField.setRemoveingZeroInDispaly(false);
        numeric_TextField.setHorizontalAlignment(4);
        numeric_TextField.setSupportedEmpty(true);
        numeric_TextField.setNegatived(false);
        numeric_TextField.setPrecision(precision);
        KDTDefaultCellEditor kdtEntrys_numeric_CellEditor = new KDTDefaultCellEditor((JTextField)numeric_TextField);
        return kdtEntrys_numeric_CellEditor;
    }

    private String getNumberFormat(int precision) {
        StringBuffer result = new StringBuffer();
        result.append("%{0");
        if (precision > 0) {
            result.append(".");
        }
        for (int i = 0; i < precision; ++i) {
            result.append("0");
        }
        result.append("}f");
        return result.toString();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Vector vec = new Vector();
        for (int i = 0; i < this.kdtTable.getBody().size(); ++i) {
            if (this.kdtTable.getCell(i, TB_PICKINGSUITE).getValue() == null || ((BigDecimal)this.kdtTable.getCell(i, TB_PICKINGSUITE).getValue()).compareTo(new BigDecimal(0)) <= 0) continue;
            HashMap<String, Object> psb = new HashMap<String, Object>();
            psb.put("ID", this.kdtTable.getCell(i, "ID").getValue());
            psb.put(TB_PICKINGSUITE, this.kdtTable.getCell(i, TB_PICKINGSUITE).getValue());
            vec.add(psb);
        }
        if (vec.size() > 0) {
            this.pickingSlipMode.createTempTable();
            this.pickingSlipMode.setPickingSlipVec(vec);
            this.pickingSlipMode.initData();
            if (this.pickingSlipMode.initDealPriceMethod()) {
                List keyList = this.pickingSlipMode.determine();
                this.pickingSlipMode.setKeyList(keyList);
                this.pickingSlipMode.setAuto(this.ckIsAutoOpenDesc.isSelected());
                this.pickingSlipMode.updateAutoOpenDesc(this.ckIsAutoOpenDesc.isSelected());
                this.actionExitCurrent_actionPerformed(e);
            } else {
                this.pickingSlipMode.releaseTempTable();
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_AtLeastOnePSSuite"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("productionOrder.id"));
        sic.add(new SelectorItemInfo("productionOrder.number"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("taskDisp.number"));
        sic.add(new SelectorItemInfo("taskDisp.model"));
        return sic;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }
}

