/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.control.client.AbstractPickingSlip_UnSuiteUI;
import com.kingdee.eas.mm.control.client.pickMode.PickingSlipUnSuiteMode;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PickingSlip_UnSuiteUI
extends AbstractPickingSlip_UnSuiteUI {
    private static final Logger logger = CoreUIObject.getLogger(PickingSlip_UnSuiteUI.class);
    public static final int DEFAULT_PRECISION = 2;
    private static String tempTable;
    private static final String TB_ID = "pickingSlipID";
    private static final String TB_ENTRYID = "pickingSlipEntryID";
    private static final String TB_PSLOTID = "pickingSlipLotID";
    private static final String TB_MATERIAL = "materialNumber";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MODEL = "model";
    private static final String TB_UNIT = "unit";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_LOCATION = "location";
    private static final String TB_LOT = "lot";
    private static final String TB_REQQTY = "reqQty";
    private static final String TB_ISQUOTACONTROL = "isQuotaControl";
    private static final String TB_UPPERLIMITQTY = "upperLimitQty";
    private static final String TB_RETURNABLEQTY = "returnAbleQty";
    private static final String TB_PICKINGQTY = "pickingQty";
    private static final String TB_RETURNINGQTY = "returningQty";
    private static final String TB_SUPPLEMENTQTY = "supplementQty";
    private static final String TB_PSNUM = "pickingSlipNum";
    private static final String TB_PRODUCTIONDPT = "pickingDpt";
    private static final String TB_PRODUCTLINE = "productLine";
    private static final String TB_PROCESS = "process";
    private static final String TB_REQDATE = "reqDate";
    private static final String TB_PRODUCTORDERNUM = "productOrderNumber";
    private static final String TB_TASKDISPNUM = "taskDispNumber";
    private static final String TB_WHMAN = "whMan";
    private static final String TB_ISSUEDTOTALQTY = "issuedTotalQty";
    private static final String TB_RETURNEDTOTALQTY = "returnedTotalQty";
    private static final String TB_PICKEDTOTALQTY = "pickedTotalQty";
    private static final String TB_COSTCENTER = "costingCenter";
    private static final String TB_COSTOBJECT = "costingObject";
    private String mode = "";
    private static final String PICKINGSLIPNUM = "PickingSlipNum";
    private static final String WORKSHOP = "workshop";
    private static final String PRODUCTLINE = "ProductLine";
    private static final String PROCESSNAME = "ProcessName";
    private static final String MATERIALNAME = "MaterialName";
    private static final String WAREHOUSE = "Warehouse";
    private ItemListener FilterDataChangeListener = null;
    PickingSlipUnSuiteMode pickingSlipMode;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.loadData();
        this.initFields();
        this.initAutoOpenDesc();
        this.kdtTable.getSelectManager().select(0, 4);
        this.kdtTable.getColumn(TB_REQDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    private void initAutoOpenDesc() throws EASBizException, BOSException {
        int isAuto = this.pickingSlipMode.getAutoOpenDesc();
        this.ckIsAutoOpenDesc.setSelected(isAuto == 1);
    }

    private void loadData() {
        this.pickingSlipMode = (PickingSlipUnSuiteMode)this.getUIContext().get("pickingSlipMode");
        if (this.pickingSlipMode == null) {
            String s = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_IDIsNull");
            MsgBox.showError((String)s);
            SysUtil.abort();
        }
        try {
            this.pickingSlipMode.createTempTable();
            this.pickingSlipMode.initData();
            IRowSet rs = this.pickingSlipMode.getData();
            this.initData(this.kdtTable, rs);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initListener() {
        super.initListener();
        this.FilterDataChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PickingSlip_UnSuiteUI.this.FilterData_dataChanged(e);
                }
                catch (Exception exc) {
                    PickingSlip_UnSuiteUI.this.handUIException(exc);
                }
            }
        };
        this.cmbPickingSlipNum.addItemListener(this.FilterDataChangeListener);
        this.cmbworkshop.addItemListener(this.FilterDataChangeListener);
        this.cmbProductLine.addItemListener(this.FilterDataChangeListener);
        this.cmbProcessName.addItemListener(this.FilterDataChangeListener);
        this.cmbMaterialName.addItemListener(this.FilterDataChangeListener);
        this.cmbWarehouse.addItemListener(this.FilterDataChangeListener);
    }

    public void initFields() {
        this.initFilterCombo();
        this.kdtTable.getColumn(TB_RETURNABLEQTY).getStyleAttributes().setHided(true);
        this.kdtTable.getColumn(TB_RETURNINGQTY).getStyleAttributes().setHided(true);
        this.kdtTable.getColumn(TB_SUPPLEMENTQTY).getStyleAttributes().setHided(true);
        this.kdtTable.getColumn(TB_LOT).getStyleAttributes().setHided(false);
        KDFormattedTextField reqQty_TextField = new KDFormattedTextField();
        reqQty_TextField.setName("kdtEntrys_baseReqQty_TextField");
        reqQty_TextField.setEditable(true);
        reqQty_TextField.setDataType(1);
        reqQty_TextField.setRemoveingZeroInDispaly(false);
        reqQty_TextField.setHorizontalAlignment(4);
        reqQty_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor reqQty_CellEditor = new KDTDefaultCellEditor((JTextField)reqQty_TextField);
        this.kdtTable.getColumn(TB_REQQTY).setEditor((ICellEditor)reqQty_CellEditor);
    }

    private void initFilterCombo() {
        try {
            Map filterItems = this.pickingSlipMode.getFilterItems(this.getMainOrgContext());
            this.cmbPickingSlipNum.removeItemListener(this.FilterDataChangeListener);
            this.cmbworkshop.removeItemListener(this.FilterDataChangeListener);
            this.cmbProductLine.removeItemListener(this.FilterDataChangeListener);
            this.cmbProcessName.removeItemListener(this.FilterDataChangeListener);
            this.cmbMaterialName.removeItemListener(this.FilterDataChangeListener);
            this.cmbWarehouse.removeItemListener(this.FilterDataChangeListener);
            this.cmbPickingSlipNum.addItems((Vector)filterItems.get("PSNumFilterItem"));
            this.cmbworkshop.addItems((Vector)filterItems.get("productDptFilterItem"));
            this.cmbProductLine.addItems((Vector)filterItems.get("productLineFilterItem"));
            this.cmbProcessName.addItems((Vector)filterItems.get("processFilterItem"));
            this.cmbMaterialName.addItems((Vector)filterItems.get("materialFilterItem"));
            this.cmbWarehouse.addItems((Vector)filterItems.get("warehouseFilterItem"));
            this.cmbPickingSlipNum.addItemListener(this.FilterDataChangeListener);
            this.cmbworkshop.addItemListener(this.FilterDataChangeListener);
            this.cmbProductLine.addItemListener(this.FilterDataChangeListener);
            this.cmbProcessName.addItemListener(this.FilterDataChangeListener);
            this.cmbMaterialName.addItemListener(this.FilterDataChangeListener);
            this.cmbWarehouse.addItemListener(this.FilterDataChangeListener);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initData(KDTable kdTable, IRowSet rs) throws Exception {
        kdTable.removeRows();
        kdTable.getColumn(TB_ISSUEDTOTALQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        kdTable.getColumn(TB_RETURNEDTOTALQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        kdTable.getColumn(TB_PICKEDTOTALQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        kdTable.getColumn(TB_PICKINGQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        kdTable.getColumn(TB_REQQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        while (rs.next()) {
            IRow row = kdTable.addRow();
            row.getCell(TB_ID).setValue((Object)rs.getString("FID"));
            row.getCell(TB_ENTRYID).setValue((Object)rs.getString("FEntryID"));
            row.getCell(TB_MATERIAL).setValue((Object)rs.getString("material"));
            row.getCell(TB_MATERIALNAME).setValue((Object)rs.getString(TB_MATERIALNAME));
            row.getCell(TB_MODEL).setValue((Object)rs.getString(TB_MODEL));
            row.getCell(TB_UNIT).setValue((Object)rs.getString(TB_UNIT));
            row.getCell(TB_WAREHOUSE).setValue((Object)rs.getString(TB_WAREHOUSE));
            row.getCell(TB_LOCATION).setValue((Object)rs.getString(TB_LOCATION));
            row.getCell(TB_LOT).setValue((Object)rs.getString("FLotNo"));
            BigDecimal reqqty = rs.getBigDecimal("FReqQty");
            if (reqqty.compareTo(new BigDecimal(0)) >= 0) {
                row.getCell(TB_REQQTY).setValue((Object)reqqty.setScale(rs.getInt("FQtyPrecision"), 4));
            } else {
                row.getCell(TB_REQQTY).setValue((Object)new BigDecimal(0).setScale(rs.getInt("FQtyPrecision"), 4));
            }
            row.getCell(TB_ISQUOTACONTROL).setValue((Object)rs.getBigDecimal("FIsQuotaControl"));
            row.getCell(TB_UPPERLIMITQTY).setValue((Object)rs.getBigDecimal("FUpperLimitQty").setScale(rs.getInt("FQtyPrecision"), 4));
            row.getCell(TB_PICKINGQTY).setEditor((ICellEditor)this.initNumericCellEditor(rs.getInt("FQtyPrecision")));
            row.getCell(TB_PSNUM).setValue((Object)rs.getString(TB_PSNUM));
            row.getCell(TB_PRODUCTIONDPT).setValue((Object)rs.getString(WORKSHOP));
            row.getCell(TB_PRODUCTLINE).setValue((Object)rs.getString("productline"));
            row.getCell(TB_PROCESS).setValue((Object)rs.getString("processName"));
            row.getCell(TB_REQDATE).setValue((Object)rs.getString(TB_REQDATE));
            row.getCell(TB_PRODUCTORDERNUM).setValue((Object)rs.getString(TB_PRODUCTORDERNUM));
            row.getCell(TB_TASKDISPNUM).setValue((Object)rs.getString("TaskDispNumber"));
            row.getCell(TB_WHMAN).setValue((Object)rs.getString(TB_WHMAN));
            row.getCell(TB_ISSUEDTOTALQTY).setValue((Object)rs.getString(TB_ISSUEDTOTALQTY));
            row.getCell(TB_RETURNEDTOTALQTY).setValue((Object)rs.getString(TB_RETURNEDTOTALQTY));
            row.getCell(TB_PICKEDTOTALQTY).setValue((Object)rs.getString(TB_PICKEDTOTALQTY));
            row.getCell(TB_COSTCENTER).setValue((Object)rs.getString("costCenter"));
            row.getCell(TB_COSTOBJECT).setValue((Object)rs.getString("costObject"));
            if (reqqty.compareTo(new BigDecimal(0)) >= 0) {
                row.getCell(TB_PICKINGQTY).setValue((Object)reqqty.setScale(rs.getInt("FQtyPrecision"), 4));
                continue;
            }
            row.getCell(TB_PICKINGQTY).setValue((Object)new BigDecimal(0).setScale(rs.getInt("FQtyPrecision"), 4));
        }
    }

    private void checkNumber() {
        int colIndex;
        String fieldName = "";
        if (this.mode.equals("Picking")) {
            fieldName = TB_PICKINGQTY;
            colIndex = this.kdtTable.getColumnIndex(TB_PICKINGQTY);
        } else {
            fieldName = TB_RETURNINGQTY;
            colIndex = this.kdtTable.getColumnIndex(TB_RETURNINGQTY);
        }
        for (int rowIndex = 0; rowIndex < this.kdtTable.getBody().size(); ++rowIndex) {
            if (TB_PICKINGQTY.equalsIgnoreCase(fieldName) && ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_ISQUOTACONTROL).getValue()).compareTo(new BigDecimal(1)) == 0 && this.kdtTable.getCell(rowIndex, TB_PICKINGQTY).getValue() != null && ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_PICKINGQTY).getValue()).compareTo(new BigDecimal(0)) > 0 && ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_PICKINGQTY).getValue()).compareTo((BigDecimal)this.kdtTable.getCell(rowIndex, TB_UPPERLIMITQTY).getValue()) > 0) {
                MsgBox.showInfo((String)(this.getHolderResource("Msg_ExceedUpperLimit", new String[]{this.kdtTable.getCell(rowIndex, TB_MATERIAL).getValue().toString()}) + this.kdtTable.getCell(rowIndex, TB_UPPERLIMITQTY).getValue()));
                this.kdtTable.getEditManager().editCellAt(rowIndex, colIndex);
                SysUtil.abort();
            }
            if (!TB_RETURNINGQTY.equalsIgnoreCase(fieldName) || this.kdtTable.getCell(rowIndex, TB_RETURNINGQTY).getValue() == null || ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_RETURNINGQTY).getValue()).compareTo(new BigDecimal(0)) <= 0 || ((BigDecimal)this.kdtTable.getCell(rowIndex, TB_RETURNINGQTY).getValue()).compareTo((BigDecimal)this.kdtTable.getCell(rowIndex, TB_RETURNABLEQTY).getValue()) <= 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_RtnQtyBiggerReturnAble"));
            this.kdtTable.getEditManager().editCellAt(rowIndex, colIndex);
            SysUtil.abort();
        }
    }

    private KDTDefaultCellEditor initNumericCellEditor(int precision) {
        KDFormattedTextField numeric_TextField = new KDFormattedTextField();
        numeric_TextField.setDataType(1);
        numeric_TextField.setRemoveingZeroInDispaly(false);
        numeric_TextField.setHorizontalAlignment(4);
        numeric_TextField.setSupportedEmpty(true);
        numeric_TextField.setNegatived(false);
        numeric_TextField.setPrecision(precision);
        KDTDefaultCellEditor kdtEntrys_numeric_CellEditor = new KDTDefaultCellEditor((JTextField)numeric_TextField);
        return kdtEntrys_numeric_CellEditor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkNumber();
        Vector vec = new Vector();
        String[] ids = new String[this.kdtTable.getBody().size()];
        for (int i = 0; i < this.kdtTable.getBody().size(); ++i) {
            if (this.kdtTable.getCell(i, TB_PICKINGQTY).getValue() == null || ((BigDecimal)this.kdtTable.getCell(i, TB_PICKINGQTY).getValue()).compareTo(new BigDecimal(0)) <= 0) continue;
            HashMap<String, Object> psb = new HashMap<String, Object>();
            psb.put("ID", this.kdtTable.getCell(i, TB_ID).getValue());
            psb.put(TB_PICKINGQTY, this.kdtTable.getCell(i, TB_PICKINGQTY).getValue());
            psb.put("entryId", this.kdtTable.getCell(i, TB_ENTRYID).getValue().toString());
            vec.add(psb);
            ids[i] = this.kdtTable.getCell(i, TB_ENTRYID).getValue().toString();
        }
        if (vec.size() > 0) {
            this.pickingSlipMode.reLoadDataByFilter(ids, vec);
            boolean isCanceled = this.pickingSlipMode.initDealPriceMethod();
            if (!isCanceled) return;
            List keyList = this.pickingSlipMode.determine();
            this.pickingSlipMode.setKeyList(keyList);
            this.pickingSlipMode.setAuto(this.ckIsAutoOpenDesc.isSelected());
            this.pickingSlipMode.updateAutoOpenDesc(this.ckIsAutoOpenDesc.isSelected());
            this.actionExitCurrent_actionPerformed(e);
            return;
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)"Msg_AtLeastOnePSQty"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.pickingSlipMode.releaseTempTable();
        super.actionExitCurrent_actionPerformed(e);
    }

    private String getHolderResource(String key, String[] params) {
        return ResourceUtils.getMessage((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)key, (String[])params);
    }

    private void FilterData_dataChanged(ItemEvent e) throws Exception {
        int anIndex = ((KDComboBox)e.getSource()).getSelectedIndex();
        this.pickingSlipMode.updateFilterInfo(this.getFilterDataKey(e), e.getItem().toString(), anIndex);
        this.initData(this.kdtTable, this.pickingSlipMode.getData());
    }

    @Override
    public void actionDividingGroup_actionPerformed(ActionEvent e) throws Exception {
        this.pickingSlipMode.dividingGroup(this);
    }

    private String getFilterDataKey(ItemEvent e) {
        String key = null;
        if (e.getSource() == this.cmbPickingSlipNum) {
            key = PICKINGSLIPNUM;
        } else if (e.getSource() == this.cmbworkshop) {
            key = WORKSHOP;
        } else if (e.getSource() == this.cmbProductLine) {
            key = PRODUCTLINE;
        } else if (e.getSource() == this.cmbProcessName) {
            key = PROCESSNAME;
        } else if (e.getSource() == this.cmbMaterialName) {
            key = MATERIALNAME;
        } else if (e.getSource() == this.cmbWarehouse) {
            key = WAREHOUSE;
        }
        return key;
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtTable == null) {
            return;
        }
        if (this.kdtTable.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        if (this.confirmRemove()) {
            int i;
            int size = this.kdtTable.getSelectManager().size();
            KDTSelectBlock selectBlock = null;
            KDTSelectBlock tempBlock = null;
            IRow iRow = null;
            Vector<KDTSelectBlock> vtemp = new Vector<KDTSelectBlock>(0);
            for (i = 0; i < size; ++i) {
                selectBlock = this.kdtTable.getSelectManager().get(i);
                boolean find = false;
                for (int j = 0; j < vtemp.size(); ++j) {
                    tempBlock = (KDTSelectBlock)vtemp.get(j);
                    if (selectBlock.getTop() > tempBlock.getTop()) continue;
                    vtemp.add(j, selectBlock);
                    find = true;
                    break;
                }
                if (find) continue;
                vtemp.add(selectBlock);
            }
            for (i = size - 1; i >= 0; --i) {
                selectBlock = (KDTSelectBlock)vtemp.get(i);
                for (int j = selectBlock.getBottom(); j >= selectBlock.getTop(); --j) {
                    iRow = this.kdtTable.getRow(j);
                    if (iRow == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                        return;
                    }
                    this.kdtTable.removeRow(j);
                    ids.add(iRow.getCell(TB_ENTRYID).getValue().toString());
                }
            }
            this.pickingSlipMode.removeLines(ids);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }
}

