/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.planning.PLSEntryFactory;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.SrcTypeEnum;
import java.util.ArrayList;
import java.util.List;

public class PrdLotClientUtils {
    public static void dealLotNo(ProductionOrderInfo orderInfo, KDTextField txtLotNo, boolean isGenerateLot) throws EASBizException, BOSException {
        if (orderInfo.getMaterial() == null || orderInfo.getStorageOrgUnit() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)orderInfo.getMaterial().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orderInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isLotNumber");
        viewer.setSelector(selector);
        MaterialInventoryCollection inv = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(viewer);
        if (inv.size() <= 0) {
            txtLotNo.setEnabled(false);
            return;
        }
        MaterialInventoryInfo invInfo = inv.get(0);
        if (!invInfo.isIsLotNumber()) {
            txtLotNo.setEnabled(false);
            return;
        }
        LotParamValueInfo param = LotFacadeFactory.getRemoteInstance().getLotParamValueByOrg(orderInfo.getStorageOrgUnit().getId().toString());
        boolean isPlanOrderGene = param.isProductionOrderPlan();
        boolean isPrdOrderGene = param.isProductionOrderProduction();
        boolean isDefaultCarried = param.isProductionOrderProsee();
        BillTypeInfo billType = orderInfo.getSourceBillType();
        LotFrame lotFrame = new LotFrame();
        lotFrame.setMainBizOrg(orderInfo.getStorageOrgUnit().getId().toString());
        lotFrame.setMaterial(orderInfo.getMaterial().getId().toString());
        List lotList = new ArrayList<LotFrame>();
        lotList.add(lotFrame);
        lotList = LotRuleFactory.getRemoteInstance().fillLotFramesNoSerial(lotList);
        if (lotList != null && lotList.size() > 0) {
            lotFrame = (LotFrame)lotList.get(0);
        }
        if (billType == null) {
            if (isPlanOrderGene || !isPlanOrderGene && isPrdOrderGene) {
                PrdLotClientUtils.setEnabledProp(orderInfo, txtLotNo, lotFrame);
                if (isGenerateLot) {
                    PrdLotClientUtils.dealLotRule(orderInfo, txtLotNo);
                }
            } else {
                txtLotNo.setRequired(false);
                txtLotNo.setEnabled(false);
            }
            return;
        }
        if (billType.getId().toString().equals("OC9YcwEhEADgAAApfwAAAUY+1VI=")) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("srcType");
            PLSEntryInfo plsEntry = (PLSEntryInfo)PLSEntryFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(orderInfo.getSourceBillEntry()), sic);
            if (plsEntry.getSrcType() == null) {
                plsEntry.setSrcType(SrcTypeEnum.MANUAL);
            }
            if (isPlanOrderGene) {
                if (isPrdOrderGene) {
                    if (isDefaultCarried) {
                        switch (plsEntry.getSrcType().getValue()) {
                            case 20: {
                                txtLotNo.setRequired(true);
                                txtLotNo.setEnabled(true);
                                break;
                            }
                            case 10: 
                            case 30: {
                                PrdLotClientUtils.setEnabledProp(orderInfo, txtLotNo, lotFrame);
                            }
                        }
                    } else {
                        PrdLotClientUtils.setEnabledProp(orderInfo, txtLotNo, lotFrame);
                    }
                } else {
                    switch (plsEntry.getSrcType().getValue()) {
                        case 20: {
                            txtLotNo.setEnabled(false);
                            break;
                        }
                        case 10: 
                        case 30: {
                            PrdLotClientUtils.setEnabledProp(orderInfo, txtLotNo, lotFrame);
                        }
                    }
                }
            } else if (isPrdOrderGene) {
                PrdLotClientUtils.setEnabledProp(orderInfo, txtLotNo, lotFrame);
            } else {
                txtLotNo.setRequired(false);
                txtLotNo.setEnabled(false);
            }
        } else if (billType.getId().toString().equals("9XXvbVGlRtym/0qtqeIXXrhE1B8=")) {
            if (isPlanOrderGene) {
                if (isPrdOrderGene) {
                    if (isDefaultCarried) {
                        txtLotNo.setRequired(true);
                        txtLotNo.setEnabled(true);
                    } else {
                        PrdLotClientUtils.setEnabledProp(orderInfo, txtLotNo, lotFrame);
                    }
                } else {
                    txtLotNo.setEnabled(false);
                }
            } else if (isPrdOrderGene) {
                PrdLotClientUtils.setEnabledProp(orderInfo, txtLotNo, lotFrame);
            } else {
                txtLotNo.setRequired(false);
                txtLotNo.setEnabled(false);
            }
        }
    }

    private static void dealLotRule(ProductionOrderInfo orderInfo, KDTextField txtLotNo) throws EASBizException, BOSException {
        LotFrame lotFrame = LotRuleFactory.getRemoteInstance().getLotFrame(orderInfo.getMaterial().getId().toString(), orderInfo.getStorageOrgUnit().getId().toString());
        if (lotFrame != null && lotFrame.getLotRule() != null) {
            LotFrame lot = new LotFrame();
            lot.setLotRule(lotFrame.getLotRule());
            lot.setSeq(lotFrame.getSeq());
            lot.setSysDate(lotFrame.getSysDate());
            lot.setCurrentSerial(lotFrame.getCurrentSerial());
            lot.setBillNumber(orderInfo.getNumber());
            lot.setMainBizOrg(orderInfo.getStorageOrgUnit().getNumber());
            lot.setMaterial(orderInfo.getMaterial().getNumber());
            lot.setFreeProp1(orderInfo.getProductLine().getNumber());
            lot.setMfg(orderInfo.getEndDate());
            lot.setBizDate(orderInfo.getBizDate());
            long currentSerial = BatchFileFactory.getRemoteInstance().updateLotRuleAssign(orderInfo.getMaterial().getId().toString(), orderInfo.getStorageOrgUnit().getId().toString());
            lot.setCurrentSerial(currentSerial);
            String lotNo = lot.getLotNumber();
            txtLotNo.setText(lotNo);
            txtLotNo.setEnabled(lotFrame.getLotRule().isIsModifiable());
            txtLotNo.setRequired(lotFrame.getLotRule().isIsModifiable());
        } else {
            txtLotNo.setEnabled(true);
            txtLotNo.setRequired(true);
        }
    }

    private static void setEnabledProp(ProductionOrderInfo orderInfo, KDTextField txtLotNo, LotFrame lotFrame) throws EASBizException, BOSException {
        if (lotFrame != null && lotFrame.getLotRule() != null) {
            txtLotNo.setEnabled(lotFrame.getLotRule().isIsModifiable());
            txtLotNo.setRequired(lotFrame.getLotRule().isIsModifiable());
        } else {
            txtLotNo.setEnabled(true);
            txtLotNo.setRequired(true);
        }
    }
}

