/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.QueryTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProductLotNoTraceDataProvider
extends AbstractPrintDataProvider {
    private static final Logger logger = CoreUIObject.getLogger(ProductLotNoTraceDataProvider.class);
    public static final String KEYFILED = "fid";
    private KDTable productTable = null;
    private KDTable materialTable = null;
    private FilterInfo queryInfo;
    private Map materialCatch = null;
    private int[] selRowIndexLst = null;
    private String[] productTblTitle = null;
    private String[] materialTblTitle = null;
    private String RESOURCE = "com.kingdee.eas.mm.control.ProductLotNoResource";

    protected ProductLotNoTraceDataProvider() {
    }

    public ProductLotNoTraceDataProvider(KDTable productTable, KDTable materialTable, FilterInfo queryInfo, Map materialCatch) {
        int i;
        this.setProductTable(productTable);
        this.setMaterialTable(materialTable);
        this.setQueryInfo(queryInfo);
        this.setMaterialCatch(materialCatch);
        if (productTable != null) {
            this.setSelRowIndexLst(KDTableUtil.getSelectedRows((KDTable)productTable));
        }
        if (productTable != null) {
            this.productTblTitle = new String[productTable.getColumnCount()];
            for (i = 0; i < productTable.getColumnCount(); ++i) {
                this.productTblTitle[i] = productTable.getColumn(i).getKey();
            }
        }
        if (materialTable != null) {
            this.materialTblTitle = new String[materialTable.getColumnCount()];
            for (i = 0; i < materialTable.getColumnCount(); ++i) {
                this.materialTblTitle[i] = materialTable.getColumn(i).getKey();
            }
        }
    }

    public KDTable getProductTable() {
        return this.productTable;
    }

    public void setProductTable(KDTable productTable) {
        this.productTable = productTable;
    }

    public KDTable getMaterialTable() {
        return this.materialTable;
    }

    public void setMaterialTable(KDTable materialTable) {
        this.materialTable = materialTable;
    }

    public FilterInfo getQueryInfo() {
        return this.queryInfo;
    }

    public void setQueryInfo(FilterInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public Map getMaterialCatch() {
        return this.materialCatch;
    }

    public void setMaterialCatch(Map materialCatch) {
        this.materialCatch = materialCatch;
    }

    public int[] getSelRowIndexLst() {
        return this.selRowIndexLst;
    }

    public void setSelRowIndexLst(int[] selRowIndexLst) {
        this.selRowIndexLst = selRowIndexLst;
    }

    public String[] getMaterialTblTitle() {
        return this.materialTblTitle;
    }

    public void setMaterialTblTitle(String[] materialTblTitle) {
        this.materialTblTitle = materialTblTitle;
    }

    public String[] getProductTblTitle() {
        return this.productTblTitle;
    }

    public void setProductTblTitle(String[] productTblTitle) {
        this.productTblTitle = productTblTitle;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet rowSet = null;
        if ("ProductLotTraceQuery.bos-query".equals(dataSource.getId())) {
            rowSet = this.constructPrintData();
        }
        return rowSet;
    }

    public Map getMaterialOfProductData() throws Exception {
        HashMap retVal;
        block9: {
            retVal = new HashMap();
            if (this.getSelRowIndexLst() != null && this.getSelRowIndexLst().length > 0) {
                ArrayList<String> queryIdLst = new ArrayList<String>();
                for (int i = 0; i < this.getSelRowIndexLst().length; ++i) {
                    String prdId = this.getProductTable().getCellDisplayText(this.getProductTable().getCell(this.getSelRowIndexLst()[i], KEYFILED));
                    if (StringUtils.isEmpty((String)prdId)) continue;
                    if (this.isExistCatch(prdId)) {
                        retVal.put(prdId, this.getMaterialCatch().get(prdId));
                        continue;
                    }
                    queryIdLst.add(prdId);
                }
                if (!queryIdLst.isEmpty()) {
                    FilterInfo info = new FilterInfo();
                    info.getFilterItems().add(this.getQueryInfo().getFilterItems().get(0));
                    QueryTypeEnum queryTypeEnum = null;
                    for (int i = 0; i < this.getQueryInfo().getFilterItems().size(); ++i) {
                        FilterItemInfo filterItemInfo = this.getQueryInfo().getFilterItems().get(i);
                        if (!filterItemInfo.getPropertyName().equals("queryType") || (queryTypeEnum = (QueryTypeEnum)filterItemInfo.getCompareValue()).getValue() != QueryTypeEnum.multiTier.getValue()) continue;
                        queryTypeEnum = QueryTypeEnum.multiTier;
                    }
                    info.getFilterItems().add(new FilterItemInfo("queryType", queryTypeEnum, CompareType.EQUALS));
                    try {
                        Map result = BatchFileFactory.getRemoteInstance().getMaterialByProductBatch(queryIdLst, info);
                        if (result != null && result.size() > 0) {
                            retVal.putAll(result);
                        }
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof EASBizException)) break block9;
                        EASBizException emp = (EASBizException)((Object)ex);
                        if ("TOODEEPLEVER".equals(emp.getSubCode())) {
                            String[] errArr = emp.getMessage().split(";");
                            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}:{1}");
                            String materialErrMsg = format.format(new Object[]{EASResource.getString((String)this.RESOURCE, (String)"materialLotNo"), errArr[0]});
                            String lotErrMsg = format.format(new Object[]{EASResource.getString((String)this.RESOURCE, (String)"lotNoTrace"), errArr[1]});
                            String pleaserestMsg = EASResource.getString((String)this.RESOURCE, (String)"pleasereset");
                            MessageFormat format1 = BOSLocaleUtil.getMessageFormat((String)"{0} {1} {2} {3}");
                            String msg = format1.format(new Object[]{EASResource.getString((String)this.RESOURCE, (String)emp.getSubCode()), materialErrMsg, lotErrMsg, pleaserestMsg});
                            throw new EASBizException(new NumericExceptionSubItem("220000", msg), (Throwable)ex);
                        }
                        throw ex;
                    }
                }
            }
        }
        return retVal;
    }

    private IRowSet constructPrintData() throws Exception {
        DynamicRowSet dynamicRowSet = null;
        if (this.getProductTable() != null && this.getMaterialTable() != null) {
            dynamicRowSet = new DynamicRowSet(this.getProductTable().getColumnCount() + this.getMaterialTable().getColumnCount());
            if (this.getSelRowIndexLst() != null && this.getSelRowIndexLst().length > 0) {
                Map matMap = this.getMaterialOfProductData();
                for (int i = 0; i < this.getSelRowIndexLst().length; ++i) {
                    String prdId = this.getProductTable().getCellDisplayText(this.getProductTable().getCell(this.getSelRowIndexLst()[i], KEYFILED));
                    if (StringUtils.isEmpty((String)prdId)) continue;
                    IRowSet matRowSet = (IRowSet)matMap.get(prdId);
                    if (matRowSet == null || matRowSet.size() < 1) {
                        this.combineRowSet(this.getSelRowIndexLst()[i], dynamicRowSet, null);
                        continue;
                    }
                    matRowSet.beforeFirst();
                    while (matRowSet.next()) {
                        this.combineRowSet(this.getSelRowIndexLst()[i], dynamicRowSet, matRowSet);
                    }
                }
                if (dynamicRowSet.size() > 0) {
                    dynamicRowSet.beforeFirst();
                }
            }
        }
        return dynamicRowSet;
    }

    private boolean isExistCatch(String prdId) {
        boolean retVal = false;
        if (!StringUtils.isEmpty((String)prdId) && this.getMaterialCatch() != null && this.getMaterialCatch().containsKey(prdId)) {
            retVal = true;
        }
        return retVal;
    }

    private void combineRowSet(int rowIndex, DynamicRowSet dynamicRowSet, IRowSet matRowSet) throws Exception {
        dynamicRowSet.moveToInsertRow();
        for (int h = 0; h < this.getProductTblTitle().length; ++h) {
            dynamicRowSet.setColInfo(h + 1, new ColInfo(this.getProductTblTitle()[h], this.getProductTblTitle()[h], 12, null));
            dynamicRowSet.updateString(this.getProductTblTitle()[h], this.getProductTable().getCellDisplayText(this.getProductTable().getCell(rowIndex, this.getProductTblTitle()[h])));
        }
        int count = this.getProductTblTitle().length + 1;
        for (int m = 0; m < this.getMaterialTblTitle().length; ++m) {
            dynamicRowSet.setColInfo(count + m, new ColInfo("raw." + this.getMaterialTblTitle()[m], "raw." + this.getMaterialTblTitle()[m], 12, null));
            if (matRowSet != null) {
                dynamicRowSet.updateString("raw." + this.getMaterialTblTitle()[m], matRowSet.getString(this.getMaterialTblTitle()[m]));
                continue;
            }
            dynamicRowSet.updateNull("raw." + this.getMaterialTblTitle()[m]);
        }
        dynamicRowSet.insertRow();
    }
}

