/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.control.ProductionOrderTraceFacadeFactory;
import com.kingdee.eas.mm.control.client.ProductionOrderTraceChooseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class ProductionOrderTraceDataProvider
extends AbstractPrintDataProvider {
    private String currentProductionOrderID = null;
    private ProductionOrderTraceChooseInfo chooseInfo;
    private static final String resourceName = "com.kingdee.eas.mm.control.ProductionOrderTraceListResource";
    private static final String[] amounts = new String[]{"fqty", "productQty", "consumeFixQty", "qty", "sendOutTotalQty", "untreadTotalQty", "reqQty", "baseQty", "commitQty", "stockTotalQty", "havedReceiveNumber"};

    public ProductionOrderTraceDataProvider(String currentProductionOrderID, ProductionOrderTraceChooseInfo chooseInfo) {
        this.currentProductionOrderID = currentProductionOrderID;
        this.chooseInfo = chooseInfo;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet rowSet = null;
        if ("ProductionOrderRptMeta.bos-query".equals(dataSource.getId())) {
            rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getProductionOrder(this.currentProductionOrderID);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        if ("TaskDispBillRptMeta.bos-query".equals(dataSource.getId())) {
            rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getDispTaskBillByCondition(this.currentProductionOrderID);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        if ("OrderStockRptMeta.bos-query".equals(dataSource.getId())) {
            rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getProductionOrderStockByCondition(this.currentProductionOrderID);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        if ("PickSlipingRptMeta.bos-query".equals(dataSource.getId())) {
            rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getPickingSlipByCondition(this.currentProductionOrderID);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        if ("ManufactureRecRptMeta.bos-query".equals(dataSource.getId())) {
            rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getManufactureRecByCondition(this.currentProductionOrderID);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        if ("MaterialReqRptMeta.bos-query".equals(dataSource.getId())) {
            rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getMaterialReqByCondition(this.currentProductionOrderID);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        if ("FinishedReportRptMeta.bos-query".equals(dataSource.getId())) {
            rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getFinishedReportByCondition(this.currentProductionOrderID);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        if ("ProductionOrderTraceChooseMeta.bos-query".equals(dataSource.getId())) {
            DynamicRowSet dynamicRowSet = new DynamicRowSet(6);
            String[] column = new String[]{"taskDispBill", "orderStock", "pickingSlip", "materialReq", "finishedRpt", "manufactureRec"};
            for (int i = 0; i < column.length; ++i) {
                ColInfo ciId = new ColInfo(column[i], column[i], -7, null);
                dynamicRowSet.setColInfo(i + 1, ciId);
            }
            dynamicRowSet.moveToInsertRow();
            dynamicRowSet.updateBoolean("taskDispBill", this.chooseInfo.isTaskDispBill());
            dynamicRowSet.updateBoolean("orderStock", this.chooseInfo.isOrderStock());
            dynamicRowSet.updateBoolean("pickingSlip", this.chooseInfo.isPickingSliping());
            dynamicRowSet.updateBoolean("materialReq", this.chooseInfo.isMaterialReq());
            dynamicRowSet.updateBoolean("finishedRpt", this.chooseInfo.isFinishedRpt());
            dynamicRowSet.updateBoolean("manufactureRec", this.chooseInfo.isManufactureRec());
            dynamicRowSet.insertRow();
            dynamicRowSet.beforeFirst();
            return dynamicRowSet;
        }
        return null;
    }

    private IRowSet updateRowSet(IRowSet rowSet) throws BOSException {
        try {
            IRowSetMetaData metaData = rowSet.getRowSetMetaData();
            DynamicRowSet dynamicRowSet = new DynamicRowSet(metaData.getColumnCount());
            String columnKey = null;
            int k = 0;
            while (rowSet.next()) {
                dynamicRowSet.moveToInsertRow();
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    columnKey = metaData.getColumnName(i);
                    dynamicRowSet.setColInfo(i, new ColInfo(columnKey, columnKey, 12, null));
                    dynamicRowSet.updateString(columnKey, this.getRightString(columnKey, rowSet.getString(columnKey)));
                }
                dynamicRowSet.insertRow();
                ++k;
            }
            if (k > 0) {
                dynamicRowSet.beforeFirst();
                return dynamicRowSet;
            }
            return rowSet;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private String getRightString(String key, String value) {
        try {
            DecimalFormat fmt = new DecimalFormat();
            fmt.applyPattern("0.######");
            if ("baseStatus".equalsIgnoreCase(key) || "fbaseStatus".equalsIgnoreCase(key)) {
                return BillBaseStatusEnum.getEnum((int)Integer.parseInt(value)).getAlias();
            }
            if ("isBackFlushed".equalsIgnoreCase(key) || "isBackFlush".equalsIgnoreCase(key)) {
                return Integer.parseInt(value) == 1 ? ProductionOrderTraceDataProvider.getResource("YesBackFlushed") : ProductionOrderTraceDataProvider.getResource("NoBackFlushed");
            }
            if ("consumeType".equalsIgnoreCase(key)) {
                return ConsumeTypeEnum.getEnum((int)Integer.parseInt(value)).getAlias();
            }
            if ("percentent".equalsIgnoreCase(key)) {
                BigDecimal result = new BigDecimal(value);
                value = fmt.format(result);
                return value + "%";
            }
            if ("isPass".equalsIgnoreCase(key)) {
                return Integer.parseInt(value) == 1 ? ProductionOrderTraceDataProvider.getResource("Pass") : ProductionOrderTraceDataProvider.getResource("Fail");
            }
            if ("replaceFlag".equalsIgnoreCase(key)) {
                return Integer.parseInt(value) == 1 ? EASResource.getString((String)resourceName, (String)"replaceFlagY") : EASResource.getString((String)resourceName, (String)"replaceFlagN");
            }
            if ("issMode".equalsIgnoreCase(key)) {
                MaterialIssueModeEnum materialIssueMode = MaterialIssueModeEnum.getEnum((int)Integer.parseInt(value));
                return materialIssueMode.getAlias();
            }
            for (int i = 0; i < amounts.length; ++i) {
                if (!amounts[i].equalsIgnoreCase(key)) continue;
                BigDecimal result = new BigDecimal(value);
                return fmt.format(result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private static String getResource(String strKey) {
        return ResourceManage.getResource((String)resourceName, (String)strKey);
    }
}

