/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.common.client.MMCommonProcessor;
import com.kingdee.eas.mm.control.BizTypeEnum;
import com.kingdee.eas.mm.control.PickingSlipLineStatusEnum;
import com.kingdee.eas.mm.control.ProductionOrderTraceFacadeFactory;
import com.kingdee.eas.mm.control.client.AbstractProductionOrderTraceListUI;
import com.kingdee.eas.mm.control.client.ProductionOrderTraceBillChooseUI;
import com.kingdee.eas.mm.control.client.ProductionOrderTraceChooseInfo;
import com.kingdee.eas.mm.control.client.ProductionOrderTraceDataProvider;
import com.kingdee.eas.mm.control.client.ProductionOrderTraceQueryUI;
import com.kingdee.eas.mm.control.client.TableCellComparator;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ProductionOrderTraceListUI
extends AbstractProductionOrderTraceListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductionOrderTraceListUI.class);
    private static final String resourceName = "com.kingdee.eas.mm.control.ProductionOrderTraceListResource";
    protected ProductionOrderTraceQueryUI traceQueryUI;
    private CommonQueryDialog commonQueryDialog;
    protected IMetaDataPK mainQueryPK;
    private boolean showDialogOnLoad = true;
    private String currentProductionOrderID = null;
    FilterInfo queryInfo = null;
    private boolean mustshowDiaglog = false;
    private int sort = 0;
    private KDTSelectListener kdtableProuductionOrderKDTSelectListener;
    private Component mySelf = this;

    public ProductionOrderTraceListUI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
        this.kdtableDispBill.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ProductionOrderTraceListUI.this.sortForTable(e, ProductionOrderTraceListUI.this.kdtableDispBill);
            }
        });
        this.kdtablePicklingSlip.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ProductionOrderTraceListUI.this.sortForTable(e, ProductionOrderTraceListUI.this.kdtablePicklingSlip);
            }
        });
        this.kdtableProductionOrderStock.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ProductionOrderTraceListUI.this.sortForTable(e, ProductionOrderTraceListUI.this.kdtableProductionOrderStock);
            }
        });
        this.kdtableManufactureRec.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ProductionOrderTraceListUI.this.sortForTable(e, ProductionOrderTraceListUI.this.kdtableManufactureRec);
            }
        });
        this.kdtableFinishedReport.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ProductionOrderTraceListUI.this.sortForTable(e, ProductionOrderTraceListUI.this.kdtableFinishedReport);
            }
        });
        this.kdtableMaterialReq.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ProductionOrderTraceListUI.this.sortForTable(e, ProductionOrderTraceListUI.this.kdtableMaterialReq);
            }
        });
    }

    public void onLoad() {
        try {
            super.onLoad();
            if (this.showDialogOnLoad && !this.showQueryDialog()) {
                SysUtil.abort();
            }
            this.kdtableProuductionOrder.checkParsed();
            this.kdtableProuductionOrder.getColumn("fqty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableProuductionOrder.getColumn("fbizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableProuductionOrder.getColumn("fstartDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableProuductionOrder.getColumn("fendDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableDispBill.checkParsed();
            this.kdtableDispBill.getColumn("productQty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableDispBill.getColumn("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableDispBill.getColumn("startDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableDispBill.getColumn("endDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableProductionOrderStock.checkParsed();
            this.kdtableProductionOrderStock.getColumn("consumeFixQty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableProductionOrderStock.getColumn("qty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableProductionOrderStock.getColumn("sendOutTotalQty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableProductionOrderStock.getColumn("untreadTotalQty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableProductionOrderStock.getColumn("startDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableProductionOrderStock.getColumn("endDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtablePicklingSlip.checkParsed();
            this.kdtablePicklingSlip.getColumn("reqQty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtablePicklingSlip.getColumn("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtablePicklingSlip.getColumn("reqDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtablePicklingSlip.getColumn("pickingDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableMaterialReq.checkParsed();
            this.kdtableMaterialReq.getColumn("baseQty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableMaterialReq.getColumn("qty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableMaterialReq.getColumn("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableMaterialReq.getColumn("mfg").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableMaterialReq.getColumn("exp").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableFinishedReport.checkParsed();
            this.kdtableFinishedReport.getColumn("commitQty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableFinishedReport.getColumn("stockTotalQty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableFinishedReport.getColumn("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableFinishedReport.getColumn("finishDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableManufactureRec.checkParsed();
            this.kdtableManufactureRec.getColumn("qty").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableManufactureRec.getColumn("havedReceiveNumber").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            this.kdtableManufactureRec.getColumn("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableManufactureRec.getColumn("mfg").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            this.kdtableManufactureRec.getColumn("exp").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                EASBizException emp = (EASBizException)((Object)e);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)resourceName, (String)emp.getSubCode()), (String)emp.getMessage(), (int)0);
            } else if (!(e instanceof AbortException)) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)resourceName, (String)"UNKNOWERROR"), (String)e.getMessage(), (int)0);
            }
            SysUtil.abort();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.kdtableProuductionOrder.getSelectManager().setSelectMode(2);
        this.kdtableDispBill.getSelectManager().setSelectMode(10);
        this.kdtablePicklingSlip.getSelectManager().setSelectMode(10);
        this.kdtableProductionOrderStock.getSelectManager().setSelectMode(10);
        this.kdtableFinishedReport.getSelectManager().setSelectMode(10);
        this.kdtableManufactureRec.getSelectManager().setSelectMode(10);
        this.kdtableMaterialReq.getSelectManager().setSelectMode(10);
        this.kdtableProuductionOrder.getStyleAttributes().setLocked(true);
        this.kdtableDispBill.getStyleAttributes().setLocked(true);
        this.kdtablePicklingSlip.getStyleAttributes().setLocked(true);
        this.kdtableProductionOrderStock.getStyleAttributes().setLocked(true);
        this.kdtableFinishedReport.getStyleAttributes().setLocked(true);
        this.kdtableManufactureRec.getStyleAttributes().setLocked(true);
        this.kdtableMaterialReq.getStyleAttributes().setLocked(true);
        this.addListener();
    }

    protected boolean showQueryDialog() throws EASBizException {
        this.initCommonQueryDialog();
        this.traceQueryUI.getUIContext().clear();
        this.traceQueryUI.getUIContext().putAll(this.getUIContext());
        boolean isNeedShowQueryDialog = true;
        if (!this.mustshowDiaglog) {
            try {
                this.commonQueryDialog.init();
                this.commonQueryDialog.getCommonQueryParam().setDirty(false);
                QuerySolutionInfo currSolution = this.commonQueryDialog.getCurrentSolutionInfo();
                FilterInfo filters = null;
                if (null != currSolution && null != currSolution.getEntityViewInfo() && currSolution.isIsUserDefaultSolu()) {
                    EntityViewInfo entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                    filters = entityViewInfo.getFilter();
                    entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                    FilterItemCollection filterItems = entityViewInfo.getFilter().getFilterItems();
                    if (null != filterItems && filterItems.size() > 0) {
                        isNeedShowQueryDialog = false;
                        for (FilterItemInfo filterItemInfo : filterItems) {
                            if (!"storageOrgUnitID".equals(filterItemInfo.getPropertyName()) || filterItemInfo.getCompareValue() != null) continue;
                            isNeedShowQueryDialog = true;
                            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourceName, (String)"InQueryStorageOrgUnitIsNotNull"));
                        }
                    }
                    isNeedShowQueryDialog = false;
                    return this.queryProductionOrder(filters);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        FilterInfo newFilterInfos = null;
        if (this.mustshowDiaglog || isNeedShowQueryDialog) {
            if (this.commonQueryDialog.show()) {
                ProductionOrderTraceQueryUI potq = (ProductionOrderTraceQueryUI)this.commonQueryDialog.getUserPanel(ProductionOrderTraceQueryUI.class.getName());
                newFilterInfos = potq.verify() ? potq.getFilterInfo() : null;
            }
            if (newFilterInfos == null) {
                return false;
            }
            this.queryInfo = newFilterInfos;
            return this.queryProductionOrder(this.queryInfo);
        }
        return false;
    }

    private boolean queryProductionOrder(FilterInfo queryInfo) throws EASBizException {
        IRowSet rowSet = null;
        try {
            FilterInfo commonFilterInfo = null;
            SorterItemCollection sortCollection = null;
            if (this.commonQueryDialog != null) {
                commonFilterInfo = this.commonQueryDialog.getCommonFilterPanel().getInnerFilterInfo();
                sortCollection = this.commonQueryDialog.getCommonSorterPanel().getSorterItems();
            }
            rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getProductionOrderByCondition(queryInfo, commonFilterInfo, sortCollection);
            this.refreshTblByRowSet(this.kdtableProuductionOrder, rowSet);
            this.kdtableDispBill.removeRows();
            this.kdtableFinishedReport.removeRows();
            this.kdtableMaterialReq.removeRows();
            this.kdtableManufactureRec.removeRows();
            this.kdtablePicklingSlip.removeRows();
            this.kdtableProductionOrderStock.removeRows();
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONPRODUCTORDER", e.getMessage()), e.getCause(), null);
        }
        return true;
    }

    private void refreshTblByRowSet(KDTable kdTable, IRowSet rowSet) throws EASBizException {
        if (rowSet == null) {
            return;
        }
        try {
            kdTable.checkParsed();
            kdTable.removeRows();
            int columnCount = kdTable.getColumnCount();
            IRow row = null;
            String columnKey = null;
            while (rowSet.next()) {
                row = kdTable.addRow();
                for (int i = 0; i < columnCount; ++i) {
                    columnKey = kdTable.getColumn(i).getKey();
                    row.getCell(i).setValue((Object)this.getRightString(columnKey, rowSet.getString(columnKey)));
                }
            }
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONREFTABLE", e.getMessage()), e.getCause(), null);
        }
        this.repaint();
    }

    private String getRightString(String key, String value) {
        try {
            if ("fbaseStatus".equals(key) || "baseStatus".equals(key)) {
                return BillBaseStatusEnum.getEnum((int)Integer.parseInt(value)).getAlias();
            }
            if ("isBackFlush".equals(key) || "isBackFlushed".equals(key)) {
                return Integer.parseInt(value) == 1 ? EASResource.getString((String)resourceName, (String)"replaceFlagY") : EASResource.getString((String)resourceName, (String)"replaceFlagN");
            }
            if ("consumeType".equals(key)) {
                return ConsumeTypeEnum.getEnum((int)Integer.parseInt(value)).getAlias();
            }
            if ("percentent".equals(key)) {
                DecimalFormat format = new DecimalFormat("0.00##");
                return format.format(new BigDecimal(value)) + "%";
            }
            if ("isPass".equalsIgnoreCase(key)) {
                return Integer.parseInt(value) == 1 ? EASResource.getString((String)resourceName, (String)"Pass") : EASResource.getString((String)resourceName, (String)"Fail");
            }
            if ("fbussinessType".equalsIgnoreCase(key)) {
                BizTypeEnum bizType = BizTypeEnum.getEnum(Integer.parseInt(value));
                return bizType.getAlias();
            }
            if ("replaceFlag".equals(key)) {
                return Integer.parseInt(value) == 1 ? EASResource.getString((String)resourceName, (String)"replaceFlagY") : EASResource.getString((String)resourceName, (String)"replaceFlagN");
            }
            if ("issMode".equals(key)) {
                MaterialIssueModeEnum materialIssueMode = MaterialIssueModeEnum.getEnum((int)Integer.parseInt(value));
                return materialIssueMode.getAlias();
            }
            if ("provideType".equals(key)) {
                MaterialProvideTypeEnum provideType = MaterialProvideTypeEnum.getEnum((int)Integer.parseInt(value));
                return provideType.getAlias();
            }
            if ("lineStatus".equals(key)) {
                PickingSlipLineStatusEnum lineStatus = PickingSlipLineStatusEnum.getEnum(Integer.parseInt(value));
                return lineStatus.getAlias();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return value;
    }

    protected CommonQueryDialog initCommonQueryDialog() throws EASBizException {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setUiObject((IUIObject)this);
            this.commonQueryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.mm.control.app.ProductionOrderTraceQuery"));
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
            String title = format.format(new Object[]{this.getUITitle(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
            this.commonQueryDialog.setTitle(title);
            this.commonQueryDialog.getCommonqueryPanel();
            this.commonQueryDialog.setProcessor((IProcessor)new MMCommonProcessor(this.createCommonProcessorMap()));
            try {
                this.traceQueryUI = new ProductionOrderTraceQueryUI();
                Dimension size = new Dimension();
                size.width = 580;
                size.height = 345;
                this.traceQueryUI.setSize(size);
                this.commonQueryDialog.addUserPanel((KDPanel)this.traceQueryUI);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONINITDIALOG", e.getMessage()), e.getCause(), null);
            }
        }
        return this.commonQueryDialog;
    }

    @Override
    protected void kdtableProuductionOrder_tableClick(KDTMouseEvent e) {
        this.sortForTable(e, this.kdtableProuductionOrder);
    }

    private void addListener() {
        this.removeListener();
        this.kdtableProuductionOrder.getSelectManager().addKDTSelectListener(this.kdtableProuductionOrderKDTSelectListener);
    }

    private void removeListener() {
        if (null != this.kdtableProuductionOrderKDTSelectListener) {
            this.kdtableProuductionOrder.getSelectManager().removeKDTSelectListener(this.kdtableProuductionOrderKDTSelectListener);
        }
    }

    protected void initListener() {
        super.initListener();
        this.kdtableProuductionOrderKDTSelectListener = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    int selectedIndex = ProductionOrderTraceListUI.this.kdtableProuductionOrder.getSelectManager().getActiveRowIndex();
                    ProductionOrderTraceListUI.this.currentProductionOrderID = (String)ProductionOrderTraceListUI.this.kdtableProuductionOrder.getCell(selectedIndex, "fid").getValue();
                    if ("panelDispTask".equals(ProductionOrderTraceListUI.this.kdtabbedPaneProductionOrder.getSelectedComponent().getName())) {
                        ProductionOrderTraceListUI.this.panelDispTask_componentShow(null);
                    } else if ("panelProductionOrderStock".equals(ProductionOrderTraceListUI.this.kdtabbedPaneProductionOrder.getSelectedComponent().getName())) {
                        ProductionOrderTraceListUI.this.panelProductionOrderStock_componentShow(null);
                    } else if ("panelPickingSlip".equals(ProductionOrderTraceListUI.this.kdtabbedPaneProductionOrder.getSelectedComponent().getName())) {
                        ProductionOrderTraceListUI.this.panelPickingSlip_componentShow(null);
                    } else if ("panelMaterialReq".equals(ProductionOrderTraceListUI.this.kdtabbedPaneProductionOrder.getSelectedComponent().getName())) {
                        ProductionOrderTraceListUI.this.panelMaterialReq_componentShow(null);
                    } else if ("panelFinieshedReport".equals(ProductionOrderTraceListUI.this.kdtabbedPaneProductionOrder.getSelectedComponent().getName())) {
                        ProductionOrderTraceListUI.this.panelFinieshedReport_componentShow(null);
                    } else if ("panelManufactureRec".equals(ProductionOrderTraceListUI.this.kdtabbedPaneProductionOrder.getSelectedComponent().getName())) {
                        ProductionOrderTraceListUI.this.panelManufactureRec_componentShow(null);
                    }
                }
                catch (Exception ee) {
                    if (ee instanceof EASBizException) {
                        EASBizException emp = (EASBizException)((Object)ee);
                        MsgBox.showDetailAndOK((Component)ProductionOrderTraceListUI.this.mySelf, (String)EASResource.getString((String)ProductionOrderTraceListUI.resourceName, (String)emp.getSubCode()), (String)emp.getMessage(), (int)0);
                    } else if (!(ee instanceof AbortException)) {
                        MsgBox.showDetailAndOK((Component)ProductionOrderTraceListUI.this.mySelf, (String)EASResource.getString((String)ProductionOrderTraceListUI.resourceName, (String)"UNKNOWERROR"), (String)ee.getMessage(), (int)0);
                    }
                    SysUtil.abort();
                }
            }
        };
    }

    @Override
    protected void panelDispTask_componentShow(ComponentEvent e) throws EASBizException {
        if (this.currentProductionOrderID != null && this.currentProductionOrderID.length() > 0) {
            try {
                IRowSet rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getDispTaskBillByCondition(this.currentProductionOrderID);
                this.refreshTblByRowSet(this.kdtableDispBill, rowSet);
            }
            catch (BOSException ee) {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONDISPTASK", ee.getMessage()), ee.getCause(), null);
            }
        }
    }

    @Override
    protected void panelProductionOrderStock_componentShow(ComponentEvent e) throws EASBizException {
        if (this.currentProductionOrderID != null && this.currentProductionOrderID.length() > 0) {
            try {
                IRowSet rowSet = ProductionOrderTraceFacadeFactory.getRemoteInstance().getProductionOrderStockByCondition(this.currentProductionOrderID);
                this.refreshTblByRowSet(this.kdtableProductionOrderStock, rowSet);
            }
            catch (BOSException ee) {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONPRODUCTORDERSTOCK", ee.getMessage()), ee.getCause(), null);
            }
        }
    }

    @Override
    protected void panelPickingSlip_componentShow(ComponentEvent e) throws EASBizException {
        if (this.currentProductionOrderID != null && this.currentProductionOrderID.length() > 0) {
            try {
                IRowSet rowset = ProductionOrderTraceFacadeFactory.getRemoteInstance().getPickingSlipByCondition(this.currentProductionOrderID);
                this.refreshTblByRowSet(this.kdtablePicklingSlip, rowset);
            }
            catch (BOSException ee) {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONPICKINGSLIP", ee.getMessage()), ee.getCause(), null);
            }
        }
    }

    @Override
    protected void panelMaterialReq_componentShow(ComponentEvent e) throws EASBizException {
        if (this.currentProductionOrderID != null && this.currentProductionOrderID.length() > 0) {
            try {
                IRowSet rowset = ProductionOrderTraceFacadeFactory.getRemoteInstance().getMaterialReqByCondition(this.currentProductionOrderID);
                this.refreshTblByRowSet(this.kdtableMaterialReq, rowset);
            }
            catch (BOSException ee) {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONPICKINGSLIP", ee.getMessage()), ee.getCause(), null);
            }
        }
    }

    @Override
    protected void panelFinieshedReport_componentShow(ComponentEvent e) throws EASBizException {
        if (this.currentProductionOrderID != null && this.currentProductionOrderID.length() > 0) {
            try {
                IRowSet rowset = ProductionOrderTraceFacadeFactory.getRemoteInstance().getFinishedReportByCondition(this.currentProductionOrderID);
                this.refreshTblByRowSet(this.kdtableFinishedReport, rowset);
            }
            catch (BOSException ee) {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONPICKINGSLIP", ee.getMessage()), ee.getCause(), null);
            }
        }
    }

    @Override
    protected void panelManufactureRec_componentShow(ComponentEvent e) throws EASBizException {
        if (this.currentProductionOrderID != null && this.currentProductionOrderID.length() > 0) {
            try {
                IRowSet rowset = ProductionOrderTraceFacadeFactory.getRemoteInstance().getManufactureRecByCondition(this.currentProductionOrderID);
                this.refreshTblByRowSet(this.kdtableManufactureRec, rowset);
            }
            catch (BOSException ee) {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONPICKINGSLIP", ee.getMessage()), ee.getCause(), null);
            }
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.currentProductionOrderID) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourceName, (String)"SelectPrintData"));
            return;
        }
        String uiClass = ProductionOrderTraceBillChooseUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, this.getUIContext(), null, OprtState.VIEW);
        uiWindow.getUIObject().setUITitle(EASResource.getString((String)resourceName, (String)"outPrintOpt"));
        uiWindow.show();
        ProductionOrderTraceBillChooseUI chooseUI = (ProductionOrderTraceBillChooseUI)uiWindow.getUIObject();
        if (chooseUI.isConfirm()) {
            ProductionOrderTraceDataProvider data = new ProductionOrderTraceDataProvider(this.currentProductionOrderID, chooseUI.getChooseInfo());
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.print("MM/CONTROL/po/PRODUCTIONORDERTRACERPT", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.currentProductionOrderID) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourceName, (String)"SelectPrintPreviewData"));
            return;
        }
        String uiClass = ProductionOrderTraceBillChooseUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, this.getUIContext(), null, OprtState.VIEW);
        uiWindow.getUIObject().setUITitle(EASResource.getString((String)resourceName, (String)"outPrintOpt"));
        uiWindow.show();
        ProductionOrderTraceBillChooseUI chooseUI = (ProductionOrderTraceBillChooseUI)uiWindow.getUIObject();
        if (chooseUI.isConfirm()) {
            ProductionOrderTraceDataProvider data = new ProductionOrderTraceDataProvider(this.currentProductionOrderID, chooseUI.getChooseInfo());
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.printPreview("MM/CONTROL/po/PRODUCTIONORDERTRACERPT", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.mustshowDiaglog = true;
        this.onLoad();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.queryInfo != null) {
            this.queryProductionOrder(this.queryInfo);
        }
    }

    private void sortForTable(KDTMouseEvent e, KDTable kdtable) {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            KDTSortManager sm = new KDTSortManager(kdtable);
            this.sort = this.sort == 0 ? 1 : 0;
            sm.sort(e.getColIndex(), this.sort);
            if (kdtable.getBody().getRows() == null || kdtable.getBody().getRows().size() <= 0) {
                return;
            }
            List rows = kdtable.getBody().getRows();
            Collections.sort(rows, new TableCellComparator(e.getColIndex(), this.sort));
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws BOSException {
        if (null == this.currentProductionOrderID) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourceName, (String)"SelectExpoetData"));
            return;
        }
        String uiClass = ProductionOrderTraceBillChooseUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, this.getUIContext(), null, OprtState.VIEW);
        uiWindow.getUIObject().setUITitle(EASResource.getString((String)resourceName, (String)"ExportOption"));
        uiWindow.show();
        ProductionOrderTraceBillChooseUI chooseUI = (ProductionOrderTraceBillChooseUI)uiWindow.getUIObject();
        if (chooseUI.isConfirm()) {
            ProductionOrderTraceChooseInfo chooseInfo = chooseUI.getChooseInfo();
            File myFile = null;
            try {
                myFile = File.createTempFile("tmp", ".xls");
                int cursor = 0;
                KDSBook book = new KDSBook(this.getUITitle());
                KDSSheet sheet = new KDSSheet(book, this.getUITitle());
                this.panelDispTask_componentShow(null);
                this.panelProductionOrderStock_componentShow(null);
                this.panelPickingSlip_componentShow(null);
                this.panelMaterialReq_componentShow(null);
                this.panelFinieshedReport_componentShow(null);
                this.panelManufactureRec_componentShow(null);
                cursor = this.exportKDSheet(book, sheet, this.kdtableProuductionOrder, this.currentProductionOrderID, cursor);
                if (chooseInfo.isTaskDispBill()) {
                    cursor = this.exportKDSheet(book, sheet, this.kdtableDispBill, cursor);
                }
                if (chooseInfo.isOrderStock()) {
                    cursor = this.exportKDSheet(book, sheet, this.kdtableProductionOrderStock, cursor);
                }
                if (chooseInfo.isPickingSliping()) {
                    cursor = this.exportKDSheet(book, sheet, this.kdtablePicklingSlip, cursor);
                }
                if (chooseInfo.isMaterialReq()) {
                    cursor = this.exportKDSheet(book, sheet, this.kdtableMaterialReq, cursor);
                }
                if (chooseInfo.isFinishedRpt()) {
                    cursor = this.exportKDSheet(book, sheet, this.kdtableFinishedReport, cursor);
                }
                if (chooseInfo.isManufactureRec()) {
                    cursor = this.exportKDSheet(book, sheet, this.kdtableManufactureRec, cursor);
                }
                book.addSheet(null, sheet);
                String tempFileName = myFile.getAbsolutePath();
                ExportManager man = new ExportManager();
                man.exportToExcel(book, tempFileName);
                KDTMenuManager.openFileInExcel((String)tempFileName);
            }
            catch (Exception ee) {
                if (myFile != null) {
                    try {
                        myFile.deleteOnExit();
                    }
                    catch (Exception eee) {
                        throw new BOSException(eee.getMessage());
                    }
                }
                throw new BOSException(ee.getMessage());
            }
        }
    }

    private int exportKDSheet(KDSBook book, KDSSheet sheet, KDTable table, int current) {
        return this.exportKDSheet(book, sheet, table, null, current);
    }

    private int exportKDSheet(KDSBook book, KDSSheet sheet, KDTable table, String currentProductid, int cursor) {
        int i;
        if (table == null) {
            return cursor;
        }
        ShareStyleAttributes ssa = null;
        KDTRow tableRow = table.getHead().getRow(0);
        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{tableRow.getSSA(), table.getHeadSSA()});
        sheet.getRows().setRowHeight(cursor, (float)UnitConverter.px2mm((int)tableRow.getHeight()));
        sheet.setCell(cursor, 0, (Object)EASResource.getString((String)resourceName, (String)table.getName()), null, ssa, null);
        ++cursor;
        int n = i = currentProductid == null ? 0 : 1;
        while (i < tableRow.getCells().size()) {
            sheet.getRows().setRowHeight(cursor, (float)UnitConverter.px2mm((int)tableRow.getHeight()));
            sheet.setCell(cursor, currentProductid == null ? i : i - 1, (Object)((String)tableRow.getCell(i).getValue()), null, ssa, null);
            ++i;
        }
        if (table.getRowCount() <= 0) {
            return cursor + 2;
        }
        IRow row = null;
        for (int i2 = 0; i2 < table.getRowCount(); ++i2) {
            DecimalFormat df;
            BigDecimal b;
            int j;
            row = table.getRow(i2);
            if (currentProductid != null) {
                if (!currentProductid.equals(row.getCell(0).getValue())) continue;
                sheet.getRows().setRowHeight(++cursor, (float)UnitConverter.px2mm((int)row.getHeight()));
                ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{row.getStyleAttributes(), table.getHeadSSA()});
                for (j = 1; j < table.getColumnCount(); ++j) {
                    if (row.getCell(j).getStyleAttributes().getNumberFormat().equals("%{0.########}f")) {
                        b = new BigDecimal(row.getCell(j).getValue().toString());
                        df = new DecimalFormat("0.##########");
                        sheet.setCell(cursor, j - 1, (Object)df.format(b), null, ssa, null);
                        continue;
                    }
                    if (row.getCell(j).getStyleAttributes().getNumberFormat().equals("yyyy-MM-dd")) {
                        String value = row.getCell(j).getValue().toString();
                        if (value == null || value.trim().equals("")) {
                            sheet.setCell(cursor, j - 1, (Object)"", null, ssa, null);
                            continue;
                        }
                        sheet.setCell(cursor, j - 1, (Object)value.substring(0, 10), null, ssa, null);
                        continue;
                    }
                    sheet.setCell(cursor, j - 1, row.getCell(j).getValue(), null, ssa, null);
                }
                break;
            }
            sheet.getRows().setRowHeight(++cursor, (float)UnitConverter.px2mm((int)row.getHeight()));
            ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{row.getStyleAttributes(), table.getHeadSSA()});
            for (j = 0; j < table.getColumnCount(); ++j) {
                if (row.getCell(j).getStyleAttributes().getNumberFormat().equals("%{0.########}f")) {
                    b = new BigDecimal("0.00");
                    if (row.getCell(j).getValue() != null) {
                        b = new BigDecimal(row.getCell(j).getValue().toString());
                    }
                    df = new DecimalFormat("0.##########");
                    sheet.setCell(cursor, j, (Object)df.format(b), null, ssa, null);
                    continue;
                }
                if (row.getCell(j).getStyleAttributes().getNumberFormat().equals("yyyy-MM-dd")) {
                    Object o = row.getCell(j).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    if (value == null || value.trim().equals("")) {
                        sheet.setCell(cursor, j, (Object)"", null, ssa, null);
                        continue;
                    }
                    sheet.setCell(cursor, j, (Object)value.substring(0, 10), null, ssa, null);
                    continue;
                }
                sheet.setCell(cursor, j, row.getCell(j).getValue(), null, ssa, null);
            }
        }
        return cursor += 2;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.panelDispTask.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 985, 270));
        this.panelProductionOrderStock.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 985, 270));
        this.panelPickingSlip.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 985, 270));
        this.panelManufactureRec.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 985, 270));
        this.panelFinieshedReport.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 985, 270));
        this.panelMaterialReq.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 985, 270));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.print);
        this.setButtonDefaultStyl(this.printPreview);
    }

    protected Map createCommonProcessorMap() {
        HashMap treatmentMap = new HashMap();
        ArrayList<BillBaseStatusEnum> status = new ArrayList<BillBaseStatusEnum>();
        status.add(BillBaseStatusEnum.NULL);
        status.add(BillBaseStatusEnum.TEMPORARILYSAVED);
        status.add(BillBaseStatusEnum.ALTERING);
        status.add(BillBaseStatusEnum.SUBMITED);
        status.add(BillBaseStatusEnum.DELETED);
        status.add(BillBaseStatusEnum.AUDITED);
        status.add(BillBaseStatusEnum.RELEASED);
        status.add(BillBaseStatusEnum.BLOCKED);
        status.add(BillBaseStatusEnum.CLOSED);
        status.add(BillBaseStatusEnum.COMPLETE);
        status.add(BillBaseStatusEnum.FINISH);
        treatmentMap.put("baseStatus", status);
        return treatmentMap;
    }
}

