/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.control.BizTypeEnum;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.client.AbstractProductionOrderTraceQueryUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class ProductionOrderTraceQueryUI
extends AbstractProductionOrderTraceQueryUI {
    private static final long serialVersionUID = -7928380049965865444L;
    private static final Logger logger = CoreUIObject.getLogger(ProductionOrderTraceQueryUI.class);
    private static final String permItem_query = "mm_productionordertrace_query";
    private static final String resourceName = "com.kingdee.eas.mm.control.ProductionOrderTraceListResource";
    public String orgName = null;
    public String orgNumber = null;
    public String materialNumber = null;
    public String materialName = null;
    private DataChangeListener datelistener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            ProductionOrderTraceQueryUI.this.initProductionOrderF7();
            ProductionOrderTraceQueryUI.this.startNumber.setText(null);
            ProductionOrderTraceQueryUI.this.endNumber.setText(null);
        }
    };
    private StorageOrgUnitInfo currPermOrg = null;

    protected StorageOrgUnitInfo getCurrPermOrg() {
        if (null == this.currPermOrg) {
            this.currPermOrg = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)permItem_query);
        }
        return this.currPermOrg;
    }

    public ProductionOrderTraceQueryUI() throws Exception {
        this.startQueryDate.addDataChangeListener(this.datelistener);
        this.endQueryDate.addDataChangeListener(this.datelistener);
    }

    public void onLoad() throws Exception {
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.storageUnitPrompt, (OrgType)OrgType.Storage, (String)permItem_query);
        this.storageUnitPrompt.setValue((Object)this.getCurrPermOrg());
        this.startQueryDate.setValue((Object)this.getQueryTime(null, "startDate"));
        this.endQueryDate.setValue((Object)this.getQueryTime(null, "endDate"));
        this.initMaterialF7();
        this.initProductionOrderF7();
    }

    private Timestamp getQueryTime(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        } else {
            calendar.setTime(SCMClientUtils.getServerDate2());
        }
        if (s.equalsIgnoreCase("startDate")) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else if (s.equalsIgnoreCase("endDate")) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 999);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public boolean verify() {
        if (null == this.storageUnitPrompt.getValue()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.control.ProductLotNoResource", (String)"PLC_Msg_StorageOrg_Not_Null"));
            this.storageUnitPrompt.requestFocus();
            return false;
        }
        if (this.startQueryDate.getTimestamp() != null && this.endQueryDate.getTimestamp() != null && this.startQueryDate.getTimestamp().getTime() > this.endQueryDate.getTimestamp().getTime()) {
            MsgBox.showInfo((String)EASResource.getString((String)resourceName, (String)"QUERYSTARTDATEGREATEENDDATE"));
            return false;
        }
        Object start = this.startNumber.getValue();
        Object end = this.endNumber.getValue();
        if (start != null && end != null) {
            ProductionOrderInfo stratOrder = (ProductionOrderInfo)start;
            ProductionOrderInfo endOrder = (ProductionOrderInfo)end;
            if (stratOrder.getNumber().compareTo(endOrder.getNumber()) > 0) {
                MsgBox.showInfo((String)EASResource.getString((String)resourceName, (String)"STARTPRODUCTMUSTGREATEND"));
                return false;
            }
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        BizTypeEnum bussinessType;
        int value;
        Calendar cal;
        LinkedHashSet set;
        StringBuffer names;
        StringBuffer numbers;
        StringBuffer ids;
        FilterInfo filters = new FilterInfo();
        FilterItemCollection itemCollection = filters.getFilterItems();
        if (this.storageUnitPrompt.getValue() != null && this.storageUnitPrompt.getText() != null && this.storageUnitPrompt.getText().length() > 0) {
            ids = new StringBuffer();
            numbers = new StringBuffer();
            names = new StringBuffer();
            if (this.storageUnitPrompt.getValue() instanceof StorageOrgUnitInfo) {
                ids.append(((StorageOrgUnitInfo)this.storageUnitPrompt.getValue()).getId().toString());
                numbers.append(((StorageOrgUnitInfo)this.storageUnitPrompt.getValue()).getNumber());
                itemCollection.add(new FilterItemInfo("storageOrgUnitNumber", (Object)numbers.toString().substring(0, numbers.toString().length() - 1)));
                itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)ids.toString(), CompareType.INCLUDE));
                itemCollection.add(new FilterItemInfo("storageOrgUnitName", (Object)((StorageOrgUnitInfo)this.storageUnitPrompt.getValue()).getName(this.getLocale())));
            } else if (this.storageUnitPrompt.getValue() instanceof LinkedHashSet) {
                set = (LinkedHashSet)this.storageUnitPrompt.getValue();
                for (String id : set) {
                    ids.append(id + ";");
                }
                itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)ids.toString().substring(0, ids.toString().length() - 1), CompareType.INCLUDE));
                itemCollection.add(new FilterItemInfo("storageOrgUnitName", (Object)this.orgName));
                itemCollection.add(new FilterItemInfo("storageOrgUnitNumber", (Object)this.orgNumber));
            } else if (this.storageUnitPrompt.getValue() instanceof Object[]) {
                Object[] storages = (Object[])this.storageUnitPrompt.getValue();
                if (storages.length > 0) {
                    for (int i = 0; i < storages.length; ++i) {
                        ids.append(((StorageOrgUnitInfo)storages[i]).getId() + ";");
                        numbers.append(((StorageOrgUnitInfo)storages[i]).getNumber() + ";");
                        names.append(((StorageOrgUnitInfo)storages[i]).getName(this.getLocale()) + ";");
                    }
                }
                itemCollection.add(new FilterItemInfo("storageOrgUnitNumber", (Object)numbers.toString().substring(0, numbers.toString().length() - 1)));
                itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)ids.toString().substring(0, ids.toString().length() - 1), CompareType.INCLUDE));
                itemCollection.add(new FilterItemInfo("storageOrgUnitName", (Object)names.toString().substring(0, names.toString().length() - 1)));
            }
        }
        if (this.materialPrompt.getValue() != null && this.materialPrompt.getText() != null && this.materialPrompt.getText().length() > 0) {
            ids = new StringBuffer();
            numbers = new StringBuffer();
            names = new StringBuffer();
            if (this.materialPrompt.getValue() instanceof MaterialInfo) {
                ids.append(((MaterialInfo)this.materialPrompt.getValue()).getId().toString());
                numbers.append(((MaterialInfo)this.materialPrompt.getValue()).getNumber());
                itemCollection.add(new FilterItemInfo("material", (Object)ids.toString(), CompareType.INCLUDE));
                itemCollection.add(new FilterItemInfo("materialNumber", (Object)numbers.toString().substring(0, numbers.toString().length() - 1)));
                itemCollection.add(new FilterItemInfo("materialName", (Object)((StorageOrgUnitInfo)this.materialPrompt.getValue()).getName(this.getLocale())));
            } else if (this.materialPrompt.getValue() instanceof LinkedHashSet) {
                set = (LinkedHashSet)this.materialPrompt.getValue();
                for (String id : set) {
                    ids.append(id + ";");
                }
                itemCollection.add(new FilterItemInfo("material", (Object)ids.toString().substring(0, ids.toString().length() - 1), CompareType.INCLUDE));
                itemCollection.add(new FilterItemInfo("materialNumber", (Object)this.materialNumber));
                itemCollection.add(new FilterItemInfo("materialName", (Object)this.materialName));
            } else if (this.materialPrompt.getValue() instanceof Object[]) {
                Object[] materials = (Object[])this.materialPrompt.getValue();
                if (materials.length > 0) {
                    for (int i = 0; i < materials.length; ++i) {
                        ids.append(((MaterialInfo)materials[i]).getId() + ";");
                        numbers.append(((MaterialInfo)materials[i]).getNumber() + ";");
                        names.append(((MaterialInfo)materials[i]).getName(this.getLocale()) + ";");
                    }
                }
                itemCollection.add(new FilterItemInfo("material", (Object)ids.toString().substring(0, ids.toString().length() - 1), CompareType.INCLUDE));
                itemCollection.add(new FilterItemInfo("materialNumber", (Object)numbers.toString().substring(0, numbers.toString().length() - 1)));
                itemCollection.add(new FilterItemInfo("materialName", (Object)names.toString().substring(0, names.toString().length() - 1)));
            }
        }
        if (this.lotNoField.getText() != null && this.lotNoField.getText().trim().length() > 0) {
            itemCollection.add(new FilterItemInfo("lotNo", (Object)this.lotNoField.getText(), CompareType.EQUALS));
        }
        if (this.startQueryDate.getValue() != null) {
            cal = Calendar.getInstance();
            cal.setTime((Date)this.startQueryDate.getValue());
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            itemCollection.add(new FilterItemInfo("startQueryDate", (Object)new Timestamp(cal.getTimeInMillis()), CompareType.GREATER_EQUALS));
        }
        if (this.endQueryDate.getValue() != null) {
            cal = Calendar.getInstance();
            cal.setTime((Date)this.endQueryDate.getValue());
            cal.set(10, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            itemCollection.add(new FilterItemInfo("endQueryDate", (Object)new Timestamp(cal.getTimeInMillis()), CompareType.LESS_EQUALS));
        }
        if (this.startNumber.getText() != null && this.startNumber.getText().trim().length() > 0) {
            itemCollection.add(new FilterItemInfo("startNumber", (Object)this.startNumber.getText().trim(), CompareType.GREATER_EQUALS));
        }
        if (this.endNumber.getText() != null && this.endNumber.getText().trim().length() > 0) {
            itemCollection.add(new FilterItemInfo("endNumber", (Object)this.endNumber.getText().trim(), CompareType.LESS_EQUALS));
        }
        if (this.cmbBizType.getSelectedItem() != null && (value = (bussinessType = (BizTypeEnum)((Object)this.cmbBizType.getSelectedItem())).getValue()) != -1) {
            itemCollection.add(new FilterItemInfo("bussinessType", (Object)new Integer(value)));
        }
        return filters;
    }

    public void clear() {
        this.storageUnitPrompt.setValue((Object)this.getCurrPermOrg());
        this.startQueryDate.setValue((Object)new Timestamp(System.currentTimeMillis() - 2592000L));
        this.endQueryDate.setValue((Object)new Timestamp(System.currentTimeMillis()));
        this.materialPrompt.setText(null);
        this.materialPrompt.setValue(null);
        this.lotNoField.setText(null);
        this.startNumber.setText(null);
        this.endNumber.setText(null);
        this.cmbBizType.setSelectedItem(null);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.storageUnitPrompt.setValue(null);
        this.startQueryDate.setValue(null);
        this.endQueryDate.setValue(null);
        try {
            FilterInfo filterInfo;
            if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    String p;
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    if ("storageOrgUnitID".equals(filterItemInfo.getPropertyName())) {
                        p = this.storageUnitPrompt.getText();
                        this.storageUnitPrompt.setValue(filterItemInfo.getCompareValue());
                        this.storageUnitPrompt.setText(p);
                        continue;
                    }
                    if ("storageOrgUnitNumber".equals(filterItemInfo.getPropertyName())) {
                        this.orgNumber = filterItemInfo.getCompareValue().toString();
                        continue;
                    }
                    if ("storageOrgUnitName".equals(filterItemInfo.getPropertyName())) {
                        this.orgName = (String)filterItemInfo.getCompareValue();
                        this.storageUnitPrompt.setText(this.orgName);
                        continue;
                    }
                    if ("material".equals(filterItemInfo.getPropertyName())) {
                        p = this.materialPrompt.getText();
                        this.materialPrompt.setValue(filterItemInfo.getCompareValue());
                        this.materialPrompt.setText(p);
                        continue;
                    }
                    if ("materialNumber".equals(filterItemInfo.getPropertyName())) {
                        this.materialNumber = filterItemInfo.getCompareValue().toString();
                        continue;
                    }
                    if ("materialName".equals(filterItemInfo.getPropertyName())) {
                        this.materialName = filterItemInfo.getCompareValue().toString();
                        this.materialPrompt.setText(this.materialName);
                        continue;
                    }
                    if ("lotNo".equals(filterItemInfo.getPropertyName())) {
                        this.lotNoField.setText(filterItemInfo.getCompareValue().toString());
                        continue;
                    }
                    if ("startNumber".equals(filterItemInfo.getPropertyName())) {
                        this.startNumber.setText(filterItemInfo.getCompareValue().toString());
                        continue;
                    }
                    if ("endNumber".equals(filterItemInfo.getPropertyName())) {
                        this.endNumber.setText(filterItemInfo.getCompareValue().toString());
                        continue;
                    }
                    if ("startQueryDate".equals(filterItemInfo.getPropertyName())) {
                        this.startQueryDate.setValue(filterItemInfo.getCompareValue());
                        continue;
                    }
                    if ("endQueryDate".equals(filterItemInfo.getPropertyName())) {
                        this.endQueryDate.setValue(filterItemInfo.getCompareValue());
                        continue;
                    }
                    if (!"bussinessType".equals(filterItemInfo.getPropertyName())) continue;
                    this.cmbBizType.setSelectedItem((Object)BizTypeEnum.getEnum((Integer)filterItemInfo.getCompareValue()));
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void initMaterialF7() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(10030), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(10050), CompareType.EQUALS));
        filterInfo.setMaskString("(#0 or #1)");
        viewInfo.setFilter(filterInfo);
        this.materialPrompt.setEntityViewInfo(viewInfo);
    }

    private void initProductionOrderF7() {
        Calendar cal;
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(1), CompareType.NOTEQUALS));
        if (this.startQueryDate.getValue() != null) {
            cal = Calendar.getInstance();
            cal.setTime((Date)this.startQueryDate.getValue());
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)new Timestamp(cal.getTimeInMillis()), CompareType.GREATER_EQUALS));
        }
        if (this.endQueryDate.getValue() != null) {
            cal = Calendar.getInstance();
            cal.setTime((Date)this.endQueryDate.getValue());
            cal.set(10, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)new Timestamp(cal.getTimeInMillis()), CompareType.LESS_EQUALS));
        }
        entityView.setFilter(filter);
        this.startNumber.setEntityViewInfo(entityView);
        this.endNumber.setEntityViewInfo(entityView);
    }
}

