/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.client.AbstractProductionPLS2OrdListUI;
import com.kingdee.eas.mm.control.client.ProductionPLS2OrdFilterUI;
import com.kingdee.eas.mm.planning.ProductionLineSchedulingFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProductionPLS2OrdListUI
extends AbstractProductionPLS2OrdListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductionPLS2OrdListUI.class);
    private ProductionPLS2OrdFilterUI conditionPanel = null;
    private static final Locale LOCALE = LocaleUtils.getLocale((String)"l2");
    private static final String TB_ID = "id";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_PRDLINENAME = "productLineName";
    private static final String TB_UNITNAME = "unitName";
    private static final String TB_QTY = "qty";
    private static final String TB_BEGINDATE = "beginDate";
    private static final String TB_ENDDATE = "endDate";
    private static final String TB_REQDATE = "requiredDate";
    private static final String TB_SLSORDER = "saleOrderNumber";
    private static final String TB_TRACENO = "traceNo";
    private static final String TB_DELAYTIME = "delayTime";
    private static final String TB_STATUS = "baseStatus";
    private static final String TB_REMARK = "remark";
    private static final int MOVE_ADDLINE = 1;
    private static final int MOVE_REVLINE = 2;
    private static final int MOVE_ADDALL = 3;
    private static final int MOVE_REVALL = 4;
    private static final String[] KDT_DATES = new String[]{"beginDate", "endDate", "requiredDate"};

    protected String getKeyFieldName() {
        return TB_ID;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "parent.storageOrgUnit.id";
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ProductionPLS2OrdFilterUI();
        }
        return this.conditionPanel;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProductionLineSchedulingFactory.getRemoteInstance();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        SorterItemCollection sortColls = viewInfo.getSorter();
        if (sortColls != null && !sortColls.isEmpty()) {
            SorterItemInfo sortInfo = null;
            Iterator it = sortColls.iterator();
            while (it.hasNext()) {
                sortInfo = (SorterItemInfo)it.next();
                if (sortInfo.getPropertyName().indexOf("number") <= -1 && sortInfo.getPropertyName().indexOf(".seq") <= -1) continue;
                it.remove();
            }
        }
        return exec;
    }

    protected boolean isAllowCommonMenu() {
        return false;
    }

    protected boolean isAllowOAMenu() {
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnUnAudit.setEnabled(false);
        this.btnUnAudit.setVisible(false);
        this.menuItemUnAudit.setEnabled(false);
        this.menuItemUnAudit.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.menuItemAuditResult.setEnabled(false);
        this.menuItemAuditResult.setVisible(false);
        this.tblDest.getSelectManager().setSelectMode(this.tblMain.getSelectManager().getSelectMode());
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        EditTableUtil.formatColDate((KDTable)this.tblDest, (String[])KDT_DATES);
        super.setReservationVisible(false);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblDest.removeRows();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.tblDest.removeRows();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.moveDataExecute(1);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.moveDataExecute(2);
    }

    @Override
    public void actionAddAllLine_actionPerformed(ActionEvent e) throws Exception {
        this.moveDataExecute(3);
    }

    @Override
    public void actionRemoveAllLine_actionPerformed(ActionEvent e) throws Exception {
        this.moveDataExecute(4);
    }

    @Override
    public void actionGenPrdOrd_actionPerformed(ActionEvent e) throws Exception {
        try {
            boolean result;
            int count = this.tblDest.getRowCount();
            if (count < 1) {
                MsgBox.showWarning((Component)((Object)this), (String)SCMUtils.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource", (String)"PlsGenOrd_UIErr", (Locale)LOCALE));
                return;
            }
            ArrayList<String> idLst = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                String id = this.tblDest.getCell(i, TB_ID).getValue().toString();
                if (StringUtils.isEmpty((String)id) || idLst.contains(id)) continue;
                idLst.add(id);
            }
            IObjectPK[] pks = null;
            if (!idLst.isEmpty()) {
                pks = new IObjectPK[idLst.size()];
                for (int i = 0; i < idLst.size(); ++i) {
                    pks[i] = new ObjectUuidPK(idLst.get(i).toString());
                }
            }
            if (result = ProductionOrderFactory.getRemoteInstance().plsGenPrdOrd(pks)) {
                this.getUIContext().put("GenPrdOrdResult", Boolean.TRUE);
                this.getUIWindow().close();
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
            if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                this.initMainRow();
            }
        }
    }

    private void moveDataExecute(int moveType) {
        int[] selectRows = null;
        if (moveType == 1) {
            selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        } else if (moveType == 2) {
            selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblDest);
        } else {
            int count = 0;
            if (moveType == 3) {
                count = this.tblMain.getRowCount();
            } else if (moveType == 4) {
                count = this.tblDest.getRowCount();
            }
            if (count > 0) {
                selectRows = new int[count];
                for (int i = 0; i < count; ++i) {
                    selectRows[i] = i;
                }
            }
        }
        if (selectRows != null && selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                this.moveDataBetweenTable(moveType, selectRows[i]);
            }
        }
    }

    private void moveDataBetweenTable(int moveType, int rowIndex) {
        if (moveType == 1 || moveType == 3) {
            IRow rowSrc = this.tblMain.getRow(rowIndex);
            if (rowSrc == null || rowSrc.getStyleAttributes().isHided()) {
                return;
            }
            IRow newRow = this.tblDest.addRow();
            List colList = this.tblMain.getColumns().getColumns();
            if (colList != null && !colList.isEmpty()) {
                for (int i = 0; i < colList.size(); ++i) {
                    String colName = ((KDTColumn)colList.get(i)).getKey();
                    newRow.getCell(colName).setValue(rowSrc.getCell(colName).getValue());
                }
            }
            if (this.tblDest.getRowCount() == 1) {
                this.tblDest.getSelectManager().select(0, 0);
            }
            rowSrc.getStyleAttributes().setHided(true);
        } else {
            String id = this.tblDest.getCell(rowIndex, TB_ID).getValue().toString();
            IRow mainRow = this.matchTblMainRow(id);
            if (mainRow != null) {
                mainRow.getStyleAttributes().setHided(false);
            }
            this.tblDest.removeRow(rowIndex);
        }
    }

    private IRow matchTblMainRow(String id) {
        IRow retVal = null;
        if (!StringUtils.isEmpty((String)id)) {
            for (int i = 0; i < this.tblMain.getRowCount() && !id.equals((retVal = this.tblMain.getRow(i)).getCell(TB_ID).getValue().toString()); ++i) {
                retVal = null;
            }
        }
        return retVal;
    }

    private void initMainRow() {
        int count = this.tblMain.getRowCount();
        int count2 = this.tblDest.getRowCount();
        if (count > 0 && count2 > 0) {
            block0: for (int i = 0; i < count; ++i) {
                String id = this.tblMain.getCell(i, TB_ID).getValue().toString();
                for (int j = 0; j < count2; ++j) {
                    String id2 = this.tblDest.getCell(j, TB_ID).getValue().toString();
                    if (!id.equals(id2)) continue;
                    this.tblMain.getRow(i).getStyleAttributes().setHided(true);
                    continue block0;
                }
            }
        }
    }
}

